<?php
	header('Access-Control-Allow-Origin: *');
	header('Access-Control-Allow-Headers: "Origin, X-Requested-With, Content-Type, Accept"');
	include 'datapacket.php';
	include 'TParams.class.php';
	
	$datapacket = new Datapacket();
	$TParams = new TParams();
	$datapacket->setHost($TParams->getHost($TParams->getDbSge()));

	class Ofx {
		
		private $ofxFile;
		
		public function __construct($ofxFile) {
			$this->ofxFile = $ofxFile;
		}
		
		/* Converte o arquivo OFX para XML*/
		public function getOfxAsXML() {
			$content = file_get_contents($this->ofxFile);
			$line = strpos($content, "<OFX>");
			$ofx = substr($content, $line - 1);
			$buffer = $ofx;
			$count = 0;
			while ($pos = strpos($buffer, '<')){
				$count++;
				$pos2 = strpos($buffer, '>');
				$element = substr($buffer, $pos + 1, $pos2 - $pos - 1);
				if (substr($element, 0, 1) == '/'){
					$sla[] = substr($element, 1);
				}else  {
					$als[] = $element;
				}
				$buffer = substr($buffer, $pos2 + 1);
			}
			$adif = array_diff($als, $sla);
			$adif = array_unique($adif);
			$ofxy = $ofx;
			foreach ($adif as $dif) {
				$dpos = 0;
				while ($dpos = strpos($ofxy, $dif, $dpos + 1)) {
					$npos = strpos($ofxy, '<', $dpos + 1);
					$ofxy = substr_replace($ofxy, "</$dif>\n<", $npos, 1);
					$dpos = $npos + strlen($element) + 3;
				}
			}
			$ofxy = str_replace('&', '', $ofxy);
			return $ofxy;
		}
		
		/*Retorna o Saldo da conta na data de exportação do extrato*/ 
		public function getBalance() {
			$xml = new SimpleXMLElement(utf8_encode($this->getOfxAsXML()));
			$balance = $xml->BANKMSGSRSV1->STMTTRNRS->STMTRS->LEDGERBAL->BALAMT;
			$dateOfBalance = $xml->BANKMSGSRSV1->STMTTRNRS->STMTRS->LEDGERBAL->DTASOF;
			$date = strtotime(substr($dateOfBalance, 0, 8));
			$dateToReturn = date('Y-m-d', $date);
			return Array('date' => $dateToReturn, 'balance' => $balance);
		}
		
		/*Retora um array de objetos com as transações     *      * DTPOSTED => Data da Transação     * TRNAMT   => Valor da Transação     * TRNTYPE  => Tipo da Transação (Débito ou Crédito)     * MEMO     => Descrição da transação     */    
		public function getTransactions() {       
			$xml = new SimpleXMLElement(utf8_encode($this->getOfxAsXML()));
			$transactions = $xml->BANKMSGSRSV1->STMTTRNRS->STMTRS->BANKTRANLIST->STMTTRN;
			return $transactions;    
		}
		
	}
	
	if( isset($_REQUEST["acao"]) && $_REQUEST["acao"]=="incluir" && isset($_FILES["fileOfx"]["tmp_name"]) ){
		
		$erro = false;
		$nomeArq = $_FILES["fileOfx"]["name"];
		// $nomeArq = "arquivo.ofx";
		$extensao = array_reverse(explode(".", $nomeArq));
		$nomeArq = $extensao[1];
		$extensao = strtolower($extensao[0]);

		$arrErro=array();
		if($extensao!="ofx"){
			$erro = true;
			$arrErro["erro"] = htmlentities("Arquivo '".$nomeArq."' inválido, somente são aceitos arquivos com a extensão .ofx");
			print_r(json_encode($arrErro));
			exit();
		}
		$arq = $nomeArq.".".$extensao;

		if($erro ==false){
			
			//upload local
			$uploaddir = $TParams->uploads.$TParams->getCodigo()."/ofx/";
			if(!is_dir($uploaddir)) @mkdir($uploaddir, 0777, true);
			@move_uploaded_file($_FILES['fileOfx']['tmp_name'], $uploaddir.$arq);
				
			$ofx = new Ofx($uploaddir.$arq);
			
			$lanctos = array("success"=>true, "conciliados"=>array(), "novos"=>array());
			
			foreach($ofx->getTransactions() as $t){
				$lan_valor = str_replace(",",".",$t->TRNAMT);
				$lan_valor = (float)$lan_valor;
				
				if(strstr((string)$t->TRNTYPE, "OTHER")==true){
					$lan_dc = ($lan_valor<0) ? 1 : 2;
				}else{
					$lan_dc = (strstr((string)$t->TRNTYPE, "CREDIT")==true) ? 2 : 1;
				}
				
				$lan_dtmov = substr($t->DTPOSTED,0,4)."-".substr($t->DTPOSTED,4,2)."-".substr($t->DTPOSTED,6,2)." 00:00:00";
				if($lan_valor<0) $lan_valor = $lan_valor * -1;
				$lan_valor = ( isset($lan_valor) && $lan_valor!=0) ? number_format($lan_valor, 2) : 0.00;
				$lan_historico = htmlentities((string)$t->MEMO);
				$lan_historico .= (isset($t->NAME) && $t->NAME!="") ? " - ".htmlentities((string)$t->NAME) : '';
				
				$filtro = '{"cod":"700588","params":[
					{"name":"cta_codigo","value":"'.$_REQUEST["cta_codigo"].'","type":"integer"},
					{"name":"lan_valor","value":"'.$lan_valor.'","type":"float"},
					{"name":"lan_dc","value":"'.$lan_dc.'","type":"integer"},
					{"name":"lan_dtmov","value":"'.$lan_dtmov.'","type":"string"}
				]}';
				$datapacket->add($filtro);
				$lan = $datapacket->open();
				$datapacket->clear();
				
				if($lan && $lan[0] && $lan[0]["lan_sequencia"]){
					array_push($lanctos["conciliados"], array(
						"lan_dtmov"=>$lan_dtmov,
						"lan_dc"=>$lan_dc,
						"lan_valor"=> $lan_valor,
						"lan_historico"=>htmlentities((string)$lan[0]["lan_historico"]),
						"lan_sequencia"=> (int)$lan[0]["lan_sequencia"]
					));
				}else{
					array_push($lanctos["novos"], array(
						"lan_dtmov"=>$lan_dtmov,
						"lan_dc"=>$lan_dc,
						"lan_valor"=> $lan_valor,
						"lan_historico"=>$lan_historico
					));
				}
			}
			print_r(json_encode($lanctos));
		}
		
	}
	
?>