<?php
	header('Access-Control-Allow-Origin: *');
	header('Access-Control-Allow-Headers: "Origin, X-Requested-With, Content-Type, Accept"');
	header('Content-Type: text/html; charset=utf-8');
	date_default_timezone_set("America/Sao_Paulo");
	
	include 'datapacket.php';
	include 'TParams.class.php';
	
	$datapacket = new Datapacket();
	$TParams = new TParams();
	$datapacket->setHost($TParams->getHost($TParams->getDbSge()));
	
	$company = $TParams->getCompany();
	
	function diffDate($d1, $d2){
		$timestamp1 = strtotime($d1);
		$timestamp2 = strtotime($d2);
		$hour = abs($timestamp2 - $timestamp1)/(60*60);
		return $hour;
	}
	
	if($company->cfg_nfentrada && $company->cfg_nfentrada==1 && (!$company->cfg_entradadata || diffDate($company->cfg_entradadata, date("Y-m-d H:i:s"))>=12) ){
		
		$filtro = '{"cod":"700654","params":[
			{"name":"cfg_entradadata","value":"'.date("Y-m-d H:i:s").'","type":"string"},
			{"name":"emp_codigo","value":"'.$company->emp_codigo.'","type":"string"}
		]}';
		$datapacket->add($filtro);
	
		include_once "phpnfe/libs/NFe/ToolsNFePHP.class.php";
			
		$tools = new ToolsNFePHP;
		
		if(!is_dir($TParams->uploads.$_REQUEST["emp_codigo"].'/nfe//importados/')){
			@mkdir($TParams->uploads.$_REQUEST["emp_codigo"].'/nfe/importados/',0777);
		}
		if( !isset($company->emp_nfensu) || $company->emp_nfensu=="" ) $company->emp_nfensu=0;
		$ultNSU = $company->emp_nfensu;
		$maxNSU = $ultNSU;
		$loopLimit = 5;
		$iCount = 0;

		while($ultNSU <= $maxNSU){
			
			$iCount++;
			if ($iCount >= $loopLimit) {
				break;
			}
	
			//buscar lista de notas emitidas para o CNPJ
			$ret = $tools->getDistDFe(1, 'AN', $ultNSU, $maxNSU);
			$lista = simplexml_load_string(str_replace("soap:", "", $ret));
			echo "<pre>";
			print_r($lista);
			
			$ultNSU = (int) $lista->Body->nfeDistDFeInteresseResponse->nfeDistDFeInteresseResult->retDistDFeInt->ultNSU;
			$maxNSU = (int) $lista->Body->nfeDistDFeInteresseResponse->nfeDistDFeInteresseResult->retDistDFeInt->maxNSU;			
			
			if( $lista->Body->nfeDistDFeInteresseResponse->nfeDistDFeInteresseResult->retDistDFeInt->loteDistDFeInt ){

				$lista = $lista->Body->nfeDistDFeInteresseResponse->nfeDistDFeInteresseResult->retDistDFeInt->loteDistDFeInt;
				
				//percorre lista de notas
				if( $lista && $lista->{"docZip"} ){
					foreach($lista->{"docZip"} as $l){
						$l = (array)$l;
						//descompacta arquivo gzip
						$xml = simplexml_load_string(gzdecode(base64_decode($l[0])));
						//verifica se há informação de nf-e autorizada
						if( ($xml->dhEmi && $xml->nProt) || ($xml->NFe && $xml->NFe->infNFe) ){
							//verifica se a nf-e esta com seu xml completo, se estiver importa no sistema
							if($xml->NFe && $xml->NFe->infNFe && $xml->NFe->infNFe['Id']){
								print_r($xml);
								
								$chave = (array) $xml->NFe->infNFe['Id'];
								$chave = substr($chave[0], 3);
								$arqNome = $TParams->uploads.$company->emp_codigo.'/nfe/importados/'.$chave.".xml";
								$arq = fopen($arqNome, "w+");

								fwrite($arq, $xml->asXML());
								fclose($arq);
								chmod($arqNome, 0777);
								//requisicao post para importação de XML
								$fields = array(
									'p' => substr(base64_encode($company->emp_codigo), 0, 1)."2".substr(base64_encode($company->emp_codigo), 1),
									'tipo' => 'entrada',
									'inativos' => ($company->cfg_entradaprod==1) ? 'sim' : 'nao',
									'ref_id' => '2',
									'parcelas' => ($company->cfg_entradafin==1) ? 'sim' : 'nao',
									'fileXml[]' => new CURLFile($arqNome)
								);
								//abrir conexao
								$ch = curl_init();
								curl_setopt($ch,CURLOPT_URL, $TParams->HostClient."/php/importarXml.php");
								curl_setopt($ch,CURLOPT_POST, true);
								curl_setopt($ch,CURLOPT_SAFE_UPLOAD, false);
								curl_setopt($ch,CURLOPT_POSTFIELDS, $fields);
								curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
								//executa POST
								$result = curl_exec($ch);
								//fechar conexao
								curl_close($ch);
								print_r($result);
								
							//caso nao esteja executa a manifestação do destinatario (ciencia da operação)
							}else{
								if( $res = $tools->manifDest($xml->chNFe, '210210', '', 1, $res) ){
									
									$xml2 = simplexml_load_string(str_replace("soap:", "", $res));
									
									if($xml2->Body->nfeRecepcaoEventoNFResult->retEnvEvento->retEvento->infEvento->cStat){
										
										$cStat = (array) $xml2->Body->nfeRecepcaoEventoNFResult->retEnvEvento->retEvento->infEvento->cStat;
										$xMotivo = (array) $xml2->Body->nfeRecepcaoEventoNFResult->retEnvEvento->retEvento->infEvento->xMotivo;
										$nProt = (array) $xml2->Body->nfeRecepcaoEventoNFResult->retEnvEvento->retEvento->infEvento->nProt;
										if($cStat[0]=='135'){

											echo "ok";
								
										}else{
											echo $xMotivo[0];
										}
										
									}else{
										print_r($xml2);
									}
									
								}
								print_r($xml);
							}
						}
					}
				}
				
				
			}
			if ($ultNSU == $maxNSU) {
			   break;
			}
			sleep(2);
		}
		
		if($ultNSU && $ultNSU>0){
			$filtro = '{"cod":"600009","params":[
				{"name":"emp_nfensu","value":"'.$ultNSU.'","type":"integer"},
				{"name":"emp_codigo","value":"'.$company->emp_codigo.'","type":"string"}
			]}';
			$datapacket->add($filtro);
			$datapacket->open();
			$datapacket->clear();
		}
	
	}else{
		exit("rotina não está pronta para execução!");
	}
?>