<?php

	header('Access-Control-Allow-Origin: *');
	header('Access-Control-Allow-Headers: "Origin, X-Requested-With, Content-Type, Accept"');
	header('Content-Type: text/html; charset=utf-8');
	date_default_timezone_set("America/Sao_Paulo");
	
	include 'datapacket.php';
	include 'TParams.class.php';
	
	$datapacket = new Datapacket();
	$TParams = new TParams();
	$datapacket->setHost($TParams->getHost($TParams->getDbSge()));
	
	$company = $TParams->getCompany();
	
	
	//cancelar NF de Entrada, pedido ou Venda Consignada
	if( isset($_POST["acao"]) && $_POST["acao"]=="cancelar" ){
		
		if( isset($_POST["not_tipo"]) && ($_POST["not_tipo"]==2 || $_POST["not_tipo"]==3) ){
			//webhook
			$filtroW = '{"cod":"600022","params":[
				{"name":"emp_codigo","value":"'.$TParams->getCodigo().'","type":"string"},
				{"name":"web_modulo","value":"pedido","type":"string"},
				{"name":"web_evento","value":"cancelarPedido","type":"string"}
			]}';
			$datapacket->setHost($TParams->getHost("empresas"));
			$datapacket->add($filtroW);
			$web = $datapacket->open();
			$datapacket->clear();
			if( isset($web) && count($web)>0 && isset($web[0]["web_url"]) ){
				include_once "webhook.php";
			}
			$datapacket->setHost($TParams->getHost($TParams->getDbSge()));
		}
		
		//atualiza status
		$filtroAtualiza = '{"cod":"700139","params":[
			{"name":"not_dtcancdesc","value":"'.date("Y-m-d H:i:s").'","type":"string"},
			{"name":"not_codigo","value":"'.$_POST["not_codigo"].'","type":"string"}
		]}';
		$datapacket->add($filtroAtualiza);
		
		$produtos = json_decode($_POST["produtos"]);
		for($i = 0; $i<count($produtos); $i++){
			if(!isset($produtos[$i][33]) || $produtos[$i][33]=="") $produtos[$i][33]="99999";
			if(!isset($produtos[$i][42]) || $produtos[$i][42]=="") $produtos[$i][42]="99999";
			
			//conversao de unidades
			if(isset($produtos[$i][35]) && $produtos[$i][35]!=""){
				$datapacket2 = new Datapacket();
				$filtro = '{"cod":"700565","params":[
					{"name":"db","value":"'.$TParams->getDb().'","type":"other"},
					{"name":"uni_codigo","value":"'.$produtos[$i][35].'","type":"string"},
					{"name":"ref_codigo","value":"'.$produtos[$i][0].'","type":"integer"}
				]}';
				$datapacket2->add($filtro);
				$conv = $datapacket2->open();
				$datapacket2->clear();
			}
			$stk_seq = substr(str_replace(array(","," ","."),array("","",""),microtime()), 0, 8);
			$stk_qde = $produtos[$i][2];
			
			if( isset($conv) && isset($conv[0]) && isset($conv[0]["ref_conv_qtde"]) ) $stk_qde = number_format($stk_qde/ $conv[0]["ref_conv_qtde"],2,'.','');
			$stk_qde = ($stk_qde>0) ? $stk_qde : $produtos[$i][2];
			
			$stk_qde = ( isset($_POST["not_tipo"]) && $_POST["not_tipo"]==9 ) ? "-".$stk_qde : $stk_qde;
			
			$filtrostk = '{"cod":"700111","params":[
				{"name":"db","value":"'.$TParams->getDb().'","type":"other"},
				{"name":"emp_codigo","value":"'.$TParams->getCodigo().'","type":"string"},
				{"name":"loc_codigo","value":"'.$produtos[$i][33].'","type":"string"},
				{"name":"lot_codigo","value":"'.$produtos[$i][42].'","type":"string"},
				{"name":"ref_codigo","value":"'.$produtos[$i][0].'","type":"integer"},
				{"name":"ser_codigo","value":"'.$_POST['not_serie'].'","type":"string"},
				{"name":"stk_data","value":"'.date("Y-m-d H:i:s").'","type":"string"},
				{"name":"stk_seq","value":"'.$stk_seq.'","type":"integer"},
				{"name":"stk_qde","value":"'.$stk_qde.'","type":"float"},
				{"name":"stk_tipo","value":"3","type":"integer"},
				{"name":"not_codigo","value":"'.$_POST['not_codigo'].'","type":"string"}
			]}';
			$datapacket->add($filtrostk);
			
			//estoques dos kits (composições)
			$datapacketkit = new Datapacket();
			$filtrostkkit = '{"cod":"700644","params":[
				{"name":"db","value":"'.$TParams->getDb().'","type":"other"},
				{"name":"ref_kit","value":"'.$produtos[$i][0].'","type":"integer"}
			]}';
			$datapacketkit->add($filtrostkkit);
			$kits = $datapacketkit->open();
			$datapacketkit->clear();
			if( isset($kits) && isset($kits[0]) && isset($kits[0]["ref_qtde"]) && $kits[0]["ref_qtde"]>0 ){
				foreach($kits as $kit){
					$stk_seq = substr(str_replace(array(","," ","."),array("","",""),microtime()), 0, 8);
					$filtrostk = '{"cod":"700111","params":[
						{"name":"db","value":"'.$TParams->getDb().'","type":"other"},
						{"name":"emp_codigo","value":"'.$TParams->getCodigo().'","type":"string"},
						{"name":"loc_codigo","value":"'.$produtos[$i][33].'","type":"string"},
						{"name":"lot_codigo","value":"'.$produtos[$i][42].'","type":"string"},
						{"name":"ref_codigo","value":"'.$kit["ref_codigo"].'","type":"integer"},
						{"name":"ser_codigo","value":"'.$_POST['not_serie'].'","type":"string"},
						{"name":"stk_data","value":"'.date("Y-m-d H:i:s").'","type":"string"},
						{"name":"stk_seq","value":"'.$stk_seq.'","type":"integer"},
						{"name":"stk_qde","value":"'.$kit["ref_qtde"].'","type":"float"},
						{"name":"stk_tipo","value":"3","type":"integer"},
						{"name":"not_codigo","value":"'.$_POST['not_codigo'].'","type":"string"}
					]}';
					$datapacket->add($filtrostk);
				}
			}
				
		}
		//log cancelamento pedido
		$filtrolog = '{"cod":"700103","params":[
			{"name":"log_tipo","value":"5","type":"integer"},
			{"name":"log_nro","value":"'.$_POST["not_codigo"].'","type":"string"},
			{"name":"log_serie","value":"'.$_POST["not_serie"].'","type":"string"},';
		$filtrolog.= ( isset($_POST["usu_login"]) && $_POST["usu_login"]!="" ) ? '{"name":"log_usu_login","value":"'.$_POST["usu_login"].'","type":"string"},' : '{"name":"log_usu_login","value":"NULL","type":"other"},';
		$filtrolog.= '{"name":"log_acao_cod","value":"5","type":"integer"},
			{"name":"log_acao_descr","value":"Cancelamento","type":"string"},
			{"name":"log_data","value":"","type":"string"},
			{"name":"log_protocolo","value":"NULL","type":"other"},
			{"name":"log_ret","value":"NULL","type":"other"},
			{"name":"log_outro","value":"'.base64_encode("Pedido Cancelado pelo usuário").'","type":"string"}
		]}';
		//cancelamento docto
		$filtroNotaDocto = '{"cod":"501011","params":[
			{"name":"not_codigo","value":"'.$_POST["not_codigo"].'","type":"string"}
		]}';
		$datapacket->add($filtrolog);
		$datapacket->add($filtroNotaDocto);
	
	//verificar NF-e com status AGUARDANDO e atualizar com os dados da transmissão
	}elseif( isset($_REQUEST["acao"]) && $_REQUEST["acao"]=="verificarNota" ){
		
		if(isset($_REQUEST['not_numero'])){ $not_numero=$_REQUEST['not_numero']; } else { $not_numero=0; }
		if(isset($_REQUEST['ser_codigo'])){ $ser_codigo=$_REQUEST['ser_codigo']; } else { $ser_codigo=''; }
		if(isset($_REQUEST['cad_codigo'])){ $cad_codigo=$_REQUEST['cad_codigo']; } else { $cad_codigo=''; }
		
		$filtro = '{"cod":"500920","params":[
			{"name":"not_numero","value":"'.$not_numero.'","type":"integer"},
			{"name":"ser_codigo","value":"'.$ser_codigo.'","type":"string"},
			{"name":"cad_codigo","value":"'.$cad_codigo.'","type":"string"}
		]}';
		
		$datapacket->add($filtro);
		$ret = $datapacket->open();
		echo json_encode($ret);
		exit();
	
	//Marcar pedidos para serem automaticamente convertidos em nota em proximo login
	}elseif( isset($_REQUEST["acao"]) && $_REQUEST["acao"]=="nfeauto" && isset($_REQUEST["not_codigo"]) ){
		
		$not_codigo = json_decode(base64_decode($_REQUEST['not_codigo']));
		$not_codigo = implode(",", $not_codigo);
		
		$filtro = '{"cod":"700668","params":[
			{"name":"not_codigo","value":"'.$not_codigo.'","type":"other"}
		]}';
		
		$datapacket->add($filtro);
		$datapacket->open();
		exit();
		
	}elseif( isset($_REQUEST["acao"]) && $_REQUEST["acao"]=="consultar" ){

		$filtroBusca = '{"cod":"700151","params":[]}';
		$datapacket->add($filtroBusca);
		$ret = $datapacket->open();
		
		if(is_array($ret)){
			
			$fields_string="";
			
			foreach($ret as $not){
				
				$fields = array(
					'p' => $_REQUEST["p"],
					'emp_codigo' => $_REQUEST["emp_codigo"],
					'not_codigo' => $not["not_codigo"],
					'facil_novo' => true,
					'acao' => 'consultar'
				);
				
				print_r($fields);

				//url-ify os dados para o POST
				foreach($fields as $key=>$value) { $fields_string .= $key.'='.$value.'&'; }
				rtrim($fields_string, '&');

				//abrir conexao
				$ch = curl_init();

				//define url, numero de variaveis POST e dados POST
				curl_setopt($ch,CURLOPT_URL, $_SERVER["HTTP_HOST"].substr($_SERVER["SCRIPT_NAME"], 0, -11)."phpnfe/web/NFe.php");
				curl_setopt($ch,CURLOPT_POST, count($fields));
				curl_setopt($ch,CURLOPT_POSTFIELDS, $fields_string);

				//executa POST
				$result = curl_exec($ch);

				//fechar conexao
				curl_close($ch);
				
			}
			
		}
		
		exit();
		
	}elseif( isset($_REQUEST["acao"]) && $_REQUEST["acao"]=="manifestar" ){
		
		include_once "phpnfe/libs/NFe/ToolsNFePHP.class.php";
		
		$tools = new ToolsNFePHP;
		

		$just = ( isset($_POST["just"]) && $_POST["just"]!="" ) ? base64_decode($_POST["just"]) : "";
		
		if( $res = $tools->manifDest($_POST["chave"], $_POST["evento"], $just, 1, $res) ){
			
			if(!is_dir($TParams->uploads.$_REQUEST["emp_codigo"].'/nfe/importados/')){
				@mkdir($TParams->uploads.$_REQUEST["emp_codigo"].'/nfe/importados/',0777);
			}
			
			$xml = simplexml_load_string(str_replace("soap:", "", $res));
			
			if($xml->Body->nfeRecepcaoEventoNFResult->retEnvEvento->retEvento->infEvento->cStat){
				
				$cStat = (array) $xml->Body->nfeRecepcaoEventoNFResult->retEnvEvento->retEvento->infEvento->cStat;
				$xMotivo = (array) $xml->Body->nfeRecepcaoEventoNFResult->retEnvEvento->retEvento->infEvento->xMotivo;
				$nProt = (array) $xml->Body->nfeRecepcaoEventoNFResult->retEnvEvento->retEvento->infEvento->nProt;
				if($cStat[0]=='135'){
					
					$arq = fopen($TParams->uploads.$company->emp_codigo.'/nfe/importados/'.$_POST["chave"]."-manif.xml", "w+");
					fwrite($arq, $res);
					fclose($arq);
					
					if($_POST["evento"]=="210210"){
						$not_entrnfe = 0;
					}elseif($_POST["evento"]=="210200"){
						$not_entrnfe = 1;
					}elseif($_POST["evento"]=="210220"){
						$not_entrnfe = 2;
					}elseif($_POST["evento"]=="210240"){
						$not_entrnfe = 3;
					}
					
					$filtro = '{"cod":"700655","params":[
						{"name":"db","value":"'.$company->emp_db_sge.'","type":"other"},
						{"name":"not_entrnfe","value":"'.$not_entrnfe.'","type":"integer"},
						{"name":"not_key_nfe","value":"'.$_POST["chave"].'","type":"string"}
					]}';
					$datapacket->add($filtro);
					$datapacket->open();
		
					echo "ok";
		
				}else{
					echo $xMotivo[0];
				}
				
			}else{
				print_r($xml);
			}
			
		}else{
			if( strstr($tools->errMsg, "O Lote foi rejeitado : 573 - Rejeicao: Duplicidade de evento") ){
				echo "ja";
			}else{
				echo $tools->errMsg;
			}
		}
	
		exit();
		
	}elseif( isset($_REQUEST["acao"]) && $_REQUEST["acao"]=="download" ){
		
		include_once "phpnfe/libs/NFe/ToolsNFePHP.class.php";
		
		$tools = new ToolsNFePHP;
		
		if(!is_dir($TParams->uploads.$_REQUEST["emp_codigo"].'/nfe//importados/')){
			@mkdir($TParams->uploads.$_REQUEST["emp_codigo"].'/nfe/importados/',0777);
		}
		if( !isset($company->emp_nfensu) ) $company->emp_nfensu=50;
		$nsu = $company->emp_nfensu;
		// while($nsu>=($company->emp_nfensu-50)){
		
			//buscar lista de notas emitidas para o CNPJ
			// $ret = $tools->getDistDFe(1, 'AN', $nsu, $company->emp_nfensu);
			$ret = $tools->getDistDFe(1, 'AN', '2063', '2064');
			// $ret = $tools->getDistDFe(1, 'AN', '1990', '2064');
			$lista = simplexml_load_string(str_replace("soap:", "", $ret));
			echo "<pre>";
			print_r($lista);
			//atualizar ultimo NSU
			/*
			if($nsu==$company->emp_nfensu){
				$emp_nfensu = (int) $lista->Body->nfeDistDFeInteresseResponse->nfeDistDFeInteresseResult->retDistDFeInt->ultNSU;
				$maxnsu = (int) $lista->Body->nfeDistDFeInteresseResponse->nfeDistDFeInteresseResult->retDistDFeInt->maxNSU;
				if(isset($emp_nfensu) && $emp_nfensu>0 ){
					$filtro = '{"cod":"600009","params":[
						{"name":"emp_nfensu","value":"'.$maxnsu.'","type":"integer"},
						{"name":"emp_codigo","value":"'.$company->emp_codigo.'","type":"string"}
					]}';
					$datapacket->add($filtro);
					$datapacket->open();
					$datapacket->clear();
				}
			}
			*/
			
			if( $lista->Body->nfeDistDFeInteresseResponse->nfeDistDFeInteresseResult->retDistDFeInt->loteDistDFeInt ){

				$lista = $lista->Body->nfeDistDFeInteresseResponse->nfeDistDFeInteresseResult->retDistDFeInt->loteDistDFeInt;
				
				//percorre lista para buscar a nota desejada
				
				if( $lista && $lista->{"docZip"} ){
					foreach($lista->{"docZip"} as $l){
						$l = (array)$l;
						//descompacta arquivo gzip
						$xml = simplexml_load_string(gzdecode(base64_decode($l[0])));
						
						if( ($xml->dhEmi && $xml->nProt) || ($xml->NFe && $xml->NFe->infNFe) ){
							if($xml->NFe && $xml->NFe->infNFe && $xml->NFe->infNFe['Id']){
								print_r($xml);
								/*
								$chave = (array) $xml->NFe->infNFe['Id'];
								$chave = substr($chave[0], 3);
								$arqNome = $TParams->uploads.$company->emp_codigo.'/nfe/importados/'.$chave.".xml";
								$arq = fopen($arqNome, "w+");

								fwrite($arq, $xml->asXML());
								fclose($arq);
								chmod($arqNome, 0777);
								//requisicao post para importação de XML
								$fields = array(
									'p' => substr(base64_encode($company->emp_codigo), 0, 1)."2".substr(base64_encode($company->emp_codigo), 1),
									'tipo' => 'saida',
									'inativos' => 'sim',
									'ref_id' => '1',
									'fileXml' => new CURLFile($arqNome)
								);
								//abrir conexao
								$ch = curl_init();
								curl_setopt($ch,CURLOPT_URL, $TParams->HostClient."/php/importarXml.php");
								curl_setopt($ch,CURLOPT_POST, true);
								curl_setopt($ch,CURLOPT_SAFE_UPLOAD, false);
								curl_setopt($ch,CURLOPT_POSTFIELDS, $fields);
								curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
								//executa POST
								$result = curl_exec($ch);
								//fechar conexao
								curl_close($ch);
								//resultado leitura XML em forma de objeto para ser importado pela tela de NF-e
								echo $result;
								exit();
								*/
								
							}else{
								if( $res = $tools->manifDest($xml->chNFe, '210210', '', 1, $res) ){
									
									$xml2 = simplexml_load_string(str_replace("soap:", "", $res));
									
									if($xml2->Body->nfeRecepcaoEventoNFResult->retEnvEvento->retEvento->infEvento->cStat){
										
										$cStat = (array) $xml2->Body->nfeRecepcaoEventoNFResult->retEnvEvento->retEvento->infEvento->cStat;
										$xMotivo = (array) $xml2->Body->nfeRecepcaoEventoNFResult->retEnvEvento->retEvento->infEvento->xMotivo;
										$nProt = (array) $xml2->Body->nfeRecepcaoEventoNFResult->retEnvEvento->retEvento->infEvento->nProt;
										if($cStat[0]=='135'){

											echo "ok";
								
										}else{
											echo $xMotivo[0];
										}
										
									}else{
										print_r($xml2);
									}
									
								}
								print_r($xml);
							}
						}
						//verifica se chave existe
						/*
						if($xml->NFe && $xml->NFe->infNFe && $xml->NFe->infNFe['Id']){
							$chave = (array) $xml->NFe->infNFe['Id'];
							$chave = substr($chave[0], 3);
							// echo $chave."<br>";
							//verifica se chave é igual a da nota informada
							
							if($chave == $_REQUEST["chave"]){
								$arqNome = $TParams->uploads.$company->emp_codigo.'/nfe/importados/'.$chave.".xml";
								$arq = fopen($arqNome, "w+");

								fwrite($arq, $xml->asXML());
								fclose($arq);
								chmod($arqNome, 0777);
								//requisicao post para importação de XML
								$fields = array(
									'p' => substr(base64_encode($company->emp_codigo), 0, 1)."2".substr(base64_encode($company->emp_codigo), 1),
									'fileXml' => new CURLFile($arqNome)
								);
								//abrir conexao
								$ch = curl_init();
								curl_setopt($ch,CURLOPT_URL, $TParams->HostClient."/php/importarXml.php");
								curl_setopt($ch,CURLOPT_POST, true);
								curl_setopt($ch,CURLOPT_SAFE_UPLOAD, false);
								curl_setopt($ch,CURLOPT_POSTFIELDS, $fields);
								curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
								//executa POST
								$result = curl_exec($ch);
								//fechar conexao
								curl_close($ch);
								//resultado leitura XML em forma de objeto para ser importado pela tela de NF-e
								echo base64_encode($result);
								break;
								// exit($chave);
								exit();
							}
							
						}
						*/
					}
				}
				
				
			}
			// $nsu--;
		// }
		/*
		if(!isset($result) && $company->emp_nfensu==$maxnsu ){
			$filtro = '{"cod":"600009","params":[
				{"name":"emp_nfensu","value":"'.($maxnsu-50).'","type":"integer"},
				{"name":"emp_codigo","value":"'.$company->emp_codigo.'","type":"string"}
			]}';
			$datapacket->add($filtro);
			$datapacket->open();
			$datapacket->clear();
			echo "Não foi encontrada uma NF-e recente com a chave informada disponivel para download. Por favor, efetue uma nova tentativa em alguns minutos";
		}
		exit();
		*/
		exit("abc");
		
	} elseif( isset($_REQUEST["acao"]) && $_REQUEST["acao"]=="email" ){
		
		setlocale (LC_TIME, 'pt_BR');
		$fields = array(
			'p' => $_REQUEST["p"],
			'email' => true,
			'not_codigo' => $_POST["not_codigo"]
		);
		$ch = curl_init();
		curl_setopt($ch,CURLOPT_URL, $TParams->HostClient."/rel/pedidoLayout0.php");
		curl_setopt($ch,CURLOPT_POST, true);
		curl_setopt($ch,CURLOPT_RETURNTRANSFER, true);
		curl_setopt($ch,CURLOPT_POSTFIELDS, $fields);
		$result = curl_exec($ch);
		curl_close($ch);
		
		$msg_remetente = ($company->{'emp_email'} && $company->{'emp_email'}!="") ? $company->{'emp_email'} : $company->{'emp_emailremetente'};
		$msg_assunto = "Pedido Nº ".$_POST["not_numero"];
		$msg_destinatario = str_replace("\"", "", base64_decode($_REQUEST["email"]));
		$msg_anexo = base64_encode("[{\"descricao\" : \"Pedido Nº ".$_POST["not_numero"]."\", \"arquivo\" : \"".$result.''."\" }]");
		
		//registro da mensagem no sistema
		$filtro = '{"cod":"700321","params":[
			{"name":"msg_codigo","value":"","type":"string"},
			{"name":"msg_tipo","value":"1","type":"integer"},
			{"name":"men_codigo","value":"NULL","type":"integer"},
			{"name":"msg_remetente","value":"'.$msg_remetente.'","type":"string"},
			{"name":"msg_destinatario","value":"'.$msg_destinatario.'","type":"string"},
			{"name":"cad_codigo","value":"'.$_POST["cad_codigo"].'","type":"string"},
			{"name":"msg_assunto","value":"'.$msg_assunto.'","type":"string"},
			{"name":"msg_conteudo","value":"","type":"string"},
			{"name":"msg_data","value":"'.date("Y-m-d H:i:s").'","type":"string"},
			{"name":"msg_dtenvio","value":"'.date("Y-m-d H:i:s").'","type":"string"},
			{"name":"msg_status","value":"0","type":"integer"},
			{"name":"msg_anexo","value":"'.$msg_anexo.'","type":"string"}
		]}';
		
		$datapacket->clear();
		$datapacket->add($filtro);
		$ret = $datapacket->open(false, true);
		
		if($ret){
			//enviar a mensagem
			$_REQUEST["acao"] = "enviar";
			$_REQUEST["msg_codigo"] = $ret;
			include_once "./mensagem.php";
		}
		exit();
		
	}elseif( isset($_REQUEST["acao"]) && $_REQUEST["acao"]=="sms" ){
		
		setlocale (LC_TIME, 'pt_BR');
		$fields = array(
			'p' => $_REQUEST["p"],
			'email' => true,
			'not_codigo' => $_POST["not_codigo"]
		);
		$ch = curl_init();
		curl_setopt($ch,CURLOPT_URL, $TParams->HostClient."/rel/pedidoLayout0.php");
		curl_setopt($ch,CURLOPT_POST, true);
		curl_setopt($ch,CURLOPT_RETURNTRANSFER, true);
		curl_setopt($ch,CURLOPT_POSTFIELDS, $fields);
		$result = curl_exec($ch);
		curl_close($ch);
		
		$msg_remetente = '';
		$msg_assunto = '';
		$msg_destinatario = $_REQUEST["sms"];
		$msg_anexo = base64_encode("[{\"descricao\" : \"Acesse seu Pedido N ".$_POST["not_numero"]."\", \"arquivo\" : \"".$result.''."\" }]");
		
		//registro da mensagem no sistema
		$filtro = '{"cod":"700321","params":[
			{"name":"msg_codigo","value":"","type":"string"},
			{"name":"msg_tipo","value":"2","type":"integer"},
			{"name":"men_codigo","value":"25","type":"integer"},
			{"name":"msg_remetente","value":"'.$msg_remetente.'","type":"string"},
			{"name":"msg_destinatario","value":"'.$msg_destinatario.'","type":"string"},
			{"name":"cad_codigo","value":"'.$_POST["cad_codigo"].'","type":"string"},
			{"name":"msg_assunto","value":"'.$msg_assunto.'","type":"string"},
			{"name":"msg_conteudo","value":"'.base64_encode('Prezado cliente, {{anexo}}: {{link}}').'","type":"string"},
			{"name":"msg_data","value":"'.date("Y-m-d H:i:s").'","type":"string"},
			{"name":"msg_dtenvio","value":"'.date("Y-m-d H:i:s").'","type":"string"},
			{"name":"msg_status","value":"0","type":"integer"},
			{"name":"msg_anexo","value":"'.$msg_anexo.'","type":"string"}
		]}';
		
		$datapacket->clear();
		$datapacket->add($filtro);
		$ret = $datapacket->open(false, true);
		
		if($ret){
			//enviar a mensagem
			$_REQUEST["acao"] = "enviar";
			$_REQUEST["msg_codigo"] = $ret;
			include_once "./mensagem.php";
		}
		exit();
		
	}elseif( isset($_REQUEST["acao"]) && $_REQUEST["acao"]=="whatsapp" ){
		
		$fields = array(
			'p' => $_REQUEST["p"],
			'email' => true,
			'not_codigo' => $_POST["not_codigo"]
		);
		$ch = curl_init();
		curl_setopt($ch,CURLOPT_URL, $TParams->HostClient."/rel/pedidoLayout0.php");
		curl_setopt($ch,CURLOPT_POST, true);
		curl_setopt($ch,CURLOPT_RETURNTRANSFER, true);
		curl_setopt($ch,CURLOPT_POSTFIELDS, $fields);
		$result = curl_exec($ch);
		curl_close($ch);
		
		$msg_remetente = '';
		$msg_assunto = '';
		$msg_destinatario = $_REQUEST["whatsapp"];
		$msg_anexo = base64_encode("[{\"descricao\" : \"Acesse seu Pedido N ".$_POST["not_numero"]."\", \"arquivo\" : \"".$result.''."\" }]");
		
		//registro da mensagem no sistema
		$filtro = '{"cod":"700321","params":[
			{"name":"msg_codigo","value":"","type":"string"},
			{"name":"msg_tipo","value":"3","type":"integer"},
			{"name":"men_codigo","value":"25","type":"integer"},
			{"name":"msg_remetente","value":"'.$msg_remetente.'","type":"string"},
			{"name":"msg_destinatario","value":"'.$msg_destinatario.'","type":"string"},
			{"name":"cad_codigo","value":"'.$_POST["cad_codigo"].'","type":"string"},
			{"name":"msg_assunto","value":"'.$msg_assunto.'","type":"string"},
			{"name":"msg_conteudo","value":"'.base64_encode('Prezado cliente, {{anexo}}: {{link}}').'","type":"string"},
			{"name":"msg_data","value":"'.date("Y-m-d H:i:s").'","type":"string"},
			{"name":"msg_dtenvio","value":"'.date("Y-m-d H:i:s").'","type":"string"},
			{"name":"msg_status","value":"0","type":"integer"},
			{"name":"msg_anexo","value":"'.$msg_anexo.'","type":"string"}
		]}';
		
		$datapacket->clear();
		$datapacket->add($filtro);
		$ret = $datapacket->open(false, true);
		
		if($ret){
			//enviar a mensagem
			$_REQUEST["acao"] = "enviar";
			$_REQUEST["msg_codigo"] = $ret;
			include_once "./mensagem.php";
		}
		exit();
		
	} elseif( isset($_REQUEST["acao"]) && $_REQUEST["acao"]=="ecf" ){
		
		if(isset($_POST["not_codigo"])){
			
			$datapacket->setHost($TParams->getHost($company->emp_db_sge));
			
			$filtro = '{"cod":"700002","params":[
				{"name":"not_codigo","value":"'.$_POST["not_codigo"].'","type":"string"},
				{"name":"db","value":"'.$company->emp_db_comum.'","type":"other"}
			]}';
			//pega dados da nfe
			$datapacket->add($filtro);
			$nota = $datapacket->open(true);
			$datapacket->clear();
			
			$filtro = '{"cod":"700703","params":[
				{"name":"not_codigo","value":"'.$_POST["not_codigo"].'","type":"string"}
			]}';
			//pega dados das parcelas da nota
			$datapacket->add($filtro);
			$doctos = $datapacket->open();
			$datapacket->clear();
			if(!$doctos) $doctos = array(0=>array("doc_tipo"=>10));
			// $cpf = (strlen($nota[0]->cad_cnpjcpf)==14) ? substr($nota[0]->cad_cnpjcpf,0,2).".".substr($nota[0]->cad_cnpjcpf,2,3).".".substr($nota[0]->cad_cnpjcpf,5,3)."/".substr($nota[0]->cad_cnpjcpf,8,4)."-".substr($nota[0]->cad_cnpjcpf,9,2) : substr($nota[0]->cad_cnpjcpf,0,3).".".substr($nota[0]->cad_cnpjcpf,3,3).".".substr($nota[0]->cad_cnpjcpf,6,3)."-".substr($nota[0]->cad_cnpjcpf,9,2);
			
			//monta txt
			switch($doctos[0]["doc_tipo"]){
				case 10:
					$forma = "DINHEIRO";
				case 4:
					$forma = "CHEQUE";
				case 5:
					$forma = "CARTAO";
				default:
					$forma = "CARTAO";
			}
			
			$arquivo = $TParams->uploads.$company->emp_codigo."/DAV".str_pad($nota[0]->not_numero,4,'0',STR_PAD_LEFT).".TXT";
			$arq = fopen($arquivo, "w");
			
			//cabecalho
			$txt = "CAB|".$forma."|\r\n";
			$txt.= "CLI|".$nota[0]->cad_cnpjcpf."|".$nota[0]->cad_nomeraz."|".$nota[0]->end_nome."|".$nota[0]->end_num."|".$nota[0]->end_cidade."|".$nota[0]->end_bairro."|".$nota[0]->end_uf."|\r\n";
			foreach($nota as $n){
				$tribjson = json_decode(base64_decode($n->itn_tribjson));
				$txt.= "PRD|".$n->ref_codigo."|".$n->itn_descr."|".$n->itn_valor."|".$n->itn_qtde."|".$n->uni_codigo."|".$tribjson->rowdata[0]->tri_csosn."|".$n->itn_ncm."|\r\n";
			}
			fwrite($arq, $txt);
			fclose($arq);
			exit("./php/download.php?file=".$arquivo."&del=true");
			
		}
		
	} else {
		
		//verifica se ja existe o codigo adicionado no banco de dados
		$filtro = '{"cod":"500921","params":[
			{"name":"not_codigo","value":"'.$_POST['not_codigo'].'","type":"string"}
		]}';
		$datapacket->add($filtro);
		$retorno = $datapacket->open(true);
		$datapacket->clear();
		if(isset($retorno) && $retorno[0]->{'not_tipo'}==2 && $retorno[0]->{'not_status'}==2){
			exit();
		}
			
		//webhook
		if( isset($_POST["not_tipo"]) && ($_POST["not_tipo"]==2 || $_POST["not_tipo"]==3) ){
			$filtroW = '{"cod":"600021","params":[
				{"name":"emp_codigo","value":"'.$TParams->getCodigo().'","type":"string"},
				{"name":"web_modulo","value":"pedido","type":"string"}
			]}';
			$datapacket->setHost($TParams->getHost("empresas"));
			$datapacket->add($filtroW);
			$web = $datapacket->open();
			$datapacket->clear();
			if( isset($web) && count($web)>0 && isset($web[0]["web_url"]) ){
				include_once "webhook.php";
			}
			$datapacket->setHost($TParams->getHost($TParams->getDbSge()));
		}
	
		//LOG DE INSERÇÃO/EDIÇÃO DA NF-e
		if($_POST['log_acao_cod']==8){
			$descr_log = "conversão";
			$obs = "Pedido Convertido em Nota Fiscal";
			$log_tipo=5;
		}else{
			if( isset($_POST["not_tipo"]) && $_POST["not_tipo"]==2 ){
				$obs = ($_POST['log_acao_cod']==1) ? "Cadastro do Pedido" : "Alteração dos dados do Pedido";
			}elseif( isset($_POST["not_tipo"]) && $_POST["not_tipo"]==3 ){
				$obs = ($_POST['log_acao_cod']==1) ? "Cadastro da Ordem de Compra" : "Alteração dos dados da Ordem de Compra";
			}elseif( isset($_POST["not_tipo"]) && $_POST["not_tipo"]==6 ){
				$obs = ($_POST['log_acao_cod']==1) ? "Cadastro da Venda Consignada" : "Alteração dos dados da Consignação";
			}else{
				$obs = ($_POST['log_acao_cod']==1) ? "Cadastro da NF-e" : "Alteração dos dados da NF-e";
			}
			if(isset($_POST["not_tipo"]) && ($_POST["not_tipo"]==2 || $_POST["not_tipo"]==3) && isset($_POST["faturar"])){
				$_POST['log_acao_cod']=7;
				$descr_log = "faturamento";
				$obs = "Pedido Faturado";
			}else{
				$descr_log = ($_POST['log_acao_cod']==1) ? "inclusão" : "edição";
			}
			
			if(isset($_POST["not_tipo"]) && ($_POST["not_tipo"]==2 || $_POST["not_tipo"]==3) ){
				$log_tipo=5;
			}elseif(isset($_POST["not_tipo"]) && $_POST["not_tipo"]==6){
				$log_tipo=7;
			}else{
				$log_tipo=2;
			}
		}
		
		$filtrolog = '{"cod":"700103","params":[
			{"name":"log_tipo","value":"'.$log_tipo.'","type":"integer"},
			{"name":"log_nro","value":"'.$_POST['not_codigo'].'","type":"string"},
			{"name":"log_serie","value":"'.$_POST['not_serie'].'","type":"string"},';
		$filtrolog.= ( isset($_POST["usu_login"]) && $_POST["usu_login"]!="" ) ? '{"name":"log_usu_login","value":"'.$_POST["usu_login"].'","type":"string"},' : '{"name":"log_usu_login","value":"NULL","type":"other"},';
		$filtrolog.= '{"name":"log_acao_cod","value":"'.$_POST['log_acao_cod'].'","type":"integer"},
			{"name":"log_acao_descr","value":"'.$descr_log.'","type":"string"},
			{"name":"log_data","value":"","type":"string"},
			{"name":"log_protocolo","value":"NULL","type":"other"},
			{"name":"log_ret","value":"NULL","type":"other"},
			{"name":"log_outro","value":"'.base64_encode($obs).'","type":"string"}
		]}';

		//campos de observação da nota
		$array1 = array("á", "à", "ã", "â", "Á", "À", "Ã", "Â", "é", "ê", "É", "Ê", "í", "Í", "ó", "õ", "ô", "Ó", "Ô", "Õ", "ú", "ü", "Ú", "Ü", "ç", "Ç", "º", "ª", "\"", "'");
		$array2 = array("a", "a", "a", "a", "A", "A", "A", "A", "e", "e", "E", "E", "i", "I", "o", "o", "o", "O", "O", "O", "u", "u", "U", "U", "c", "C", "", "", "", "");
		
		if(isset($_POST["not_obs"]) && $_POST["not_obs"]!=""){
			$obs = base64_encode(utf8_decode(strip_tags(str_replace($array1, $array2, trim($_POST["not_obs"])))));
		}else{
			$obs = "";
		}
		if(isset($_POST["not_obs4"]) && $_POST["not_obs4"]!=""){
			$obs4 = base64_encode(utf8_decode(strip_tags(str_replace($array1, $array2, trim($_POST["not_obs4"])))));
		}else{
			$obs4 = "";
		}		
		
		$not_status = ( isset($_POST["ped_status"]) && isset($_POST["not_tipo"]) && ($_POST["not_tipo"]==2 || $_POST["not_tipo"]==3) ) ? $_POST["ped_status"] : 0; //atualizar status, nos casos de pedidos

		// tributos
		$not_ibpt_federal = 0;
		if(isset($_POST['not_ibpt_federal']) && !empty($_POST['not_ibpt_federal']) && is_numeric($_POST['not_ibpt_federal']) && $_POST['not_ibpt_federal']>0){
			$not_ibpt_federal = $_POST['not_ibpt_federal'];
		}
		
		$not_ibpt_estadual = 0;
		if(isset($_POST['not_ibpt_estadual']) && !empty($_POST['not_ibpt_estadual']) && is_numeric($_POST['not_ibpt_estadual']) && $_POST['not_ibpt_estadual']>0){
			$not_ibpt_estadual = $_POST['not_ibpt_estadual'];
		}

		$not_ibpt_municipal = 0;
		if(isset($_POST['not_ibpt_municipal']) && !empty($_POST['not_ibpt_municipal']) && is_numeric($_POST['not_ibpt_municipal']) && $_POST['not_ibpt_municipal']>0){
			$not_ibpt_municipal = $_POST['not_ibpt_municipal'];
		}
		
		//NF-e referenciada
		if( isset($_POST['not_nferef']) && $_POST['not_nferef']!="" ){
			if($_POST['cfo_codigo']==5929 || $_POST['cfo_codigo']==6929){
				$refjson=$_POST['not_nferef'];
			}else{
				$nferef= json_decode($_POST['not_nferef']);
				$refjson = '{';
				for($i=0;$i<count($nferef);$i++){
					$refjson.='"'.($i).'":"'.$nferef[$i].'",';
				}
				$refjson = substr($refjson,0,-1);
				$refjson.='}';
			}
		}
		
		//anexo PEDIDO
		$filtroAnexo = '{"cod":"700714","params":[
			{"name":"not_codigo","value":"'.$_POST['not_codigo'].'","type":"string"}
		]}';
		$datapacket->add($filtroAnexo);
		$not_anexo = $datapacket->open(false);
		$datapacket->clear();
		
		//excluir itens anteriores
		$filtro2 = '{"cod":"700100","params":[
			{"name":"not_codigo","value":"'.$_POST['not_codigo'].'","type":"string"}
		]}';
		$datapacket->add($filtro2);
		
		//excluir parcelas anteriores
		$filtroLimpaParc = '{"cod":"700106","params":[
			{"name":"not_codigo","value":"'.$_POST["not_codigo"].'","type":"string"}
		]}';
		$datapacket->add($filtroLimpaParc);
		
		//excluir servicos anteriores
		$filtroserv1 = '{"cod":"700480","params":[
			{"name":"not_codigo","value":"'.$_POST['not_codigo'].'","type":"string"}
		]}';
		$datapacket->add($filtroserv1);
		
		$datapacket->open();
		$datapacket->clear();
		
		//CADASTRAR/ EDITAR A NF-e
		if( isset($_POST["nf"]) && $_POST["nf"]=="nf" ){
			$filtro = '{"cod":"500910","params":[';
		}else{

			if($retorno[0]->{'total'} > 0){
				$filtro = '{"cod":"500922","params":[';
			}else{
				//buscar numero atualizado
				if(isset($_POST["not_tipo"]) && ($_POST["not_tipo"]==9 || $_POST["not_tipo"]==7)){
					$not_tipo = '7,9';
				}elseif(isset($_POST["not_tipo"])){
					$not_tipo = $_POST["not_tipo"];
				}else{
					$not_tipo = '7,9';
				}
				$filtronum = '{"cod":"500924","params":[
					{"name":"not_tipo","value":"'.$not_tipo.'","type":"other"},
					{"name":"ser_codigo","value":"'.$_POST['not_serie'].'","type":"string"}
				]}';
				$datapacket->add($filtronum);
				$num = $datapacket->open(true);
				$datapacket->clear();
				if($num[0] && $num[0]->not_numero) $_POST["not_numero"] = $num[0]->not_numero;
				
				$filtro = '{"cod":"500923","params":[';
				// $filtro = '{"cod":"700096","params":[';
			}
			
		}
		
		$filtro.='
			{"name":"not_codigo","value":"'.$_POST['not_codigo'].'","type":"string"},
			{"name":"not_numero","value":"'.$_POST["not_numero"].'","type":"integer"},
			{"name":"ser_codigo","value":"'.$_POST['not_serie'].'","type":"string"},
			{"name":"cad_codigo","value":"'.$_POST['cad_codigo'].'","type":"string"},';
		$filtro.= ( isset($_POST['ven_codigo']) && $_POST['ven_codigo']!="" ) ? '{"name":"cad_codvend","value":"'.$_POST['ven_codigo'].'","type":"string"},' : '{"name":"cad_codvend","value":"NULL","type":"other"},';
		$filtro.= ( isset($_POST["not_tipo"]) ) ? '{"name":"not_tipo","value":"'.$_POST["not_tipo"].'","type":"integer"},' : '{"name":"not_tipo","value":"9","type":"integer"},';
		$filtro.= '{"name":"not_cancelada","value":"0","type":"integer"},
			{"name":"not_dtcancdesc","value":"","type":"null"},';
		$filtro.= '{"name":"not_data","value":"'.implode("-", array_reverse( explode("/", substr($_POST['not_data'],0,10)))).' '.substr($_POST['not_data'],10).'","type":"string"},';
		$filtro.= '{"name":"not_dtemissao","value":"'.date("Y-m-d H:i:s").'","type":"string"},
			{"name":"not_dtfaturam","value":"","type":"null"},
			{"name":"not_dtprevisao","value":"","type":"null"},
			{"name":"not_dtentrega","value":"","type":"null"},';
		$filtro.= ( isset($_POST["not_finanatualiz"]) ) ? '{"name":"not_finanatualiz","value":"'.$_POST["not_finanatualiz"].'","type":"integer"},' : '{"name":"not_finanatualiz","value":"0","type":"integer"},';
		$filtro.= ( isset($_POST["not_stokatualiz"]) ) ? '{"name":"not_stokatualiz","value":"'.$_POST["not_stokatualiz"].'","type":"integer"},' : '{"name":"not_stokatualiz","value":"0","type":"integer"},';
		$filtro.= ( isset($_POST["not_custoautaliz"]) ) ? '{"name":"not_custoautaliz","value":"'.$_POST["not_custoautaliz"].'","type":"integer"},' : '{"name":"not_custoautaliz","value":"0","type":"integer"},';
		$filtro.= '{"name":"not_percdesc","value":"'.$_POST['not_pdesc'].'","type":"float"},
			{"name":"not_valordesc","value":"'.$_POST['not_desc'].'","type":"float"},
			{"name":"not_totalnota","value":"'.$_POST['not_totalnota'].'","type":"float"},
			{"name":"not_totalprod","value":"'.$_POST['not_total'].'","type":"float"},';
		$filtro.= ( isset($_POST['total_servico']) ) ? '{"name":"not_totalserv","value":"'.$_POST["total_servico"].'","type":"float"},' : '{"name":"not_totalserv","value":"NULL","type":"other"},';
		$filtro.= '{"name":"not_entrsaida","value":"'.$_POST['not_entrsaida'].'","type":"integer"},
			{"name":"not_totbaseicms","value":"'.$_POST['not_totbaseicms'].'","type":"float"},
			{"name":"not_toticms","value":"'.$_POST['not_icms'].'","type":"float"},
			{"name":"not_totbaseipi","value":"'.$_POST['not_totbaseipi'].'","type":"float"},
			{"name":"not_totipi","value":"'.$_POST['not_ipi'].'","type":"float"},
			{"name":"cfo_codigo","value":"'.$_POST['cfo_codigo'].'","type":"integer"},';
			$filtro.= ( isset($_POST['cdp_codigo']) && $_POST['cdp_codigo']!='' && $_POST['cdp_codigo']!=0 ) ? '{"name":"cdp_codigo","value":"'.$_POST['cdp_codigo'].'","type":"integer"},' : '{"name":"cdp_codigo","value":"NULL","type":"other"},';
			$filtro.= '{"name":"pdv_codigo","value":"","type":"null"},';
			$filtro.= ( isset($_POST['ccu_codigo']) && $_POST['ccu_codigo']!='' && $_POST['ccu_codigo']!=0 && $_POST['ccu_codigo']!="Novo Registro" ) ? '{"name":"ccu_codigo","value":"'.$_POST['ccu_codigo'].'","type":"string"},' : '{"name":"ccu_codigo","value":"NULL","type":"other"},';
			$filtro.= ( isset($_POST['plc_codigo']) && $_POST['plc_codigo']!='' && $_POST['plc_codigo']!=0 && $_POST['plc_codigo']!="Novo Registro" ) ? '{"name":"plc_codigo","value":"'.$_POST['plc_codigo'].'","type":"string"},' : '{"name":"plc_codigo","value":"NULL","type":"other"},';
			$filtro.= ( isset($_POST['tbp_codigo']) && $_POST['tbp_codigo']!='' && $_POST['tbp_codigo']!=0 ) ? '{"name":"tbp_codigo","value":"'.$_POST['tbp_codigo'].'","type":"integer"},' : '{"name":"tbp_codigo","value":"NULL","type":"other"},';
			$filtro.= ( isset($_POST["not_codigo_pai"]) && $_POST['not_codigo_pai']!='' && $_POST['not_codigo_pai']!=0 ) ? '{"name":"not_codigo_pai","value":"'.$_POST["not_codigo_pai"].'","type":"string"},' : '{"name":"not_codigo_pai","value":"NULL","type":"other"},';
			$filtro.= '{"name":"not_codigo_filho","value":"","type":"null"},
			{"name":"cad_codtransp","value":"'.$_POST['not_transportadora'].'","type":"string"},
			{"name":"not_frete","value":"'.$_POST['not_frete'].'","type":"float"},
			{"name":"not_seguro","value":"'.$_POST['not_seguro'].'","type":"float"},
			{"name":"not_despesa","value":"'.$_POST['not_desp'].'","type":"float"},
			{"name":"not_tpfrete","value":"'.$_POST['tipo_frete'].'","type":"integer"},
			{"name":"not_toticmssubst","value":"'.$_POST['not_strib'].'","type":"float"},
			{"name":"not_obs1","value":"'.$obs.'","type":"string"},
			{"name":"not_obs2","value":"","type":"string"},
			{"name":"not_obs3","value":"","type":"string"},
			{"name":"not_obs4","value":"'.$obs4.'","type":"string"},
			{"name":"not_devolucao","value":"","type":"null"},
			{"name":"not_hhmmss","value":"","type":"null"},
			{"name":"not_qtde","value":"'.$_POST['not_quantidade'].'","type":"float"},
			{"name":"not_especie","value":"'.$_POST['not_especie'].'","type":"string"},
			{"name":"not_marca","value":"'.$_POST['not_fremarca'].'","type":"string"},
			{"name":"not_nro","value":"'.$_POST['not_frenumero'].'","type":"string"},
			{"name":"not_pesobruto","value":"'.$_POST['not_frepesobruto'].'","type":"float"},
			{"name":"not_pesoliquido","value":"'.$_POST['not_frepesoliquido'].'","type":"float"},
			{"name":"not_cadinscrito","value":"","type":"null"},
			{"name":"not_transportadora","value":"'.$_POST['not_transportadora'].'","type":"string"},
			{"name":"not_placa","value":"'.$_POST['not_placa'].'","type":"string"},
			{"name":"not_totbaseicmsst","value":"'.$_POST['not_totbasestrib'].'","type":"float"},
			{"name":"not_totiss","value":"","type":"null"},
			{"name":"cad_atendente","value":"","type":"null"},';
		$filtro.= ( isset($_POST["not_key_nfe"]) && $_POST["not_key_nfe"]!="" ) ? '{"name":"not_key_nfe","value":"'.$_POST["not_key_nfe"].'","type":"string"},' : '{"name":"not_key_nfe","value":"NULL","type":"other"},';
		$filtro.= ($_POST["cdp_modo"]=='1' || $_POST["cdp_modo"]==1) ? '{"name":"not_cdp_desc","value":"'.(-$_POST['not_desconto']).'","type":"float"},' : '{"name":"not_cdp_desc","value":"'.$_POST['not_desconto'].'","type":"float"},';
		$filtro.= '{"name":"not_cobranca","value":"","type":"null"},
			{"name":"not_entrada","value":"","type":"null"},';
		$filtro.= ( (isset($_POST["not_tipo"]) && ($_POST["not_tipo"]==2 || $_POST["not_tipo"]==3) && isset($_POST["faturar"])) || (isset($_POST["nf"]) && $_POST["nf"]=="nf") ) ? '{"name":"not_status","value":"2","type":"integer"},' : '{"name":"not_status","value":"'.$not_status.'","type":"integer"},'; //status faturado, caso seja um pedido com esta opção!
		$filtro.= (isset($_POST["nfe_final"]) && $_POST["nfe_final"]!="" ) ? '{"name":"not_tpprc","value":"'.$_POST["nfe_final"].'","type":"integer"},' : '{"name":"not_tpprc","value":"NULL","type":"other"},';
		$filtro.= '{"name":"not_nrodeposito","value":"","type":"null"},
			{"name":"not_codrastream","value":"","type":"null"},';
		$filtro.= ( isset($_POST['cta_codigo']) && $_POST['cta_codigo']!="") ? '{"name":"cta_codigo","value":"'.$_POST['cta_codigo'].'","type":"integer"},' : '{"name":"cta_codigo","value":"NULL","type":"other"},';
		$filtro.= '{"name":"not_result","value":"","type":"null"},';
		$filtro.= ( isset($_POST["not_cstat"]) && $_POST["not_cstat"]!="" ) ? '{"name":"not_cstat","value":"'.$_POST["not_cstat"].'","type":"integer"},' : '{"name":"not_cstat","value":"NULL","type":"other"},';
		$filtro.= ( isset($_POST["not_xmotivo"]) && $_POST["not_xmotivo"]!="" ) ? '{"name":"not_xmotivo","value":"'.base64_encode($_POST["not_xmotivo"]).'","type":"string"},' : '{"name":"not_xmotivo","value":"NULL","type":"other"},';
		$filtro.= '{"name":"not_nrec","value":"","type":"null"},';
		$filtro.= ( isset($_POST["not_nprot"]) && $_POST["not_nprot"]!="" ) ? '{"name":"not_nprot","value":"'.$_POST["not_nprot"].'","type":"string"},' : '{"name":"not_nprot","value":"NULL","type":"other"},';
		$filtro.= ( isset($_POST["nf"]) && $_POST["nf"]=="nf" ) ? '{"name":"not_tpemis","value":"NULL","type":"other"},' : '{"name":"not_tpemis","value":"1","type":"integer"},'; //caso não seja um cadastro de nf de entrada add tipoemissao = 1
		$filtro.= '{"name":"not_aliq","value":"","type":"null"},
			{"name":"not_entrnfe","value":"","type":"null"},
			{"name":"not_mapa","value":"","type":"null"},
			{"name":"not_lote_ccev","value":"","type":"null"},
			{"name":"loc_codigo","value":"","type":"null"},
			{"name":"not_cod_mesa","value":"","type":"null"},
			{"name":"not_sta_mesa","value":"","type":"null"},';
		$filtro.= ($_POST['not_aliqcredicms']) ? '{"name":"not_aliqcredicms","value":"'.$_POST['not_aliqcredicms'].'","type":"float"},' : '{"name":"not_aliqcredicms","value":"NULL","type":"other"},';
		$filtro.= (isset($_POST['not_info']) && $_POST['not_info']!="" && $_POST['not_info']!=" ") ? '{"name":"not_inf_fisco","value":"'.base64_encode(strip_tags(str_replace($array1, $array2, $_POST['not_info']))).'","type":"string"},' : '{"name":"not_inf_fisco","value":"","type":"string"},';
		$filtro.= ( isset($_POST['lic_codigo']) && $_POST['lic_codigo'] && $_POST['lic_codigo']!='' && $_POST['lic_codigo']!=0 ) ? '{"name":"lic_codigo","value":"'.$_POST['lic_codigo'].'","type":"integer"},' : '{"name":"lic_codigo","value":"NULL","type":"other"},';
		$filtro.= ( isset($_POST['not_nferef']) && $_POST['not_nferef'] && $_POST['not_nferef']!='' ) ? '{"name":"not_nferef","value":"'.base64_encode($refjson).'","type":"string"},' : '{"name":"not_nferef","value":"NULL","type":"other"},';
		$filtro.= ( isset($_POST['not_auxiliar']) && $_POST['not_auxiliar'] ) ? '{"name":"not_auxiliar","value":"'.trim($_POST['not_auxiliar']).'","type":"string"},' : '{"name":"not_auxiliar","value":"NULL","type":"other"},';
		$filtro.= (isset($not_anexo) && isset($not_anexo[0]) && is_array($not_anexo)) ? '{"name":"not_anexo","value":"'.$not_anexo[0]["not_anexo"].'","type":"string"},' : '{"name":"not_anexo","value":"NULL","type":"other"},';
		$filtro.= (isset($_POST['ors_codigo']) && !empty($_POST['ors_codigo'])) ? '{"name":"ors_codigo","value":"'.$_POST['ors_codigo'].'","type":"string"},' : '{"name":"ors_codigo","value":"NULL","type":"other"},';
		$filtro.= '{"name":"not_ibpt_federal","value":"'.$not_ibpt_federal.'","type":"float"},
			{"name":"not_ibpt_estadual","value":"'.$not_ibpt_estadual.'","type":"float"},
			{"name":"not_ibpt_municipal","value":"'.$not_ibpt_municipal.'","type":"float"}
		]}';

		$datapacket->add($filtro);
		$datapacket->add($filtrolog);		
		
		//CADASTRAR/ ALTERAR OS ITENS DA NF-e (PRODUTOS)
		$produtos = json_decode($_POST["produtos"]);
		
		$ant="";
		$ref_comissao=0;
		
		for($i = 0; $i<count($produtos); $i++){

			$descontoItem = ($produtos[$i][15]) ? $produtos[$i][15] : 0;
			
			//corrigindo dados de estoque que nao foram enviados
			if(!isset($produtos[$i][33]) || $produtos[$i][33]=="") $produtos[$i][33]="99999";
			if(!isset($produtos[$i][42]) || $produtos[$i][42]=="") $produtos[$i][42]="99999";
			
			//comissao do produto
			if( isset($produtos[$i][46]) && $produtos[$i][46]>0 && $produtos[$i][3]>0 ){
				$ref_comissao+= (float) number_format($produtos[$i][46]/100*($produtos[$i][2] * ($produtos[$i][3]-$descontoItem)), 2, ".","");
			}else{
				$produtos[$i][46]=0;
			}

			//json com os dados  da tributação
			$tribjson = '{
				"metadata":[],
				"rowdata":[
					{
						"ref_codigo":"'.$produtos[$i][45].'",
						"ref_tipo":0,
						"ref_preco":'.str_replace(",", ".", $produtos[$i][3]).',
						"ref_cfop":"'.$produtos[$i][10].'",
						"tri_codigo":"'.$produtos[$i][11].'",
						"tri_aliqipi":'.str_replace(",", ".", $produtos[$i][9]).',
						"tri_aliqicms":'.str_replace(",", ".", $produtos[$i][6]).',
						"tri_redbaseicms":'.str_replace(",", ".", $produtos[$i][17]).',
						"tri_redbaseipi":'.str_replace(",", ".", $produtos[$i][18]).',
						"tri_aliq_icms_st":'.str_replace(",", ".", $produtos[$i][19]).',
						"tri_sit_ipi":"'.str_replace(",", ".", $produtos[$i][20]).'",
						"tri_mva_st":'.str_replace(",", ".", $produtos[$i][21]).',
						"tri_situacao":"'.str_replace(",", ".", $produtos[$i][22]).'",
						"tri_csosn":"'.str_replace(",", ".", $produtos[$i][23]).'",
						"tri_sit_pis":"'.str_replace(",", ".", $produtos[$i][25]).'",
						"tri_basepis":"'.str_replace(",", ".", $produtos[$i][26]).'",
						"tri_aliqpis":"'.str_replace(",", ".", $produtos[$i][27]).'",
						"tri_pis":"'.str_replace(",", ".", $produtos[$i][28]).'",
						"tri_sit_cofins":"'.str_replace(",", ".", $produtos[$i][29]).'",
						"tri_basecofins":"'.str_replace(",", ".", $produtos[$i][30]).'",
						"tri_aliqcofins":"'.str_replace(",", ".", $produtos[$i][31]).'",
						"tri_cofins":"'.str_replace(",", ".", $produtos[$i][32]).'",
						"ncm_valor":"'.str_replace(",", ".", $produtos[$i][14]).'",
						"tri_origem":"'.str_replace(",", ".", $produtos[$i][34]).'",
						"ref_cest":"'.str_replace(",", ".", $produtos[$i][43]).'",
						"tri_cenq":"'.str_replace(",", ".", $produtos[$i][44]).'",
						"ref_comissao":"'.str_replace(",", ".", $produtos[$i][46]).'",
						"tri_aliqdif":"'.str_replace(",", ".", $produtos[$i][47]).'",
						"tri_icmsdif":"'.str_replace(",", ".", $produtos[$i][48]).'",
						"uni_codigo_trib":"'.str_replace(",", ".", $produtos[$i][49]).'",
						"xped":"'.$produtos[$i][50].'",
						"nitemped":"'.$produtos[$i][51].'",
						"tri_cbenef":"'.$produtos[$i][52].'",
						"ref_bcicmsret":"'.$produtos[$i][53].'",
						"ref_aliqicmsret":"'.$produtos[$i][54].'",
						"ref_icmsret":"'.$produtos[$i][55].'",
						"tri_modbc_icms":"'.$produtos[$i][58].'",
						"tri_modbc_st_icms":"'.$produtos[$i][59].'"
					}
				]
			}';
			
			$produtos[$i][1] = strtoupper(str_replace($array1, $array2, trim($produtos[$i][1]))); //tratamento da string com o nome do produto
			
			if( isset($produtos[$i][38]) && $produtos[$i][38]!="" ){
				$produtos[$i][38] = strtoupper(str_replace($array1, $array2, trim($produtos[$i][38])));
			}
			
			// $ordem_item = ( isset($produtos[$i][60]) && is_numeric($produtos[$i][60]) ) ? $produtos[$i][60] : $i;
			$ordem_item = $i;
			
			$filtro3 = '{"cod":"700099","params":[
				{"name":"not_codigo","value":"'.$_POST['not_codigo'].'","type":"string"},
				{"name":"ref_codigo","value":"'.$produtos[$i][0].'","type":"integer"},
				{"name":"itn_ordem","value":"'.$ordem_item.'","type":"integer"},
				{"name":"itn_descr","value":"'.$produtos[$i][1].'","type":"string"},
				{"name":"itn_qtde","value":"'.$produtos[$i][2].'","type":"float"},
				{"name":"itn_valordesc","value":"'.$descontoItem.'","type":"float"},
				{"name":"itn_valor","value":"'.str_replace(",", ".", $produtos[$i][3]).'","type":"float"},
				{"name":"itn_subtotal","value":"'.($produtos[$i][2] * ($produtos[$i][3]-$descontoItem)).'","type":"float"},
				{"name":"itn_baseicms","value":"'.str_replace(",", ".", $produtos[$i][4]).'","type":"float"},
				{"name":"itn_icms","value":"'.str_replace(",", ".", $produtos[$i][5]).'","type":"float"},
				{"name":"itn_aliqicms","value":"'.str_replace(",", ".", $produtos[$i][6]).'","type":"float"},
				{"name":"itn_baseipi","value":"'.str_replace(",", ".", $produtos[$i][7]).'","type":"float"},
				{"name":"itn_ipi","value":"'.str_replace(",", ".", $produtos[$i][8]).'","type":"float"},
				{"name":"itn_aliqipi","value":"'.str_replace(",", ".", $produtos[$i][9]).'","type":"float"},
				{"name":"itn_baseicmsst","value":"'.str_replace(",", ".", $produtos[$i][12]).'","type":"float"},
				{"name":"itn_icmssubst","value":"'.str_replace(",", ".", $produtos[$i][13]).'","type":"float"},';
			$filtro3.= ( $_POST["not_entrsaida"]==2 && isset($produtos[$i][41]) ) ? '{"name":"itn_custovenda","value":"'.$produtos[$i][41].'","type":"float"},' : '{"name":"itn_custovenda","value":"NULL","type":"other"},'; //custo de venda NF-e de saída
			$filtro3.= '{"name":"itn_tribjson","value":"'.base64_encode($tribjson).'","type":"string"},
				{"name":"itn_ncm","value":"'.$produtos[$i][16].'","type":"string"},
				{"name":"ref_codbar","value":"'.$produtos[$i][24].'","type":"string"},
				{"name":"loc_codigo","value":"'.$produtos[$i][33].'","type":"string"},';
			$filtro3.= ( isset($produtos[$i][34]) ) ? '{"name":"itn_obs","value":"'.$produtos[$i][34].'","type":"string"},' : '{"name":"itn_obs","value":" ","type":"string"},';
			$filtro3.= ( isset($produtos[$i][35]) ) ? '{"name":"uni_codigo","value":"'.$produtos[$i][35].'","type":"string"},' : '{"name":"uni_codigo","value":"NULL","type":"other"},';
			$filtro3.= ( isset($produtos[$i][36]) ) ? '{"name":"itn_altura","value":"'.str_replace(",", ".", $produtos[$i][36]).'","type":"float"},' : '{"name":"itn_altura","value":"NULL","type":"other"},';
			$filtro3.= ( isset($produtos[$i][37]) ) ? '{"name":"itn_largura","value":"'.str_replace(",", ".", $produtos[$i][37]).'","type":"float"},' : '{"name":"itn_largura","value":"NULL","type":"other"},';
			$filtro3.= ( isset($produtos[$i][38]) ) ? '{"name":"itn_modelo","value":"'.$produtos[$i][38].'","type":"string"},' : '{"name":"itn_modelo","value":"NULL","type":"other"},';
			$filtro3.= ( isset($produtos[$i][39]) ) ? '{"name":"itn_comando","value":"'.$produtos[$i][39].'","type":"string"},' : '{"name":"itn_comando","value":"NULL","type":"other"},';
			$filtro3.= ( isset($produtos[$i][40]) ) ? '{"name":"fml_codigo","value":"'.$produtos[$i][40].'","type":"integer"},' : '{"name":"fml_codigo","value":"NULL","type":"other"},';
			$filtro3.= ( isset($produtos[$i][42]) ) ? '{"name":"lot_codigo","value":"'.$produtos[$i][42].'","type":"string"}' : '{"name":"lot_codigo","value":"99999","type":"string"}';
			$filtro3.= ']}';
			
			$datapacket->add($filtro3);
			
			//Adicionar os produtos ao estooue, e atualizar custos em casos de cadastro de NF de Entrada
			if( isset($_POST["nf"]) && $_POST["nf"]=="nf" ){
				$stk_seq = substr(str_replace(array(","," ","."),array("","",""),microtime()), 0, 8);
				$datapacketStk = new Datapacket();
				$datapacketStk->setHost($TParams->getHost($TParams->getDbSge()));
				$filtrostk = '{"cod":"700111","params":[
					{"name":"db","value":"'.$TParams->getDb().'","type":"other"},
					{"name":"emp_codigo","value":"'.$TParams->getCodigo().'","type":"string"},
					{"name":"loc_codigo","value":"'.$produtos[$i][33].'","type":"string"},
					{"name":"lot_codigo","value":"'.$produtos[$i][42].'","type":"string"},
					{"name":"ref_codigo","value":"'.$produtos[$i][0].'","type":"integer"},
					{"name":"ser_codigo","value":"'.$_POST['not_serie'].'","type":"string"},
					{"name":"stk_data","value":"'.date("Y-m-d H:i:").'0'.$i.'","type":"string"},
					{"name":"stk_seq","value":"'.$stk_seq.'","type":"integer"},
					{"name":"stk_qde","value":"'.$produtos[$i][2].'","type":"float"},
					{"name":"stk_tipo","value":"1","type":"integer"},
					{"name":"not_codigo","value":"'.$_POST['not_codigo'].'","type":"string"}
				]}';
				$datapacketStk->add($filtrostk);
				$datapacketStk->open();
				$datapacketStk->clear();
				
				//selecionar custo medio
				$datapacketCusto = new Datapacket();
				$datapacketCusto->setHost($TParams->getHost($TParams->getDbSge()));
				$datapacketCusto->add('{"cod":"700203","params":[{"name":"ref_codigo","value":"'.$produtos[$i][0].'","type":"integer"}]}');
				$ret = $datapacketCusto->open();
				
				
				if(!strstr($ant, $produtos[$i][0])){
					
					if($produtos[$i][13]>0){
						$icmsProd = $produtos[$i][13]/$produtos[$i][2];
					}else{
						$icmsProd=0;
					}
					
					if($produtos[$i][8]>0){
						$ipiProd = $produtos[$i][8]/$produtos[$i][2];
					}else{
						$ipiProd=0;
					}
					
					$custoRepos = $produtos[$i][3]+$icmsProd+$ipiProd;
					$cus_medio = ($ret && $ret[0] && $ret[0]["cus_medio"]) ? ( ( ($custoRepos*$produtos[$i][2])+($ret[0]["cus_medio"]*$ret[0]["cus_qtde"]) )/($produtos[$i][2]+$ret[0]["cus_qtde"]) ) : ($custoRepos);
					
					$filtrocusto = '{"cod":"700202","params":[
						{"name":"ref_codigo","value":"'.$produtos[$i][0].'","type":"integer"},
						{"name":"ser_codigo","value":"'.$_POST['not_serie'].'","type":"string"},
						{"name":"cus_qtde","value":"'.$produtos[$i][2].'","type":"float"},
						{"name":"cus_repos","value":"'.str_replace(",", ".", $custoRepos).'","type":"float"},
						{"name":"cus_medio","value":"'.$cus_medio.'","type":"float"},
						{"name":"cus_venda","value":"'.str_replace( ",", ".", ( $custoRepos + ($custoRepos * $company->emp_overhead)/100 ) ).'","type":"float"},
						{"name":"cus_ipi","value":"'.str_replace(",", ".", $ipiProd).'","type":"float"},
						{"name":"cus_icms","value":"'.str_replace(",", ".", $icmsProd).'","type":"float"}
					]}';
					$datapacket->add($filtrocusto);
					$ant.= $produtos[$i][0].",";
				}
			}
			
			//Ou remover produtos do estoque, em se tratando de um pedido faturado ou venda consignada
			if( (isset($_POST["not_tipo"]) && ($_POST["not_tipo"]==2 || $_POST["not_tipo"]==3) && isset($_POST["faturar"]) && isset($_POST["ped_status"]) && $_POST["ped_status"]==0) || isset($_POST["consig"] ) ){
				
				//conversao de unidades
				$datapacket2 = new Datapacket();
				$datapacket2->setHost($TParams->getHost($TParams->getDbSge()));
				$filtro = '{"cod":"700565","params":[
					{"name":"db","value":"'.$TParams->getDb().'","type":"other"},
					{"name":"uni_codigo","value":"'.$produtos[$i][35].'","type":"string"},
					{"name":"ref_codigo","value":"'.$produtos[$i][0].'","type":"integer"}
				]}';
				$datapacket2->add($filtro);
				$conv = $datapacket2->open();
				$datapacket2->clear();
				
				$stk_seq = substr(str_replace(array(","," ","."),array("","",""),microtime()), 0, 8);
				$loc_codigo = ($produtos[$i][33]) ? $produtos[$i][33] : "99999";
				
				if($_POST["not_tipo"]==3){
					$stk_tipo=1;
					$stk_qde = $produtos[$i][2];
				}else{
					$stk_tipo=2;
					if( isset($conv) && isset($conv[0]) && isset($conv[0]["ref_conv_qtde"]) && $conv[0]["ref_conv_qtde"]>0 ){
						$stk_qde = number_format($produtos[$i][2]/ $conv[0]["ref_conv_qtde"],2,'.','');
						$stk_qde = ($stk_qde>0) ? '-'.$stk_qde :  '-'.$produtos[$i][2];
					}else{
						$stk_qde = '-'.$produtos[$i][2];
					}
				}
				$filtrostk = '{"cod":"700111","params":[
					{"name":"db","value":"'.$TParams->getDb().'","type":"other"},
					{"name":"emp_codigo","value":"'.$TParams->getCodigo().'","type":"string"},
					{"name":"loc_codigo","value":"'.$loc_codigo.'","type":"string"},
					{"name":"lot_codigo","value":"'.$produtos[$i][42].'","type":"string"},
					{"name":"ref_codigo","value":"'.$produtos[$i][0].'","type":"integer"},
					{"name":"ser_codigo","value":"'.$_POST['not_serie'].'","type":"string"},
					{"name":"stk_data","value":"'.date("Y-m-d H:i:s").'","type":"string"},
					{"name":"stk_seq","value":"'.$stk_seq.'","type":"integer"},
					{"name":"stk_qde","value":"'.$stk_qde.'","type":"float"},
					{"name":"stk_tipo","value":"'.$stk_tipo.'","type":"integer"},
					{"name":"not_codigo","value":"'.$_POST['not_codigo'].'","type":"string"}
				]}';
				$datapacket->add($filtrostk);
				
				
				//estoques dos kits (composições)
				$datapacketkit = new Datapacket();
				$filtrostkkit = '{"cod":"700644","params":[
					{"name":"db","value":"'.$TParams->getDb().'","type":"other"},
					{"name":"ref_kit","value":"'.$produtos[$i][0].'","type":"integer"}
				]}';
				$datapacketkit->add($filtrostkkit);
				$kits = $datapacketkit->open();
				$datapacketkit->clear();
				if( isset($kits) && isset($kits[0]) && isset($kits[0]["ref_qtde"]) && $kits[0]["ref_qtde"]>0 ){
					foreach($kits as $kit){
						$stk_seq = substr(str_replace(array(","," ","."),array("","",""),microtime()), 0, 8);
						$filtrostk = '{"cod":"700111","params":[
							{"name":"db","value":"'.$TParams->getDb().'","type":"other"},
							{"name":"emp_codigo","value":"'.$TParams->getCodigo().'","type":"string"},
							{"name":"loc_codigo","value":"'.$loc_codigo.'","type":"string"},
							{"name":"lot_codigo","value":"'.$produtos[$i][42].'","type":"string"},
							{"name":"ref_codigo","value":"'.$kit["ref_codigo"].'","type":"integer"},
							{"name":"ser_codigo","value":"'.$_POST['not_serie'].'","type":"string"},
							{"name":"stk_data","value":"'.date("Y-m-d H:i:s").'","type":"string"},
							{"name":"stk_seq","value":"'.$stk_seq.'","type":"integer"},
							{"name":"stk_qde","value":"-'.$kit["ref_qtde"].'","type":"float"},
							{"name":"stk_tipo","value":"2","type":"integer"},
							{"name":"not_codigo","value":"'.$_POST['not_codigo'].'","type":"string"}
						]}';
						$datapacket->add($filtrostk);
					}
				}

			}
			
			//echo $filtro3;
		}
		
		//CADASTRAR/ ALTERAR OS ITENS DO PEDIDO (SERVIÇOS) - SOMENTE PARA PEDIDOS
		if( isset($_POST["servicos"]) ){
			
			$svc_comissao = 0;
			$servicos = json_decode($_POST["servicos"]);
			
			for($i = 0; $i<count($servicos); $i++){
				
				//comissao do servico
				if( isset($servicos[$i][8]) && $servicos[$i][8]>0 && $servicos[$i][4]>0 ){
					$svc_comissao+= (float) $servicos[$i][8]/100*$servicos[$i][4];
				}else{
					$servicos[$i][8]=0;
				}
				
				if( !isset($servicos[$i][9]) || $servicos[$i][9]=="" || $servicos[$i][9]=='0000-00-00 00:00:00' ){
					$servicos[$i][9] = "NULL";
				}else{
					$servicos[$i][9] = "'".$servicos[$i][9]."'";
				}
				
				$filtroserv2 = '{"cod":"700481","params":[
					{"name":"not_codigo","value":"'.$_POST['not_codigo'].'","type":"string"},
					{"name":"svc_codigo","value":"'.$servicos[$i][0].'","type":"integer"},
					{"name":"its_descr","value":"'.$servicos[$i][1].'","type":"string"},
					{"name":"its_qtde","value":"'.str_replace(",", ".", $servicos[$i][2]).'","type":"float"},
					{"name":"its_valor","value":"'.str_replace(",", ".", $servicos[$i][3]).'","type":"float"},
					{"name":"its_desc","value":"'.str_replace(",", ".", $servicos[$i][5]).'","type":"float"},
					{"name":"its_adic","value":"'.str_replace(",", ".", $servicos[$i][6]).'","type":"float"},
					{"name":"its_subtotal","value":"'.str_replace(",", ".", $servicos[$i][4]).'","type":"float"},
					{"name":"its_obs","value":"'.$servicos[$i][7].'","type":"string"},
					{"name":"its_comissao","value":"'.$servicos[$i][8].'","type":"float"},
					{"name":"its_data","value":"'.$servicos[$i][9].'","type":"other"}
				]}';
				
				$datapacket->add($filtroserv2);

			}
		}
		
		//PARCELAS DA NOTA	
		if( isset($_POST["parcelas"]) ){ //em caso de pedidos convertidos verificar se ja foram faturados
			
			$parcelas = json_decode($_POST["parcelas"]);
			$doc_codigo  = substr(str_replace(array(","," ","."),array("","",""),microtime()), -10).mt_rand(1000, 9999);
			if(is_array($parcelas) && count($parcelas)>0){
				
				//comissao vendedor
				if( isset($_POST["ven_codigo"]) && $_POST['ven_codigo']!="" && isset($_POST['cad_comissao']) && $_POST['cad_comissao']>0 ){
					if(isset($_POST['tipo_frete']) && $_POST['tipo_frete']==2 && isset($_POST['not_frete']) && $_POST['not_frete']>0){
						$doc_comissao = (float) ($_POST["cad_comissao"]/100 * ($_POST["not_totalnota"] - $_POST['not_frete']));
					}else{
						$doc_comissao = (float) ($_POST["cad_comissao"]/100 * $_POST["not_totalnota"]);
					}
				}elseif(isset($_POST["ven_codigo"]) && $_POST['ven_codigo']!="" && $ref_comissao>0){
					$doc_comissao = $ref_comissao;
					if(isset($svc_comissao) && $svc_comissao>0) $doc_comissao = (float) $doc_comissao + $svc_comissao;
				}else{
					$doc_comissao=0;
				}
				if($doc_comissao>0 && count($parcelas)>0){
					$doc_comissao = number_format((float) $doc_comissao/ count($parcelas), 2,".", "");
				}
			
				for($i = 0; $i<count($parcelas); $i++){

					$doc_codigo2 = $doc_codigo + $i;
					$pagrec = ($_POST["not_entrsaida"]=="2" || $_POST["not_entrsaida"]==2) ? "2" : "1";
					if(isset($_POST["not_tipo"]) && $_POST["not_tipo"]==2){
						$doc_origem = 5;
					}elseif(isset($_POST["not_tipo"]) && $_POST["not_tipo"]==3){
						$doc_origem = 11;
					}else{
						$doc_origem = 7;
					}
					if( isset($_POST["not_tipo"]) && $_POST["not_tipo"]==2 ){
						$descritivo = "Pedido";
					}elseif( isset($_POST["not_tipo"]) && $_POST["not_tipo"]==3 ){
						$descritivo = "Ordem de Compra";
					}else{
						$descritivo = "NF-e";
					}
					$descritivo.= " nro ".$_POST["not_numero"];
					$descritivo.= (count($parcelas)>1) ? " - parcela ".($i+1) : "";
					if( isset($_POST["not_tipo"]) && $_POST["not_tipo"]==2 ){
						$doc_numero = "PED".$_POST["not_numero"];
					}elseif( isset($_POST["not_tipo"]) && $_POST["not_tipo"]==3 ){
						$doc_numero = "OC".$_POST["not_numero"];
					}else{
						$doc_numero = "NFE".$_POST["not_numero"];
					}
					
					//PARCELA
					$filtroParc  = '{"cod":"500134", "params":[
						{"name":"doc_codigo", "value":"'.$doc_codigo2.'", "type":"string"},
						{"name":"doc_numero", "value":"'.$doc_numero.'-'.($i+1).'", "type":"string"},
						{"name":"doc_tipo", "value":"'.$parcelas[$i][3].'", "type":"integer"},
						{"name":"doc_pagrec", "value":"'.$pagrec.'", "type":"integer"},
						{"name":"doc_data", "value":"'.date('Y-m-d H:i:s').'", "type":"string"},
						{"name":"doc_valor", "value":"'.$parcelas[$i][2].'", "type":"float"},
						{"name":"doc_dtvcto", "value":"'.$parcelas[$i][1].'", "type":"string"},
						{"name":"doc_dtpgto", "value":"NULL", "type":"other"},
						{"name":"doc_vlrpg", "value":"NULL", "type":"other"},
						{"name":"doc_descr", "value":"'.$descritivo.'", "type":"string"},
						{"name":"doc_status", "value":"0", "type":"integer"},
						{"name":"doc_codbar", "value":" ", "type":"string"},
						{"name":"doc_linhadig", "value":"NULL", "type":"other"},
						{"name":"doc_banco", "value":"NULL", "type":"other"},
						{"name":"doc_agencia", "value":"NULL", "type":"other"},
						{"name":"doc_conta", "value":"NULL", "type":"other"},';
					$filtroParc.= ( isset($company->emp_multa) && $company->emp_multa>0 && $pagrec=="2" ) ? '{"name":"doc_multa", "value":"'.$company->emp_multa.'", "type":"float"},' : '{"name":"doc_multa", "value":"NULL", "type":"other"},';
					$filtroParc.= ( isset($company->emp_jurosdiario) && $company->emp_jurosdiario>0 && $pagrec=="2" ) ? '{"name":"doc_juros", "value":"'.$company->emp_jurosdiario.'", "type":"float"},' : '{"name":"doc_juros", "value":"NULL", "type":"other"},';
					$filtroParc.= '{"name":"doc_honorarios", "value":"NULL", "type":"other"},
						{"name":"doc_dias_envio", "value":"0", "type":"integer"},
						{"name":"doc_nparc", "value":"'.($i+1).'", "type":"integer"},
						{"name":"doc_tparc", "value":"'.(count($parcelas)).'", "type":"integer"},
						{"name":"doc_json_parcial", "value":"NULL", "type":"other"},
						{"name":"doc_obs", "value":"'.$descritivo.'", "type":"string"},
						{"name":"cad_codigo", "value":"'.$_POST["cad_codigo"].'", "type":"string"},
						{"name":"ser_codigo", "value":"'.$_POST["not_serie"].'", "type":"string"},';
					$filtroParc.= ( isset($_POST['ccu_codigo']) && $_POST['ccu_codigo']!="" && $_POST['ccu_codigo']!="Novo Registro") ? '{"name":"ccu_codigo","value":"'.$_POST['ccu_codigo'].'","type":"string"},' : '{"name":"ccu_codigo","value":"NULL","type":"other"},';
					$filtroParc.= ( isset($_POST['plc_codigo']) && $_POST['plc_codigo']!="" && $_POST['plc_codigo']!="Novo Registro") ? '{"name":"plc_codigo","value":"'.$_POST['plc_codigo'].'","type":"string"},' : '{"name":"plc_codigo","value":"NULL","type":"other"},';
					$filtroParc.='{"name":"doc_cod_pai", "value":"NULL", "type":"other"},
						{"name":"cad_codatend", "value":"NULL", "type":"other"},
						{"name":"doc_carteira", "value":"'.$parcelas[$i][4].'", "type":"string"},
						{"name":"doc_nossonumero", "value":"NULL", "type":"other"},';
					$filtroParc.= ( isset($servicos) && isset($servicos[0][0]) ) ? '{"name":"svc_codigo", "value":"'.$servicos[0][0].'", "type":"integer"},' : '{"name":"svc_codigo", "value":"NULL", "type":"other"},';
					$filtroParc.= '{"name":"doc_sacador", "value":"NULL", "type":"other"},';
					$filtroParc.= ( isset($_POST['cta_codigo']) && $_POST['cta_codigo']!='' ) ? '{"name":"cta_codigo","value":"'.$_POST['cta_codigo'].'","type":"integer"},' : '{"name":"cta_codigo","value":"NULL","type":"other"},';
					$filtroParc.= ( isset($parcelas[$i][6]) && $parcelas[$i][6]!="" ) ? '{"name":"doc_dias_protesto", "value":"'.$parcelas[$i][6].'", "type":"integer"},' : '{"name":"doc_dias_protesto", "value":"NULL", "type":"other"},';
					$filtroParc.= ( isset($parcelas[$i][5]) && $parcelas[$i][5]!="" ) ? '{"name":"doc_protesto", "value":"'.$parcelas[$i][5].'", "type":"integer"},' : '{"name":"doc_protesto", "value":"NULL", "type":"other"},';
					$filtroParc.= ( isset($_POST["not_tipo"]) && ($_POST["not_tipo"]==2 || $_POST["not_tipo"]==3) && !isset($_POST["faturar"]) ) ? '{"name":"doc_previsao", "value":"1", "type":"integer"},' : '{"name":"doc_previsao", "value":"0", "type":"integer"},';
					$filtroParc.= '{"name":"doc_origem", "value":"'.$doc_origem.'", "type":"integer"},';
					$filtroParc.= '{"name":"doc_origem_codigo", "value":"'.$_POST["not_codigo"].'", "type":"string"},';
					$filtroParc.= ( isset($_POST['ven_codigo']) && $_POST['ven_codigo']!="" ) ? '{"name":"cad_codvend", "value":"'.$_POST["ven_codigo"].'", "type":"string"},' : '{"name":"cad_codvend", "value":"NULL", "type":"other"},';
					$filtroParc.= '{"name":"doc_comissao", "value":"'.$doc_comissao.'", "type":"float"}';
					$filtroParc.= ']}';
					
					$datapacket->add($filtroParc);
					
					//VINCULO NF-e -> PARCELA
					$filtroParcNota = '{"cod":"700107","params":[
						{"name":"not_codigo","value":"'.$_POST["not_codigo"].'","type":"string"},
						{"name":"doc_codigo","value":"'.$doc_codigo2.'","type":"string"}
					]}';
					$datapacket->add($filtroParcNota);
					
					//log inclusao docto
					$filtrolog = '{"cod":"501240","params":[
						{"name":"lgd_tipo","value":"1","type":"integer"},
						{"name":"doc_codigo","value":"'.$doc_codigo2.'","type":"string"},
						{"name":"usu_login","value":"'.$_POST["usu_login"].'","type":"string"},
						{"name":"lgd_dtatualizada","value":"NULL","type":"other"},
						{"name":"lgd_descr","value":"Documento cadastrado e vinculado a '.$descritivo.'","type":"string"}
					]}';
					$datapacket->add($filtrolog);
					
				}
				
				//ATUALIZAR OS PEDIDOS FINALIZADOS (fin)
				if( isset($_POST["pedidos"]) && !isset($_POST["nf"]) ){
					$pedidos = json_decode($_POST["pedidos"]);
					if(is_array($pedidos)){
						foreach($pedidos as $pedido){
							if($pedido && $pedido!=""){
								//excluir parcelas de pedidos convertidos nao faturados
								$filtroLimpaParc = '{"cod":"700106","params":[
									{"name":"not_codigo","value":"'.$pedido.'","type":"string"}
								]}';
								$datapacket->add($filtroLimpaParc);
							}
						}
					}
				}
				
			}
		}
		
		//ATUALIZAR OS PEDIDOS FINALIZADOS (status)
		if( isset($_POST["pedidos"]) && !isset($_POST["nf"]) ){
			$pedidos = json_decode($_POST["pedidos"]);
			if(is_array($pedidos)){
				foreach($pedidos as $pedido){
					if($pedido && $pedido!=""){
						$filtroped = '{"cod":"700550","params":[
							{"name":"not_codigo","value":"'.$pedido.'","type":"string"},
							{"name":"not_status","value":"2","type":"integer"}
						]}';
						$datapacket->add($filtroped);
					}
				}
			}
		}
		
		//ATUALIZAR OS PEDIDOS FINALIZADOS PARCIALMENTE
		if( isset($_POST["pedidosParc"]) ){
			$pedidosParc = json_decode($_POST["pedidosParc"]);
			if(is_array($pedidosParc)){
				foreach($pedidosParc as $pedidoParc){
					if($pedidoParc && $pedidoParc!=""){
						$filtroped = '{"cod":"700550","params":[
							{"name":"not_codigo","value":"'.$pedidoParc.'","type":"string"},
							{"name":"not_status","value":"1","type":"integer"}
						]}';
						$datapacket->add($filtroped);
						//excluir parcelas de pedidos convertidos nao faturados
						// if( $_POST["not_finanatualiz"]==0 ){
							$filtroLimpaParc = '{"cod":"700106","params":[
								{"name":"not_codigo","value":"'.$pedidoParc.'","type":"string"}
							]}';
							$datapacket->add($filtroLimpaParc);
						// }
					}
				}
			}
		}
		
		//ATUALIZAR A OS, QUANDO FOR O CASO DE UMA NF-E EMITIDA A PARTIR DE UMA OS
		if( isset($_POST["ose_codigo"]) && $_POST["ose_codigo"]!="" ){
			$datapacket2 = new Datapacket();
			$datapacket2->setHost($TParams->getHost($TParams->getDbSge()));
			$filtroobs = '{"cod":"700263","params":[
				{"name":"ose_codigo","value":"'.$_POST["ose_codigo"].'","type":"integer"}
			]}';
			$datapacket2->add($filtroobs);
			$res = $datapacket2->open();
			$ose_obs = json_decode(base64_decode($res[0]["ose_obs"]));
			if(!is_array($ose_obs)) $ose_obs = array();
			$pos = (count($ose_obs)>0) ? count($ose_obs) : 0; 
			$ose_obs[$pos] =  new StdClass();
			$ose_obs[$pos]->obs_ordem = $pos;
			$ose_obs[$pos]->obs_tipo = 0;
			$ose_obs[$pos]->obs_obs = base64_encode("NF-e nro ".$_POST["not_numero"]." - serie ".$_POST["not_serie"]." foi emitida a partir desta OS.");
			$ose_obs[$pos]->usu_login = "";
			$ose_obs[$pos]->usu_nome = "SISTEMA";
			$ose_obs[$pos]->obs_data = date("Y-m-d H:i:s");
			$filtroos = '{"cod":"700238","params":[
				{"name":"ose_codigo","value":"'.$_POST["ose_codigo"].'","type":"integer"},
				{"name":"not_codigo","value":"'.$_POST["not_codigo"].'","type":"string"},
				{"name":"ose_obs","value":"'.base64_encode(json_encode($ose_obs)).'","type":"string"}
			]}';
			$datapacket->add($filtroos);
		}
		
		if(isset($_REQUEST['ins_codigo']) && !empty($_REQUEST['ins_codigo'])){

			$filtroInsumo = '{"cod":"501290","params":[
				{"name":"ins_codigo","value":"'.$_REQUEST['ins_codigo'].'","type":"string"},
				{"name":"not_codigo","value":"'.$_REQUEST['not_codigo'].'","type":"string"}
			]}';
			$datapacket->add($filtroInsumo);
		}

	}
	
	$ret = $datapacket->open();
	$datapacket->clear();
	
	//print_r($datapacket->getLastQuery());
	
	echo "ok"; //String que confirma que não houve erros anteriormente (deve ser mantida)

?>