<?php
	header('Access-Control-Allow-Origin: *');
	header("Access-Control-Allow-Headers: Origin, X-Requested-With, Content-Type, Accept");

	session_start();
	
	include_once("../../class/uds/datapacket.php");
	include_once '../../sge/TParams.class.php';
	
	class CTe extends TParams{
	
		public $xml='<?xml version="1.0" encoding="UTF-8"?>';
		public $key='';
		public $cDV='';
		public $anomes='';
		
		private $company='';
		private $rowdata='';

		public function __construct($cte_nct,$emp_codigo){

			$TParams = get_called_class();

			$filtroCompany = '{"cod":"000604","params":[{"name":"emp_codigo","value":"'.$emp_codigo.'","type":"string"}]}';

			$dataPacket = new TDatapacket();
			$dataPacket->setToken($this::getToken('empresas'));
			$dataPacket->setUrl($TParams::$url);
			$dataPacket->add($filtroCompany);
			$ret = $dataPacket->open();
			$rowdataCompany = $dataPacket->getRowdata();
			$this->company = $rowdataCompany[0];

			$filtroRowdata = '{"cod":"000964","params":[{"name":"database","value":"'.$this->company->emp_db_comum.'","type":"other"},{"name":"cte_nct","value":"'.$cte_nct.'","type":"string"}]}';
			
			$dataPacket = new TDatapacket();
			$dataPacket->setToken($this::getToken($this->company->emp_db_sge));
			$dataPacket->setUrl($TParams::$url);
			$dataPacket->add($filtroRowdata);
			$ret = $dataPacket->open();
			$rowdata = $dataPacket->getRowdata();
			$this->rowdata = $rowdata[0];
			
			$this->anomes = date('ym');
			
		}
		
		public function getKeyDv($chave) {
			$soma_ponderada = 0;
			$multiplicadores = array(2,3,4,5,6,7,8,9);
			$i = 42;
			while ($i >= 0) {
				for ($m=0; $m<count($multiplicadores) && $i>=0; $m++) {
					$soma_ponderada+= $chave[$i] * $multiplicadores[$m];
					$i--;
				}
			}
			$resto = $soma_ponderada % 11;
			if ($resto == '0' || $resto == '1') {
				return 0;
			} else {
				return (11 - $resto);
		   }
		}		

		public function getKey($params='') {

			/*
			  · cUF - Código da UF do emitente do Documento Fiscal   2
			  · AAMM - Ano e Mês de emissão do CT-e 4
			  · CNPJ - CNPJ do emitente 14
			  · mod - Modelo do Documento Fiscal 2
			  · serie - Série do Documento Fiscal 3
			  · nCT - Número do Documento Fiscal 9
			  · tpEmis ? Forma de emissão do CT-e 1
			  · cCT - Código Numérico que compõe a Chave de Acesso 8
			  · cDV - Dígito Verificador da Chave de Acesso 1
			*/

			if($params){

				$obj 	= json_decode(base64_decode($params));
				$cUF	= $obj->cUF;
				$AAMM	= $obj->AAMM;
				$CNPJ	= $obj->CNPJ;
				$mod	= 57;
				$serie	= 1;
				$nCT	= $obj->nCT;
				$tpEmis	= $obj->tpEmis;
				$cCT	= $obj->cCT;

			}else{

				$cUF	= substr($this->company->emp_codmun,0,2);
				$AAMM	= substr($this->rowdata->cte_data,2,2).substr($this->rowdata->cte_data,5,2);
				$CNPJ	= $this->company->emp_cpfcnpj;
				$mod	= 57;
				$serie	= 1;
				$nCT	= $this->rowdata->cte_nct;
				$tpEmis	= 1;
				$cCT	= $this->rowdata->cte_codigo;
				
			}

			// 02 - cUF  - código da UF do emitente do Documento Fiscal
			$chave = sprintf("%02d", $cUF);

			// 04 - AAMM - Ano e Mes de emissão da NF-e
			$chave.= sprintf("%04s", $AAMM);

			// 14 - CNPJ - CNPJ do emitente
			$chave.= sprintf("%014s", $CNPJ);

			// 02 - mod  - Modelo do Documento Fiscal
			$chave.= sprintf("%02d", $mod);

			// 03 - serie - Série do Documento Fiscal
			$chave.= sprintf("%03d", $serie);

			// 09 - nCT  - Número do Documento Fiscal
			$chave.= sprintf("%09d", $nCT);

			// 01 - tpEmis  - Tipo emissão 
			$chave.= sprintf("%01d", $tpEmis);

			// 08 - cCT  - Código Numérico que compõe a Chave de Acesso // diminui 1 digito na versão 2.0
			$chave.= sprintf("%08d", $cCT);

			// 01 - cDV  - Dígito Verificador da Chave de Acesso
			$chave.= $this->getKeyDv($chave);
			
			return $chave;
		}
		
		public function getAliqIcms($uf){
			if($uf=='PR' || $uf=='SC' || $uf=='RS' || $uf=='MG' || $uf=='RJ' || $uf=='SP'){
				return 12;
			}else{
				return 7;
			}
		}
		
		public function getXML(){
			// if (!this.empresa) throw 'Dados da empresa não está definido';
			
			$nfe = json_decode(base64_decode($this->rowdata->cte_itens));
			$infNFe='';
			for($i=0;$i<count($nfe);$i++){
				$infNFe .= '<infNFe><chave>'.$nfe[$i][0].'</chave></infNFe>';
			}
			
			$hora 	  = explode("-",$this->rowdata->cte_hora);
			$novaHora = ''; 
			foreach($hora as $val){
				$novaHora .= str_pad($val,2,'0',STR_PAD_LEFT).":";
			}
			$novaHora = substr($novaHora,0,-1);
			
			// $this->xml .= '<cteProc versao="1.04" xmlns="http://www.portalfiscal.inf.br/cte">';
			$this->xml .= '<CTe xmlns="http://www.portalfiscal.inf.br/cte">';
			$this->xml .= '<infCte Id="CTe'.$this->getKey().'" versao="1.04">';
			$this->xml.='<ide>';
				$this->xml.='<cUF>'.substr($this->company->emp_codmun,0,2).'</cUF>';
				$this->xml.='<cCT>'.str_pad($this->rowdata->cte_codigo,8,'0',STR_PAD_LEFT).'</cCT>';
				$this->xml.='<CFOP>'.$this->rowdata->cfo_codigo.'</CFOP>';
				$this->xml.='<natOp>'.$this->rowdata->cte_natop.'</natOp>';
				$this->xml.='<forPag>'.$this->rowdata->cte_forpag.'</forPag>'; // 0-pago 1-a pagar ou 2-outros
				$this->xml.='<mod>57</mod>';
				$this->xml.='<serie>1</serie>';
				$this->xml.='<nCT>'.$this->rowdata->cte_nct.'</nCT>';
				$this->xml.='<dhEmi>'.$this->rowdata->cte_data.'T'.$novaHora.'</dhEmi>';
				$this->xml.='<tpImp>1</tpImp>';
				$this->xml.='<tpEmis>1</tpEmis>';
				$this->xml.='<cDV>'.$this->getKeyDv($this->getKey()).'</cDV>';
				$this->xml.='<tpAmb>2</tpAmb>';
				//$this->xml.='<tpAmb>'.$this->rowdata->cte_ambcte.'</tpAmb>';
				$this->xml.='<tpCTe>0</tpCTe>';
				$this->xml.='<procEmi>0</procEmi>';
				$this->xml.='<verProc>1</verProc>';
				// $this->xml.='<refCTe_Opc></refCTe_Opc>';
				$this->xml.='<cMunEnv>'.$this->company->emp_codmun.'</cMunEnv>';
				$this->xml.='<xMunEnv>'.$this->company->emp_cidade.'</xMunEnv>';
				$this->xml.='<UFEnv>'.$this->company->emp_uf.'</UFEnv>';
				$this->xml.='<modal>01</modal>';
				$this->xml.='<tpServ>'.$this->rowdata->cte_tpserv.'</tpServ>';
				$this->xml.='<cMunIni>'.$this->rowdata->cte_cmunini.'</cMunIni>';
				$this->xml.='<xMunIni>'.$this->rowdata->cte_xmunini.'</xMunIni>';
				$this->xml.='<UFIni>'.$this->rowdata->cte_ufini.'</UFIni>';
				$this->xml.='<cMunFim>'.$this->rowdata->cte_cmunfim.'</cMunFim>';
				$this->xml.='<xMunFim>'.$this->rowdata->cte_xmunfim.'</xMunFim>';
				$this->xml.='<UFFim>'.$this->rowdata->cte_uffim.'</UFFim>';
				$this->xml.='<retira>1</retira>';
				$this->xml.='<xDetRetira>Sera entregue no endereço do destinatario</xDetRetira>';
				$this->xml.='<toma03><toma>'.$this->rowdata->cad_toma.'</toma></toma03>';
			$this->xml.='</ide>';
			$this->xml.='<compl>';
				$this->xml.='<fluxo/>';
			$this->xml.='</compl>';
			$this->xml.='<emit>';
				$this->xml.='<CNPJ>'.$this->company->emp_cpfcnpj.'</CNPJ>';
				$this->xml.='<IE>'.$this->company->emp_inscrg.'</IE>';
				$this->xml.='<xNome>'.str_replace("&","",$this->company->emp_razao).'</xNome>';
				$this->xml.='<xFant>'.str_replace("&","",$this->company->emp_fantasia).'</xFant>';
				$this->xml.='<enderEmit>';
					$this->xml.='<xLgr>'.$this->company->emp_endereco.'</xLgr>';
					$this->xml.='<nro>'.$this->company->emp_num.'</nro>';
					$this->xml.='<xBairro>'.$this->company->emp_bairro.'</xBairro>';
					$this->xml.='<cMun>'.$this->company->emp_codmun.'</cMun>';
					$this->xml.='<xMun>'.$this->company->emp_cidade.'</xMun>';
					$this->xml.='<CEP>'.$this->company->emp_cep.'</CEP>';
					$this->xml.='<UF>'.$this->company->emp_uf.'</UF>';
					$this->xml.='<fone>'.str_replace(array('-','(',')'),array('','',''),$this->company->emp_fone).'</fone>';	
					// $this->xml.='<cPais>1058</cPais>';
					// $this->xml.='<xPais>BRASIL</xPais>';
				$this->xml.='</enderEmit>';
			$this->xml.='</emit>';

			$this->xml.='<rem>';
				if(strlen($this->rowdata->rem_cad_cnpjcpf)==11){
					$this->xml.='<CPF>'.$this->rowdata->rem_cad_cnpjcpf.'</CPF>';
					$this->xml.='<IE></IE>';
				}else{
					$this->xml.='<CNPJ>'.$this->rowdata->rem_cad_cnpjcpf.'</CNPJ>';
					$this->xml.='<IE>'.$this->rowdata->rem_cad_inscrg.'</IE>';
				}				
				$this->xml.='<xNome>'.str_replace("&","",$this->rowdata->rem_cad_nomeraz).'</xNome>';
				// $this->xml.='<xFant>'.$this->rowdata->emp_fantasia.'</xFant>';
				$this->xml.='<enderReme>';
					$this->xml.='<xLgr>'.$this->rowdata->rem_end_nome.'</xLgr>';
					$this->xml.='<nro>'.$this->rowdata->rem_end_num.'</nro>';
					$this->xml.='<xBairro>'.$this->rowdata->rem_end_bairro.'</xBairro>';
					$this->xml.='<cMun>'.$this->rowdata->rem_cad_codmun.'</cMun>';
					$this->xml.='<xMun>'.$this->rowdata->rem_cad_cidade.'</xMun>';
					$this->xml.='<UF>'.$this->rowdata->rem_cad_uf.'</UF>';
					// $this->xml.='<CEP>'.$this->rowdata->end_cep.'</CEP>';
					// $this->xml.='<fone>'.$this->rowdata->tel_ddd.$this->rowdata->tel_prefixo.$this->rowdata->tel_numero.'</fone>';
					$this->xml.='<cPais>1058</cPais>';
					$this->xml.='<xPais>BRASIL</xPais>';
			$this->xml.='</enderReme>';
			$this->xml.= $infNFe;
			$this->xml.='</rem>';
			$this->xml.='<dest>';
				if(strlen($this->rowdata->dest_cad_cnpjcpf)==11){
					$this->xml.='<CPF>'.$this->rowdata->dest_cad_cnpjcpf.'</CPF>';
					$this->xml.='<IE></IE>';
				}else{
					$this->xml.='<CNPJ>'.$this->rowdata->dest_cad_cnpjcpf.'</CNPJ>';
					$this->xml.='<IE>'.$this->rowdata->dest_cad_inscrg.'</IE>';
				}
				$this->xml.='<xNome>'.str_replace("&","",$this->rowdata->dest_cad_nomeraz).'</xNome>';
				// $this->xml.='<xFant>'.$this->rowdata->emp_fantasia.'</xFant>';
				$this->xml.='<enderDest>';
						$this->xml.='<xLgr>'.$this->rowdata->dest_end_nome.'</xLgr>';
						$this->xml.='<nro>'.$this->rowdata->dest_end_num.'</nro>';
						$this->xml.='<xBairro>'.$this->rowdata->dest_end_bairro.'</xBairro>';
						$this->xml.='<cMun>'.$this->rowdata->dest_cad_codmun.'</cMun>';
						$this->xml.='<xMun>'.$this->rowdata->dest_cad_cidade.'</xMun>';
						$this->xml.='<UF>'.$this->rowdata->dest_cad_uf.'</UF>';
						// $this->xml.='<CEP>'.$this->rowdata->dest_cad_cep.'</CEP>';
						// $this->xml.='<fone>'.$this->rowdata->emp_fone.'</fone>';
						$this->xml.='<cPais>1058</cPais>';
						$this->xml.='<xPais>BRASIL</xPais>';
				$this->xml.='</enderDest>';
			$this->xml.='</dest>';		
			$this->xml.='<vPrest>';		
				$this->xml.='<vTPrest>'.number_format($this->rowdata->cte_vtprest,2,'.','').'</vTPrest>';		
				$this->xml.='<vRec>'.number_format($this->rowdata->cte_vrec,2,'.','').'</vRec>';
				if($this->rowdata->cte_valpedagio>0){
					$this->xml.='<Comp>';
						$this->xml.='<xNome>PEDAGIO</xNome>';
						$this->xml.='<vComp>'.number_format($this->rowdata->cte_valpedagio,2,'.','').'</vComp>';
					$this->xml.='</Comp>';
				}
				if($this->rowdata->cte_valoutros>0){
					$this->xml.='<Comp>';
						$this->xml.='<xNome>OUTROS</xNome>';
						$this->xml.='<vComp>'.number_format($this->rowdata->cte_valoutros,2,'.','').'</vComp>';
					$this->xml.='</Comp>';
				}
			$this->xml.='</vPrest>';
			$this->xml.='<imp>';
				if($this->rowdata->cte_sitribu==1){
				
					$this->xml.='<ICMS>';
						$this->xml.='<ICMSSN>';
							$this->xml.='<indSN>1</indSN>';
						$this->xml.='</ICMSSN>';
					$this->xml.='</ICMS>';
					
				}else{
				
					$this->xml.='<ICMS>';
						$this->xml.='<ICMS00>';
							$this->xml.='<CST>00</CST>';
							$this->xml.='<vBC>'.$this->rowdata->cte_valfrete.'</vBC>';
							
							if($this->company->emp_codregtrib==3){
								if(substr($this->rowdata->cfo_codigo,0,1)==5){
									$pIcms=12;
								}else{
									$pIcms=$this->getAliqIcms($this->rowdata->dest_cad_uf);
								}
								$this->xml.='<pICMS>'.$pIcms.'</pICMS>';
								$this->xml.='<vICMS>'.substr(".",",",(($this->rowdata->cte_valfrete*$pIcms)/100)).'</vICMS>';
							}else{
								$this->xml.='<pICMS>0</pICMS>';
								$this->xml.='<vICMS>0</vICMS>';
							}
						$this->xml.='</ICMS00>';
					$this->xml.='</ICMS>';
					
				}
				$this->xml.='<vTotTrib>'.($this->rowdata->cte_valfrete*$pIcms).'</vTotTrib>';
				if(strlen($this->rowdata->cte_obs)>0)
					$this->xml.='<infAdFisco>'.$this->rowdata->cte_obs.'</infAdFisco>';
			$this->xml.='</imp>';
			$this->xml.='<infCTeNorm>';
				$this->xml.='<infCarga>';
					$this->xml.='<vCarga>'.$this->rowdata->cte_valfrete.'</vCarga>';
					$this->xml.='<proPred>'.$this->rowdata->cte_prodpred.'</proPred>';
					$this->xml.='<infQ>';
						$this->xml.='<cUnid>'.str_pad($this->rowdata->cte_unimedida,2,'0',STR_PAD_LEFT).'</cUnid>';
						$this->xml.='<tpMed>'.$this->rowdata->cte_tpmedida.'</tpMed>';
						$this->xml.='<qCarga>'.$this->rowdata->cte_qtdecarga.'</qCarga>';
					$this->xml.='</infQ>';
				$this->xml.='</infCarga>';
				$this->xml.='<seg>';
				$this->xml.='<respSeg>4</respSeg>';
				 // $this->xml.='<xSeg></xSeg>';
				/* se houver seguradora
				$this->xml.='<nApol></nApol>';
				$this->xml.='<nAver></nAver>';
				$this->xml.='<vCarga></vCarga>';
				*/
				$this->xml.='</seg>';
				$this->xml.='<infModal versaoModal="1.04">';
					$this->xml.='<rodo>';
						$this->xml.='<RNTRC>'.$this->company->emp_rntrc.'</RNTRC>';
						$this->xml.='<dPrev>'.$this->rowdata->cte_dtprev.'</dPrev>';
						$this->xml.='<lota>'.$this->rowdata->cte_lotacao.'</lota>';
						/*$this->xml.='<veic_Opc></veic_Opc>';
						$this->xml.='<cInt_Opc></cInt_Opc>';
						$this->xml.='<RENAVAM></RENAVAM>';
						$this->xml.='<placa></tara>';
						$this->xml.='<capKG></capKG>';
						$this->xml.='<capM3></capM3>';
						$this->xml.='<tpProp>P</capM3>';
						$this->xml.='<tpVeic>0</tpVeic>';
						$this->xml.='<tpRod></tpRod>';
						$this->xml.='<tpCar></tpCar>';
						$this->xml.='<UF></UF>';*/
					$this->xml.='</rodo>';
				$this->xml.='</infModal>';
			$this->xml.='</infCTeNorm>';
			$this->xml.='</infCte>';
			$this->xml.='</CTe>';
			return $this->xml;
		}
		
		public function getCompany(){
			return $this->company;
		}
		
		public function getRowdata(){
			return $this->rowdata;
		}

	}

	$CTe 	 = new CTe(243,'DEMO');
	
	$company = $CTe->getCompany();
	$rowdata = $CTe->getRowdata();
	
	

	$_SESSION['emp_codigo'] = $company->{'emp_codigo'};
	
	include_once "../libs/CTeNFePHP.class.php";

	$CTeTools = new CTeNFePHP();
	
	$acao 	 = 'transmitir';
	$param	 = $_REQUEST['param'];
	
	if($acao=='transmitir'){

		$cteDir = TParams::$uploads.'DEMO'.'/cte/';

		if(!is_dir($cteDir)){
			@mkdir($cteDir,0777);
		}
		
		if(!is_dir($cteDir.$CTe->anomes)){
			@mkdir($cteDir.$CTe->anomes,0777);
		}
		
		if(is_dir($cteDir.$CTe->anomes)){
			$xml = $CTeTools->signXML($CTe->getXml(),'infCte');
			$validacao = $CTeTools->validXML($CTe->getXml(),'../schemes/PL_CTE_104/cteModalRodoviario_v1.04.xsd');
			
			$nomeArquivo = $cteDir.$CTe->anomes.'/'.$CTe->getKey().'-cte.xml';

			$arquivoXML = fopen($nomeArquivo,'w+');
			fwrite($arquivoXML,$xml);
			fclose($arquivoXML);

			if($arquivoXML){

				$arrXML = Array();
				array_push($arrXML,$xml);

				$retorno = $CTeTools->sendLot($arrXML,'1'.$rowdata->cte_nct,'2');

				$dhRecbto = str_replace(array(":","/"),array("-","-"),$retorno['dhRecbto']);
				$arrDhRecbto = explode("-",$dhRecbto);
				$dhRecbto = substr($arrDhRecbto[2],0,-3)."-".$arrDhRecbto[1]."-".$arrDhRecbto[0]." ".substr($arrDhRecbto[2],-2)."-".$arrDhRecbto[3];
				
				if($retorno){

				
					sleep(2);
					$getProt = $CTeTools->getProtocol($retorno['nRec']);
					
					if($getProt['aProt'][0]['cStat']=='105'){
						sleep(4);
						$getProt = $CTeTools->getProtocol($retorno['nRec']);
					}
					
					if($retorno['bStat']==false){
						$retorno['bStat'] = 0;
					}
					
					if($getProt['aProt'][0]['tpAmb']==1){
						$tpAmb = 'producao';
					}else{
						$tpAmb = 'homologacao';
					}
					
					$nfefile 	= $nomeArquivo;
					$protfile 	= TParams::$hostRoot.'uploads/DEMO/cte/'.$tpAmb.'/temporarias/'.$getProt['aProt'][0]['chCTe'].'-prot.xml';
					
					if ($xml = $CTeTools->addProt($nfefile, $protfile)){
						sleep(2);
						file_put_contents($nomeArquivo, $xml);
					}
					
					if(!$getProt['aProt'][0]['cStat']){
						if(!$retorno['cStat']){
							$getProt['aProt'][0]['cStat']=0;
						}else{
							$getProt['aProt'][0]['cStat']=$retorno['cStat'];
						}
					}
					
					$filtroUpdt = '{"cod":"000965","params":[
						{"name":"cte_codigo","value":"'.$rowdata->cte_codigo.'","type":"string"},
						{"name":"cte_bstat","value":"'.$retorno['bStat'].'","type":"integer"},
						{"name":"cte_cstat","value":"'.$getProt['aProt'][0]['cStat'].'","type":"integer"},
						{"name":"cte_xmotivo","value":"'.base64_encode($retorno['xMotivo']).'","type":"string"},
						{"name":"cte_dhrecbto","value":"'.$dhRecbto.'","type":"string"},
						{"name":"cte_nrec","value":"'.$retorno['nRec'].'","type":"string"},
						{"name":"cte_key","value":"'.$getProt['aProt'][0]['chCTe'].'","type":"string"},';

					if($getProt['aProt'][0]['nProt']){
						$filtroUpdt .= '{"name":"cte_nprot","value":"'.$getProt['aProt'][0]['nProt'].'","type":"string"}';
					}else{
						$filtroUpdt .= '{"name":"cte_nprot","value":"","type":"null"}';
					}

					$filtroUpdt.=']}';

					$dataPacket = new TDatapacket();
					$dataPacket->setToken($CTe->getToken($company->emp_db_sge));
					$dataPacket->setUrl($CTe::$url);
					$dataPacket->add($filtroUpdt);
					$ret = $dataPacket->execute();
				
					$getProt['aProt'][0]['dvChCTe']=$CTe->getKeyDv($CTe->getKey());
					echo '{"CTe":'.json_encode($retorno).',';
					echo "\r\n";
					echo '"status":'.json_encode($getProt).',';
					echo "\r\n";
					echo '"debug":{"nfefile":"'.$nfefile.'","protfile":"'.$protfile.'","filtro":'.$filtroUpdt.'}}';
				}
			}
		}

	}elseif($acao=='atualizar'){

		$params = json_decode(base64_decode($param));
		
		$retorno = $CTeTools->getProtocol($params->nRec);
		
		$filtroUpdt = '{"cod":"000965","params":[
			{"name":"cte_codigo","value":"'.$params->cte_codigo.'","type":"string"},
			{"name":"cte_bstat","value":"'.$retorno['bStat'].'","type":"integer"},
			{"name":"cte_cstat","value":"'.$getProt['aProt'][0]['cStat'].'","type":"integer"},
			{"name":"cte_xmotivo","value":"'.base64_encode($getProt['aProt'][0]['xMotivo']).'","type":"string"},
			{"name":"cte_dhrecbto","value":"'.$dhRecbto.'","type":"string"},
			{"name":"cte_nrec","value":"'.$retorno['nRec'].'","type":"string"},
			{"name":"cte_key","value":"'.$getProt['aProt'][0]['chCTe'].'","type":"string"},';

		if($getProt['aProt'][0]['nProt']){
			$filtroUpdt .= '{"name":"cte_nprot","value":"'.$getProt['aProt'][0]['nProt'].'","type":"string"}';
		}else{
			$filtroUpdt .= '{"name":"cte_nprot","value":"","type":"null"}';
		}

		$filtroUpdt.=']}';

		$dataPacket = new TDatapacket();
		$dataPacket->setToken($CTe->getToken($company->emp_db_sge));
		$dataPacket->setUrl($CTe::$url);
		$dataPacket->add($filtroUpdt);
		$ret = $dataPacket->execute();
		
		echo '{"CTe":{"nRec":""},"status":'.json_encode($retorno).'}';

	}elseif($acao=='status'){

		print_r($CTeTools->statusServico('PR', '1', '2'));

	}elseif($acao=='dacte'){

		require_once('../libs/DacteNFePHP.class.php');

		$arq 	= TParams::$hostRoot.'uploads/'.$_SESSION['emp_codigo'].'/cte/'.$CTe->anomes.'/'.$param.'-cte.xml';
		if(is_file($arq)){
			$docxml = file_get_contents($arq);
			$dacte 	= $dacte = new DacteNFePHP($docxml, "P", "A4", "", 'I');
			$id 	= $dacte->montaDACTE('P','A4',$pdf,'');
			$teste 	= $dacte->printDACTE(TParams::$hostRoot.'uploads/'.$_SESSION['emp_codigo'].'/cte/'.$CTe->anomes.'/'.$id.'.pdf','F');
			echo '{"status":{"bStat":false,"cStat":"","xMotivo":"","aProt":[{"tpAmb":"","verAplic":"","chCTe":"'.$id.'","dhRecbto":"","nProt":"","digVal":"","cStat":"99999","xMotivo":"","dvChCTe":""}],"aCanc":"","print":true}}';
		}else{
			echo '{"status":{"bStat":false,"cStat":"","xMotivo":"O arquivo '.$arq.' não existe.","aProt":[{"tpAmb":"","verAplic":"","chCTe":"'.$id.'","dhRecbto":"","nProt":"","digVal":"","cStat":"99999","dvChCTe":""}],"aCanc":"","print":true}}';
		}
	}elseif($acao=='cancelar'){

		$params  = json_decode(base64_decode($param));
		$retorno = $CTeTools->cancelCT($params->chCTe, $params->nProt, $params->justificativa, '2');
		$dhRecbto = str_replace(":","-",$retorno['dhRecbto']);
		
		$filtro = '{"cod":"000969","params":[
			{"name":"cte_codigo",	"value":"'.$params->cte_codigo.'",	"type":"string"},
			{"name":"cte_bstat",	"value":"'.$retorno['bStat'].'",	"type":"integer"},
			{"name":"cte_cstat",	"value":"'.$retorno['cStat'].'",	"type":"integer"},
			{"name":"cte_xmotivo",	"value":"'.base64_encode($retorno['xMotivo']).'",	"type":"string"},
			{"name":"cte_dhrecbto",	"value":"'.$dhRecbto.'",			"type":"string"},
			{"name":"cte_nprot",	"value":"'.$retorno['nProt'].'",	"type":"string"}
		]}';
		
		$dataPacket = new TDatapacket();
		$dataPacket->setToken($CTe->getToken($company->emp_db_sge));
		$dataPacket->setUrl($CTe::$url);
		$dataPacket->add($filtro);
		$ret = $dataPacket->execute();
		
		echo '{"status":{"aProt":[{"bStat":"'.$retorno['bStat'].'","cStat":"'.$retorno['cStat'].'","xMotivo":"'.base64_encode($retorno['xMotivo']).'","dhRecbto":"'.$retorno['dhRecbto'].'","nProt":"'.$retorno['nProt'].'"}]}}';
	}
?>