<?php
	date_default_timezone_set('America/Sao_Paulo');
	header('Access-Control-Allow-Origin: *');
	header("Access-Control-Allow-Headers: Origin, X-Requested-With, Content-Type, Accept");
	
	include_once "../../TParams.class.php";

	class NFSe extends TParams{
	
		public $xml='';
		public $anomes='';
		public $nfs_codigo=0;
		public $nfs_nrorps=0;
		public $codmun="4115200";
		public $TParams;
		public $tpAmb='homologacao';
		public $dirAguardando = '';
		public $dirAutorizada = '';
		public $dirCancelada = '';
		public $dirDenegada = '';
		public $dirTemporaria = '';

		private $company='';
		private $rowdata='';
		private $priKEY='';
		private $pubKEY='';
		private $wsdl='';
		private $endpoint='';
		private $URLdsig = 'http://www.w3.org/2000/09/xmldsig#';
		private $URLCanonMeth = 'http://www.w3.org/TR/2001/REC-xml-c14n-20010315';
		private $URLSigMeth = 'http://www.w3.org/2000/09/xmldsig#rsa-sha1';
		private $URLTransfMeth_1 = 'http://www.w3.org/2000/09/xmldsig#enveloped-signature';
		private $URLTransfMeth_2 = 'http://www.w3.org/TR/2001/REC-xml-c14n-20010315';
		private $URLDigestMeth = 'http://www.w3.org/2000/09/xmldsig#sha1';
		
		public function __construct($nfs_codigo){
		
			$this->TParams = new TParams();
			
			$this->company = $this->TParams->getCompany();
			
			$this->priKEY = $this->TParams->getUploads().$this->company->emp_codigo.'/certificados/'.$this->company->emp_cpfcnpj.'_priKEY.pem';
			$this->pubKEY = $this->TParams->getUploads().$this->company->emp_codigo.'/certificados/'.$this->company->emp_cpfcnpj.'_pubKEY.pem';

			$filtroRps = '{"cod":"500001","params":[
				{"name":"nfs_codigo","value":"'.$nfs_codigo.'","type":"string"},
				{"name":"database","value":"'.$this->company->emp_db_comum.'","type":"other"}
			]}';
			$this->TParams->setHost($this->TParams->getHost($this->TParams->getDbSge()));
			$this->TParams->add($filtroRps);
			$ret = $this->TParams->open(true);
			$this->TParams->clear();
			$this->rowdata = $ret[0];
			$this->anomes = substr(date("Y",strtotime($this->rowdata->nfs_dtemissao)),0,4).date("m",strtotime($this->rowdata->nfs_dtemissao));
			$this->nfs_codigo=$nfs_codigo;
			$this->nfs_nrorps=$this->rowdata->nfs_nrorps;
			$this->tpAmb = 'homologacao';
			$this->codmun = $this->company->emp_codmun;
			
			if($this->company->emp_amb_nfse==1){
				$this->tpAmb = 'producao';
			}else{
				$this->tpAmb = 'homologacao';
			}
			//Maringá
			if($this->codmun=="4115200"){
				if($this->company->emp_amb_nfse==1){
					$this->wsdl = "https://nfse-ws.ecity.maringa.pr.gov.br/v2.01?wsdl";
					$this->endpoint = "https://nfse-ws.ecity.maringa.pr.gov.br/v2.01";
				}else{
					$this->wsdl = "https://nfse-ws.hom-ecity.maringa.pr.gov.br/v2.01?wsdl";
					$this->endpoint = "https://nfse-ws.hom-ecity.maringa.pr.gov.br/v2.01";
				}
			//Sarandi
			}elseif($this->codmun=="4126256"){
				// $this->wsdl = "https://sarandi.sigiss.com.br/sarandi/ws/sigiss_ws.php?wsdl";
				// $this->endpoint = "https://sarandi.sigiss.com.br/sarandi/ws/sigiss_ws.php";
				$this->endpoint = "https://sarandi.oxy.elotech.com.br/iss-ws/nfseService";
				$this->wsdl = "https://sarandi.oxy.elotech.com.br/iss-ws/nfse203.wsdl";
			//Paiçandu
			}elseif($this->codmun=="4117503"){
				$this->endpoint = "https://app.grupoautomacao.com/issonline-pmpa/servlet/anfse?wsdl";
			//Mandaguaçu/ jaragua do sul
			}elseif($this->codmun=="4114104" || $this->codmun=="4208906"){
				$this->URLCanonMeth = 'http://www.w3.org/2001/10/xml-exc-c14n#';
				if($this->company->emp_amb_nfse==1){
					$this->wsdl = "https://e-gov.betha.com.br/e-nota-contribuinte-ws/nfseWS?wsdl";
					$this->endpoint = "https://e-gov.betha.com.br/e-nota-contribuinte-ws/nfseWS";
				}else{
					$this->wsdl = "https://e-gov.betha.com.br/e-nota-contribuinte-test-ws/nfseWS?wsdl";
					$this->endpoint = "https://e-gov.betha.com.br/e-nota-contribuinte-test-ws/nfseWS";
				}
			//Doutor Camargo
			}elseif($this->codmun=="4107306"){
				$this->endpoint = "https://doutorcamargo.oxy.elotech.com.br/iss-ws/nfseService";
				$this->wsdl = "https://doutorcamargo.oxy.elotech.com.br/iss-ws/nfse203.wsdl";
			//Porto Rico
			}elseif($this->codmun=="4120200"){
				$this->endpoint = "https://portorico.oxy.elotech.com.br/iss-ws/nfseService";
				$this->wsdl = "https://portorico.oxy.elotech.com.br/iss-ws/nfse203.wsdl";
			//São Paulo
			}elseif($this->codmun=="3550308"){
				$this->endpoint = "https://nfe.prefeitura.sp.gov.br/ws/lotenfe.asmx";
				$this->wsdl = "https://nfe.prefeitura.sp.gov.br/ws/lotenfe.asmx?WSDL";
			//Uniflor
			}elseif($this->codmun=="4128302"){
				if($this->company->emp_amb_nfse==1){
					$this->endpoint = "https://www.esnfs.com.br:8444/enfsws/services/Enfs";
					$this->wsdl = "https://www.esnfs.com.br:8444/enfsws/services/Enfs?wsdl";
				}else{
					$this->endpoint = "https://www.esnfs.com.br:9444/homologacaows/services/Enfs";
					$this->wsdl = "https://www.esnfs.com.br:9444/homologacaows/services/Enfs?wsdl";
				}
			}else{
				exit("Municipio nao suportado!");
			}
			
			// estrutura de pastas para armazenamento da nfse
			$this->dirAguardando = $this->TParams->getUploads().$this->company->emp_codigo.'/nfse/'.$this->tpAmb.'/aguardando/';
			$this->dirAutorizada = $this->TParams->getUploads().$this->company->emp_codigo.'/nfse/'.$this->tpAmb.'/autorizadas/';
			$this->dirCancelada  = $this->TParams->getUploads().$this->company->emp_codigo.'/nfse/'.$this->tpAmb.'/canceladas/';
			$this->dirTemporaria = $this->TParams->getUploads().$this->company->emp_codigo.'/nfse/'.$this->tpAmb.'/temporarias/';
			if(!is_dir($this->TParams->getUploads().$this->company->emp_codigo)){
				@mkdir($this->TParams->getUploads().$this->company->emp_codigo, 0777, true);
			}
			if(!is_dir($this->TParams->getUploads().$this->company->emp_codigo.'/nfse/')){
				@mkdir($this->TParams->getUploads().$this->company->emp_codigo.'/nfse/', 0777, true);
			}
			if(!is_dir($this->TParams->getUploads().$this->company->emp_codigo.'/nfse/'.$this->tpAmb)){
				@mkdir($this->TParams->getUploads().$this->company->emp_codigo.'/nfse/'.$this->tpAmb, 0777, true);
			}
			if(!is_dir($this->dirAguardando.$this->anomes)){
				@mkdir($this->dirAguardando.$this->anomes, 0777, true);
			}
			if(!is_dir($this->dirAguardando.$this->anomes)){
				@mkdir($this->dirAguardando.$this->anomes, 0777, true);
			}
			if(!is_dir($this->dirAutorizada.$this->anomes)){
				@mkdir($this->dirAutorizada.$this->anomes, 0777, true);
			}
			if(!is_dir($this->dirCancelada.$this->anomes)){
				@mkdir($this->dirCancelada.$this->anomes, 0777, true);
			}
			if(!is_dir($this->dirTemporaria.$this->anomes)){
				@mkdir($this->dirTemporaria.$this->anomes, 0777, true);
			}
			
		}
		
		public function getXML(){
			
			$array1 = array("á", "à", "ã", "â", "Á", "À", "Ã", "Â", "é", "ê", "É", "Ê", "í", "Í", "ó", "õ", "ô", "Ó", "Ô", "Õ", "ú", "ü", "Ú", "Ü", "ç", "Ç", "º", "ª", "\"", "'", "&", ";", "\n", "<br>", "<br/>");
			$array2 = array("a", "a", "a", "a", "A", "A", "A", "A", "e", "e", "E", "E", "i", "I", "o", "o", "o", "O", "O", "O", "u", "u", "U", "U", "c", "C", "", "", "", "", "E", "", " ", " ", " ");
			
			//Maringá
			if($this->codmun=="4115200"){
				
				$this->xml .= '<EnviarLoteRpsSincronoEnvio xmlns="http://www.abrasf.org.br/nfse.xsd" xmlns:ds="http://www.w3.org/2000/09/xmldsig#" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://www.abrasf.org.br/nfse.xsd nfse_v2.01.xsd ">';
				$this->xml .= '<LoteRps Id="L1" versao="2.01">';
					$this->xml .= '<NumeroLote>'.str_pad($this->company->emp_nfselote, 6, "0", STR_PAD_LEFT).'</NumeroLote>';
					$this->xml .= '<CpfCnpj>
												<Cnpj>'.$this->company->emp_cpfcnpj.'</Cnpj>
											</CpfCnpj>';
					$this->xml .= '<InscricaoMunicipal>'.$this->company->emp_inscrmun.'</InscricaoMunicipal>';
					$this->xml .= '<QuantidadeRps>1</QuantidadeRps>';
					$this->xml .= '<ListaRps>';
						$this->xml .= '<Rps>';
							$this->xml .= '<InfDeclaracaoPrestacaoServico>';
								$this->xml .= '<Rps Id="R1">';
									$this->xml .= '<IdentificacaoRps>';
										$this->xml .= '<Numero>'.$this->rowdata->nfs_nrorps.'</Numero>';
										$this->xml .= '<Serie>'.$this->rowdata->nfs_serierps.'</Serie>';
										$this->xml .= '<Tipo>'.$this->rowdata->nfs_tiporps.'</Tipo>';
									$this->xml .= '</IdentificacaoRps>';
									$this->xml .= '<DataEmissao>'.substr($this->rowdata->nfs_dtemissao,0,10).'</DataEmissao>';
									$this->xml .= '<Status>1</Status>';
								$this->xml .= '</Rps>';
								// $this->xml .= '<Competencia>'.substr($this->rowdata->nfs_dtprestacao,0,10).'</Competencia>';
								$this->xml .= '<Competencia>'.substr($this->rowdata->nfs_dtemissao,0,10).'</Competencia>';
								$this->xml .= '<Servico>';
									$this->xml .= '<Valores>';
										$this->xml .= ($this->rowdata->nfs_vlrservico>0) ? '<ValorServicos>'.number_format($this->rowdata->nfs_vlrservico,2,".","").'</ValorServicos>' : '<ValorServicos>0.00</ValorServicos>';
										$this->xml .= ($this->rowdata->nfs_vlrdeducao>0) ? '<ValorDeducoes>'.number_format($this->rowdata->nfs_vlrdeducao,2,".","").'</ValorDeducoes>' : '<ValorDeducoes>0.00</ValorDeducoes>';
										$this->xml .= ($this->rowdata->nfs_vlrpis>0) ? '<ValorPis>'.number_format($this->rowdata->nfs_vlrpis,2,".","").'</ValorPis>' : '<ValorPis>0.00</ValorPis>';
										$this->xml .= ($this->rowdata->nfs_vlrcofins>0) ? '<ValorCofins>'.number_format($this->rowdata->nfs_vlrcofins,2,".","").'</ValorCofins>' : '<ValorCofins>0.00</ValorCofins>';
										$this->xml .= ($this->rowdata->nfs_vlrinss>0) ? '<ValorInss>'.number_format($this->rowdata->nfs_vlrinss,2,".","").'</ValorInss>' : '<ValorInss>0.00</ValorInss>';
										$this->xml .= ($this->rowdata->nfs_vlrir>0) ? '<ValorIr>'.number_format($this->rowdata->nfs_vlrir,2,".","").'</ValorIr>' : '<ValorIr>0.00</ValorIr>';
										$this->xml .= ($this->rowdata->nfs_vlrcsll>0) ? '<ValorCsll>'.number_format($this->rowdata->nfs_vlrcsll,2,".","").'</ValorCsll>' : '<ValorCsll>0.00</ValorCsll>';
										// $this->xml .= ($this->rowdata->nfs_vlrissret>0) ? '<OutrasRetencoes>'.number_format($this->rowdata->nfs_vlrissret,2,".","").'</OutrasRetencoes>' : '<OutrasRetencoes>0.00</OutrasRetencoes>';
										$this->xml .= '<OutrasRetencoes>0.00</OutrasRetencoes>';
										$this->xml .= ($this->rowdata->nfs_vlriss>0) ? '<ValorIss>'.number_format($this->rowdata->nfs_vlriss,2,".","").'</ValorIss>' : '<ValorIss>0.00</ValorIss>';
										$this->xml .= ($this->rowdata->nfs_aliqiss>0) ? '<Aliquota>'.number_format($this->rowdata->nfs_aliqiss,0,"","").'</Aliquota>' : '<Aliquota>0.00</Aliquota>';
										$this->xml .= ($this->rowdata->nfs_descincond>0) ? '<DescontoIncondicionado>'.number_format($this->rowdata->nfs_descincond,2,".","").'</DescontoIncondicionado>' : '<DescontoIncondicionado>0.00</DescontoIncondicionado>';
										$this->xml .= ($this->rowdata->nfs_desccond>0) ? '<DescontoCondicionado>'.number_format($this->rowdata->nfs_desccond,2,".","").'</DescontoCondicionado>' : '<DescontoCondicionado>0.00</DescontoCondicionado>';
									$this->xml .= '</Valores>';
									$this->xml .= '<IssRetido>'.$this->rowdata->nfs_issret.'</IssRetido>';
									$this->xml .= ($this->rowdata->nfs_issret==1) ? '<ResponsavelRetencao>1</ResponsavelRetencao>' : '';
									$this->xml .= '<ItemListaServico>'.$this->rowdata->nfs_coditnlistserv.'</ItemListaServico>';
									$this->xml .= '<CodigoCnae>'.$this->company->emp_cnae.'</CodigoCnae>';
									$this->xml .= '<CodigoTributacaoMunicipio>'.$this->rowdata->nfs_coditnlistserv.'</CodigoTributacaoMunicipio>';
									$this->xml .= '<Discriminacao>'.strip_tags(str_replace($array1, $array2, utf8_encode(base64_decode($this->rowdata->nfs_descrserv)))).'</Discriminacao>';
									$this->xml .= '<CodigoMunicipio>'.$this->company->emp_codmun.'</CodigoMunicipio>';
									$this->xml .= '<CodigoPais>1058</CodigoPais>';
									$this->xml .= '<ExigibilidadeISS>'.$this->rowdata->nfs_exigibilidadeiss.'</ExigibilidadeISS>';
									$this->xml .= (isset($this->rowdata->nfs_codmun) && $this->rowdata->nfs_codmun!="") ? '<MunicipioIncidencia>'.$this->rowdata->nfs_codmun.'</MunicipioIncidencia>' : '<MunicipioIncidencia>'.$this->company->emp_codmun.'</MunicipioIncidencia>';
									// $this->xml .= '<NumeroProcesso>38300/2012</NumeroProcesso>';
								$this->xml .= '</Servico>';
								$this->xml .= '<Prestador>';
									$this->xml .= '<CpfCnpj>';
									$this->xml .= '<Cnpj>'.$this->company->emp_cpfcnpj.'</Cnpj>';
									$this->xml .= '</CpfCnpj>';
									$this->xml .= '<InscricaoMunicipal>'.$this->company->emp_inscrmun.'</InscricaoMunicipal>';
								$this->xml .= '</Prestador>';
								$this->xml .= '<Tomador>';
									$this->xml .= '<IdentificacaoTomador>';
										$this->xml .= '<CpfCnpj>';
										if(strlen($this->rowdata->tom_cnpjcpf)==14){
											$this->xml .= '<Cnpj>'.$this->rowdata->tom_cnpjcpf.'</Cnpj>';
										}else{
											$this->xml .= '<Cpf>'.$this->rowdata->tom_cnpjcpf.'</Cpf>';
										}
										$this->xml .= '</CpfCnpj>';
										// $this->xml .= '<InscricaoMunicipal>0</InscricaoMunicipal>';
									$this->xml .= '</IdentificacaoTomador>';
									$this->xml .= '<RazaoSocial>'.str_replace($array1, $array2, $this->rowdata->tom_nomeraz).'</RazaoSocial>';
									$this->xml .= '<Endereco>';
										$this->xml .= '<Endereco>'.str_replace($array1, $array2, $this->rowdata->end_nome).'</Endereco>';
										$this->xml .= '<Numero>'.str_replace($array1, $array2, $this->rowdata->end_num).'</Numero>';
										$this->xml .= (isset($this->rowdata->end_compl) && $this->rowdata->end_compl!="") ? '<Complemento>'.str_replace($array1, $array2, $this->rowdata->end_compl).'</Complemento>' : '';
										$this->xml .= '<Bairro>'.str_replace($array1, $array2, $this->rowdata->end_bairro).'</Bairro>';
										$this->xml .= '<CodigoMunicipio>'.$this->rowdata->tom_codmun.'</CodigoMunicipio>';
										$this->xml .= '<Uf>'.$this->rowdata->end_uf.'</Uf>';
										$this->xml .= '<CodigoPais>1058</CodigoPais>';
										$this->xml .= '<Cep>'.$this->rowdata->end_cep.'</Cep>';
									$this->xml .= '</Endereco>';
									$this->xml .= '<Contato>';
										$this->xml .= '<Telefone>'.$this->rowdata->tel_ddd.$this->rowdata->tel_prefixo.$this->rowdata->tel_numero.'</Telefone>';
										$this->xml .= ($this->rowdata->tom_email && $this->rowdata->tom_email!="") ? '<Email>'.trim($this->rowdata->tom_email).'</Email>' : '';
									$this->xml .= '</Contato>';
								$this->xml .= '</Tomador>';
								/*
								$this->xml .= '<Intermediario>';
									$this->xml .= '<IdentificacaoIntermediario>';
									$this->xml .= '<CpfCnpj>';
									$this->xml .= '<Cnpj>63402328000154</Cnpj>';
									$this->xml .= '</CpfCnpj>';
									$this->xml .= '<InscricaoMunicipal>0</InscricaoMunicipal>';
									$this->xml .= '</IdentificacaoIntermediario>';
									$this->xml .= '<RazaoSocial>INTERMEDIARIO TESTE 10367</RazaoSocial>';
								$this->xml .= '</Intermediario>';
								$this->xml .= '<ConstrucaoCivil>';
									$this->xml .= '<CodigoObra>999999</CodigoObra>';
									$this->xml .= '<Art>ART9999</Art>';
								$this->xml .= '</ConstrucaoCivil>';
								*/
								$this->xml .= ($this->company->emp_codregtrib==3) ? '' : '<RegimeEspecialTributacao>6</RegimeEspecialTributacao>';
								$this->xml .= ($this->company->emp_codregtrib==3) ? '<OptanteSimplesNacional>2</OptanteSimplesNacional>' : '<OptanteSimplesNacional>1</OptanteSimplesNacional>';
								$this->xml .= '<IncentivoFiscal>2</IncentivoFiscal>';
							$this->xml .= '</InfDeclaracaoPrestacaoServico>';
						$this->xml .= '</Rps>';
					$this->xml .= '</ListaRps>';
				$this->xml.='</LoteRps>';
				$this->xml.='</EnviarLoteRpsSincronoEnvio>';
				
			// Antigo Sarandi
			}elseif($this->codmun=="3749743932743243"){
				
				$sit = "tp";
				if($this->rowdata->nfs_exigibilidadeiss==1){
					if($this->rowdata->nfs_responsavel==2){
						// $sit="tt";
						$sit="tp";
					}
				}else{
					$sit="is";
				}
				$tipo = (strlen($this->rowdata->tom_cnpjcpf)==11) ? "2" : "3";
				$this->xml .= '<DescricaoRps>';
					$this->xml .= '<ccm>'.$this->company->emp_inscrmun.'</ccm>';
					$this->xml .= '<cnpj>'.$this->company->emp_cpfcnpj.'</cnpj>';
					$this->xml .= '<senha>'.$this->company->emp_path_acbr.'</senha>';
					$this->xml .= ($this->company->emp_codigo=='ORIGINALLUB') ? '' : '<aliquota_simples>'.$this->rowdata->nfs_aliqiss.'</aliquota_simples>';
					$this->xml .= '<id_sis_legado>'.$this->rowdata->nfs_nrorps.'</id_sis_legado>';
					$this->xml .= '<servico>'.$this->rowdata->nfs_coditnlistserv.'</servico>';
					$this->xml .= '<situacao>'.$sit.'</situacao>';
					$this->xml .= '<valor>'.number_format($this->rowdata->nfs_vlrservico, 2, ",", "").'</valor>';
					$this->xml .= '<base>'.number_format(($this->rowdata->nfs_vlrservico-$this->rowdata->nfs_vlrdeducao), 2, ",", "").'</base>';
					$this->xml .= '<descricaoNF>'.strip_tags(str_replace($array1, $array2, utf8_encode(base64_decode($this->rowdata->nfs_descrserv)))).'</descricaoNF>';
					$this->xml .= '<tomador_tipo>'.$tipo.'</tomador_tipo>';
					$this->xml .= '<tomador_cnpj>'.$this->rowdata->tom_cnpjcpf.'</tomador_cnpj>';
					// $this->xml .= '<tomador_im>?</tomador_im>';
					$this->xml .= '<tomador_razao>'.str_replace($array1, $array2, $this->rowdata->tom_nomeraz).'</tomador_razao>';
					// $this->xml .= '<tomador_fantasia>?</tomador_fantasia>';
					$this->xml .= '<tomador_endereco>'.str_replace($array1, $array2, $this->rowdata->end_nome).'</tomador_endereco>';
					$this->xml .= '<tomador_numero>'.str_replace($array1, $array2, $this->rowdata->end_num).'</tomador_numero>';
					$this->xml .= ($this->rowdata->end_compl && $this->rowdata->end_compl!="") ? '<tomador_complemento>'.str_replace($array1, $array2, $this->rowdata->end_compl).'</tomador_complemento>' : '';
					$this->xml .= '<tomador_bairro>'.str_replace($array1, $array2, $this->rowdata->end_bairro).'</tomador_bairro>';
					$this->xml .= '<tomador_CEP>'.$this->rowdata->end_cep.'</tomador_CEP>';
					$this->xml .= '<tomador_cod_cidade>'.$this->rowdata->tom_codmun.'</tomador_cod_cidade>';
					$this->xml .= '<tomador_fone>'.$this->rowdata->tel_ddd.$this->rowdata->tel_prefixo.$this->rowdata->tel_numero.'</tomador_fone>';
					$this->xml .= '<rps_num>'.$this->rowdata->nfs_nrorps.'</rps_num>';
					$this->xml .= '<rps_serie>'.$this->rowdata->nfs_serierps.'</rps_serie>';
					$this->xml .= '<rps_dia>'.substr($this->rowdata->nfs_dtemissao, 8, 2).'</rps_dia>';
					$this->xml .= '<rps_mes>'.substr($this->rowdata->nfs_dtemissao, 5, 2).'</rps_mes>';
					$this->xml .= '<rps_ano>'.substr($this->rowdata->nfs_dtemissao, 0, 4).'</rps_ano>';
					$this->xml .= ($this->rowdata->nfs_issret==1) ? '<retencao_iss>'.$this->rowdata->nfs_vlriss.'</retencao_iss>' : '';
					$this->xml .= ($this->rowdata->nfs_vlrpis>0) ? '<pis>'.$this->rowdata->nfs_vlrpis.'</pis>' : '';
					$this->xml .= ($this->rowdata->nfs_vlrcofins>0) ? '<cofins>'.$this->rowdata->nfs_vlrcofins.'</cofins>' : '';
					$this->xml .= ($this->rowdata->nfs_vlrinss>0) ? '<inss>'.$this->rowdata->nfs_vlrinss.'</inss>' : '';
					$this->xml .= ($this->rowdata->nfs_vlrir>0) ? '<irrf>'.$this->rowdata->nfs_vlrir.'</irrf>' : '';
					$this->xml .= ($this->rowdata->nfs_vlrcsll>0) ? '<csll>'.$this->rowdata->nfs_vlrcsll.'</csll>' : '';
				$this->xml .= '</DescricaoRps>';
		  
			//Paiçandu
			}elseif($this->codmun=="4117503"){
				
				$this->xml.= '<NFSE>';
				$this->xml.= '<IDENTIFICACAO>';
				$this->xml.= '<MESCOMP>'.substr($this->rowdata->nfs_dtprestacao,5,2).'</MESCOMP>';
				$this->xml.= '<ANOCOMP>'.substr($this->rowdata->nfs_dtprestacao,0,4).'</ANOCOMP>';
				$this->xml.= '<INSCRICAO>'.$this->company->emp_inscrmun.'</INSCRICAO>';
				$this->xml.= '<VERSAO>1.00</VERSAO>';
				$this->xml.= '</IDENTIFICACAO>';
				$this->xml.= '<NOTAS>';
					$this->xml.= '<NOTA>';
						$this->xml.= '<RPS>0000-0000-'.str_pad($this->rowdata->nfs_nrorps, 4, '0', STR_PAD_LEFT).'</RPS>';
						$this->xml.= '<LOTE>'.$this->company->emp_nfselote.'</LOTE>';
						$this->xml.= '<SEQUENCIA>'.$this->rowdata->nfs_nrorps.'</SEQUENCIA>';
						$this->xml.= '<DATAEMISSAO>'.implode("/", array_reverse( explode("-", substr($this->rowdata->nfs_dtemissao,0,10)))).'</DATAEMISSAO>';
						$this->xml.= '<HORAEMISSAO>'.substr($this->rowdata->nfs_dtemissao,11).'</HORAEMISSAO>';
						$this->xml.= '<LOCAL>D</LOCAL>';
						// $this->xml.= '<UFFORA>UF</UFFORA>';
						// $this->xml.= '<MUNICIPIOFORA>Município</MUNICIPIOFORA>';
						// $this->xml.= '<PAISFORA>País</PAISFORA>';
						$this->xml.= ( $this->company->emp_codregtrib==3 ) ? '<SITUACAO>1</SITUACAO>' : '<SITUACAO>2</SITUACAO>';
						$this->xml.= ($this->rowdata->nfs_responsavel==2) ? '<RETIDO>S</RETIDO>' : '<RETIDO>N</RETIDO>';
						$this->xml.= '<ATIVIDADE>'.substr($this->rowdata->nfs_coditnlistserv, 0, 2).'.'.substr($this->rowdata->nfs_coditnlistserv, 2).'</ATIVIDADE>';
						$this->xml.= '<ALIQUOTAAPLICADA>'.number_format($this->rowdata->nfs_aliqiss, 2, ".","").'</ALIQUOTAAPLICADA>';
						$this->xml.= '<DEDUCAO>'.number_format($this->rowdata->nfs_vlrdeducao, 2, ".","").'</DEDUCAO>';
						$this->xml.= '<IMPOSTO>'.number_format($this->rowdata->nfs_vlriss, 2, ".","").'</IMPOSTO>';
						$this->xml.= ($this->rowdata->nfs_responsavel==2) ? '<RETENCAO>'.number_format($this->rowdata->nfs_vlrissret, 2, ".","").'</RETENCAO>' : '<RETENCAO>0.00</RETENCAO>';
						$this->xml.= '<OBSERVACAO></OBSERVACAO>';
						$this->xml.= '<CPFCNPJ>'.$this->rowdata->tom_cnpjcpf.'</CPFCNPJ>';
						// $this->xml.= '<RGIE></RGIE>';
						$this->xml.= '<NOMERAZAO>'.str_replace($array1, $array2, $this->rowdata->tom_nomeraz).'</NOMERAZAO>';
						$this->xml.= '<NOMEFANTASIA>'.str_replace($array1, $array2, $this->rowdata->tom_nomeraz).'</NOMEFANTASIA>';
						$this->xml.= '<MUNICIPIO>'.$this->rowdata->tom_codmun.'</MUNICIPIO>';
						$this->xml.= '<BAIRRO>'.str_replace($array1, $array2, $this->rowdata->end_bairro).'</BAIRRO>';
						$this->xml.= '<CEP>'.$this->rowdata->end_cep.'</CEP>';
						$this->xml.= '<PREFIXO>RUA</PREFIXO>';
						$this->xml.= '<LOGRADOURO>'.str_replace($array1, $array2, $this->rowdata->end_nome).'</LOGRADOURO>';
						$this->xml.= (isset($this->rowdata->end_compl)) ? '<COMPLEMENTO>'.str_replace($array1, $array2, $this->rowdata->end_compl).'</COMPLEMENTO>' : '';
						$this->xml.= '<NUMERO>'.$this->rowdata->end_num.'</NUMERO>';
						// $this->xml.= '<EMAIL></EMAIL>';
						$this->xml.= '<DENTROPAIS>S</DENTROPAIS>';
						// $this->xml.= '<DEDMATERIAIS>N</DEDMATERIAIS>';
						// $this->xml.= '<CONTRAAPRESENTACAO>N</CONTRAAPRESENTACAO>';
						$this->xml.= '<PIS>'.number_format($this->rowdata->nfs_vlrpis, 2, ".","").'</PIS>';
						$this->xml.= '<COFINS>'.number_format($this->rowdata->nfs_vlrcofins, 2, ".","").'</COFINS>';
						$this->xml.= '<INSS>'.number_format($this->rowdata->nfs_vlrinss, 2, ".","").'</INSS>';
						$this->xml.= '<IR>'.number_format($this->rowdata->nfs_vlrir, 2, ".","").'</IR>';
						$this->xml.= '<CSLL>'.number_format($this->rowdata->nfs_vlrcsll, 2, ".","").'</CSLL>';
						$this->xml.= '<OUTRASRETENCOES>0.00</OUTRASRETENCOES>';
						// $this->xml.= '<OBRA>Obra</OBRA>';
						$this->xml.= '<SERVICOS>';
							$this->xml.= '<SERVICO>';
								$this->xml.= '<DESCRICAO>'.substr(strip_tags(str_replace($array1, $array2, utf8_encode(base64_decode($this->rowdata->nfs_descrserv)))), 0, 100).'</DESCRICAO>';
								$this->xml.= '<VALORUNIT>'.number_format($this->rowdata->nfs_vlrservico, 2, ".","").'</VALORUNIT>';
								$this->xml.= '<QUANTIDADE>01</QUANTIDADE>';
							$this->xml.= '</SERVICO>';
						$this->xml.= '</SERVICOS>';
					$this->xml.= '</NOTA>';
				$this->xml.= '</NOTAS>';
				$this->xml.= '</NFSE>';
				/*
				if($this->rowdata->nfs_exigibilidadeiss==1){
					$natOp="1";
				}else{
					$natOp="2";
				}
				
				$this->xml.= '<sis:GerarNovaNfseEnvio>';
				$this->xml.= '<nfse:Prestador>';
				   $this->xml.= '<nfse:Cnpj>'.$this->company->emp_cpfcnpj.'</nfse:Cnpj>';
				   $this->xml.= '<nfse:InscricaoMunicipal>'.$this->company->emp_inscrmun.'</nfse:InscricaoMunicipal>';
				$this->xml.= '</nfse:Prestador>';
				$this->xml.= '<nfse:InformacaoNfse id="L1">';
				   $this->xml.= '<nfse:NaturezaOperacao>'.$natOp.'</nfse:NaturezaOperacao>';
				   $this->xml.= '<nfse:RegimeEspecialTributacao>6</nfse:RegimeEspecialTributacao>';
				   $this->xml.= ($this->company->emp_codregtrib==3) ? '<nfse:OptanteSimplesNacional>2</nfse:OptanteSimplesNacional>' : '<nfse:OptanteSimplesNacional>1</nfse:OptanteSimplesNacional>';
				   $this->xml.= '<nfse:IncentivadorCultural>2</nfse:IncentivadorCultural>';
				   $this->xml.= '<nfse:Status>1</nfse:Status>';
				   $this->xml.= '<nfse:Competencia>'.substr($this->rowdata->nfs_dtprestacao,0,10).'</nfse:Competencia>';
				   // $this->xml.= '<nfse:NfseSubstituida></nfse:NfseSubstituida>';
				   // $this->xml.= '<nfse:OutrasInformacoes></nfse:OutrasInformacoes>';
				   $this->xml.= '<nfse:Servico>';
					  $this->xml.= '<nfse:Valores>';
						 $this->xml.= '<nfse:ValorServicos>'.number_format($this->rowdata->nfs_vlrservico, 2, ".","").'</nfse:ValorServicos>';
						 $this->xml.= '<nfse:ValorDeducoes>'.number_format($this->rowdata->nfs_vlrdeducao, 2, ".","").'</nfse:ValorDeducoes>';
						 $this->xml.= '<nfse:ValorPis>'.number_format($this->rowdata->nfs_vlrpis, 2, ".","").'</nfse:ValorPis>';
						 $this->xml.= '<nfse:ValorCofins>'.number_format($this->rowdata->nfs_vlrcofins, 2, ".","").'</nfse:ValorCofins>';
						 $this->xml.= '<nfse:ValorInss>'.number_format($this->rowdata->nfs_vlrinss, 2, ".","").'</nfse:ValorInss>';
						 $this->xml.= '<nfse:ValorIr>'.number_format($this->rowdata->nfs_vlrir, 2, ".","").'</nfse:ValorIr>';
						 $this->xml.= '<nfse:ValorCsll>'.number_format($this->rowdata->nfs_vlrcsll, 2, ".","").'</nfse:ValorCsll>';
						 $this->xml.= ($this->rowdata->nfs_responsavel==2) ? '<nfse:IssRetido>1</nfse:IssRetido>' : '<nfse:IssRetido>2</nfse:IssRetido>';
						 $this->xml.= '<nfse:ValorIss>'.number_format($this->rowdata->nfs_vlriss, 2, ".","").'</nfse:ValorIss>';
						 $this->xml.= ($this->rowdata->nfs_responsavel==2) ? '<nfse:ValorIssRetido>'.number_format($this->rowdata->nfs_vlrissret, 2, ".","").'</nfse:ValorIssRetido>' : '';
						 $this->xml.= '<nfse:BaseCalculo>'.number_format(($this->rowdata->nfs_vlrservico-$this->rowdata->nfs_vlrdeducao), 2, ".","").'</nfse:BaseCalculo>';
						 $this->xml.= '<nfse:Aliquota>'.number_format($this->rowdata->nfs_aliqiss, 2, ".","").'</nfse:Aliquota>';
						 $this->xml.= '<nfse:ValorLiquidoNfse>'.number_format($this->rowdata->nfs_vlrservico - ($this->rowdata->nfs_vlrpis+$this->rowdata->nfs_vlrcofins+$this->rowdata->nfs_vlrinss+$this->rowdata->nfs_vlrir+$this->rowdata->nfs_vlrcsll+$this->rowdata->nfs_vlrissret), 2, ".","").'</nfse:ValorLiquidoNfse>';
						 // $this->xml.= '<nfse:DescontoIncondicionado>?</nfse:DescontoIncondicionado>';
						 // $this->xml.= '<nfse:DescontoCondicionado>?</nfse:DescontoCondicionado>';
					  $this->xml.= '</nfse:Valores>';
					  $this->xml.= '<nfse:ItemListaServico>'.substr($this->rowdata->nfs_coditnlistserv,0,2).".".substr($this->rowdata->nfs_coditnlistserv,2,2).'</nfse:ItemListaServico>';
					  $this->xml.= '<nfse:CodigoCnae>'.$this->company->emp_cnae.'</nfse:CodigoCnae>';
					  $this->xml.= '<nfse:CodigoTributacaoMunicipio>'.substr($this->rowdata->nfs_coditnlistserv,0,2).".".substr($this->rowdata->nfs_coditnlistserv,2,2).'</nfse:CodigoTributacaoMunicipio>';
					  $this->xml.= '<nfse:Discriminacao>'.str_replace($array1, $array2, utf8_encode(base64_decode($this->rowdata->nfs_descrserv))).'</nfse:Discriminacao>';
					  $this->xml.= (isset($this->rowdata->nfs_codmun) && $this->rowdata->nfs_codmun!="") ? '<nfse:CodigoMunicipio>'.$this->rowdata->nfs_codmun.'</nfse:CodigoMunicipio>' : '<nfse:CodigoMunicipio>'.$this->company->emp_codmun.'</nfse:CodigoMunicipio>';
					  $this->xml.= '<nfse:ItensServico>';
						 $this->xml.= '<nfse:Descricao>'.substr(str_replace($array1, $array2, utf8_encode(base64_decode($this->rowdata->nfs_descrserv))), 0, 100).'</nfse:Descricao>';
						 $this->xml.= '<nfse:Quantidade>1</nfse:Quantidade>';
						 $this->xml.= '<nfse:ValorUnitario>'.number_format($this->rowdata->nfs_vlrservico, 2, ".","").'</nfse:ValorUnitario>';
					  $this->xml.= '</nfse:ItensServico>';
				   $this->xml.= '</nfse:Servico>';
				   $this->xml.= '<nfse:Tomador>';
					  $this->xml.= '<nfse:IdentificacaoTomador>';
						 $this->xml.= '<nfse:CpfCnpj>';
							$this->xml.= (strlen($this->rowdata->tom_cnpjcpf)==14) ? '<nfse:Cnpj>'.$this->rowdata->tom_cnpjcpf.'</nfse:Cnpj>' : '<nfse:Cpf>'.$this->rowdata->tom_cnpjcpf.'</nfse:Cpf>';
						 $this->xml.= '</nfse:CpfCnpj>';
					  $this->xml.= '</nfse:IdentificacaoTomador>';
					  $this->xml.= '<nfse:RazaoSocial>'.str_replace($array1, $array2, $this->rowdata->tom_nomeraz).'</nfse:RazaoSocial>';
					  $this->xml.= '<nfse:Endereco>';
						 $this->xml.= '<nfse:Endereco>'.str_replace($array1, $array2, $this->rowdata->end_nome).'</nfse:Endereco>';
						 $this->xml.= '<nfse:Numero>'.$this->rowdata->end_num.'</nfse:Numero>';
						 $this->xml.= (isset($this->rowdata->end_compl) && $this->rowdata->end_compl!="") ? '<nfse:Complemento>'.str_replace($array1, $array2, $this->rowdata->end_compl).'</nfse:Complemento>' :'';
						 $this->xml.= '<nfse:Bairro>'.str_replace($array1, $array2, $this->rowdata->end_bairro).'</nfse:Bairro>';
						 $this->xml.= '<nfse:CodigoMunicipio>'.$this->rowdata->tom_codmun.'</nfse:CodigoMunicipio>';
						 $this->xml.= '<nfse:Uf>'.$this->rowdata->end_uf.'</nfse:Uf>';
						 $this->xml.= '<nfse:Cep>'.$this->rowdata->end_cep.'</nfse:Cep>';
					  $this->xml.= '</nfse:Endereco>';
					  $this->xml.= '<nfse:Contato>';
						 $this->xml.= '<nfse:Telefone>'.$this->rowdata->tel_ddd.$this->rowdata->tel_prefixo.$this->rowdata->tel_numero.'</nfse:Telefone>';
						 $this->xml.= (isset($this->rowdata->tom_emai) && $this->rowdata->tom_emai!="") ? '<nfse:Email>'.$this->rowdata->tom_email.'</nfse:Email>' : '';
					  $this->xml.= '</nfse:Contato>';
				   $this->xml.= '</nfse:Tomador>';
				$this->xml.= '</nfse:InformacaoNfse>';
				$this->xml.= '</sis:GerarNovaNfseEnvio>';
				*/
			
			//Mandaguaçu/ jaragua do sul
			}elseif($this->codmun=="4114104" || $this->codmun=="4208906"){
				
				$this->xml .= '<GerarNfseEnvio xmlns = "http://www.betha.com.br/e-nota-contribuinte-ws">';
					$this->xml .= '<Rps>';
						$this->xml .= '<InfDeclaracaoPrestacaoServico  Id="lote1">';
							$this->xml .= '<Rps>';
								$this->xml .= '<IdentificacaoRps>';
									$this->xml .= '<Numero>'.$this->rowdata->nfs_nrorps.'</Numero>';
									$this->xml .= '<Serie>'.$this->rowdata->nfs_serierps.'</Serie>';
									$this->xml .= '<Tipo>'.$this->rowdata->nfs_tiporps.'</Tipo>';
								$this->xml .= '</IdentificacaoRps>';
								$this->xml .= '<DataEmissao>'.substr($this->rowdata->nfs_dtemissao,0,10).'</DataEmissao>';
								$this->xml .= '<Status>1</Status>';
							$this->xml .= '</Rps>';
							// $this->xml .= '<Competencia>'.substr($this->rowdata->nfs_dtprestacao,0,10).'</Competencia>';
							$this->xml .= '<Competencia>'.substr($this->rowdata->nfs_dtemissao,0,10).'</Competencia>';
							$this->xml .= '<Servico>';
								$this->xml .= '<Valores>';
									$this->xml .= ($this->rowdata->nfs_vlrservico>0) ? '<ValorServicos>'.number_format($this->rowdata->nfs_vlrservico,2,".","").'</ValorServicos>' : '<ValorServicos>0.00</ValorServicos>';
									$this->xml .= ($this->rowdata->nfs_vlrdeducao>0) ? '<ValorDeducoes>'.number_format($this->rowdata->nfs_vlrdeducao,2,".","").'</ValorDeducoes>' : '<ValorDeducoes>0.00</ValorDeducoes>';
									$this->xml .= ($this->rowdata->nfs_vlrpis>0) ? '<ValorPis>'.number_format($this->rowdata->nfs_vlrpis,2,".","").'</ValorPis>' : '<ValorPis>0.00</ValorPis>';
									$this->xml .= ($this->rowdata->nfs_vlrcofins>0) ? '<ValorCofins>'.number_format($this->rowdata->nfs_vlrcofins,2,".","").'</ValorCofins>' : '<ValorCofins>0.00</ValorCofins>';
									$this->xml .= ($this->rowdata->nfs_vlrinss>0) ? '<ValorInss>'.number_format($this->rowdata->nfs_vlrinss,2,".","").'</ValorInss>' : '<ValorInss>0.00</ValorInss>';
									$this->xml .= ($this->rowdata->nfs_vlrir>0) ? '<ValorIr>'.number_format($this->rowdata->nfs_vlrir,2,".","").'</ValorIr>' : '<ValorIr>0.00</ValorIr>';
									$this->xml .= ($this->rowdata->nfs_vlrcsll>0) ? '<ValorCsll>'.number_format($this->rowdata->nfs_vlrcsll,2,".","").'</ValorCsll>' : '<ValorCsll>0.00</ValorCsll>';
									// $this->xml .= ($this->rowdata->nfs_vlrissret>0) ? '<OutrasRetencoes>'.number_format($this->rowdata->nfs_vlrissret,2,".","").'</OutrasRetencoes>' : '<OutrasRetencoes>0.00</OutrasRetencoes>';
									$this->xml .= '<OutrasRetencoes>0.00</OutrasRetencoes>';
									$this->xml .= ($this->rowdata->nfs_vlriss>0) ? '<ValorIss>'.number_format($this->rowdata->nfs_vlriss,2,".","").'</ValorIss>' : '<ValorIss>0.00</ValorIss>';
									$this->xml .= ($this->rowdata->nfs_aliqiss>0) ? '<Aliquota>'.number_format($this->rowdata->nfs_aliqiss,0,"","").'</Aliquota>' : '<Aliquota>0.00</Aliquota>';
									$this->xml .= ($this->rowdata->nfs_descincond>0) ? '<DescontoIncondicionado>'.number_format($this->rowdata->nfs_descincond,2,".","").'</DescontoIncondicionado>' : '<DescontoIncondicionado>0.00</DescontoIncondicionado>';
									$this->xml .= ($this->rowdata->nfs_desccond>0) ? '<DescontoCondicionado>'.number_format($this->rowdata->nfs_desccond,2,".","").'</DescontoCondicionado>' : '<DescontoCondicionado>0.00</DescontoCondicionado>';
								$this->xml .= '</Valores>';
								$this->xml .= '<IssRetido>'.$this->rowdata->nfs_issret.'</IssRetido>';
								$this->xml .= ($this->rowdata->nfs_issret==1) ? '<ResponsavelRetencao>1</ResponsavelRetencao>' : '';
								$this->xml .= '<ItemListaServico>'.$this->rowdata->nfs_coditnlistserv.'</ItemListaServico>';
								$this->xml .= '<CodigoCnae>'.$this->company->emp_cnae.'</CodigoCnae>';
								$this->xml .= '<CodigoTributacaoMunicipio>'.$this->rowdata->nfs_coditnlistserv.'</CodigoTributacaoMunicipio>';
								$this->xml .= '<Discriminacao>'.strip_tags(str_replace($array1, $array2, utf8_encode(base64_decode($this->rowdata->nfs_descrserv)))).'</Discriminacao>';
								$this->xml .= '<CodigoMunicipio>'.$this->company->emp_codmun.'</CodigoMunicipio>';
								$this->xml .= '<ExigibilidadeISS>'.$this->rowdata->nfs_exigibilidadeiss.'</ExigibilidadeISS>';
								$this->xml .= (isset($this->rowdata->nfs_codmun) && $this->rowdata->nfs_codmun!="") ? '<MunicipioIncidencia>'.$this->rowdata->nfs_codmun.'</MunicipioIncidencia>' : '<MunicipioIncidencia>'.$this->company->emp_codmun.'</MunicipioIncidencia>';
								// $this->xml .= '<NumeroProcesso>38300/2012</NumeroProcesso>';
							$this->xml .= '</Servico>';
							$this->xml .= '<Prestador>';
								$this->xml .= '<CpfCnpj>';
								$this->xml .= '<Cnpj>'.$this->company->emp_cpfcnpj.'</Cnpj>';
								$this->xml .= '</CpfCnpj>';
								$this->xml .= '<InscricaoMunicipal>'.$this->company->emp_inscrmun.'</InscricaoMunicipal>';
							$this->xml .= '</Prestador>';
							$this->xml .= '<Tomador>';
								$this->xml .= '<IdentificacaoTomador>';
									$this->xml .= '<CpfCnpj>';
									if(strlen($this->rowdata->tom_cnpjcpf)==14){
										$this->xml .= '<Cnpj>'.$this->rowdata->tom_cnpjcpf.'</Cnpj>';
									}else{
										$this->xml .= '<Cpf>'.$this->rowdata->tom_cnpjcpf.'</Cpf>';
									}
									$this->xml .= '</CpfCnpj>';
									// $this->xml .= '<InscricaoMunicipal>0</InscricaoMunicipal>';
								$this->xml .= '</IdentificacaoTomador>';
								$this->xml .= '<RazaoSocial>'.str_replace($array1, $array2, $this->rowdata->tom_nomeraz).'</RazaoSocial>';
								$this->xml .= '<Endereco>';
									$this->xml .= '<Endereco>'.str_replace($array1, $array2, $this->rowdata->end_nome).'</Endereco>';
									$this->xml .= '<Numero>'.str_replace($array1, $array2, $this->rowdata->end_num).'</Numero>';
									$this->xml .= (isset($this->rowdata->end_compl) && $this->rowdata->end_compl!="") ? '<Complemento>'.str_replace($array1, $array2, $this->rowdata->end_compl).'</Complemento>' : '';
									$this->xml .= '<Bairro>'.str_replace($array1, $array2, $this->rowdata->end_bairro).'</Bairro>';
									$this->xml .= '<CodigoMunicipio>'.$this->rowdata->tom_codmun.'</CodigoMunicipio>';
									$this->xml .= '<Uf>'.$this->rowdata->end_uf.'</Uf>';
									$this->xml .= '<Cep>'.$this->rowdata->end_cep.'</Cep>';
								$this->xml .= '</Endereco>';
								$this->xml .= '<Contato>';
									$this->xml .= '<Telefone>'.$this->rowdata->tel_ddd.$this->rowdata->tel_prefixo.$this->rowdata->tel_numero.'</Telefone>';
									$this->xml .= ($this->rowdata->tom_email && $this->rowdata->tom_email!="") ? '<Email>'.$this->rowdata->tom_email.'</Email>' : '';
								$this->xml .= '</Contato>';
							$this->xml .= '</Tomador>';
							/*
							$this->xml .= '<Intermediario>';
								$this->xml .= '<IdentificacaoIntermediario>';
								$this->xml .= '<CpfCnpj>';
								$this->xml .= '<Cnpj>63402328000154</Cnpj>';
								$this->xml .= '</CpfCnpj>';
								$this->xml .= '<InscricaoMunicipal>0</InscricaoMunicipal>';
								$this->xml .= '</IdentificacaoIntermediario>';
								$this->xml .= '<RazaoSocial>INTERMEDIARIO TESTE 10367</RazaoSocial>';
							$this->xml .= '</Intermediario>';
							$this->xml .= '<ConstrucaoCivil>';
								$this->xml .= '<CodigoObra>999999</CodigoObra>';
								$this->xml .= '<Art>ART9999</Art>';
							$this->xml .= '</ConstrucaoCivil>';
							*/
							$this->xml .= ($this->company->emp_codregtrib==3) ? '' : '<RegimeEspecialTributacao>6</RegimeEspecialTributacao>';
							$this->xml .= ($this->company->emp_codregtrib==3) ? '<OptanteSimplesNacional>2</OptanteSimplesNacional>' : '<OptanteSimplesNacional>1</OptanteSimplesNacional>';
							$this->xml .= '<IncentivoFiscal>2</IncentivoFiscal>';
						$this->xml .= '</InfDeclaracaoPrestacaoServico>';
					$this->xml .= '</Rps>';
				$this->xml .= '</GerarNfseEnvio>';

			//Porto Rico / Doutor Camargo / Sarandi
			}elseif($this->codmun=="4120200" || $this->codmun=="4107306" || $this->codmun=="4126256"){
				$this->xml.= '<nfse:EnviarLoteRpsSincronoEnvio>';
					 $this->xml.= '<nfse:IdentificacaoRequerente>';
						$this->xml.= '<nfse:CpfCnpj>';
						   $this->xml.= '<nfse:Cnpj>'.$this->company->emp_cpfcnpj.'</nfse:Cnpj>';
						$this->xml.= '</nfse:CpfCnpj>';
						$this->xml.= '<nfse:InscricaoMunicipal>'.$this->company->emp_inscrmun.'</nfse:InscricaoMunicipal>';
						$this->xml.= '<nfse:Senha>'.$this->company->emp_path_acbr.'</nfse:Senha>';
						$this->xml .= ($this->company->emp_amb_nfse==1) ? '<nfse:Homologa>0</nfse:Homologa>' : '<nfse:Homologa>1</nfse:Homologa>';
					 $this->xml.= '</nfse:IdentificacaoRequerente>';
					 $this->xml.= '<nfse:LoteRps versao="?">';
						$this->xml.= '<nfse:NumeroLote>'.$this->company->emp_nfselote.'</nfse:NumeroLote>';
						$this->xml.= '<nfse:CpfCnpj>';
						   // $this->xml.= '<nfse:Cpf></nfse:Cpf>';
						   $this->xml.= '<nfse:Cnpj>'.$this->company->emp_cpfcnpj.'</nfse:Cnpj>';
						$this->xml.= '</nfse:CpfCnpj>';
						$this->xml.= '<nfse:InscricaoMunicipal>'.$this->company->emp_inscrmun.'</nfse:InscricaoMunicipal>';
						$this->xml.= '<nfse:QuantidadeRps>1</nfse:QuantidadeRps>';
						$this->xml.= '<nfse:ListaRps>';
						   $this->xml.= '<nfse:Rps>';
							  $this->xml.= '<nfse:InfDeclaracaoPrestacaoServico>';
								 $this->xml.= '<nfse:Rps>';
									$this->xml.= '<nfse:IdentificacaoRps>';
									   $this->xml.= '<nfse:Numero>'.$this->rowdata->nfs_nrorps.'</nfse:Numero>';
									   $this->xml.= '<nfse:Serie>'.$this->rowdata->nfs_serierps.'</nfse:Serie>';
									   $this->xml.= '<nfse:Tipo>'.$this->rowdata->nfs_tiporps.'</nfse:Tipo>';
									$this->xml.= '</nfse:IdentificacaoRps>';
									$this->xml.= '<nfse:DataEmissao>'.substr($this->rowdata->nfs_dtemissao,0,10).'</nfse:DataEmissao>';
									$this->xml.= '<nfse:Status>1</nfse:Status>';
									if( isset($this->rowdata->nfs_nrorpssub) && $this->rowdata->nfs_nrorpssub!="" ){
										$this->xml.= '<nfse:RpsSubstituido>';
										   $this->xml.= '<nfse:Numero>'.$this->rowdata->nfs_nrorpssub.'</nfse:Numero>';
										   $this->xml.= '<nfse:Serie>'.$this->rowdata->nfs_serierpssub.'</nfse:Serie>';
										   $this->xml.= '<nfse:Tipo'.$this->rowdata->nfs_tiporpssub.'</nfse:Tipo>';
										$this->xml.= '</nfse:RpsSubstituido>';
									}
								 $this->xml.= '</nfse:Rps>';
								 $this->xml.= '<nfse:Competencia>'.substr($this->rowdata->nfs_dtprestacao,0,10).'</nfse:Competencia>';
								 $this->xml.= '<nfse:Servico>';
									$this->xml.= '<nfse:Valores>';
									   $this->xml.= '<nfse:ValorServicos>'.$this->rowdata->nfs_vlrservico.'</nfse:ValorServicos>';
									   $this->xml.= '<nfse:ValorDeducoes>'.$this->rowdata->nfs_vlrdeducao.'</nfse:ValorDeducoes>';
									   $this->xml.= '<nfse:ValorPis>'.$this->rowdata->nfs_vlrpis.'</nfse:ValorPis>';
									   $this->xml.= '<nfse:ValorCofins>'.$this->rowdata->nfs_vlrcofins.'</nfse:ValorCofins>';
									   $this->xml.= '<nfse:ValorInss>'.$this->rowdata->nfs_vlrinss.'</nfse:ValorInss>';
									   $this->xml.= '<nfse:ValorIr>'.$this->rowdata->nfs_vlrir.'</nfse:ValorIr>';
									   $this->xml.= '<nfse:ValorCsll>'.$this->rowdata->nfs_vlrcsll.'</nfse:ValorCsll>';
									   //$this->xml.= ($this->rowdata->nfs_issret==1) ? '<nfse:ValorIss>'.$this->rowdata->nfs_vlriss.'</nfse:ValorIss>' : '';
									   $this->xml.= '<nfse:Aliquota>'.$this->rowdata->nfs_aliqiss.'</nfse:Aliquota>';
									   $this->xml.= '<nfse:DescontoIncondicionado>?</nfse:DescontoIncondicionado>';
									   $this->xml.= '<nfse:DescontoCondicionado>?</nfse:DescontoCondicionado>';
									$this->xml.= '</nfse:Valores>';
									$this->xml.= '<nfse:IssRetido>'.$this->rowdata->nfs_issret.'</nfse:IssRetido>';
									$this->xml.= ($this->rowdata->nfs_issret==1) ? '<nfse:ResponsavelRetencao>1</nfse:ResponsavelRetencao>' : '';
									$this->xml.= '<nfse:Discriminacao>'.strip_tags(str_replace($array1, $array2, utf8_encode(base64_decode($this->rowdata->nfs_descrserv)))).'</nfse:Discriminacao>';
									$this->xml.= '<nfse:CodigoTributacaoMunicipio>'.substr($this->rowdata->nfs_coditnlistserv, 0, 2).'.'.substr($this->rowdata->nfs_coditnlistserv, 2).'</nfse:CodigoTributacaoMunicipio>';
									$this->xml.= '<nfse:CodigoMunicipio>'.$this->company->emp_codmun.'</nfse:CodigoMunicipio>';
									$this->xml.= '<nfse:ExigibilidadeISS>'.$this->rowdata->nfs_exigibilidadeiss.'</nfse:ExigibilidadeISS>';
									$this->xml .= (isset($this->rowdata->nfs_codmun) && $this->rowdata->nfs_codmun!="") ? '<nfse:MunicipioIncidencia>'.$this->rowdata->nfs_codmun.'</nfse:MunicipioIncidencia>' : '<nfse:MunicipioIncidencia>'.$this->company->emp_codmun.'</nfse:MunicipioIncidencia>';
									$this->xml.= '<nfse:ListaItensServico>';
									   $this->xml.= '<nfse:ItemServico>';
										  $this->xml.= '<nfse:ItemListaServico>'.$this->rowdata->nfs_coditnlistserv.'</nfse:ItemListaServico>';
										  $this->xml.= '<nfse:CodigoCnae>'.$this->company->emp_cnae.'</nfse:CodigoCnae>';
										  $this->xml.= '<nfse:Descricao>'.strip_tags(str_replace($array1, $array2, utf8_encode(base64_decode($this->rowdata->nfs_descrserv)))).'</nfse:Descricao>';
										  $this->xml.= '<nfse:Tributavel>1</nfse:Tributavel>';
										  $this->xml.= '<nfse:Quantidade>1</nfse:Quantidade>';
										  $this->xml.= '<nfse:ValorUnitario>'.number_format($this->rowdata->nfs_vlrservico - ($this->rowdata->nfs_vlrpis+$this->rowdata->nfs_vlrcofins+$this->rowdata->nfs_vlrinss+$this->rowdata->nfs_vlrir+$this->rowdata->nfs_vlrcsll), 2, ".","").'</nfse:ValorUnitario>';
										  $this->xml.= '<nfse:ValorLiquido>'.number_format($this->rowdata->nfs_vlrservico - ($this->rowdata->nfs_vlrpis+$this->rowdata->nfs_vlrcofins+$this->rowdata->nfs_vlrinss+$this->rowdata->nfs_vlrir+$this->rowdata->nfs_vlrcsll), 2, ".","").'</nfse:ValorLiquido>';
									   $this->xml.= '</nfse:ItemServico>';
									$this->xml.= '</nfse:ListaItensServico>';
								 $this->xml.= '</nfse:Servico>';
								 $this->xml.= '<nfse:Prestador>';
									$this->xml.= '<nfse:CpfCnpj>';
									   $this->xml.= '<nfse:Cnpj>'.$this->company->emp_cpfcnpj.'</nfse:Cnpj>';
									$this->xml.= '</nfse:CpfCnpj>';
									$this->xml.= '<nfse:InscricaoMunicipal>'.$this->company->emp_inscrmun.'</nfse:InscricaoMunicipal>';
								 $this->xml.= '</nfse:Prestador>';
								 $this->xml.= '<nfse:Tomador>';
									$this->xml.= '<nfse:IdentificacaoTomador>';
									   $this->xml.= '<nfse:CpfCnpj>';
										  $this->xml.= (strlen($this->rowdata->tom_cnpjcpf)==14) ? '<nfse:Cnpj>'.$this->rowdata->tom_cnpjcpf.'</nfse:Cnpj>' : '<nfse:Cpf>'.$this->rowdata->tom_cnpjcpf.'</nfse:Cpf>';
									   $this->xml.= '</nfse:CpfCnpj>';
									$this->xml.= '</nfse:IdentificacaoTomador>';
									$this->xml.= '<nfse:RazaoSocial>'.str_replace($array1, $array2, $this->rowdata->tom_nomeraz).'</nfse:RazaoSocial>';
									$this->xml.= '<nfse:Endereco>';
									   $this->xml.= '<nfse:Endereco>'.str_replace($array1, $array2, $this->rowdata->end_nome).'</nfse:Endereco>';
									   $this->xml.= '<nfse:Numero>'.str_replace($array1, $array2, $this->rowdata->end_num).'</nfse:Numero>';
									   $this->xml.= '<nfse:Complemento>'.str_replace($array1, $array2, $this->rowdata->end_compl).'</nfse:Complemento>';
									   $this->xml.= '<nfse:Bairro>'.str_replace($array1, $array2, $this->rowdata->end_bairro).'</nfse:Bairro>';
									   $this->xml.= '<nfse:CodigoMunicipio>'.$this->rowdata->tom_codmun.'</nfse:CodigoMunicipio>';
									   $this->xml.= '<nfse:Uf>'.$this->rowdata->end_uf.'</nfse:Uf>';
									   $this->xml.= '<nfse:Cep>'.$this->rowdata->end_cep.'</nfse:Cep>';
									$this->xml.= '</nfse:Endereco>';
									$this->xml.= '<nfse:Contato>';
									   $this->xml .= '<nfse:Telefone>'.$this->rowdata->tel_ddd.$this->rowdata->tel_prefixo.$this->rowdata->tel_numero.'</nfse:Telefone>';
									   $this->xml .= ($this->rowdata->tom_email && $this->rowdata->tom_email!="") ? '<nfse:Email>'.$this->rowdata->tom_email.'</nfse:Email>' : '';
									$this->xml.= '</nfse:Contato>';
								 $this->xml.= '</nfse:Tomador>';
								 // $this->xml.= '<nfse:RegimeEspecialTributacao>6</nfse:RegimeEspecialTributacao>';
								 $this->xml.= '<nfse:IncentivoFiscal>2</nfse:IncentivoFiscal>';
							  $this->xml.= '</nfse:InfDeclaracaoPrestacaoServico>';
						   $this->xml.= '</nfse:Rps>';
						$this->xml.= '</nfse:ListaRps>';
					 $this->xml.= '</nfse:LoteRps>';
				  $this->xml.= '</nfse:EnviarLoteRpsSincronoEnvio>';
			
			//São Paulo			
			}elseif($this->codmun=="3550308"){
				
				$fp = fopen($this->priKEY, "r");
				$priv_key = fread($fp, 8192);
				fclose($fp);
				$pkeyid = openssl_get_privatekey($priv_key);
				
				$tTrib = 'T';
				$issRet = ($this->rowdata->nfs_issret==1) ? 'S' : 'N';
				$cfpcnpj = (strlen($this->rowdata->tom_cnpjcpf)==14) ? '2' : '1';
				$ass = $this->company->emp_inscrmun.str_pad($this->rowdata->nfs_serierps,5,' ', STR_PAD_RIGHT).str_pad($this->rowdata->nfs_nrorps,12,'0', STR_PAD_LEFT).str_replace('-','',substr($this->rowdata->nfs_dtemissao,0,10)).$tTrib.'N'.$issRet.str_pad(number_format($this->rowdata->nfs_vlrservico, 2, '', ''),15,'0',STR_PAD_LEFT).str_pad(number_format($this->rowdata->nfs_vlrdeducao, 2, '', ''),15,'0',STR_PAD_LEFT).$this->rowdata->nfs_coditnlistserv.$cfpcnpj.str_pad($this->rowdata->tom_cnpjcpf, 14, '0');
				
				$signature = '';
				$resp = openssl_sign($ass,$signature,$pkeyid);
				$assinatura = base64_encode($signature);
				
				$this->xml.= '<PedidoEnvioRPS xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns="http://www.prefeitura.sp.gov.br/nfe">';
				  $this->xml.= '<Cabecalho Versao="1" xmlns="">';
					$this->xml.= '<CPFCNPJRemetente>';
					  $this->xml.= '<CNPJ>'.$this->company->emp_cpfcnpj.'</CNPJ>';
					$this->xml.= '</CPFCNPJRemetente>';
				  $this->xml.= '</Cabecalho>';
				  $this->xml.= '<RPS xmlns="">';
					$this->xml.= '<Assinatura>'.$assinatura.'</Assinatura>';
					$this->xml.= '<ChaveRPS>';
					  $this->xml.= '<InscricaoPrestador>'.$this->company->emp_inscrmun.'</InscricaoPrestador>';
					  $this->xml.= '<SerieRPS>'.$this->rowdata->nfs_serierps.'</SerieRPS>';
					  $this->xml.= '<NumeroRPS>'.$this->rowdata->nfs_nrorps.'</NumeroRPS>';
					$this->xml.= '</ChaveRPS>';
					$this->xml.= '<TipoRPS>RPS</TipoRPS>';
					$this->xml.= '<DataEmissao>'.substr($this->rowdata->nfs_dtemissao,0,10).'</DataEmissao>';
					$this->xml.= '<StatusRPS>N</StatusRPS>';
					$this->xml.= '<TributacaoRPS>'.$tTrib.'</TributacaoRPS>';
					$this->xml.= '<ValorServicos>'.number_format($this->rowdata->nfs_vlrservico, 2, '.', '').'</ValorServicos>';
					$this->xml.= ($this->rowdata->nfs_vlrdeducao>0) ? '<ValorDeducoes>'.number_format($this->rowdata->nfs_vlrdeducao, 2, '.', '').'</ValorDeducoes>' : '<ValorDeducoes>0</ValorDeducoes>';
					$this->xml.= ($this->rowdata->nfs_vlrpis>0) ? '<ValorPIS>'.number_format($this->rowdata->nfs_vlrpis, 2, '.', '').'</ValorPIS>' : '<ValorPIS>0</ValorPIS>';
					$this->xml.= ($this->rowdata->nfs_vlrcofins>0) ? '<ValorCOFINS>'.number_format($this->rowdata->nfs_vlrcofins, 2, '.', '').'</ValorCOFINS>' : '<ValorCOFINS>0</ValorCOFINS>';
					$this->xml.= ($this->rowdata->nfs_vlrinss>0) ? '<ValorINSS>'.number_format($this->rowdata->nfs_vlrinss, 2, '.', '').'</ValorINSS>' : '<ValorINSS>0</ValorINSS>';
					$this->xml.= ($this->rowdata->nfs_vlrir>0) ? '<ValorIR>'.number_format($this->rowdata->nfs_vlrir, 2, '.', '').'</ValorIR>' : '<ValorIR>0</ValorIR>';
					$this->xml.= ($this->rowdata->nfs_vlrcsll>0) ? '<ValorCSLL>'.number_format($this->rowdata->nfs_vlrcsll, 2, '.', '').'</ValorCSLL>' : '<ValorCSLL>0</ValorCSLL>';
					$this->xml.= '<CodigoServico>'.$this->rowdata->nfs_coditnlistserv.'</CodigoServico>';
					$this->xml.= '<AliquotaServicos>'.$this->rowdata->nfs_aliqiss.'</AliquotaServicos>';
					$this->xml.= ($this->rowdata->nfs_issret==1) ? '<ISSRetido>true</ISSRetido>' : '<ISSRetido>false</ISSRetido>';
					$this->xml.= '<CPFCNPJTomador>';
					  $this->xml.= (strlen($this->rowdata->tom_cnpjcpf)==14) ? '<CNPJ>'.$this->rowdata->tom_cnpjcpf.'</CNPJ>' : '<CPF>'.$this->rowdata->tom_cnpjcpf.'</CPF>';
					$this->xml.= '</CPFCNPJTomador>';
					$this->xml.= '<RazaoSocialTomador>'.str_replace($array1, $array2, $this->rowdata->tom_nomeraz).'</RazaoSocialTomador>';
					$this->xml.= '<EnderecoTomador>';
					  $this->xml.= '<TipoLogradouro>Av</TipoLogradouro>';
					  $this->xml.= '<Logradouro>'.str_replace($array1, $array2, $this->rowdata->end_nome).'</Logradouro>';
					  $this->xml.= '<NumeroEndereco>'.str_replace($array1, $array2, $this->rowdata->end_num).'</NumeroEndereco>';
					  $this->xml.= '<ComplementoEndereco>'.str_replace($array1, $array2, $this->rowdata->end_compl).'</ComplementoEndereco>';
					  $this->xml.= '<Bairro>'.str_replace($array1, $array2, $this->rowdata->end_bairro).'</Bairro>';
					  $this->xml.= '<Cidade>'.$this->rowdata->tom_codmun.'</Cidade>';
					  $this->xml.= '<UF>'.$this->rowdata->end_uf.'</UF>';
					  $this->xml.= '<CEP>'.$this->rowdata->end_cep.'</CEP>';
					$this->xml.= '</EnderecoTomador>';
					$this->xml .= ($this->rowdata->tom_email && $this->rowdata->tom_email!="") ? '<EmailTomador>'.$this->rowdata->tom_email.'</EmailTomador>' : '';
					$this->xml.= '<Discriminacao>'.strip_tags(str_replace($array1, $array2, utf8_encode(base64_decode($this->rowdata->nfs_descrserv)))).'</Discriminacao>';
				  $this->xml.= '</RPS>';
				$this->xml.= '</PedidoEnvioRPS>';
				
				openssl_free_key($pkeyid);
			//Uniflor
			}elseif($this->codmun=="4128302"){
				$this->xml.= '<es:enviarLoteRpsEnvio xmlns:es="http://www.equiplano.com.br/esnfs" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"	xsi:schemaLocation="http://www.equiplano.com.br/enfs esRecepcionarLoteRpsEnvio_v01.xsd">';
					$this->xml.= '<lote>';
					$this->xml.= '<nrLote>'.$this->company->emp_nfselote.'</nrLote>';
						$this->xml.= '<qtRps>1</qtRps>';
						$this->xml.= '<nrVersaoXml>1</nrVersaoXml>';
						$this->xml.= '<prestador>';
							$this->xml.= '<nrCnpj>'.$this->company->emp_cpfcnpj.'</nrCnpj>';
							$this->xml.= 'nrInscricaoMunicipal>'.$this->company->emp_inscrmun.'</nrInscricaoMunicipal>';
							$this->xml.= ($this->company->emp_codregtrib==3) ? '<isOptanteSimplesNacional>2</isOptanteSimplesNacional>' : '<isOptanteSimplesNacional>1</isOptanteSimplesNacional>';
							$this->xml.= '<idEntidade>465</idEntidade>';
						$this->xml.= '</prestador>';
						$this->xml.= '<listaRps>';
							$this->xml.= '<rps>';
								$this->xml.= '<nrRps>'.$this->rowdata->nfs_nrorps.'</nrRps>';
								$this->xml.= '<nrEmissorRps>1</nrEmissorRps>';
								$this->xml.= '<dtEmissaoRps>'.date("Y-m-d").'T'.date("H:i:s").'</dtEmissaoRps>';
								$this->xml.= '<!-- stRps obrigatório {1=converter, 2=converter e cancelar NFS, 3=cancelar RPS}--><stRps>1</stRps>';
								$this->xml.= '<!-- tpTributacao obrigatório {1=tributado no munícipio, 2=em outro munícipio, 3=isento/imune, 4=suspenso/decisão judicial}--><tpTributacao>1</tpTributacao>';
								//$this->xml.= '<!-- nrCidadeIbgeServico {Quando o tipo de tributação (tpTributacao) for 2 = Em outro município, é obrigatório informar o código IBGE do município de destino.}--><nrCidadeIbgeServico>000000</nrCidadeIbgeServico>';
								$this->xml.= '<!-- isIssRetido obrigatório {1=sim, 2=não}--><isIssRetido>'.$this->rowdata->nfs_issret.'</isIssRetido>';
								$this->xml.= '<tomador>';
									$this->xml.= '<documento>';
										$this->xml.= '<!-- nrDocumento obrigatório --><nrDocumento>'.$this->rowdata->tom_cnpjcpf.'</nrDocumento>';
										$this->xml.= (strlen($this->rowdata->tom_cnpjcpf)==14) ? '<tpDocumento>2</tpDocumento>' : '<tpDocumento>1</tpDocumento>';
										//$this->xml.= '<!-- dsDocumentoEstrangeiro obrigatório se tpDocumento=3--><dsDocumentoEstrangeiro></dsDocumentoEstrangeiro>';
									$this->xml.= '</documento>';
									$this->xml.= '<nmTomador>'.str_replace($array1, $array2, $this->rowdata->tom_nomeraz).'</nmTomador>';
									$this->xml.= ($this->rowdata->tom_email && $this->rowdata->tom_email!="") ? '<dsEmail>'.$this->rowdata->tom_email.'</dsEmail>' : '';
									//$this->xml.= '<nrInscricaoEstadual>19518744</nrInscricaoEstadual>';
									//$this->xml.= '<nrInscricaoMunicipal>555</nrInscricaoMunicipal>';
									$this->xml.= '<dsEndereco>'.str_replace($array1, $array2, $this->rowdata->end_nome).'</dsEndereco>';
									$this->xml.= '<nrEndereco>'.$this->rowdata->end_num.'</nrEndereco>';
									$this->xml.= '<dsComplemento>'.str_replace($array1, $array2, $this->rowdata->end_compl).'</dsComplemento>';
									$this->xml.= '<nmBairro>'.str_replace($array1, $array2, $this->rowdata->end_bairro).'</nmBairro>';
									$this->xml.= '<nrCidadeIbge>'.$this->rowdata->tom_codmun.'</nrCidadeIbge>';
									$this->xml.= '<nmUf>'.$this->rowdata->end_uf.'</nmUf>';
									//$this->xml.= '<nmCidadeEstrangeira></nmCidadeEstrangeira>';
									$this->xml.= '<nmPais>Brasil</nmPais>';
									$this->xml.= '<nrCep>'.$this->rowdata->end_cep.'</nrCep>';
									$this->xml.= '<nrTelefone>'.$this->rowdata->tel_ddd.' '.$this->rowdata->tel_prefixo.$this->rowdata->tel_numero.'</nrTelefone>';
								$this->xml.= '</tomador>';
								$this->xml.= '<listaServicos>';
									$this->xml.= '<servico>';
										$this->xml.= '<!-- nrServicoItem obrigatório --><nrServicoItem>'.substr($this->rowdata->nfs_coditnlistserv, 0, 2).'</nrServicoItem>';
										$this->xml.= '<!-- nrServicoSubItem obrigatório --><nrServicoSubItem>'.substr($this->rowdata->nfs_coditnlistserv, 2).'</nrServicoSubItem>';
										$this->xml.= '<!-- vlServico obrigatório --><vlServico>'.number_format($this->rowdata->nfs_vlrservico, 2, '.', '').'</vlServico>';
										$this->xml.= '<!-- vlAliquota obrigatório --><vlAliquota>'.$this->rowdata->nfs_aliqiss.'</vlAliquota>';
										//$this->xml.= '<deducao>';
											//$this->xml.= '<vlDeducao>1.0</vlDeducao>';
											//$this->xml.= '<!-- dsJustificativaDeducao obrigatório Se informado vlDeducao--><dsJustificativaDeducao>teste</dsJustificativaDeducao>';
										//$this->xml.= '</deducao>';
										$this->xml.= '<!-- vlBaseCalculo obrigatório --><vlBaseCalculo>'.number_format($this->rowdata->nfs_vlrservico, 2, '.', '').'</vlBaseCalculo>';
										$this->xml.= '<!-- vlIssServico obrigatório --><vlIssServico>'.number_format($this->rowdata->nfs_vlriss,2,".","").'</vlIssServico>';
										$this->xml.= '<!-- dsDiscriminacaoServico obrigatório --><dsDiscriminacaoServico>'.strip_tags(str_replace($array1, $array2, utf8_encode(base64_decode($this->rowdata->nfs_descrserv)))).'</dsDiscriminacaoServico>';
									$this->xml.= '</servico>';
								$this->xml.= '</listaServicos>';
								$this->xml.= '<vlTotalRps>'.number_format($this->rowdata->nfs_vlrservico, 2, '.', '').'</vlTotalRps>';
								$this->xml.= '<vlLiquidoRps>'.number_format($this->rowdata->nfs_vlrservico, 2, '.', '').'</vlLiquidoRps>';
								$this->xml.= '<retencoes>';
									$this->xml.= ($this->rowdata->nfs_vlrcofins>0) ? '<vlCofins>'.number_format($this->rowdata->nfs_vlrcofins, 2, '.', '').'</vlCofins>' : '<vlCofins>0</vlCofins>';
									$this->xml.= ($this->rowdata->nfs_vlrcsll>0) ? '<vlCsll>'.number_format($this->rowdata->nfs_vlrcsll, 2, '.', '').'</vlCsll>' : '<vlCsll>0</vlCsll>';
									$this->xml.= ($this->rowdata->nfs_vlrinss>0) ? '<vlInss>'.number_format($this->rowdata->nfs_vlrinss, 2, '.', '').'</vlInss>' : '<vlInss>0</vlInss>';
									$this->xml.= ($this->rowdata->nfs_vlrir>0) ? '<vlIrrf>'.number_format($this->rowdata->nfs_vlrir, 2, '.', '').'</vlIrrf>' : '<vlIrrf>0</vlIrrf>';
									$this->xml.= ($this->rowdata->nfs_vlrpis>0) ? '<vlPis>'.number_format($this->rowdata->nfs_vlrpis, 2, '.', '').'</vlPis>' : '<vlPis>0</vlPis>';
									$this->xml.= ($this->rowdata->nfs_issret==1) ? '<vlIss>'.number_format($this->rowdata->nfs_vlriss,2,".","").'</vlIss>' : '<vlIss>0</vlIss>';
									$this->xml.= '<vlAliquotaCofins>0</vlAliquotaCofins>';
									$this->xml.= '<vlAliquotaCsll>0</vlAliquotaCsll>';
									$this->xml.= '<vlAliquotaInss>0</vlAliquotaInss>';
									$this->xml.= '<vlAliquotaIrrf>0</vlAliquotaIrrf>';
									$this->xml.= '<vlAliquotaPis>0</vlAliquotaPis>';
								$this->xml.= '</retencoes>';
							$this->xml.= '</rps>';
						$this->xml.= '</listaRps>';
					$this->xml.= '</lote>';
				$this->xml.= '</es:enviarLoteRpsEnvio>';
			}
			
			return $this->xml;
		}
		
		public function getXMLCanc(){
			
			//Maringá
			if($this->codmun=="4115200"){
				
				$this->xml .= '<CancelarNfseEnvio xmlns="http://www.abrasf.org.br/nfse.xsd" xmlns:ds="http://www.w3.org/2000/09/xmldsig#" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://www.abrasf.org.br/nfse.xsd nfse_v2.01.xsd ">';
					$this->xml .= '<Pedido>';
						$this->xml .= '<InfPedidoCancelamento Id="L1">';
							$this->xml .= '<IdentificacaoNfse>';
								$this->xml .= '<Numero>'.$this->rowdata->nfs_nronfse.'</Numero>';
								$this->xml .= '<CpfCnpj>';
									$this->xml .= '<Cnpj>'.$this->company->emp_cpfcnpj.'</Cnpj>';
								$this->xml .= '</CpfCnpj>';
								$this->xml .= '<InscricaoMunicipal>'.$this->company->emp_inscrmun.'</InscricaoMunicipal>';
								$this->xml .= '<CodigoMunicipio>'.$this->company->emp_codmun.'</CodigoMunicipio>';
							$this->xml .= '</IdentificacaoNfse>';
							$this->xml .= '<CodigoCancelamento>1</CodigoCancelamento>';
						$this->xml .= '</InfPedidoCancelamento>';
					$this->xml .= '</Pedido>';
				$this->xml .= '</CancelarNfseEnvio>';
			
			// Antigo Sarandi			
			}elseif($this->codmun=="34543543534534534543"){
				
				$this->xml .= '<DadosCancelaNota>';
					$this->xml .= '<ccm>'.$this->company->emp_inscrmun.'</ccm>';
					$this->xml .= '<cnpj>'.$this->company->emp_cpfcnpj.'</cnpj>';
					$this->xml .= '<senha>'.$this->company->emp_path_acbr.'</senha>';
					$this->xml .= '<nota>'.$this->rowdata->nfs_nronfse.'</nota>';
					$this->xml .= '<motivo>1</motivo>';
				$this->xml .= '</DadosCancelaNota>';
				
			//Paiçandu			
			}elseif($this->codmun=="4117503"){
				
				$this->xml .= '<NFSE>';
					$this->xml .= '<IDENTIFICACAO>';
						$this->xml .= '<INSCRICAO>'.$this->company->emp_inscrmun.'</INSCRICAO>';
						$this->xml .= '<LOTE>'.$this->rowdata->nfs_nronfref.'</LOTE>';
						$this->xml .= '<SEQUENCIA>'.$this->rowdata->nfs_nrorps.'</SEQUENCIA>';
					$this->xml .= '</IDENTIFICACAO>';
				$this->xml .= '</NFSE>';
			//Mandaguaçu/ jaragua do sul
			}elseif($this->codmun=="4114104" || $this->codmun=="4208906"){
				
				$this->xml .= '<CancelarNfseEnvio xmlns="http://www.betha.com.br/e-nota-contribuinte-ws">';
					$this->xml .= '<Pedido>';
						$this->xml .= '<InfPedidoCancelamento Id="1">';
							$this->xml .= '<IdentificacaoNfse>';
								$this->xml .= '<Numero>'.$this->rowdata->nfs_nronfse.'</Numero>';
								$this->xml .= '<CpfCnpj>';
									$this->xml .= '<Cnpj>'.$this->company->emp_cpfcnpj.'</Cnpj>';
								$this->xml .= '</CpfCnpj>';
								$this->xml .= '<InscricaoMunicipal>'.$this->company->emp_inscrmun.'</InscricaoMunicipal>';
								$this->xml .= '<CodigoMunicipio>'.$this->company->emp_codmun.'</CodigoMunicipio>';
							$this->xml .= '</IdentificacaoNfse>';
							$this->xml .= '<CodigoCancelamento>1</CodigoCancelamento>';
						$this->xml .= '</InfPedidoCancelamento>';
					$this->xml .= '</Pedido>';
				$this->xml .= '</CancelarNfseEnvio>';
				
			//Porto Rico / Doutor Camargo / Sarandi			
			}elseif($this->codmun=="4120200" || $this->codmun=="4107306" || $this->codmun=="4126256"){
				
				$this->xml .= '<nfse:CancelarNfseEnvio>';
					$this->xml .= '<nfse:IdentificacaoRequerente>';
					$this->xml .= '<nfse:CpfCnpj>';
					   $this->xml .= '<nfse:Cnpj>'.$this->company->emp_cpfcnpj.'</nfse:Cnpj>';
					$this->xml .= '</nfse:CpfCnpj>';
					$this->xml .= '<nfse:InscricaoMunicipal>'.$this->company->emp_inscrmun.'</nfse:InscricaoMunicipal>';
					$this->xml .= '<nfse:Senha>'.$this->company->emp_path_acbr.'</nfse:Senha>';
					$this->xml .= ($this->company->emp_amb_nfse==1) ? '<nfse:Homologa>0</nfse:Homologa>' : '<nfse:Homologa>1</nfse:Homologa>';
					$this->xml .= '</nfse:IdentificacaoRequerente>';
					$this->xml .= '<nfse:Pedido>';
					$this->xml .= '<nfse:InfPedidoCancelamento>';
					   $this->xml .= '<nfse:IdentificacaoNfse>';
						  $this->xml .= '<nfse:Numero>'.$this->rowdata->nfs_nronfse.'</nfse:Numero>';
						  $this->xml .= '<nfse:CpfCnpj>';
							 $this->xml .= '<nfse:Cnpj>'.$this->company->emp_cpfcnpj.'</nfse:Cnpj>';
						  $this->xml .= '</nfse:CpfCnpj>';
						  $this->xml .= '<nfse:InscricaoMunicipal>'.$this->company->emp_inscrmun.'</nfse:InscricaoMunicipal>';
						  $this->xml .= '<nfse:CodigoMunicipio>'.$this->company->emp_codmun.'</nfse:CodigoMunicipio>';
					   $this->xml .= '</nfse:IdentificacaoNfse>';
					   $this->xml .= '<nfse:ChaveAcesso>'.$this->rowdata->nfs_motcanc.'</nfse:ChaveAcesso>';
					   $this->xml .= '<nfse:CodigoCancelamento>1</nfse:CodigoCancelamento>';
					$this->xml .= '</nfse:InfPedidoCancelamento>';
					$this->xml .= '</nfse:Pedido>';
				$this->xml .= '</nfse:CancelarNfseEnvio>';
			
			//São Paulo
			}elseif($this->codmun=="3550308"){
				
				$fp = fopen($this->priKEY, "r");
				$priv_key = fread($fp, 8192);
				fclose($fp);
				$pkeyid = openssl_get_privatekey($priv_key);

				$ass = $this->company->emp_inscrmun.str_pad($this->rowdata->nfs_nronfse,12,'0', STR_PAD_LEFT);
				
				$signature = '';
				$resp = openssl_sign($ass,$signature,$pkeyid);
				$assinatura = base64_encode($signature);
				
				$this->xml .= '<PedidoCancelamentoNFe xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns="http://www.prefeitura.sp.gov.br/nfe">';
				  $this->xml .= '<Cabecalho Versao="1" xmlns="">';
					$this->xml .= '<CPFCNPJRemetente>';
					  $this->xml .= '<CNPJ>'.$this->company->emp_cpfcnpj.'</CNPJ>';
					$this->xml .= '</CPFCNPJRemetente>';
					$this->xml .= '<transacao>true</transacao>';
				  $this->xml .= '</Cabecalho>';
				  $this->xml .= '<Detalhe xmlns="">';
					$this->xml .= '<ChaveNFe>';
					  $this->xml .= '<InscricaoPrestador>'.$this->company->emp_inscrmun.'</InscricaoPrestador>';
					  $this->xml .= '<NumeroNFe>'.$this->rowdata->nfs_nronfse.'</NumeroNFe>';
					$this->xml .= '</ChaveNFe>';
					$this->xml .= '<AssinaturaCancelamento>'.$assinatura.'</AssinaturaCancelamento>';
				  $this->xml .= '</Detalhe>';
				$this->xml .= '</PedidoCancelamentoNFe>';
				
				openssl_free_key($pkeyid);
				
			}
			
			return $this->xml;
			
		}
		
		public function getXMLCons(){
			
			//Maringá / Mandaguaçu/ jaragua do sul
			if($this->codmun=="4115200" || $this->codmun=="4114104" || $this->codmun=="4208906"){
				
				$this->xml .= '<ConsultarNfseServicoPrestadoEnvio xmlns="http://www.abrasf.org.br/nfse.xsd" xmlns:ds="http://www.w3.org/2000/09/xmldsig#" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://www.abrasf.org.br/nfse.xsd nfse_v2.01.xsd ">';
				$this->xml .= '<Prestador>';
					$this->xml .= '<CpfCnpj>';
						$this->xml .= '<Cnpj>'.$this->company->emp_cpfcnpj.'</Cnpj>';
					$this->xml .= '</CpfCnpj>';
					$this->xml .= '<InscricaoMunicipal>'.$this->company->emp_inscrmun.'</InscricaoMunicipal>';
				$this->xml .= '</Prestador>';
				$this->xml .= '<NumeroNfse>'.$this->rowdata->nfs_nronfse.'</NumeroNfse>';
				$this->xml .= '<PeriodoEmissao>';
					$this->xml .= '<DataInicial>'.substr($this->rowdata->nfs_dtemissao,0,10).'</DataInicial>';
					$this->xml .= '<DataFinal>'.substr($this->rowdata->nfs_dtemissao,0,10).'</DataFinal>';
				$this->xml .= '</PeriodoEmissao>';
				$this->xml .= '<Tomador>';
					$this->xml .= '<CpfCnpj>';
						$this->xml .= '<Cnpj>'.$this->rowdata->tom_cnpjcpf.'</Cnpj>';
					$this->xml .= '</CpfCnpj>';
				$this->xml .= '</Tomador>';
				$this->xml .= '<Pagina>1</Pagina>';
				$this->xml .= '</ConsultarNfseServicoPrestadoEnvio>';
			
			//Antigo Sarandi
			}elseif($this->codmun=="435345346345345345435"){
				
				$this->xml .= '<DadosPrestador>';
					$this->xml .= '<ccm>'.$this->company->emp_inscrmun.'</ccm>';
					$this->xml .= '<cnpj>'.$this->company->emp_cpfcnpj.'</cnpj>';
					$this->xml .= '<senha>'.$this->company->emp_path_acbr.'</senha>';
					$this->xml .= '<aliquota_simples>'.$this->rowdata->nfs_aliqiss.'</aliquota_simples>';
				$this->xml .= '</DadosPrestador>';
				$this->xml .= '<Nota>'.$this->rowdata->nfs_nronfse.'</Nota>';
				
			//Paiçandu
			}elseif($this->codmun=="4117503"){
				
				$this->xml .= '<NFSE>';
					$this->xml .= '<IDENTIFICACAO>';
						$this->xml .= '<INSCRICAO>'.$this->company->emp_inscrmun.'</INSCRICAO>';
						$this->xml .= '<LOTE>'.$this->rowdata->nfs_nronfref.'</LOTE>';
						$this->xml .= '<SEQUENCIA>'.$this->rowdata->nfs_nrorps.'</SEQUENCIA>';
					$this->xml .= '</IDENTIFICACAO>';
				$this->xml .= '</NFSE>';
				
			}
			
			return $this->xml;
			
		}
		
		public function signXML($docxml, $tagid='', $tagappend=''){
			
			//namespace
			if($this->codmun=="4117503"){
				$ns = "xd:";
			}else{
				$ns = "";
			}
			
			// obter o chave privada para a ssinatura
			$fp = fopen($this->priKEY, "r");
			$priv_key = fread($fp, 8192);
			fclose($fp);
			$pkeyid = openssl_get_privatekey($priv_key);
			// limpeza do xml com a retirada dos CR, LF e TAB
			$order = array("\r\n", "\n", "\r", "\t");
			$replace = '';
			$docxml = str_replace($order, $replace, $docxml);
			// carrega o documento no DOM
			$xmldoc = new DOMDocument();
			$xmldoc->preservWhiteSpace = false; //elimina espaços em branco
			$xmldoc->formatOutput = false;
			// muito importante deixar ativadas as opçoes para limpar os espacos em branco
			// e as tags vazias
			$xmldoc->loadXML($docxml,LIBXML_NOBLANKS | LIBXML_NOEMPTYTAG);
			$root = $xmldoc->documentElement;
			//extrair a tag com os dados a serem assinados
			$node = $xmldoc->getElementsByTagName($tagid)->item(0);
			// $id = trim($node->getAttribute("Id"));
			// $idnome = preg_replace('/[^0-9]/','', $id);
			//extrai os dados da tag para uma string
			$dados = $node->C14N(false,false,NULL,NULL);
			//calcular o hash dos dados
			$hashValue = hash('sha1',$dados,true);
			//converte o valor para base64 para serem colocados no xml
			$digValue = base64_encode($hashValue);
			//monta a tag da assinatura digital
			$Signature = $xmldoc->createElement($ns.'Signature');
			// $root->appendChild($Signature);
			$append = $xmldoc->getElementsByTagName($tagappend)->item(0);
			$append->appendChild($Signature);
			$Signature->setAttribute('xmlns', $this->URLdsig);
			$SignedInfo = $xmldoc->createElement($ns.'SignedInfo');
			$Signature->appendChild($SignedInfo);
			//Cannocalization
			$newNode = $xmldoc->createElement($ns.'CanonicalizationMethod');
			$SignedInfo->appendChild($newNode);
			$newNode->setAttribute('Algorithm', $this->URLCanonMeth);
			//SignatureMethod
			$newNode = $xmldoc->createElement($ns.'SignatureMethod');
			$SignedInfo->appendChild($newNode);
			$newNode->setAttribute('Algorithm', $this->URLSigMeth);
			//Reference
				$Reference = $xmldoc->createElement($ns.'Reference');
				$SignedInfo->appendChild($Reference);
				if($this->codmun=="3550308"){
					$Reference->setAttribute('URI', '');
				}elseif($this->codmun=="4114104" || $this->codmun=="4208906"){
					if($tagid=="InfPedidoCancelamento"){
						$Reference->setAttribute('URI', '#1');
					}else{
						$Reference->setAttribute('URI', '#lote1');
					}
				}else{
					$Reference->setAttribute('URI', '#L1');
				}
				
				if($this->codmun=="4117503" || $this->codmun=="3550308" || $this->codmun=="4114104" || $this->codmun=="4208906"){
					//Transforms
					$Transforms = $xmldoc->createElement($ns.'Transforms');
					$Reference->appendChild($Transforms);
					//Transform
					$newNode = $xmldoc->createElement($ns.'Transform');
					$Transforms->appendChild($newNode);
					$newNode->setAttribute('Algorithm', $this->URLTransfMeth_1);
					//Transform
					$newNode = $xmldoc->createElement($ns.'Transform');
					$Transforms->appendChild($newNode);
					$newNode->setAttribute('Algorithm', $this->URLTransfMeth_2);
				}
			
				//DigestMethod
				$newNode = $xmldoc->createElement($ns.'DigestMethod');
				$Reference->appendChild($newNode);
				$newNode->setAttribute('Algorithm', $this->URLDigestMeth);
				//DigestValue
				$newNode = $xmldoc->createElement($ns.'DigestValue',$digValue);
				$Reference->appendChild($newNode);
				// extrai os dados a serem assinados para uma string
				$dados = $SignedInfo->C14N(false,false,NULL,NULL);
				//inicializa a variavel que irá receber a assinatura
				$signature = '';
				//executa a assinatura digital usando o resource da chave privada
				$resp = openssl_sign($dados,$signature,$pkeyid);
				//codifica assinatura para o padrao base64
				$signatureValue = base64_encode($signature);
				//SignatureValue
				$newNode = $xmldoc->createElement($ns.'SignatureValue',$signatureValue);
				$Signature->appendChild($newNode);				
				//KeyInfo
				$KeyInfo = $xmldoc->createElement($ns.'KeyInfo');
				$Signature->appendChild($KeyInfo);
				//X509Data
				$X509Data = $xmldoc->createElement($ns.'X509Data');
				$KeyInfo->appendChild($X509Data);
				//carrega o certificado sem as tags de inicio e fim
				$cert = $this->__cleanCerts($this->pubKEY);
				//X509Certificate
				$newNode = $xmldoc->createElement($ns.'X509Certificate',$cert);
				$X509Data->appendChild($newNode);
				//grava na string o objeto DOM
				$docxml = $xmldoc->saveXML();
				// libera a memoria
				openssl_free_key($pkeyid);
				//retorna o documento assinado
			return $docxml;
		} //fim signXML
		
		public function sendLot($xml){
			
			//Maringá
			if($this->codmun=="4115200"){
				$data = '<?xml version="1.0" encoding="UTF-8"?>';
				$data.= '<soapenv:Envelope xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/" xmlns:ws="https://isseteste.maringa.pr.gov.br/ws/">';
				$data.= '<soapenv:Header/><soapenv:Body><EnviarLoteRpsSincrono soapenv:encodingStyle="http://schemas.xmlsoap.org/soap/encoding/"><xml xsi:type="xsd:string"><![CDATA['.$xml.']]></xml></EnviarLoteRpsSincrono></soapenv:Body></soapenv:Envelope>';
				$tamanho = strlen($data);
				$parametros = Array('Content-Type: application/soap+xml;charset=utf-8;action="'.$this->endpoint.'"',"Content-length: $tamanho");
			//Antigo Sarandi
			}elseif($this->codmun=="32984327498743974743"){
				$data = '<?xml version="1.0" encoding="US-ASCII"?>';
				$data.= '<soapenv:Envelope xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/" xmlns:urn="urn:sigiss_ws">';
				$data.= '<soapenv:Header/><soapenv:Body><urn:GerarNota soapenv:encodingStyle="http://schemas.xmlsoap.org/soap/encoding/">'.$xml.'</urn:GerarNota></soapenv:Body></soapenv:Envelope>';
				$tamanho = strlen($data);
				$parametros = Array('Content-Type: text/xml;charset=US-ASCII;action="'.$this->endpoint.'"',"Content-length: $tamanho", 'SOAPAction: "'.$this->endpoint.'#GerarNota"');
			//Paiçandu
			}elseif($this->codmun=="4117503"){
				$data = '<?xml version="1.0" encoding="ISO-8859-1"?>';
				$data.= '<soap:Envelope xmlns:soap="http://www.w3.org/2003/05/soap-envelope" xmlns:nfse="nfse"><soap:Header/><soap:Body><nfse:Nfse.Execute><nfse:Operacao>1</nfse:Operacao><nfse:Usuario>'.$this->company->emp_cpfcnpj.'</nfse:Usuario>';
				$data.= '<nfse:Senha>'.md5($this->company->emp_path_acbr).'</nfse:Senha><nfse:Webxml>'.htmlentities($xml).'</nfse:Webxml></nfse:Nfse.Execute></soap:Body></soap:Envelope>';
				$tamanho = strlen($data);
				$parametros = Array('Content-Type: text/xml;charset=ISO-8859-1;action="'.$this->endpoint.'"',"Content-length: $tamanho", 'SOAPAction: "'.$this->endpoint.'');
			//Mandaguaçu/ jaragua do sul
			}elseif($this->codmun=="4114104" || $this->codmun=="4208906"){
				$data = '<?xml version="1.0" encoding="UTF-8"?>';
				$data.= '<soapenv:Envelope xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/" xmlns:e="http://www.betha.com.br/e-nota-contribuinte-ws">';
				$data.= '<soapenv:Header/><soapenv:Body><e:GerarNfse><nfseCabecMsg><![CDATA[<cabecalho xmlns="http://www.betha.com.br/e-nota-contribuinte-ws" versao="2.02"><versaoDados>2.02</versaoDados></cabecalho>]]>';
				$data.= '</nfseCabecMsg><nfseDadosMsg><![CDATA['.$xml.']]></nfseDadosMsg></e:GerarNfse></soapenv:Body></soapenv:Envelope>';
				$tamanho = strlen($data);
				$parametros = Array('Content-Type: application/soap+xml;charset=utf-8;action="'.$this->endpoint.'"',"Content-length: $tamanho");
			//Porto Rico / Doutor Camargo / Sarandi
			}elseif($this->codmun=="4120200" || $this->codmun=="4107306" || $this->codmun=="4126256"){
				$data = '<?xml version="1.0" encoding="UTF-8"?>';
				$data = '<soapenv:Envelope xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/" xmlns:nfse="http://shad.elotech.com.br/schemas/iss/nfse_v2_03.xsd">';
				$data.= '<soapenv:Header/><soapenv:Body>'.$xml.'</soapenv:Body></soapenv:Envelope>';
				$tamanho = strlen($data);
				$parametros = Array('Content-Type: text/xml;charset=ISO-8859-1;action="'.$this->endpoint.'"',"Content-length: $tamanho", 'SOAPAction: "'.$this->endpoint.'');
			//São Paulo
			}elseif($this->codmun=="3550308"){
				$data = '<?xml version="1.0" encoding="UTF-8"?>';
				$data.= '<soapenv:Envelope xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/" xmlns:nfe="http://www.prefeitura.sp.gov.br/nfe">';
				$data.= '<soapenv:Header/><soapenv:Body><nfe:EnvioRPSRequest><nfe:VersaoSchema>1</nfe:VersaoSchema><nfe:MensagemXML><![CDATA['.$xml.']]></nfe:MensagemXML></nfe:EnvioRPSRequest></soapenv:Body></soapenv:Envelope>';
				$tamanho = strlen($data);
				$parametros = Array('Content-Type: text/xml;charset=utf-8;action="'.$this->endpoint.'"',"Content-length: $tamanho");
			//Uniflor
			}elseif($this->codmun=="4128302"){
				$data = '<?xml version="1.0" encoding="UTF-8"?>';
				$data.= '<soapenv:Envelope xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/" xmlns:ser="http://services.enfsws.es">';
				$data.= '<soapenv:Header/><soapenv:Body><ser:esRecepcionarLoteRps><ser:xml><![CDATA['.$xml.']]></ser:xml></ser:esRecepcionarLoteRps></soapenv:Body></soapenv:Envelope>';
				$tamanho = strlen($data);
				$parametros = Array('Content-Type: text/xml;charset=utf-8;action="'.$this->endpoint.'"',"Content-length: $tamanho");
			}

			$oCurl = curl_init();			
			curl_setopt($oCurl, CURLOPT_URL, $this->endpoint);
			if($this->codmun!="4117503") curl_setopt($oCurl, CURLOPT_PORT , 443);
			curl_setopt($oCurl, CURLOPT_VERBOSE, 1); //apresenta informações de conexão na tela
			curl_setopt($oCurl, CURLOPT_SSLVERSION, 6);
			curl_setopt($oCurl, CURLOPT_SSL_VERIFYHOST, 0);
			curl_setopt($oCurl, CURLOPT_SSL_VERIFYPEER, 0);
			curl_setopt($oCurl, CURLOPT_SSLCERT, $this->pubKEY);
			curl_setopt($oCurl, CURLOPT_SSLKEY, $this->priKEY);
			curl_setopt($oCurl, CURLOPT_POST, 1);
			curl_setopt($oCurl, CURLOPT_POSTFIELDS, $data);
			curl_setopt($oCurl, CURLOPT_RETURNTRANSFER, 1);
			curl_setopt($oCurl, CURLOPT_HEADER, true); 
			curl_setopt($oCurl, CURLOPT_HTTPHEADER,$parametros);
			$__xml = curl_exec($oCurl);
			if (curl_errno($oCurl)) {
				echo "Erro cURL: " . curl_error($oCurl);
			}

			if ($__xml) {
				$doc = new DOMDocument();
				$doc->loadXML($__xml);
				$nome = $this->dirTemporaria . $this->anomes . '/' . $this->nfs_nrorps . '-ret.xml';
				$nome = $doc->save($nome);
			} else {
				exit( 'Nao houve retorno Soap verifique a mensagem de erro e o debug!!');
			}
			
			$n = strlen($__xml);
			//Maringá
			if($this->codmun=="4115200"){
				// $x = stripos($__xml, "&lt;?xml");
				
				
				// $__xml = substr($__xml, $x, ($n-$x-86));
			// Antigo Sarandi
			}elseif($this->codmun=="749247947239473274"){
				$x = stripos($__xml, "<ns1:GerarNota");
				$__xml = substr($__xml, $x, ($n-$x-36));
			//Paiçandu
			}elseif($this->codmun=="4117503"){
				$x = stripos($__xml, "<Mensagem");
				$__xml = substr($__xml, $x, ($n-$x-64));
			//Mandaguaçu/ jaragua do sul
			}elseif($this->codmun=="4114104" || $this->codmun=="4208906"){
				$x = stripos($__xml, "&lt;ListaNfse&gt;");
				$__xml = substr($__xml, $x, ($n-$x-87));
			//Porto Rico / Doutor Camargo / Sarandi
			}elseif($this->codmun=="4120200" || $this->codmun=="4107306" || $this->codmun=="4126256"){
				$x = stripos($__xml, '<ns2:');
				$__xml = substr($__xml, $x, ($n-$x-36));
				// print_r($__xml);
				// exit();
			//São Paulo
			}elseif($this->codmun=="3550308"){
				$x = stripos($__xml, "&lt;?xml");
				$__xml = substr($__xml, $x, ($n-$x-60));
			//Uniflor
			}elseif($this->codmun=="4128302"){
				//$x = stripos($__xml, "&lt;?xml");
				//$__xml = substr($__xml, $x, ($n-$x-60));
				print_r($__xml);
				exit();
			}
			curl_close($oCurl);

			//tratamento do retorno			
			$ret = array();
			//Maringá
			if($this->codmun=="4115200"){
				if( strstr($__xml, "CompNfse")==true ){
					$x = stripos($__xml, "<ListaNfse");
					$__xml = substr($__xml, $x, ($n-$x-120));
				}else{
					$x = stripos($__xml, "<ListaMensagemRetorno");
					$__xml = substr($__xml, $x, ($n-$x-120));
				}
				$retorno = simplexml_load_string(html_entity_decode($__xml));
				if($retorno->CompNfse && $retorno->CompNfse->Nfse){
					$ret["DataRecebimento"] = ($retorno->CompNfse->Nfse->InfNfse->DataEmissao) ? str_replace("T", " ", (string)$retorno->CompNfse->Nfse->InfNfse->DataEmissao) : "";
					$ret["CodigoVerificacao"] = ($retorno->CompNfse->Nfse->InfNfse->CodigoVerificacao) ? (string)$retorno->CompNfse->Nfse->InfNfse->CodigoVerificacao : "";
					$ret["NumeroNfse"] = ($retorno->CompNfse->Nfse->InfNfse->Numero) ? (string)$retorno->CompNfse->Nfse->InfNfse->Numero : "";
					$ret["XML"] = html_entity_decode($__xml);
				}else{
					$x = stripos($__xml, "<ListaMensagemRetornoLote");
					$__xml = substr($__xml, $x, ($n-$x-87));
					$retorno = simplexml_load_string(html_entity_decode($__xml));
					if($retorno->MensagemRetorno){
						foreach($retorno->MensagemRetorno as $msg){
							array_push($ret, array("Codigo"=>(string)$msg->Codigo, "Erro"=>(string)$msg->Mensagem));
						}
					}
				}
			//Antigo Sarandi
			}elseif($this->codmun=="983749329844374"){
				$retorno = simplexml_load_string(utf8_encode($__xml));
				if($retorno->RetornoNota && $retorno->RetornoNota->Nota && (int)$retorno->RetornoNota->Nota>0){
					$ret["DataRecebimento"] = date("Y-m-d H:i:s");
					$ret["CodigoVerificacao"] = ($retorno->RetornoNota->autenticidade) ? (string)$retorno->RetornoNota->autenticidade : "";
					$ret["NumeroNfse"] = ($retorno->RetornoNota->Nota) ? (string)$retorno->RetornoNota->Nota : "";
					$ret["XML"] = ($retorno->RetornoNota->LinkImpressao) ? (string)$retorno->RetornoNota->LinkImpressao : "";
				}elseif($retorno->DescricaoErros && $retorno->DescricaoErros->item){
					foreach($retorno->DescricaoErros->item as $msg){
						array_push($ret, array("Codigo"=>(string)$msg->DescricaoProcesso, "Erro"=>(string)$msg->DescricaoErro));
					}
				}else{
					$ret = $retorno;
				}
			//Paiçandu
			}elseif($this->codmun=="4117503"){
				sleep(6);
				$data = '<?xml version="1.0" encoding="ISO-8859-1"?>';
				$data.= '<soap:Envelope xmlns:soap="http://www.w3.org/2003/05/soap-envelope" xmlns:nfse="nfse"><soap:Header/><soap:Body><nfse:Nfse.Execute><nfse:Operacao>3</nfse:Operacao><nfse:Usuario>'.$this->company->emp_cpfcnpj.'</nfse:Usuario>';
				$data.= '<nfse:Senha>'.md5($this->company->emp_path_acbr).'</nfse:Senha><nfse:Webxml>'.htmlentities("<NFSE><IDENTIFICACAO><INSCRICAO>".$this->company->emp_inscrmun."</INSCRICAO><LOTE>".$this->company->emp_nfselote."</LOTE><SEQUENCIA>".$this->nfs_nrorps."</SEQUENCIA></IDENTIFICACAO></NFSE>").'</nfse:Webxml></nfse:Nfse.Execute></soap:Body></soap:Envelope>';
				$tamanho = strlen($data);
				$parametros = Array('Content-Type: text/xml;charset=ISO-8859-1;action="'.$this->endpoint.'"',"Content-length: $tamanho", 'SOAPAction: "'.$this->endpoint.'');
				$oCurl = curl_init();			
				curl_setopt($oCurl, CURLOPT_URL, $this->endpoint);
				curl_setopt($oCurl, CURLOPT_SSLVERSION, 6);
				curl_setopt($oCurl, CURLOPT_SSLCERT, $this->pubKEY);
				curl_setopt($oCurl, CURLOPT_SSLKEY, $this->priKEY);
				curl_setopt($oCurl, CURLOPT_POST, 1);
				curl_setopt($oCurl, CURLOPT_POSTFIELDS, $data);
				curl_setopt($oCurl, CURLOPT_RETURNTRANSFER, 1);
				curl_setopt($oCurl, CURLOPT_HTTPHEADER,$parametros);
				$__xml = curl_exec($oCurl);
				$x = stripos($__xml, "&lt;NFSE&gt;");
				$n = strlen($__xml);
				$__xml = html_entity_decode(substr($__xml, $x, ($n-$x-78)));
				$retorno = simplexml_load_string($__xml);
				if($retorno->NOTA && $retorno->NOTA->COD){
					$ret["DataRecebimento"] = date("Y-m-d H:i:s");
					$ret["CodigoVerificacao"] = ($retorno->NOTA->RPS) ? (string)$retorno->NOTA->RPS : "";
					$ret["NumeroNfse"] = ($retorno->NOTA->COD) ? (string)$retorno->NOTA->COD : "";
					$ret["Lote"] = ($retorno->NOTA->LOTE) ? (string)$retorno->NOTA->LOTE : "";
					$ret["XML"] = $__xml;
				}else{
					$ret = $retorno;
				}
			//Mandaguaçu/ jaragua do sul
			}elseif($this->codmun=="4114104" || $this->codmun=="4208906"){
				$retorno = simplexml_load_string(html_entity_decode($__xml));
				if($retorno->CompNfse && $retorno->CompNfse->Nfse){
					$ret["DataRecebimento"] = ($retorno->CompNfse->Nfse->InfNfse->DataEmissao) ? str_replace("T", " ", (string)$retorno->CompNfse->Nfse->InfNfse->DataEmissao) : "";
					$ret["CodigoVerificacao"] = ($retorno->CompNfse->Nfse->InfNfse->CodigoVerificacao) ? (string)$retorno->CompNfse->Nfse->InfNfse->CodigoVerificacao : "";
					$ret["NumeroNfse"] = ($retorno->CompNfse->Nfse->InfNfse->Numero) ? (string)$retorno->CompNfse->Nfse->InfNfse->Numero : "";
					$ret["XML"] = html_entity_decode($__xml);
				}else{
					$x = stripos($__xml, ' &lt;ListaMensagemRetorno&gt;');
					$__xml = substr($__xml, $x, ($n));
					$retorno = simplexml_load_string(html_entity_decode($__xml));
					if($retorno->MensagemRetorno){
						foreach($retorno->MensagemRetorno as $msg){
							array_push($ret, array("Codigo"=>(string)$msg->Codigo, "Erro"=>(string)$msg->Mensagem));
						}
					}
				}
			//Porto Rico / Doutor Camargo / Sarandi
			}elseif($this->codmun=="4120200" || $this->codmun=="4107306" || $this->codmun=="4126256"){
				$retorno = simplexml_load_string(str_replace("ns2:", "", $__xml));			
				if($retorno->ListaMensagemRetornoLote && $retorno->ListaMensagemRetornoLote->MensagemRetorno){
					foreach($retorno->ListaMensagemRetornoLote->MensagemRetorno as $msg){
						array_push($ret, array("Codigo"=>(string)$msg->Codigo, "Erro"=>(string)$msg->Mensagem));
					}
				}elseif($retorno->ListaNfse){
					$ret["DataRecebimento"] = ($retorno->DataRecebimento) ? str_replace("T", " ", (string)$retorno->DataRecebimento) : "";
					$ret["CodigoVerificacao"] = ($retorno->ListaNfse->CompNfse->Nfse->InfNfse->CodigoVerificacao) ? (string)$retorno->ListaNfse->CompNfse->Nfse->InfNfse->CodigoVerificacao : "";
					$ret["NumeroNfse"] = ($retorno->ListaNfse->CompNfse->Nfse->InfNfse->Numero) ? (string)$retorno->ListaNfse->CompNfse->Nfse->InfNfse->Numero : "";
					$ret["ChaveAcesso"] = ($retorno->ListaNfse->CompNfse->Nfse->InfNfse->ChaveAcesso) ? (string)$retorno->ListaNfse->CompNfse->Nfse->InfNfse->ChaveAcesso : "";
					$ret["XML"] = html_entity_decode($retorno->ListaNfse->CompNfse->Xml);
				}
			//São Paulo
			}if($this->codmun=="3550308"){

				$retorno = simplexml_load_string(html_entity_decode($__xml));
				if($retorno->Erro){
					foreach($retorno->Erro as $msg){
						array_push($ret, array("Codigo"=>(string)$msg->Codigo, "Erro"=>(string)$msg->Descricao));
					}
				}elseif($retorno->ChaveNFeRPS && $retorno->ChaveNFeRPS->ChaveNFe){
					
					$ret["DataRecebimento"] = date("Y-m-d H:i:s");
					$ret["CodigoVerificacao"] = ($retorno->ChaveNFeRPS->ChaveNFe->CodigoVerificacao) ? (string)$retorno->ChaveNFeRPS->ChaveNFe->CodigoVerificacao : "";
					$ret["NumeroNfse"] = ($retorno->ChaveNFeRPS->ChaveNFe->NumeroNFe) ? (string)$retorno->ChaveNFeRPS->ChaveNFe->NumeroNFe : "";
					$ret["XML"] = html_entity_decode($__xml);
					
				}

			}
			
			return $ret;

		}
		
		public function cancelar($xml){
			
			//Maringá
			if($this->codmun=="4115200"){
				$data = '<?xml version="1.0" encoding="UTF-8"?>';
				$data.= '<soapenv:Envelope xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/" xmlns:ws="https://isseteste.maringa.pr.gov.br/ws/">';
				$data.= '<soapenv:Header/><soapenv:Body><ws:CancelarNfse soapenv:encodingStyle="http://schemas.xmlsoap.org/soap/encoding/"><xml xsi:type="xsd:string"><![CDATA['.$xml.']]></xml></ws:CancelarNfse></soapenv:Body></soapenv:Envelope>';
				
				$tamanho = strlen($data);
				$parametros = Array('Content-Type: application/soap+xml;charset=utf-8;action="'.$this->endpoint.'"',"Content-length: $tamanho");
			//Antigo Sarandi
			}elseif($this->codmun=="324324324324989"){
				$data = '<?xml version="1.0" encoding="US-ASCII"?>';
				$data.= '<soapenv:Envelope xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/" xmlns:urn="urn:sigiss_ws">';
				$data.= '<soapenv:Header/><soapenv:Body><urn:CancelarNota soapenv:encodingStyle="http://schemas.xmlsoap.org/soap/encoding/">'.$xml.'</urn:CancelarNota></soapenv:Body></soapenv:Envelope>';
				
				$tamanho = strlen($data);
				$parametros = Array('Content-Type: text/xml;charset=US-ASCII;action="'.$this->endpoint.'"',"Content-length: $tamanho", 'SOAPAction: "'.$this->endpoint.'#CancelarNota"');
			//Paiçandu
			}elseif($this->codmun=="4117503"){
				$data = '<?xml version="1.0" encoding="ISO-8859-1"?>';
				$data.= '<soap:Envelope xmlns:soap="http://www.w3.org/2003/05/soap-envelope" xmlns:nfse="nfse"><soap:Header/><soap:Body><nfse:Nfse.Execute><nfse:Operacao>2</nfse:Operacao><nfse:Usuario>'.$this->company->emp_cpfcnpj.'</nfse:Usuario>';
				$data.= '<nfse:Senha>'.md5($this->company->emp_path_acbr).'</nfse:Senha><nfse:Webxml>'.htmlentities($xml).'</nfse:Webxml></nfse:Nfse.Execute></soap:Body></soap:Envelope>';
				$tamanho = strlen($data);
				$parametros = Array('Content-Type: text/xml;charset=ISO-8859-1;action="'.$this->endpoint.'"',"Content-length: $tamanho", 'SOAPAction: "'.$this->endpoint.'');
			//Mandaguaçu/ jaragua do sul
			}elseif($this->codmun=="4114104" || $this->codmun=="4208906"){
				$data = '<?xml version="1.0" encoding="UTF-8"?>';
				$data.= '<soapenv:Envelope xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/" xmlns:e="http://www.betha.com.br/e-nota-contribuinte-ws">';
				$data.= '<soapenv:Header/><soapenv:Body><e:CancelarNfse><nfseCabecMsg><![CDATA[<cabecalho xmlns="http://www.betha.com.br/e-nota-contribuinte-ws" versao="2.02"><versaoDados>2.02</versaoDados></cabecalho>]]>';
				$data.= '</nfseCabecMsg><nfseDadosMsg><![CDATA['.$xml.']]></nfseDadosMsg></e:CancelarNfse></soapenv:Body></soapenv:Envelope>';
				$tamanho = strlen($data);
				$parametros = Array('Content-Type: application/soap+xml;charset=utf-8;action="'.$this->endpoint.'"',"Content-length: $tamanho");
			//Porto Rico / Doutor Camargo / Sarandi
			}elseif($this->codmun=="4120200" || $this->codmun=="4107306" || $this->codmun=="4126256"){
				$data = '<?xml version="1.0" encoding="UTF-8"?>';
				$data = '<soapenv:Envelope xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/" xmlns:nfse="http://shad.elotech.com.br/schemas/iss/nfse_v2_03.xsd">';
				$data.= '<soapenv:Header/><soapenv:Body>'.$xml.'</soapenv:Body></soapenv:Envelope>';
				$tamanho = strlen($data);
				$parametros = Array('Content-Type: text/xml;charset=ISO-8859-1;action="'.$this->endpoint.'"',"Content-length: $tamanho", 'SOAPAction: "'.$this->endpoint.'');
			// São Paulo
			}elseif($this->codmun=="3550308"){
				$data = '<?xml version="1.0" encoding="UTF-8"?>';
				$data.= '<soapenv:Envelope xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/" xmlns:nfe="http://www.prefeitura.sp.gov.br/nfe">';
				$data.= '<soapenv:Header/><soapenv:Body><nfe:CancelamentoNFeRequest><nfe:VersaoSchema>1</nfe:VersaoSchema><nfe:MensagemXML><![CDATA['.$xml.']]></nfe:MensagemXML></nfe:CancelamentoNFeRequest></soapenv:Body></soapenv:Envelope>';
				$tamanho = strlen($data);
				$parametros = Array('Content-Type: text/xml;charset=utf-8;action="'.$this->endpoint.'"',"Content-length: $tamanho");
			}
			
			$oCurl = curl_init();			
			curl_setopt($oCurl, CURLOPT_URL, $this->endpoint);
			if($this->codmun!="4117503") curl_setopt($oCurl, CURLOPT_PORT , 443);
			curl_setopt($oCurl, CURLOPT_VERBOSE, 1); //apresenta informações de conexão na tela
			curl_setopt($oCurl, CURLOPT_SSLVERSION, 6);
			curl_setopt($oCurl, CURLOPT_SSL_VERIFYHOST, 0);
			curl_setopt($oCurl, CURLOPT_SSL_VERIFYPEER, 0);
			curl_setopt($oCurl, CURLOPT_SSLCERT, $this->pubKEY);
			curl_setopt($oCurl, CURLOPT_SSLKEY, $this->priKEY);
			curl_setopt($oCurl, CURLOPT_POST, 1);
			curl_setopt($oCurl, CURLOPT_POSTFIELDS, $data);
			curl_setopt($oCurl, CURLOPT_RETURNTRANSFER, 1);
			curl_setopt($oCurl, CURLOPT_HTTPHEADER,$parametros);
			$__xml = curl_exec($oCurl);

			if ($__xml) {
				$doc = new DOMDocument();
				$doc->loadXML($__xml);
				$nome = $this->dirCancelada . $this->anomes . '/' . $this->rowdata->nfs_nronfse . '-retcanc.xml';
				$nome = $doc->save($nome);
			} else {
				exit( 'Nao houve retorno Soap verifique a mensagem de erro e o debug!!');
			}
			curl_close($oCurl);
			$n = strlen($__xml);
			
			//Maringá
			if($this->codmun=="4115200"){
				// $x = stripos($__xml, "&lt;?");
				$x = stripos($__xml, "<CancelarNfseResposta");
				// $__xml = substr($__xml, $x, ($n-$x-73));
				$__xml = substr($__xml, $x, ($n-$x-77));
			//Antigo Sarandi
			}elseif($this->codmun=="93829408329408408"){
				$x = stripos($__xml, "<ns1:CancelarNota");
				$__xml = substr($__xml, $x, ($n-$x-36));
			//Paiçandu
			}elseif($this->codmun=="4117503"){
				$x = stripos($__xml, "&lt;NFSE&gt;");
				$__xml = substr($__xml, $x, ($n-$x-77));
			//Mandaguaçu/ jaragua do sul
			}elseif($this->codmun=="4114104" || $this->codmun=="4208906"){
				$x = stripos($__xml, "&lt;CancelarNfseResposta");
				$__xml = substr($__xml, $x, ($n-$x-62));
			//Porto Rico / Doutor Camargo / Sarandi
			}elseif($this->codmun=="4120200" || $this->codmun=="4107306" || $this->codmun=="4126256"){
				$x = stripos($__xml, '<ns2:');
				$__xml = substr($__xml, $x, ($n-$x-36));
			//São Paulo
			}elseif($this->codmun=="3550308"){
				$x = stripos($__xml, "&lt;?xml");
				$__xml = substr($__xml, $x, ($n-$x-67));
			}
			
			//tratamento do retorno			
			$ret = array();
			//Maringá
			if($this->codmun=="4115200"){
				$retorno = simplexml_load_string(html_entity_decode($__xml));
				if($retorno->ListaMensagemRetorno && $retorno->ListaMensagemRetorno->MensagemRetorno){
					foreach($retorno->ListaMensagemRetorno->MensagemRetorno as $msg){
						array_push($ret, array("Codigo"=>(string)$msg->Codigo, "Erro"=>(string)$msg->Mensagem));
					}
				}elseif($retorno->RetCancelamento && $retorno->RetCancelamento->NfseCancelamento && $retorno->RetCancelamento->NfseCancelamento->Confirmacao && $retorno->RetCancelamento->NfseCancelamento->Confirmacao->DataHora ){
					$ret["DataCancelamento"] = str_replace("T", " ", (string) $retorno->RetCancelamento->NfseCancelamento->Confirmacao->DataHora);
				}else{
					$ret = $retorno;
				}
			//Antigo Sarandi
			}elseif($this->codmun=="94380182302183"){
				$retorno = simplexml_load_string(utf8_encode($__xml));
				if($retorno->RetornoNota && $retorno->RetornoNota->Nota && (int)$retorno->RetornoNota->Nota>0){
					$ret["DataCancelamento"] = date("Y-m-d H:i:s");
				}elseif($retorno->DescricaoErros && $retorno->DescricaoErros->item){
					foreach($retorno->DescricaoErros->item as $msg){
						array_push($ret, array("Codigo"=>(string)$msg->DescricaoProcesso, "Erro"=>(string)$msg->DescricaoErro));
					}
				}else{
					$ret = $retorno;
				}
			//Paiçandu
			}elseif($this->codmun=="4117503"){
				$retorno = simplexml_load_string(html_entity_decode($__xml));
				if($retorno->NOTA){
					$ret["DataCancelamento"] = date("Y-m-d");
				}else{
					$ret = $retorno;
				}
			//Mandaguaçu/ jaragua do sul
			}elseif($this->codmun=="4114104" || $this->codmun=="4208906"){
				$retorno = simplexml_load_string(html_entity_decode($__xml));
				if($retorno->ListaMensagemRetorno && $retorno->ListaMensagemRetorno->MensagemRetorno){
					foreach($retorno->ListaMensagemRetorno->MensagemRetorno as $msg){
						array_push($ret, array("Codigo"=>(string)$msg->Codigo, "Erro"=>(string)$msg->Mensagem));
					}
				}elseif($retorno->RetCancelamento && $retorno->RetCancelamento->NfseCancelamento && $retorno->RetCancelamento->NfseCancelamento->Confirmacao && $retorno->RetCancelamento->NfseCancelamento->Confirmacao->DataHora ){
					$ret["DataCancelamento"] = str_replace("T", " ", (string) $retorno->RetCancelamento->NfseCancelamento->Confirmacao->DataHora);
				}else{
					$ret = $retorno;
				}
			//Porto Rico / Doutor Camargo / Sarandi
			}elseif($this->codmun=="4120200" || $this->codmun=="4107306" || $this->codmun=="4126256"){
				$retorno = simplexml_load_string(str_replace("ns2:", "", $__xml));
				if($retorno->ListaMensagemRetorno && $retorno->ListaMensagemRetorno->MensagemRetorno){
					foreach($retorno->ListaMensagemRetorno->MensagemRetorno as $msg){
						array_push($ret, array("Codigo"=>(string)$msg->Codigo, "Erro"=>(string)$msg->Mensagem));
					}
				}elseif($retorno->tcRetCancelamento && $retorno->tcRetCancelamento->NfseCancelamento && $retorno->tcRetCancelamento->NfseCancelamento->ConfirmacaoCancelamento && $retorno->tcRetCancelamento->NfseCancelamento->ConfirmacaoCancelamento->Pedido ){
					$ret["DataCancelamento"] = date("Y-m-d");
				}else{
					$ret = $retorno;
				}
			//São Paulo
			}elseif($this->codmun=="3550308"){
				$retorno = simplexml_load_string(html_entity_decode($__xml));
				if($retorno->Alerta && $retorno->Alerta->Codigo){
					foreach($retorno->Alerta as $msg){
						array_push($ret, array("Codigo"=>(string)$msg->Codigo, "Erro"=>(string)$msg->Descricao));
					}
				}elseif($retorno->Cabecalho && $retorno->Cabecalho->Sucesso ){
					$ret["DataCancelamento"] = date("Y-m-d");
				}else{
					$ret = $retorno;
				}
			}

			return $ret;

		}
		
		public function consultar($xml){
			
			//Maringá
			if($this->codmun=="4115200"){
				$data = '<?xml version="1.0" encoding="UTF-8"?>';
				$data.= '<soapenv:Envelope xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/" xmlns:ws="https://isseteste.maringa.pr.gov.br/ws/">';
				$data.= '<soapenv:Header/><soapenv:Body><ws:ConsultarNfseServicoPrestado soapenv:encodingStyle="http://schemas.xmlsoap.org/soap/encoding/"><xml xsi:type="xsd:string"><![CDATA['.$xml.']]></xml></ws:ConsultarNfseServicoPrestado></soapenv:Body></soapenv:Envelope>';
				$tamanho = strlen($data);
				$parametros = Array('Content-Type: application/soap+xml;charset=utf-8;action="'.$this->endpoint.'"',"Content-length: $tamanho");
			//Antigo Sarandi
			}elseif($this->codmun=="9827492849024383"){
				$data = '<?xml version="1.0" encoding="US-ASCII"?>';
				$data.= '<soapenv:Envelope xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/" xmlns:urn="urn:sigiss_ws">';
				$data.= '<soapenv:Header/><soapenv:Body><urn:ConsultarNotaPrestador soapenv:encodingStyle="http://schemas.xmlsoap.org/soap/encoding/">'.$xml.'</urn:ConsultarNotaPrestador></soapenv:Body></soapenv:Envelope>';
				$tamanho = strlen($data);
				$parametros = Array('Content-Type: text/xml;charset=US-ASCII;action="'.$this->endpoint.'"',"Content-length: $tamanho", 'SOAPAction: "'.$this->endpoint.'#ConsultarNotaPrestador"');
			//Paiçandu
			}elseif($this->codmun=="4117503"){
				$data = '<?xml version="1.0" encoding="ISO-8859-1"?>';
				$data.= '<soap:Envelope xmlns:soap="http://www.w3.org/2003/05/soap-envelope" xmlns:nfse="nfse"><soap:Header/><soap:Body><nfse:Nfse.Execute><nfse:Operacao>3</nfse:Operacao><nfse:Usuario>'.$this->company->emp_cpfcnpj.'</nfse:Usuario>';
				$data.= '<nfse:Senha>'.md5($this->company->emp_path_acbr).'</nfse:Senha><nfse:Webxml>'.htmlentities($xml).'</nfse:Webxml></nfse:Nfse.Execute></soap:Body></soap:Envelope>';
				$tamanho = strlen($data);
				$parametros = Array('Content-Type: text/xml;charset=ISO-8859-1;action="'.$this->endpoint.'"',"Content-length: $tamanho", 'SOAPAction: "'.$this->endpoint.'');
			}
			
			$oCurl = curl_init();
			
			curl_setopt($oCurl, CURLOPT_URL, $this->endpoint);
			if($this->codmun!="4117503") curl_setopt($oCurl, CURLOPT_PORT , 443);
			curl_setopt($oCurl, CURLOPT_VERBOSE, 1); //apresenta informações de conexão na tela
			curl_setopt($oCurl, CURLOPT_SSLVERSION, 6);
			curl_setopt($oCurl, CURLOPT_SSL_VERIFYHOST, 0);
			curl_setopt($oCurl, CURLOPT_SSL_VERIFYPEER, 0);
			curl_setopt($oCurl, CURLOPT_SSLCERT, $this->pubKEY);
			curl_setopt($oCurl, CURLOPT_SSLKEY, $this->priKEY);
			curl_setopt($oCurl, CURLOPT_POST, 1);
			curl_setopt($oCurl, CURLOPT_POSTFIELDS, $data);
			curl_setopt($oCurl, CURLOPT_RETURNTRANSFER, 1);
			curl_setopt($oCurl, CURLOPT_HTTPHEADER,$parametros);
			$__xml = curl_exec($oCurl);
			$n = strlen($__xml);
			curl_close($oCurl);
			
			//Maringá
			if($this->codmun=="4115200"){
				$x = stripos($__xml, "&lt;?");
				$__xml = substr($__xml, $x, ($n-$x-89));
			//Antigo Sarandi
			}elseif($this->codmun=="08498348329883984308324"){
				$x = stripos($__xml, "<ns1:ConsultarNotaPrestador");
				$__xml = substr($__xml, $x, ($n-$x-36));
			//Paiçandu
			}elseif($this->codmun=="4117503"){
				$x = stripos($__xml, "&lt;NFSE&gt;");
				$__xml = substr($__xml, $x, ($n-$x-46));
			}
			
			//tratamento do retorno
			$ret = array();
			//Maringá
			if($this->codmun=="4115200"){
				$retorno = simplexml_load_string(html_entity_decode($__xml));
				if($retorno->ListaMensagemRetorno && $retorno->ListaMensagemRetorno->MensagemRetorno){
					foreach($retorno->ListaMensagemRetorno->MensagemRetorno as $msg){
						array_push($ret, array("Codigo"=>(string)$msg->Codigo, "Erro"=>(string)$msg->Mensagem));
					}
				}elseif($retorno->ListaNfse && $retorno->ListaNfse->CompNfse){
					$ret["NumeroNfse"] = (string)$retorno->ListaNfse->CompNfse->Nfse->InfNfse->Numero;
					$ret["DataRecebimento"] = str_replace("T", " ", (string)$retorno->ListaNfse->CompNfse->Nfse->InfNfse->DataEmissao);
					$ret["CodigoVerificacao"] = (string)$retorno->ListaNfse->CompNfse->Nfse->InfNfse->CodigoVerificacao;
					$ret["Status"] = ( isset($retorno->ListaNfse->CompNfse->NfseCancelamento) ) ? "3" : "2";
				}else{
					$ret = $retorno;
				}
			//Antigo Sarandi
			}elseif($this->codmun=="2987439o8408430"){
				$retorno = simplexml_load_string(utf8_encode($__xml));
				$xml = utf8_encode(str_replace(array('ns1:', ' xmlns:ns1="urn:sigiss_ws"', ' xsi:type="tns:tcDadosNota"', ' xsi:type="xsd:int"', ' xsi:type="xsd:string"',' xsi:type="SOAP-ENC:Array" SOAP-ENC:arrayType="tns:tcEstruturaDescricaoErros[1]"',' xsi:type="tns:tcEstruturaDescricaoErros"'), "", $__xml));
				if($retorno->DadosNota && $retorno->DadosNota->nota && (int)$retorno->DadosNota->nota>0){
					$ret["DataRecebimento"] = date("Y-m-d H:i:s");
					$ret["CodigoVerificacao"] = ($retorno->DadosNota->autenticidade) ? (string)$retorno->DadosNota->autenticidade : "";
					$ret["NumeroNfse"] = ($retorno->DadosNota->nota) ? (string)$retorno->DadosNota->nota : "";
					$ret["XML"] = ($retorno->DadosNota->LinkImpressao) ? (string)$retorno->DadosNota->LinkImpressao : "";
					$ret["Status"] = ( isset($retorno->DadosNota->StatusNFe) && $retorno->DadosNota->StatusNFe=="Cancelada" ) ? "3" : "2";
					//salvar XML
					$nomeArquivo = $this->dirAutorizada.$this->anomes.'/'.$ret["NumeroNfse"].'-nfse.xml';
					$arquivoXML = fopen($nomeArquivo,'w+');
					fwrite($arquivoXML,$xml);
					fclose($arquivoXML);
					chmod($nomeArquivo, 0777);
				}elseif($retorno->DescricaoErros && $retorno->DescricaoErros->item){
					foreach($retorno->DescricaoErros->item as $msg){
						array_push($ret, array("Codigo"=>(string)$msg->DescricaoProcesso, "Erro"=>(string)$msg->DescricaoErro));
					}
				}else{
					$ret = $retorno;
				}
			//Paiçandu
			}elseif($this->codmun=="4117503"){
				$retorno = simplexml_load_string(html_entity_decode($__xml));
				if($retorno->NOTA && $retorno->NOTA->COD){
					$ret["NumeroNfse"] = (string)$retorno->NOTA->COD;
					$ret["DataRecebimento"] = date("Y-m-d");
					$ret["CodigoVerificacao"] = (string)$retorno->NOTA->RPS;
					$ret["Status"] = ( isset($retorno->NOTA->SITCOD) ) ? (string)$retorno->NOTA->SITCOD : "0";
					$ret["XML"] = $__xml;
					//salvar XML
					$nomeArquivo = $this->dirAutorizada.$this->anomes.'/'.$ret["NumeroNfse"].'-nfse.xml';
					$arquivoXML = fopen($nomeArquivo,'w+');
					fwrite($arquivoXML,$__xml);
					fclose($arquivoXML);
					chmod($nomeArquivo, 0777);
				}else{
					$ret = $retorno;
				}
			}
			
			return $ret;

		}
		
		protected function __cleanCerts($certFile){
			// Carregar a chave publica do arquivo pem
			$pubKey = file_get_contents($certFile);
			// Inicializa variavel
			$data = '';
			// Carrega o certificado em um array usando o LF como referencia
			$arCert = explode("\n", $pubKey);
			foreach ($arCert as $curData) {
				// Remove a tag de inicio e fim do certificado
				if (strncmp($curData, '-----BEGIN CERTIFICATE', 22) != 0 && strncmp($curData, '-----END CERTIFICATE', 20) != 0 ) {
					// Carrega o resultado numa string
					$data .= trim($curData);
				}
			}
			return $data;
		}
		
		public function getCompany(){
			return $this->company;
		}
		
		public function getRowdata(){
			return $this->rowdata;
		}
		
	}
	
	if( isset($_REQUEST["nfs_codigo"]) && $_REQUEST["nfs_codigo"]!="" ){
	
		$NFSe = new NFSe($_REQUEST["nfs_codigo"]);
		
		$rowdata = $NFSe->getRowdata();

		$acao  = (isset($_REQUEST['acao']))  ? $_REQUEST['acao']  : "";

		if($acao=='transmitir'){

			if(is_dir($NFSe->dirTemporaria.$NFSe->anomes)){
				
				$xml = $NFSe->getXML();
				
				//Assinatura
				if($NFSe->codmun=="4115200"){
					//Maringá
					$xml = $NFSe->signXML($xml, 'LoteRps', 'EnviarLoteRpsSincronoEnvio');
				}elseif($NFSe->codmun=="4114104" || $NFSe->codmun=="4208906"){
					//Mandaguaçu/ jaragua do sul
					$xml = $NFSe->signXML($xml, 'InfDeclaracaoPrestacaoServico', 'Rps');
				}elseif($NFSe->codmun=="3550308"){
					//São Paulo
					$xml = $NFSe->signXML($xml, 'PedidoEnvioRPS', 'PedidoEnvioRPS');
				}				
				
				$xml = str_replace(array("<?xml version=\"1.0\"?>","<?xml version=\"1.0\" encoding=\"UTF-8\"?>","\n"),"",$xml);
				
				// print_r($xml);
				// exit();
				
				$nomeArquivo = $NFSe->dirTemporaria.$NFSe->anomes.'/'.$rowdata->nfs_nrorps.'-rps.xml';
				$arquivoXML = fopen($nomeArquivo,'w+');
				fwrite($arquivoXML,$xml);
				fclose($arquivoXML);
				chmod($nomeArquivo, 0777);

				if($arquivoXML){

					$retorno = $NFSe->sendLot($xml);
					
					if($retorno[0]["Erro"]){
						
						foreach($retorno as $msg){
							echo $msg["Codigo"].": ".$msg["Erro"]."<br>";
						}
						
						$TParams = new TParams();
						$TParams->setHost($NFSe->TParams->getHost($NFSe->TParams->getDbSge()));
						//LOG DE ERRO			
						$filtrolog = '{"cod":"700103","params":[
							{"name":"log_tipo","value":"1","type":"integer"},
							{"name":"log_nro","value":"'.$_REQUEST["nfs_codigo"].'","type":"string"},
							{"name":"log_serie","value":"'.$rowdata->nfs_serierps.'","type":"string"},';
						$filtrolog.= ( isset($_REQUEST["usu_login"]) && $_REQUEST["usu_login"]!="" ) ? '{"name":"log_usu_login","value":"'.$_REQUEST["usu_login"].'","type":"string"},' : '{"name":"log_usu_login","value":"NULL","type":"other"},';
						$filtrolog.= '{"name":"log_acao_cod","value":"3","type":"integer"},
							{"name":"log_acao_descr","value":"transmissão","type":"string"},
							{"name":"log_data","value":"","type":"string"},
							{"name":"log_protocolo","value":"NULL","type":"other"},
							{"name":"log_ret","value":"NULL","type":"other"},
							{"name":"log_outro","value":"'.base64_encode("Erro: ".$retorno[0]["Codigo"]." - ".$retorno[0]["Erro"]).'","type":"string"}
						]}';
						$TParams->add($filtrolog);
						$TParams->open();
						$TParams->clear();
						
						//incrementar lote
						$filtroLote = '{"cod":"600003","params":[
							{"name":"emp_codigo","value":"'.$NFSe->getCompany()->emp_codigo.'","type":"string"}
						]}';
						$NFSe->TParams->setHost($NFSe->TParams->getHost("empresas"));
						$NFSe->TParams->add($filtroLote);
						$NFSe->TParams->open();
						$NFSe->TParams->clear();
						
					}elseif($retorno["XML"]){
						
						$TParams = new TParams();
						$nfs_dtfaturam = $retorno["DataRecebimento"];
						$nfseVerif = $retorno["CodigoVerificacao"];
						$nfseNum = $retorno["NumeroNfse"];
						$lote = ( isset($retorno["Lote"]) ) ? $retorno["Lote"] : 'NULL';
						$xml = $retorno["XML"];
						$chave = ( isset($retorno["ChaveAcesso"]) ) ? $retorno["ChaveAcesso"] : "";
						
						if(strlen($xml)>700){
							$nomeArquivo = $NFSe->dirAutorizada.$NFSe->anomes.'/'.$nfseNum.'-nfse.xml';
							$arquivoXML = fopen($nomeArquivo,'w+');
							fwrite($arquivoXML,$xml);
							fclose($arquivoXML);
							chmod($nomeArquivo, 0777);
							$xml = " ";
						}else{
							$xml = base64_encode($xml);
						}
				
						//ATUALIZAÇÃO DA NFS-e
						$filtro = '{"cod":"501036","params":[
							{"name":"nfs_codigo","value":"'.$_REQUEST["nfs_codigo"].'","type":"string"},
							{"name":"nfs_dtfaturam","value":"'.$nfs_dtfaturam.'","type":"string"},
							{"name":"nfs_codver","value":"'.$nfseVerif.'","type":"string"},
							{"name":"nfs_nronfref","value":"'.$lote.'","type":"integer"},
							{"name":"nfs_nronfse","value":"'.$nfseNum.'","type":"string"},
							{"name":"nfs_xml","value":"'.$xml.'","type":"string"},
							{"name":"nfs_motcanc","value":"'.$chave.'","type":"string"}
						]}';
						$TParams->setHost($NFSe->TParams->getHost($NFSe->TParams->getDbSge()));
						$TParams->add($filtro);
						
						//ATUALIZAÇÃO DO NRO DA NFSE NO DOCTO
						$filtro = '{"cod":"501080","params":[
							{"name":"nfs_codigo","value":"'.$_REQUEST["nfs_codigo"].'","type":"string"},
							{"name":"nfs_nronfse","value":"'.$nfseNum.'","type":"string"}
						]}';
						$TParams->add($filtro);
						
						echo "NFS-e transmitida com sucesso! Código de verificação: ".$nfseVerif;
						
						//LOG DE TRANSMISSAO			
						$filtrolog = '{"cod":"700103","params":[
							{"name":"log_tipo","value":"1","type":"integer"},
							{"name":"log_nro","value":"'.$_REQUEST["nfs_codigo"].'","type":"string"},
							{"name":"log_serie","value":"'.$rowdata->nfs_serierps.'","type":"string"},';
						$filtrolog.= ( isset($_REQUEST["usu_login"]) && $_REQUEST["usu_login"]!="" ) ? '{"name":"log_usu_login","value":"'.$_REQUEST["usu_login"].'","type":"string"},' : '{"name":"log_usu_login","value":"NULL","type":"other"},';
						$filtrolog.= '{"name":"log_acao_cod","value":"3","type":"integer"},
							{"name":"log_acao_descr","value":"transmissão","type":"string"},
							{"name":"log_data","value":"","type":"string"},
							{"name":"log_protocolo","value":"NULL","type":"other"},
							{"name":"log_ret","value":"NULL","type":"other"},
							{"name":"log_outro","value":"'.base64_encode("NFS-e transmitida com sucesso!").'","type":"string"}
						]}';
						$TParams->add($filtrolog);
						$TParams->open();
						$TParams->clear();
						
						//Salvar XML
						if($NFSe->codmun=="4117503"){
							$NFSe2 = new NFSe($_REQUEST["nfs_codigo"]);
							$xml = $NFSe2->getXMLCons();
							$NFSe2->consultar($xml);
						}
						
						//incrementar lote
						$filtroLote = '{"cod":"600003","params":[
							{"name":"emp_codigo","value":"'.$NFSe->getCompany()->emp_codigo.'","type":"string"}
						]}';
						$NFSe->TParams->setHost($NFSe->TParams->getHost("empresas"));
						$NFSe->TParams->add($filtroLote);
						$NFSe->TParams->open();
						$NFSe->TParams->clear();
						
					}else{
						print_r($retorno);
						
						//incrementar lote
						$filtroLote = '{"cod":"600003","params":[
							{"name":"emp_codigo","value":"'.$NFSe->getCompany()->emp_codigo.'","type":"string"}
						]}';
						$NFSe->TParams->setHost($NFSe->TParams->getHost("empresas"));
						$NFSe->TParams->add($filtroLote);
						$NFSe->TParams->open();
						$NFSe->TParams->clear();
					}

				}
			}
			
		}elseif($acao=='cancelar'){
			
			$xml = $NFSe->getXMLCanc();
			//Assinatura
			if($NFSe->codmun=="4115200"){
				//Maringá
				$xml = $NFSe->signXML($xml, 'InfPedidoCancelamento', 'Pedido');
			}elseif($NFSe->codmun=="4114104" || $NFSe->codmun=="4208906"){
				//Mandaguaçu/ jaragua do sul
				$xml = $NFSe->signXML($xml, 'InfPedidoCancelamento', 'Pedido');
			}elseif($NFSe->codmun=="3550308"){
				//São Paulo
				$xml = $NFSe->signXML($xml, 'PedidoCancelamentoNFe', 'PedidoCancelamentoNFe');
			}	
			$xml = str_replace(array("<?xml version=\"1.0\"?>","\n"),"",$xml);

			$retorno = $NFSe->cancelar($xml);

			if($retorno[0]["Erro"]){
						
				foreach($retorno as $msg){
					echo $msg["Codigo"].": ".$msg["Erro"]."<br>";
				}
				
			}elseif($retorno["DataCancelamento"]){
				
				$data =  implode("/", array_reverse( explode("-", substr($retorno["DataCancelamento"], 0, 10))));
				
				$TParams = new TParams();
				$filtro = '{"cod":"501039","params":[
					{"name":"nfs_codigo","value":"'.$_REQUEST["nfs_codigo"].'","type":"string"},
					{"name":"nfs_motcanc","value":"'.$_REQUEST["motivo"].'","type":"string"}
				]}';
				$TParams->setHost($NFSe->TParams->getHost($NFSe->TParams->getDbSge()));
				$TParams->add($filtro);					
				
				//LOG DE CANCELAMENTO
				$filtrolog = '{"cod":"700103","params":[
					{"name":"log_tipo","value":"1","type":"integer"},
					{"name":"log_nro","value":"'.$_REQUEST["nfs_codigo"].'","type":"string"},
					{"name":"log_serie","value":"'.$rowdata->nfs_serierps.'","type":"string"},';
				$filtrolog.= ( isset($_REQUEST["usu_login"]) && $_REQUEST["usu_login"]!="" ) ? '{"name":"log_usu_login","value":"'.$_REQUEST["usu_login"].'","type":"string"},' : '{"name":"log_usu_login","value":"NULL","type":"other"},';
				$filtrolog.= '{"name":"log_acao_cod","value":"4","type":"integer"},
					{"name":"log_acao_descr","value":"cancelamento","type":"string"},
					{"name":"log_data","value":"","type":"string"},
					{"name":"log_protocolo","value":"NULL","type":"other"},
					{"name":"log_ret","value":"NULL","type":"other"},
					{"name":"log_outro","value":"'.base64_encode("NFS-e cancelada em ".$data).'","type":"string"}
				]}';
				$TParams->add($filtrolog);
				$TParams->open();
				$TParams->clear();
				
				
				
				$filtroDocto = '{"cod":"501005","params":[
					{"name":"not_codigo","value":"'.$_REQUEST["nfs_codigo"].'","type":"string"}
				]}';
				$TParams->add($filtroDocto);
				$doctos = $TParams->open(true);
				$TParams->clear();
				
				//cancelamento de doctos
				if( isset($doctos) && is_array($doctos) && isset($doctos[0]->{"doc_tipo"}) ){
					foreach ($doctos as $docto) {
						if($docto->doc_status==0){
							$filtro = '{"cod":"501240","params":[
								{"name":"lgd_tipo","value":"3","type":"integer"},
								{"name":"doc_codigo","value":"'.$docto->doc_codigo.'","type":"string"},
								{"name":"usu_login","value":"'.$_REQUEST["usu_login"].'","type":"string"},
								{"name":"lgd_dtatualizada","value":"NULL","type":"other"},
								{"name":"lgd_descr","value":"Motivo: NFS-e cancelada","type":"string"}
							]}';
							$TParams->add($filtro);
							
							$filtroDocto = '{"cod":"501006","params":[
								{"name":"doc_codigo","value":"'.$docto->doc_codigo.'","type":"string"}
							]}';
							$TParams->add($filtroDocto);
							//cancelar boleto inter no banco
							if($docto->doc_tipo==2 && $docto->doc_boletogerado==1 && $docto->doc_carteira=='112'){
								$fields = array(
									'p' => $_REQUEST["p"],
									'acao' => 'cancelar',
									'doc_codigo' => $docto->doc_codigo
								);
								$ch = curl_init();
								curl_setopt($ch,CURLOPT_URL, $TParams->HostClient."/rel/relboleto.php");
								curl_setopt($ch,CURLOPT_POST, true);
								curl_setopt($ch,CURLOPT_RETURNTRANSFER, true);
								curl_setopt($ch,CURLOPT_POSTFIELDS, $fields);
								$result = curl_exec($ch);
							}
						}
					}
					$TParams->open();
					$TParams->clear();
				}

				
				//Salvar XML
				if($NFSe->codmun=="4117503"){
					$NFSe2 = new NFSe($_REQUEST["nfs_codigo"]);
					$xml = $NFSe2->getXMLCons();
					$NFSe2->consultar($xml);
				}
				
				echo "NFS-e cancelada em ".$data;
				
			}else{
				print_r($retorno);
			}
				
		}elseif($acao=='consultar'){
			
			$xml = $NFSe->getXMLCons();
			
			$retorno = $NFSe->consultar($xml);
			
			$TParams = new TParams();
			
			if($retorno[0]["Erro"]){
						
				foreach($retorno as $msg){
					echo $msg["Codigo"].": ".$msg["Erro"]."<br>";
				}
				
			}else{
				
				if( isset($retorno["Status"]) && $retorno["Status"]=="2" ){
					$_xml = (isset($retorno["XML"]) && $retorno["XML"]!="") ? base64_encode($retorno["XML"]) : " ";
					$filtro = '{"cod":"501036","params":[
						{"name":"nfs_codigo","value":"'.$_REQUEST["nfs_codigo"].'","type":"string"},
						{"name":"nfs_dtfaturam","value":"'.$retorno["DataRecebimento"].'","type":"string"},
						{"name":"nfs_codver","value":"'.$retorno["CodigoVerificacao"].'","type":"string"},
						{"name":"nfs_nronfref","value":"NULL","type":"other"},
						{"name":"nfs_nronfse","value":"'.$retorno["NumeroNfse"].'","type":"string"},
						{"name":"nfs_xml","value":"'.$_xml.'","type":"string"},
						{"name":"nfs_motcanc","value":"","type":"string"}
					]}';
				}elseif( isset($retorno["Status"]) && $retorno["Status"]=="3" ){
					$filtro = '{"cod":"501039","params":[
						{"name":"nfs_codigo","value":"'.$_REQUEST["nfs_codigo"].'","type":"string"},
						{"name":"nfs_motcanc","value":" ","type":"string"}
					]}';
				}
				
				if( isset($filtro) && $filtro!=""){
					$TParams->setHost($NFSe->TParams->getHost($NFSe->TParams->getDbSge()));
					$TParams->add($filtro);
					$TParams->open();
					exit("NFS-e consultada e atualizada!");
				}else{
					exit("Não foram encontrados dados desta NFS-e");
				}
				
			}
			
		}elseif($acao=='baixar'){
			
			$nomeArquivo = $NFSe->dirAutorizada.$NFSe->anomes.'/'.$rowdata->nfs_nronfse.'-nfse.xml';
			header("Expires: 0");
			header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
			header("Content-Disposition: attachment; filename=".$rowdata->nfs_nronfse."-nfse.xml");
			header("Content-Type: application/force-download");
			readfile($nomeArquivo);
			exit();
			
		}
	
	}else{
		exit("O código da nota de serviço deve ser informado!");
	}
	
?>
