<?php

	date_default_timezone_set('America/Sao_Paulo');
	
	header('Access-Control-Allow-Origin: *');
	header("Access-Control-Allow-Headers: Origin, X-Requested-With, Content-Type, Accept");

	session_start();
	
	include_once"../../datapacket.php";
	include_once '../../TParams.class.php';
	include_once "../libs/NFe/MakeNFePHP.class.php";
	include_once "../libs/NFe/ToolsNFePHP.class.php";
	include_once "../libs/NFe/DanfeNFePHP.class.php";
	include_once "../libs/NFe/DanfeNFCeNFePHP.class.php";
	include_once "../libs/NFe/DanfeNFCeNFePHPantigo.class.php";
	
	//Classe geradora da chave e que carrega as informações da NF-e
	class NFe extends TParams{

		public $modelo = "55";
		public $codigoUF = array(
			"RO" => "11",
			"AC" => "12",
			"AM" => "13",
			"RR" => "14",
			"PA" => "15",
			"AP" => "16",
			"TO" => "17",
			"MA" => "21",
			"PI" => "22",
			"CE" => "23",
			"RN" => "24",
			"PB" => "25",
			"PE" => "26",
			"AL" => "27",
			"SE" => "28",
			"BA" => "29",
			"MG" => "31",
			"ES" => "32",
			"RJ" => "33",
			"SP" => "35",
			"PR" => "41",
			"SC" => "42",
			"RS" => "43",
			"MS" => "50",
			"MT" => "51",
			"DF" => "53"
		);
		private $company = '';
		private $nota = '';
		private $transportadora = '';
		private $doctos = '';
		public $anoMes='';
		
		public $ambNfe = 'homologacao';

		public function __construct($not_codigo,$emp_codigo){

			$TParams = new TParams();
			$Datapacket = new Datapacket();

			$filtroCompany = '{"cod":"600001","params":[
				{"name":"emp_codigo","value":"'.$emp_codigo.'","type":"string"}
			]}';
			
			//pega dados da empresa
			$Datapacket->setHost($TParams->getHost("empresas"));
			$Datapacket->add($filtroCompany);
			$company = $Datapacket->open(true);
			$this->company = $company[0];
			sleep(1);
			$Datapacket->clear();

			if( isset($company) ){
				if($company[0]->emp_amb_nfe==1){
					$this->ambNfe="producao";
				}else{
					$this->ambNfe="homologacao";
				}
			}else{
				$this->ambNfe="homologacao";
			}

			$filtroNota = '{"cod":"700002","params":[
				{"name":"not_codigo","value":"'.$not_codigo.'","type":"string"},
				{"name":"db","value":"'.$company[0]->emp_db_comum.'","type":"other"}
			]}';
			
			//pega dados da nfe
			$Datapacket->setHost($TParams->getHost($company[0]->emp_db_sge));
			$Datapacket->add($filtroNota);
			$nota = $Datapacket->open(true);

			$this->nota = $nota;
			sleep(1);

			$Datapacket->clear();
			
			$this->anoMes = substr($nota[0]->{'not_data'},0,4).substr($nota[0]->{'not_data'},5,2);
			
			if($nota[0]->cad_codtransp){
			
				$filtroTransp = '{"cod":"500002","params":[
					{"name":"cad_codigo","value":"'.$nota[0]->cad_codtransp.'","type":"string"}
				]}';
				
				//pega dados da transportadora
				$Datapacket->setHost($TParams->getHost($company[0]->emp_db_comum));
				$Datapacket->add($filtroTransp);
				$transportadora = $Datapacket->open(true);
				$this->transportadora = $transportadora;
				sleep(1);
				$Datapacket->clear();
				
			}
			
			$filtroDocto = '{"cod":"700703","params":[
				{"name":"not_codigo","value":"'.$not_codigo.'","type":"string"}
			]}';
			
			//pega dados das parcelas da nota
			$Datapacket->setHost($TParams->getHost($company[0]->emp_db_sge));
			$Datapacket->add($filtroDocto);
			$doctos = $Datapacket->open(true);
			$this->doctos = $doctos;
			sleep(1);
			$Datapacket->clear();
			
		}
		
		function str2Hex($str)	{ //converter string para hexadecimal
			if ($str == '') return '';
			$hex = "";
			$iCount = 0;
			do {
				$hex .= sprintf("%02x", ord($str{$iCount}));
				$iCount++;
			} while ($iCount < strlen($str));
			return $hex;
		}
		
		//modulo 11 p/ gerar a chave
		function digito_modulo11($NumDado, $NumDig, $LimMult){

			$Dado = $NumDado;
			for($n=1; $n<=$NumDig; $n++){
				$Soma = 0;
				$Mult = 2;
				for($i=strlen($Dado) - 1; $i>=0; $i--){
					$Soma += $Mult * intval(substr($Dado,$i,1));
					if(++$Mult > $LimMult) $Mult = 2;
				}
				$Dado .= strval(fmod(fmod(($Soma * 10), 11), 10));
			}
			return substr($Dado, strlen($Dado)-$NumDig);
			
		}
		//formatação do código da nota
		public function codigoNota(){
		
			if (!$this->nota[0]->not_codigo) {
				exit("- Falta código da Nota");
			}
			$j = $this->nota[0]->not_codigo;
			$g = "";
			$h = 9;
			$i= "1";
			
			if (strlen($j) > $h) {
				$j = substr($j, 0, $h);
			}
			for ($f = 0; $f < ($h - strlen($j)); $f++) {
				$g .= "0";
			}
			$j .= $g;
			return ($i.$j);
			
		}
		//gerar a chave da nota
		public function gerarChave($e=true){
			
			if( isset($this->nota) && isset($this->nota[0]) && isset($this->nota[0]->not_numero) ){
			
				if (!$this->company->emp_db_sge) {
					$erro.= "- Falta UF da empresa<br>";
				}
				if (!$this->nota[0]->not_dtemissao) {
					$erro.= "- Falta data de emissão da Nota<br>";
				}
				if (!$this->company->emp_cpfcnpj) {
					$erro.= "- Falta CNPJ da Empresa<br>";
				}
				if (!$this->nota[0]->ser_codigo) {
					$erro.= "- Falta número da série da nota<br>";
				}
				if (!$this->nota[0]->not_numero) {
					$erro.= "- Falta número da nota<br>";
				}
				$data = $this->nota[0]->not_dtemissao;
			
				if(!isset($erro)){
					$f = $this->codigoUF[strtoupper($this->company->emp_uf)].substr($data,2,2).substr($data,5,2).$this->company->emp_cpfcnpj.$this->modelo.str_pad($this->nota[0]->ser_codigo, 3, "0", STR_PAD_LEFT).str_pad($this->nota[0]->not_numero, 9, "0", STR_PAD_LEFT)."1".str_pad(substr($this->nota[0]->not_codigo,0,8), 8, "0", STR_PAD_LEFT);
				
					if ($e) {
						return ($f.$this->digito_modulo11($f, 1, 9));
					}else{
						return ($this->digito_modulo11($f, 1, 9));
					}
				}else{
					exit("Erro na geração da chave da Nota ".$erro);
				}
				
			}
			
		}
		
		public function validaGTIN($gtin=""){
			if(!is_numeric($gtin)){
				return false;
			}
			if( !in_array(strlen($gtin), array(8,12,13,14)) ){
				return false;
			}
			if( strlen($gtin)==13 && substr($gtin,0,3)!="789" && substr($gtin,0,3)!="790" ){
				return false;
			}
			$soma=0;
			for($i=0;$i<(strlen($gtin)-1); $i++){
				if(strlen($gtin)==13){
					if($i%2==0){
						$soma+=$gtin[$i]*1;
					}else{
						$soma+=$gtin[$i]*3;
					}
				}else{
					if($i%2==0){
						$soma+=$gtin[$i]*3;
					}else{
						$soma+=$gtin[$i]*1;
					}
				}
			}
			$base10=$soma;
			if($base10%10!=0){
				while($base10%10!=0){
					$base10++;
				}
			}
			$resultado = $base10-$soma;
			if( $resultado==$gtin[strlen($gtin)-1] ){
				return true;
			}else{
				return false;
			}
		}
		
		public function getCompany(){
			return $this->company;
		}
		
		public function getNota(){
			return $this->nota;
		}
		
		public function getTransportadora(){
			return $this->transportadora;
		}
		
		public function getDoctos(){
			return $this->doctos;
		}
		
		public function getUF($uf="PR"){
			return $this->codigoUF[$uf];
		}
		
	}
	
	//Intanciando classe de dados com os dados recebidos (código da nota e da empresa)
	$Nota 	 = new NFe($_REQUEST['not_codigo'],$_REQUEST['emp_codigo']);
	
	$company = $Nota->getCompany();
	$nota = $Nota->getNota();
	$transportadora = $Nota->getTransportadora();
	$doctos = $Nota->getDoctos();
	

	/*
	echo "<pre>";
	print_r($nota);
	echo "</pre>";
	*/
	//exit();	
	
	//instanciando classe responsável por montar a Nota (XML)
	$nfe = new MakeNFe();
	
	//Identificar o modelo da NF-e (55) ou NFC-e (65) - padrão NF-e (55)
	if( isset($_REQUEST["mod"]) ){
		
		$mod = $_REQUEST["mod"];
		$Nota->modelo = $mod;
		
	}else{
		
		$mod = "55";
		
	}
	
	//caracteres de substituição
	$array1 = array("á", "à", "ã", "â", "Á", "À", "Ã", "Â", "é", "ê", "É", "Ê", "í", "Í", "ó", "õ", "ô", "Ó", "Ô", "Õ", "ú", "ü", "Ú", "Ü", "ç", "Ç", "\n", "º", "ª", ":");
	$array2 = array("a", "a", "a", "a", "A", "A", "A", "A", "e", "e", "E", "E", "i", "I", "o", "o", "o", "O", "O", "O", "u", "u", "U", "U", "c", "C", " . ", "", "", "");
	
	//criar todas as tags do XML em sequencia 

	//Numero e versão da NFe (infNFe)
	$chave = $Nota->gerarChave();
	// $versao = '3.10';
	$versao = '4.00';
	$resp = $nfe->taginfNFe($chave, $versao);

	//Dados da NFe (ide)
	$cUF = $Nota->getUF($company->{'emp_uf'}); //codigo numerico do estado
	$cNF = str_pad(substr($nota[0]->{'not_codigo'},0,8), 8, "0", STR_PAD_LEFT); //numero aleatório da NF
	$natOp = substr($nota[0]->{'cfo_codigo'}."-".str_replace($array1, $array2, $nota[0]->{'cfo_descr'}), 0, 60); //natureza da operação
	$indPag = ($nota[0]->{'cdp_indpag'}) ? $nota[0]->{'cdp_indpag'} : "2"; //0=Pagamento à vista; 1=Pagamento a prazo; 2=Outros
	//$mod = '55'; //modelo da NFe 55 ou 65 essa última NFCe
	$serie = $nota[0]->{'ser_codigo'}; //serie da NFe
	$nNF = $nota[0]->{'not_numero'}; // numero da NFe
	
	//GMT
	if( isset($company->{'emp_gmt'})  ){
		$gmt = (int) 3 - $company->{'emp_gmt'};
		/*
		if( (date("I")==1) && strstr("DF|ES|GO|MT|MS|MG|PR|RJ|RS|SC|SP", $company->{'emp_uf'}) ){
			$gmt = $gmt-1;
		}
		*/
		$gmt = "-0".$gmt.":00";
	}else{
		$gmt = date("P");
	}
	
	if( $_SERVER['SERVER_NAME'] == "dev.jcmantovan.com.br" ){
		// $dhEmi = "2025-04-02T18:00:00-03:00";
		$gmt = date("P");
		$dhEmi = date('Y-m-d')."T".date('H:i:s').$gmt;
	}else{
		$dhEmi = date('Y-m-d')."T".date('H:i:s').$gmt;
	}
	
	//$dhEmi = substr($nota[0]->{'not_data'}, 0, 10)."T".substr($nota[0]->{'not_data'}, 11, 8).$gmt;  //para versão 3.00 '2014-02-03T13:22:42-3.00' não informar para NFCe
		
	$dhSaiEnt = substr($nota[0]->{'not_data'}, 0, 10)."T".date('H:i:s').$gmt; //versão 2.00, 3.00 e 3.10
	$tpNF = ($nota[0]->{'not_entrsaida'}==2) ? '1' : '0';
	
	//1=Operação interna; 2=Operação interestadual; 3=Operação com exterior.
	if($nota[0]->{'end_uf'}=="EX"){
		$idDest = '3';
	}else if( $company->{'emp_uf'} == $nota[0]->{'end_uf'} || (isset($_REQUEST["mod"]) && $_REQUEST["mod"]=="65") ){
		$idDest = '1';
	}else{
		$idDest = '2';
	}

	$cMunFG = $company->{'emp_codmun'};
	$tpImp = ( isset($_REQUEST["mod"]) && $_REQUEST["mod"]=="65" ) ? '4' : '1'; //0=Sem geração de DANFE; 1=DANFE normal, Retrato; 2=DANFE normal, Paisagem;
				  //3=DANFE Simplificado; 4=DANFE NFC-e; 5=DANFE NFC-e em mensagem eletrônica
				  //(o envio de mensagem eletrônica pode ser feita de forma simultânea com a impressão do DANFE;
				  //usar o tpImp=5 quando esta for a única forma de disponibilização do DANFE).
	$tpEmis = '1'; //1=Emissão normal (não em contingência);
				   //2=Contingência FS-IA, com impressão do DANFE em formulário de segurança;
				   //3=Contingência SCAN (Sistema de Contingência do Ambiente Nacional);
				   //4=Contingência DPEC (Declaração Prévia da Emissão em Contingência);
				   //5=Contingência FS-DA, com impressão do DANFE em formulário de segurança;
				   //6=Contingência SVC-AN (SEFAZ Virtual de Contingência do AN);
				   //7=Contingência SVC-RS (SEFAZ Virtual de Contingência do RS);
				   //9=Contingência off-line da NFC-e (as demais opções de contingência são válidas também para a NFC-e);
				   //Nota: Para a NFC-e somente estão disponíveis e são válidas as opções de contingência 5 e 9.
	$cDV = $Nota->gerarChave(false); //digito verificador
	$tpAmb = $company->{'emp_amb_nfe'}; //1=Produção; 2=Homologação
	if( isset($_REQUEST["fin_nfe"]) ){
		$finNFe = $_REQUEST["fin_nfe"]; //1=NF-e normal; 2=NF-e complementar; 3=NF-e de ajuste; 4=Devolução/Retorno; 5=Nota de credito; 6=Nota de debito;
	}else{
		$finNFe = '1'; //1=NF-e normal; 2=NF-e complementar; 3=NF-e de ajuste; 4=Devolução/Retorno; 5=Nota de credito; 6=Nota de debito;
	}
	
	//indicador destinatário quanto à contribuição do ICMS; 1 - Contribuinte; 2 - Não Contribuinte; 9 - Não Contribuinte que pode ou não possuir IE
	if($nota[0]->{'cad_pessoa'}==2 && strlen($nota[0]->{'cad_cnpjcpf'})>11 && $nota[0]->{'end_uf'}!="EX"){
		if( strtolower($nota[0]->{'cad_inscrg'})=="isento" ){
			$indIEDest = "2";
		}elseif( !$nota[0]->{'cad_inscrg'} || trim($nota[0]->{'cad_inscrg'})=="" ){
			$indIEDest = "9";
		}else{
			$indIEDest = "1";
		}
	}else{
		if( isset($nota[0]->{'not_tpprc'}) && $nota[0]->{'not_tpprc'}==0 && isset($nota[0]->{'cad_inscrg'}) && $nota[0]->{'cad_inscrg'}!="" && $nota[0]->{'cad_inscrg'}!="isento" ){
			$indIEDest = "1";
		}else{
			if( strtolower($nota[0]->{'cad_inscrg'})=="isento" ){
				$indIEDest = "2";
			}else{
				$indIEDest = "9";
			}
		}
	}
	
	//0=Não é conumidor final; 1=Consumidor final;
	if( (isset($_REQUEST["mod"]) && $_REQUEST["mod"]=="65") || $indIEDest == "9" || $nota[0]->{'not_tpprc'}==1 ){
		$indFinal = "1";
	}else{
		$indFinal = "0";
	}

	$indPres = ( isset($_REQUEST["mod"]) && $_REQUEST["mod"]=="65" ) ? '1' : '9';
		//0=Não se aplica (por exemplo, Nota Fiscal complementar ou de ajuste);
		//1=Operação presencial;
		//2=Operação não presencial, pela Internet;
		//3=Operação não presencial, Teleatendimento;
		//4=NFC-e em operação com entrega a domicílio;
		//5=Operação presencial, fora do estabelecimento;
		//9=Operação não presencial, outros.
	if( !isset($_REQUEST["mod"]) ) $indIntermed = '0';
		// 0=Operação sem intermediador (em site ou plataforma própria)
		// 1=Operação em site ou plataforma de terceiros(intermediadores/marketplace) 
	$procEmi = '0';
		//0=Emissão de NF-e com aplicativo do contribuinte;
		//1=Emissão de NF-e avulsa pelo Fisco;
		//2=Emissão de NF-e avulsa, pelo contribuinte com seu certificado digital, através do site do Fisco;
		//3=Emissão NF-e pelo contribuinte com aplicativo fornecido pelo Fisco.
	$verProc = '3.22.8'; //versão do aplicativo emissor
	$dhCont = ''; //entrada em contingência AAAA-MM-DDThh:mm:ssTZD
	$xJust = ''; //Justificativa da entrada em contingência

	$resp = $nfe->tagide($cUF, $cNF, $natOp, $indPag, $mod, $serie, $nNF, $dhEmi, $dhSaiEnt, $tpNF, $idDest, $cMunFG, $tpImp, $tpEmis, $cDV, $tpAmb, $finNFe, $indFinal, $indPres, $indIntermed, $procEmi, $verProc, $dhCont, $xJust);

	//refNFe NFe/ ECF referenciada  
	if( isset($nota[0]->{'not_nferef'}) && $nota[0]->{'not_nferef'}!='' ){
		$refjson = json_decode(base64_decode($nota[0]->{'not_nferef'}), true);
		//ECF
		if( $nota[0]->{'cfo_codigo'}==5929 || $nota[0]->{'cfo_codigo'}==6929 ){
			foreach($refjson as $nferef){
				$mod = $nferef["not_ecfmod"];
				$nECF = $nferef["not_necf"];
				$nCOO = $nferef["not_ncoo"];
				$resp = $nfe->tagrefECF($mod, $nECF, $nCOO);
			}
		//NF-e
		}else{
			foreach($refjson as $nferef){
				$resp = $nfe->tagrefNFe($nferef);
			}
		}
	}

	//refNF Nota Fiscal 1A referenciada
	$cUF = '';
	$AAMM = '';
	$CNPJ = '';
	$mod = '';
	$serie = '';
	$nNF = '';
	//$resp = $nfe->tagrefNF($cUF, $AAMM, $CNPJ, $mod, $serie, $nNF);

	//NFPref Nota Fiscal Produtor Rural referenciada
	$cUF = '';
	$AAMM = '';
	$CNPJ = '';
	$CPF = '';
	$IE = '';
	$mod = '';
	$serie = '';
	$nNF = '';
	//$resp = $nfe->tagrefNFP($cUF, $AAMM, $CNPJ, $CPF, $IE, $mod, $serie, $nNF);

	//CTeref CTe referenciada
	$refCTe = '';
	//$resp = $nfe->tagrefCTe($refCTe);

	//Dados do emitente
	$CNPJ = $company->{'emp_cpfcnpj'};
	$CPF = '';
	$xNome = substr(str_replace("&", "&amp;", $company->{'emp_razao'}),0,60);
	$xFant = substr(str_replace("&", "&amp;", $company->{'emp_fantasia'}),0,60);
	$IE = $company->{'emp_inscrg'};
	// $IEST = ($nota[0]->{'cad_inscrg'}!="" && strtolower($nota[0]->{'cad_inscrg'})!="isento" && $nota[0]->{'cad_pessoa'}==2 ) ? $nota[0]->{'cad_inscrg'} : "";
	$IEST = "";
	$IM = (isset($company->{'emp_inscrmun'}) && $company->{'emp_inscrmun'}!="") ? $company->{'emp_inscrmun'} : "";
	$CNAE = ($company->{'emp_cnae'}!="") ? $company->{'emp_cnae'} : "";
	$CRT = $company->{'emp_codregtrib'};
	$resp = $nfe->tagemit($CNPJ, $CPF, $xNome, $xFant, $IE, $IEST, $IM, $CNAE, $CRT);

	//endereço do emitente
	$xLgr = $company->{'emp_endereco'};
	if($company->{'emp_num'}!=""){
		if(strlen($company->{'emp_num'})<5){
			$nro = str_pad($company->{'emp_num'}, 4, "0", STR_PAD_LEFT);
		}else{
			$nro = $company->{'emp_num'};
		}
	}
	$xCpl =  ($company->{'emp_complem'}!="") ? $company->{'emp_complem'} : "";
	$xBairro = $company->{'emp_bairro'};
	$cMun = $company->{'emp_codmun'};
	$xMun = ucwords(strtolower($company->{'emp_cidade'}));
	$UF = strtoupper($company->{'emp_uf'});
	$CEP = $company->{'emp_cep'};
	$cPais = '1058';
	$xPais = 'BRASIL';
	$fone = $company->{'emp_fone'};
	$resp = $nfe->tagenderEmit($xLgr, $nro, $xCpl, $xBairro, $cMun, $xMun, $UF, $CEP, $cPais, $xPais, $fone);
	
	if( isset($nota[0]->{'cod_cad'}) && $nota[0]->{'cod_cad'} != '99999999999999' && !isset($_REQUEST["mod"]) ){

		if(isset($nota[0]->{'cad_cnpjcpf'}) && !empty($nota[0]->{'cad_cnpjcpf'}) && $nota[0]->{'end_uf'}!="EX"){
			$CNPJ = (strlen($nota[0]->{'cad_cnpjcpf'})>11) ? $nota[0]->{'cad_cnpjcpf'} : "";
			$CPF = (strlen($nota[0]->{'cad_cnpjcpf'})<12) ? $nota[0]->{'cad_cnpjcpf'} : "";
			$idEstrangeiro = '';
		}else if($nota[0]->{'end_uf'}!="EX"){
			$CNPJ = (strlen($nota[0]->{'not_cpf'})>11) ? $nota[0]->{'not_cpf'} : "";
			$CPF = (strlen($nota[0]->{'not_cpf'})<12) ? $nota[0]->{'not_cpf'} : "";
			$idEstrangeiro = '';
		}else{
			$CNPJ = "";
			$CPF = "";
			$idEstrangeiro = $nota[0]->{'cad_cnpjcpf'};
		}
		
		$xNome =  substr(str_replace("&", "&amp;", $nota[0]->{'cad_nomeraz'}), 0, 60);
		// $IE =  ($nota[0]->{'cad_inscrg'}!="" && strtolower($nota[0]->{'cad_inscrg'})!="isento" && (isset($_REQUEST["nfe_final"]) && $_REQUEST["nfe_final"]=='nao') && !isset($_REQUEST["mod"]) ) ? $nota[0]->{'cad_inscrg'} : "";
		$IE =  ($nota[0]->{'cad_inscrg'}!="" && strtolower($nota[0]->{'cad_inscrg'})!="isento" && (strlen($nota[0]->{'cad_cnpjcpf'})==14 || $nota[0]->{'not_tpprc'}==0) && !isset($_REQUEST["mod"]) ) ? $nota[0]->{'cad_inscrg'} : "";
		$ISUF = ($nota[0]->{'cad_suframa'}!="") ? $nota[0]->{'cad_suframa'} : "";
		$IM = '';
		// $email = (isset($nota[0]->{'cad_email_nfe'}) && $nota[0]->{'cad_email_nfe'}!='') ? trim(strtolower($nota[0]->{'cad_email_nfe'})) : '';
		$email = '';
		if($tpAmb == 2){
			$resp = $nfe->tagdest($CNPJ, $CPF, $idEstrangeiro, 'NF-E EMITIDA EM AMBIENTE DE HOMOLOGACAO - SEM VALOR FISCAL', $indIEDest, $IE, $ISUF, $IM, $email);
		}else{
			$resp = $nfe->tagdest($CNPJ, $CPF, $idEstrangeiro, $xNome, $indIEDest, $IE, $ISUF, $IM, $email);
		}

		//Endereço do destinatário
		$xLgr = substr($nota[0]->{'end_nome'}, 0, 60);
		if($nota[0]->{'end_num'}!=""){
			if(strlen($nota[0]->{'end_num'})<5){
				$nro = str_pad($nota[0]->{'end_num'}, 4, "0", STR_PAD_LEFT);
			}else{
				$nro = $nota[0]->{'end_num'};
			}
		}
		$xCpl = trim($nota[0]->{'end_compl'});
		$xBairro = $nota[0]->{'end_bairro'};
		$cMun = $nota[0]->{'cad_codmun'};
		$xMun = $nota[0]->{'end_cidade'};
		$UF = $nota[0]->{'end_uf'};
		$CEP = ($nota[0]->{'end_cep'}) ? str_replace("-", "", $nota[0]->{'end_cep'}) : "";
		if( $nota[0]->{'end_uf'}=="EX" ){
			$cPais = (int) $nota[0]->{'end_pais'};
			$xPais = $nota[0]->{'end_nomepais'};
		}else{
			$cPais = '1058';
			$xPais = 'BRASIL';
		}
		$fone = trim($nota[0]->{'tel_ddd'}).trim($nota[0]->{'tel_prefixo'}).trim($nota[0]->{'tel_numero'});
		$resp = $nfe->tagenderDest($xLgr, $nro, $xCpl, $xBairro, $cMun, $xMun, $UF, $CEP, $cPais, $xPais, $fone);

	}else if( isset($nota[0]->{'not_cpf'}) && !empty($nota[0]->{'not_cpf'}) ){

		$IE = "";
		$CNPJ = (strlen($nota[0]->{'not_cpf'})>11) ? $nota[0]->{'not_cpf'} : "";
		$CPF = (strlen($nota[0]->{'not_cpf'})<12) ? $nota[0]->{'not_cpf'} : "";
		if($tpAmb == 2){
			$resp = $nfe->tagdest($CNPJ, $CPF, "",'NF-E EMITIDA EM AMBIENTE DE HOMOLOGACAO - SEM VALOR FISCAL',$indIEDest, $IE);
		}else{
			$resp = $nfe->tagdest($CNPJ, $CPF, "", "CONSUMIDOR FINAL", $indIEDest, $IE);
		}

	}


	//Identificação do local de retirada (se diferente do emitente)
	$CNPJ = '';
	$CPF = '';
	$xLgr = '';
	$nro = '';
	$xCpl = '';
	$xBairro = '';
	$cMun = '';
	$xMun = '';
	$UF = '';
	//$resp = $nfe->tagretirada($CNPJ, $CPF, $xLgr, $nro, $xCpl, $xBairro, $cMun, $xMun, $UF);

	//Identificação do local de Entrega (se diferente do destinatário)
	$CNPJ = '';
	$CPF = '';
	$xLgr = '';
	$nro = '2';
	$xCpl = '';
	$xBairro = '';
	$cMun = '';
	$xMun = '';
	$UF = '';
	//$resp = $nfe->tagentrega($CNPJ, $CPF, $xLgr, $nro, $xCpl, $xBairro, $cMun, $xMun, $UF);

	//Identificação dos autorizados para fazer o download da NFe (somente versão 3.1)
	$aAut = array($company->{'emp_cpfcnpj'},$nota[0]->{'cad_cnpjcpf'});
	foreach ($aAut as $aut) {
		if (strlen($aut) == 14) {
			//$resp = $nfe->tagautXML($aut);
		} else {
			//$resp = $nfe->tagautXML('', $aut);
		}
	}

	//produtos
	$i=0;
	$vTotDesc=0;
	$vTotDescNota=0;
	$vTotOutro=0;
	$ant="";
	
	foreach($nota as $not){
		
		if( $not->{"itn_ordem"}!=$ant ){
			
			$tribjson = json_decode(base64_decode($not->{"itn_tribjson"}));
			$vdesc = '';
			$voutro = '';
			if($not->{"itn_valordesc"}>0){
				$vdesc = $not->{"itn_qtde"} * $not->{"itn_valordesc"};
			}
			
			if($not->{"not_valordesc"}>0){
				$p = ($not->{"itn_subtotal"} * 100)/ $not->{"not_totalprod"}; //porcentagem do desconto do produto em relacao ao total dos produtos
				$vdesc+= number_format(($not->{"not_valordesc"}*$p/100), 2, ".", "");
				$vTotDescNota+=number_format(($not->{"not_valordesc"}*$p/100), 2, ".", "");
			}
			if($not->{"not_despesa"}>0 && $i==0){
				$voutro = $not->{"not_despesa"};
			}
			
			//cdp (variação da condição de pagamento/ tabela de precos)
			if($not->{"not_cdp_desc"}<0 && $i==0){
				$vdesc -= $not->{"not_cdp_desc"};
			}elseif($not->{"not_cdp_desc"}>0 && $i==0){
				$voutro += $not->{"not_cdp_desc"};
			}
			
			//tbp (variação da tabela de preços)
			/*
			$variacao = 0;
			if($not->{"tbp_codigo"} && $not->{"tbp_da"}==1 && $i==0){
				if($not->{"tbp_tpdesc"}==1) $variacao = $not->{"not_totalprod"}*($not->{"tbp_valor"}/100);
				else $variacao = $not->{"tbp_valor"};
				$vdesc += $variacao;
				$variacao = 0;
			}elseif($not->{"tbp_codigo"} && $not->{"tbp_da"}==2 && $i==0){
				if($not->{"tbp_tpdesc"}==1) $variacao = $not->{"not_totalprod"}*($not->{"tbp_valor"}/100);
				else $variacao = $not->{"tbp_valor"};
				$voutro+=$variacao;
				$variacao=0;
			}
			*/
			
			$ref_codigo =  ($tribjson->{"rowdata"}[0]->{"ref_codigo"} && $tribjson->{"rowdata"}[0]->{"ref_codigo"}!="") ? $tribjson->{"rowdata"}[0]->{"ref_codigo"} :  $not->{"ref_codigo"};
			$ref_codigo = ( strlen($ref_codigo)>=3 ) ? $ref_codigo : str_pad($ref_codigo, 3, "0", STR_PAD_LEFT);
			
			if( isset($not->{"ref_codbar"}) && $not->{"ref_codbar"}!="" ){
				if($Nota->validaGTIN($not->{"ref_codbar"})){
					$codbar = $not->{"ref_codbar"};
					// $codbar = "SEM GTIN";
				}else{
					$codbar = "SEM GTIN";
				}
			}else{
				$codbar = "SEM GTIN";
			}

			if($not->{"itn_qtde"}>0){
				$not->{"itn_qtde"}=number_format($not->{"itn_qtde"},$company->{'emp_decimais'},".","");
			}else{
				$not->{"itn_qtde"}="0";
			}
			
			if($vdesc>0 && $vdesc!=""){
				// $vdesc=number_format($vdesc,$company->{'emp_decimais'},".","");
				$vdesc=number_format($vdesc,2,".","");
			}else{
				$vdesc=0;
			}
			
			$vTotDesc += $vdesc; //total de desconto

			if($voutro>0){
				$voutro=number_format($voutro,2,".","");
			}else{
				$voutro="0";
			}
			
			$not->{"itn_valor"} = $not->{"itn_valor"} + $variacao;
			// $vprod = ( $not->{"itn_qtde"} * $not->{"itn_valor"} );
			$vprod = ($not->{"itn_subtotal"} + ($not->{"itn_qtde"} * $not->{"itn_valordesc"}));

			if($not->{"itn_qtde"}>0){
				if($company->{'emp_decimais'}>=4){
					$itn_qtde = number_format($not->{"itn_qtde"},4,".","");
				}else{
					$itn_qtde = number_format($not->{"itn_qtde"},$company->{'emp_decimais'},".","");
				}
			}else{
				$itn_qtde = 0;
			}
			
			if($vprod>0){
				$vprod=number_format($vprod,2,".","");
			}else{
				$vprod="0";
			}
		
			if($not->{"itn_valor"}>0){
				$itn_valor = number_format($not->{"itn_valor"},$company->{'emp_decimais'},".","");
			}else{
				$itn_valor=0;
			}
			
			if(strlen($not->{"itn_descr"})>120){
				$itn_descr = substr($not->{"itn_descr"},0,120);
			}else{
				$itn_descr = $not->{"itn_descr"};
			}
			
			$uni_codigo =  (isset($not->{"uni_codigo"}) && $not->{"uni_codigo"}!="") ? $not->{"uni_codigo"} : "UN";
			if($tribjson->{"rowdata"}[0]->{"tri_cbenef"} && $tribjson->{"rowdata"}[0]->{"tri_cbenef"}!="" && $tribjson->{"rowdata"}[0]->{"tri_cbenef"}!="PR000000" && $company->{'emp_codregtrib'}==3) $cbenef = $tribjson->{"rowdata"}[0]->{"tri_cbenef"};
			$aP[$i] = array(
				'nItem' => ($i+1),
				'cProd' =>  $ref_codigo,
				'cEAN' => $codbar,
				'xProd' => $itn_descr,
				'NCM' => $not->{"itn_ncm"},
				'NVE' => '',
				'CEST' => ($tribjson->{"rowdata"}[0]->{"ref_cest"}) ? $tribjson->{"rowdata"}[0]->{"ref_cest"} : '0000000',
				'indEscala' => 'S',
				'CNPJFab' => '',
				'cBenef' => ($tribjson->{"rowdata"}[0]->{"tri_cbenef"} && $tribjson->{"rowdata"}[0]->{"tri_cbenef"}!="" && $tribjson->{"rowdata"}[0]->{"tri_cbenef"}!="PR000000" && $company->{'emp_codregtrib'}==3) ? $tribjson->{"rowdata"}[0]->{"tri_cbenef"} : '',
				'EXTIPI' => '',
				'CFOP' => ($tribjson->{"rowdata"}[0]->{"ref_cfop"}) ? $tribjson->{"rowdata"}[0]->{"ref_cfop"} : $not->{"cfo_codigo"},
				'uCom' => $uni_codigo,
				'qCom' => $itn_qtde,
				'vUnCom' => $itn_valor,
				'vProd' => $vprod,
				'cEANTrib' => $codbar,
				'uTrib' => (isset($tribjson->{"rowdata"}[0]->{"uni_codigo_trib"}) && $tribjson->{"rowdata"}[0]->{"uni_codigo_trib"}!="") ? $tribjson->{"rowdata"}[0]->{"uni_codigo_trib"} : $uni_codigo,
				'qTrib' =>  $itn_qtde,
				'vUnTrib' => $itn_valor,
				'vFrete' => ($i==0 &&  $not->{"not_frete"}>0 && ($nota[0]->{"not_tpfrete"}=='1' || $nota[0]->{"not_tpfrete"}=='2')) ?  number_format($not->{"not_frete"},2,'.','') : '',
				'vSeg' => ($i==0 &&  $not->{"not_seguro"}>0) ?  number_format($not->{"not_seguro"},2,'.','') : '',
				'vDesc' => ($vdesc>0) ? $vdesc : '',
				'vOutro' => ($voutro>0) ? $voutro : '',
				'indTot' => '1',
				'xPed' => ($tribjson->{"rowdata"}[0]->{"xped"}) ? $tribjson->{"rowdata"}[0]->{"xped"} : '',
				'nItemPed' => ($tribjson->{"rowdata"}[0]->{"nitemped"}) ? $tribjson->{"rowdata"}[0]->{"nitemped"} : '',
				'nFCI' => ''
			);
			$ant = $not->{"itn_ordem"};
		
			$i++;
			$vTotOutro += $voutro;
		}
		
	}
	
	//resolvendo problema da diferença no arredondamento do desconto
	if($nota[0]->{"not_valordesc"}>0 && $vTotDescNota>0 && $vTotDescNota!=$nota[0]->{"not_valordesc"}){
		$diff = $vTotDescNota - $nota[0]->{"not_valordesc"};
		$aP[0]["vDesc"] = number_format( ($aP[0]["vDesc"]-$diff), 2, ".", "");
		$vTotDesc = number_format( ($vTotDesc-$diff), 2, ".", "");
	}

	$vTotProd=0;
	foreach ($aP as $prod) {
		$nItem = $prod['nItem'];
		$cProd = $prod['cProd'];
		$cEAN = $prod['cEAN'];
		$xProd = $prod['xProd'];
		$NCM = $prod['NCM'];
		$NVE = $prod['NVE'];
		$CEST = $prod['CEST'];
		$indEscala = $prod['indEscala'];
		$CNPJFab = $prod['CNPJFab'];
		$cBenef = $prod['cBenef'];
		$EXTIPI = $prod['EXTIPI'];
		$CFOP = $prod['CFOP'];
		$uCom = $prod['uCom'];
		$qCom = $prod['qCom'];
		$vUnCom = $prod['vUnCom'];
		$vProd = $prod['vProd'];
		$vTotProd+=$prod['vProd'];
		$cEANTrib = $prod['cEANTrib'];
		$uTrib = $prod['uTrib'];
		$qTrib = $prod['qTrib'];
		$vUnTrib = $prod['vUnTrib'];
		$vFrete = $prod['vFrete'];
		$vSeg = $prod['vSeg'];
		$vDesc = $prod['vDesc'];
		$vOutro = $prod['vOutro'];
		$indTot = $prod['indTot'];
		$xPed = $prod['xPed'];
		$nItemPed = $prod['nItemPed'];
		$nFCI = $prod['nFCI'];
		$resp = $nfe->tagprod($nItem, $cProd, $cEAN, $xProd, $NCM, $NVE, $CEST, $indEscala, $CNPJFab, $cBenef, $EXTIPI, $CFOP, $uCom, $qCom, $vUnCom, $vProd, $cEANTrib, $uTrib, $qTrib, $vUnTrib, $vFrete, $vSeg, $vDesc, $vOutro, $indTot, $xPed, $nItemPed, $nFCI);
	}
	
	$i=1;
	$vTotTrib=0;
	$vTotTrib2=0;
	$vTotPIS=0;
	$vTotCOFINS=0;
	$ant="";
	
	$vFCPUFDestTot=0;
	$vICMSUFDestTot=0;
	$vICMSUFRemetTot=0;
	$vICMSDifTot=0;
	$vICMSOpTot=0;
	$vTotST=0;
	$totRet=0;
	
	foreach($nota as $not){
		
		if( $not->{"itn_ordem"}!=$ant ){
			
			$tribjson = json_decode(base64_decode($not->{"itn_tribjson"}));
			
			$nItem = $i;
			
			//informações adicionais do produto
			if( strlen($not->{"itn_descr"})>120 ){
				$resp = $nfe->taginfAdProd($nItem, trim(substr($not->{"itn_descr"},0, 499)));
			}
			
			//DI
			
			$nDI = '21/2139614-3';
			$dDI = date("Y-m-d");
			$xLocDesemb = 'FOZ DO IGUACU';
			$UFDesemb = 'PR';
			$dDesemb = date("Y-m-d");
			$tpViaTransp = '7';
			$vAFRMM = '';
			$tpIntermedio = '1';
			$CNPJ = '';
			$UFTerceiro = '';
			$cExportador = '111';
			$nAdicao='1';
			$nSeqAdic='1';
			$cFabricante='1';
			$vDescDI='';
			$nDraw='1';
			if($nota[0]->{'end_uf'}=="EX" && $nota[0]->{'not_entrsaida'}==1){
				$resp = $nfe->tagDI($nItem, $nDI, $dDI, $xLocDesemb, $UFDesemb, $dDesemb, $tpViaTransp, $vAFRMM, $tpIntermedio, $CNPJ, $UFTerceiro, $cExportador);
				$resp = $nfe->tagadi($nItem,$nDI,$nAdicao,$nSeqAdic,$cFabricante,$vDescDI,$nDraw);
			}
			
			
			//Rastro
			/*
			$nLote = '234556786';
			$qLote = '25';
			$dFab = '2016-01-01';
			$dVal = '2017-12-12';
			$cAgreg = '';
			$resp = $nfe->tagRastro($nItem, $nLote, $qLote, $dFab, $dVal, $cAgreg);
			*/
			
			if( strstr("3650|3651|3652|3653|5650|5652|5653|5654|5655|5656|5658|5659|5664|5665|6650|6651|6652|6653|6654|6655|6656|6658|6659|6664|6665|7650|7651|7654", $tribjson->{"rowdata"}[0]->{'ref_cfop'}) && isset($not->{"ref_anp"}) && $not->{"ref_anp"}!="" && $not->{"ref_anp"}!=0){
				//combustivel
				$nItem = $i;
				$cProdANP = $not->{"ref_anp"};
				$descANP = 'descricao';
				$ufCons = $nota[0]->{'end_uf'};
				$resp = $nfe->tagcomb($nItem, $cProdANP, "", $descANP, "", "", "", "", "", "", $ufCons);
			}

			//imposto
			$nItem = $i;
			$val_ipi = ( !isset($_REQUEST["mod"]) ) ? $not->{"itn_ipi"} : "0";
			$vTotTrib = floor($not->{"itn_icms"}+$val_ipi+$not->{"itn_icmssubst"});
			$vTotTrib = ($vTotTrib > 0) ? number_format( $vTotTrib, 2, ".", "") : "0";
			$vTotTrib2 += $vTotTrib;
			$resp = $nfe->tagimposto($nItem, $vTotTrib);

			//ICMS
			$nItem =$i;
			$orig = ($tribjson->{"rowdata"}[0]->{"tri_origem"} && $tribjson->{"rowdata"}[0]->{"tri_origem"}!="") ? $tribjson->{"rowdata"}[0]->{"tri_origem"} : "0";
			$cst = str_pad($tribjson->{"rowdata"}[0]->{"tri_situacao"}, 2, "0", STR_PAD_LEFT);
			$modBC = ($tribjson->{"rowdata"}[0]->{"tri_modbc_icms"} && $tribjson->{"rowdata"}[0]->{"tri_modbc_icms"}!="") ? $tribjson->{"rowdata"}[0]->{"tri_modbc_icms"} : '0';
			$tri_redbaseicms = ( $not->{"itn_icms"}>0 && ($cst=="20" || $cst=="70") && $company->{'emp_codregtrib'}==3 ) ? number_format($tribjson->{"rowdata"}[0]->{"tri_redbaseicms"}, 2, ".", "") : "0.00";
			$itn_baseicms = ( $not->{"itn_baseicms"}>0 ) ? number_format($not->{"itn_baseicms"}, 2, ".", "") : "0";
			$itn_aliqicms = ($not->{"itn_aliqicms"}>0) ? number_format($not->{"itn_aliqicms"}, 2, ".", "") : "0";
			$vICMS = ($not->{"itn_icms"}>0) ? number_format($not->{"itn_icms"}, 2, ".", "") : "0";
			
			//icms em frete, seguro e despesas
			
			if($i==1 && $vICMS>0){
				if( $nota[0]->{'not_frete'}>0 && $nota[0]->{'not_tpfrete'}=='2' ){
					$itn_baseicms+=$nota[0]->{'not_frete'};
					$vICMS+= $nota[0]->{'not_frete'}*($itn_aliqicms/100);
				}
				if( $nota[0]->{'not_seguro'}>0 ){
					$itn_baseicms+=$nota[0]->{'not_seguro'};
					$vICMS+= $nota[0]->{'not_seguro'}*($itn_aliqicms/100);
				}
				if( $nota[0]->{'not_despesa'}>0 && $company->{"cfg_despesa"}==1 ){
					$itn_baseicms+=$nota[0]->{'not_despesa'};
					$vICMS+= $nota[0]->{'not_despesa'}*($itn_aliqicms/100);
				}
				$itn_baseicms = number_format($itn_baseicms, 2, '.','');
				$vICMS = number_format($vICMS, 2, '.','');
			}
			
			
			if( ($cst=="30" || $cst=="40" || $cst=="41" || $cst=="90") && $company->{'emp_codregtrib'}==3 ){
				//nao incidencia icms de imposto na exportacao
				if( $cst=="41" && ($nota[0]->{'cfo_codigo'}==5502 || $nota[0]->{'cfo_codigo'}==6502) ){
					$icmsexport=true;
				}
				
				if($not->{"itn_valor"}>0 && $not->{"itn_icms"}>0 && $cst!="90"){
					$vICMSDeson = number_format($not->{"itn_valor"}*($not->{"itn_aliqicms"}/100), 2, ".", "");
					$vICMSDesonTot += number_format($not->{"itn_valor"}*($not->{"itn_aliqicms"}/100), 2, ".", "");
					$motDesICMS = '9';
				}else{
					$vICMSDeson = "";
					$vICMSDesonTot += "";
					$motDesICMS = '';
				}
				
			}elseif( ($cst=="20" || $cst=="70") && $company->{'emp_codregtrib'}==3 ){
				if($not->{"itn_valor"}>0 && $tribjson->{"rowdata"}[0]->{"tri_redbaseicms"}>0 && $not->{"itn_aliqicms"}>0){
					$vICMSDeson = number_format( (($not->{"itn_valor"}*$tribjson->{"rowdata"}[0]->{"tri_redbaseicms"})/100) * ($not->{"itn_aliqicms"}/100), 2, ".", "");
					$vICMSDesonTot += number_format( (($not->{"itn_valor"}*$tribjson->{"rowdata"}[0]->{"tri_redbaseicms"})/100) * ($not->{"itn_aliqicms"}/100), 2, ".", "");
					$motDesICMS = "9";
				}else{
					$vICMSDeson = "";
					$vICMSDesonTot += "";
					$motDesICMS = '';
				}
			}else{
				$vICMSDeson = "";
				$vICMSDesonTot += "";
				$motDesICMS = '';
			}
			$modBCST = ( isset($tribjson->{"rowdata"}[0]->{"tri_modbc_st_icms"}) && $tribjson->{"rowdata"}[0]->{"tri_modbc_st_icms"}!="" ) ? $tribjson->{"rowdata"}[0]->{"tri_modbc_st_icms"} : '4';
			$pMVAST = ( isset($tribjson->{"rowdata"}[0]->{"tri_mva_st"}) && $tribjson->{"rowdata"}[0]->{"tri_mva_st"}>0 ) ? number_format($tribjson->{"rowdata"}[0]->{"tri_mva_st"}, 2, ".", "") : "0.00";
			$pRedBCST = ( isset($tribjson->{"rowdata"}[0]->{"tri_redbaseicmsst"}) && $tribjson->{"rowdata"}[0]->{"tri_redbaseicmsst"}>0 ) ? number_format($tribjson->{"rowdata"}[0]->{"tri_redbaseicmsst"}, 2, ".", "") : "0.00";
			$vBCST = ($not->{"itn_baseicmsst"}>0) ? number_format($not->{"itn_baseicmsst"}, 2, ".", "") : "0.00";
			$pICMSST =($tribjson->{"rowdata"}[0]->{"tri_aliq_icms_st"}>0) ? number_format($tribjson->{"rowdata"}[0]->{"tri_aliq_icms_st"}, 2, ".", "") : "0.00";
			$vICMSST = ($not->{"itn_icmssubst"}>0) ? number_format($not->{"itn_icmssubst"}, 2, ".", "") : "0.00";
			$vTotST+=$vICMSST;
			if( $cst=="51" && $company->{'emp_codregtrib'}==3 ){
				if( ($indFinal=='1' && $idDest=='1') || $itn_baseicms==0 ){
					$pDif = "0.00";
					$vICMSDif = "0.00";
					$vICMSOp = "0.00";
				}else{
					$pDif = ($tribjson->{"rowdata"}[0]->{"tri_aliqdif"}>0) ? number_format($tribjson->{"rowdata"}[0]->{"tri_aliqdif"}, 2, ".", "") : "0.00";
					$vICMSDif = ($tribjson->{"rowdata"}[0]->{"tri_icmsdif"}>0) ? number_format($tribjson->{"rowdata"}[0]->{"tri_icmsdif"}, 2, ".", "") : "0.00";
					$vICMSOp = ($tribjson->{"rowdata"}[0]->{"tri_icmsdif"}>0) ? number_format( ($vICMS + $tribjson->{"rowdata"}[0]->{"tri_icmsdif"}) , 2, ".", "") : "0.00";
				}
				$vICMSDifTot+=$vICMSDif;
				$vICMSOpTot+=$vICMSOp;
			}else{
				$pDif = '';
				$vICMSDif = '';
				$vICMSOp = '';
			}
			
			//icms retido (somente cst=60)
			if( $cst=="060" && $CRT==3 && $tribjson->{"rowdata"}[0]->{"ref_bcicmsret"} && $tribjson->{"rowdata"}[0]->{"ref_bcicmsret"}>0 && $tribjson->{"rowdata"}[0]->{"ref_icmsret"} && $tribjson->{"rowdata"}[0]->{"ref_icmsret"}>0 ){
				$vBCSTRet = number_format( $tribjson->{"rowdata"}[0]->{"ref_bcicmsret"} , 2, ".", "");
				$vICMSSTRet = number_format( $tribjson->{"rowdata"}[0]->{"ref_icmsret"} , 2, ".", "");
				$pST =  ($tribjson->{"rowdata"}[0]->{"ref_aliqicmsret"}>0) ? number_format( $tribjson->{"rowdata"}[0]->{"ref_aliqicmsret"} , 2, ".", "") : "0.00";
				$totRet+= $tribjson->{"rowdata"}[0]->{"ref_icmsret"};
			}else{
				$vBCSTRet = '0';
				$vICMSSTRet = '0';
				$pST='0.00';
			}
			
			//SIMPES NACIONAL CRT=1
			$csosn = ($tribjson->{"rowdata"}[0]->{"tri_csosn"} && $tribjson->{"rowdata"}[0]->{"tri_csosn"}!="000") ? $tribjson->{"rowdata"}[0]->{"tri_csosn"} : "400";
			$pCredSN = ($not->{"not_aliqcredicms"}>0) ? number_format($not->{"not_aliqcredicms"}, 2, ".", "") : "0";
			$icmsXaliqcredicms = ($not->{"itn_baseicms"}*$not->{"not_aliqcredicms"});
			$vCredICMSSN = ($icmsXaliqcredicms>0) ? number_format($icmsXaliqcredicms, 2, ".", "") : "0";
			
			//ipi
			$cstIpi =  str_pad($tribjson->{"rowdata"}[0]->{"tri_sit_ipi"}, 2, "0", STR_PAD_LEFT);
			$clEnq = "";
			$cnpjProd = "";
			$cSelo = "";
			$qSelo="";
			$cEnq = ($tribjson->{"rowdata"}[0]->{"tri_cenq"} && $tribjson->{"rowdata"}[0]->{"tri_cenq"}!="") ? $tribjson->{"rowdata"}[0]->{"tri_cenq"} : "999";
			$vBCIPI = ($not->{"itn_baseipi"}>0) ? number_format($not->{"itn_baseipi"}, 2, ".", "") : "0";
			$pIPI = ($not->{"itn_aliqipi"}>0) ? number_format($not->{"itn_aliqipi"}, 2, ".", "") : "0";
			$qUnid = "";
			$vUnid = "";
			$vIPI=($not->{"itn_ipi"}>0) ? number_format($not->{"itn_ipi"}, 2, ".", "") : "0";
			
			//pis
			$cstPIS = ($tribjson->{"rowdata"}[0]->{"tri_sit_pis"}) ? str_pad($tribjson->{"rowdata"}[0]->{"tri_sit_pis"}, 2, "0", STR_PAD_LEFT) : "07";
			//nao incidencia pis exportacao
			if( $cstPIS=="07" && ($nota[0]->{'cfo_codigo'}==5502 || $nota[0]->{'cfo_codigo'}==6502) ){
				$pisexport = true;
			}
			$vBCPIS = ( ($cstPIS=="01" || $cstPIS=="02") && $tribjson->{"rowdata"}[0]->{"tri_basepis"} && $tribjson->{"rowdata"}[0]->{"tri_basepis"}>0 ) ? number_format($tribjson->{"rowdata"}[0]->{"tri_basepis"}, 2, ".", "") : "0";
			$pPIS = ($tribjson->{"rowdata"}[0]->{"tri_aliqpis"} && $tribjson->{"rowdata"}[0]->{"tri_aliqpis"}>0 && $cstPIS!="03") ? number_format($tribjson->{"rowdata"}[0]->{"tri_aliqpis"}, 2, ".", "") : "0.00";
			$vPIS = ($tribjson->{"rowdata"}[0]->{"tri_pis"} && $tribjson->{"rowdata"}[0]->{"tri_pis"}>0) ? number_format($tribjson->{"rowdata"}[0]->{"tri_pis"}, 2, ".", "") : "0.00";
			$vTotPIS += $vPIS;
			$qBCProd = ($cstPIS=="03") ? $not->{"itn_qtde"} : "";
			$vAliqProd = ($cstPIS=="03" && $tribjson->{"rowdata"}[0]->{"tri_aliqpis"} && $tribjson->{"rowdata"}[0]->{"tri_aliqpis"}>0) ? number_format($tribjson->{"rowdata"}[0]->{"tri_aliqpis"}, 2, ".", "") : "";
			
			//cofins
			$cstCOFINS = ($tribjson->{"rowdata"}[0]->{"tri_sit_cofins"}) ? str_pad($tribjson->{"rowdata"}[0]->{"tri_sit_cofins"}, 2, "0", STR_PAD_LEFT) : "07";
			//nao incidencia cofins exportacao
			if( $cstCOFINS=="07" && ($nota[0]->{'cfo_codigo'}==5502 || $nota[0]->{'cfo_codigo'}==6502) ){
				$cofinsexport = true;
			}
			$vBCCOFINS = ( ($cstCOFINS=="01" || $cstCOFINS=="02") && $tribjson->{"rowdata"}[0]->{"tri_basecofins"} && $tribjson->{"rowdata"}[0]->{"tri_basecofins"}>0 ) ? number_format($tribjson->{"rowdata"}[0]->{"tri_basecofins"}, 2, ".", "") : "0.00";
			$pCOFINS = ($tribjson->{"rowdata"}[0]->{"tri_aliqcofins"}&& $tribjson->{"rowdata"}[0]->{"tri_aliqcofins"}>0 && $cstCOFINS!="03") ? number_format($tribjson->{"rowdata"}[0]->{"tri_aliqcofins"}, 2, ".", "") : "0.00";
			$vCOFINS =  ($tribjson->{"rowdata"}[0]->{"tri_cofins"} && $tribjson->{"rowdata"}[0]->{"tri_cofins"}>0) ? number_format($tribjson->{"rowdata"}[0]->{"tri_cofins"}, 2, ".", "") : "0.00";
			$vTotCOFINS += $vCOFINS;
			$qBCProdCOFINS = ($cstCOFINS=="03") ? $not->{"itn_qtde"} : "";
			$vAliqProdCOFINS = ($cstCOFINS=="03" && $tribjson->{"rowdata"}[0]->{"tri_aliqcofins"} && $tribjson->{"rowdata"}[0]->{"tri_aliqcofins"}>0) ? number_format($tribjson->{"rowdata"}[0]->{"tri_aliqcofins"}, 2, ".", "") : "";
			
			if($CRT==3 || $CRT=='3'){
				$resp = $nfe->tagICMS($nItem, $orig, $cst, $modBC, $tri_redbaseicms, $itn_baseicms, $itn_aliqicms, $vICMS, $vICMSDeson, $motDesICMS, $modBCST, $pMVAST, $pRedBCST, $vBCST, $pICMSST, $vICMSST, $pDif, $vICMSDif, $vICMSOp, $vBCSTRet, $vICMSSTRet, $pST);
			}else{
				$resp = $nfe->tagICMSSN($nItem, $orig, $csosn, $modBC, $itn_baseicms, $tri_redbaseicms, $itn_aliqicms, $vICMS, $pCredSN, $vCredICMSSN, $modBCST, $pMVAST, $pRedBCST, $vBCST, $pICMSST, $vICMSST, $vBCSTRet, $vICMSSTRet, $pST);
			}

			//ICMSPart
			//$resp = $nfe->tagICMSPart($nItem, $orig, $cst, $modBC, $vBC, $pRedBC, $pICMS, $vICMS, $modBCST, $pMVAST, $pRedBCST, $vBCST, $pICMSST, $vICMSST, $pBCOp, $ufST);
			//ICMSST
			//$resp = $nfe->tagICMSST($nItem, $orig, $tri_situacao, $vBCSTRet, $vICMSSTRet, $vBCSTDest, $vICMSSTDest);
			//ICMSSN
			
			//IPI
			if( !isset($_REQUEST["mod"]) ) $resp = $nfe->tagIPI($nItem, $cstIpi, $clEnq, $cnpjProd, $cSelo, $qSelo, $cEnq, $vBCIPI, $pIPI, $qUnid, $vUnid, $vIPI);
			//PIS
			$resp = $nfe->tagPIS($nItem, $cstPIS, $vBCPIS, $pPIS, $vPIS, $qBCProd, $vAliqProd);
			//PISST
			//$resp = $nfe->tagPISST($nItem, $vBC, $pPIS, $qBCProd, $vAliqProd, $vPIS);
			//COFINS
			$resp = $nfe->tagCOFINS($nItem, $cstCOFINS, $vBCCOFINS, $pCOFINS, $vCOFINS, $qBCProdCOFINS, $vAliqProdCOFINS);
			//COFINSST
			//$resp = $nfe->tagCOFINSST($nItem, $vBC, $pCOFINS, $qBCProd, $vAliqProd, $vCOFINS);
			//II
			if($nota[0]->{'end_uf'}=="EX" && $nota[0]->{'not_entrsaida'}==1){
				$resp = $nfe->tagII($nItem, '0.00', '0.00', '0.00', '0.00');
			}
			
			//Grupo a ser informado nas vendas interestaduais para consumidor final, não contribuinte de ICMS (a partir de 01/01/2016)
			if($indFinal=='1' && $idDest=='2' && $indIEDest != "1" && (!isset($cProdANP) || strstr("820101001|820101010|810102001|810102004|810102002|810102003|810101002|810101001|810101003|220101003|220101004|220101002|220101001|220101005|220101006|56010100", $cProdANP)) ){
				$vBCUFDest = $itn_baseicms;
				$vBCFCPUFDest = $vBCUFDest;
				$pFCPUFDest = ($nota[0]->{'end_uf'}=='SP' || $nota[0]->{'end_uf'}=='RJ') ? '2' : '0';
				if( strstr("MG|SP", $nota[0]->{'end_uf'}) ){
					$pICMSUFDest = '18.00';
				}elseif( $nota[0]->{'end_uf'}=="RJ" ){
					$pICMSUFDest = '19.00';
				}else{
					$pICMSUFDest = '17.50';
				}
				if($orig=="1" || $orig=="2" || $orig=="6" || $orig=="7"){ //produto importado
					$pICMSInter = '4.00';
				}elseif( strstr("PR|SC|RS|SP|RJ|MG", $company->{'emp_uf'}) && strstr("ES|AM|AC|RO|RR|PA|AP|TO|MA|PB|PE|AL|SE|CE|PI|BA|RN|MT|MS|GO|DF", $nota[0]->{'end_uf'}) ){ //origem no sul/ sudeste - destino no norte/nordeste/centro-oeste (exceto ES)
					$pICMSInter = '7.00';
				}else{ //demais casos
					$pICMSInter = '12.00';
				}
				if(date("Y")<="2016"){
					$pICMSInterPart = '40.00';
				}elseif(date("Y")=="2017"){
					$pICMSInterPart = '60.00';
				}elseif(date("Y")=="2018"){
					$pICMSInterPart = '80.00';
				}elseif(date("Y")>="2019"){
					$pICMSInterPart = '100.00';
				}
				$vFCPUFDest = ($vBCUFDest >0 && $pFCPUFDest>0) ? number_format(($vBCUFDest *$pFCPUFDest/100), 2, '.', '') : '0.00';
				$vFCPUFDestTot+=$vFCPUFDest;
				$vICMSUFDest = ($vICMS>0) ? number_format((($vBCUFDest*($pICMSUFDest-$pICMSInter)/100)*$pICMSInterPart/100), 2, '.', '') : '0.00';
				$vICMSUFDestTot+=$vICMSUFDest;
				$vICMSUFRemet = ($vICMS>0) ? number_format((($vBCUFDest*($pICMSUFDest-$pICMSInter)/100)*((100-$pICMSInterPart))/100), 2, '.', '') : '0.00';
				$vICMSUFRemetTot+=$vICMSUFRemet;
				$resp = $nfe->tagICMSUFDest($nItem, $vBCUFDest, $vBCFCPUFDest, $pFCPUFDest, $pICMSUFDest, $pICMSInter, $pICMSInterPart, $vFCPUFDest, $vICMSUFDest, $vICMSUFRemet);
			}
			
			//IBSCBS
			
			if($company->{'emp_codregtrib'}==3 && $tpAmb==2){
				$vibsuf = number_format(($itn_baseicms * 0.1 / 100), 2, '.', '');
				$vibsmun = number_format(($itn_baseicms * 0 / 100), 2, '.', '');
				$vcbs = number_format(($itn_baseicms * 0.9 / 100), 2, '.', '');
				$vibs = number_format(($vibsuf + $vibsmun), 2, '.', '');
				$resp = $nfe->tagIBSCBS($nItem, '000', '000001', $itn_baseicms, number_format(0.1, 2, '.', ''), $vibsuf, 0, 0, $vibs, number_format(0.9, 2, '.', ''), $vcbs);
			}
			
			
			$i++;
			
			$ant = $not->{"itn_ordem"};
			
		}	
			
	}
	$vFCPUFDestTot = ($vFCPUFDestTot>0) ? number_format($vFCPUFDestTot, 2, '.', '') : "";
	$vICMSUFDestTot = ($vICMSUFDestTot>0) ? number_format($vICMSUFDestTot, 2, '.', '') : "";
	$vICMSUFRemetTot = ($vICMSUFRemetTot>0) ? number_format($vICMSUFRemetTot, 2, '.', '') : "";
	
	$vII="0";
	$vTotPIS = ($vTotPIS>0) ? number_format($vTotPIS, 2, ".", "") : "0";
	$vTotCOFINS = ($vTotCOFINS>0) ? number_format($vTotCOFINS, 2, ".", "") : "0";
	$vNF = ($nota[0]->{"not_totalnota"}>0) ? number_format($nota[0]->{"not_totalnota"}, 2, ".", "") : "0";
		
	$vFrete =  ($nota[0]->{"not_frete"}>0 && ($nota[0]->{'not_tpfrete'}=='1' || $nota[0]->{"not_tpfrete"}=='2')) ? number_format($nota[0]->{"not_frete"}, 2, ".", "") : "0";
	$vSeg =  ($nota[0]->{"not_seguro"}>0) ? number_format($nota[0]->{"not_seguro"}, 2, ".", "") : "0";
	$vTotOutro = ($vTotOutro>0) ? number_format($vTotOutro, 2, ".", "") : '0';
	$totBaseicms  = ($nota[0]->{"not_totbaseicms"} >0) ? number_format($nota[0]->{"not_totbaseicms"}, 2, ".", "") : "0";
	$vTotICMS  = ($nota[0]->{"not_toticms"} >0) ? number_format($nota[0]->{"not_toticms"}, 2, ".", "") : "0";
	$vTotBCST  = ($nota[0]->{"not_totbaseicmsst"} >0) ? number_format($nota[0]->{"not_totbaseicmsst"}, 2, ".", "") : "0";
	$vTotST  = ($vTotST >0) ? number_format($vTotST, 2, ".", "") : "0";
	$vTotDesc = ($vTotDesc>0) ? number_format($vTotDesc, 2, ".", "") : "0";
	$vTotIPI =($nota[0]->{"not_totipi"} >0 && !isset($_REQUEST["mod"]) ) ? number_format($nota[0]->{"not_totipi"}, 2, ".", "") : "0";
	
	//NF-e 4.00
	$vFCPTot = '0.00';
	$vFCPSTTot = '0.00';
	$vFCPSTRetTot = '0.00';
	$vIPIDevol = '0.00';
	
	$vTotProd =($vTotProd >0) ? number_format($vTotProd, 2, ".", "") : "0";
	// $vTotProd =($nota[0]->{"not_totalprod"} > 0) ? number_format($nota[0]->{"not_totalprod"}, 2, ".", "") : "0";
	
	//corrigir diferença de um centavo de arredondamento de casas decimais
	$diff = $vNF - $vTotProd;
	if($diff!=0) $diff = number_format($diff,2);
	$vNF = ( $diff == 0.01 || $diff == -0.01 ) ? $vTotProd : $vNF; 

	if($vICMSDesonTot>0){
		//str_pad($this->nota[0]->ser_codigo, 3, "0", STR_PAD_LEFT)
		$vICMSDesonTot = number_format($vICMSDesonTot, 2, ".", "");
	}else{
		$vICMSDesonTot=0;
	}
	//ICMSTot
	$resp = $nfe->tagICMSTot($totBaseicms , $vTotICMS, $vICMSDesonTot, $vFCPTot, $vFCPUFDestTot, $vICMSUFDestTot, $vICMSUFRemetTot, $vTotBCST, $vTotST, $vFCPSTTot, $vFCPSTRetTot, $vTotProd, $vFrete, $vSeg, $vTotDesc, $vII, $vTotIPI, $vIPIDevol, $vTotPIS, $vTotCOFINS, $vTotOutro, $vNF, $vTotTrib2);
	
	//frete
	//0=Contratação do Frete por conta do Remetente (CIF);1=Contratação do Frete por conta do Destinatário (FOB);2=Contratação do Frete por conta de Terceiros;3=Transporte Próprio por conta do Remetente;4=Transporte Próprio por conta do Destinatário;9=Sem Ocorrência de Transporte.
	if($nota[0]->{"not_tpfrete"}=='9'){
		$modFrete = $nota[0]->{"not_tpfrete"};
	}else{
		$modFrete = $nota[0]->{"not_tpfrete"}-1;
	}
	if( isset($_REQUEST["mod"]) && $_REQUEST["mod"]=="65" ) $modFrete = "9";
	$resp = $nfe->tagtransp($modFrete);

	//transportadora
	if($transportadora!=""){
		$CNPJ = ($transportadora[0]->{"cad_pessoa"}==2) ? $transportadora[0]->{"cad_cnpjcpf"} : '';
		$CPF = ($transportadora[0]->{"cad_pessoa"}==1) ? $transportadora[0]->{"cad_cnpjcpf"} : '';
		$xNome = str_replace("&", "&amp;", $transportadora[0]->{"cad_nomeraz"});
		$IE = ($transportadora[0]->{"cad_inscrg"} && $transportadora[0]->{"cad_pessoa"}==2) ? $transportadora[0]->{"cad_inscrg"} : '';
		$xEnder = ($transportadora[0]->{"end_nome"}) ? $transportadora[0]->{"end_nome"} : "";
		$xMun = ($transportadora[0]->{"end_cidade"}) ? $transportadora[0]->{"end_cidade"} : "";
		$UF = ( isset($transportadora[0]->{"end_uf"}) && $transportadora[0]->{"end_uf"}!="") ? $transportadora[0]->{"end_uf"} : "PR";
		$resp = $nfe->tagtransporta($CNPJ, $CPF, $xNome, $IE, $xEnder, $xMun, $UF);
	}
	//nao informar dados do veiculo em notas interestaduais (regra sefaz)
	if($transportadora!="" && $idDest!="2"){
		//dados dos veiculos de transporte
		$placa = ($not->{"not_placa"}) ? strtoupper(str_replace("-", "", $not->{"not_placa"})) : 'AAA0000';
		$UF = ( isset($transportadora[0]->{"end_uf"}) && $transportadora[0]->{"end_uf"}!="") ? $transportadora[0]->{"end_uf"} : "PR";
		$RNTC = '';
		$resp = $nfe->tagveicTransp($placa, $UF, $RNTC);
	}

	//dados dos volumes transportados
	if(!isset($_REQUEST['mod']) || $_REQUEST['mod'] != 65){
		$qVol = (int) $not->{"not_qtde"}; //Quantidade de volumes transportados
		$esp = $not->{"not_especie"}; //Espécie dos volumes transportados
		$marca = $not->{"not_marca"}; //Marca dos volumes transportados
		$nVol = $not->{"not_nro"}; //Numeração dos volume
		$pesoL = ($nota[0]->{"not_pesoliquido"}>0) ? number_format($nota[0]->{"not_pesoliquido"}, 3, ".", "") : "0";
		$pesoB = ($nota[0]->{"not_pesobruto"}>0) ? number_format($nota[0]->{"not_pesobruto"}, 3, ".", "") : "0";
		$aLacres = '';
		$resp = $nfe->tagvol($qVol, $esp, $marca, $nVol, $pesoL, $pesoB, $aLacres);
	}

	//dados da fatura
	$nFat = '';
	$vOrig = '';
	$vDesc = '';
	$vLiq = '';

	//dados das duplicadas
	if(isset($_REQUEST["parc"]) && $_REQUEST["parc"]=='sim' && isset($doctos) && is_array($doctos) && isset($doctos[0]->{"doc_tipo"}) ){
		foreach ($doctos as $docto) {
			$totdoc += $docto->{"doc_valor"};
		}
		$nFat = $doctos[0]->{"doc_numero"};
		$vOrig = $vLiq = ($totdoc>0) ? number_format($totdoc, 2, ".", "") : "0.00";
		// $vOrig = $vLiq = ($vNF>0) ? number_format($vNF, 2, ".", "") : "0.00";
		$resp = $nfe->tagfat($nFat, $vOrig, $vDesc, $vLiq);
		$n=1;
		if($nota[0]->{'cdp_indpag'}==1){
			foreach ($doctos as $docto) {
				$nDup = str_pad($n, 3, '0', STR_PAD_LEFT);
				$dVenc = substr($docto->{"doc_dtvcto"}, 0, 10);
				$vDup = ($docto->{"doc_valor"}>0) ? number_format($docto->{"doc_valor"}, 2, ".", "") : "0.00";
				$resp = $nfe->tagdup($nDup, $dVenc, $vDup);
				$n++;
			}
		}
	}


	//Grupo obrigatório para a NFC-e. Não informar para a NF-e versão anterior a 4
	if( (isset($_REQUEST["mod"]) && $_REQUEST["mod"]=="65") ){
		$tPag = '01'; //01=Dinheiro 02=Cheque 03=Cartão de Crédito 04=Cartão de Débito 05=Crédito da Loja 10=Vale Alimentação 11=Vale Refeição 12=Vale Presente 13=Vale Combustível 14=Duplicata Mercantil 15=Boleto Bancario 16=deposito bancario 17=Pix dinamico 18=Transf Bancaria, carteira digital 19=programa fidelidade 20=Pix estatico 21=credito em loja 22=nao informado por falha de hardwatre 90=sem pagamento 99=Outros
		$vPag = ($vNF>0) ? number_format($vNF, 2, ".", "") : "0.00";
		$resp = $nfe->tagpag($tPag, $vPag);
		
		$qrCode = 'http://www.fazenda.pr.gov.br/nfce/qrcode/?p=';
		$seq = $chave.'|2|'.$tpAmb."|"; //URL do QR Code
		$seq .= ($company->emp_codigo=="MILCOISAS") ? "2" : "1";
		$hash = strtoupper(sha1($seq.$company->emp_csc));
		$qrCode = $qrCode.$seq."|".$hash;
		$urlChave = 'http://www.fazenda.pr.gov.br';
		$resp = $nfe->taginfNFeSupl($qrCode, $urlChave);
	//Passa a ser obrigatório tag de pagamento a partir da NF-e 4.0
	}
	//para nfc-e nao informar duplicata mercantil (14)
	if( isset($doctos) && is_array($doctos) && isset($doctos[0]) && $doctos[0]!="" && $doctos[0]->doc_valor>0 ){
		$t=0;
		foreach($doctos as $doc){
			switch($doc->{"doc_tipo"}){
				case 1:
					$tPag='01';
					break;
				case 2:
					$tPag='15';
					break;
				case 4:
					$tPag='02';
					break;
				case 5:
					$tPag='03';
					break;
				case 6:
					$tPag='04';
					break;
				case 9:
					$tPag='16';
					break;
				case 10:
					$tPag='01';
					break;
				case 24:
					$tPag='17';
					break;
				default:
					$tPag='01';
			}
			$vPag = ($doc->doc_valor>0) ? number_format($doc->doc_valor, 2, ".", "") : "0,00";
			$t += $vPag;
			$vTroco = ($t>$vNF) ? number_format(($t-$vNF), 2, ".", "") : "";
			$resp = $nfe->tagdetpag($tPag, $vPag, $vTroco);
			
			//se a operação for com cartão de crédito essa informação é obrigatória
			$tpIntegra = '2'; //Tipo de Integração do processo de pagamento: 1=Pagamento integrado com o sistema de automação da empresa (Ex.: equipamento TEF, Comércio Eletrônico); 2= Pagamento não integrado com o sistema de automação da empresa (Ex.: equipamento POS); 
			$CNPJ = ''; //CNPJ da operadora de cartão
			$tBand = ''; //01=Visa 02=Mastercard 03=American Express 04=Sorocred 05=Diners Club 06=Elo 07=Hipercard 08=Aura 09=Cabal 99=Outros
			$cAut = ''; //número da autorização da transação
			if($tPag=='03' || $tPag=='04' || $tPag=='17'){
				$resp = $nfe->tagcard($tpIntegra, $CNPJ, $tBand, $cAut);
			}
		}
		
	}
	/*
	elseif($finNFe=='1'){
		$tPag = '01'; //01=Dinheiro 02=Cheque 03=Cartão de Crédito 04=Cartão de Débito 05=Crédito Loja 10=Vale Alimentação 11=Vale Refeição 12=Vale Presente 13=Vale Combustíve 14=Duplicata 15=boleto bancario 90=Sem Pagamentol 99=Outros
		$vPag = ( ($vNF>0) && $tPag!='90' ) ? number_format($vNF, 2, ".", "") : "0.00";
		$vTroco='';
		$resp = $nfe->tagdetpag($tPag, $vPag, $vTroco);
		
		//se a operação for com cartão de crédito essa informação é obrigatória
		$tpIntegra = '2'; //Tipo de Integração do processo de pagamento: 1=Pagamento integrado com o sistema de automação da empresa (Ex.: equipamento TEF, Comércio Eletrônico); 2= Pagamento não integrado com o sistema de automação da empresa (Ex.: equipamento POS); 
		$CNPJ = ''; //CNPJ da operadora de cartão
		$tBand = ''; //01=Visa 02=Mastercard 03=American Express 04=Sorocred 05=Diners Club 06=Elo 07=Hipercard 08=Aura 09=Cabal 99=Outros
		$cAut = ''; //número da autorização da transação
		if($tPag=='03' || $tPag=='04') $resp = $nfe->tagcard($tpIntegra, $CNPJ, $tBand, $cAut);
	}
	*/
	else{
		$tPag='90';
		$vPag = ( ($vNF>0) && $tPag!='90' ) ? number_format($vNF, 2, ".", "") : "0.00";
		$vTroco='';
		$resp = $nfe->tagdetpag($tPag, $vPag, $vTroco);
		
		//se a operação for com cartão de crédito essa informação é obrigatória
		$tpIntegra = '2'; //Tipo de Integração do processo de pagamento: 1=Pagamento integrado com o sistema de automação da empresa (Ex.: equipamento TEF, Comércio Eletrônico); 2= Pagamento não integrado com o sistema de automação da empresa (Ex.: equipamento POS); 
		$CNPJ = ''; //CNPJ da operadora de cartão
		$tBand = ''; //01=Visa 02=Mastercard 03=American Express 04=Sorocred 05=Diners Club 06=Elo 07=Hipercard 08=Aura 09=Cabal 99=Outros
		$cAut = ''; //número da autorização da transação
		if($tPag=='03' || $tPag=='04') $resp = $nfe->tagcard($tpIntegra, $CNPJ, $tBand, $cAut);
	}
	
	

	//informações Adicionais
	$infAdFisco="";
	//DIFAL
	if($vICMSUFDestTot>0){
		$infAdFisco .= "ICMS da UF de destino por DIFAL R$".number_format($vICMSUFDestTot, 2, ",", "").". ";
	}
	if($vICMSUFRemetTot>0){
		$infAdFisco .= "ICMS da UF de origem por DIFAL R$".number_format($vICMSUFRemetTot, 2, ",", "").". ";
	}
	//ICMS diferido
	if($vICMSDifTot>0 && $pDif>0 && $vICMSOpTot>0){
		// $infAdFisco .= "Operação com diferimento parcial do imposto no valor de R$ ".number_format($vICMSDifTot, 2, ",", "")." (".number_format($pDif, 2, ",", "")."% de R$ ".number_format($vICMSOpTot, 2, ",", "").")  nos termos do inciso I do art.108 do Decreto n° 6.080/2012 (RICMS/PR).";
	}
	//ICMS retido anteriormente
	if($totRet>0){
		$infAdFisco .= "Total de ICMS retido anteriormente por ST R$ ".number_format($totRet, 2, ",", "").". ";
	}
	//motivo de nao tributacao na exportacao
	if( isset($icmsexport) ){
		$infAdFisco .= "ICMS NAO INCIDENCIA ART III INCISO II, REGULAMENTO ICMS PARANA DECRETO 6080/2012 ";
	}
	if( isset($pisexport) ){
		$infAdFisco .= "PIS/COFINS NAO INCIDENCIA ART V INCISO I DA LEI 106 3702 E INCISO I ART VI DA LEI 10833/2003 ";
	}
	if( isset($cofinsexport) ){
		$infAdFisco .= "COFINS NAO INCIDENCIA, ART VI, INCISO I, LEI 10.833/2003 ";
	}
	if( isset($ipiexport) ){
		$infAdFisco .= "IPI SUSPENSO ART XLIII, INCISO V, DECRETO 7.212/2010 ";
	}
	//cbenef
	if(isset($cbenef) && $cbenef=="PR820004"){
		$infAdFisco .= "Redução de base de cálculo prevista no item 4 do Anexo VI do RICMS/2017";
	}
	if(isset($cbenef) && $cbenef=="PR810163"){
		$infAdFisco .= "Isenção do ICMS Cfe. Dec 7.871/2017 - Anexo V Item 163";
	}
	//aproveitamento de ICMS
	$infAdFisco.= (isset($not->{"not_aliqcredicms"}) && $not->{"not_aliqcredicms"}>0) ? " - PERMITE O APROVEITAMENTO DE CREDITO DE ICMS NO VALOR DE R$ ".number_format(($not->{"not_aliqcredicms"}*$nota[0]->{"not_totalnota"}/100), 2, ",", "").", CORRESPONDENTE AO PERCENTUAL DE ".number_format($not->{"not_aliqcredicms"}, 2, ",", "")."% NOS TERMOS DO ART. 23 DA LC 123." : "";
	
	$infAdFisco.= (isset($not->{"not_inf_fisco"}) && $not->{"not_inf_fisco"}!="") ? str_replace($array1, $array2, trim(base64_decode($not->{"not_inf_fisco"}))) : "";
	
	$infCpl = '';
		
	$infCpl .= (isset($not->{"not_obs1"}) && $not->{"not_obs1"}!="") ? str_replace($array1, $array2, trim(base64_decode($not->{"not_obs1"}))).". " : "";
	$infCpl .= (isset($not->{"not_obs4"}) && $not->{"not_obs4"}!="" && isset($company->{"cfg_ibpt_detalhe"}) && $company->{"cfg_ibpt_detalhe"}!=3) ? str_replace($array1, $array2, trim(base64_decode($not->{"not_obs4"}))) : "";
	$resp = $nfe->taginfAdic($infAdFisco, $infCpl);
	
	
	//Grupo dos autorizados a fazer download do XML
	if( isset($company->{"emp_ctb_cnpj"}) && $company->{"emp_ctb_cnpj"}!="" ){
		$autx = str_replace(array(".","-","/", " "), "", $company->{"emp_ctb_cnpj"});
		$resp = $nfe->tagautXML($autx, "");
	}
	$resp = $nfe->tagautXML("19699120000157", "");
	
	//Grupo do responsavel tecnico
	if($tpAmb == 2){
		$hashCSRT = "02YQ714CPGWB66BV06DNPN7Y1K23PHNQT60L".$chave;
		$idCSRT = '01';
	}else{
		$hashCSRT = "19N7S4Y1G0X7WESNDVUTNT4R88IF87DM6AQ1".$chave;
		$idCSRT = '02';
	}
	$hashCSRT = sha1($hashCSRT, true);
	$hashCSRT = base64_encode($hashCSRT);
	$resp = $nfe->taginfRespTec("19699120000157", "Julio Cesar Mantovan", "suporte@jcmantovan.com.br","44999600544", $idCSRT, $hashCSRT);

	//observações emitente
	$aObsC = array(
		array('email','roberto@x.com.br'),
		array('email','rodrigo@y.com.br'),
		array('email','rogerio@w.com.br')
	);
	foreach ($aObsC as $obs) {
		$xCampo = $obs[0];
		$xTexto = $obs[1];
		//$resp = $nfe->tagobsCont($xCampo, $xTexto);
	}

	//observações fisco
	$aObsF = array(
		array('email','roberto@x.com.br'),
		array('email','rodrigo@y.com.br'),
		array('email','rogerio@w.com.br')
	);
	foreach ($aObsF as $obs) {
		$xCampo = $obs[0];
		$xTexto = $obs[1];
		//$resp = $nfe->tagobsFisco($xCampo, $xTexto);
	}

	//Dados do processo
	//0=SEFAZ; 1=Justiça Federal; 2=Justiça Estadual; 3=Secex/RFB; 9=Outros
	$aProcRef = array(
		array('nProc1','0'),
		array('nProc2','1'),
		array('nProc3','2'),
		array('nProc4','3'),
		array('nProc5','9')
	);
	foreach ($aProcRef as $proc) {
		$nProc = $proc[0];
		$indProc = $proc[1];
		//$resp = $nfe->tagprocRef($nProc, $indProc);
	}

	//dados exportação
	$UFSaidaPais = 'PR';
	$xLocExporta = 'PARANA';
	$xLocDespacho = 'PARANA';
	if($nota[0]->{'end_uf'}=="EX" && $nota[0]->{'not_entrsaida'}==2) $resp = $nfe->tagexporta($UFSaidaPais, $xLocExporta, $xLocDespacho);

	//dados de compras
	$xNEmp = '';
	$xPed = '12345';
	$xCont = 'A342212';
	//$resp = $nfe->tagcompra($xNEmp, $xPed, $xCont);

	//dados da colheita de cana
	$safra = '2014';
	$ref = '01/2014';
	//$resp = $nfe->tagcana($safra, $ref);

	$aForDia = array(
		array('1', '100', '1400', '1000', '1400'),
		array('2', '100', '1400', '1000', '1400'),
		array('3', '100', '1400', '1000', '1400'),
		array('4', '100', '1400', '1000', '1400'),
		array('5', '100', '1400', '1000', '1400'),
		array('6', '100', '1400', '1000', '1400'),
		array('7', '100', '1400', '1000', '1400'),
		array('8', '100', '1400', '1000', '1400'),
		array('9', '100', '1400', '1000', '1400'),
		array('10', '100', '1400', '1000', '1400'),
		array('11', '100', '1400', '1000', '1400'),
		array('12', '100', '1400', '1000', '1400'),
		array('13', '100', '1400', '1000', '1400'),
		array('14', '100', '1400', '1000', '1400')
	);
	foreach ($aForDia as $forDia) {
		$dia = $forDia[0];
		$qtde = $forDia[1];
		$qTotMes = $forDia[2];
		$qTotAnt = $forDia[3];
		$qTotGer = $forDia[4];
		//$resp = $nfe->tagforDia($dia, $qtde, $qTotMes, $qTotAnt, $qTotGer);
	}

	//monta a NFe
	$resp = $nfe->montaNFe();

	$modSOAP = '2';
	
	if(!$resp){
		$erro = "Erro XML Incompleto: <br>";
		foreach ($nfe->erros as $err) {
			$erro.= 'tag: &lt;'.$err['tag'].'&gt; : '.$err['desc'].'<br>';
		}
		echo $erro;
		exit();
	}
	
	//instancia ferramentas NFe e classes para atualização do BD
	$tools = new ToolsNFePHP;
	$TParams = new TParams();
	$Datapacket = new Datapacket();
	$Datapacket->setHost($TParams->getHost($company->{'emp_db_sge'}));

	//pasta padrão para o xml
	if($nota[0]->{'not_status'}==2){
		if(!is_dir($TParams->uploads.$_REQUEST["emp_codigo"].'/nfe/'.$Nota->{"ambNfe"}.'/autorizadas')){
			@mkdir($TParams->uploads.$_REQUEST["emp_codigo"].'/nfe/'.$Nota->{"ambNfe"}.'/autorizadas',0777,true);
		}
		$nfeDir = $TParams->uploads.$_REQUEST["emp_codigo"].'/nfe/'.$Nota->{"ambNfe"}.'/autorizadas/'.$Nota->anoMes."/";
		if(!is_dir($nfeDir)){
			@mkdir($nfeDir,0777,true);
		}
		$situacao = "autorizadas";
	}else if($nota[0]->{'not_cstat'} == '110' || $nota[0]->{'not_cstat'} == '205' || $nota[0]->{'not_cstat'} == '233' || $nota[0]->{'not_cstat'} == '234' || $nota[0]->{'not_cstat'} == '301'){
		if(!is_dir($TParams->uploads.$_REQUEST["emp_codigo"].'/nfe/'.$Nota->{"ambNfe"}.'/denegadas')){
			@mkdir($TParams->uploads.$_REQUEST["emp_codigo"].'/nfe/'.$Nota->{"ambNfe"}.'/denegadas',0777,true);
		}
		$nfeDir = $TParams->uploads.$_REQUEST["emp_codigo"].'/nfe/'.$Nota->{"ambNfe"}.'/denegadas/'.$Nota->anoMes."/";
		if(!is_dir($nfeDir)){
			@mkdir($nfeDir,0777,true);
		}
		$situacao = "denegadas";
	}else if($nota[0]->{'not_cstat'} == '101' || $nota[0]->{'not_cstat'} == '135'){
		if(!is_dir($TParams->uploads.$_REQUEST["emp_codigo"].'/nfe/'.$Nota->{"ambNfe"}.'/canceladas')){
			@mkdir($TParams->uploads.$_REQUEST["emp_codigo"].'/nfe/'.$Nota->{"ambNfe"}.'/canceladas',0777,true);
		}
		$nfeDir = $TParams->uploads.$_REQUEST["emp_codigo"].'/nfe/'.$Nota->{"ambNfe"}.'/canceladas/'.$Nota->anoMes."/";
		if(!is_dir($nfeDir)){
			@mkdir($nfeDir,0777,true);
		}
		$situacao = "canceladas";
	}else if($nota[0]->{'not_status'}==1){
		if(!is_dir($TParams->uploads.$_REQUEST["emp_codigo"].'/nfe/'.$Nota->{"ambNfe"}.'/aguardando')){
			@mkdir($TParams->uploads.$_REQUEST["emp_codigo"].'/nfe/'.$Nota->{"ambNfe"}.'/aguardando',0777,true);
		}
		$nfeDir = $TParams->uploads.$_REQUEST["emp_codigo"].'/nfe/'.$Nota->{"ambNfe"}.'/aguardando/'.$Nota->anoMes."/";
		if(!is_dir($nfeDir)){
			@mkdir($nfeDir,0777,true);
		}
		$situacao = "aguardando";
	}else{
		if(!is_dir($TParams->uploads.$_REQUEST["emp_codigo"].'/nfe/'.$Nota->{"ambNfe"}.'/temporarias')){
			@mkdir($TParams->uploads.$_REQUEST["emp_codigo"].'/nfe/'.$Nota->{"ambNfe"}.'/temporarias',0777,true);
		}
		$nfeDir = $TParams->uploads.$_REQUEST["emp_codigo"].'/nfe/'.$Nota->{"ambNfe"}.'/temporarias/'.$Nota->anoMes."/";
		if(!is_dir($nfeDir)){
			@mkdir($nfeDir,0777,true);
		}
		$situacao = "temporarias";
	}

	if(is_dir($nfeDir)){
		
		//Criar e escrever arquivo XML com os dados gerados
		if(!empty($nota[0]->{'not_key_nfe'})){
			$nomeArquivo = $nfeDir.$nota[0]->{'not_key_nfe'}.'-nfe.xml';
		}else{
			$nomeArquivo = $nfeDir.$Nota->gerarChave().'-nfe.xml';
		}
		
		if($nota[0]->{"not_status"}==0){
			$arquivoXML = fopen($nomeArquivo,'w+');
			fwrite($arquivoXML, $nfe->getXML());
			
			fclose($arquivoXML);
			chmod($nomeArquivo, 0777);
		}
		
		
		$aErro = array();
		$docxml = file_get_contents($nomeArquivo);
		
		if(isset($_REQUEST["motivo"]) && $_REQUEST["motivo"]=="erro"){

			//classe p/ envio
			include_once "../libs/MailNFePHP.class.php";
			
			//dados de configuração de envio
			$config = array(
				"mailAuth"=>"1",
				"mailFROM"=>strtolower($company->{"emp_emailremetente"}),
				"mailHOST"=>strtolower($company->{'emp_hostsmtp'}),
				"mailUSER"=>strtolower($company->{"emp_emailremetente"}),
				"mailPASS"=>$company->{"emp_pwdsmtp"},
				"mailPORT"=>"587",
				"mailPROTOCOL"=>"",
				"mailFROMmail"=>strtolower($company->{"emp_emailremetente"}),
				"mailFROMname"=>$company->{"emp_fantasia"},
				"mailREPLYTOmail"=>strtolower($company->{"emp_emailremetente"}),
				"mailREPLYTOname"=>$company->{"emp_fantasia"},
				"mailIMAPhost"=>"",
				"mailIMAPport"=>"",
				"mailIMAPsecurity"=>"",
				"mailIMAPnocerts"=>"",
				"mailIMAPbox"=>"",
				"recebidasDir"=>"",
				"temporariasDir"=>"",
				"canceladasDir"=>"",
				"CNPJ"=>$company->{"emp_cpfcnpj"},
				"mailLayoutFile"=>""
			);

			$email = new MailNFePHP($config);
			$msg = str_replace(" ","+",$_REQUEST["msg"]);
			$msg = base64_decode($msg);

			$to = base64_decode($_REQUEST["email"]);
			$to = str_replace(" ", "", $to);
			if(strstr($to, ";")) $to = explode(";", $to);
			elseif(strstr($to, ",")) $to = explode(",", $to);
			
			$cliente = $nota[0]->{"cad_nomeraz"};
			$assunto = utf8_decode("Erro de NF-e - C: ".$company->{"emp_codigo"}." - S: ".$nota[0]->{"ser_codigo"}." - N: ".$nota[0]->{"not_numero"});
			if(isset($nomeArquivo) && $nomeArquivo!=""){
				$arqxml = $nomeArquivo;
			}else{
				$arqxml = "";
			}
			$arqpdf = "";
			$auth = "1";
			$outro = "";

			//texto puro (sem html)
			$txt = strip_tags($msg);

			if(is_array($to)){

				$msgfinal = "";
				foreach($to as $para){
					if($email->sendM($para, $cliente, $assunto, utf8_decode($txt), utf8_decode($msg), $arqxml, $arqpdf, $auth, $outro))
						$msgfinal.= $para." - Enviado!<br>";
					else
						$msgfinal.= $para." - Não Enviado!<br>";
				}
				exit($msgfinal);

			}else{

				if( $email->sendM($to, $cliente, $assunto, $txt, $msg, $arqxml, "", "0", "") ){
					exit("E-mail enviado com sucesso!");
				}else{
					exit("Erro ao tentar enviar e-mail, verifique as configurações de envio e tente novamente mais tarde.<br>Ação:E-mail suporte");
				}

			}

		}else{

			//acao=transmitir
			if($_REQUEST["acao"]=="transmitir"){
				
				// $xsd = '../schemes/PL_009_V4_2016_002_v160b/nfe_v4.00.xsd';
				// $xsd = '../schemes/PL_009_V4_00_NT_2018_005_v1.20/nfe_v4.00.xsd';
				// $xsd = '../schemes/PL_009/nfe_v4.00.xsd';
				$xsd = '../schemes/PL_010b_NT2025_002_v1.21/nfe_v4.00.xsd';
				
				//Validar XML
				if (!$tools->validXML($docxml, $xsd, $aErro)) {
					
					//XML inválido - erro
					$erro = 'Erro(s) na estrutura XML: <br>';
					foreach ($aErro as $er) {
						$erro.= $er .'<br>';
					}
					//Atualização do log com os dados de erros no XML
					$filtrolog = '{"cod":"700103","params":[
						{"name":"log_tipo","value":"2","type":"integer"},
						{"name":"log_nro","value":"'.$nota[0]->{"not_codigo"}.'","type":"string"},
						{"name":"log_serie","value":"'.$nota[0]->{"ser_codigo"}.'","type":"string"},';
					$filtrolog.= ( isset($_REQUEST["usu_login"]) && $_REQUEST["usu_login"]!="" ) ? '{"name":"log_usu_login","value":"'.$_REQUEST["usu_login"].'","type":"string"},' : '{"name":"log_usu_login","value":"NULL","type":"other"},';
					$filtrolog.= '{"name":"log_acao_cod","value":"2","type":"integer"},
						{"name":"log_acao_descr","value":"edição","type":"string"},
						{"name":"log_data","value":"'.date("Y-m-d H:i:s").'","type":"string"},
						{"name":"log_protocolo","value":"NULL","type":"other"},
						{"name":"log_ret","value":"NULL","type":"other"},
						{"name":"log_outro","value":"'.base64_encode(str_replace("<br>", "; ", $erro)).'","type":"string"}
					]}';
					$Datapacket->add($filtrolog);
					$Datapacket->open();

					//classe p/ envio
					include_once "../libs/MailNFePHP.class.php";
					
					//dados de configuração de envio
					$config = array(
						"mailAuth"=>"0",
						"mailFROM"=>$company->{"emp_emailremetente"},
						"mailHOST"=>'127.0.0.1',
						"mailUSER"=>$company->{"emp_emailremetente"},
						"mailPASS"=>$company->{"emp_pwdsmtp"},
						"mailPORT"=>"587",
						"mailPROTOCOL"=>"",
						"mailFROMmail"=>$company->{"emp_emailremetente"},
						"mailFROMname"=>$company->{"emp_fantasia"},
						"mailREPLYTOmail"=>$company->{"emp_emailremetente"},
						"mailREPLYTOname"=>$company->{"emp_fantasia"},
						"mailIMAPhost"=>"",
						"mailIMAPport"=>"",
						"mailIMAPsecurity"=>"",
						"mailIMAPnocerts"=>"",
						"mailIMAPbox"=>"",
						"recebidasDir"=>"",
						"temporariasDir"=>"",
						"canceladasDir"=>"",
						"CNPJ"=>$company->{"emp_cpfcnpj"},
						"mailLayoutFile"=>""
					);

					$email = new MailNFePHP($config);
					$msg = str_replace(" ","+",$_REQUEST["msg"]);
					$msg = base64_decode($msg);

					$to = base64_decode($_REQUEST["email"]);
					$to = str_replace(" ", "", $to);
					if(strstr($to, ";")) $to = explode(";", $to);
					elseif(strstr($to, ",")) $to = explode(",", $to);
					
					$cliente = $nota[0]->{"cad_nomeraz"};
					$assunto = utf8_decode("Erro de NF-e - C: ".$company->{"emp_codigo"}." - S: ".$nota[0]->{"ser_codigo"}." - N: ".$nota[0]->{"not_numero"});
					if(isset($nomeArquivo) && $nomeArquivo!=""){
						$arqxml = $nomeArquivo;
					}else{
						$arqxml = "";
					}
					$arqpdf = "";
					$auth = "0";
					$outro = "";

					//texto puro (sem html)
					$txt = strip_tags($msg);

					if(is_array($to)){

						$msgfinal = "";
						foreach($to as $para){
							if($email->sendM($para, $cliente, $assunto, utf8_decode($txt), utf8_decode($msg), $arqxml, $arqpdf, $auth, $outro))
								$msgfinal.= $para." - Enviado!<br>";
							else
								$msgfinal.= $para." - Não Enviado!<br>";
						}
						exit($msgfinal);

					}else{

						if( $email->sendM($to, $cliente, $assunto, utf8_decode($txt), utf8_decode($msg).$arqpdf, $arqxml, $arqpdf, $auth, $outro) ){
							exit("E-mail enviado com sucesso!");
						}else{
							exit("<br><div style='margin:10px;background-color:#fde8e8;border:1px #ffd6d6 solid; border-radius:8px'><div style='padding:2px;border:1px #fee2e2 solid; border-radius:8px'>".$erro."</div></div><br>Ação:Validar Xml");
						}

					}
					
					echo $erro;

				}else{ //XML válido prosseguir

					//Assinar XML
					if ($xml = $tools->signXML($docxml, 'infNFe')){
					
						file_put_contents($nomeArquivo, $xml);
						$docxml = file_get_contents($nomeArquivo);
						//Obter um numero de lote
						$lote = substr(str_replace(',','',number_format(microtime(true)*1000000,0)),0,15);

						//Enviar o lote
						if ($retorno = $tools->autoriza($docxml, $lote, $aResp)){
							//atualiza status nf-e no banco para 1 (aguardando retorno)
							$not_finanatualiz = ( isset($nota[0]->{"not_finanatualiz"}) ) ? $nota[0]->{"not_finanatualiz"} : "0";
							$not_stokatualiz = ( isset($nota[0]->{"not_stokatualiz"}) ) ? $nota[0]->{"not_stokatualiz"} : "0";
							$not_custoautaliz = ( isset($nota[0]->{"not_custoautaliz"}) ) ? $nota[0]->{"not_custoautaliz"} : "0";
							$filtroAtualiza = '{"cod":"700105","params":[
								{"name":"not_status","value":"0","type":"integer"},
								{"name":"not_dtfaturam","value":"NULL","type":"other"},
								{"name":"not_dtprevisao","value":"NULL","type":"other"},
								{"name":"not_dtentrega","value":"NULL","type":"other"},
								{"name":"not_finanatualiz","value":"'.$not_finanatualiz.'","type":"integer"},
								{"name":"not_stokatualiz","value":"'.$not_stokatualiz.'","type":"integer"},
								{"name":"not_custoautaliz","value":"'.$not_custoautaliz.'","type":"integer"},
								{"name":"not_key_nfe","value":"'.$chave.'","type":"string"},
								{"name":"not_result","value":"'.base64_encode(json_encode($retorno)).'","type":"string"},
								{"name":"not_cstat","value":"'.$retorno["protNFe"]["infProt"]['cStat'].'","type":"string"},
								{"name":"not_xmotivo","value":"'.base64_encode($retorno["protNFe"]["infProt"]['xMotivo']).'","type":"string"},
								{"name":"not_aliq","value":"'.$itn_aliqicms.'","type":"string"},
								{"name":"not_codigo","value":"'.$_REQUEST["not_codigo"].'","type":"string"},
								{"name":"not_tpemis","value":"'.$tpEmis.'","type":"string"},';

							if($retorno["protNFe"]["infProt"]["nProt"]){
								$filtroAtualiza .= '{"name":"not_nprot","value":"'.$retorno["protNFe"]["infProt"]["nProt"].'","type":"string"}';
							}else{
								$filtroAtualiza .= '{"name":"not_nprot","value":"NULL","type":"other"}';
							}
							$filtroAtualiza.=']}';
							$Datapacket->add($filtroAtualiza);
							$Datapacket->open(true);
							$Datapacket->clear();
										
							if ($retorno['bStat']){
								//Pegar Protocolo
								if($prot = $tools->getProtocol("", $chave, $tpAmb)){
									$nfefile 	= $nomeArquivo;
									$protfile 	= $nfeDir.$chave.'-prot.xml';

									//Criar arquivo protocolo
									$arquivoProt = fopen($protfile,'w+');
									fwrite($arquivoProt, $prot);
									fclose($arquivoProt);
									chmod($protfile, 0777);
									
									//Adicionar Protocolo ao XML da NF-e
									if ($xml = $tools->addProt($nfefile, $protfile)){
										file_put_contents($nfefile, $xml);
										unlink($protfile);
										$protfile2 = substr($nfeDir,0,-7).$chave.'-prot.xml';
										unlink($protfile2);
									}
								}
								
								$docxmll = file_get_contents($nfefile);
								$dhRecbto = implode("-", array_reverse(explode("/", substr($retorno["protNFe"]["infProt"]["dhRecbto"], 0, 10))));
								$dhRecbto.= substr($retorno["protNFe"]["infProt"]["dhRecbto"], 10, 9);
								
								if($retorno["protNFe"]["infProt"]['cStat']=="100"){
									
									if(!is_dir($TParams->uploads.$_REQUEST["emp_codigo"].'/nfe/'.$Nota->{"ambNfe"}.'/autorizadas')){
										@mkdir($TParams->uploads.$_REQUEST["emp_codigo"].'/nfe/'.$Nota->{"ambNfe"}.'/autorizadas',0777,true);
									}
									$dir = $TParams->uploads.$_REQUEST["emp_codigo"].'/nfe/'.$Nota->{"ambNfe"}.'/autorizadas/'.$Nota->anoMes.'/';
									if(!is_dir($dir)){
										@mkdir($dir,0777,true);
									}
									copy($nomeArquivo, $dir.$chave.'-nfe.xml');
									chmod($dir.$chave.'-nfe.xml', 0777);
									unlink($nomeArquivo);
									
									$ant="";
									//Atualização do estoque do(s) produto(s) (caso ainda não esteja atualizado)
									if( !$nota[0]->{'not_stokatualiz'} || $nota[0]->{'not_stokatualiz'}==0 ){
										foreach($nota as $not){
											if( $not->{"itn_ordem"}!=$ant ){
												
												//conversao de unidades quando necessario
												$datapacket2 = new Datapacket();
												$filtro = '{"cod":"700565","params":[
													{"name":"db","value":"'.$TParams->getDb().'","type":"other"},
													{"name":"uni_codigo","value":"'.$not->{'uni_codigo'}.'","type":"string"},
													{"name":"ref_codigo","value":"'.$not->{'ref_codigo'}.'","type":"integer"}
												]}';
												$datapacket2->add($filtro);
												$conv = $datapacket2->open();
												$datapacket2->clear();
				
												$stk_seq = substr(str_replace(array(","," ","."),array("","",""),microtime()), 0, 8);
												$loc_codigo = ($not->{'loc_codigo'}) ? $not->{'loc_codigo'} : "1";
												$lot_codigo = ($not->{'lot_codigo'}) ? $not->{'lot_codigo'} : "99999";
												$stk_qde = $not->{'itn_qtde'};
												
												if( isset($conv) && isset($conv[0]) && isset($conv[0]["ref_conv_qtde"]) ) $stk_qde = number_format($stk_qde/ $conv[0]["ref_conv_qtde"],2,'.',''); //conversao
												$stk_qde = ($stk_qde>0) ? $stk_qde : $not->{'itn_qtde'};
												
												$stk_qde = ($nota[0]->{'not_entrsaida'}==2) ? '-'.$stk_qde : $stk_qde;
												
												$filtrostk = '{"cod":"700111","params":[
													{"name":"db","value":"'.$company->{"emp_db_comum"}.'","type":"other"},
													{"name":"emp_codigo","value":"'.$company->{"emp_codigo"}.'","type":"string"},
													{"name":"loc_codigo","value":"'.$loc_codigo.'","type":"string"},
													{"name":"lot_codigo","value":"'.$lot_codigo.'","type":"string"},
													{"name":"ref_codigo","value":"'.$not->{'ref_codigo'}.'","type":"integer"},
													{"name":"ser_codigo","value":"'.$nota[0]->{"ser_codigo"}.'","type":"string"},
													{"name":"stk_data","value":"'.$dhRecbto.'","type":"string"},
													{"name":"stk_seq","value":"'.$stk_seq.'","type":"integer"},
													{"name":"stk_qde","value":"'.$stk_qde.'","type":"float"},
													{"name":"stk_tipo","value":"'.$nota[0]->{'not_entrsaida'}.'","type":"integer"},
													{"name":"not_codigo","value":"'.$_REQUEST['not_codigo'].'","type":"string"}
												]}';
												$Datapacket->add($filtrostk);
												$ant = $not->{"itn_ordem"};
												
											}
										}
									}
									
									//Atualizar os dados de retorno da NF-e no banco de dados (autorizada)
									$filtroAtualiza = '{"cod":"700105","params":[
										{"name":"not_status","value":"2","type":"integer"},
										{"name":"not_dtfaturam","value":"'.$dhRecbto.'","type":"string"},
										{"name":"not_dtprevisao","value":"'.$dhRecbto.'","type":"string"},
										{"name":"not_dtentrega","value":"'.$dhRecbto.'","type":"string"},
										{"name":"not_finanatualiz","value":"1","type":"integer"},
										{"name":"not_stokatualiz","value":"1","type":"integer"},
										{"name":"not_custoautaliz","value":"1","type":"integer"},
										{"name":"not_key_nfe","value":"'.$retorno["protNFe"]["infProt"]["chNFe"].'","type":"string"},
										{"name":"not_result","value":"'.base64_encode(json_encode($retorno)).'","type":"string"},
										{"name":"not_cstat","value":"'.$retorno["protNFe"]["infProt"]['cStat'].'","type":"string"},
										{"name":"not_xmotivo","value":"'.base64_encode($retorno["protNFe"]["infProt"]['xMotivo']).'","type":"string"},
										{"name":"not_aliq","value":"'.$itn_aliqicms.'","type":"string"},
										{"name":"not_codigo","value":"'.$_REQUEST["not_codigo"].'","type":"string"},
										{"name":"not_tpemis","value":"'.$tpEmis.'","type":"string"},';

									if($retorno["protNFe"]["infProt"]["nProt"]){
										$filtroAtualiza .= '{"name":"not_nprot","value":"'.$retorno["protNFe"]["infProt"]["nProt"].'","type":"string"}';
									}else{
										$filtroAtualiza .= '{"name":"not_nprot","value":"","type":"null"}';
									}

									$filtroAtualiza.=']}';
									
									$Datapacket->add($filtroAtualiza);
									
									//Atualização do Log da NF-e com os dados transmitidos
									$log_tipo = ( isset($_REQUEST["mod"]) && $_REQUEST["mod"]=='65' ) ? 9 : 2;
									$filtrolog = '{"cod":"700103","params":[
										{"name":"log_tipo","value":"'.$log_tipo.'","type":"integer"},
										{"name":"log_nro","value":"'.$nota[0]->{"not_codigo"}.'","type":"string"},
										{"name":"log_serie","value":"'.$nota[0]->{"ser_codigo"}.'","type":"string"},';
									$filtrolog.= ( isset($_REQUEST["usu_login"]) && $_REQUEST["usu_login"]!="" ) ? '{"name":"log_usu_login","value":"'.$_REQUEST["usu_login"].'","type":"string"},' : '{"name":"log_usu_login","value":"NULL","type":"other"},';
									$filtrolog.= '{"name":"log_acao_cod","value":"3","type":"integer"},
										{"name":"log_acao_descr","value":"transmissão","type":"string"},
										{"name":"log_data","value":"'.$dhRecbto.'","type":"string"},
										{"name":"log_protocolo","value":"'.$retorno["protNFe"]["infProt"]["nProt"].'","type":"string"},
										{"name":"log_ret","value":"'.base64_encode(json_encode($retorno)).'","type":"string"},
										{"name":"log_outro","value":"'.base64_encode("NF-e transmitida com sucesso!").'","type":"string"}
									]}';
									$Datapacket->add($filtrolog);
									
									$Datapacket->open(true);
									
									$Datapacket->clear();
									
									//e-commerce - informar dados da NF-e para marketplaces
									if( isset($nota[0]->{'not_codigo_pai'}) && $nota[0]->{'not_codigo_pai'}!=""){
										$filtroecm = '{"cod":"700003","params":[
											{"name":"not_codigo","value":"'.$nota[0]->{'not_codigo_pai'}.'","type":"string"}
										]}';
										$Datapacket->add($filtroecm);
										$ecm = $Datapacket->open(true);
										$Datapacket->clear();
										if(isset($ecm[0]) && isset($ecm[0]->id) && isset($ecm[0]->ecm_id) && $ecm[0]->ecm_id!=""){
											$ch = curl_init();
											curl_setopt($ch,CURLOPT_URL, $TParams->HostClient."php/marketplace.php?p=".$_REQUEST["p"]."&tipo=pedido&acao=alterar&status=4&id=".$ecm[0]->id."&serie=".$nota[0]->{'ser_codigo'}."&num=".$nota[0]->{'not_numero'}."&chave=".$retorno["protNFe"]["infProt"]["chNFe"]);
											curl_setopt($ch,CURLOPT_HTTPHEADER, array('Content-Type:application/json', 'Content-Length: 1'));
											curl_setopt($ch,CURLOPT_POST, true);
											curl_setopt($ch,CURLOPT_RETURNTRANSFER, true);
											curl_exec($ch);
											curl_close($ch);
										}
										
									}
									
									//DANFE
									$logo = "http://".$_SERVER['SERVER_NAME']."/uploads/".$_REQUEST["emp_codigo"]."/".$company->{"emp_logo"};
									$dir = $TParams->uploads.$_REQUEST["emp_codigo"].'/nfe/'.$Nota->{"ambNfe"}.'/autorizadas/'.$Nota->anoMes.'/';

									if(isset($_REQUEST['calcNcm'])){
										$calcNcm = $_REQUEST['calcNcm'];
									}else{
										$calcNcm = 0;
									}
									if( isset($_REQUEST["mod"]) && $_REQUEST["mod"]=="65" ){
										if(isset($company->{"emp_logo"}) && !empty($company->{"emp_logo"})){
											$danfe = new DanfeNFCeNFePHP($docxmll, $logo, 0, '000001', $company->{"emp_csc"}, $company->{'emp_codigo'}, $chave,$Nota->uploads);
										}else{
											$danfe = new DanfeNFCeNFePHP($docxmll, '', 0, '000001', $company->{"emp_csc"}, $company->{'emp_codigo'}, $chave,$Nota->uploads);
										}
										
										$id = $danfe->montaDANFE(false, $calcNcm);
										
										$danfe->printDANFE('html', $dir.$chave.'.html', 'F',$Nota->anoMes);
										
									}else{
										$danfe = new DanfeNFePHP($docxmll, 'C', 'A4', $logo, 'F', $dir,$company);
										$id = $danfe->montaDANFE();
										$danfe->printDANFE($dir.$chave.'.pdf', 'F',$Nota->anoMes);
									}
									
									echo "NF-e transmitida com sucesso! Chave: ".$retorno["protNFe"]["infProt"]["chNFe"];
								
								}else{
									
									$filtrolog = '{"cod":"700103","params":[
										{"name":"log_tipo","value":"2","type":"integer"},
										{"name":"log_nro","value":"'.$nota[0]->{"not_codigo"}.'","type":"string"},
										{"name":"log_serie","value":"'.$nota[0]->{"ser_codigo"}.'","type":"string"},';
									$filtrolog.= ( isset($_REQUEST["usu_login"]) && $_REQUEST["usu_login"]!="" ) ? '{"name":"log_usu_login","value":"'.$_REQUEST["usu_login"].'","type":"string"},' : '{"name":"log_usu_login","value":"NULL","type":"other"},';
									$filtrolog.= '{"name":"log_acao_cod","value":"3","type":"integer"},
										{"name":"log_acao_descr","value":"transmissão 2","type":"string"},
										{"name":"log_data","value":"","type":"string"},
										{"name":"log_protocolo","value":"'.$retorno["protNFe"]["infProt"]["nProt"].'","type":"string"},
										{"name":"log_ret","value":"'.base64_encode(json_encode($retorno)).'","type":"string"},
										{"name":"log_outro","value":"'.base64_encode($retorno["protNFe"]["infProt"]['xMotivo']).'","type":"string"}
									]}';
									$Datapacket->add($filtrolog);
									$Datapacket->open();
									$Datapacket->clear();

									if($retorno["protNFe"]["infProt"]['cStat'] == '110' || $retorno["protNFe"]["infProt"]['cStat'] == '205' || $retorno["protNFe"]["infProt"]['cStat'] == '301'){
										if(!is_dir($TParams->uploads.$_REQUEST["emp_codigo"].'/nfe/'.$Nota->{"ambNfe"}.'/denegadas')){
											@mkdir($TParams->uploads.$_REQUEST["emp_codigo"].'/nfe/'.$Nota->{"ambNfe"}.'/denegadas',0777,true);
										}
										$dir = $TParams->uploads.$_REQUEST["emp_codigo"].'/nfe/'.$Nota->{"ambNfe"}.'/denegadas/'.$Nota->anoMes.'/';
										if(!is_dir($dir)){
											@mkdir($dir,0777,true);
										}
										copy($nomeArquivo, $dir.$chave.'-nfe.xml');
										chmod($dir.$chave.'-nfe.xml', 0777);
										unlink($nomeArquivo);
										
										//Atualizar os dados de retorno da NF-e no banco de dados (denegada)
										$filtroAtualiza = '{"cod":"700105","params":[
											{"name":"not_status","value":"6","type":"integer"},
											{"name":"not_dtfaturam","value":"'.$dhRecbto.'","type":"string"},
											{"name":"not_dtprevisao","value":"'.$dhRecbto.'","type":"string"},
											{"name":"not_dtentrega","value":"'.$dhRecbto.'","type":"string"},
											{"name":"not_finanatualiz","value":"1","type":"integer"},
											{"name":"not_stokatualiz","value":"1","type":"integer"},
											{"name":"not_custoautaliz","value":"1","type":"integer"},
											{"name":"not_key_nfe","value":"'.$retorno["protNFe"]["infProt"]["chNFe"].'","type":"string"},
											{"name":"not_result","value":"'.base64_encode(json_encode($retorno)).'","type":"string"},
											{"name":"not_cstat","value":"'.$retorno["protNFe"]["infProt"]['cStat'].'","type":"string"},
											{"name":"not_xmotivo","value":"'.base64_encode($retorno["protNFe"]["infProt"]['xMotivo']).'","type":"string"},
											{"name":"not_aliq","value":"'.$itn_aliqicms.'","type":"string"},
											{"name":"not_codigo","value":"'.$nota[0]->{"not_codigo"}.'","type":"string"},
											{"name":"not_tpemis","value":"'.$tpEmis.'","type":"string"},
											{"name":"not_nprot","value":"'.$retorno["protNFe"]["infProt"]["nProt"].'","type":"string"}
										]}';
										
										$Datapacket->add($filtroAtualiza);
										$Datapacket->open();
											
									}else if($retorno["protNFe"]["infProt"]['cStat'] == '101' || $retorno["protNFe"]["infProt"]['cStat'] == '135'){
										if(!is_dir($TParams->uploads.$_REQUEST["emp_codigo"].'/nfe/'.$Nota->{"ambNfe"}.'/canceladas')){
											@mkdir($TParams->uploads.$_REQUEST["emp_codigo"].'/nfe/'.$Nota->{"ambNfe"}.'/canceladas',0777,true);
										}
										$dir = $TParams->uploads.$_REQUEST["emp_codigo"].'/nfe/'.$Nota->{"ambNfe"}.'/canceladas/'.$Nota->anoMes.'/';
										if(!is_dir($dir)){
											@mkdir($dir,0777,true);
										}
										copy($nomeArquivo, $dir.$chave.'-nfe.xml');
										chmod($dir.$chave.'-nfe.xml', 0777);
										unlink($nomeArquivo);
									//SP Assincrono
									}elseif ( isset($retorno['infRec']['nRec']) ){
										
										$prot = $tools->getProtocol($retorno['infRec']['nRec'], "", $tpAmb, $retorno);
										
										$dhRecbto = implode("-", array_reverse(explode("/", substr($retorno["aProt"][0]["dhRecbto"], 0, 10))));
										$dhRecbto.= substr($retorno["aProt"][0]["dhRecbto"], 10, 9);
										
										sleep(6);

										if( $retorno["aProt"][0]["cStat"]=="100" ){
											
											$protfile 	= $nfeDir.$chave.'-prot.xml';
											//Criar arquivo protocolo
											$arquivoProt = fopen($protfile,'w+');
											fwrite($arquivoProt, $prot);
											fclose($arquivoProt);
											
											//Adicionar Protocolo ao XML da NF-e
											if ($xml = $tools->addProt($nomeArquivo, $protfile)){
												file_put_contents($nomeArquivo, $xml);
											}
											
											if(!is_dir($TParams->uploads.$_REQUEST["emp_codigo"].'/nfe/'.$Nota->{"ambNfe"}.'/autorizadas')){
												@mkdir($TParams->uploads.$_REQUEST["emp_codigo"].'/nfe/'.$Nota->{"ambNfe"}.'/autorizadas',0777,true);
											}
											$dir = $TParams->uploads.$_REQUEST["emp_codigo"].'/nfe/'.$Nota->{"ambNfe"}.'/autorizadas/'.$Nota->anoMes.'/';
											if(!is_dir($dir)){
												@mkdir($dir,0777,true);
											}
											
											copy($nomeArquivo, $dir.$chave.'-nfe.xml');
											chmod($dir.$chave.'-nfe.xml', 0777);
											copy($protfile, $dir.$chave.'-prot.xml');
											chmod($dir.$chave.'-prot.xml', 0777);
											unlink($nomeArquivo);
											unlink($protfile);
											
											$docxml = file_get_contents($dir.$chave.'-nfe.xml');
											
											$ant="";
											//Atualização do estoque do(s) produto(s) (caso ainda não esteja atualizado)
											if( !$nota[0]->{'not_stokatualiz'} || $nota[0]->{'not_stokatualiz'}==0 ){
												foreach($nota as $not){
													if( $not->{"itn_ordem"}!=$ant ){
														
														//conversao de unidades quando necessario
														$datapacket2 = new Datapacket();
														$filtro = '{"cod":"700565","params":[
															{"name":"db","value":"'.$TParams->getDb().'","type":"other"},
															{"name":"uni_codigo","value":"'.$not->{'uni_codigo'}.'","type":"string"},
															{"name":"ref_codigo","value":"'.$not->{'ref_codigo'}.'","type":"integer"}
														]}';
														$datapacket2->add($filtro);
														$conv = $datapacket2->open();
														$datapacket2->clear();
								
														$stk_seq = substr(str_replace(array(","," ","."),array("","",""),microtime()), 0, 8);
														$loc_codigo = ($not->{'loc_codigo'}) ? $not->{'loc_codigo'} : "1";
														$lot_codigo = ($not->{'lot_codigo'}) ? $not->{'lot_codigo'} : "99999";
														$stk_qde = $not->{'itn_qtde'};
														
														if( isset($conv) && isset($conv[0]) && isset($conv[0]["ref_conv_qtde"]) ) $stk_qde = number_format($stk_qde/ $conv[0]["ref_conv_qtde"],2,'.',''); //conversao
														$stk_qde = ($stk_qde>0) ? $stk_qde : $not->{'itn_qtde'};
														
														$stk_qde = ($nota[0]->{'not_entrsaida'}==2) ? '-'.$stk_qde : $stk_qde;
														$filtrostk = '{"cod":"700111","params":[
															{"name":"db","value":"'.$company->{"emp_db_comum"}.'","type":"other"},
															{"name":"emp_codigo","value":"'.$company->{"emp_codigo"}.'","type":"string"},
															{"name":"loc_codigo","value":"'.$loc_codigo.'","type":"string"},
															{"name":"lot_codigo","value":"'.$lot_codigo.'","type":"string"},
															{"name":"ref_codigo","value":"'.$not->{'ref_codigo'}.'","type":"integer"},
															{"name":"ser_codigo","value":"'.$nota[0]->{"ser_codigo"}.'","type":"string"},
															{"name":"stk_data","value":"'.$dhRecbto.'","type":"string"},
															{"name":"stk_seq","value":"'.$stk_seq.'","type":"integer"},
															{"name":"stk_qde","value":"'.$stk_qde.'","type":"float"},
															{"name":"stk_tipo","value":"'.$nota[0]->{'not_entrsaida'}.'","type":"integer"},
															{"name":"not_codigo","value":"'.$_REQUEST['not_codigo'].'","type":"string"}
														]}';
														$Datapacket->add($filtrostk);
														$ant = $not->{"itn_ordem"};
													}
												}
											}
											
											//Atualizar os dados de retorno da NF-e no banco de dados (autorizada)
											$filtroAtualiza = '{"cod":"700105","params":[
												{"name":"not_status","value":"2","type":"integer"},
												{"name":"not_dtfaturam","value":"'.$dhRecbto.'","type":"string"},
												{"name":"not_dtprevisao","value":"'.$dhRecbto.'","type":"string"},
												{"name":"not_dtentrega","value":"'.$dhRecbto.'","type":"string"},
												{"name":"not_finanatualiz","value":"1","type":"integer"},
												{"name":"not_stokatualiz","value":"1","type":"integer"},
												{"name":"not_custoautaliz","value":"1","type":"integer"},
												{"name":"not_key_nfe","value":"'.$retorno["aProt"][0]["chNFe"].'","type":"string"},
												{"name":"not_result","value":"'.base64_encode(json_encode($retorno)).'","type":"string"},
												{"name":"not_cstat","value":"'.$retorno["aProt"][0]['cStat'].'","type":"string"},
												{"name":"not_xmotivo","value":"'.base64_encode($retorno["aProt"][0]['xMotivo']).'","type":"string"},
												{"name":"not_aliq","value":"'.$itn_aliqicms.'","type":"string"},
												{"name":"not_codigo","value":"'.$_REQUEST["not_codigo"].'","type":"string"},
												{"name":"not_tpemis","value":"'.$tpEmis.'","type":"string"},';

											if($retorno["aProt"][0]["nProt"]){
												$filtroAtualiza .= '{"name":"not_nprot","value":"'.$retorno["aProt"][0]["nProt"].'","type":"string"}';
											}else{
												$filtroAtualiza .= '{"name":"not_nprot","value":"NULL","type":"other"}';
											}

											$filtroAtualiza.=']}';
											
											$Datapacket->add($filtroAtualiza);
											
											//Atualização do Log da NF-e com os dados transmitidos
											$filtrolog = '{"cod":"700103","params":[
												{"name":"log_tipo","value":"2","type":"integer"},
												{"name":"log_nro","value":"'.$nota[0]->{"not_codigo"}.'","type":"string"},
												{"name":"log_serie","value":"'.$nota[0]->{"ser_codigo"}.'","type":"string"},';
											$filtrolog.= ( isset($_REQUEST["usu_login"]) && $_REQUEST["usu_login"]!="" ) ? '{"name":"log_usu_login","value":"'.$_REQUEST["usu_login"].'","type":"string"},' : '{"name":"log_usu_login","value":"NULL","type":"other"},';
											$filtrolog.= '{"name":"log_acao_cod","value":"3","type":"integer"},
												{"name":"log_acao_descr","value":"transmissão","type":"string"},
												{"name":"log_data","value":"'.$dhRecbto.'","type":"string"},
												{"name":"log_protocolo","value":"'.$retorno["aProt"][0]["nProt"].'","type":"string"},
												{"name":"log_ret","value":"'.base64_encode(json_encode($retorno)).'","type":"string"},
												{"name":"log_outro","value":"'.base64_encode("NF-e transmitida com sucesso!").'","type":"string"}
											]}';
											$Datapacket->add($filtrolog);
											
											$Datapacket->open(true);
											
											//print_r($Datapacket->getLastQuery());
											
											//DANFE
											$logo = "http://".$_SERVER['SERVER_NAME']."/uploads/".$_REQUEST["emp_codigo"]."/".$company->{"emp_logo"};

											if(isset($_REQUEST['calcNcm'])){
												$calcNcm = $_REQUEST['calcNcm'];
											}else{
												$calcNcm = 0;
											}
											if( isset($_REQUEST["mod"]) && $_REQUEST["mod"]=="65" ){
												if(isset($company->{"emp_logo"}) && !empty($company->{"emp_logo"})){
													$danfe = new DanfeNFCeNFePHP($docxmll, $logo, 0, '000001', $company->{"emp_csc"}, $company->{'emp_codigo'}, $chave,$Nota->uploads);
												}else{
													$danfe = new DanfeNFCeNFePHP($docxmll, '', 0, '000001', $company->{"emp_csc"}, $company->{'emp_codigo'}, $chave,$Nota->uploads);
												}
												$id = $danfe->montaDANFE(false, $calcNcm);
												$danfe->printDANFE('html', $dir.$chave.'.html', 'F',$Nota->anoMes);
											}else{
												$danfe = new DanfeNFePHP($docxml, 'C', 'A4', $logo, 'F', $dir,$company);
												$id = $danfe->montaDANFE();
												$danfe->printDANFE($dir.$chave.'.pdf', 'F',$Nota->anoMes);
											}
											
											echo "NF-e transmitida com sucesso! Chave: ".$retorno["aProt"][0]["chNFe"];
											
										}else if( isset($retorno['cStat']) && $retorno['cStat']==105 ){
											
											if(!is_dir($TParams->uploads.$_REQUEST["emp_codigo"].'/nfe/'.$Nota->{"ambNfe"}.'/aguardando')){
												@mkdir($TParams->uploads.$_REQUEST["emp_codigo"].'/nfe/'.$Nota->{"ambNfe"}.'/aguardando',0777,true);
											}
											$dir = $TParams->uploads.$_REQUEST["emp_codigo"].'/nfe/'.$Nota->{"ambNfe"}.'/aguardando/'.$Nota->anoMes.'/';
											if(!is_dir($dir)){
												@mkdir($dir,0777,true);
											}
											copy($nomeArquivo, $dir.$chave.'-nfe.xml');
											chmod($dir.$chave.'-nfe.xml', 0777);
											unlink($nomeArquivo);
											
											$filtroAguardar = '{"cod":"700799","params":[
												{"name":"not_codigo","value":"'.$_REQUEST["not_codigo"].'","type":"string"}
											]}';
											$Datapacket->clear();
											$Datapacket->add($filtroAguardar);
											$Datapacket->open();
											$Datapacket->clear();
											
											echo "NF-e aguardando retorno da SEFAZ!";
											
										}else if( isset($retorno['aProt'][0]['cStat']) || isset($retorno['aProt'][0]['xMotivo']) ){
											echo "Erro: ".$retorno['aProt'][0]['cStat']." - ".$retorno['aProt'][0]['xMotivo'];
										}else{
											echo "Erro: ";
											print_r($retorno);
										}
										
											
											
									}else if( isset($retorno["aProt"][0]['cStat']) || isset($retorno["aProt"][0]['xMotivo']) ){
										echo "Erro: ".$retorno["aProt"][0]['cStat']." - ".$retorno["aProt"][0]['xMotivo'];
									}else{
										
										//arquivo de protocolo
										$arq = substr($nfeDir,0,-7).$chave.'-prot.xml';
										if( is_file($arq) && file_exists($arq) ){
											
											$filtroAtualiza = '{"cod":"700552","params":[
												{"name":"not_status","value":"0","type":"integer"},
												{"name":"not_cstat","value":"991","type":"other"},
												{"name":"not_codigo","value":"'.$_REQUEST["not_codigo"].'","type":"string"}
											]}';
											$Datapacket->add($filtroAtualiza);
											$Datapacket->open(true);
											$Datapacket->clear();
											
											$prot = file_get_contents($arq);
											$prot2 = file_get_contents($arq);
											$prot = str_replace(":","",$prot);
											$prot = simplexml_load_string($prot);
											if($prot->soapBody->nfeAutorizacaoLoteResult->retEnviNFe->protNFe->infProt->xMotivo){
												exit("Erro: ".$prot->soapBody->nfeAutorizacaoLoteResult->retEnviNFe->protNFe->infProt->xMotivo);
											}elseif($prot->soapBody->nfeAutorizacaoLoteResult->retEnviNFe->xMotivo){
												exit("Erro: ".$prot->soapBody->nfeAutorizacaoLoteResult->retEnviNFe->xMotivo);
											}elseif($prot->soapBody->nfeResultMsg->retEnviNFe->protNFe->infProt->cStat && $prot->soapBody->nfeResultMsg->retEnviNFe->protNFe->infProt->cStat!="100"){
												exit("Erro: ".$prot->soapBody->nfeResultMsg->retEnviNFe->protNFe->infProt->cStat." - ".$prot->soapBody->nfeResultMsg->retEnviNFe->protNFe->infProt->xMotivo);
											}elseif($prot->soapBody->nfeResultMsg->retConsSitNFe->protNFe->infProt->nProt){

												$dhRecbto = str_replace("T", " ", substr($prot->soapBody->nfeResultMsg->retConsSitNFe->protNFe->infProt->dhRecbto,0,17));
												$dhRecbto = substr($dhRecbto,0,13).":".substr($dhRecbto,13,2).":".substr($dhRecbto,15,2);

												$protfile 	= $nfeDir.$chave.'-prot.xml';
												//Criar arquivo protocolo
												$arquivoProt = fopen($protfile,'w+');
												fwrite($arquivoProt, $prot2);
												fclose($arquivoProt);
												
												//Adicionar Protocolo ao XML da NF-e
												if ($xml = $tools->addProt($nomeArquivo, $protfile)){
													file_put_contents($nomeArquivo, $xml);
												}
												
												if(!is_dir($TParams->uploads.$_REQUEST["emp_codigo"].'/nfe/'.$Nota->{"ambNfe"}.'/autorizadas')){
													@mkdir($TParams->uploads.$_REQUEST["emp_codigo"].'/nfe/'.$Nota->{"ambNfe"}.'/autorizadas',0777,true);
												}
												$dir = $TParams->uploads.$_REQUEST["emp_codigo"].'/nfe/'.$Nota->{"ambNfe"}.'/autorizadas/'.$Nota->anoMes.'/';
												if(!is_dir($dir)){
													@mkdir($dir,0777,true);
												}
												
												copy($nomeArquivo, $dir.$chave.'-nfe.xml');
												chmod($dir.$chave.'-nfe.xml', 0777);
												copy($protfile, $dir.$chave.'-prot.xml');
												chmod($dir.$chave.'-prot.xml', 0777);
												unlink($nomeArquivo);
												unlink($protfile);
												
												$ant="";
												//Atualização do estoque do(s) produto(s) (caso ainda não esteja atualizado)
												if( !$nota[0]->{'not_stokatualiz'} || $nota[0]->{'not_stokatualiz'}==0 ){
													foreach($nota as $not){
														if( $not->{"itn_ordem"}!=$ant ){
															
															//conversao de unidades quando necessario
															$datapacket2 = new Datapacket();
															$filtro = '{"cod":"700565","params":[
																{"name":"db","value":"'.$TParams->getDb().'","type":"other"},
																{"name":"uni_codigo","value":"'.$not->{'uni_codigo'}.'","type":"string"},
																{"name":"ref_codigo","value":"'.$not->{'ref_codigo'}.'","type":"integer"}
															]}';
															$datapacket2->add($filtro);
															$conv = $datapacket2->open();
															$datapacket2->clear();
									
															$stk_seq = substr(str_replace(array(","," ","."),array("","",""),microtime()), 0, 8);
															$loc_codigo = ($not->{'loc_codigo'}) ? $not->{'loc_codigo'} : "1";
															$lot_codigo = ($not->{'lot_codigo'}) ? $not->{'lot_codigo'} : "99999";
															$stk_qde = $not->{'itn_qtde'};
															
															if( isset($conv) && isset($conv[0]) && isset($conv[0]["ref_conv_qtde"]) ) $stk_qde = number_format($stk_qde/ $conv[0]["ref_conv_qtde"],2,'.',''); //conversao
															$stk_qde = ($stk_qde>0) ? $stk_qde : $not->{'itn_qtde'};
															
															$stk_qde = ($nota[0]->{'not_entrsaida'}==2) ? '-'.$stk_qde : $stk_qde;
															$filtrostk = '{"cod":"700111","params":[
																{"name":"db","value":"'.$company->{"emp_db_comum"}.'","type":"other"},
																{"name":"emp_codigo","value":"'.$company->{"emp_codigo"}.'","type":"string"},
																{"name":"loc_codigo","value":"'.$loc_codigo.'","type":"string"},
																{"name":"lot_codigo","value":"'.$lot_codigo.'","type":"string"},
																{"name":"ref_codigo","value":"'.$not->{'ref_codigo'}.'","type":"integer"},
																{"name":"ser_codigo","value":"'.$nota[0]->{"ser_codigo"}.'","type":"string"},
																{"name":"stk_data","value":"'.$dhRecbto.'","type":"string"},
																{"name":"stk_seq","value":"'.$stk_seq.'","type":"integer"},
																{"name":"stk_qde","value":"'.$stk_qde.'","type":"float"},
																{"name":"stk_tipo","value":"'.$nota[0]->{'not_entrsaida'}.'","type":"integer"},
																{"name":"not_codigo","value":"'.$_REQUEST['not_codigo'].'","type":"string"}
															]}';
															$Datapacket->add($filtrostk);
															$ant = $not->{"itn_ordem"};
														}
													}
												}
												
												//Atualizar os dados de retorno da NF-e no banco de dados (autorizada)
												$filtroAtualiza = '{"cod":"700105","params":[
													{"name":"not_status","value":"2","type":"integer"},
													{"name":"not_dtfaturam","value":"'.$dhRecbto.'","type":"string"},
													{"name":"not_dtprevisao","value":"'.$dhRecbto.'","type":"string"},
													{"name":"not_dtentrega","value":"'.$dhRecbto.'","type":"string"},
													{"name":"not_finanatualiz","value":"1","type":"integer"},
													{"name":"not_stokatualiz","value":"1","type":"integer"},
													{"name":"not_custoautaliz","value":"1","type":"integer"},
													{"name":"not_key_nfe","value":"'.$prot->soapBody->nfeResultMsg->retConsSitNFe->protNFe->infProt->chNFe.'","type":"string"},
													{"name":"not_result","value":"'.base64_encode(json_encode($prot->soapBody->nfeResultMsg->retConsSitNFe->protNFe->infProt)).'","type":"string"},
													{"name":"not_cstat","value":"'.$prot->soapBody->nfeResultMsg->retConsSitNFe->protNFe->infProt->cStat.'","type":"string"},
													{"name":"not_xmotivo","value":"'.base64_encode($prot->soapBody->nfeResultMsg->retConsSitNFe->protNFe->infProt->xMotivo).'","type":"string"},
													{"name":"not_aliq","value":"'.$itn_aliqicms.'","type":"string"},
													{"name":"not_codigo","value":"'.$_REQUEST["not_codigo"].'","type":"string"},
													{"name":"not_tpemis","value":"'.$tpEmis.'","type":"string"},';

												if($prot->soapBody->nfeResultMsg->retConsSitNFe->protNFe->infProt->nProt){
													$filtroAtualiza .= '{"name":"not_nprot","value":"'.$prot->soapBody->nfeResultMsg->retConsSitNFe->protNFe->infProt->nProt.'","type":"string"}';
												}else{
													$filtroAtualiza .= '{"name":"not_nprot","value":"NULL","type":"other"}';
												}

												$filtroAtualiza.=']}';
												
												$Datapacket->add($filtroAtualiza);
												
												//Atualização do Log da NF-e com os dados transmitidos
												$filtrolog = '{"cod":"700103","params":[
													{"name":"log_tipo","value":"2","type":"integer"},
													{"name":"log_nro","value":"'.$nota[0]->{"not_codigo"}.'","type":"string"},
													{"name":"log_serie","value":"'.$nota[0]->{"ser_codigo"}.'","type":"string"},';
												$filtrolog.= ( isset($_REQUEST["usu_login"]) && $_REQUEST["usu_login"]!="" ) ? '{"name":"log_usu_login","value":"'.$_REQUEST["usu_login"].'","type":"string"},' : '{"name":"log_usu_login","value":"NULL","type":"other"},';
												$filtrolog.= '{"name":"log_acao_cod","value":"3","type":"integer"},
													{"name":"log_acao_descr","value":"transmissão","type":"string"},
													{"name":"log_data","value":"'.$dhRecbto.'","type":"string"},
													{"name":"log_protocolo","value":"'.$prot->soapBody->nfeResultMsg->retConsSitNFe->protNFe->infProt->nProt.'","type":"string"},
													{"name":"log_ret","value":"'.base64_encode(json_encode($prot->soapBody->nfeResultMsg->retConsSitNFe->protNFe->infProt)).'","type":"string"},
													{"name":"log_outro","value":"'.base64_encode("NF-e transmitida com sucesso!").'","type":"string"}
												]}';
												$Datapacket->add($filtrolog);
												
												$Datapacket->open(true);
												
												//print_r($Datapacket->getLastQuery());
												
												//DANFE
												$logo = "http://".$_SERVER['SERVER_NAME']."/uploads/".$_REQUEST["emp_codigo"]."/".$company->{"emp_logo"};

												if(isset($_REQUEST['calcNcm'])){
													$calcNcm = $_REQUEST['calcNcm'];
												}else{
													$calcNcm = 0;
												}
												if( isset($_REQUEST["mod"]) && $_REQUEST["mod"]=="65" ){
													if(isset($company->{"emp_logo"}) && !empty($company->{"emp_logo"})){
														$danfe = new DanfeNFCeNFePHP($docxmll, $logo, 0, '000001', $company->{"emp_csc"}, $company->{'emp_codigo'}, $chave,$Nota->uploads);
													}else{
														$danfe = new DanfeNFCeNFePHP($docxmll, '', 0, '000001', $company->{"emp_csc"}, $company->{'emp_codigo'}, $chave,$Nota->uploads);
													}
													$id = $danfe->montaDANFE(false, $calcNcm);
													$danfe->printDANFE('html', $dir.$chave.'.html', 'F',$Nota->anoMes);
												}else{
													$danfe = new DanfeNFePHP($docxml, 'C', 'A4', $logo, 'F', $dir,$company);
													$id = $danfe->montaDANFE();
													$danfe->printDANFE($dir.$chave.'.pdf', 'F',$Nota->anoMes);
												}
												
												echo "NF-e transmitida com sucesso! Chave: ".$prot->soapBody->nfeResultMsg->retConsSitNFe->protNFe->infProt->chNFe;
											}else{
												echo "Erro: lote processado porem invalidado";
											}
											
										}
									
									}
									
								}
									
							} else {
							
								$filtrolog = '{"cod":"700103","params":[
									{"name":"log_tipo","value":"2","type":"integer"},
									{"name":"log_nro","value":"'.$nota[0]->{"not_codigo"}.'","type":"string"},
									{"name":"log_serie","value":"'.$nota[0]->{"ser_codigo"}.'","type":"string"},';
								$filtrolog.= ( isset($_REQUEST["usu_login"]) && $_REQUEST["usu_login"]!="" ) ? '{"name":"log_usu_login","value":"'.$_REQUEST["usu_login"].'","type":"string"},' : '{"name":"log_usu_login","value":"NULL","type":"other"},';
								$filtrolog.= '{"name":"log_acao_cod","value":"3","type":"integer"},
									{"name":"log_acao_descr","value":"transmissão 3","type":"string"},
									{"name":"log_data","value":"'.date("Y-m-d H:i:s").'","type":"string"},
									{"name":"log_protocolo","value":"NULL","type":"other"},
									{"name":"log_ret","value":"NULL","type":"other"},
									{"name":"log_outro","value":"'.base64_encode("Erro!: ".$tools->errMsg).'","type":"string"}
								]}';
								$Datapacket->add($filtrolog);
								$Datapacket->open();
								echo "Erro!: ".$tools->errMsg;
								
							}

						} else {

							//Atualização do log com dados de erro na tentativa de transmissão
							$filtrolog = '{"cod":"700103","params":[
								{"name":"log_tipo","value":"2","type":"integer"},
								{"name":"log_nro","value":"'.$nota[0]->{"not_codigo"}.'","type":"string"},
								{"name":"log_serie","value":"'.$nota[0]->{"ser_codigo"}.'","type":"string"},';
							$filtrolog.= ( isset($_REQUEST["usu_login"]) && $_REQUEST["usu_login"]!="" ) ? '{"name":"log_usu_login","value":"'.$_REQUEST["usu_login"].'","type":"string"},' : '{"name":"log_usu_login","value":"NULL","type":"other"},';
							$filtrolog.= '{"name":"log_acao_cod","value":"3","type":"integer"},
								{"name":"log_acao_descr","value":"transmissão 4","type":"string"},
								{"name":"log_data","value":"'.date("Y-m-d H:i:s").'","type":"string"},
								{"name":"log_protocolo","value":"NULL","type":"other"},
								{"name":"log_ret","value":"NULL","type":"other"},
								{"name":"log_outro","value":"'.base64_encode("Erro!: ".$tools->errMsg).'","type":"string"}
							]}';
							$Datapacket->add($filtrolog);
							// $Datapacket->open();
							
							echo "Erro!: ".$tools->errMsg;
							$cStat = substr($tools->errMsg,0,3);
							$not_finanatualiz=0;
							$not_stokatualiz=0;
							$not_custoautaliz=0;

							if($cStat == '100' || $cStat == '204'){
								if(!is_dir($TParams->uploads.$_REQUEST["emp_codigo"].'/nfe/'.$Nota->{"ambNfe"}.'/autorizadas')){
									@mkdir($TParams->uploads.$_REQUEST["emp_codigo"].'/nfe/'.$Nota->{"ambNfe"}.'/autorizadas',0777,true);
								}
								$dir = $TParams->uploads.$_REQUEST["emp_codigo"].'/nfe/'.$Nota->{"ambNfe"}.'/autorizadas/'.$Nota->anoMes.'/';
								if(!is_dir($dir)){
									@mkdir($dir,0777,true);
								}
								copy($nomeArquivo, $dir.$chave.'-nfe.xml');
								chmod($dir.$chave.'-nfe.xml', 0777);
								unlink($nomeArquivo);
								$not_status=2;
								$not_finanatualiz=1;
								$not_stokatualiz=1;
								$not_custoautaliz=1;
							}else if($cStat == '110' || $cStat == '205' || $cStat == '233' || $cStat == '234' || $cStat == '301'){
								if(!is_dir($TParams->uploads.$_REQUEST["emp_codigo"].'/nfe/'.$Nota->{"ambNfe"}.'/denegadas')){
									@mkdir($TParams->uploads.$_REQUEST["emp_codigo"].'/nfe/'.$Nota->{"ambNfe"}.'/denegadas',0777,true);
								}
								$dir = $TParams->uploads.$_REQUEST["emp_codigo"].'/nfe/'.$Nota->{"ambNfe"}.'/denegadas/'.$Nota->anoMes.'/';
								if(!is_dir($dir)){
									@mkdir($dir,0777,true);
								}
								copy($nomeArquivo, $dir.$chave.'-nfe.xml');
								chmod($dir.$chave.'-nfe.xml', 0777);
								unlink($nomeArquivo);
								$not_status=6;
							}else if($cStat == '101' || $cStat == '135'){
								if(!is_dir($TParams->uploads.$_REQUEST["emp_codigo"].'/nfe/'.$Nota->{"ambNfe"}.'/canceladas')){
									@mkdir($TParams->uploads.$_REQUEST["emp_codigo"].'/nfe/'.$Nota->{"ambNfe"}.'/canceladas',0777,true);
								}
								$dir = $TParams->uploads.$_REQUEST["emp_codigo"].'/nfe/'.$Nota->{"ambNfe"}.'/canceladas/'.$Nota->anoMes.'/';
								if(!is_dir($dir)){
									@mkdir($dir,0777,true);
								}
								copy($nomeArquivo, $dir.$chave.'-nfe.xml');
								chmod($dir.$chave.'-nfe.xml', 0777);
								unlink($nomeArquivo);
								$not_status=3;
							}else{
								if ($retorno["protNFe"]["infProt"]["nProt"]){
									$not_status=1;
									if(!is_dir($TParams->uploads.$_REQUEST["emp_codigo"].'/nfe/'.$Nota->{"ambNfe"}.'/aguardando')){
										@mkdir($TParams->uploads.$_REQUEST["emp_codigo"].'/nfe/'.$Nota->{"ambNfe"}.'/aguardando',0777,true);
									}
									$dir = $TParams->uploads.$_REQUEST["emp_codigo"].'/nfe/'.$Nota->{"ambNfe"}.'/aguardando/'.$Nota->anoMes.'/';
									if(!is_dir($dir)){
										@mkdir($dir,0777,true);
									}
									copy($nomeArquivo, $dir.$chave.'-nfe.xml');
									chmod($dir.$chave.'-nfe.xml', 0777);
									unlink($nomeArquivo);
								}else{
									$not_status=0;
									$cStat='';
								}
							}
							
							$filtroAtualiza = '{"cod":"700105","params":[
								{"name":"not_status","value":"'.$not_status.'","type":"integer"},
								{"name":"not_dtfaturam","value":"NULL","type":"other"},
								{"name":"not_dtprevisao","value":"NULL","type":"other"},
								{"name":"not_dtentrega","value":"NULL","type":"other"},
								{"name":"not_finanatualiz","value":"'.$not_finanatualiz.'","type":"integer"},
								{"name":"not_stokatualiz","value":"'.$not_stokatualiz.'","type":"integer"},
								{"name":"not_custoautaliz","value":"'.$not_custoautaliz.'","type":"integer"},
								{"name":"not_key_nfe","value":"'.$chave.'","type":"string"},
								{"name":"not_result","value":"'.base64_encode(json_encode($retorno)).'","type":"string"},
								{"name":"not_cstat","value":"'.$cStat.'","type":"string"},
								{"name":"not_xmotivo","value":"'.base64_encode($retorno["protNFe"]["infProt"]['xMotivo']).'","type":"string"},
								{"name":"not_aliq","value":"0","type":"string"},
								{"name":"not_codigo","value":"'.$_REQUEST["not_codigo"].'","type":"string"},
								{"name":"not_tpemis","value":"'.$tpEmis.'","type":"string"},';
							if($retorno["protNFe"]["infProt"]["nProt"]){
								$filtroAtualiza .= '{"name":"not_nprot","value":"'.$retorno["protNFe"]["infProt"]["nProt"].'","type":"string"}';
							}else{
								$filtroAtualiza .= '{"name":"not_nprot","value":"NULL","type":"other"}';
							}
							$filtroAtualiza.=']}';
							$Datapacket->add($filtroAtualiza);
							$Datapacket->open();

						}
					
					} else {
				
						//Atualização do log com erro de assinatura de XML
						$filtrolog = '{"cod":"700103","params":[
							{"name":"log_tipo","value":"2","type":"integer"},
							{"name":"log_nro","value":"'.$nota[0]->{"not_codigo"}.'","type":"string"},
							{"name":"log_serie","value":"'.$nota[0]->{"ser_codigo"}.'","type":"string"},';
						$filtrolog.= ( isset($_REQUEST["usu_login"]) && $_REQUEST["usu_login"]!="" ) ? '{"name":"log_usu_login","value":"'.$_REQUEST["usu_login"].'","type":"string"},' : '{"name":"log_usu_login","value":"NULL","type":"other"},';
						$filtrolog.= '{"name":"log_acao_cod","value":"3","type":"integer"},
							{"name":"log_acao_descr","value":"transmissão 5","type":"string"},
							{"name":"log_data","value":"'.date("Y-m-d H:i:s").'","type":"string"},
							{"name":"log_protocolo","value":"NULL","type":"other"},
							{"name":"log_ret","value":"NULL","type":"other"},
							{"name":"log_outro","value":"'.base64_encode("Erro na Assinatura XML: ".$tools->errMsg).'","type":"string"}
						]}';
						$Datapacket->add($filtrolog);
						$Datapacket->open();
					
						echo "Erro na Assinatura XML: ".$tools->errMsg;
						
					}
					
				}
				
			//acao = imprimir DANFE
			}elseif($_REQUEST["acao"]=="imprimir"){
				
				//Atualização do log (impressao)
				$filtrolog = '{"cod":"700103","params":[
					{"name":"log_tipo","value":"2","type":"integer"},
					{"name":"log_nro","value":"'.$nota[0]->{"not_codigo"}.'","type":"string"},
					{"name":"log_serie","value":"'.$nota[0]->{"ser_codigo"}.'","type":"string"},';
				$filtrolog.= ( isset($_REQUEST["usu_login"]) && $_REQUEST["usu_login"]!="" ) ? '{"name":"log_usu_login","value":"'.$_REQUEST["usu_login"].'","type":"string"},' : '{"name":"log_usu_login","value":"NULL","type":"other"},';
				$filtrolog.= '{"name":"log_acao_cod","value":"4","type":"integer"},
					{"name":"log_acao_descr","value":"impressão","type":"string"},
					{"name":"log_data","value":"'.date("Y-m-d H:i:s").'","type":"string"},
					{"name":"log_protocolo","value":"NULL","type":"other"},
					{"name":"log_ret","value":"NULL","type":"other"},
					{"name":"log_outro","value":"'.base64_encode("Impressão do DANFE").'","type":"string"}
				]}';
				$Datapacket->add($filtrolog);
				$Datapacket->open();
				
				$logo = $TParams->uploads.$_REQUEST["emp_codigo"]."/".$company->{"emp_logo"};
				// $logo = substr($logo, 0, -3)."jpg"; //tem quer ser jpg!!!!
				$dir = $nfeDir;
				if(isset($_REQUEST['calcNcm'])){
					$calcNcm = $_REQUEST['calcNcm'];
				}else{
					$calcNcm = 0;
				}
				
				if( isset($_REQUEST["mod"]) && $_REQUEST["mod"]=="65" ){
					if(isset($company->{"emp_logo"}) && !empty($company->{"emp_logo"})){
						$logo = $TParams->uploads2.$_REQUEST["emp_codigo"]."/".$company->{"emp_logo"};
						$danfe = new DanfeNFCeNFePHP($docxml, $logo, 0, '000001', $company->{"emp_csc"}, $company->{'emp_codigo'}, $chave,$Nota->uploads);
					}else{
						$danfe = new DanfeNFCeNFePHP($docxml, '', 0, '000001', $company->{"emp_csc"}, $company->{'emp_codigo'}, $chave,$Nota->uploads);
					}
					$id = $danfe->montaDANFE(false, $calcNcm);
					if( is_file($dir.$chave.'.html') && file_exists($dir.$chave.'.html') ){
						unlink($dir.$chave.'.html');
					}
					$danfe->printDANFE('html', $dir.$chave.'.html', 'F',$Nota->anoMes);
				}else{
					if($situacao=="canceladas"){
						$docxml = file_get_contents(substr($nomeArquivo, 0, -7)."nfe2.xml");
					}
					$danfe = new DanfeNFePHP($docxml, 'C', 'A4', $logo, 'F', $dir,$company);
					if($situacao=="canceladas"){
						$id = $danfe->montaDANFE('', 'A4', 'C', 1);
					}else{
						$id = $danfe->montaDANFE();
					}
					$danfe->printDANFE($dir.$chave.'.pdf', 'F',$Nota->anoMes);
				}
				
				if(isset($_REQUEST['mod'])&&$_REQUEST['mod']=='65'){
					exit('/uploads/'.$_REQUEST["emp_codigo"].'/nfe/'.$Nota->{"ambNfe"}.'/'.$situacao.'/'.$Nota->anoMes.'/'.$chave.'.html');
				}else{
					exit('/uploads/'.$_REQUEST["emp_codigo"].'/nfe/'.$Nota->{"ambNfe"}.'/'.$situacao.'/'.$Nota->anoMes.'/'.$chave.'.pdf');
				}
			
			//acao = baixar o XML da NF-e
			}elseif($_REQUEST["acao"]=="baixar"){
			
				header("Expires: 0");
				header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
				header("Content-Disposition: attachment; filename=".$chave."-nfe.xml");
				header("Content-Type: application/force-download");
				readfile($nomeArquivo);
				
				exit();
			
			//acao = email - enviar um e-mail com os arquivos da NF-e
			}elseif($_REQUEST["acao"]=="email"){
				$Datapacket->clear();
				
				if( isset($_REQUEST["msg"]) && $_REQUEST["msg"]=="cancelamento" ){
					
					$filter = '{"cod":"700268","params":[
						{"name":"dbcomum","value":"'.$company->{'emp_db_comum'}.'","type":"other"},
						{"name":"men_codigo","value":"23","type":"integer"}
					]}';
					$Datapacket->add($filter);
					$ret = $Datapacket->open(true);
					$Datapacket->clear();
					$msg_conteudo = $ret[0]->men_conteudo;
					$msg_remetente = $ret[0]->men_remetente;
					$msg_assunto = $ret[0]->men_assunto." N: ".$nota[0]->{"not_numero"}." - serie: ".$nota[0]->{"ser_codigo"};
					$to = base64_decode($_REQUEST["email"]);
					$to = strtolower(str_replace(" ", "", $to));
					$msg_destinatario = str_replace("\"", "", $to);
					
					$msg_anexo = "[";
					if(!$_POST["danfe"] || $_POST["danfe"]=="sim"){					
						if( isset($_POST["mod"]) && $_POST["mod"]==65 ){
							$anexoimp = substr($nomeArquivo,0,-8).".html";
						}else{
							$anexoimp = $nfeDir.$chave.".pdf";
						}
						$msg_anexo.= "{\"descricao\" : \"".base64_encode(utf8_decode("Nota Fiscal Eletrônica número ".$nota[0]->{"not_numero"}.", série ".$nota[0]->{"ser_codigo"}." de ".$company->{"emp_razao"}.", no valor de R$ ".$valor))."\", \"arquivo\" : \"".$anexoimp."\" },";
					}
					if(!$_POST["xml"] || $_POST["xml"]=="sim"){
						$msg_anexo.= "{\"descricao\" : \"\", \"arquivo\" : \"".$nomeArquivo."\" },";
					}
					$msg_anexo = base64_encode(substr($msg_anexo,0,-1)."]");
					
					$filtro = '{"cod":"700321","params":[
						{"name":"msg_codigo","value":"","type":"string"},
						{"name":"msg_tipo","value":"1","type":"integer"},
						{"name":"men_codigo","value":"23","type":"integer"},
						{"name":"msg_remetente","value":"'.$msg_remetente.'","type":"string"},
						{"name":"msg_destinatario","value":"'.$msg_destinatario.'","type":"string"},
						{"name":"cad_codigo","value":"'.$nota[0]->cad_codigo.'","type":"string"},
						{"name":"msg_assunto","value":"'.$msg_assunto.'","type":"string"},
						{"name":"msg_conteudo","value":"'.$msg_conteudo.'","type":"string"},
						{"name":"msg_data","value":"'.date("Y-m-d H:i:s").'","type":"string"},
						{"name":"msg_dtenvio","value":"'.date("Y-m-d H:i:s").'","type":"string"},
						{"name":"msg_status","value":"0","type":"integer"},
						{"name":"msg_anexo","value":"'.$msg_anexo.'","type":"string"}
					]}';
					$Datapacket->clear();
					$Datapacket->add($filtro);
					$ret = $Datapacket->open(false, true);
					
				}else{
					$filter = '{"cod":"700268","params":[
						{"name":"dbcomum","value":"'.$company->{'emp_db_comum'}.'","type":"other"},
						{"name":"men_codigo","value":"3","type":"integer"}
					]}';
					$Datapacket->add($filter);
					$ret = $Datapacket->open(true);
					$Datapacket->clear();
					
					$valor = ($nota[0]->{"not_totalnota"}>0) ? number_format($nota[0]->{"not_totalnota"}, 2, ",", "") : "0,00";
					
					if( isset($_REQUEST["msg"]) && $_REQUEST["msg"]!="" ){
						
						$msg_conteudo = $_REQUEST["msg"];
						
						$msg_remetente = $company->{'emp_emailremetente'};
						
						$msg_assunto = "Envio de NF-e N: ".$nota[0]->{"not_numero"}." - série: ".$nota[0]->{"ser_codigo"};
						
					}elseif($ret && $ret[0] && $ret[0]->men_conteudo && $ret[0]->men_conteudo!=""){
						
						$msg_conteudo = $ret[0]->men_conteudo;
						
						$msg_remetente = $ret[0]->men_remetente;
						
						$msg_assunto = $ret[0]->men_assunto." N: ".$nota[0]->{"not_numero"}." - serie: ".$nota[0]->{"ser_codigo"};
						
					}else{
						
						$msg = "<p><b>Prezado Sr(a) {{destinatario}},</b></p>";
						$msg .= "<p>Você está recebendo a Nota Fiscal Eletrônica número ".$nota[0]->{"not_numero"}.", série ".$nota[0]->{"ser_codigo"}." de";
						$msg .= " ".$company->{"emp_razao"}.", no valor de R$ ".$valor.". Junto com a mercadoria, você receberá também um DANFE";
						$msg .= " (Documento Auxiliar da Nota Fiscal Eletrônica), que acompanha o trânsito das";
						$msg .= " mercadorias.</p>";
						$msg .= "<p><i>Podemos conceituar a Nota Fiscal Eletrônica como um documento de existência apenas";
						$msg .= " digital, emitido e armazenado eletronicamente, com o intuito de documentar, para fins";
						$msg .= " fiscais, uma operação de circulação de mercadorias, ocorrida entre as partes.";
						$msg .= " Sua validade jurídica garantida pela assinatura digital do remetente (garantia de autoria";
						$msg .= " e de integridade) e recepção, pelo Fisco, do documento eletrônico, antes da";
						$msg .= " ocorrência do Fato Gerador.</i></p>";
						$msg .= "<p><i>Os registros fiscais e contábeis devem ser feitos, a partir do próprio arquivo";
						$msg .= " da NF-e, anexo neste e-mail, ou utilizando o DANFE, que representa graficamente a Nota";
						$msg .= " Fiscal Eletrônica. A validade e autenticidade deste documento eletrônico pode ser";
						$msg .= " verificada no site nacional do projeto (www.nfe.fazenda.gov.br), através da chave de acesso";
						$msg .= " contida no DANFE.</i></p>";
						$msg .= "<p><i>Para poder utilizar os dados descritos do DANFE na escrituração da NF-e, tanto o";
						$msg .= " contribuinte destinatário, como o contribuinte emitente, terão de verificar a validade da";
						$msg .= " NF-e. Esta validade está vinculada à efetiva existência da NF-e nos arquivos da SEFAZ,";
						$msg .= " e comprovada através da emissão da Autorização de Uso.</i></p>";
						$msg .= "<p><b>O DANFE não é uma nota fiscal, nem substitui uma nota fiscal, servindo apenas";
						$msg .= " como instrumento auxiliar para consulta da NF-e no Ambiente Nacional.</b></p>";
						$msg .= "<p>Para mais detalhes sobre o projeto, consulte: ";
						$msg .= "<a href='http://www.nfe.fazenda.gov.br/portal/Default.aspx'>www.nfe.fazenda.gov.br</a></p>";
						$msg .= "<br /><p>Atenciosamente,<p>{{remetente}}</p>";
						
						$msg_conteudo = base64_encode(utf8_decode($msg));
						
						$msg_remetente = $company->{'emp_emailremetente'};
						
						$msg_assunto = "Envio de NF-e N: ".$nota[0]->{"not_numero"}." - série: ".$nota[0]->{"ser_codigo"};
						
					}
					
					$msg_anexo = "[";
					if(!$_POST["danfe"] || $_POST["danfe"]=="sim"){
						//Busca por Carta de Correção
						$filtrocce = '{"cod":"700113","params":[
							{"name":"log_nro","value":"'.$nota[0]->{"not_codigo"}.'","type":"string"},
							{"name":"log_serie","value":"'.$nota[0]->{"ser_codigo"}.'","type":"string"}
						]}';
						$Datapacket->add($filtrocce);					
						$res = $Datapacket->open();
						$Datapacket->clear();
						if(isset($res) && count($res)>0){
							$ch = curl_init();
							$p = base64_encode($_REQUEST["emp_codigo"]);
							$p = substr($p, 0, 1)."2".substr($p, 1);
							$fields = array(
								'p' => $p,
								'email' => true,
								'not_codigo' => $nota[0]->{"not_codigo"}
							);
							$fields = http_build_query($fields);
							curl_setopt($ch,CURLOPT_URL, $_SERVER["HTTP_HOST"]."/desktop/rel/cartaCorrecao.php");
							curl_setopt($ch,CURLOPT_POST, true);
							curl_setopt($ch,CURLOPT_RETURNTRANSFER, true);
							curl_setopt($ch,CURLOPT_SAFE_UPLOAD, false);
							curl_setopt($ch,CURLOPT_POSTFIELDS, $fields);
							$result = curl_exec($ch);
							curl_close($ch);
							$msg_anexo.= "{\"descricao\" : \"".base64_encode(utf8_decode("Carta de correção "))."\", \"arquivo\" : \"".$result."\" },";
						}
					
						if( isset($_POST["mod"]) && $_POST["mod"]==65 ){
							$anexoimp = substr($nomeArquivo,0,-8).".html";
						}else{
							$anexoimp = $nfeDir.$chave.".pdf";
						}
						$msg_anexo.= "{\"descricao\" : \"".base64_encode(utf8_decode("Nota Fiscal Eletrônica número ".$nota[0]->{"not_numero"}.", série ".$nota[0]->{"ser_codigo"}." de ".$company->{"emp_razao"}.", no valor de R$ ".$valor))."\", \"arquivo\" : \"".$anexoimp."\" },";
					}
					if(!$_POST["xml"] || $_POST["xml"]=="sim"){
						$msg_anexo.= "{\"descricao\" : \"\", \"arquivo\" : \"".$nomeArquivo."\" },";
					}
					$msg_anexo = base64_encode(substr($msg_anexo,0,-1)."]");
					
					$to = base64_decode($_REQUEST["email"]);
					$to = strtolower(str_replace(" ", "", $to));
					// if(strstr($to, ";")) $to = explode(";", $to);
					// elseif(strstr($to, ",")) $to = explode(",", $to);
					
					// $msg_destinatario = (is_array($to)) ? str_replace("\"", "", $to[0]) : str_replace("\"", "", $to);
					$msg_destinatario = str_replace("\"", "", $to);
					
					$filtro = '{"cod":"700321","params":[
						{"name":"msg_codigo","value":"","type":"string"},
						{"name":"msg_tipo","value":"1","type":"integer"},
						{"name":"men_codigo","value":"3","type":"integer"},
						{"name":"msg_remetente","value":"'.$msg_remetente.'","type":"string"},
						{"name":"msg_destinatario","value":"'.$msg_destinatario.'","type":"string"},
						{"name":"cad_codigo","value":"'.$nota[0]->cad_codigo.'","type":"string"},
						{"name":"msg_assunto","value":"'.$msg_assunto.'","type":"string"},
						{"name":"msg_conteudo","value":"'.$msg_conteudo.'","type":"string"},
						{"name":"msg_data","value":"'.date("Y-m-d H:i:s").'","type":"string"},
						{"name":"msg_dtenvio","value":"'.date("Y-m-d H:i:s").'","type":"string"},
						{"name":"msg_status","value":"0","type":"integer"},
						{"name":"msg_anexo","value":"'.$msg_anexo.'","type":"string"}
					]}';
					
					$Datapacket->clear();
					$Datapacket->add($filtro);
					$ret = $Datapacket->open(false, true);
				
				}
				
				if($ret){
					$Datapacket->clear();
					//vinculo mensagem-nota
					$filtro = '{"cod":"700329","params":[
						{"name":"msg_codigo","value":"'.$ret.'","type":"integer"},
						{"name":"vin_tabela","value":"header_nota","type":"string"},
						{"name":"vin_codigo","value":"'.$_REQUEST["not_codigo"].'","type":"string"}
					]}';
					$Datapacket->add($filtro);
					$Datapacket->open();
					$_REQUEST["acao"] = "enviar";
					$_REQUEST["msg_codigo"] = $ret;
					
					include_once "../../mensagem.php";
				}
				
				
				/*
				//classe p/ envio
				include_once "../libs/MailNFePHP.class.php";
				
				//dados de configuração de envio
				$arqpdf = $nfeDir.$chave.".pdf";
				$auth = "1";
				$outro = "";
				
				$config = array(
					"mailAuth"=>"1",
					"mailFROM"=>strtolower($company->{"emp_emailremetente"}),
					"mailHOST"=>strtolower($company->{"emp_hostsmtp"}),
					"mailUSER"=>strtolower($company->{"emp_emailremetente"}),
					"mailPASS"=>$company->{"emp_pwdsmtp"},
					"mailPORT"=>"587",
					"mailPROTOCOL"=>"",
					"mailFROMmail"=>strtolower($company->{"emp_emailremetente"}),
					"mailFROMname"=>$company->{"emp_fantasia"},
					"mailREPLYTOmail"=>strtolower($company->{"emp_emailremetente"}),
					"mailREPLYTOname"=>$company->{"emp_fantasia"},
					"mailIMAPhost"=>"",
					"mailIMAPport"=>"",
					"mailIMAPsecurity"=>"",
					"mailIMAPnocerts"=>"",
					"mailIMAPbox"=>"",
					"recebidasDir"=>"",
					"temporariasDir"=>"",
					"canceladasDir"=>"",
					"CNPJ"=>$company->{"emp_cpfcnpj"},
					"mailLayoutFile"=>""
				);

				$email = new MailNFePHP($config);
				
				$msg = nl2br(utf8_encode(base64_decode($_REQUEST["msg"])));
				
				$to = base64_decode($_REQUEST["email"]);
				$to = str_replace(" ", "", $to);
				if(strstr($to, ";")) $to = explode(";", $to);
				elseif(strstr($to, ",")) $to = explode(",", $to);

				$cliente = $nota[0]->{"cad_nomeraz"};
				$assunto = utf8_decode("Envio de NF-e N: ".$nota[0]->{"not_numero"}." - série: ".$nota[0]->{"ser_codigo"});
				$arqxml = $nomeArquivo;

				//mensagem (corpo do e-mail)
				if ($msg == '') {

					if( $company->{"emp_msgnfe"} && strlen($company->{"emp_msgnfe"})>30 ){
						$msg = base64_decode($company->{"emp_msgnfe"});
					}else{
						$msg = "<p><b>Prezado Sr(a) {cliente},</b></p>";
						$msg .= "<p>Você está recebendo a Nota Fiscal Eletrônica número {numero}, série {serie} de";
						$msg .= " {emitente}, no valor de R$ {valor}. Junto com a mercadoria, você receberá também um DANFE";
						$msg .= " (Documento Auxiliar da Nota Fiscal Eletrônica), que acompanha o trânsito das";
						$msg .= " mercadorias.</p>";
						$msg .= "<p><i>Podemos conceituar a Nota Fiscal Eletrônica como um documento de existência apenas";
						$msg .= " digital, emitido e armazenado eletronicamente, com o intuito de documentar, para fins";
						$msg .= " fiscais, uma operação de circulação de mercadorias, ocorrida entre as partes.";
						$msg .= " Sua validade jurídica garantida pela assinatura digital do remetente (garantia de autoria";
						$msg .= " e de integridade) e recepção, pelo Fisco, do documento eletrônico, antes da";
						$msg .= " ocorrência do Fato Gerador.</i></p>";
						$msg .= "<p><i>Os registros fiscais e contábeis devem ser feitos, a partir do próprio arquivo";
						$msg .= " da NF-e, anexo neste e-mail, ou utilizando o DANFE, que representa graficamente a Nota";
						$msg .= " Fiscal Eletrônica. A validade e autenticidade deste documento eletrônico pode ser";
						$msg .= " verificada no site nacional do projeto (www.nfe.fazenda.gov.br), através da chave de acesso";
						$msg .= " contida no DANFE.</i></p>";
						$msg .= "<p><i>Para poder utilizar os dados descritos do DANFE na escrituração da NF-e, tanto o";
						$msg .= " contribuinte destinatário, como o contribuinte emitente, terão de verificar a validade da";
						$msg .= " NF-e. Esta validade está vinculada à efetiva existência da NF-e nos arquivos da SEFAZ,";
						$msg .= " e comprovada através da emissão da Autorização de Uso.</i></p>";
						$msg .= "<p><b>O DANFE não é uma nota fiscal, nem substitui uma nota fiscal, servindo apenas";
						$msg .= " como instrumento auxiliar para consulta da NF-e no Ambiente Nacional.</b></p>";
						$msg .= "<p>Para mais detalhes sobre o projeto, consulte: ";
						$msg .= "<a href='http://www.nfe.fazenda.gov.br/portal/Default.aspx'>www.nfe.fazenda.gov.br</a></p>";
						$msg .= "<br /><p>Atenciosamente,<p>{emitente}</p>";
					}
					
				}
				//substitui os campos variáveis da mensagem html
				$valor = ($nota[0]->{"not_totalnota"}>0) ? number_format($nota[0]->{"not_totalnota"}, 2, ",", "") : "0,00";
				$msg = str_replace('{cliente}', $cliente, $msg);
				$msg = str_replace('{emitente}', $company->{"emp_razao"}, $msg);
				$msg = str_replace('{numero}', $nota[0]->{"not_numero"}, $msg);
				$msg = str_replace('{serie}', $nota[0]->{"ser_codigo"}, $msg);
				$msg = str_replace('{valor}', $valor, $msg);
				$msg = utf8_decode($msg);

				//texto puro (sem html)
				$txt = strip_tags($msg);
				
				
				if(is_array($to)){

					$msgfinal = "";
					foreach($to as $para){
						if($email->sendM($para, $cliente, $assunto, $txt, $msg, $arqxml, $arqpdf, $auth, $outro)){
							$msgfinal.= $para." - Enviado!<br>";
						}else{
							$msgfinal.= $para." - Nâo Enviado!<br>";
						}
					}
					exit($msgfinal);
					
				}else{

					if( $email->sendM($to, $cliente, $assunto, $txt, $msg, $arqxml, $arqpdf, $auth, $outro) ){
						exit("E-mail enviado com sucesso!");
					}else{
						exit("Erro ao tentar enviar e-mail, verifique as configurações de envio e tente novamente mais tarde.<br>Ação:E-mail");
					}
					
				}
				*/
			//acao = enviar link por whatsapp
			}elseif( $_REQUEST["acao"]=="whatsapp" ){
				
				$msg_remetente = '';
				$msg_assunto = '';
				$msg_destinatario = $_REQUEST["whatsapp"];
				$msg_anexo = base64_encode("[{\"descricao\" : \"Acesse sua NF-e N ".$nota[0]->{"not_numero"}."\", \"arquivo\" : \"".$nfeDir.$chave.".pdf".''."\" }]");
				
				//registro da mensagem no sistema
				$filtro = '{"cod":"700321","params":[
					{"name":"msg_codigo","value":"","type":"string"},
					{"name":"msg_tipo","value":"3","type":"integer"},
					{"name":"men_codigo","value":"26","type":"integer"},
					{"name":"msg_remetente","value":"'.$msg_remetente.'","type":"string"},
					{"name":"msg_destinatario","value":"'.$msg_destinatario.'","type":"string"},
					{"name":"cad_codigo","value":"'.$nota[0]->cad_codigo.'","type":"string"},
					{"name":"msg_assunto","value":"'.$msg_assunto.'","type":"string"},
					{"name":"msg_conteudo","value":"'.base64_encode('Prezado cliente, {{anexo}}: {{link}}').'","type":"string"},
					{"name":"msg_data","value":"'.date("Y-m-d H:i:s").'","type":"string"},
					{"name":"msg_dtenvio","value":"'.date("Y-m-d H:i:s").'","type":"string"},
					{"name":"msg_status","value":"0","type":"integer"},
					{"name":"msg_anexo","value":"'.$msg_anexo.'","type":"string"}
				]}';
				
				$Datapacket->clear();
				$Datapacket->add($filtro);
				$ret = $Datapacket->open(false, true);
				
				if($ret){
					//enviar a mensagem
					$_REQUEST["acao"] = "enviar";
					$_REQUEST["msg_codigo"] = $ret;
					include_once "../../mensagem.php";
				}
				exit();
				
			//acao = enviar link por sms
			}elseif( $_REQUEST["acao"]=="sms" ){
				
				$msg_remetente = '';
				$msg_assunto = '';
				$msg_destinatario = $_REQUEST["sms"];
				$msg_anexo = base64_encode("[{\"descricao\" : \"sua NF-e N ".$nota[0]->{"not_numero"}."\", \"arquivo\" : \"".$nfeDir.$chave.".pdf".''."\" }]");
				
				//registro da mensagem no sistema
				$filtro = '{"cod":"700321","params":[
					{"name":"msg_codigo","value":"","type":"string"},
					{"name":"msg_tipo","value":"2","type":"integer"},
					{"name":"men_codigo","value":"26","type":"integer"},
					{"name":"msg_remetente","value":"'.$msg_remetente.'","type":"string"},
					{"name":"msg_destinatario","value":"'.$msg_destinatario.'","type":"string"},
					{"name":"cad_codigo","value":"'.$nota[0]->cad_codigo.'","type":"string"},
					{"name":"msg_assunto","value":"'.$msg_assunto.'","type":"string"},
					{"name":"msg_conteudo","value":"'.base64_encode('Prezado cliente, {{anexo}}: {{link}}').'","type":"string"},
					{"name":"msg_data","value":"'.date("Y-m-d H:i:s").'","type":"string"},
					{"name":"msg_dtenvio","value":"'.date("Y-m-d H:i:s").'","type":"string"},
					{"name":"msg_status","value":"0","type":"integer"},
					{"name":"msg_anexo","value":"'.$msg_anexo.'","type":"string"}
				]}';
				
				$Datapacket->clear();
				$Datapacket->add($filtro);
				$ret = $Datapacket->open(false, true);
				
				if($ret){
					//enviar a mensagem
					$_REQUEST["acao"] = "enviar";
					$_REQUEST["msg_codigo"] = $ret;
					include_once "../../mensagem.php";
				}
				exit();

			//acao = cancelar a NF-e
			}elseif($_REQUEST["acao"]=="cancelar"){
				
				$motivo =trim(base64_decode($_REQUEST["motivo"]));
				
				if ($resp = $tools->cancelEvent($chave, $nota[0]->{"not_nprot"}, $motivo, $tpAmb, $modSOAP)){
					
					//atualização do XML
					copy($nomeArquivo, substr($nomeArquivo, 0, -7)."nfe2.xml" ); //copia do original (usar para impressao)
					chmod(substr($nomeArquivo, 0, -7)."nfe2.xml", 0777);
					file_put_contents($nomeArquivo, $resp["xml"]); //substituição do conteúdo original pelo protocolo de cancelamento
					
					if(!is_dir($TParams->uploads.$_REQUEST["emp_codigo"].'/nfe/'.$Nota->{"ambNfe"}.'/canceladas')){
						@mkdir($TParams->uploads.$_REQUEST["emp_codigo"].'/nfe/'.$Nota->{"ambNfe"}.'/canceladas',0777,true);
					}
					$nfeDir = $TParams->uploads.$_REQUEST["emp_codigo"].'/nfe/'.$Nota->{"ambNfe"}.'/canceladas/'.$Nota->anoMes."/";
					if(!is_dir($nfeDir)){
						@mkdir($nfeDir,0777,true);
					}
					copy($nomeArquivo, $nfeDir.$chave.'-nfe.xml'); //copiando para a pasta canceladas (protocolo de cancelamento)
					chmod($nfeDir.$chave.'-nfe.xml', 0777);
					copy(substr($nomeArquivo, 0, -7)."nfe2.xml", $nfeDir.$chave.'-nfe2.xml'); //copiando para a pasta canceladas (original)
					chmod($nfeDir.$chave.'-nfe2.xml', 0777);
					unlink($nomeArquivo); //excluindo
					unlink(substr($nomeArquivo, 0, -7)."nfe2.xml"); //excluindo
					
					//alterar pedido vinculado
					$filtroPed = '{"cod":"700385","params":[
						{"name":"not_codigo","value":"'.$nota[0]->{"not_codigo"}.'","type":"string"}
					]}';
					$Datapacket->add($filtroPed);
					
					//alterar os vinculada
					$filtroOs = '{"cod":"700805","params":[
						{"name":"not_codigo","value":"'.$nota[0]->{"not_codigo"}.'","type":"string"}
					]}';
					$Datapacket->add($filtroOs);
					
					$Datapacket->open();
					
					$Datapacket->clear();
					
					//Atualização da NF-e no Banco (cancelamento)
					$dhRecbto = implode("-", array_reverse(explode("/", substr($resp["ret"]["dhRecbto"], 0, 10))));
					$dhRecbto.= substr($resp["ret"]["dhRecbto"], 10, 9);
					$filtroAtualiza = '{"cod":"700112","params":[
						{"name":"not_dtcancdesc","value":"'.$dhRecbto.'","type":"string"},
						{"name":"not_cstat","value":"'.$resp["ret"]["cStat"].'","type":"integer"},
						{"name":"not_xmotivo","value":"'.base64_encode($resp["ret"]["xMotivo"]).'","type":"string"},
						{"name":"not_nprot","value":"'.$resp["ret"]["nProt"].'","type":"integer"},
						{"name":"not_codigo","value":"'.$nota[0]->{"not_codigo"}.'","type":"string"}
					]}';
					$Datapacket->add($filtroAtualiza);
					
					//cancelamento de doctos
					if( isset($doctos) && is_array($doctos) && isset($doctos[0]->{"doc_tipo"}) ){
						foreach ($doctos as $docto) {
							$filtro = '{"cod":"501240","params":[
								{"name":"lgd_tipo","value":"3","type":"integer"},
								{"name":"doc_codigo","value":"'.$docto->doc_codigo.'","type":"string"},
								{"name":"usu_login","value":"'.$_REQUEST["usu_login"].'","type":"string"},
								{"name":"lgd_dtatualizada","value":"NULL","type":"other"},
								{"name":"lgd_descr","value":"Motivo: NF-e cancelada","type":"string"}
							]}';
							$Datapacket->add($filtro);
							//cancelar boleto inter no banco
							if($docto->doc_tipo==2 && $docto->doc_boletogerado==1 && $docto->doc_carteira=='112'){
								$fields = array(
									'p' => $_REQUEST["p"],
									'acao' => 'cancelar',
									'doc_codigo' => $docto->doc_codigo
								);
								$ch = curl_init();
								curl_setopt($ch,CURLOPT_URL, $Datapacket->HostClient."/rel/relboleto.php");
								curl_setopt($ch,CURLOPT_POST, true);
								curl_setopt($ch,CURLOPT_RETURNTRANSFER, true);
								curl_setopt($ch,CURLOPT_POSTFIELDS, $fields);
								$result = curl_exec($ch);
							}
						}
					}
					$Datapacket->open();
					$Datapacket->clear();
					$filtroDocto = '{"cod":"700704","params":[
						{"name":"not_codigo","value":"'.$nota[0]->{"not_codigo"}.'","type":"string"}
					]}';
					$Datapacket->add($filtroDocto);
					
					$ant="";
					//Atualização do estoque do(s) produto(s) (reposição)
					foreach($nota as $not){
						if( $not->{"itn_ordem"}!=$ant ){
							
							//conversao de unidades quando necessario
							$datapacket2 = new Datapacket();
							$filtro = '{"cod":"700565","params":[
								{"name":"db","value":"'.$TParams->getDb().'","type":"other"},
								{"name":"uni_codigo","value":"'.$not->{'uni_codigo'}.'","type":"string"},
								{"name":"ref_codigo","value":"'.$not->{'ref_codigo'}.'","type":"integer"}
							]}';
							$datapacket2->add($filtro);
							$conv = $datapacket2->open();
							$datapacket2->clear();
				
							$stk_seq = substr(str_replace(array(","," ","."),array("","",""),microtime()), 0, 8);
							$loc_codigo = ($not->{'loc_codigo'}) ? $not->{'loc_codigo'} : "1";
							$lot_codigo = ($not->{'lot_codigo'}) ? $not->{'lot_codigo'} : "99999";
							$stk_qde = $not->{'itn_qtde'};
							
							if( isset($conv) && isset($conv[0]) && isset($conv[0]["ref_conv_qtde"]) ) $stk_qde = number_format($stk_qde/ $conv[0]["ref_conv_qtde"],2,'.',''); //conversao
							$stk_qde = ($stk_qde>0) ? $stk_qde : $not->{'itn_qtde'};
							
							$filtrostk = '{"cod":"700111","params":[
								{"name":"db","value":"'.$company->{"emp_db_comum"}.'","type":"other"},
								{"name":"emp_codigo","value":"'.$company->{"emp_codigo"}.'","type":"string"},
								{"name":"loc_codigo","value":"'.$loc_codigo.'","type":"string"},
								{"name":"lot_codigo","value":"'.$lot_codigo.'","type":"string"},
								{"name":"ref_codigo","value":"'.$not->{'ref_codigo'}.'","type":"integer"},
								{"name":"ser_codigo","value":"'.$nota[0]->{"ser_codigo"}.'","type":"string"},
								{"name":"stk_data","value":"'.$dhRecbto.'","type":"string"},
								{"name":"stk_seq","value":"'.$stk_seq.'","type":"integer"},
								{"name":"stk_qde","value":"'.$stk_qde.'","type":"float"},
								{"name":"stk_tipo","value":"3","type":"integer"},
								{"name":"not_codigo","value":"'.$_REQUEST['not_codigo'].'","type":"string"}
							]}';
							$Datapacket->add($filtrostk);
							$ant = $not->{"itn_ordem"};
						}
					}
					
					//Atualização do log com dados do cancelamento
					$filtrolog = '{"cod":"700103","params":[
						{"name":"log_tipo","value":"2","type":"integer"},
						{"name":"log_nro","value":"'.$nota[0]->{"not_codigo"}.'","type":"string"},
						{"name":"log_serie","value":"'.$nota[0]->{"ser_codigo"}.'","type":"string"},';
					$filtrolog.= ( isset($_REQUEST["usu_login"]) && $_REQUEST["usu_login"]!="" ) ? '{"name":"log_usu_login","value":"'.$_REQUEST["usu_login"].'","type":"string"},' : '{"name":"log_usu_login","value":"NULL","type":"other"},';
					$filtrolog.= '{"name":"log_acao_cod","value":"5","type":"integer"},
						{"name":"log_acao_descr","value":"cancelamento","type":"string"},
						{"name":"log_data","value":"'.date("Y-m-d H:i:s").'","type":"string"},
						{"name":"log_protocolo","value":"'.$resp["ret"]["nProt"].' ","type":"string"},
						{"name":"log_ret","value":"NULL","type":"other"},
						{"name":"log_outro","value":"'.base64_encode('NF-e cancelada, motivo: \''.utf8_encode($motivo).'\'').'","type":"string"}
					]}';
					$Datapacket->add($filtrolog);
					
					$Datapacket->open();
					
					echo "NF-e cancelada com sucesso em: ".$resp["ret"]["dhRecbto"];
					
					exit();
					
				} else {
				
					//Atualização do log com erro na tentativa de cancelamento
					$filtrolog = '{"cod":"700103","params":[
						{"name":"log_tipo","value":"2","type":"integer"},
						{"name":"log_nro","value":"'.$nota[0]->{"not_codigo"}.'","type":"string"},
						{"name":"log_serie","value":"'.$nota[0]->{"ser_codigo"}.'","type":"string"},';
					$filtrolog.= ( isset($_REQUEST["usu_login"]) && $_REQUEST["usu_login"]!="" ) ? '{"name":"log_usu_login","value":"'.$_REQUEST["usu_login"].'","type":"string"},' : '{"name":"log_usu_login","value":"NULL","type":"other"},';
					$filtrolog.= '{"name":"log_acao_cod","value":"5","type":"integer"},
						{"name":"log_acao_descr","value":"cancelamento","type":"string"},
						{"name":"log_data","value":"'.date("Y-m-d H:i:s").'","type":"string"},
						{"name":"log_protocolo","value":"NULL","type":"other"},
						{"name":"log_ret","value":"NULL","type":"other"},
						{"name":"log_outro","value":"'.base64_encode("Erro no cancelamento: ".$tools->errMsg).'","type":"string"}
					]}';
					$Datapacket->add($filtrolog);
					$Datapacket->open();
				
					echo "Erro no cancelamento: ".$tools->errMsg;
					exit();
					
				}
			
			//acao = corrigir - Carta de correção da NF-e
			}elseif($_REQUEST["acao"]=="corrigir"){
				
				//Busca por eventos anteriores para pegar sequencia da Carta de Correção
				$filtrocce = '{"cod":"700113","params":[
					{"name":"log_nro","value":"'.$nota[0]->{"not_codigo"}.'","type":"string"},
					{"name":"log_serie","value":"'.$nota[0]->{"ser_codigo"}.'","type":"string"}
				]}';
				
				$Datapacket->add($filtrocce);
				
				$res = $Datapacket->open();
				$seq = count($res);
					
				$texto = trim(base64_decode($_REQUEST["texto"]));
				$seq = ($seq>0) ? ($seq+1) : 1;
				
				if ($resp = $tools->envCCe($nota[0]->{"not_key_nfe"}, $texto, $seq, $tpAmb, $retorno)){
					
					$ccefile = $nfeDir.$nota[0]->{"not_key_nfe"}.'-'.$seq.'-cce.xml';
							
					//Criar arquivo carta correção e gravar dados retornados
					$arquivoCCe = fopen($ccefile,'w+');
					fwrite($arquivoCCe, $resp["xml"]);
					fclose($arquivoCCe);
							
					//Atualização do log com dados da carta de correção
					$filtrolog = '{"cod":"700103","params":[
						{"name":"log_tipo","value":"2","type":"integer"},
						{"name":"log_nro","value":"'.$nota[0]->{"not_codigo"}.'","type":"string"},
						{"name":"log_serie","value":"'.$nota[0]->{"ser_codigo"}.'","type":"string"},';
					$filtrolog.= ( isset($_REQUEST["usu_login"]) && $_REQUEST["usu_login"]!="" ) ? '{"name":"log_usu_login","value":"'.$_REQUEST["usu_login"].'","type":"string"},' : '{"name":"log_usu_login","value":"NULL","type":"other"},';
					$filtrolog.= '{"name":"log_acao_cod","value":"6","type":"integer"},
						{"name":"log_acao_descr","value":"correção","type":"string"},
						{"name":"log_data","value":"'.date("Y-m-d H:i:s").'","type":"string"},
						{"name":"log_protocolo","value":"'.$resp["retEvento"]["infEvento"]["nProt"].' ","type":"string"},
						{"name":"log_ret","value":"'.base64_encode(json_encode($resp["retEvento"])).'","type":"string"},
						{"name":"log_outro","value":"'.base64_encode('Carta de correcao: \''.$texto.'\'').'","type":"string"}
					]}';
					
					$Datapacket->add($filtrolog);
					
					$Datapacket->open();
					
					echo 'Carta de correção enviada com sucesso em: '.date("d/m/Y H:i:s h", strtotime($resp["retEvento"]["infEvento"]["dhRegEvento"]));
					
					exit();
					
				} else {
				
					//Atualização do log com erro de envio de carta de correção
					$filtrolog = '{"cod":"700103","params":[
						{"name":"log_tipo","value":"2","type":"integer"},
						{"name":"log_nro","value":"'.$nota[0]->{"not_codigo"}.'","type":"string"},
						{"name":"log_serie","value":"'.$nota[0]->{"ser_codigo"}.'","type":"string"},';
					$filtrolog.= ( isset($_REQUEST["usu_login"]) && $_REQUEST["usu_login"]!="" ) ? '{"name":"log_usu_login","value":"'.$_REQUEST["usu_login"].'","type":"string"},' : '{"name":"log_usu_login","value":"NULL","type":"other"},';
					$filtrolog.= '{"name":"log_acao_cod","value":"6","type":"integer"},
						{"name":"log_acao_descr","value":"correção","type":"string"},
						{"name":"log_data","value":"'.date("Y-m-d H:i:s").'","type":"string"},
						{"name":"log_protocolo","value":"NULL","type":"other"},
						{"name":"log_ret","value":"NULL","type":"other"},
						{"name":"log_outro","value":"'.base64_encode("Erro no envio da Carta de Correção: ".$tools->errMsg).'","type":"string"}
					]}';
					$Datapacket->add($filtrolog);
					$Datapacket->open();
				
					echo "Erro no envio da Carta de Correção: ".$tools->errMsg;
					exit();
					
				}
				
			}elseif($_REQUEST["acao"]=="consultar"){
				
				$chave = ( isset($nota[0]->{'not_key_nfe'}) && $nota[0]->{'not_key_nfe'}!="" ) ? $nota[0]->{'not_key_nfe'} : $chave;
				
				if ($prot = $tools->getProtocol("", $chave, $tpAmb, $retorno)){

					$dhRecbto = implode("-", array_reverse(explode("/", substr($retorno["aProt"]["dhRecbto"], 0, 10))));
					$dhRecbto.= substr($retorno["aProt"]["dhRecbto"], 10, 9);

					if( $retorno["cStat"]=="100" ){
						
						$protfile 	= $nfeDir.$chave.'-prot.xml';
						//Criar arquivo protocolo
						$arquivoProt = fopen($protfile,'w+');
						fwrite($arquivoProt, $prot);
						fclose($arquivoProt);
						
						$xml = $tools->signXML($docxml, 'infNFe');
					
						file_put_contents($nomeArquivo, $xml);
						
						//Adicionar Protocolo ao XML da NF-e
						if ($xml = $tools->addProt($nomeArquivo, $protfile)){
							file_put_contents($nomeArquivo, $xml);
						}
						
						if(!is_dir($TParams->uploads.$_REQUEST["emp_codigo"].'/nfe/'.$Nota->{"ambNfe"}.'/autorizadas')){
							@mkdir($TParams->uploads.$_REQUEST["emp_codigo"].'/nfe/'.$Nota->{"ambNfe"}.'/autorizadas',0777,true);
						}
						$dir = $TParams->uploads.$_REQUEST["emp_codigo"].'/nfe/'.$Nota->{"ambNfe"}.'/autorizadas/'.$Nota->anoMes.'/';
						if(!is_dir($dir)){
							@mkdir($dir,0777,true);
						}
						
						copy($nomeArquivo, $dir.$chave.'-nfe.xml');
						chmod($dir.$chave.'-nfe.xml', 0777);
						unlink($nomeArquivo);
						unlink($protfile);
						
						$docxml = file_get_contents($dir.$chave.'-nfe.xml');
						
						$ant="";
						//Atualização do estoque do(s) produto(s) (caso ainda não esteja atualizado)
						if( !$nota[0]->{'not_stokatualiz'} || $nota[0]->{'not_stokatualiz'}==0 ){
							foreach($nota as $not){
								if( $not->{"itn_ordem"}!=$ant ){
									
									//conversao de unidades quando necessario
									$datapacket2 = new Datapacket();
									$filtro = '{"cod":"700565","params":[
										{"name":"db","value":"'.$TParams->getDb().'","type":"other"},
										{"name":"uni_codigo","value":"'.$not->{'uni_codigo'}.'","type":"string"},
										{"name":"ref_codigo","value":"'.$not->{'ref_codigo'}.'","type":"integer"}
									]}';
									$datapacket2->add($filtro);
									$conv = $datapacket2->open();
									$datapacket2->clear();
			
									$stk_seq = substr(str_replace(array(","," ","."),array("","",""),microtime()), 0, 8);
									$loc_codigo = ($not->{'loc_codigo'}) ? $not->{'loc_codigo'} : "1";
									$lot_codigo = ($not->{'lot_codigo'}) ? $not->{'lot_codigo'} : "99999";
									$stk_qde = $not->{'itn_qtde'};
									
									if( isset($conv) && isset($conv[0]) && isset($conv[0]["ref_conv_qtde"]) ) $stk_qde = number_format($stk_qde/ $conv[0]["ref_conv_qtde"],2,'.',''); //conversao
									$stk_qde = ($stk_qde>0) ? $stk_qde : $not->{'itn_qtde'};
									
									$stk_qde = ($nota[0]->{'not_entrsaida'}==2) ? '-'.$stk_qde : $stk_qde;
									$filtrostk = '{"cod":"700111","params":[
										{"name":"db","value":"'.$company->{"emp_db_comum"}.'","type":"other"},
										{"name":"emp_codigo","value":"'.$company->{"emp_codigo"}.'","type":"string"},
										{"name":"loc_codigo","value":"'.$loc_codigo.'","type":"string"},
										{"name":"lot_codigo","value":"'.$lot_codigo.'","type":"string"},
										{"name":"ref_codigo","value":"'.$not->{'ref_codigo'}.'","type":"integer"},
										{"name":"ser_codigo","value":"'.$nota[0]->{"ser_codigo"}.'","type":"string"},
										{"name":"stk_data","value":"'.$dhRecbto.'","type":"string"},
										{"name":"stk_seq","value":"'.$stk_seq.'","type":"integer"},
										{"name":"stk_qde","value":"'.$stk_qde.'","type":"float"},
										{"name":"stk_tipo","value":"'.$nota[0]->{'not_entrsaida'}.'","type":"integer"},
										{"name":"not_codigo","value":"'.$_REQUEST['not_codigo'].'","type":"string"}
									]}';
									$Datapacket->add($filtrostk);
									$ant = $not->{"itn_ordem"};
								}
							}
						}
						
						//Atualizar os dados de retorno da NF-e no banco de dados (autorizada)
						$filtroAtualiza = '{"cod":"700105","params":[
							{"name":"not_status","value":"2","type":"integer"},
							{"name":"not_dtfaturam","value":"'.$dhRecbto.'","type":"string"},
							{"name":"not_dtprevisao","value":"'.$dhRecbto.'","type":"string"},
							{"name":"not_dtentrega","value":"'.$dhRecbto.'","type":"string"},
							{"name":"not_finanatualiz","value":"1","type":"integer"},
							{"name":"not_stokatualiz","value":"1","type":"integer"},
							{"name":"not_custoautaliz","value":"1","type":"integer"},
							{"name":"not_key_nfe","value":"'.$retorno["chNFe"].'","type":"string"},
							{"name":"not_result","value":"'.base64_encode(json_encode($retorno)).'","type":"string"},
							{"name":"not_cstat","value":"'.$retorno['cStat'].'","type":"string"},
							{"name":"not_xmotivo","value":"'.base64_encode($retorno['xMotivo']).'","type":"string"},
							{"name":"not_aliq","value":"'.$itn_aliqicms.'","type":"string"},
							{"name":"not_codigo","value":"'.$_REQUEST["not_codigo"].'","type":"string"},
							{"name":"not_tpemis","value":"'.$tpEmis.'","type":"string"},';

						if($retorno["aProt"]["nProt"]){
							$filtroAtualiza .= '{"name":"not_nprot","value":"'.$retorno["aProt"]["nProt"].'","type":"string"}';
						}else{
							$filtroAtualiza .= '{"name":"not_nprot","value":"","type":"null"}';
						}

						$filtroAtualiza.=']}';
						
						$Datapacket->add($filtroAtualiza);
						
						//Atualização do Log da NF-e com os dados transmitidos
						$filtrolog = '{"cod":"700103","params":[
							{"name":"log_tipo","value":"2","type":"integer"},
							{"name":"log_nro","value":"'.$nota[0]->{"not_codigo"}.'","type":"string"},
							{"name":"log_serie","value":"'.$nota[0]->{"ser_codigo"}.'","type":"string"},';
						$filtrolog.= ( isset($_REQUEST["usu_login"]) && $_REQUEST["usu_login"]!="" ) ? '{"name":"log_usu_login","value":"'.$_REQUEST["usu_login"].'","type":"string"},' : '{"name":"log_usu_login","value":"NULL","type":"other"},';
						$filtrolog.= '{"name":"log_acao_cod","value":"3","type":"integer"},
							{"name":"log_acao_descr","value":"transmissão","type":"string"},
							{"name":"log_data","value":"'.$dhRecbto.'","type":"string"},
							{"name":"log_protocolo","value":"'.$retorno["aProt"]["nProt"].'","type":"string"},
							{"name":"log_ret","value":"'.base64_encode(json_encode($retorno)).'","type":"string"},
							{"name":"log_outro","value":"'.base64_encode("NF-e transmitida com sucesso!").'","type":"string"}
						]}';
						$Datapacket->add($filtrolog);
						
						$Datapacket->open(true);
						
						//print_r($Datapacket->getLastQuery());
						
						//DANFE
						$logo = "http://".$_SERVER['SERVER_NAME']."/uploads/".$_REQUEST["emp_codigo"]."/".$company->{"emp_logo"};

						if(isset($_REQUEST['calcNcm'])){
							$calcNcm = $_REQUEST['calcNcm'];
						}else{
							$calcNcm = 0;
						}
						if( isset($_REQUEST["mod"]) && $_REQUEST["mod"]=="65" ){
							if(isset($company->{"emp_logo"}) && !empty($company->{"emp_logo"})){
								$danfe = new DanfeNFCeNFePHP($docxmll, $logo, 0, '000001', $company->{"emp_csc"}, $company->{'emp_codigo'}, $chave,$Nota->uploads);
							}else{
								$danfe = new DanfeNFCeNFePHP($docxmll, '', 0, '000001', $company->{"emp_csc"}, $company->{'emp_codigo'}, $chave,$Nota->uploads);
							}
							$id = $danfe->montaDANFE(false, $calcNcm);
							$danfe->printDANFE('html', $dir.$chave.'.html', 'F',$Nota->anoMes);
						}else{
							$danfe = new DanfeNFePHP($docxml, 'C', 'A4', $logo, 'F', $dir,$company);
							$id = $danfe->montaDANFE();
							$danfe->printDANFE($dir.$chave.'.pdf', 'F',$Nota->anoMes);
						}
						
					}elseif( $retorno["cStat"]=="110" || $retorno["cStat"]=="205" || $retorno["cStat"]=="233" || $retorno["cStat"]=="234" || $retorno["cStat"]=="301" ){
						if(!is_dir($TParams->uploads.$_REQUEST["emp_codigo"].'/nfe/'.$Nota->{"ambNfe"}.'/denegadas')){
							@mkdir($TParams->uploads.$_REQUEST["emp_codigo"].'/nfe/'.$Nota->{"ambNfe"}.'/denegadas',0777,true);
						}
						$dir = $TParams->uploads.$_REQUEST["emp_codigo"].'/nfe/'.$Nota->{"ambNfe"}.'/denegadas/'.$Nota->anoMes.'/';
						if(!is_dir($dir)){
							@mkdir($dir,0777,true);
						}
						copy($nomeArquivo, $dir.$chave.'-nfe.xml');
						chmod($dir.$chave.'-nfe.xml', 0777);
						unlink($nomeArquivo);
						$not_status=6;
						$filtroAtualiza = '{"cod":"700105","params":[
							{"name":"not_status","value":"'.$not_status.'","type":"integer"},
							{"name":"not_dtfaturam","value":"NULL","type":"other"},
							{"name":"not_dtprevisao","value":"NULL","type":"other"},
							{"name":"not_dtentrega","value":"NULL","type":"other"},
							{"name":"not_finanatualiz","value":"1","type":"integer"},
							{"name":"not_stokatualiz","value":"1","type":"integer"},
							{"name":"not_custoautaliz","value":"1","type":"integer"},
							{"name":"not_key_nfe","value":"'.$chave.'","type":"string"},
							{"name":"not_result","value":"'.base64_encode(json_encode($retorno)).'","type":"string"},
							{"name":"not_cstat","value":"'.$retorno["cStat"].'","type":"string"},
							{"name":"not_xmotivo","value":"'.base64_encode($retorno["protNFe"]["infProt"]['xMotivo']).'","type":"string"},
							{"name":"not_aliq","value":"0","type":"string"},
							{"name":"not_codigo","value":"'.$_REQUEST["not_codigo"].'","type":"string"},
							{"name":"not_tpemis","value":"'.$tpEmis.'","type":"string"},';
						if($retorno["protNFe"]["infProt"]["nProt"]){
							$filtroAtualiza .= '{"name":"not_nprot","value":"'.$retorno["protNFe"]["infProt"]["nProt"].'","type":"string"}';
						}else{
							$filtroAtualiza .= '{"name":"not_nprot","value":"NULL","type":"other"}';
						}
						$filtroAtualiza.=']}';
						$Datapacket->clear();
						$Datapacket->add($filtroAtualiza);
						$Datapacket->open();
						$Datapacket->clear();
					}
				}
			
			//alterar status para aguardando
			}elseif($_REQUEST["acao"]=="aguardar"){
				
				if(!is_dir($TParams->uploads.$_REQUEST["emp_codigo"].'/nfe/'.$Nota->{"ambNfe"}.'/aguardando')){
					@mkdir($TParams->uploads.$_REQUEST["emp_codigo"].'/nfe/'.$Nota->{"ambNfe"}.'/aguardando',0777,true);
				}
				$dir = $TParams->uploads.$_REQUEST["emp_codigo"].'/nfe/'.$Nota->{"ambNfe"}.'/aguardando/'.$Nota->anoMes.'/';
				if(!is_dir($dir)){
					@mkdir($dir,0777,true);
				}
				copy($nomeArquivo, $dir.$chave.'-nfe.xml');
				chmod($dir.$chave.'-nfe.xml', 0777);
				unlink($nomeArquivo);
				
				$filtroAguardar = '{"cod":"700799","params":[
					{"name":"not_codigo","value":"'.$_REQUEST["not_codigo"].'","type":"string"}
				]}';
				$Datapacket->clear();
				$Datapacket->add($filtroAguardar);
				$Datapacket->open();
				$Datapacket->clear();
				
			}
				
			
		}
	}

	/*
	if ($resp) {
		header('Content-type: text/xml; charset=UTF-8');
		echo $nfe->getXML();
	} else {
		header('Content-type: text/html; charset=UTF-8');
		foreach ($nfe->erros as $err) {
			echo 'tag: &lt;'.$err['tag'].'&gt; ---- '.$err['desc'].'<br>';
		}
	}
	*/
	
?>