<?php 
/*
* Classe para definicao das propriedades de um documento, pode ser utilizado em remessa ou retorno
*/
class Documento{
	
	/*
	layout da remessa, padrao febraban de 240 posições
	*/
	public $layout = "FEBRABAN240";
	
	/*
	Código do Banco na Compensação
	G001 tamanho 3 posição 1-3
	*/
	public $banco = "000";
	
	/*
	Lote de Serviço 
	G002 tamanho 4 posição 4-7
	*/
	public $lote = "0001";
	
/*	
	Tipo de Registro
	G003 tamanho 1 posição 8-8
	
	public $registro = "1";*/
	

	/*
	Tipo de Operação
	G028 tamanho 1 posição 9-9
	*/
	public $operacao = "R";
	
	
	/*
	Tipo de Serviço
	G025 tamanho 2 posição 10-11
	*/
	public $servico = "01";
	

	/*
	Uso Exclusivo FEBRABAN/CNAB
	G004 tamanho 2 posição 12-13
	*/
	public $cnab = "  ";
	
	

	/*
	Nº da Versão do Layout do Lote
	G030 tamanho 3 posição 14-16
	*/
	public $layoutLote = "045";
	

	/*
	Tipo de Inscrição da Empresa
	G005 tamanho 1 posição 18-18
	*/
	public $inscricaoTipo = "0";


	/*
	Nº de Inscrição da Empresa
	G006 tamanho 15 posição 19-33
	*/
	public $inscricaoNumero = "000000000000000";
	

	/*
	Código do Convênio no Banco
	G007 tamanho 20 posição 34-53
	*/
	public $convenio = "                    ";
	
	
	/*
	Contrato ou código de transmissão (somente para alguns bancos)
	tamanho 15 posição 54-68
	*/
	public $contrato = "               ";



	/*
	Agência Mantenedora da Conta
	G008 tamanho 5 posição 54-58
	*/
	public $agenciaCodigo = "00000";



	/*
	Dígito Verificador da Conta
	G009 tamanho 1 posição 59-59
	*/
	public $agenciaDv = " ";



	/*
	Número da Conta Corrente
	G010 tamanho 12 posição 60-71
	*/
	public $contaNumero = "000000000000";


	/*
	Número da Conta Corrente
	G011 tamanho 1 posição 72-72
	*/
	public $contaDv = " ";


	/*
	Dígito Verificador da Ag/Conta 
	G012 tamanho 1 posição 73-73
	*/
	public $dv = " ";



	/*
	Nome da Empresa 
	G013 tamanho 30 posição 74-103
	*/
	public $empresaNome = "                              ";



	/*
	Mensagem 1
	C073 tamanho 40 posição 104-143
	*/
	public $informacao1 = "                                        ";


	/*
	Mensagem 2
	C073 tamanho 40 posição 144-183
	*/
	public $informacao2 = "                                        ";

	

	/*
	Número Remessa/Retorno 
	G079 tamanho 8 posição 184-191
	*/
	public $numeroRemessaRetorno = "00000000";



	/*
	Data de Gravação Remessa/Retorno
	G068 tamanho 8 posição 192-199
	*/
	public $dataGravacaoRemecaRetorno = "00000000";


	/*
	Data do Crédito 
	C003 tamanho 8 posição 200-207
	*/
	public $dataCredito = "        ";



	/*
	Uso Exclusivo FEBRABAN/CNAB
	G004 tamanho 33 posição 208-240
	*/
	public $cnabFinalHeader = "                                 ";




	/*
	Nº Sequencial do Registro no Lote
	G038 tamanho 5 posição 9-13
	*/
	public $numeroRegistro = "00000";

	/*
	Código de Movimento Remessa 
	C004 tamanho 2 posição 16-17
	*/
	public $codigoMovimento = "00";
	
	/*
	Motivo da Ocorrência  do retorno 
	C047 tamanho 10 posição 214-223
	*/
	public $motivo = "0000000000";

	/*
	Identificação do Título no Banco 
	G069 tamanho 20 posição 38-57
	*/
	public $nossoNumero = "                    ";

	/*
	Código da Carteira
	C006 tamanho 1 posição 58-58
	*/
	public $carteira = "0";
	
	public $numeroCarteira = "000";

	/*
	Forma de Cadastr. do Título no Banco
	C007 tamanho 1 posição 59-59
	*/
	public $cadastramento = "1";

	/*
	Tipo de Documento
	C008 tamanho 1 posição 60-60
	*/
	public $documento = "2";

	/*
	Identificação da Emissão do Bloqueto
	C009 tamanho 1 posição 61-61
	*/
	public $emissaoBloqueto = "2";

	/*
	Identificação da Distribuição 
	C010 tamanho 1 posição 62-62
	*/
	public $distribuicaoBloqueto = "2";


	/*
	Número do Documento de Cobrança
	C011 tamanho 15 posição 63-77
	*/
	public $numeroDocumento = "               ";

	/*
	Data de Vencimento do Título
	C012 tamanho 8 posição 78-85
	*/
	public $vencimento = "00000000";


	/*
	Valor Nominal do Título
	C070 tamanho 13 posição 86-100
	*/
	public $valorTitulo = "000000000000000";

	
	/*
	Agência Encarregada da Cobrança
	C014 tamanho 5 posição 101-105
	*/
	public $agenciaCobradora = "00000";
	
	/*
	Agência Encarregada da DV
	C014 tamanho 5 posição 101-105
	*/
	public $agenciaCobradoraDv = " ";


	/*
	Espécie do Título 
	C015 tamanho 2 posição 107-108
	*/
	public $especieTitulo = "02";


	/*
	Identific. de Título Aceito/Não Aceito
	C016 tamanho 1 posição 109-109
	*/
	public $aceite = "N";


	/*
	Data Emissão do Título
	G071 tamanho 8 posição 110-117
	*/
	public $dataEmissaoTitulo = "00000000";



	/*
	Código do Juros de Mora
	C018 tamanho 1 posição 118-118
	*/
	public $codigoJurosMora = "1";


	/*
	Data do Juros de Mora
	C019 tamanho 8 posição 119-126
	*/
	public $dataJurosMora = "00000000";


	/*
	Juros de Mora por Dia/Taxa 
	C020 tamanho 13 posição 127-141
	*/
	public $jurosMora = "000000000000000";


	/*
	Código do Desconto 1
	C021 tamanho 1 posição 142-142
	*/
	public $codigoDesconto1 = "0";

	/*
	Data do Desconto 1 
	C022 tamanho 8 posição 143-150
	*/
	public $dataDesconto1 = "00000000";


	/*
	Valor/Percentual a ser Concedido
	C023 tamanho 13 posição 151-165
	*/
	public $desconto1 = "000000000000000";


	/*
	Valor do IOF a ser Recolhido 
	C024 tamanho 13 posição 166-180
	*/
	public $valorIof = "000000000000000";


	/*
	Valor do Abatimento 
	G045 tamanho 13 posição 181-195
	*/
	public $valorAbatimento = "000000000000000";


	/*
	Identificação do Título na Empresa  
	G072 tamanho 25 posição 196-220
	*/
	public $usoEmpresaCedente = "                         ";


	/*
	Código para Protesto  
	C026 tamanho 1 posição 221-221
	*/
	public $codigoProtesto = "0";


	/*
	Número de Dias para Protesto   
	C027 tamanho 2 posição 222-223
	*/
	public $prazoProtesto = "00";


	/*
	Código para Baixa/Devolução   
	C028 tamanho 1 posição 224-224
	*/
	public $codigoBaixaDevolucao = "0";


	/*
	Número de Dias para Baixa/Devolução   
	C029 tamanho 3 posição 225-227
	*/
	public $prazoBaixaDevolucao = "000";


	/*
	Código da Moeda  
	G065 tamanho 2 posição 228-229
	*/
	public $codigoMoeda = "09";


	/*
	Nº do Contrato da Operação de Créd. 
	C030 tamanho 10 posição 230-239
	*/
	public $numeroContrato = "0000000000";


	/*
	Uso livre banco/empresa ou autorização de pagamento parcial  
	C078 tamanho 1 posição 240-240
	*/
	public $usoLivreBancoEmpresa = " ";


	
	
	/*
	Tipo de inscrição do sacado
	G005 tamanho 1 posição 18-18
	*/
	public $inscricaoTipoSacado = "0";
	
	/*
	Número de inscrição do sacado
	G005 tamanho 15 posição 19-33
	*/
	public $inscricaoNumeroSacado = "000000000000000";
	
	/*
	Nome do Sacado
	G032 tamanho 40 posição 34-73
	*/
	public $sacadoNome = "                                        ";


	/*
	Endereço
	G032 tamanho 40 posição 74-113
	*/
	public $endereco = "                                        ";



	/*
	Bairro
	G032 tamanho 15 posição 114-128
	*/
	public $bairro = "               ";


	/*
	CEP
	G034 tamanho 5 posição 129-133
	*/
	public $cep = "00000000";


	/*
	Cidade
	G033 tamanho 15 posição 137-151
	*/
	public $cidade = "               ";


	/*
	Unidade da Federação
	G036 tamanho 2 posição 152-153
	*/
	public $uf = "  ";


	
	/*
	Tipo de Inscrição do Sacador/ Avalista
	G005 tamanho 1 posição 154-154
	*/
	public $inscricaoTipoSacadorAvalista = "0";
	
	/*
	Tipo de Inscrição do Sacador/ Avalista
	G006 tamanho 15 posição 155-169
	*/
	public $inscricaoNumeroSacadorAvalista = "000000000000000";
	
	/*
	Nome do Sacador/ Avalista
	G013 tamanho 40 posição 170-209
	*/
	public $nomeSacadorAvalista = "                                        ";



	/*
	Cód. Bco. Corresp. na Compensação 
	C031 tamanho 3 posição 210-212
	*/
	public $bancoCorrespondente = "000";



	/*
	Nosso Nº no Banco Correspondente 
	C032 tamanho 20 posição 213-232
	*/
	public $nossoNumeroBancoCorrespondente = "                    ";


	/*
	Uso Exclusivo FEBRABAN/ CNAB
	C032 tamanho 8 posição 233-240
	*/
	public $cnabFinalSegmentoQ = "        ";


	/*
	Código do Desconto 2
	C021 tamanho 1 posição 18-18
	*/
	public $codigoDesconto2 = "0";

	/*
	Data do Desconto 2 
	C022 tamanho 8 posição 19-26
	*/
	public $dataDesconto2 = "00000000";


	/*
	Valor/Percentual a ser Concedido
	C023 tamanho 13 posição 26-41
	*/
	public $desconto2 = "000000000000000";


	/*
	Código do Desconto 3
	C021 tamanho 1 posição 42-42
	*/
	public $codigoDesconto3 = "0";

	/*
	Data do Desconto 3 
	C022 tamanho 8 posição 43-50
	*/
	public $dataDesconto3 = "00000000";


	/*
	Valor/Percentual a ser Concedido
	C023 tamanho 13 posição 51-65
	*/
	public $desconto3 = "000000000000000";


	/*
	Código da Multa
	C021 tamanho 1 posição 66-66
	*/
	public $codigoMulta = "2";

	/*
	Data da Multa 
	C022 tamanho 8 posição 67-74
	*/
	public $dataMulta = "00000000";


	/*
	Valor/Percentual a Ser Aplicado
	C023 tamanho 13 posição 75-89
	*/
	public $multa = "000000000000000";



	/*
	Informação ao Sacado 
	C036 tamanho 10 posição 90-99
	*/
	public $informacaoSacado = "          ";



	/*
	Mensagem 3
	C037 tamanho 40 posição 100-139
	*/
	public $informacao3 = "                                        ";


	/*
	Mensagem 4
	C037 tamanho 40 posição 140-179
	*/
	public $informacao4 = "                                        ";



	/*
	Uso Exclusivo FEBRABAN/CNAB 
	G004 tamanho 20 posição 180-199
	*/
	public $cnabR = "                    ";


	/*
	Cód. Ocor. do Sacado
	C038 tamanho 8 posição 200-207
	*/
	public $codOcoSacado = "        ";



	/*
	Cód. do Banco na Conta do Débito
	G001 tamanho 3 posição 208-210
	*/
	public $debitoBanco = "   ";


	/*
	Código da Agência do Débito 
	G008 tamanho 5 posição 211-215
	*/
	public $debitoAgencia = "     ";


	/*
	Dígito Verificador da Agência
	G009 tamanho 1 posição 216-216
	*/
	public $debitoAgenciaDv = " ";



	/*
	Conta Corrente para Débito
	G010 tamanho 12 posição 217-228
	*/
	public $debitoContaCorrente = "            ";


	/*
	Dígito Verificador da Conta
	G011 tamanho 1 posição 229-229
	*/
	public $debitoContaCorrenteDv = " ";


	/*
	Dígito Verificador Ag/Conta
	G012 tamanho 1 posição 230-230
	*/
	public $debitoAgenciaContaDv = " ";


	/*
	Aviso para Débito Automático 
	C039 tamanho 1 posição 231-231
	*/
	public $identificacaoAvisoDebito = " ";


	/*
	Uso Exclusivo FEBRABAN/CNAB 
	G004 tamanho 9 posição 232-240
	*/
	public $cnabFinalSegmentoR = "         ";



	/*
	Identificação da Impressão
	C040 tamanho 1 posição 18-18
	*/
	public $tipoImpressao = "0";

	/*
	Número da Linha a ser Impressa 
	C041 tamanho 2 posição 19-20
	*/
	public $numeroLinha = "00";


	/*
	Mensagem a ser Impressa 
	C042 tamanho 140 posição 21-160
	*/
	public $mensagem = "                                                                                                                                            ";


	/*
	Número da Linha a ser Impressa 
	C043 tamanho 2 posição 161-162
	*/
	public $tipoFonte = "00";


	/*
	Número da Linha a ser Impressa 
	G004 tamanho 2 posição 163-240
	*/
	public $cnabFinalSegmentoS = "                                                                              ";



	/*
	Uso Exclusivo FEBRABAN/CNAB
	G004 tamanho 9 posição 9-17
	*/
	public $cnabTrailer = "         ";

	
	/*
	Quantidade de Registros no Lote
	G057 tamanho 6 posição 18-23
	*/
	public $quantidadeRegistro = "000000";

	/*
	Quantidade de Títulos em Cobrança 
	C070 tamanho 6 posição 24-29
	*/
	public $quantidadeTituloCombrancaSimples = "      ";

	/*
	Valor Total dos Títulos em Carteiras 
	C071 tamanho 17 posição 30-46
	*/
	public $valorTotalTituloCarteiraSimples = "                 ";

	
	/*
	Quantidade de Títulos em Cobrança 
	C070 tamanho 6 posição 47-52
	*/
	public $quantidadeTituloCombrancaVinculada = "      ";

	
	/*
	Valor Total dos Títulos em Carteiras 
	C071 tamanho 17 posição 53-69
	*/
	public $valorTotalTituloCarteiraVinculada = "                 ";


	/*
	Quantidade de Títulos em Cobrança 
	C070 tamanho 6 posição 70-75
	*/
	public $quantidadeTituloCombrancaCaucionada = "      ";

	/*
	Valor Total dos Títulos em Carteiras 
	C071 tamanho 17 posição 76-92
	*/
	public $valorTotalTituloCarteiraCaucionada = "                 ";

	/*
	Quantidade de Títulos em Cobrança 
	C070 tamanho 6 posição 93-98
	*/
	public $quantidadeTituloCombrancaDescontada = "      ";

	/*
	Valor Total dos Títulos em Carteiras 
	C071 tamanho 17 posição 99-115
	*/
	public $valorTotalTituloCarteiraDescontada = "                 ";


	/*
	Número do Aviso de Lançamento 
	C072 tamanho 8 posição 116-123
	*/
	public $numeroAviso = "        ";


	/*
	Número do Aviso de Lançamento 
	G004 tamanho 117 posição 124-240
	*/
	public $cnabFinalTrailer = "                                                                                                                     ";
	
	/*
	numero da parcela
	tamanho 2 posição 75-76 (400 posicoes somente)
	*/
	public $parcela = "01";
	
	/*
	variacao da carteira
	tamanho 3 posição 86-88 (400 posicoes somente)
	*/
	public $variacao = "000";
	
	/*
	valor da tarifa bancaria (retorno somente)
	tamanho 7 posição 182-188
	*/
	public $valorTarifa = "0000000";
	
	/*
	valor recebido (retorno somente)
	tamanho 13 posição 254-266
	*/
	public $valorRecebido = "000000000000";
	
	/*
	valor do lançamento (retorno somente)
	tamanho 13 posição 306-318
	*/
	public $valorLancamento = "000000000000";
	
	
	
	/*construtor padrão*/
	public function __construct($layout='FEBRABAN240', $banco="001"){
		$this->dataGravacaoRemecaRetorno = date("dmY");
		$this->layout = $layout;
		$this->banco = $banco;

		if($this->layout=="CNAB400" || $this->layout=="CBR641"){
			
			$this->inscricaoTipo = "00"; // tamanho 2 2-3
			$this->inscricaoNumero = "00000000000000"; // tamanho 14 4-17
			$this->agenciaCodigo = "0000"; // tamanho 4 18-21
			$this->contaNumero = "00000000"; // tamanho 8 23-30
			
			if($this->layout=="CBR641"){
				$this->convenio = "0000000"; // tamanho 7 32-38
				$this->nossoNumero = "00000000000000000"; // tamanho 17 64-80
				$this->jurosMora = "0000000000000"; // tamanho 11
				$this->multa = "000000000000"; // tamanho 12
				$this->desconto1 = "0000000000000";
				$this->valorIof = "0000000000000";
				$this->valorAbatimento = "0000000000000";
				$this->sacadoNome = "                                     ";
				$this->bairro = "            ";
				$this->carteira = "00";
			}else{
				$this->convenio = "000000"; // tamanho 6 32-37
				$this->nossoNumero = "000000000000"; // tamanho 12 63-74
				$this->jurosMora = "000000"; // tamanho 6 161-166
				$this->multa = "000000"; // tamanho 6 167-172
				if( $this->banco==341){
					$this->endereco = "                                        "; // tamanho 37 275-314
					$this->bairro = "            "; // tamanho 12
				}else{
					$this->endereco = "                                     "; // tamanho 37 275-311
				}
			}
			
			$this->numeroDocumento = "          "; // tamanho 10 111-120
			$this->vencimento = "000000"; // tamanho 6 121-126
			$this->valorTitulo = "0000000000000"; // tamanho 13 127-139
			$this->dataEmissaoTitulo = "000000"; // tamanho 6 151-156
			$this->dataJurosMora = "000000"; // tamanho 6 174-179
			$this->dataMulta = "000000";
			$this->inscricaoTipoSacado = "00"; // tamanho 2 219-220
			$this->inscricaoNumeroSacado = "00000000000000"; // tamanho 14 221-234
			
			$this->numeroRegistro = "000001"; // tamanho 6 395-400
			
			if($this->banco=="341"){
				$this->contaNumero = "00000";
				$this->numeroDocumento = "                         ";
				$this->nossoNumero = "00000000";
				$this->jurosMora = "0000000000000";
				$this->desconto1 = "0000000000000";
				$this->valorIof = "0000000000000";
				$this->valorAbatimento = "0000000000000";
			}elseif($this->banco=="237"){
				$this->numeroCarteira = "0000";
				$this->contaNumero = "000000";
				$this->multa = "0000";
				$this->nossoNumero = "000000000000";
				$this->jurosMora = "0000000000000";
				$this->especieTitulo = "01";
				$this->desconto1 = "0000000000000";
				$this->valorIof = "0000000000000";
				$this->endereco = "                                        ";
				$this->valorAbatimento = "0000000000000";
				$this->dataDesconto1 = "000000";
			}elseif($this->banco=="748"){
				$this->codigoMoeda = "A";
				$this->especieTitulo = "A";
				$this->codigoDesconto1 = "A";
				$this->codigoJurosMora = "A";
				$this->nossoNumero = "000000000";
				$this->multa = "0000";
				$this->codigoProtesto = "00";
				$this->inscricaoTipoSacado = "0";
				$this->nomeSacadorAvalista = "                                         ";
				$this->convenio = "00000";
				$this->jurosMora = "0000000000000";
				$this->multa = "0000";
				$this->endereco = "                                        ";
				$this->inscricaoNumeroSacadorAvalista = "00000000000000";
			}
			
		}elseif($this->layout=="FEBRABAN240"){
			
			if($this->banco=="033"){
				$this->agenciaCodigo = "0000";
				$this->contaNumero = "000000000";
				$this->convenio = "                    ";
				$this->dv = "0000000000  ";
				$this->nossoNumero = "             ";
				$this->codigoMoeda = "00";
				$this->numeroContrato = "          ";
				$this->emissaoBloqueto = " ";
				$this->distribuicaoBloqueto = " ";
				$this->codigoDesconto3 = "";
				$this->dataDesconto3 = "";
				$this->desconto3 = "                        ";
				$this->nossoNumeroBancoCorrespondente = "000000000           ";
			}elseif($this->banco=="237"){
				$this->numeroDocumento = "000000000000000";
			}elseif($this->banco=='756'){
				$this->dataCredito="00000000";
				$this->codOcoSacado="00000000";
				$this->debitoContaCorrente="000000000000";
				$this->debitoContaCorrenteDv="0";
				$this->debitoAgencia="00000";
				$this->debitoBanco="000";
				$this->identificacaoAvisoDebito="0";
				$this->quantidadeTituloCombrancaSimples="000000";
				$this->valorTotalTituloCarteiraSimples="00000000000000000";
				$this->quantidadeTituloCombrancaVinculada="000000";
				$this->valorTotalTituloCarteiraVinculada="00000000000000000";
				$this->quantidadeTituloCombrancaCaucionada="000000";
				$this->valorTotalTituloCarteiraCaucionada="00000000000000000";
				$this->quantidadeTituloCombrancaDescontada="000000";
				$this->valorTotalTituloCarteiraDescontada="00000000000000000";
			}
			
		}elseif( $this->layout=="SIGCB240" ){
			$this->cnab="00";
			$this->convenio="000000";
			$this->nossoNumero="00000000000000000";
			$this->carteira="1";
			$this->numeroDocumento="           ";
			$this->dataCredito="00000000";
			$this->distribuicaoBloqueto="0";
			$this->quantidadeTituloCombrancaSimples="000000";
			$this->valorTotalTituloCarteiraSimples="00000000000000000";
			$this->quantidadeTituloCombrancaCaucionada="000000";
			$this->valorTotalTituloCarteiraCaucionada="00000000000000000";
			$this->quantidadeTituloCombrancaVinculada="000000";
			$this->valorTotalTituloCarteiraVinculada="00000000000000000";
			$this->quantidadeTituloCombrancaDescontada="000000";
			$this->valorTotalTituloCarteiraDescontada="00000000000000000";
			$this->agenciaCobradoraDv="0";
		}
		
	}

	
	/**
	* _set
	* Atribui valores para propriedades da classe
	* @param string $prop propriedade que deseja utilizar
	* @param string $value valor para ser armazenado na prop informada
	* @return $this
	*/
	public function _set($prop,$value){
		if(property_exists($this,$prop)){
			
			$arr1 = array("á", "à", "ã", "â", "Á", "À", "Ã", "Â", "é", "ê", "É", "Ê", "í", "Í", "ó", "õ", "ô", "Ó", "Ô", "Õ", "ú", "ü", "Ú", "Ü", "ç", "Ç", "º", "ª", "\"", "'", "&");
			$arr2 = array("a", "a", "a", "a", "A", "A", "A", "A", "e", "e", "E", "E", "i", "I", "o", "o", "o", "O", "O", "O", "u", "u", "U", "U", "c", "C", "", "", "", "", "E");
			$value = strtoupper(str_replace($arr1, $arr2, $value));
			
			switch($prop){
				case 'inscricaoNumero':
					if(strlen($value)>11){
						$this->_set('inscricaoTipo', '2');
					}else{
						$this->_set('inscricaoTipo', '1');
					}
					break;
				case 'inscricaoNumeroSacado':
					if(strlen($value)>11){
						$this->_set('inscricaoTipoSacado', '2');
					}else{
						$this->_set('inscricaoTipoSacado', '1');
					}
					break;
				case 'inscricaoNumeroSacadorAvalista':
					if(strlen($value)>11){
						$this->_set('inscricaoTipoSacadorAvalista', '2');
					}elseif(strlen($value)==11){
						$this->_set('inscricaoTipoSacadorAvalista', '1');
					}else{
						$this->_set('inscricaoTipoSacadorAvalista', '0');
					}
					break;
				case "vencimento":
				case "dataEmissaoTitulo":
				case "dataJurosMora":
				case "dataMulta":
					if( $this->layout=="CNAB400" || $this->layout=="CBR641" ){
						$value = substr($value, 0, 4).substr($value, 6, 2);
					}
					break;
				case "multa":
					if($this->layout=="CNAB400" || $this->banco=="237"){
						$this->codigoMulta = ((float)$value>0) ? "2" : "0";
					}
					break;
				case "jurosMora":
					if( ($this->layout=="FEBRABAN240" || $this->layout=="SIGCB240") && $value==0){
						if($this->banco=='756'){
							$this->_set('codigoJurosMora', '0');
						}else{
							$this->_set('codigoJurosMora', '3');
						}
						$this->_set('dataJurosMora', '00000000');
					}elseif( $this->layout=="SIGCB240" && $value>0 ){
						$this->_set('codigoJurosMora', '2');
					}
					break;
				case "numeroDocumento":
					$value = str_replace("-", "", $value);
					if( $this->layout=="SIGCB240" ){
						$this->_set('usoEmpresaCedente', $value);
					}elseif( $this->layout=="FEBRABAN240" && $this->banco=="237" ){
						$value = substr($value, -9);
					}
					break;
				case "nossoNumero":
					if( $this->layout=="CNAB400" && $this->banco==341 ){
						$value = substr($value, 0, -1);
					}elseif( $this->layout=='FEBRABAN240' && $this->banco=='756' ){
						$value = str_pad($value,10,"0",STR_PAD_LEFT)."01014     ";
					}elseif( $this->banco=='748' ){
						$value = str_replace(array("/","-"),"",$value);
					}
					break;
			}
			
			$tam = strlen($this->$prop);
			if( is_numeric($this->$prop) ){
				if($value>0 && strstr($value, ".")){
					//juros com 5 casas decimais quando percentual
					if($prop=="jurosMora" && $this->layout=="FEBRABAN240" && $this->codigoJurosMora=="2"){
						$value = number_format($value, 5, "", "");
					}elseif( ($prop=="jurosMora" || $prop=="multa") && $this->banco=="756" && $this->layout=="CNAB400" ){
						$value = number_format($value, 4, "", "");
					}else{
						$value = number_format($value, 2, "", "");
					}
				}elseif($value==0 &&  strstr($value, ".")){
					$value = $this->$prop;
				}
				// $value = (int) $value;
				$this->$prop = substr((string)$value, 0, $tam);
				$this->$prop = str_pad((string)$this->$prop, $tam, "0", STR_PAD_LEFT);
			}else{
				$this->$prop = substr($value, 0, $tam);
				$this->$prop = str_pad($this->$prop, $tam, " ", STR_PAD_RIGHT);
			}
			
		}else{
			throw new Exception("Propriedade ".$prop." inexistente do Documento");
		}
		return $this;
	}
	
	/**
	* headerLote
	* Monta a linha de cabeçalho do lote do arquivo de remessa, usando as propriedades do documento de acordo com o layout inofrmado
	* @return string $linha string com a linha completa do cabeçalho do lote
	*/
	public function headerLote(){
		$headerLote = "";
		
		if($this->layout=="FEBRABAN240"){
			if($this->banco=="033"){
				$headerLote = $this->banco.$this->lote."1".$this->operacao.$this->servico.$this->cnab.$this->layoutLote." ".$this->inscricaoTipo.$this->inscricaoNumero."                    ".$this->convenio.$this->empresaNome.$this->informacao1.$this->informacao2.$this->numeroRemessaRetorno.$this->dataGravacaoRemecaRetorno.$this->dataCredito.$this->cnabFinalHeader."\n";
			}else{
				$headerLote = $this->banco.$this->lote."1".$this->operacao.$this->servico.$this->cnab.$this->layoutLote." ".$this->inscricaoTipo.$this->inscricaoNumero.$this->convenio.$this->agenciaCodigo.$this->agenciaDv.$this->contaNumero.$this->contaDv.$this->dv.$this->empresaNome.$this->informacao1.$this->informacao2.$this->numeroRemessaRetorno.$this->dataGravacaoRemecaRetorno.$this->dataCredito.$this->cnabFinalHeader."\n";
			}
		}elseif( $this->layout=="SIGCB240" ){
			$headerLote = $this->banco.$this->lote."1".$this->operacao.$this->servico.$this->cnab.$this->layoutLote." ".$this->inscricaoTipo.$this->inscricaoNumero.$this->convenio."00000000000000".$this->agenciaCodigo.$this->agenciaDv.$this->convenio."00000000".$this->empresaNome.$this->informacao1.$this->informacao2.$this->numeroRemessaRetorno.$this->dataGravacaoRemecaRetorno.$this->dataCredito.$this->cnabFinalHeader."\n";
		}
		
		return $headerLote;
	}
	
	/**
	* detalheLote
	* Monta as linhas correspondentes aos detalhes do lote do arquivo de remessa, usando as propriedades do documento de acordo com o layout inofrmado
	* @return string $linha string com as linhas completas dos detalhes do lote
	*/
	public function detalheLote(){
		$detalheLote = "";
		
		//240 posições
		if( $this->layout=="FEBRABAN240" ){
			/*
			* segmentoP (Obrigatório na remessa)
			* segmentoQ (Obrigatório na remessa)
			* segmentoR (Opcional remessa)
			* segmentoS (Ocional remessa)
			* Monta a linha correspondenete aos segmentos do lote do arquivo de remessa, usando as propriedades do documento de acordo com o layout inofrmado
			*/
			$this->_set('numeroRegistro', $this->numeroRegistro+1); //incrementa registro
			
			$segmentoP = $this->banco.$this->lote."3".$this->numeroRegistro."P ".$this->codigoMovimento.$this->agenciaCodigo.$this->agenciaDv.$this->contaNumero.$this->contaDv.$this->dv.$this->nossoNumero.$this->carteira.$this->cadastramento.$this->documento.$this->emissaoBloqueto.$this->distribuicaoBloqueto.$this->numeroDocumento.$this->vencimento.$this->valorTitulo.$this->agenciaCobradora.$this->agenciaCobradoraDv.$this->especieTitulo.$this->aceite.$this->dataEmissaoTitulo.$this->codigoJurosMora.$this->dataJurosMora.$this->jurosMora.$this->codigoDesconto1.$this->dataDesconto1.$this->desconto1.$this->valorIof.$this->valorAbatimento.$this->usoEmpresaCedente.$this->codigoProtesto.$this->prazoProtesto.$this->codigoBaixaDevolucao.$this->prazoBaixaDevolucao.$this->codigoMoeda.$this->numeroContrato.$this->usoLivreBancoEmpresa."\n";
			
			$this->_set('numeroRegistro', $this->numeroRegistro+1); //incrementa registro

			$segmentoQ = $this->banco.$this->lote."3".$this->numeroRegistro."Q ".$this->codigoMovimento.$this->inscricaoTipoSacado.$this->inscricaoNumeroSacado.$this->sacadoNome.$this->endereco.$this->bairro.$this->cep.$this->cidade.$this->uf.$this->inscricaoTipoSacadorAvalista.$this->inscricaoNumeroSacadorAvalista.$this->nomeSacadorAvalista.$this->bancoCorrespondente.$this->nossoNumeroBancoCorrespondente.$this->cnabFinalSegmentoQ."\n";
			
			$this->_set('numeroRegistro', $this->numeroRegistro+1); //incrementa registro

			$segmentoR = $this->banco.$this->lote."3".$this->numeroRegistro."R ".$this->codigoMovimento.$this->codigoDesconto2.$this->dataDesconto2.$this->desconto2.$this->codigoDesconto3.$this->dataDesconto3.$this->desconto3.$this->codigoMulta.$this->dataMulta.$this->multa.$this->informacaoSacado.$this->informacao3.$this->informacao4.$this->cnabR.$this->codOcoSacado.$this->debitoBanco.$this->debitoAgencia.$this->debitoAgenciaDv.$this->debitoContaCorrente.$this->debitoContaCorrenteDv.$this->debitoAgenciaContaDv.$this->identificacaoAvisoDebito.$this->cnabFinalSegmentoR."\n";
			
			// $this->_set('numeroRegistro', $this->numeroRegistro+1); //incrementa registro

			// $segmentoS = $this->banco.$this->lote."3".$this->numeroRegistro."S ".$this->codigoMovimento.$this->tipoImpressao.$this->numeroLinha.$this->mensagem.$this->tipoFonte.$this->cnabFinalSegmentoS."\n"; // nao utilizado
			
			$detalheLote = $segmentoP.$segmentoQ.$segmentoR;
		
		//240 posições (caixa)
		}elseif( $this->layout=="SIGCB240" ){
			
			/*
			* segmentoP (Obrigatório na remessa)
			* segmentoQ (Obrigatório na remessa)
			* segmentoR (Opcional remessa)
			* Monta a linha correspondenete aos segmentos do lote do arquivo de remessa, usando as propriedades do documento de acordo com o layout inofrmado
			*/
			$this->_set('numeroRegistro', $this->numeroRegistro+1); //incrementa registro
			
			$segmentoP = $this->banco.$this->lote."3".$this->numeroRegistro."P ".$this->codigoMovimento.$this->agenciaCodigo.$this->agenciaDv.$this->convenio."00000000000".$this->nossoNumero.$this->carteira.$this->cadastramento.$this->documento.$this->emissaoBloqueto.$this->distribuicaoBloqueto.$this->numeroDocumento."    ".$this->vencimento.$this->valorTitulo.$this->agenciaCobradora.$this->agenciaCobradoraDv.$this->especieTitulo.$this->aceite.$this->dataEmissaoTitulo.$this->codigoJurosMora.$this->dataJurosMora.$this->jurosMora.$this->codigoDesconto1.$this->dataDesconto1.$this->desconto1.$this->valorIof.$this->valorAbatimento.$this->usoEmpresaCedente.$this->codigoProtesto.$this->prazoProtesto.$this->codigoBaixaDevolucao.$this->prazoBaixaDevolucao.$this->codigoMoeda.$this->numeroContrato.$this->usoLivreBancoEmpresa."\n";
			
			$this->_set('numeroRegistro', $this->numeroRegistro+1); //incrementa registro

			$segmentoQ = $this->banco.$this->lote."3".$this->numeroRegistro."Q ".$this->codigoMovimento.$this->inscricaoTipoSacado.$this->inscricaoNumeroSacado.$this->sacadoNome.$this->endereco.$this->bairro.$this->cep.$this->cidade.$this->uf.$this->inscricaoTipoSacadorAvalista.$this->inscricaoNumeroSacadorAvalista.$this->nomeSacadorAvalista.$this->bancoCorrespondente.$this->nossoNumeroBancoCorrespondente.$this->cnabFinalSegmentoQ."\n";
			
			$this->_set('numeroRegistro', $this->numeroRegistro+1); //incrementa registro

			$segmentoR = $this->banco.$this->lote."3".$this->numeroRegistro."R ".$this->codigoMovimento.$this->codigoDesconto2.$this->dataDesconto2.$this->desconto2.$this->codigoDesconto3.$this->dataDesconto3.$this->desconto3.$this->codigoMulta.$this->dataMulta.$this->multa.$this->informacaoSacado.$this->informacao3.$this->informacao4.$this->cnabR.$this->codOcoSacado.$this->debitoBanco.$this->debitoAgencia.$this->debitoAgenciaDv.$this->debitoContaCorrente.$this->debitoContaCorrenteDv.$this->debitoAgenciaContaDv.$this->identificacaoAvisoDebito.$this->cnabFinalSegmentoR."\n";
			
			$detalheLote = $segmentoP.$segmentoQ.$segmentoR;
			
		//400 posições
		}elseif( $this->layout=="CNAB400" ){
			
			$this->_set('numeroRegistro', $this->numeroRegistro+1);
			
			if( $this->banco=="341" ){
				
				$detalheLote = "1".$this->inscricaoTipo.$this->inscricaoNumero.$this->agenciaCodigo."00".$this->contaNumero.$this->contaDv."    0000".$this->numeroDocumento.$this->nossoNumero."0000000000000".$this->numeroCarteira."                     ".$this->carteira.$this->codigoMovimento.substr($this->numeroDocumento,0,10).$this->vencimento.$this->valorTitulo.$this->banco."0".$this->agenciaCodigo."99N".$this->dataEmissaoTitulo."4300".$this->jurosMora.$this->dataJurosMora.$this->desconto1.$this->valorIof.$this->valorAbatimento.$this->inscricaoTipoSacado.$this->inscricaoNumeroSacado.$this->sacadoNome.$this->endereco.$this->bairro.$this->cep.$this->cidade.$this->uf.$this->nomeSacadorAvalista.$this->prazoProtesto." ".$this->numeroRegistro."\r\n";
			
			}elseif( $this->banco=="237" ){
				
				$detalheLote = "100000 000000000000 0".$this->numeroCarteira.$this->agenciaCodigo."0".$this->contaNumero.$this->contaDv."                         000".$this->codigoMulta.$this->multa.$this->nossoNumero."00000000002N              ".$this->codigoMovimento.$this->numeroDocumento.$this->vencimento.$this->valorTitulo."00000000".$this->especieTitulo."N".$this->dataEmissaoTitulo."0000".$this->jurosMora.$this->dataDesconto1.$this->desconto1.$this->valorIof.$this->valorAbatimento.$this->inscricaoTipoSacado.$this->inscricaoNumeroSacado.$this->sacadoNome.$this->endereco."            ".$this->cep."                                                            ".$this->numeroRegistro."\r\n";
			
			}elseif( $this->banco=="756" ){
				
				$detalheLote = "1".$this->inscricaoTipo.$this->inscricaoNumero.$this->agenciaCodigo.$this->agenciaDv.$this->contaNumero.$this->contaDv."000000                         ".$this->nossoNumero.$this->parcela."00       ".$this->variacao."0000000000000    201".$this->codigoMovimento.$this->numeroDocumento.$this->vencimento.$this->valorTitulo.$this->banco.$this->agenciaCodigo.$this->agenciaDv."990".$this->dataEmissaoTitulo."4300".$this->jurosMora.$this->multa."2000000000000000000".$this->codigoMoeda."0000000000000000000000000".$this->inscricaoTipoSacado.$this->inscricaoNumeroSacado.$this->sacadoNome.$this->endereco.$this->bairro.$this->cep.$this->cidade.$this->uf.$this->nomeSacadorAvalista.$this->prazoProtesto." ".$this->numeroRegistro."\n";				
			
			}elseif( $this->banco=="748" ){
				
				$detalheLote = "1".$this->carteira.$this->carteira.$this->carteira."            ".$this->codigoMoeda.$this->codigoDesconto1.$this->codigoJurosMora."                            ".$this->nossoNumero."      ".date("Ymd")." N B0000    0000000000".$this->multa."            ".$this->codigoMovimento.$this->numeroDocumento.$this->vencimento.$this->valorTitulo."         ".$this->especieTitulo."N".$this->dataEmissaoTitulo.$this->codigoProtesto.$this->prazoProtesto.$this->jurosMora.$this->vencimento."000000000000000000000000000000000000000".$this->inscricaoTipoSacado."0".$this->inscricaoNumeroSacado.$this->sacadoNome.$this->endereco."00000000000 ".$this->cep."00000".$this->inscricaoNumeroSacadorAvalista.$this->nomeSacadorAvalista.$this->numeroRegistro."\r\n";				
			
			}
			
		}elseif( $this->layout=="CBR641" ){
			
			$this->_set('numeroRegistro', $this->numeroRegistro+1);
			
			$detalheLote = "7".$this->inscricaoTipo.$this->inscricaoNumero.$this->agenciaCodigo.$this->agenciaDv.$this->contaNumero.$this->contaDv.$this->convenio."                         ".$this->nossoNumero.$this->parcela."00       ".$this->variacao."0000000     ".$this->carteira.$this->codigoMovimento.$this->numeroDocumento.$this->vencimento.$this->valorTitulo.$this->banco.$this->agenciaCodigo.$this->agenciaDv."990".$this->dataEmissaoTitulo."0000".$this->jurosMora.$this->dataJurosMora.$this->desconto1.$this->valorIof.$this->valorAbatimento.$this->inscricaoTipoSacado.$this->inscricaoNumeroSacado.$this->sacadoNome."   ".$this->endereco.$this->bairro.$this->cep.$this->cidade.$this->uf.$this->nomeSacadorAvalista.$this->prazoProtesto." ".$this->numeroRegistro."\n";
			
			$this->_set('numeroRegistro', $this->numeroRegistro+1);
			
			$detalheLote .= "599".$this->codigoMulta.$this->dataMulta.$this->multa."                                                                                                                                                                                                                                                                                                                                                                                    ".$this->numeroRegistro."\n";
			
		}
		
		return $detalheLote;
	}

	/**
	* trailerLote
	* Monta a linha de trailer do lote do arquivo de remessa, usando as propriedades do documento de acordo com o layout inofrmado
	* @return string $linha string com a linha completa do cabeçalho do lote
	*/
	public function trailerLote(){
		$trailerLote = "";
		
		if( $this->layout=="FEBRABAN240" || $this->layout=="SIGCB240" ){
			
			$trailerLote = $this->banco.$this->lote."5".$this->cnabTrailer.$this->quantidadeRegistro.$this->quantidadeTituloCombrancaSimples.$this->valorTotalTituloCarteiraSimples.$this->quantidadeTituloCombrancaVinculada.$this->valorTotalTituloCarteiraVinculada.$this->quantidadeTituloCombrancaCaucionada.$this->valorTotalTituloCarteiraCaucionada.$this->quantidadeTituloCombrancaDescontada.$this->valorTotalTituloCarteiraDescontada.$this->numeroAviso.$this->cnabFinalTrailer."\n";
		
		}elseif( $this->layout=="CNAB400" || $this->layout=="CBR641" ){
			
			$this->_set('numeroRegistro', $this->numeroRegistro+1);
			
			if($this->banco=="341" || $this->banco=="237" ){
				$trailerLote = "9                                                                                                                                                                                                                                                                                                                                                                                                         ".$this->numeroRegistro."\r\n";
			}elseif($this->banco=="748"){
				$trailerLote = "91748".$this->convenio."                                                                                                                                                                                                                                                                                                                                                                                                ".$this->numeroRegistro."\r\n";
			}else{
				$trailerLote = "9                                                                                                                                                                                                                                                                                                                                                                                                         ".$this->numeroRegistro."\n";
			}

		}
		
		return $trailerLote;
	}
	
	
	/**
	* _get (somente retorno)
	* Retorna valores para propriedades da classe a partir do arquivo de retorno
	* @param string $prop propriedade que deseja buscar
	* @param string $linha linha do arquivo de retorno para extrair a propriedade desejada
	* @return $prop
	*/
	public function _get($prop,$linha){
		
		if(property_exists($this,$prop)){
			
			switch($prop){
				
				case 'nossoNumero':
					if($this->layout=="CNAB400" && $this->banco=="756"){
						$this->$prop = substr($linha, 66, 8);
					}elseif($this->layout=="CNAB400" && $this->banco=="341"){
						$this->$prop = substr($linha, 85, 9);
					}elseif($this->layout=="CNAB400" && $this->banco=="748"){
						$this->$prop = substr($linha, 47, 15);
					}elseif($this->layout=="CNAB400" && $this->banco=="237"){
						$this->$prop = substr($linha, 70, 12);
					}elseif($this->layout=="FEBRABAN240" && $this->banco=="033"){
						$this->$prop = substr($linha, 40, 13);
					}elseif($this->layout=="FEBRABAN240" && $this->banco=="756"){
						$this->$prop = substr($linha, 39, 8);
					}elseif($this->layout=="FEBRABAN240" && $this->banco=="001"){
						$this->$prop = substr($linha, 37, 20);
					}elseif($this->layout=="SIGCB240" && $this->banco=="104"){
						$this->$prop = substr($linha, 39, 17)."-".substr($linha, 56, 1);
					}
					break;
				case 'parcela':
					if($this->layout=="CNAB400" && $this->banco=="756"){
						$this->$prop = substr($linha, 74, 2);
					}else{
						$this->$prop = "01";
					}
					break;
				case 'codigoBaixaDevolucao':
					if($this->layout=="CNAB400" && $this->banco=="756"){
						$this->$prop = substr($linha, 80, 2);
					}else{
						$this->$prop = "";
					}
					break;
				case 'codigoMovimento':
					if($this->layout=="CNAB400" && ($this->banco=="756" || $this->banco=="341" || $this->banco=="748" || $this->banco=="237")){
						$this->$prop = substr($linha, 108, 2);
					}elseif( $this->layout=="FEBRABAN240" || $this->layout=="SIGCB240" ){
						$this->$prop = substr($linha, 15, 2);
					}
					break;
				case 'dataEmissaoTitulo': //data de entrada no banco ou da liquidação do titulo
					if($this->layout=="CNAB400" && ($this->banco=="756" || $this->banco=="341" || $this->banco=="748" || $this->banco=="237")){
						$this->$prop = substr($linha, 110, 2)."/".substr($linha, 112, 2)."/20".substr($linha, 114, 2);
					}else{
						$this->$prop = "";
					}
					break;
				case 'numeroDocumento':
					if($this->layout=="CNAB400" && ($this->banco=="756" || $this->banco=="341" || $this->banco=="748" || $this->banco=="237")){
						$this->$prop = substr($linha, 116, 10);
					}elseif($this->layout=="FEBRABAN240" && $this->banco=="033"){
						$this->$prop = substr($linha, 54, 15);
					}elseif($this->layout=="FEBRABAN240" && ($this->banco=="756" || $this->banco=="001")){
						$this->$prop = substr($linha, 58, 15);
					}elseif($this->layout=="SIGCB240" && $this->banco=="104"){
						$this->$prop = substr($linha, 105, 25);
					}
					break;
				case 'vencimento':
					if($this->layout=="CNAB400" && ($this->banco=="756" || $this->banco=="341" || $this->banco=="748" || $this->banco=="237")){
						$this->$prop = substr($linha, 146, 6);
					}elseif($this->layout=="FEBRABAN240" && $this->banco=="033"){
						$this->$prop = substr($linha, 69, 8);
					}elseif($this->layout=="FEBRABAN240" && ($this->banco=="756" || $this->banco=="001")){
						$this->$prop = substr($linha, 73, 8);
					}elseif($this->layout=="SIGCB240" && $this->banco=="104"){
						$this->$prop = substr($linha, 73, 2)."/".substr($linha, 75, 2)."/".substr($linha, 77, 4);
					}
					break;
				case 'valorTitulo':
					if($this->layout=="CNAB400" && ($this->banco=="756" || $this->banco=="341" || $this->banco=="748" || $this->banco=="237")){
						$this->$prop = substr($linha, 152, 13);
					}elseif($this->layout=="FEBRABAN240" && $this->banco=="033"){
						$this->$prop = substr($linha, 77, 15);
					}elseif($this->layout=="FEBRABAN240" && ($this->banco=="756" || $this->banco=="001")){
						$this->$prop = substr($linha, 81, 15);
					}elseif($this->layout=="SIGCB240" && $this->banco=="104"){
						$this->$prop = (float) substr($linha, 81, 13).".".substr($linha, 94, 2);
					}
					break;
				case 'especieTitulo':
					if($this->layout=="CNAB400" && $this->banco=="756"){
						$this->$prop = substr($linha, 173, 2);
					}else{
						$this->$prop="";
					}
					break;
				case 'dataCredito': //data em que o valor sera/foi creditado na conta
					if($this->layout=="CNAB400" && $this->banco=="756"){
						$this->$prop = substr($linha, 175, 2)."/".substr($linha, 177, 2)."/20".substr($linha, 179, 2);
					}elseif($this->layout=="CNAB400" && $this->banco=="341"){
						$this->$prop = substr($linha, 110, 2)."/".substr($linha, 112, 2)."/20".substr($linha, 114, 2);
					}elseif($this->layout=="CNAB400" && $this->banco=="748"){
						$this->$prop = substr($linha, 334, 2)."/".substr($linha, 332, 2)."/".substr($linha, 328, 4);
					}elseif($this->layout=="CNAB400" && $this->banco=="237"){
						$this->$prop = substr($linha, 295, 2)."/".substr($linha, 297, 2)."/20".substr($linha, 299, 2);
					}elseif($this->layout=="FEBRABAN240" && ($this->banco=="033" || $this->banco=="001") ){
						$this->$prop = substr($linha, 145, 2)."/".substr($linha, 147, 2)."/".substr($linha, 149, 4);
					}elseif( ($this->layout=="SIGCB240" && $this->banco=="104") || ($this->layout=="FEBRABAN240" && $this->banco=="756") ){
						$this->$prop = substr($linha, 137, 2)."/".substr($linha, 139, 2)."/".substr($linha, 141, 4);
					}
					break;
				case 'valorTarifa': //tarifa
					if($this->layout=="CNAB400" && $this->banco=="756"){
						$this->$prop = (float) substr($linha, 181, 5).".".substr($linha, 186, 2);
					}elseif($this->layout=="CNAB400" && ($this->banco=="341" || $this->banco=="748" || $this->banco=="237")){
						$this->$prop = (float) substr($linha, 175, 11).".".substr($linha, 186, 2);
					}elseif($this->layout=="FEBRABAN240" && $this->banco=="033"){
						$this->$prop = (float) substr($linha, 193, 13).".".substr($linha, 206, 2);
					}elseif($this->layout=="FEBRABAN240" && ($this->banco=="756" || $this->banco=="001")){
						$this->$prop = (float) substr($linha, 198, 13).".".substr($linha, 211, 2);
					}elseif($this->layout=="SIGCB240" && $this->banco=="104"){
						$this->$prop = (float) substr($linha, 198, 12).".".substr($linha, 211, 2);
					}
					break;
				case 'desconto1':
					if($this->layout=="CNAB400" && ($this->banco=="756" || $this->banco=="341" || $this->banco=="748" || $this->banco=="237")){
						$this->$prop = (float) substr($linha, 240, 11).".".substr($linha, 251, 2);
					}elseif($this->layout=="FEBRABAN240" && $this->banco=="033"){
						$this->$prop = (float) substr($linha, 47, 13).".".substr($linha, 60, 2);
					}elseif($this->layout=="FEBRABAN240" && $this->banco=="756"){
						$this->$prop = (float) substr($linha, 32, 13).".".substr($linha, 45, 2);
					}elseif($this->layout=="SIGCB240" && $this->banco=="104"){
						$this->$prop = (float) substr($linha, 32, 13).".".substr($linha, 45, 2);
					}
					break;
				case 'valorRecebido':
					if($this->layout=="CNAB400" && ($this->banco=="756" || $this->banco=="341" || $this->banco=="748" || $this->banco=="237")){
						$this->$prop = (float) substr($linha, 253, 11).".".substr($linha, 264, 2);
					}elseif($this->layout=="FEBRABAN240" && ($this->banco=="756" || $this->banco=="001" || $this->banco=="033") ){
						$this->$prop = (float) substr($linha, 77, 13).".".substr($linha, 90, 2);
					}else{
						$this->$prop = (float) substr($linha, 92, 13).".".substr($linha, 105, 2);
					}
					break;
				case 'motivo':
					if($this->layout=="FEBRABAN240"){
						if($this->banco=="033"){
							$this->$prop = substr($linha, 200, 10);
						}elseif($this->banco=="001"){
							$this->$prop = substr($linha, 205, 10);
						}else{
							$this->$prop = substr($linha, 213, 10);
						}
						$this->$prop = substr($this->$prop, -2, 2);
					}else{
						$this->$prop = substr($linha, 318, 2);
					}
					break;
				case 'jurosMora':
					if($this->layout=="CNAB400" && ($this->banco=="756" || $this->banco=="341" || $this->banco=="748" || $this->banco=="237")){
						$this->$prop = (float) substr($linha, 266, 11).".".substr($linha, 277, 2);
					}else{
						$this->$prop = (float) substr($linha, 17, 13).".".substr($linha, 30, 2);
					}
					break;
				case 'valorLancamento':
					if($this->layout=="CNAB400" && $this->banco=="756"){
						$this->$prop = (float) substr($linha, 305, 11).".".substr($linha, 316, 2);
					}else{
						$this->$prop = (float) substr($linha, 77, 13).".".substr($linha, 90, 2);
					}
					break;
				case 'multa':
					if($this->layout=="CNAB400" && $this->banco=="756"){
						$this->$prop = (float) substr($linha, 320, 10).".".substr($linha, 330, 2);
					}else{
						$this->$prop = "0.00";
					}
					break;
			
			}
			
			return $this->$prop;
			
		}else{
			exit("Propriedade ".$prop." inexistente no Documento!");
		}
		
	}
}
?>