<?php
/*
* Classe para definicao das propriedades de um arquivo de retorno
*/
class Retorno{
	
	/*
	string com caminho completo do arquivo de retorno
	*/
	public $nomeArquivo = "";
	
	/*
	array de linhas com o conteudo do arquivo de retorno a ser lido
	*/
	public $arquivo = array();
	
	/*
	layout do arquivo retorno, padrao febraban de 240 posições
	*/
	public $layout = "FEBRABAN240";
	
	/*
	Código do Banco na Compensação
	G001 tamanho 3 posição 1-3
	*/
	public $banco = "000";
	
	/*
	Lote de Serviço 
	G002 tamanho 4 posição 4-7
	*/
	public $lote = "0000";


	/*
	Uso Exclusivo FEBRABAN / CNAB  
	G004 tamanho 9 posição 9-17
	*/
	public $cnab = "         ";


	/*
	Tipo de Inscrição da Empresa
	G005 tamanho 1 posição 18-18
	*/
	public $inscricaoTipo = "0";


	/*
	Nº de Inscrição da Empresa
	G006 tamanho 15 posição 19-32
	*/
	public $inscricaoNumero = "00000000000000";
	

	/*
	Código do Convênio no Banco
	G007 tamanho 20 posição 33-52
	*/
	public $convenio = "                    ";


	/*
	Agência Mantenedora da Conta
	G008 tamanho 5 posição 53-57
	*/
	public $agenciaCodigo = "00000";


	/*
	Dígito Verificador da Conta
	G009 tamanho 1 posição 58-58
	*/
	public $agenciaDv = " ";


	/*
	Número da Conta Corrente
	G010 tamanho 12 posição 59-70
	*/
	public $contaNumero = "000000000000";


	/*
	Número da Conta Corrente
	G011 tamanho 1 posição 71-71
	*/
	public $contaDv = " ";


	/*
	Dígito Verificador da Ag/Conta 
	G012 tamanho 1 posição 72-72
	*/
	public $dvAgenciaConta = " ";


	/*
	Nome da Empresa 
	G013 tamanho 30 posição 73-102
	*/
	public $empresaNome = "                              ";


	/*
	Nome do Banco 
	G014 tamanho 30 posição 103-132
	*/
	public $nomeBanco = "                              ";


	/*
	Lote de Serviço 
	G004 tamanho 10 posição 133-142
	*/
	public $cnabHeader = "          ";


	/*
	Código Remessa / Retorno 
	G015 tamanho 1 posição 143-143
	*/
	public $arquivoCodigo = "1";


	/*
	Data de Geração do Arquivo
	G016 tamanho 8 posição 144-151
	*/
	public $arquivoDataGeracao = "00000000";
	
	/*
	Hora de Geração do Arquivo
	G017 tamanho 6 posição 152-157
	*/
	public $arquivoHoraGeracao = "000000";

	/*
	Número Seqüencial do Arquivo
	G018 tamanho 6 posição 158-163
	*/
	public $arquivoSequenciaNsa = "000000";

	/*
	No da Versão do Layout do Arquivo
	G019 tamanho 3 posição 164-166
	*/
	public $arquivoLayout = "087";


	/*
	Densidade de Gravação do Arquivo
	G020 tamanho 5 posição 167-171
	*/
	public $arquivoDensidade = "00000";


	/*
	Para Uso Reservado do Banco
	G021 tamanho 3 posição 172-191
	*/
	public $reservadoBanco = "                    ";


	/*
	Para Uso Reservado da Empresa
	G022 tamanho 3 posição 192-211
	*/
	public $reservadoEmpresa = "                    ";


	/*
	Uso Exclusivo FEBRABAN / CNAB
	G004 tamanho 29 posição 212-240
	*/
	public $cnabFinalHeader = "                             ";




	/*
	Uso Exclusivo FEBRABAN / CNAB
	G004 tamanho 9 posição 9-17
	*/
	public $cnabTrailer = "         ";

	/*
	Quantidade de Lotes do Arquivo
	G049 tamanho 6 posição 18-23
	*/
	public $quantidadeLote = "000001";


	/*
	Quantidade de Registros do Arquivo 
	G056 tamanho 6 posição 24-29
	*/
	public $quantidadeRegistro = "000000";


	/*
	Qtde de Contas p/ Conc. (Lotes)
	G037 tamanho 6 posição 30-35
	*/
	public $quantidadeContaConciliada = "      ";


	/*
	Uso Exclusivo FEBRABAN / CNAB
	G004 tamanho 205 posição 36-240
	*/
	public $cnabFinalTrailer = "                                                                                                                                                                                                             ";
	
	
	
	/**
	* Construtor padrao - abre o arquivo, armazena suas linhas e atribui as propriedades da classe
	* @param string $arquivo nome do arquivo a ser aberto e lido
	*/
	public function __construct($arquivo='teste.ret'){
		
		$this->nomeArquivo = $arquivo;
		//extensao
		$ext = array_reverse(explode(".", $this->nomeArquivo));
		
		if($ext[0] && ($ext[0]=="ret" || $ext[0]=="txt" || $ext[0]=="crt") ){
		
			if( is_file($this->nomeArquivo) && file_exists($this->nomeArquivo) ){
				
				$this->arquivo = file($this->nomeArquivo);
				
				//minimo de 3 linhas
				if( is_array($this->arquivo) && count($this->arquivo)>=3 ){
				
					//quantidade de caracteres por linha
					$tam = strlen($this->arquivo[0]);
					
					//400 posicoes
					if($tam==402 || $tam==401){
						
						$this->layout = "CNAB400";
						$this->agenciaCodigo = substr($this->arquivo[0], 26, 4);
						$this->agenciaDv = substr($this->arquivo[0], 30, 1);
						$this->convenio = substr($this->arquivo[0], 31, 9);
						$this->banco = substr($this->arquivo[0], 76, 3);
						
						if($this->banco==748){ //Sicredi
							$this->inscricaoNumero = substr($this->arquivo[0], 31, 14);
						}else{
							$this->inscricaoNumero = substr($this->arquivo[1], 3, 14);
						}
						$this->contaNumero = substr($this->arquivo[1], 22, 8);
						$this->contaDv = substr($this->arquivo[1], 30, 1);
						
					}else{
						$this->banco = substr($this->arquivo[0], 0, 3);
						if( $this->banco=="104" ){
							$this->layout = "SIGCB240";
							$this->agenciaCodigo = substr($this->arquivo[0], 53, 5);
							$this->agenciaDv = substr($this->arquivo[0], 58, 1);
							$this->convenio = substr($this->arquivo[0], 59, 6);
							$this->inscricaoNumero = substr($this->arquivo[0], 18, 14);
							// $this->contaNumero = substr($this->arquivo[0], 37, 9);
							// $this->contaDv = substr($this->arquivo[0], 46, 1);
						}else{
							$this->layout = "FEBRABAN240";
							$this->agenciaCodigo = substr($this->arquivo[0], 32, 4);
							$this->agenciaDv = substr($this->arquivo[0], 36, 1);
							$this->convenio = substr($this->arquivo[0], 52, 9);
							$this->inscricaoNumero = substr($this->arquivo[0], 18, 14);
							$this->contaNumero = substr($this->arquivo[0], 37, 9);
							$this->contaDv = substr($this->arquivo[0], 46, 1);
						}
						
					}
					
				}else{
					
					exit("Formatação de arquivo de retorno inválida");
					
				}
				
			}else{
				
				exit('Arquivo de retorno não encontrado');
				
			}
			
		}else{
				
			exit('Extensão de arquivo de retorno inválida');
				
		}
		
	}
	
}
?>