<?php

	setlocale (LC_ALL, 'pt_BR.UTF-8');
	set_time_limit(1500);
	error_reporting(E_ALL ^ E_NOTICE);
	
	include_once "../class/useful.php";
	include_once '../php/TParams.class.php';
	include_once "../class/PHPMailer_v5.1/class.phpmailer.php";

	$Useful = new Useful();
	$datapacket=new TParams();
	$datapacket->clear();
	$datapacket->debug(true);

	function diffDate($d1, $d2){
		$d1 = explode("-", $d1);
		$d2 = explode("-", $d2);
		$X = 86400;
		return floor( ( ( mktime(0, 0, 0, $d2[1], $d2[2], $d2[0]) - mktime(0, 0, 0, $d1[1], $d1[2], $d1[0] ) ) / $X ) );
	}
	
	$arr1 = array("á", "à", "ã", "â", "Á", "À", "Ã", "Â", "é", "ê", "É", "Ê", "í", "Í", "ó", "õ", "ô", "Ó", "Ô", "Õ", "ú", "ü", "Ú", "Ü", "ç", "Ç", "º", "ª", "\"", "'", "\n");
	$arr2 = array("a", "a", "a", "a", "A", "A", "A", "A", "e", "e", "E", "E", "i", "I", "o", "o", "o", "O", "O", "O", "u", "u", "U", "U", "c", "C", "", "", "", "", "");
	
	$datapacket->setHost($datapacket->getHost("empresas"));
	
	// selecionar todas as empresas cujo certificado esta proximo de vencer
	$filtro = '{"cod":"500519","params":[]}';
	$datapacket->add($filtro);
	$cert = $datapacket->open(true);
	$datapacket->clear();
	
	if( isset($cert) && count($cert)>0 ){
		$datapacket2=new TParams();
		$datapacket2->setHost($datapacket2->getHost("e0371"));
		foreach($cert as $cer){
			$filtro = '{"cod":"700321","params":[
				{"name":"msg_codigo","value":"","type":"string"},
				{"name":"msg_tipo","value":"1","type":"integer"},
				{"name":"men_codigo","value":"0","type":"integer"},
				{"name":"msg_remetente","value":"site@jcmantovan.com.br","type":"string"},
				{"name":"msg_destinatario","value":"suporte@jcmantovan.com.br","type":"string"},
				{"name":"cad_codigo","value":"","type":"string"},
				{"name":"msg_assunto","value":"Certificado proximo de vencer","type":"string"},
				{"name":"msg_conteudo","value":"'.base64_encode(utf8_decode("A empresa ".$cer->emp_codigo." está com certificado digital perto de vencer (".implode("/",array_reverse(explode("-",substr($cer->emp_valid_cert,0,10))))).")").'","type":"string"},
				{"name":"msg_data","value":"'.date("Y-m-d H:i:s").'","type":"string"},
				{"name":"msg_dtenvio","value":"'.date("Y-m-d H:i:s").'","type":"string"},
				{"name":"msg_status","value":"0","type":"integer"},
				{"name":"msg_anexo","value":"","type":"string"}
			]}';
			$datapacket2->add($filtro);
			$ret = $datapacket2->open(false, true); //codigo da mensagem criada
			$datapacket2->clear();
			
			//enviar mensagem
			if($ret){
				$fields = array(
					'p' => "S2kNNQU5UT1ZBTg==",
					'acao' => 'enviar',
					'msg_codigo' => $ret
				);
				$fields_string="";
				foreach($fields as $key=>$value) { $fields_string .= $key.'='.$value.'&'; }
				rtrim($fields_string, '&');
				$ch = curl_init();
				curl_setopt($ch,CURLOPT_URL, $_SERVER["HTTP_HOST"]."/desktop/php/mensagem.php");
				curl_setopt($ch,CURLOPT_POST, count($fields));
				curl_setopt($ch,CURLOPT_POSTFIELDS, $fields_string);
				$result = curl_exec($ch);
				curl_close($ch);
			}
		}
		$datapacket2->clear();
	}
			
	// selecionar todas as empresas que não fizeram login há mais de 5 dias
	$dt1 = date("Y-m-d H:i:s", strtotime(date("Y-m-d H:i:s")."- 14 days"));
	$dt2 = date("Y-m-d H:i:s", strtotime(date("Y-m-d H:i:s")."- 5 days"));
	$filtro = '{"cod":"500523","params":[
		{"name":"dt1","value":"'.$dt1.'","type":"string"},
		{"name":"dt2","value":"'.$dt2.'","type":"string"}
	]}';
	
	$datapacket=new TParams();
	$datapacket->clear();
	$datapacket->setHost($datapacket->getHost("empresas"));
	
	$datapacket->add($filtro);
	$abandono = $datapacket->open(true);
	$datapacket->clear();
	if( isset($abandono) && count($abandono)>0 ){
		$datapacket2=new TParams();
		$datapacket2->setHost($datapacket2->getHost("e0371"));
		$lista ='';
		foreach($abandono as $aban){
			$lista .= $aban->usu_login.' - '.implode("/",array_reverse(explode("-",substr($aban->log_data,0,10)))).'<br>';
		}
		$filtro = '{"cod":"700321","params":[
			{"name":"msg_codigo","value":"","type":"string"},
			{"name":"msg_tipo","value":"1","type":"integer"},
			{"name":"men_codigo","value":"0","type":"integer"},
			{"name":"msg_remetente","value":"site@jcmantovan.com.br","type":"string"},
			{"name":"msg_destinatario","value":"suporte@jcmantovan.com.br","type":"string"},
			{"name":"cad_codigo","value":"","type":"string"},
			{"name":"msg_assunto","value":"Usuarios que nao fizeram login","type":"string"},
			{"name":"msg_conteudo","value":"'.base64_encode(utf8_decode("Os seguintes usuários não fizeram login no sistema há mais de 5 dias: <br>".$lista)).'","type":"string"},
			{"name":"msg_data","value":"'.date("Y-m-d H:i:s").'","type":"string"},
			{"name":"msg_dtenvio","value":"'.date("Y-m-d H:i:s").'","type":"string"},
			{"name":"msg_status","value":"0","type":"integer"},
			{"name":"msg_anexo","value":"","type":"string"}
		]}';
		$datapacket2->add($filtro);
		$ret = $datapacket2->open(false, true); //codigo da mensagem criada
		$datapacket2->clear();
		
		//enviar mensagem
		if($ret){
			$fields = array(
				'p' => "S2kNNQU5UT1ZBTg==",
				'acao' => 'enviar',
				'msg_codigo' => $ret
			);
			$fields_string="";
			foreach($fields as $key=>$value) { $fields_string .= $key.'='.$value.'&'; }
			rtrim($fields_string, '&');
			$ch = curl_init();
			curl_setopt($ch,CURLOPT_URL, $_SERVER["HTTP_HOST"]."/desktop/php/mensagem.php");
			curl_setopt($ch,CURLOPT_POST, count($fields));
			curl_setopt($ch,CURLOPT_POSTFIELDS, $fields_string);
			$result = curl_exec($ch);
			curl_close($ch);
		}
		$datapacket2->clear();
	}
	
	// selecionar todas as empresas marcadas para executar a rotina (cfg_rotina=1)
	$datapacket=new TParams();
	$datapacket->clear();
	$datapacket->setHost($datapacket->getHost("empresas"));
	$filtro = '{"cod":"600005","params":[]}';
	$datapacket->add($filtro);
	$empresas = $datapacket->open(true);
	$datapacket->clear();
	
	//verifica se há empresas para executar a rotina
	if( isset($empresas) && count($empresas)>0 ){
		
		//percorre empresas da rotina
		foreach($empresas as $empresa){
			
			//atribuir banco de dados
			$datapacket->setHost($datapacket->getHost($empresa->emp_db_sge));
			
			$p = base64_encode($empresa->emp_codigo);
			$p = substr($p, 0, 1)."2".substr($p, 1);
			
			//2vezes em cada empresa; 1 vez relatorio e execução; 2 vez apenas relatorio de previsao
			for($vez=0; $vez<2; $vez++){
				
				//variavel do e-mail relatório
				$relatorio="";
				$anexo1="";
				$anexo2="";
				$anexo3="";
				
				//data calendario base para execução das rotinas, na primeira vez pega a data atual, na segunda pega uma previsão para um ou tres dias
				if( $vez==1 ){
					if( date("l")=="Friday" ){
						$data_base = date("Y-m-d H:i:s", strtotime(date("Y-m-d H:i:s")."+ 3 days"));
					}else{
						$data_base = date("Y-m-d H:i:s", strtotime(date("Y-m-d H:i:s")."+ 1 days"));
					}
				}else{
					$data_base = date("Y-m-d H:i:s");
				}

				
				
				//Somente no banco jcmantovan, verificar boletos vencidos relativos aos serviços do FACIL (sub_codigo=1), efetuar os bloqueios e enviar os e-mails aos clientes necessarios
				if($empresa->emp_db_sge=="e0371"){
					for($diff=5; $diff<=15; $diff=$diff+5){ //5, 10, e 15 dias decorridos do vencimento, 5, 10 e 15
						//FACIL
						if($empresa->cfg_suspende_facil==1){
							$filtro = '{"cod":"700266","params":[
								{"name":"dbcomum","value":"'.$empresa->emp_db_comum.'","type":"other"},
								{"name":"data_base","value":"'.$data_base.'","type":"string"},
								{"name":"diff","value":"'.$diff.'","type":"integer"}
							]}';
							$datapacket->add($filtro);
							$emps = $datapacket->open();
							$datapacket->clear();
							if($emps && is_array($emps) && count($emps)>0){
								$conj="";

								$relatorio.= ($vez==0) ? "<strong>Clientes bloqueados no FÁCIL por falta de pagamento (".$diff." dias de atraso):</strong><br><br>" : "<strong>Clientes a serem bloqueados no FÁCIL por falta de pagamento (".$diff." dias de atraso):</strong><br><br>";
								
								foreach($emps as $emp){

									$conj.= ( isset($emp["cad_cnpjcpf"]) && $emp["cad_cnpjcpf"]!="" ) ? "'".$emp["cad_cnpjcpf"]."', " : "";
									$relatorio.= $emp["cad_nomeraz"]."<br>";
									
									if($vez==0){
										//modelo de e-mail
										$filtro = '{"cod":"700268","params":[
											{"name":"dbcomum","value":"'.$empresa->emp_db_comum.'","type":"other"},
											{"name":"men_codigo","value":"4","type":"integer"}
										]}';
										$datapacket->add($filtro);
										$filtro = '{"cod":"700265","params":[
											{"name":"ctt_codigo","value":"'.$emp["ctt_codigo"].'","type":"integer"},
											{"name":"ctt_status","value":"3","type":"integer"}
										]}';
										$datapacket->add($filtro);
										$ret = $datapacket->open(true);
										$datapacket->clear();
										
										if( ($emp["eml_ender"] || ($emp["cad_email_nfe"] && $emp["cad_email_nfe"]!="")) && count($ret)>0 && isset($emp["cad_cnpjcpf"]) && $emp["cad_cnpjcpf"]!="" ){
											
											$msg_destinatario = ($emp["eml_ender"]) ? $emp["eml_ender"] : $emp["cad_email_nfe"];
											$filtro = '{"cod":"700321","params":[
												{"name":"msg_codigo","value":"","type":"string"},
												{"name":"msg_tipo","value":"1","type":"integer"},
												{"name":"men_codigo","value":"4","type":"integer"},
												{"name":"msg_remetente","value":"'.$ret[0]->men_remetente.'","type":"string"},
												{"name":"msg_destinatario","value":"'.strtolower($msg_destinatario).'","type":"string"},
												{"name":"cad_codigo","value":"'.$emp["cad_codigo"].'","type":"string"},
												{"name":"msg_assunto","value":"'.$ret[0]->men_assunto.'","type":"string"},
												{"name":"msg_conteudo","value":"'.utf8_decode($ret[0]->men_conteudo).'","type":"string"},
												{"name":"msg_data","value":"'.date("Y-m-d H:i:s").'","type":"string"},
												{"name":"msg_dtenvio","value":"'.date("Y-m-d H:i:s").'","type":"string"},
												{"name":"msg_status","value":"0","type":"integer"},
												{"name":"msg_anexo","value":"","type":"string"}
											]}';
											$datapacket->add($filtro);
											$ret = $datapacket->open(false, true);
											$datapacket->clear();
											//enviar mensagem de e-mail com aviso de bloqueio do serviço
											if($ret){
												//requisição para envio da mensagem
												$fields = array(
													'p' => $p,
													'acao' => 'enviar',
													'msg_codigo' => $ret
												);

												//url-ify os dados para o POST
												$fields_string="";
												foreach($fields as $key=>$value) { $fields_string .= $key.'='.$value.'&'; }
												rtrim($fields_string, '&');

												//abrir conexao
												$ch = curl_init();

												//define url, numero de variaveis POST e dados POST
												curl_setopt($ch,CURLOPT_URL, $_SERVER["HTTP_HOST"]."/desktop/php/mensagem.php");
												curl_setopt($ch,CURLOPT_POST, count($fields));
												curl_setopt($ch,CURLOPT_POSTFIELDS, $fields_string);

												//executa POST
												$result = curl_exec($ch);

												//fechar conexao
												curl_close($ch);
											}
											
										}
									}
								}
								if($conj!=""){
									$conj = substr($conj, 0, (strlen($conj)-2));
									$filtro = '{"cod":"700267","params":[
										{"name":"emp_cpfcnpj","value":"'.$conj.'","type":"other"}
									]}';
									$datapacket->add($filtro);
									if($vez==0) $datapacket->open();
									$datapacket->clear();
								}
							}
						}
					}
				}
				//Somente no banco da UDS
				//verificar boletos vencidos relativos aos serviços de hospedagem (sub_codigo=1), efetuar as suspensões e enviar os e-mails aos clientes necessarios
				//verificar os lançamentos financeiros de consumo interno e agrupá-los uma vez ao mês
				if($empresa->emp_db_sge=="e9997" || $empresa->emp_db_sge=="e9998"){
					for($diff=5; $diff<=15; $diff=$diff+5){ //5, 10, e 15 dias decorridos do vencimento, 5, 10 e 15
					
						//HOSPEDAGEM
						if($empresa->cfg_suspende_host==1){
							$filtro = '{"cod":"700278","params":[
								{"name":"dbcomum","value":"'.$empresa->emp_db_comum.'","type":"other"},
								{"name":"data_base","value":"'.$data_base.'","type":"string"},
								{"name":"diff","value":"'.$diff.'","type":"integer"}
							]}';
							$datapacket->add($filtro);
							$users = $datapacket->open();
							$datapacket->clear();
							
							if($users && is_array($users) && count($users)>0){
								$relatorio.= ($vez==0) ? "<br><br><strong>Clientes que tiveram HOSPEDAGEM suspensa por falta de pagamento (".$diff." dias de atraso):</strong><br><br>" : "<br><br><strong>Clientes que terão HOSPEDAGEM suspensa por falta de pagamento (".$diff." dias de atraso):</strong><br><br>";
								$ant="";
								foreach($users as $user){
									$usu="";
									$obs = base64_decode($user["ctt_obs"]);
									$svc_obs = base64_decode($user["ctt_svc_obs"]);
									if(strstr($obs, "www.")){
										$usu = explode("www.", $obs);
										$usu = (strstr($usu[1], " ")) ? explode(" ", $usu[1]) : $usu[1];
										if(is_array($usu)) $usu=$usu[1];
									}elseif(strstr($svc_obs, "www.")){
										$usu = explode("www.", $svc_obs);
										$usu = (strstr($usu[1], " ")) ? explode(" ", $usu[1]) : $usu[1];
										if(is_array($usu)) $usu=$usu[1];
									}
									$usu = strtolower($usu);
									
									if($ant!=$user["ctt_numero"]){
										$relatorio.= ( $usu!="" ) ? $user["cad_nomeraz"].", contrato Nro: ".$user["ctt_numero"]." - ".$usu."<br>" : $user["cad_nomeraz"]." - <strong>Não foi bloqueado, pois falta informação de domínio na obs no Contrato nro ".$user["ctt_numero"]."<strong><br>";
										$ant = $user["ctt_numero"];
									}
									
									if($vez==0 && $usu!=""){
										
										$filtro = '{"cod":"700265","params":[
											{"name":"ctt_codigo","value":"'.$user["ctt_codigo"].'","type":"integer"},
											{"name":"ctt_status","value":"3","type":"integer"}
										]}';
										$datapacket->add($filtro);
										$filtrolog = '{"cod":"700103","params":[
											{"name":"log_tipo","value":"4","type":"integer"},
											{"name":"log_nro","value":"'.$user["ctt_codigo"].'","type":"string"},
											{"name":"log_serie","value":"CTT","type":"string"},
											{"name":"log_usu_login","value":"","type":"string"},
											{"name":"log_acao_cod","value":"10","type":"integer"},
											{"name":"log_acao_descr","value":"bloqueio","type":"string"},
											{"name":"log_data","value":"'.date("Y-m-d H:i:s").'","type":"string"},
											{"name":"log_protocolo","value":"NULL","type":"other"},
											{"name":"log_ret","value":"NULL","type":"other"},
											{"name":"log_outro","value":"'.base64_encode("Bloqueio do Contrato por falta de pagamento").'","type":"string"}
										]}';
										$datapacket->add($filtrolog);
										$filtro = '{"cod":"700159","params":[
											{"name":"cad_codigo","value":"'.$user["cad_codigo"].'","type":"string"},
											{"name":"cad_status","value":"2","type":"integer"}
										]}';
										$datapacket->add($filtro);
										$datapacket->open();
										$datapacket->clear();
										
										
										//autenticação cpanel
										$whmusername = "rsrv12gr";
										$hash = "8cd0728cc093b222a6131c39194583b7f1c671326bfca5a190906249eb7d518e41ca51bc77a47bf3da4e37d6c8b6828cf6cd1957a8f5877c93e3dac961560579eff476cbe32b7fd18db4087f87a1d2309a43ef076232aca9087c6c7d19549749eecfcf6fb0075e74cbc7348ab1ef9dc6813221779cffc93df31d765d68f1847ee5e3655f63266e7066646b6f6328aa3a6dabb2b07b1ce8cd920da04df2f8b48b8cfb778a4f4452a34cf24b5bbe335b8d58502e7593eb152e5ff72aa8343f496ffce0e4e86a7c69557c621c04ab75d626600a5c0fa3a76602fb624cd78fd51c16464161b3c16ea9e9a9336aa281ef18d1f31312e49beefc490e3eccb5091ab80fab7f3f2a2a4a02fbef8eddccc273390ee5b3f9e2431b42c7149299b5e9230d9389b345b1978a8dce489ab6c06a920d51df7f9117d939d7990760a623a17ff0dc18c19d79dff0185310902a5d0fbfa2a9d5863f264d5c27c8e2032161e976389da8f3333fa46fde935fcb3f5d6b3004a6daf00b4fb28607ebbd888f67113210c3113381231ad0c34a7b0e4a6baaa8a297c271973df880342f5c30bc959309549b8bc4ea0013fb814a6cbcf2aa2d7b46d87a12fd6ad12cb8f435c9a7c45b67acc20846c2394b5ac1c9f0302b921c4de7291b17c24b4d1d3cbba75335e37c43daee";
										  
										$query = "https://srv14.grupouds.com.br:2087/json-api/listaccts?api.version=1"; 
										$curl = curl_init();
										curl_setopt($curl, CURLOPT_SSL_VERIFYHOST,0);
										curl_setopt($curl, CURLOPT_SSL_VERIFYPEER,0);
										curl_setopt($curl, CURLOPT_RETURNTRANSFER,1);
										$header[0] = "Authorization: WHM $whmusername:" . preg_replace("'(\r|\n)'","",$hash);
										curl_setopt($curl,CURLOPT_HTTPHEADER,$header);
										curl_setopt($curl, CURLOPT_URL, $query);
										$result = curl_exec($curl);
										curl_close($curl);
										$res = json_decode($result);
										//verificacao usuarios
										for($count=0;$count<count($res->data->acct); $count++){
											//comparacao com dominio da obs
											if($usu==$res->data->acct[$count]->domain){
												//suspensão da conta
												$query = "https://srv14.grupouds.com.br:2087/json-api/suspendacct?api.version=1&user=".$res->data->acct[$count]->user."&reason=Nonpayment"; 
												$curl = curl_init();
												curl_setopt($curl, CURLOPT_SSL_VERIFYHOST,0);
												curl_setopt($curl, CURLOPT_SSL_VERIFYPEER,0);
												curl_setopt($curl, CURLOPT_RETURNTRANSFER,1);
												$header[0] = "Authorization: WHM $whmusername:" . preg_replace("'(\r|\n)'","",$hash);
												curl_setopt($curl,CURLOPT_HTTPHEADER,$header);
												curl_setopt($curl, CURLOPT_URL, $query);
												$result = curl_exec($curl);
												curl_close($curl);
												
												//modelo de e-mail
												$filtro = '{"cod":"700268","params":[
													{"name":"dbcomum","value":"'.$empresa->emp_db_comum.'","type":"other"},
													{"name":"men_codigo","value":"5","type":"integer"}
												]}';
												$datapacket->add($filtro);
												$ret = $datapacket->open(true);
												$datapacket->clear();
												
												if( $user["eml_ender"] || ($user["cad_email_nfe"] && $user["cad_email_nfe"]!="") && count($ret)>0 ){

													$msg_destinatario = ($user["eml_ender"]) ? $user["eml_ender"] : $user["cad_email_nfe"];
													$filtro = '{"cod":"700321","params":[
														{"name":"msg_codigo","value":"","type":"string"},
														{"name":"msg_tipo","value":"1","type":"integer"},
														{"name":"men_codigo","value":"5","type":"integer"},
														{"name":"msg_remetente","value":"'.$ret[0]->men_remetente.'","type":"string"},
														{"name":"msg_destinatario","value":"'.strtolower($msg_destinatario).'","type":"string"},
														{"name":"cad_codigo","value":"'.$user["cad_codigo"].'","type":"string"},
														{"name":"msg_assunto","value":"'.$ret[0]->men_assunto.'","type":"string"},
														{"name":"msg_conteudo","value":"'.utf8_decode($ret[0]->men_conteudo).'","type":"string"},
														{"name":"msg_data","value":"'.date("Y-m-d H:i:s").'","type":"string"},
														{"name":"msg_dtenvio","value":"'.date("Y-m-d H:i:s").'","type":"string"},
														{"name":"msg_status","value":"0","type":"integer"},
														{"name":"msg_anexo","value":"","type":"string"}
													]}';
													$datapacket->add($filtro);
													$ret = $datapacket->open(false, true);
													$datapacket->clear();
													//enviar mensagem de e-mail com aviso de bloqueio do serviço
													if($ret){
														//requisição para envio ds mensagem
														$fields = array(
															'p' => $p,
															'acao' => 'enviar',
															'msg_codigo' => $ret
														);

														//url-ify os dados para o POST
														$fields_string="";
														foreach($fields as $key=>$value) { $fields_string .= $key.'='.$value.'&'; }
														rtrim($fields_string, '&');

														//abrir conexao
														$ch = curl_init();

														//define url, numero de variaveis POST e dados POST
														curl_setopt($ch,CURLOPT_URL, $_SERVER["HTTP_HOST"]."/desktop/php/mensagem.php");
														curl_setopt($ch,CURLOPT_POST, count($fields));
														curl_setopt($ch,CURLOPT_POSTFIELDS, $fields_string);

														//executa POST
														$result = curl_exec($ch);

														//fechar conexao
														curl_close($ch);
													}
													
												}
												
											}
										}
										
										
									}
									
								}

							}
						}
						
					}
					$relatorio.= "<br><br>";
					
					if( date("d")==26 || ( (date("d")==27 || date("d")==28) && date("w")==1) ){
						//uma vez ao mes (26), agrupar todos os documentos com vencimento no dia 25 do mes atual, em aberto (doc_status=0), que sejam uma previsão de pagamento (doc_previsao=1) a receber (doc_pagrec=2), provenientes de pedidos (doc_origem=5), do tipo dinheiro (doc_tipo=10), do centro de custo adiantamento de salario (ccu_codigo=5.53) e plano de contas funcionario (plc_codigo=5.1.1.1.12)
						$filtro = '{"cod":"500503","params":[
							{"name":"doc_dtvcto","value":"'.date("Y-m-")."25 00:00:00".'","type":"string"},
							{"name":"db","value":"'.$empresa->emp_db_comum.'","type":"other"}
						]}';
						$datapacket->add($filtro);
						$docs = $datapacket->open();
						$datapacket->clear();
						$cont=1;
						$codigos = "";
						$numeros = "";
						$valor=0;
						$vcto="";
						$cad="";
						$contador=0;
						array_push($docs, array());
						
						//percorrer os selecionados e verificar os que possuem mesmo vencimento e cliente, criar docto unificado (soma) e atualizar grupo de doctos com o código pai do novo docto único bem como o seu status para agrupado (doc_status=4)
						foreach($docs as $doc){
							// print_r($doc);
							// echo "<br><br>";
							if( isset($doc["doc_dtvcto"]) && substr($doc["doc_dtvcto"],0,10)==$vcto && $doc["cad_codigo"]==$cad ){
								
								if($doc["doc_valor"] >0){
									$doc["doc_valor"] = (float) $doc["doc_valor"];
								}
								$codigos.= "'".$doc["doc_codigo"]."', ";
								$numeros.= ($doc["doc_valor"]>0) ? "'".$doc["doc_numero"]."' - R$ ".number_format($doc["doc_valor"], 2, ",", "")." - ".$doc["svc_descr"]."<br>" : "'".$doc["doc_numero"]."' - R$ 0,00 - ".$doc["svc_descr"]."<br>";
								$valor+= $doc["doc_valor"];
								$cont++;
								
							}elseif($cont>=1 && $contador!=0){
								
								if($valor>0){
									$valor = (float) $valor;
									$valor = number_format($valor, 2, ".", "");
									
									$cod = substr(str_replace(array(","," ","."),array("","",""),microtime()), -10).mt_rand(10, 9999);
									
									$filtroParc  = '{"cod":"500134", "params":[
										{"name":"doc_codigo", "value":"'.$cod.'", "type":"string"},
										{"name":"doc_numero", "value":"'.$cod.'-1", "type":"string"},
										{"name":"doc_tipo", "value":"10", "type":"integer"},
										{"name":"doc_pagrec", "value":"2", "type":"integer"},
										{"name":"doc_data", "value":"'.date('Y-m-d H:i:s').'", "type":"string"},
										{"name":"doc_valor", "value":"'.$valor.'", "type":"float"},
										{"name":"doc_dtvcto", "value":"'.$vcto.'", "type":"string"},
										{"name":"doc_dtpgto", "value":"'.date('Y-m-d H:i:s').'", "type":"string"},
										{"name":"doc_vlrpg", "value":"'.$valor.'", "type":"float"},
										{"name":"doc_descr", "value":"ADIANTAMENTO DE SALARIO", "type":"string"},
										{"name":"doc_status", "value":"2", "type":"integer"},
										{"name":"doc_codbar", "value":" ", "type":"string"},
										{"name":"doc_linhadig", "value":"NULL", "type":"other"},
										{"name":"doc_banco", "value":"NULL", "type":"other"},
										{"name":"doc_agencia", "value":"NULL", "type":"other"},
										{"name":"doc_conta", "value":"NULL", "type":"other"},';
									$filtroParc.= ( isset($multa) && $multa>0 ) ? '{"name":"doc_multa", "value":"'.$multa.'", "type":"float"},' : '{"name":"doc_multa", "value":"NULL", "type":"other"},';
									$filtroParc.= ( isset($juros) && $juros>0 ) ? '{"name":"doc_juros", "value":"'.$juros.'", "type":"float"},' : '{"name":"doc_juros", "value":"NULL", "type":"other"},';
									$filtroParc.= '{"name":"doc_honorarios", "value":"NULL", "type":"other"},
										{"name":"doc_dias_envio", "value":"0", "type":"integer"},
										{"name":"doc_nparc", "value":"1", "type":"integer"},
										{"name":"doc_tparc", "value":"1", "type":"integer"},
										{"name":"doc_json_parcial", "value":"NULL", "type":"other"},
										{"name":"doc_obs", "value":"ADIANTAMENTO DE SALARIO", "type":"string"},
										{"name":"cad_codigo", "value":"'.$cad.'", "type":"string"},
										{"name":"ser_codigo", "value":"1", "type":"string"},
										{"name":"ccu_codigo","value":"5.53","type":"string"},
										{"name":"doc_cod_pai", "value":"NULL", "type":"other"},
										{"name":"plc_codigo", "value":"5.1.1.1.12", "type":"string"},
										{"name":"cad_codatend", "value":"NULL", "type":"other"},
										{"name":"doc_carteira", "value":"NULL", "type":"other"},
										{"name":"doc_nossonumero", "value":"NULL", "type":"other"},
										{"name":"svc_codigo", "value":"NULL", "type":"other"},
										{"name":"doc_sacador", "value":"NULL", "type":"other"},';
									$filtroParc.= ( isset($cta_codigo) && $cta_codigo!="" ) ? '{"name":"cta_codigo","value":"'.$cta_codigo.'","type":"integer"},' : '{"name":"cta_codigo","value":"NULL","type":"other"},';
									$filtroParc.= '{"name":"doc_dias_protesto", "value":"0", "type":"integer"},
										{"name":"doc_protesto", "value":"0", "type":"integer"},
										{"name":"doc_previsao", "value":"0", "type":"integer"},
										{"name":"doc_origem", "value":"9", "type":"integer"},
										{"name":"doc_origem_codigo", "value":"NULL", "type":"other"},
										{"name":"cad_codvend", "value":"NULL", "type":"other"},
										{"name":"doc_comissao", "value":"0", "type":"float"}';
									$filtroParc.= ']}';
									
									$datapacket->add($filtroParc);
									
									$datapacket->open();
									$datapacket->clear();
									
									$filtro  = '{"cod":"500504", "params":[
										{"name":"doc_codigo", "value":"'.substr($codigos, 0, -2).'", "type":"other"},
										{"name":"doc_codigo_pai", "value":"'.$cod.'", "type":"string"}
									]}';
									
									$datapacket->add($filtro);
									
									//log inclusao docto
									$filtrolog = '{"cod":"501240","params":[
										{"name":"lgd_tipo","value":"1","type":"integer"},
										{"name":"doc_codigo","value":"'.$cod.'","type":"string"},
										{"name":"usu_login","value":"SISTEMA","type":"string"},
										{"name":"lgd_dtatualizada","value":"NULL","type":"other"},
										{"name":"lgd_descr","value":"Documento cadastrado a partir do agrupamento de outros documentos","type":"string"}
									]}';
									$datapacket->add($filtrolog);

									$datapacket->open();
									$datapacket->clear();

								}
								
								if( isset($doc["doc_codigo"]) ){
									$codigos = "'".$doc["doc_codigo"]."', ";
									$numeros = ($doc["doc_valor"]>0) ? "'".$doc["doc_numero"]."' - R$ ".number_format((float)$doc["doc_valor"], 2, ",", "")." - ".$doc["svc_descr"]."<br>" : "'".$doc["doc_numero"]."' - R$ 0,00 - ".$doc["svc_descr"]."<br>";
									$valor=$doc["doc_valor"];
									$vcto = substr($doc["doc_dtvcto"],0,10);
									$multa = $doc["doc_multa"];
									$juros = $doc["doc_juros"];
									$prev = $doc["doc_dias_envio"];
									$cad = $doc["cad_codigo"];
									$cta_codigo = $doc["cta_codigo"];
									$carteira = $doc["doc_carteira"];
									$cli = $doc["cad_nomeraz"];
								}else{
									$valor=0;
									$codigos="";
									$numeros="";
								}
								
								$cont=1;

							}else{
								
								if( isset($doc["doc_codigo"]) ){
									$codigos = "'".$doc["doc_codigo"]."', ";
									$numeros = ($doc["doc_valor"]>0) ? "'".$doc["doc_numero"]."' - R$ ".number_format((float)$doc["doc_valor"], 2, ",", "")." - ".$doc["svc_descr"]."<br>" : "'".$doc["doc_numero"]."' - R$ 0,00 - ".$doc["svc_descr"]."<br>";
									$valor=$doc["doc_valor"];
									$vcto = substr($doc["doc_dtvcto"],0,10);
									$multa = $doc["doc_multa"];
									$juros = $doc["doc_juros"];
									$prev = $doc["doc_dias_envio"];
									$cad = $doc["cad_codigo"];
									$cta_codigo = $doc["cta_codigo"];
									$carteira = $doc["doc_carteira"];
									$cli = $doc["cad_nomeraz"];
								}
								
							}
							$contador++;
						}
					}
				}
				
				
				//atualizar contratos ativos com data final vencida, para o status de inativo
				if($empresa->cfg_inativa_ctt==1){
					$filtro = '{"cod":"700199","params":[
						{"name":"db","value":"'.$empresa->emp_db_comum.'","type":"other"},
						{"name":"data_base","value":"'.$data_base.'","type":"string"}
					]}';
					$datapacket->add($filtro);
					$ctts = $datapacket->open();
					$datapacket->clear();
					if( $ctts && is_array($ctts) && count($ctts) ){
						$relatorio.= ($vez==0) ? "<strong>Contratos que foram inativados, por expiração de data de término:</strong><br><br>" : "<strong>Contratos que vão ser inativados, por expiração de data de término:</strong><br><br>";
						foreach($ctts as $ctt){
							$filtro = '{"cod":"700265","params":[
								{"name":"ctt_codigo","value":"'.$ctt["ctt_codigo"].'","type":"integer"},
								{"name":"ctt_status","value":"2","type":"integer"}
							]}';
							$datapacket->add($filtro);
							$relatorio.= "Contrato Nro <strong>".$ctt["ctt_numero"]."</strong>, do cliente <strong>".$ctt["cad_nomeraz"]."</strong> referente ao serviço <strong>".$ctt["svc_descr"]."</strong><br>";
						}
						if($vez==0){
							$datapacket->open();
						}
						$datapacket->clear();
						$relatorio.= "<br><br>";
					}
				}
					
				//selecionar todos os contratos por frequencia (sem condição de pagamento) e ativos cuja data final não esteja definida
				if($empresa->cfg_gera_parcela==1){
					$filtro = '{"cod":"500485","params":[
						{"name":"emp_codigo","value":"'.$empresa->emp_codigo.'","type":"string"},
						{"name":"dbcomum","value":"'.$empresa->emp_db_comum.'","type":"other"}
					]}';
					$datapacket->add($filtro);
					$contratos = $datapacket->open();
					$datapacket->clear();
					$contador=0;
					$resultnfse="";

					//percorre contratos selecionados, simula parcelas, e verifica se a diferença entre o vencimento e a data atual coincide com os dias de antecedencia para geração (emp_dias_envio), em caso afirmativo gera a parcela
					foreach($contratos as $cont){
						
						//verificar a ultima parcela de cada contrato, caso nao exista criar a primeira
						$filtro = '{"cod":"500486","params":[
							{"name":"doc_numero","value":"CTT'.$cont["ctt_codigo"].'-","type":"other"}
						]}';
						$datapacket->add($filtro);
						$parc = $datapacket->open();
						$datapacket->clear();

						$cont["ctt_valor"] = (float) $cont["ctt_valor"];
						$cont["ctt_desconto"] = (float) $cont["ctt_desconto"];
						$cont["ctt_acrescimo"] = (float) $cont["ctt_acrescimo"];
						
						if(gettype($cont["ctt_valor"])=="string"){
							$cont["ctt_valor"]=0;
						}
						if(gettype($cont["ctt_acrescimo"])=="string"){
							$cont["ctt_acrescimo"]=0;
						}
						if(gettype($cont["ctt_desconto"])=="string"){
							$cont["ctt_desconto"]=0;
						}
						
						//dados para emitir NFS-e automatica
						if( isset($cont["ctt_nfse"]) && $cont["ctt_nfse"]==1 && ($resultnfse=="" || $resultnfse=="OK") ){
						
							$nfs_vlrservico = $cont["ctt_valor"] - $cont["ctt_desconto"] + $cont["ctt_acrescimo"];
							$nfs_vlrservico = number_format($nfs_vlrservico, 2, ".", "");
							
							$nfs_coditnlistserv = ($cont["atv_codigo"] && $cont["atv_codigo"]!="") ? $cont["atv_codigo"] : "0101";
							
							$email_nfse = ( isset($cont["cad_email_nfe"]) && $cont["cad_email_nfe"]!="" ) ? $cont["cad_email_nfe"] : $cont["eml_ender"];
							
							$nfse = array(
								'p' => $p,
								'emp_codigo' => $empresa->emp_codigo,
								'acao' => 'salvar',
								'usu_login' => 'SISTEMA',
								'nfs_codigo' => substr(str_replace(array(","," ","."),array("","",""),microtime()), 0, 13),
								'log_acao_cod' => 1,
								'nfs_serierps' => '1',
								'nfs_dtprestacao' => date("d/m/Y"),
								'nfs_vlrservico' => $nfs_vlrservico,
								'nfs_vlrdeducao' => 0,
								'nfs_vlrpis' => 0,
								'nfs_vlrcofins' => 0,
								'nfs_vlrinss' => 0,
								'nfs_vlrir' => 0,
								'nfs_vlrcsll' => 0,
								'nfs_vlriss' => (float) (($nfs_vlrservico * 2) / 100),
								'nfs_aliqiss' => 0,
								'nfs_aliqpis' => 0,
								'nfs_aliqcofins' => 0,
								'nfs_aliqinss' => 0,
								'nfs_aliqir' => 0,
								'nfs_aliqcsll' => 0,
								'nfs_coditnlistserv' => $nfs_coditnlistserv,
								'nfs_descrserv' => $cont["sub_descricao"]." ".$cont["svc_descr"],
								'nfs_tomador' => $cont["cad_codigo"],
								'cdp_codigo' => '999',
								'nfs_exigibilidadeiss' => 1,
								'nfs_responsavel' => 1,
								'ctt_codigo' => $cont["ctt_codigo"],
								'cad_codigo' => $cont["cad_codigo"],
								'email' => $email_nfse,
								'auto' => true //instrucao para rotina automatica de emissao
							);
							
						}else{
							$nfse="";
						}
						
						if(isset($parc[0]["doc_codigo"])){ //existem parcelas criadas?
							
							$add = (int) ($cont["frq_dias"]/ 30); //numero de meses a adicionar
							// $data = explode("-", $parc[0]["doc_dtvcto"]);
							// $mes = str_pad(($data[1]+$add), 2, "0", STR_PAD_LEFT);
							// $prox_vcto = ($mes>12) ? ($data[0]+1)."-01-".str_pad($cont["ctt_datavcto"], 2, "0", STR_PAD_LEFT) : $data[0]."-".$mes."-".str_pad($cont["ctt_datavcto"], 2, "0", STR_PAD_LEFT);
							
							$prox_vcto = date("Y-m-d", strtotime($parc[0]["doc_dtvcto"]."+ ".$add." months"));
							$prox_vcto = substr($prox_vcto, 0, 8).str_pad($cont["ctt_datavcto"], 2, "0", STR_PAD_LEFT);
							
							
							$dias = diffDate(substr($data_base, 0, 10), $prox_vcto);
							$valor = $cont["ctt_valor"] - $cont["ctt_desconto"] + $cont["ctt_acrescimo"];
					
							if( $dias <= $empresa->emp_dias_envio && $valor>0 ){ // verificar se diferença entre data atual e prox vcto é igual (ou menor) ao definido nas configurações para geração da parcela
								
								$valor = number_format($valor, 2, ".", "");
								if($contador==0) $relatorio.= "<strong>Parcelas que foram geradas automaticamente</strong><br><br>";
								
								$relatorio.= "Criada a parcela Nro <strong>".($parc[0]["doc_nparc"]+1)."</strong> do Contrato Nro <strong>".$cont["ctt_numero"]."</strong> do cliente <strong>".$cont["cad_nomeraz"]."</strong>, no valor de <strong>R$ ".number_format($valor,2,",","")."</strong>, referente ao serviço <strong>".$cont["svc_descr"]."</strong><br>";								
								
								//anotacoes
								if( isset($cont['frq_codigo']) && $cont['frq_codigo']!="" && $cont['frq_codigo']!=0 ){
									$doc_descr = ( isset($cont["sub_descricao"]) && $cont["sub_descricao"]!="" ) ? $cont["sub_descricao"]." - ".$cont["svc_descr"] : $cont["svc_descr"];
									$doc_obs = $doc_descr;
								}else{
									$doc_descr = "Contrato nro ".$cont["ctt_numero"]." - parcela ".($parc[0]["doc_nparc"]+1)." - ".$cont["svc_descr"];
									$doc_obs = $doc_descr;
								}
								$doc_descr.= ( $cont["ctt_svc_obs"]!="" ) ? substr(" ".utf8_encode(strip_tags(str_replace("\n", " ", base64_decode($cont["ctt_svc_obs"])))),0,30) : "";
								//add periodo de referencia na descricao
								if( isset($cont["ctt_periodo"]) && $cont["ctt_periodo"]!=0){
									$m = (int) ($cont["frq_dias"]/30);
									if($cont["ctt_periodo"]==1){
										$dataini = "01/".substr($prox_vcto, 5, 2)."/".substr($prox_vcto, 0, 4);
									}else{
										$dataini = date("d/m/Y", strtotime("-".$m." months", strtotime($prox_vcto)));
									}
									$datafim = date("d/m/Y", strtotime("-1 day", strtotime( "+".$m." months", strtotime(implode("-", array_reverse(explode("/",$dataini)))))));
									$doc_descr.= " - (".$dataini." a ".$datafim.")";
								}
								if( isset($cont['frq_codigo']) && $cont['frq_codigo']!="" && $cont['frq_codigo']!=0 && isset($dataini) ){
									$doc_obs.= " - ".substr($dataini, 3);
								}
								
								//comissao vendedor
								if( isset($cont["cad_codvend"]) && $cont["cad_codvend"]!="" && isset($cont['cad_comissao']) && $cont['cad_comissao']>0 ){
									$doc_comissao = (float) ($cont["cad_comissao"]/100 * $valor);
								}elseif(isset($cont["cad_codvend"]) && $cont["cad_codvend"]!="" && isset($cont["svc_comissao"]) && $cont["svc_comissao"]>0){
									$doc_comissao = (float) ($cont["svc_comissao"]/100 * $valor);
								}else{
									$doc_comissao=0;
								}
								if($doc_comissao>0){
									$doc_comissao = number_format((float) $doc_comissao, 2,".", "");
								}
								
								$doc_codigo = substr(str_replace(array(","," ","."),array("","",""),microtime()), -10).mt_rand(10, 9999);
								
								$filtroParc  = '{"cod":"500134", "params":[
									{"name":"doc_codigo", "value":"'.$doc_codigo.'", "type":"string"},
									{"name":"doc_numero", "value":"CTT'.$cont["ctt_codigo"].'-'.($parc[0]["doc_nparc"]+1).'", "type":"string"},
									{"name":"doc_tipo", "value":"'.$cont["doc_tipo"].'", "type":"integer"},
									{"name":"doc_pagrec", "value":"2", "type":"integer"},
									{"name":"doc_data", "value":"'.date('Y-m-d H:i:s').'", "type":"string"},
									{"name":"doc_valor", "value":"'.$valor.'", "type":"float"},
									{"name":"doc_dtvcto", "value":"'.$prox_vcto.' 00:00:00", "type":"string"},
									{"name":"doc_dtpgto", "value":"NULL", "type":"other"},
									{"name":"doc_vlrpg", "value":"NULL", "type":"other"},
									{"name":"doc_descr", "value":"'.str_replace($arr1, $arr2, $doc_obs).'", "type":"string"},
									{"name":"doc_status", "value":"0", "type":"integer"},
									{"name":"doc_codbar", "value":" ", "type":"string"},
									{"name":"doc_linhadig", "value":"NULL", "type":"other"},
									{"name":"doc_banco", "value":"NULL", "type":"other"},
									{"name":"doc_agencia", "value":"NULL", "type":"other"},
									{"name":"doc_conta", "value":"NULL", "type":"other"},';
								$filtroParc.= ( isset($empresa->emp_multa) && $empresa->emp_multa>0 ) ? '{"name":"doc_multa", "value":"'.$empresa->emp_multa.'", "type":"float"},' : '{"name":"doc_multa", "value":"NULL", "type":"other"},';
								$filtroParc.= ( isset($empresa->emp_jurosdiario) && $empresa->emp_jurosdiario>0 ) ? '{"name":"doc_juros", "value":"'.$empresa->emp_jurosdiario.'", "type":"float"},' : '{"name":"doc_juros", "value":"NULL", "type":"other"},';
								$filtroParc.= '{"name":"doc_honorarios", "value":"NULL", "type":"other"},';
								$filtroParc.= ( isset($cont["ctt_previsao"]) && $cont["ctt_previsao"]>0 && isset($empresa->emp_dias_envio) && $empresa->emp_dias_envio>0 ) ? '{"name":"doc_dias_envio", "value":"'.$empresa->emp_dias_envio.'", "type":"integer"},' : '{"name":"doc_dias_envio", "value":"0", "type":"integer"},';
								$filtroParc.= '{"name":"doc_nparc", "value":"'.($parc[0]["doc_nparc"]+1).'", "type":"integer"},
									{"name":"doc_tparc", "value":"NULL", "type":"other"},
									{"name":"doc_json_parcial", "value":"NULL", "type":"other"},
									{"name":"doc_obs", "value":"'.str_replace($arr1, $arr2, $doc_descr).'", "type":"string"},
									{"name":"cad_codigo", "value":"'.$cont["cad_codigo"].'", "type":"string"},
									{"name":"ser_codigo", "value":"CTT", "type":"string"},';
								$filtroParc.= ( isset($cont["ccu_codigo"]) && $cont["ccu_codigo"]!="" ) ? '{"name":"ccu_codigo","value":"'.$cont["ccu_codigo"].'","type":"string"},' : '{"name":"ccu_codigo","value":"NULL","type":"other"},';
								$filtroParc.= '{"name":"doc_cod_pai", "value":"NULL", "type":"other"},';
								$filtroParc.= ( isset($cont["plc_codigo"]) && $cont["plc_codigo"]!="" ) ? '{"name":"plc_codigo","value":"'.$cont["plc_codigo"].'","type":"string"},' : '{"name":"plc_codigo", "value":"NULL", "type":"other"},';
								$filtroParc.= '{"name":"cad_codatend", "value":"NULL", "type":"other"},';
								$filtroParc.= ( isset($cont["ctt_carteira"]) && $cont["ctt_carteira"]!="" ) ? '{"name":"doc_carteira", "value":"'.$cont["ctt_carteira"].'", "type":"string"},' : '{"name":"doc_carteira", "value":"'.$parc[0]["doc_carteira"].'", "type":"string"},';
								$filtroParc.= '{"name":"doc_nossonumero", "value":"NULL", "type":"other"},
									{"name":"svc_codigo", "value":"'.$cont["svc_codigo"].'", "type":"integer"},
									{"name":"doc_sacador", "value":"NULL", "type":"other"},';
								$filtroParc.= ( isset($cont["cta_codigo"]) && $cont["cta_codigo"]!="" ) ? '{"name":"cta_codigo","value":"'.$cont["cta_codigo"].'","type":"integer"},' : '{"name":"cta_codigo","value":"NULL","type":"other"},';
								$filtroParc.= '{"name":"doc_dias_protesto", "value":"10", "type":"integer"},
									{"name":"doc_protesto", "value":"0", "type":"integer"},
									{"name":"doc_previsao", "value":"0", "type":"integer"},
									{"name":"doc_origem", "value":"2", "type":"integer"},
									{"name":"doc_origem_codigo", "value":"'.$cont["ctt_codigo"].'", "type":"string"},';
								$filtroParc.= ( isset($cont['ven_codigo']) && $cont['ven_codigo']!="" ) ? '{"name":"cad_codvend", "value":"'.$cont["ven_codigo"].'", "type":"string"},' : '{"name":"cad_codvend", "value":"NULL", "type":"other"},';
								$filtroParc.= '{"name":"doc_comissao", "value":"'.$doc_comissao.'", "type":"float"}';
								$filtroParc.= ']}';

								$datapacket->add($filtroParc);
								
								//log inclusao docto
								$filtrolog = '{"cod":"501240","params":[
									{"name":"lgd_tipo","value":"1","type":"integer"},
									{"name":"doc_codigo","value":"'.$doc_codigo.'","type":"string"},
									{"name":"usu_login","value":"SISTEMA","type":"string"},
									{"name":"lgd_dtatualizada","value":"NULL","type":"other"},
									{"name":"lgd_descr","value":"Documento cadastrado e vinculado ao contrato N '.$cont["ctt_numero"].'","type":"string"}
								]}';
								$datapacket->add($filtrolog);
								
								$datapacket->open();
								
								//requisição nfs-e
								if( isset($nfse) && is_array($nfse) && $empresa->cfg_gera_nfse==1 ){
									$ch = curl_init();
									curl_setopt($ch,CURLOPT_URL, $_SERVER["HTTP_HOST"]."/desktop/php/nfse.php");
									curl_setopt($ch,CURLOPT_POST, count($nfse));
									curl_setopt($ch,CURLOPT_POSTFIELDS, $nfse);
									curl_setopt($ch,CURLOPT_RETURNTRANSFER, true);
									$resultnfse = curl_exec($ch);
									curl_close($ch);
								}
								
								$datapacket->clear();
								
							}
							
						}else{ //caso não existam parcelas para o contrato, cria a primeira
							
							$valor = $cont["ctt_valor"] - $cont["ctt_desconto"] + $cont["ctt_acrescimo"];
							
							
							$dias = round(diffDate($cont["ctt_dataini"], $cont["ctt_datacobr"]));
							$prop = $dias * round($valor/ $cont["frq_dias"]);
							$valorprop = ( $cont["ctt_dataini"]<$cont["ctt_datacobr"] && $prop<$valor ) ?  $valor+$prop :  $valor-$prop;
							if ( isset($cont["ctt_proporcional"]) && $cont["ctt_proporcional"]==1 ) $valor = $valorprop;
							
							$dias = diffDate(substr($data_base, 0, 10), $cont["ctt_datacobr"]);
							
							if( $dias <= $empresa->emp_dias_envio && $valor>0 ){
								
								$valor = number_format($valor, 2, ".", "");
								
								$relatorio.= "Criada a parcela Nro <strong>1</strong> do Contrato Nro <strong>".$cont["ctt_numero"]."</strong> do cliente <strong>".$cont["cad_nomeraz"]."</strong>, no valor de <strong>R$ ".number_format($valor,2,",","")."</strong>, referente ao serviço <strong>".$cont["svc_descr"]."</strong><br>";
								
								if($contador==0) $relatorio.= "<strong>Parcelas que foram geradas automaticamente</strong><br><br>";
								
								//anotacoes
								if( isset($cont['frq_codigo']) && $cont['frq_codigo']!="" && $cont['frq_codigo']!=0 ){
									$doc_descr = "";
									$doc_obs = ( isset($cont["sub_descricao"]) && $cont["sub_descricao"]!="" ) ? $cont["sub_descricao"]." - ".$cont["svc_descr"] : $cont["svc_descr"];
								}else{
									$doc_descr = "";
									$doc_obs = "Contrato nro ".$cont["ctt_numero"]." - parcela 1 - ".$cont["svc_descr"];
								}
								$doc_descr.= ( $cont["ctt_svc_obs"]!="" ) ? substr(" ".utf8_encode(strip_tags(str_replace("\n", " ", base64_decode($cont["ctt_svc_obs"])))),0,30) : "";
								//add periodo de referencia na descricao
								if( isset($cont["ctt_periodo"]) && $cont["ctt_periodo"]!=0){
									$m = (int) ($cont["frq_dias"]/30);
									if($cont["ctt_periodo"]==1){
										$dataini = "01/".substr($cont["ctt_datacobr"], 5, 2)."/".substr($cont["ctt_datacobr"], 0, 4);
									}else{
										$dataini = date("d/m/Y", strtotime("-".$m." months", strtotime($cont["ctt_datacobr"])));
									}
									$datafim = date("d/m/Y", strtotime("-1 day", strtotime( "+".$m." months", strtotime(implode("-", array_reverse(explode("/",$dataini)))))));
									if(isset($cont["ctt_proporcional"]) && $cont["ctt_proporcional"]==true && $cont["ctt_periodo"]==1){
										$dataini = implode("/", array_reverse(explode("-", $cont["ctt_dataini"])));
									}
									$doc_descr.= " - (".$dataini." a ".$datafim.")";
								}
								if( isset($cont['frq_codigo']) && $cont['frq_codigo']!="" && $cont['frq_codigo']!=0 && isset($dataini) ){
									$doc_obs.= " - ".substr($dataini, 3);
								}
								
								//comissao vendedor
								if( isset($cont["cad_codvend"]) && $cont["cad_codvend"]!="" && isset($cont['cad_comissao']) && $cont['cad_comissao']>0 ){
									$doc_comissao = (float) ($cont["cad_comissao"]/100 * $valor);
								}elseif(isset($cont["cad_codvend"]) && $cont["cad_codvend"]!="" && isset($cont["svc_comissao"]) && $cont["svc_comissao"]>0){
									$doc_comissao = (float) ($cont["svc_comissao"]/100 * $valor);
								}else{
									$doc_comissao=0;
								}
								if($doc_comissao>0){
									$doc_comissao = number_format((float) $doc_comissao, 2,".", "");
								}
								
								$doc_codigo = substr(str_replace(array(","," ","."),array("","",""),microtime()), -10).mt_rand(10,9999);
								
								$filtroParc  = '{"cod":"500134", "params":[
									{"name":"doc_codigo", "value":"'.$doc_codigo.'", "type":"string"},
									{"name":"doc_numero", "value":"CTT'.$cont["ctt_codigo"].'-1", "type":"string"},
									{"name":"doc_tipo", "value":"'.$cont["doc_tipo"].'", "type":"integer"},
									{"name":"doc_pagrec", "value":"2", "type":"integer"},
									{"name":"doc_data", "value":"'.date('Y-m-d H:i:s').'", "type":"string"},
									{"name":"doc_valor", "value":"'.$valor.'", "type":"float"},
									{"name":"doc_dtvcto", "value":"'.$cont["ctt_datacobr"].' 00:00:00", "type":"string"},
									{"name":"doc_dtpgto", "value":"NULL", "type":"other"},
									{"name":"doc_vlrpg", "value":"NULL", "type":"other"},
									{"name":"doc_descr", "value":"'.str_replace($arr1, $arr2, $doc_obs).'", "type":"string"},
									{"name":"doc_status", "value":"0", "type":"integer"},
									{"name":"doc_codbar", "value":" ", "type":"string"},
									{"name":"doc_linhadig", "value":"NULL", "type":"other"},
									{"name":"doc_banco", "value":"NULL", "type":"other"},
									{"name":"doc_agencia", "value":"NULL", "type":"other"},
									{"name":"doc_conta", "value":"NULL", "type":"other"},';
								$filtroParc.= ( isset($empresa->emp_multa) && $empresa->emp_multa>0 ) ? '{"name":"doc_multa", "value":"'.$empresa->emp_multa.'", "type":"float"},' : '{"name":"doc_multa", "value":"NULL", "type":"other"},';
								$filtroParc.= ( isset($empresa->emp_jurosdiario) && $empresa->emp_jurosdiario>0 ) ? '{"name":"doc_juros", "value":"'.$empresa->emp_jurosdiario.'", "type":"float"},' : '{"name":"doc_juros", "value":"NULL", "type":"other"},';
								$filtroParc.= '{"name":"doc_honorarios", "value":"NULL", "type":"other"},';
								$filtroParc.= ( isset($cont["ctt_previsao"]) && $cont["ctt_previsao"]>0 && isset($empresa->emp_dias_envio) && $empresa->emp_dias_envio>0 ) ? '{"name":"doc_dias_envio", "value":"'.$empresa->emp_dias_envio.'", "type":"integer"},' : '{"name":"doc_dias_envio", "value":"0", "type":"integer"},';
								$filtroParc.= '{"name":"doc_nparc", "value":"1", "type":"integer"},
									{"name":"doc_tparc", "value":"NULL", "type":"other"},
									{"name":"doc_json_parcial", "value":"NULL", "type":"other"},
									{"name":"doc_obs", "value":"'.str_replace($arr1, $arr2, $doc_descr).'", "type":"string"},
									{"name":"cad_codigo", "value":"'.$cont["cad_codigo"].'", "type":"string"},
									{"name":"ser_codigo", "value":"CTT", "type":"string"},';
								$filtroParc.= ( isset($cont["ccu_codigo"]) && $cont["ccu_codigo"]!="" ) ? '{"name":"ccu_codigo","value":"'.$cont["ccu_codigo"].'","type":"string"},' : '{"name":"ccu_codigo","value":"NULL","type":"other"},';
								$filtroParc.= '{"name":"doc_cod_pai", "value":"NULL", "type":"other"},';
								$filtroParc.= ( isset($cont["plc_codigo"]) && $cont["plc_codigo"]!="" ) ? '{"name":"plc_codigo","value":"'.$cont["plc_codigo"].'","type":"string"},' : '{"name":"plc_codigo", "value":"NULL", "type":"other"},';
								$filtroParc.= '{"name":"cad_codatend", "value":"NULL", "type":"other"},';
								$filtroParc.= ( isset($cont["ctt_carteira"]) && $cont["ctt_carteira"]!="" ) ? '{"name":"doc_carteira", "value":"'.$cont["ctt_carteira"].'", "type":"string"},' : '{"name":"doc_carteira", "value":"NULL", "type":"other"},';
								$filtroParc.= '{"name":"doc_nossonumero", "value":"NULL", "type":"other"},
									{"name":"svc_codigo", "value":"'.$cont["svc_codigo"].'", "type":"integer"},
									{"name":"doc_sacador", "value":"NULL", "type":"other"},';
								$filtroParc.= ( isset($cont["cta_codigo"]) && $cont["cta_codigo"]!="" ) ? '{"name":"cta_codigo","value":"'.$cont["cta_codigo"].'","type":"integer"},' : '{"name":"cta_codigo","value":"NULL","type":"other"},';
								$filtroParc.= '{"name":"doc_dias_protesto", "value":"10", "type":"integer"},
									{"name":"doc_protesto", "value":"0", "type":"integer"},
									{"name":"doc_previsao", "value":"0", "type":"integer"},
									{"name":"doc_origem", "value":"2", "type":"integer"},
									{"name":"doc_origem_codigo", "value":"'.$cont["ctt_codigo"].'", "type":"string"},';
								$filtroParc.= ( isset($cont['ven_codigo']) && $cont['ven_codigo']!="" ) ? '{"name":"cad_codvend", "value":"'.$cont["ven_codigo"].'", "type":"string"},' : '{"name":"cad_codvend", "value":"NULL", "type":"other"},';
								$filtroParc.= '{"name":"doc_comissao", "value":"'.$doc_comissao.'", "type":"float"}';
								$filtroParc.= ']}';

								$datapacket->add($filtroParc);
								
								//log inclusao docto
								$filtrolog = '{"cod":"501240","params":[
									{"name":"lgd_tipo","value":"1","type":"integer"},
									{"name":"doc_codigo","value":"'.$doc_codigo.'","type":"string"},
									{"name":"usu_login","value":"SISTEMA","type":"string"},
									{"name":"lgd_dtatualizada","value":"NULL","type":"other"},
									{"name":"lgd_descr","value":"Documento cadastrado e vinculado ao contrato N '.$cont["ctt_numero"].'","type":"string"}
								]}';
								$datapacket->add($filtrolog);

								$datapacket->open();
								
								//requisição nfs-e
								if( isset($nfse) && is_array($nfse) && $empresa->cfg_gera_nfse==1 ){
									$ch = curl_init();
									curl_setopt($ch,CURLOPT_URL, $_SERVER["HTTP_HOST"]."/desktop/php/nfse.php");
									curl_setopt($ch,CURLOPT_POST, count($nfse));
									curl_setopt($ch,CURLOPT_POSTFIELDS, $nfse);
									curl_setopt($ch,CURLOPT_RETURNTRANSFER, true);
									$resultnfse = curl_exec($ch);
									curl_close($ch);
								}

								$datapacket->clear();
							}
								
						}

						$contador++;
						
					}
					
					$relatorio.= "<br><br>";
				
				}
			
			
				//selecionar todos os boletos (doc_tipo=2) a receber (doc_pagrec=2) em aberto (doc_status=0) que não tenham sido gerados (doc_boletogerado=0; doc_nossonumero IS NULL), que não sejam uma previsão (doc_previsao=0 or doc_previsao IS NULL) ordenados por cliente e vencimento
				$filtro = '{"cod":"500487","params":[
					{"name":"db","value":"'.$empresa->emp_db_comum.'","type":"other"}
				]}';
				$datapacket->add($filtro);
				$boletos = $datapacket->open();
				$cont=1;
				$codigos = "";
				$numeros = "";
				$valor=0;
				$comissao=0;
				$descr="";
				$obs="";
				$vcto="";
				$cad="";
				$vend="";
				$contador=0;
				array_push($boletos, array());
				$rel = array();
				$rel2 = array();
				
				//percorrer os boletos selecionados e verificar os que possuem mesmo vencimento e cliente, criar boleto unificado (soma do valor dos boletos que o compõem) e atualizar grupo de boletos com o código pai do novo boleto único bem como o seu status para agrupado (doc_status=4)
				if($empresa->cfg_agrupa_boleto==1){
					foreach($boletos as $bol){
						// print_r($bol);
						// echo "<br><br>";
						if( isset($bol["doc_dtvcto"]) && $bol["doc_dtvcto"]==$vcto && $bol["cad_codigo"]==$cad ){
							
							if($bol["doc_valor"] >0){
								$bol["doc_valor"] = (float) $bol["doc_valor"];
							}
							
							$codigos.= "'".$bol["doc_codigo"]."', ";
							$numeros.= ($bol["doc_valor"]>0) ? "'".$bol["doc_numero"]."' - R$ ".number_format($bol["doc_valor"], 2, ",", "")." - ".$bol["svc_descr"]."<br>" : "'".$bol["doc_numero"]."' - R$ 0,00 - ".$bol["svc_descr"]."<br>";
							array_push($rel2, array("", "", number_format($bol["doc_valor"], 2, ",", ""), $bol["doc_numero"], $bol["doc_descr"]));
							
							$valor+= $bol["doc_valor"];
							$comissao+= $bol["doc_comissao"];
							$descr.=" - ".$bol["doc_descr"]." (R$ ".number_format($bol["doc_valor"], 2, ",", "").")";
							$obs.=" - ".$bol["doc_obs"]." (R$ ".number_format($bol["doc_valor"], 2, ",", "").")";
							// $obs="";
							
							$cont++;
							
						}elseif($cont>1){
							
							if($contador==0) $relatorio.="<strong>boletos unificados</strong><br><br>";
							
							//boleto unico integrado
							if($valor>0){
								$valor = (float) $valor;
								$valor = number_format($valor, 2, ".", "");
								$comissao = (float) $comissao;
								if($comissao>0) $comissao = number_format($comissao, 2, ".", "");
								
								$cod = substr(str_replace(array(","," ","."),array("","",""),microtime()), -10).mt_rand(10, 9999);
								
								if($vez==1) $relatorio.= "Será ";
								$relatorio.="Gerado boleto único de Nro <strong>".$cod."</strong> para o cliente <strong>".$cli."</strong> no valor de <strong>R$ ".number_format($valor,2,",","")."</strong> com vencimento para <strong>".implode("/", array_reverse(explode("-", substr($vcto,0,10))))."</strong>, composto pelos boletos:<br>".$numeros;
								
								array_push($rel, array($cli, implode("/", array_reverse(explode("-", substr($vcto,0,10)))), number_format($valor,2,",",""), $cod."-1", ""));
								foreach($rel2 as $r){
									array_push($rel, $r);
								}
								
								$filtroParc  = '{"cod":"500134", "params":[
									{"name":"doc_codigo", "value":"'.$cod.'", "type":"string"},
									{"name":"doc_numero", "value":"'.$cod.'-1", "type":"string"},
									{"name":"doc_tipo", "value":"2", "type":"integer"},
									{"name":"doc_pagrec", "value":"2", "type":"integer"},
									{"name":"doc_data", "value":"'.date('Y-m-d H:i:s').'", "type":"string"},
									{"name":"doc_valor", "value":"'.$valor.'", "type":"float"},
									{"name":"doc_dtvcto", "value":"'.$vcto.'", "type":"string"},
									{"name":"doc_dtpgto", "value":"NULL", "type":"other"},
									{"name":"doc_vlrpg", "value":"NULL", "type":"other"},
									{"name":"doc_descr", "value":"'.$descr.'", "type":"string"},
									{"name":"doc_status", "value":"0", "type":"integer"},
									{"name":"doc_codbar", "value":" ", "type":"string"},
									{"name":"doc_linhadig", "value":"NULL", "type":"other"},
									{"name":"doc_banco", "value":"NULL", "type":"other"},
									{"name":"doc_agencia", "value":"NULL", "type":"other"},
									{"name":"doc_conta", "value":"NULL", "type":"other"},';
								$filtroParc.= ( isset($multa) && $multa>0 ) ? '{"name":"doc_multa", "value":"'.$multa.'", "type":"float"},' : '{"name":"doc_multa", "value":"NULL", "type":"other"},';
								$filtroParc.= ( isset($juros) && $juros>0 ) ? '{"name":"doc_juros", "value":"'.$juros.'", "type":"float"},' : '{"name":"doc_juros", "value":"NULL", "type":"other"},';
								$filtroParc.= '{"name":"doc_honorarios", "value":"NULL", "type":"other"},';
								$filtroParc.= ( isset($prev) && $prev>0) ? '{"name":"doc_dias_envio", "value":"'.$prev.'", "type":"integer"},' : '{"name":"doc_dias_envio", "value":"0", "type":"integer"},';
								$filtroParc.= '{"name":"doc_nparc", "value":"1", "type":"integer"},
									{"name":"doc_tparc", "value":"1", "type":"integer"},
									{"name":"doc_json_parcial", "value":"NULL", "type":"other"},
									{"name":"doc_obs", "value":"'.$obs.'", "type":"string"},
									{"name":"cad_codigo", "value":"'.$cad.'", "type":"string"},
									{"name":"ser_codigo", "value":"1", "type":"string"},
									{"name":"ccu_codigo","value":"NULL","type":"other"},
									{"name":"doc_cod_pai", "value":"NULL", "type":"other"},
									{"name":"plc_codigo", "value":"NULL", "type":"other"},
									{"name":"cad_codatend", "value":"NULL", "type":"other"},';
								$filtroParc.= ( isset($carteira) && $carteira!="" ) ? '{"name":"doc_carteira", "value":"'.$carteira.'", "type":"string"},' : '{"name":"doc_carteira", "value":"NULL", "type":"other"},';
								$filtroParc.= '{"name":"doc_nossonumero", "value":"NULL", "type":"other"},
									{"name":"svc_codigo", "value":"NULL", "type":"other"},
									{"name":"doc_sacador", "value":"NULL", "type":"other"},';
								$filtroParc.= ( isset($cta_codigo) && $cta_codigo!="" ) ? '{"name":"cta_codigo","value":"'.$cta_codigo.'","type":"integer"},' : '{"name":"cta_codigo","value":"NULL","type":"other"},';
								$filtroParc.= '{"name":"doc_dias_protesto", "value":"'.$empresa->emp_dias_protesto.'", "type":"integer"},
									{"name":"doc_protesto", "value":"'.$empresa->emp_protesto.'", "type":"integer"},
									{"name":"doc_previsao", "value":"0", "type":"integer"},
									{"name":"doc_origem", "value":"9", "type":"integer"},
									{"name":"doc_origem_codigo", "value":"NULL", "type":"other"},';
								$filtroParc.= ( isset($vend) && $vend!="" ) ? '{"name":"cad_codvend", "value":"'.$vend.'", "type":"string"},' : '{"name":"cad_codvend", "value":"NULL", "type":"other"},';
								$filtroParc.= '{"name":"doc_comissao", "value":"'.$comissao.'", "type":"float"}';
								$filtroParc.= ']}';
								
								$datapacket->add($filtroParc);
								
								$datapacket->open();
								$datapacket->clear();
								
								$filtro  = '{"cod":"500488", "params":[
									{"name":"doc_codigo", "value":"'.substr($codigos, 0, -2).'", "type":"other"},
									{"name":"doc_codigo_pai", "value":"'.$cod.'", "type":"string"}
								]}';
								
								$datapacket->add($filtro);
								
								//log inclusao docto
								$filtrolog = '{"cod":"501240","params":[
									{"name":"lgd_tipo","value":"1","type":"integer"},
									{"name":"doc_codigo","value":"'.$cod.'","type":"string"},
									{"name":"usu_login","value":"SISTEMA","type":"string"},
									{"name":"lgd_dtatualizada","value":"NULL","type":"other"},
									{"name":"lgd_descr","value":"Documento cadastrado a partir do agrupamento de outros documentos","type":"string"}
								]}';
								$datapacket->add($filtrolog);

								$datapacket->open();
								$datapacket->clear();

							}
							
							if( isset($bol["doc_codigo"]) ){
								$rel2 = array();
								$codigos = "'".$bol["doc_codigo"]."', ";
								$numeros = ($bol["doc_valor"]>0) ? "'".$bol["doc_numero"]."' - R$ ".number_format((float)$bol["doc_valor"], 2, ",", "")." - ".$bol["svc_descr"]."<br>" : "'".$bol["doc_numero"]."' - R$ 0,00 - ".$bol["svc_descr"]."<br>";
								array_push($rel2, array("", "", number_format((float)$bol["doc_valor"], 2, ",", ""), $bol["doc_numero"], $bol["doc_descr"]));
								$valor=$bol["doc_valor"];
								$comissao=$bol["doc_comissao"];
								$descr=$bol["doc_descr"]." (R$ ".number_format($bol["doc_valor"], 2, ",", "").")";
								$obs=$bol["doc_obs"]." (R$ ".number_format($bol["doc_valor"], 2, ",", "").")";;
								$vcto = $bol["doc_dtvcto"];
								$multa = $bol["doc_multa"];
								$juros = $bol["doc_juros"];
								$prev = $bol["doc_dias_envio"];
								$cad = $bol["cad_codigo"];
								$vend = $bol["cad_codvend"];
								$cta_codigo = $bol["cta_codigo"];
								$carteira = $bol["doc_carteira"];
								$cli = $bol["cad_nomeraz"];
							}else{
								$valor=0;
								$codigos="";
								$numeros="";
							}
							
							$cont=1;
							$contador++;

						}else{
							
							if( isset($bol["doc_codigo"]) ){
								$rel2 = array();
								$codigos = "'".$bol["doc_codigo"]."', ";
								$numeros = ($bol["doc_valor"]>0) ? "'".$bol["doc_numero"]."' - R$ ".number_format((float)$bol["doc_valor"], 2, ",", "")." - ".$bol["svc_descr"]."<br>" : "'".$bol["doc_numero"]."' - R$ 0,00 - ".$bol["svc_descr"]."<br>";
								array_push($rel2, array("", "", number_format((float)$bol["doc_valor"], 2, ",", ""), $bol["doc_numero"], $bol["doc_descr"]));
								$valor=$bol["doc_valor"];
								$comissao=$bol["doc_comissao"];
								$descr=$bol["doc_descr"]." (R$ ".number_format($bol["doc_valor"], 2, ",", "").")";
								$obs=$bol["doc_obs"]." (R$ ".number_format($bol["doc_valor"], 2, ",", "").")";;
								$vcto = $bol["doc_dtvcto"];
								$multa = $bol["doc_multa"];
								$juros = $bol["doc_juros"];
								$prev = $bol["doc_dias_envio"];
								$cad = $bol["cad_codigo"];
								$vend = $bol["cad_codvend"];
								$cta_codigo = $bol["cta_codigo"];
								$carteira = $bol["doc_carteira"];
								$cli = $bol["cad_nomeraz"];
							}
							
						}
						
					}				
				}
				
				//relatorio anexo
				if(count($rel)>0){
					//requisição para criar relatorio
					$fields = array(
						'p' => $p,
						'vez' => $vez,
						'dados' => $rel
					);
					$fields = http_build_query($fields);
					/*
					$fields_string="";
					foreach($fields as $key=>$value) { $fields_string .= $key.'='.$value.'&'; }
					rtrim($fields_string, '&');
					*/
					//abrir conexao
					$ch = curl_init();
					//define url, numero de variaveis POST e dados POST
					curl_setopt($ch,CURLOPT_URL, $_SERVER["HTTP_HOST"]."/desktop/rel/relRotinaUnificados.php");
					curl_setopt($ch,CURLOPT_POST, true);
					curl_setopt($ch,CURLOPT_RETURNTRANSFER, true);
					curl_setopt($ch,CURLOPT_POSTFIELDS, $fields);
					//executa POST
					$result = curl_exec($ch);
					$anexo1 = $result;  //relatorio anexo
					//fechar conexao
					curl_close($ch);
				}
				
				$relatorio.= "<br><br>";
				
				$datapacket->clear();
				
				if($vez==0){
					//relatorio mensal de aniversariantes
					if( $empresa->cfg_aniversariantes==1 ){
						
						// verifica se ha aniversariantes do dia
						if( $empresa->emp_codigo=="UDSTECNOLOGIA" || $empresa->emp_codigo=="MODELO" ){
							$cad_tipo="4";
						}else{
							$cad_tipo="1";
						}
						$filtro = '{"cod":"500521","params":[
							{"name":"cad_tipo","value":"'.$cad_tipo.'","type":"string"},
							{"name":"db","value":"'.$empresa->emp_db_comum.'","type":"other"}
						]}';
						$datapacket->add($filtro);
						$aniv = $datapacket->open(true);
						$datapacket->clear();
						
						if( (isset($aniv) && isset($aniv[0]) && isset($aniv[0]->total) && $aniv[0]->total>0) || date("w")==5 ){
			
							//montar relatório para anexar no e-mail
							$dados = (date("w")==5) ? array('ordem'=>2, 'cad_tipo'=>$cad_tipo, 'data_ini'=>date("d/m/Y"), 'data_fim'=>date("d/m/Y", strtotime(date("Y-m-d H:i:s")."+ 2 days"))) : array('ordem'=>2, 'cad_tipo'=>$cad_tipo, 'data_ini'=>date("d/m/Y"), 'data_fim'=>date("d/m/Y"));
							$fields = array(
								'p' => $p,
								'emp_codigo' => $empresa->emp_codigo,
								'rotina' => true,
								'dados' => base64_encode(json_encode($dados))
							);
							$ch = curl_init();
							curl_setopt($ch,CURLOPT_URL, $datapacket->HostClient."/rel/relAniversario.php");
							curl_setopt($ch,CURLOPT_POST, true);
							curl_setopt($ch,CURLOPT_RETURNTRANSFER, true);
							curl_setopt($ch,CURLOPT_POSTFIELDS, $fields);
							$result = curl_exec($ch);
							
							$filtro = '{"cod":"700321","params":[
								{"name":"msg_codigo","value":"","type":"string"},
								{"name":"msg_tipo","value":"1","type":"integer"},
								{"name":"men_codigo","value":"0","type":"integer"},
								{"name":"msg_remetente","value":"site@jcmantovan.com.br","type":"string"},
								{"name":"msg_destinatario","value":"'.$empresa->cfg_email_rotina.';","type":"string"},
								{"name":"cad_codigo","value":"","type":"string"},
								{"name":"msg_assunto","value":"Relatorio de aniversariantes do dia","type":"string"},
								{"name":"msg_conteudo","value":"'.base64_encode("Segue em anexo relatorio de todos os aniversariantes de hoje").'","type":"string"},
								{"name":"msg_data","value":"'.date("Y-m-d H:i:s").'","type":"string"},
								{"name":"msg_dtenvio","value":"'.date("Y-m-d H:i:s").'","type":"string"},
								{"name":"msg_status","value":"0","type":"integer"},
								{"name":"msg_anexo","value":"","type":"string"}
							]}';
							$datapacket->add($filtro);
							$ret = $datapacket->open(false, true); //codigo da mensagem criada
							$datapacket->clear();
							
							//anexar relatorio
							$fields = array(
								'p' => $p,
								'acao' => 'anexar',
								'msg_codigo' => $ret,
								'ane_descricao' => base64_encode("Relatorio de aniversariantes do mes"),
								'msg_anexo' => new CURLFile("/var/www".$result)
							);
							$ch = curl_init();
							curl_setopt($ch,CURLOPT_URL, $_SERVER["HTTP_HOST"]."/desktop/php/mensagem.php");
							curl_setopt($ch,CURLOPT_POST, true);
							curl_setopt($ch,CURLOPT_SAFE_UPLOAD, false);
							curl_setopt($ch,CURLOPT_POSTFIELDS, $fields);
							$result = curl_exec($ch);
							curl_close($ch);
							
							//enviar mensagem
							if($ret){
								$fields = array(
									'p' => $p,
									'acao' => 'enviar',
									'msg_codigo' => $ret
								);
								$fields_string="";
								foreach($fields as $key=>$value) { $fields_string .= $key.'='.$value.'&'; }
								rtrim($fields_string, '&');
								$ch = curl_init();
								curl_setopt($ch,CURLOPT_URL, $_SERVER["HTTP_HOST"]."/desktop/php/mensagem.php");
								curl_setopt($ch,CURLOPT_POST, count($fields));
								curl_setopt($ch,CURLOPT_POSTFIELDS, $fields_string);
								$result = curl_exec($ch);
								curl_close($ch);
							}
						
						}
					
					}
				}
				
				//selecionar boletos marcados para envio automático cujos dias antecedentes para envio (emp_dias_envio) coincida com a diferença entre o vencimento e a data base para calculo
				$filtro = '{"cod":"500484","params":[
					{"name":"emp_codigo","value":"'.$empresa->emp_codigo.'","type":"string"},
					{"name":"dbcomum","value":"'.$empresa->emp_db_comum.'","type":"other"},
					{"name":"emp_dias_envio","value":"'.$empresa->emp_dias_envio.'","type":"integer"},
					{"name":"data_base","value":"'.$data_base.'","type":"string"}
				]}';
				$datapacket->add($filtro);
				$res = $datapacket->open();
				$datapacket->clear();
				
				$doctos = array();
				$emails = array();
				$carteiras = array();
				$ant="";
				$rel = array();
		
				//percorre boletos selecionados e monta array com: boleto e e-mail(s) para envio
				if( isset($res) && is_array($res) && $empresa->cfg_envia_boleto==1 ){
					foreach($res as $r){
						
						if( $ant!=$r["doc_codigo"] ){
							
							$emails[$r["doc_codigo"]]="";
							$carteiras[$r["doc_codigo"]]="";
							
							if($r["doc_valor"]>0){
								
								$r["doc_valor"] = (float) $r["doc_valor"];
								
								if($r["email"] && $r["email"]!=""){
									
									if($vez==1) $relatorio.= "Será ";
									$relatorio.= "Enviado boleto Nro: <strong>".$r["doc_numero"]."</strong> de valor <strong>R$ ".number_format($r["doc_valor"],2,",","")."</strong>, vencimento <strong>".implode("/", array_reverse(explode("-", substr($r["doc_dtvcto"],0,10))))."</strong> e carteira <strong>".$r["doc_carteira"]."</strong> para o e-mail <strong>".strtolower($r["email"])."</strong> do cliente <strong>".$r["cad_nomeraz"]."</strong><br><br>";
									
									array_push($rel, array( $r["doc_numero"], $r["cad_nomeraz"], number_format($r["doc_valor"],2,",",""), implode("/", array_reverse(explode("-", substr($r["doc_dtvcto"],0,10)))), $r["doc_carteira"], strtolower($r["email"]) ));
								
									$emails[$r["doc_codigo"]].=strtolower($r["email"]);
									$carteiras[$r["doc_codigo"]].=$r["doc_carteira"];
									
								}
								array_push($doctos, $r["doc_codigo"]);
							}
							$ant=$r["doc_codigo"];
							
						}else{
							
							if($r["email"] && $r["email"]!=""){
								
								if($vez==1) $relatorio.= "Será ";
								$relatorio.= "Enviado boleto Nro: <strong>".$r["doc_numero"]."</strong> de valor <strong>R$ ".number_format($r["doc_valor"],2,",","")."</strong>, vencimento <strong>".implode("/", array_reverse(explode("-", substr($r["doc_dtvcto"],0,10))))."</strong> e carteira <strong>".$r["doc_carteira"]."</strong> para o e-mail <strong>".strtolower($r["email"])."</strong> do cliente <strong>".$r["cad_nomeraz"]."</strong><br><br>";
								
								$rel[(count($rel)-1)][5].= "; ".strtolower($r["email"]);
								// array_push($rel, array( $r["doc_numero"], $r["cad_nomeraz"], number_format($r["doc_valor"],2,",",""), implode("/", array_reverse(explode("-", substr($r["doc_dtvcto"],0,10)))), $r["doc_carteira"], strtolower($r["email"]) ));
								
								$emails[$r["doc_codigo"]].=";".strtolower($r["email"]);
								
							}
							
						}
						
					}
				}
				
				//relatorio anexo
				if(count($rel)>0){
					//requisição para criar relatorio
					$fields = array(
						'p' => $p,
						'vez' => $vez,
						'dados' => $rel		
					);
					$fields = http_build_query($fields);
					/*
					$fields_string="";
					foreach($fields as $key=>$value) { $fields_string .= $key.'='.$value.'&'; }
					rtrim($fields_string, '&');
					*/
					//abrir conexao
					$ch = curl_init();
					//define url, numero de variaveis POST e dados POST
					curl_setopt($ch,CURLOPT_URL, $_SERVER["HTTP_HOST"]."/desktop/rel/relRotinaEnviados.php");
					curl_setopt($ch,CURLOPT_POST, true);
					curl_setopt($ch,CURLOPT_RETURNTRANSFER, true);
					curl_setopt($ch,CURLOPT_POSTFIELDS, $fields);
					//executa POST
					$result = curl_exec($ch);
					$anexo2 = $result;  //relatorio anexo
					//fechar conexao
					curl_close($ch);
				}
				
				//selecionar boletos (doc_tipo=2) em aberto (doc_status=0) a receber (doc_pagrec=2) cujo vencimento seja um dia antecedente a data base ou 2 dias de atraso.
				//caso seja uma segunda, não verifica atrasados (vencimentos em finais de semana podem ser pagos na segunda)
				if( $empresa->cfg_envia_lembrete && $empresa->cfg_envia_lembrete==1 ){
					if( date("l")=="Monday" ){
						$filtro = '{"cod":"500516","params":[
							{"name":"db","value":"'.$empresa->emp_db_sge.'","type":"other"},
							{"name":"dbcomum","value":"'.$empresa->emp_db_comum.'","type":"other"},
							{"name":"data_base","value":"'.$data_base.'","type":"string"}
						]}';					
					}else{
						$filtro = '{"cod":"500515","params":[
							{"name":"db","value":"'.$empresa->emp_db_sge.'","type":"other"},
							{"name":"dbcomum","value":"'.$empresa->emp_db_comum.'","type":"other"},
							{"name":"data_base","value":"'.$data_base.'","type":"string"}
						]}';
					}
					$datapacket->add($filtro);
					$res = $datapacket->open();
					$datapacket->clear();
					$ant="";
					$rel = array();
			
					//percorre boletos selecionados e monta array com: boleto e e-mail(s) para envio (lembretes de vencimento)
					if( isset($res) && is_array($res) ){
						foreach($res as $r){
							
							if( $ant!=$r["doc_codigo"] ){
								
								$emails[$r["doc_codigo"]]="";
								
								if($r["doc_valor"]>0){
									
									$r["doc_valor"] = (float) $r["doc_valor"];
									
									if($r["email"] && $r["email"]!=""){
										
										if($vez==1) $relatorio.= "Será ";
										$relatorio.= "Enviado lembrete de vencimento do boleto Nro: <strong>".$r["doc_numero"]."</strong> de valor <strong>R$ ".number_format($r["doc_valor"],2,",","")."</strong> e vencimento original <strong>".implode("/", array_reverse(explode("-", substr($r["doc_dtvcto"],0,10))))."</strong> para o e-mail <strong>".strtolower($r["email"])."</strong> do cliente <strong>".$r["cad_nomeraz"]."</strong><br><br>";
										
										array_push($rel, array( $r["doc_numero"], $r["cad_nomeraz"], number_format($r["doc_valor"],2,",",""), implode("/", array_reverse(explode("-", substr($r["doc_dtvcto"],0,10)))), $r["doc_carteira"], strtolower($r["email"]) ));
									
										$emails[$r["doc_codigo"]].=strtolower($r["email"]);
										
									}
									array_push($doctos, $r["doc_codigo"]);
								}
								$ant=$r["doc_codigo"];
								
							}else{
								
								if($r["email"] && $r["email"]!=""){
									
									if($vez==1) $relatorio.= "Será ";
									$relatorio.= "Enviado lembrete de vencimento do boleto Nro: <strong>".$r["doc_numero"]."</strong> de valor <strong>R$ ".number_format($r["doc_valor"],2,",","")."</strong> e vencimento original <strong>".implode("/", array_reverse(explode("-", substr($r["doc_dtvcto"],0,10))))."</strong> para o e-mail <strong>".strtolower($r["email"])."</strong> do cliente <strong>".$r["cad_nomeraz"]."</strong><br><br>";
									
									array_push($rel, array( $r["doc_numero"], $r["cad_nomeraz"], number_format($r["doc_valor"],2,",",""), implode("/", array_reverse(explode("-", substr($r["doc_dtvcto"],0,10)))), $r["doc_carteira"], strtolower($r["email"]) ));
									
									$emails[$r["doc_codigo"]].=";".strtolower($r["email"]);
									
								}
								
							}
							
						}
					}
				}
				
				//relatorio anexo
				if(count($rel)>0){
					//requisição para criar relatorio
					$fields = array(
						'p' => $p,
						'vez' => $vez,
						'lembrete' => '1',
						'dados' => $rel		
					);
					$fields = http_build_query($fields);
					//abrir conexao
					$ch = curl_init();
					//define url, numero de variaveis POST e dados POST
					curl_setopt($ch,CURLOPT_URL, $_SERVER["HTTP_HOST"]."/desktop/rel/relRotinaEnviados.php");
					curl_setopt($ch,CURLOPT_POST, true);
					curl_setopt($ch,CURLOPT_RETURNTRANSFER, true);
					curl_setopt($ch,CURLOPT_POSTFIELDS, $fields);
					//executa POST
					$result = curl_exec($ch);
					$anexo3 = $result;  //relatorio anexo
					//fechar conexao
					curl_close($ch);
				}
				
				//relatorio por e-mail
				if(trim(strip_tags($relatorio))!="" && $empresa->cfg_envia_rel==1){
					
					$compl = ( $vez==1 ) ? "Previsão para ".implode("/", array_reverse(explode("-", substr($data_base,0,10)))) : "Executada";
					$assunto = "Relatório Rotina Fácil  - ".$compl;
					
					$filtro = '{"cod":"700321","params":[
						{"name":"msg_codigo","value":"","type":"string"},
						{"name":"msg_tipo","value":"1","type":"integer"},
						{"name":"men_codigo","value":"0","type":"integer"},
						{"name":"msg_remetente","value":"site@jcmantovan.com.br","type":"string"},
						{"name":"msg_destinatario","value":"'.$empresa->cfg_email_rotina.'","type":"string"},
						{"name":"cad_codigo","value":"","type":"string"},
						{"name":"msg_assunto","value":"'.$assunto.'","type":"string"},
						{"name":"msg_conteudo","value":"'.base64_encode(utf8_decode($relatorio)).'","type":"string"},
						{"name":"msg_data","value":"'.date("Y-m-d H:i:s").'","type":"string"},
						{"name":"msg_dtenvio","value":"'.date("Y-m-d H:i:s").'","type":"string"},
						{"name":"msg_status","value":"0","type":"integer"},
						{"name":"msg_anexo","value":"","type":"string"}
					]}';
					$datapacket->add($filtro);
					$ret = $datapacket->open(false, true); //codigo da mensagem criada
					$datapacket->clear();
					
					//anexar relatorios
					if( isset($anexo1) && $anexo1!="" ){
						$fields = array(
							'p' => $p,
							'acao' => 'anexar',
							'msg_codigo' => $ret,
							'ane_descricao' => base64_encode("Relatorio"),
							'msg_anexo' => new CURLFile("/var/www".$anexo1)
						);
						$ch = curl_init();
						curl_setopt($ch,CURLOPT_URL, $_SERVER["HTTP_HOST"]."/desktop/php/mensagem.php");
						curl_setopt($ch,CURLOPT_POST, true);
						curl_setopt($ch,CURLOPT_SAFE_UPLOAD, false);
						curl_setopt($ch,CURLOPT_POSTFIELDS, $fields);
						curl_exec($ch);
						curl_close($ch);
						$anexo1="";
					}
					if( isset($anexo2) && $anexo2!="" ){
						$fields = array(
							'p' => $p,
							'acao' => 'anexar',
							'msg_codigo' => $ret,
							'ane_descricao' => base64_encode("Relatorio"),
							'msg_anexo' => new CURLFile("/var/www".$anexo2)
						);
						$ch = curl_init();
						curl_setopt($ch,CURLOPT_URL, $_SERVER["HTTP_HOST"]."/desktop/php/mensagem.php");
						curl_setopt($ch,CURLOPT_POST, true);
						curl_setopt($ch,CURLOPT_SAFE_UPLOAD, false);
						curl_setopt($ch,CURLOPT_POSTFIELDS, $fields);
						curl_exec($ch);
						curl_close($ch);
						$anexo2="";
					}
					if( isset($anexo3) && $anexo3!="" ){
						$fields = array(
							'p' => $p,
							'acao' => 'anexar',
							'msg_codigo' => $ret,
							'ane_descricao' => base64_encode("Relatorio"),
							'msg_anexo' => new CURLFile("/var/www".$anexo3)
						);
						$ch = curl_init();
						curl_setopt($ch,CURLOPT_URL, $_SERVER["HTTP_HOST"]."/desktop/php/mensagem.php");
						curl_setopt($ch,CURLOPT_POST, true);
						curl_setopt($ch,CURLOPT_SAFE_UPLOAD, false);
						curl_setopt($ch,CURLOPT_POSTFIELDS, $fields);
						curl_exec($ch);
						curl_close($ch);
						$anexo3="";
					}
					
					//enviar mensagem
					if($ret){
						$fields = array(
							'p' => $p,
							'acao' => 'enviar',
							'msg_codigo' => $ret
						);
						$fields_string="";
						foreach($fields as $key=>$value) { $fields_string .= $key.'='.$value.'&'; }
						rtrim($fields_string, '&');
						$ch = curl_init();
						curl_setopt($ch,CURLOPT_URL, $_SERVER["HTTP_HOST"]."/desktop/php/mensagem.php");
						curl_setopt($ch,CURLOPT_POST, count($fields));
						curl_setopt($ch,CURLOPT_POSTFIELDS, $fields_string);
						$result = curl_exec($ch);
						curl_close($ch);
					}
					$relatorio="";
				}
				$datapacket->clear();
				
				if($vez==0){
					//percorre todos os boletos selecionados, gera e faz o envio por e-mail
					
					foreach($doctos as $doc){
						
						//resetar dias para envio (marcar como já enviado)
						$filtro = '{"cod":"500501","params":[
							{"name":"doc_codigo","value":"'.$doc.'","type":"string"}
						]}';
						$datapacket->add($filtro);
						
						$to = explode(";", $emails[$doc]);
						
						if( is_array($to) ){
							
							foreach($to as $t){
								
								$fields = array(
									'p' => $p,
									'email' => json_encode($t), //linha com o e-mail do cliente (descomentar após testes)
									// 'email' => json_encode("julio@grupouds.com.br"), //remover esta linha
									'doc_codigo' => urlencode($doc)
								);

								//url-ify os dados para o POST
								$fields_string="";
								foreach($fields as $key=>$value) { $fields_string .= $key.'='.$value.'&'; }
								rtrim($fields_string, '&');

								//abrir conexao
								$ch = curl_init();

								//define url, numero de variaveis POST e dados POST
								curl_setopt($ch,CURLOPT_URL, $_SERVER["HTTP_HOST"]."/desktop/rel/relboleto.php");
								curl_setopt($ch,CURLOPT_POST, count($fields));
								curl_setopt($ch,CURLOPT_POSTFIELDS, $fields_string);

								//executa POST
								$result = curl_exec($ch);
								// if($carteiras && $carteiras[$doc] && && $carteiras[$doc]==112) sleep(6);
								//fechar conexao
								curl_close($ch);
								
							}
							
						}else{
							
							$fields = array(
								'p' => $p,
								'email' => json_encode($emails[$doc]), //linha com o e-mail do cliente (descomentar após testes)
								// 'email' => json_encode("julio@grupouds.com.br"), //remover esta linha
								'doc_codigo' => urlencode($doc)
							);

							//url-ify os dados para o POST
							$fields_string="";
							foreach($fields as $key=>$value) { $fields_string .= $key.'='.$value.'&'; }
							rtrim($fields_string, '&');

							//abrir conexao
							$ch = curl_init();

							//define url, numero de variaveis POST e dados POST
							curl_setopt($ch,CURLOPT_URL, $_SERVER["HTTP_HOST"]."/desktop/rel/relboleto.php");
							curl_setopt($ch,CURLOPT_POST, count($fields));
							curl_setopt($ch,CURLOPT_POSTFIELDS, $fields_string);
							
							//executa POST
							$result = curl_exec($ch);
							// if($carteiras && $carteiras[$doc] && && $carteiras[$doc]==112) sleep(6);
							//fechar conexao
							curl_close($ch);
							
						}
						
					}
						
					$datapacket->open();
					$datapacket->clear();
					
				}
				
			}

		}
	
	}else{
		exit("Nâo há empresas habilitadas para a execução da rotina");
	}
	

?>
