<?php

	setlocale (LC_ALL, 'pt_BR.UTF-8');
	set_time_limit(1500);
	error_reporting(E_ALL ^ E_NOTICE);
	
	include_once "../class/useful.php";
	include_once '../php/TParams.class.php';
	include_once "../class/PHPMailer_v5.1/class.phpmailer.php";

	$Useful = new Useful();
	$datapacket=new TParams();
	$datapacket->clear();
	$datapacket->debug(true);

	function diffDate($d1, $d2){
		$d1 = explode("-", $d1);
		$d2 = explode("-", $d2);
		$X = 86400;
		return floor( ( ( mktime(0, 0, 0, $d2[1], $d2[2], $d2[0]) - mktime(0, 0, 0, $d1[1], $d1[2], $d1[0] ) ) / $X ) );
	}
	
	$arr1 = array("á", "à", "ã", "â", "Á", "À", "Ã", "Â", "é", "ê", "É", "Ê", "í", "Í", "ó", "õ", "ô", "Ó", "Ô", "Õ", "ú", "ü", "Ú", "Ü", "ç", "Ç", "º", "ª", "\"", "'", "\n");
	$arr2 = array("a", "a", "a", "a", "A", "A", "A", "A", "e", "e", "E", "E", "i", "I", "o", "o", "o", "O", "O", "O", "u", "u", "U", "U", "c", "C", "", "", "", "", "");
	
	$datapacket->setHost($datapacket->getHost("empresas"));
	
	// selecionar todas as empresas marcadas para executar a rotina (cfg_rotina=1)
	$datapacket=new TParams();
	$datapacket->clear();
	$datapacket->setHost($datapacket->getHost("empresas"));
	$filtro = '{"cod":"600005","params":[]}';
	$datapacket->add($filtro);
	$empresas = $datapacket->open(true);
	$datapacket->clear();
	
	//verifica se há empresas para executar a rotina
	if( isset($empresas) && count($empresas)>0 ){
		
		//percorre empresas da rotina
		foreach($empresas as $empresa){
			
			//atribuir banco de dados
			$datapacket->setHost($datapacket->getHost($empresa->emp_db_sge));
			
			$p = base64_encode($empresa->emp_codigo);
			$p = substr($p, 0, 1)."2".substr($p, 1);
			
			//Enviar mensagens de e-mail agendadas (módulo de mensagens)
			if($empresa->cfg_envia_msg==1){
				$data1 = date("Y-m-d H:i:s", strtotime(date("Y-m-d H:i:s") . " - 10 minutes"));
				
				$filtro = '{"cod":"700814","params":[
					{"name":"data1","value":"'.$data1.'","type":"string"},
					{"name":"data2","value":"'.date("Y-m-d H:i:s").'","type":"string"}
				]}';
				$datapacket->add($filtro);
				$res = $datapacket->open();
				$datapacket->clear();
				//print_r($filtro);
				//print_r($res);
				
				if( isset($res) && is_array($res) && count($res)>0 ){
					
					
					foreach( $res as $msg ){
						echo $msg["msg_codigo"]."<br>";
						
						//requisição para envio das mensagens
						$fields = array(
							'p' => $p,
							'acao' => 'enviar',
							'msg_codigo' => $msg["msg_codigo"]
						);

						//url-ify os dados para o POST
						$fields_string="";
						foreach($fields as $key=>$value) { $fields_string .= $key.'='.$value.'&'; }
						rtrim($fields_string, '&');

						//abrir conexao
						$ch = curl_init();

						//define url, numero de variaveis POST e dados POST
						curl_setopt($ch,CURLOPT_URL, $_SERVER["HTTP_HOST"]."/desktop/php/mensagem.php");
						curl_setopt($ch,CURLOPT_POST, count($fields));
						curl_setopt($ch,CURLOPT_POSTFIELDS, $fields_string);

						//executa POST
						$result = curl_exec($ch);

						//fechar conexao
						curl_close($ch);
						
						

					}
					
					echo $empresa->emp_codigo;
				}
			}
					
			
		}
	}
			
?>