<?php
	date_default_timezone_set("America/Sao_Paulo");
	
	require_once("../class/sintegra.php");
	require_once("datapacket.php");
	require_once("TParams.class.php");
	
	$TParams=new TParams();
	// --> Registro Sintegra a ser gerado até o presente momento 50, 51, 53, 54, 60M, 60A, 60D, 60I, 60R e 75
	
	// function para tratamento de caracteres especiais...
	function substitui($str_string){
		$str_string = utf8_decode($str_string);
		$str="";
		$find    = array("á","à","ã","â","ä","é","è","ê","ë","í","ì","î","ï","ó","ò","õ","ô","ö","ú","ù","û","ü","ç","Á","À","Ã","Â","Ä","É","È","Ê","Ë","Í","Ì","Î","Ï","Ó","Ò","Õ","Ô","Ö","Ú","Ù","Û","Ü","Ç","?","!","(",")","&");
		$replace = array("a","a","a","a","a","e","e","e","e","i","i","i","i","o","o","o","o","o","u","u","u","u","c","A","A","A","A","A","E","E","E","E","I","I","I","I","O","O","O","O","O","U","U","U","U","C","","","","","");
		$str = str_replace($find, $replace, $str_string);
		return $str;
	}
	
	$company = $TParams->getCompany();
	
	//data da geração
	$not_dtfatini  = $_REQUEST["ini"]." 00:00:00";
	$not_dtfatfim = $_REQUEST["fim"]." 23:59:59";
	$not_tipo = ""; //esvaziar
	
	//tipo de documento
	if( (isset($_REQUEST["nfe_entrada"]) && $_REQUEST["nfe_entrada"]==true) || (isset($_REQUEST["nfe_saida"]) && $_REQUEST["nfe_saida"]==true) ){
		$not_tipo.= "(not_tipo=9 ";
		if($_REQUEST["nfe_entrada"]==true && $_REQUEST["nfe_saida"]==false){
			$not_tipo.= " and not_entrsaida=1) ";
		}elseif($_REQUEST["nfe_entrada"]==false && $_REQUEST["nfe_saida"]==true){
			$not_tipo.= " and not_entrsaida=2) ";
		}else{
			$not_tipo.= ") ";
		}
		if( (isset($_REQUEST["nfce"]) && $_REQUEST["nfce"]==true) ){
			$not_tipo.= " or not_tipo=12 ";
		}
	}elseif( isset($_REQUEST["nfce"]) && $_REQUEST["nfce"]==true ){
		$not_tipo.= "not_tipo=12 ";
	}
	
	$filtroJanela =  '{"cod":"700694","params":[
		{"name":"db","value":"'.$company->{"emp_db_comum"}.'","type":"other"},
		{"name":"not_tipo","value":"'.$not_tipo.'","type":"other"},
		{"name":"not_dtfatini","value":"'.$not_dtfatini.'","type":"string"},
		{"name":"not_dtfatfim","value":"'.$not_dtfatfim.'","type":"string"}
	]}';
	
	$dataPacket = new DataPacket();
	$dataPacket->setHost($TParams->getHost($company->emp_db_sge));				
	$dataPacket->add($filtroJanela);
	$notas = $dataPacket->open(true);
	
	$companySintegra = json_decode(base64_decode($company->{"emp_sintegra"}));

	$_sint=new TSintegra();
	//$_sint->SetZipDate(substr($not_dtfatini,0,4).substr($not_dtfatini,5,2));
	//$_sint->SetEmpCodigo($company->emp_codigo);
	//$_sint->FileName='sintegra1.txt';
	$_sint->VersaoValidador=TVersaoValidador::$vv523;

	// Registro 10		
	$_sint->Registro10->CNPJ = $company->{"emp_cpfcnpj"};
	$_sint->Registro10->Inscricao = $company->{"emp_inscrg"};
	$_sint->Registro10->RazaoSocial = substitui($company->{"emp_razao"});
	$_sint->Registro10->Cidade = substitui($company->{"emp_cidade"});
	$_sint->Registro10->Estado = $company->{"emp_uf"};
	$_sint->Registro10->Telefone = $company->{"emp_fone"};
	
	$_sint->Registro10->DataInicial = $not_dtfatini;		
	$_sint->Registro10->DataFinal = $not_dtfatfim;		
	$_sint->Registro10->CodigoConvenio = $companySintegra[0]->{"cod_conv"};
	$_sint->Registro10->NaturezaInformacoes = $companySintegra[0]->{"nat_info"};
	$_sint->Registro10->FinalidadeArquivo = $companySintegra[0]->{"fin_arq"};
	
	// Registro 11
	$_sint->Registro11->Endereco = substitui($company->{"emp_endereco"});
	$_sint->Registro11->Numero = $company->{"emp_num"};
	$_sint->Registro11->Complemento = '';
	$_sint->Registro11->Bairro = substitui($company->{"emp_bairro"});
	$_sint->Registro11->Cep = $company->{"emp_cep"};
	$_sint->Registro11->Responsavel = substitui($companySintegra[0]->{"responsavel"});
	$_sint->Registro11->Telefone = $company->{"emp_fone"};
	
	$itens75=array();
	$array50=array();

	try{
		$ant="";
		
		foreach($notas as $nota){

			$notcodigo = $nota->{'not_codigo'};
			if($ant != $notcodigo){
				$nitem = 1;
				$ant = $notcodigo;
			}
			$filtroItem = '{"cod":"700695","params":[{"name":"database","value":"'.$company->{"emp_db_comum"}.'","type":"other"},{"name":"not_codigo","value":"'.$notcodigo.'","type":"string"}]}';
			$datapacket_item = new DataPacket();
			$datapacket_item->setHost($TParams->getHost($company->{"emp_db_sge"}));
			$datapacket_item->add($filtroItem);
			$item_nota = $datapacket_item->open(true);
			
			$status = $nota->{'not_cstat'};
				
				//=====================================================================INICIO DO REGISTRO 50========================================================================//				
				if ($companySintegra[0]->{'reg50'}==1){
					$wregistro50=new TRegistro50();
					$UF = ($nota->{'not_entrsaida'}==2 && $nota->{'not_tipo'}==9) ? $nota->{'cad_uf'} : $company->{"emp_uf"};
					$wregistro50->CPFCNPJ = ($nota->{'not_entrsaida'}==2 && $nota->{'not_tipo'}==9) ? $nota->{'cad_cnpjcpf'} : $company->{'emp_cpfcnpj'};
					if($UF=="EX") $wregistro50->CPFCNPJ = 0;
					if($nota->{'cad_pessoa'}==1){
						$wregistro50->Inscricao = "ISENTO        ";
					}else{
						if($nota->{'not_entrsaida'}==2 && $nota->{'not_tipo'}==9){
							if( isset($nota->{'cad_inscrg'}) && $nota->{'cad_inscrg'}!="" && is_numeric($nota->{'cad_inscrg'}) ){
								$wregistro50->Inscricao = $nota->{'cad_inscrg'};
							}else{
								$wregistro50->Inscricao = "ISENTO        ";
							}
						}else{
							$wregistro50->Inscricao = $company->{'emp_inscrg'};
						}
					}
					$wregistro50->DataDocumento = $nota->{'not_dtfaturam'};	
					$wregistro50->UF = $UF;
					
					$mod=$company->{'emp_amb_nfe'};
					if ($mod != 0){
						$mod = 55;
					}else{
						if ($companySintegra[0]->{"reg60M"}==1){
							$mod = 33;
							$modDoc = "2D";
						}elseif ($companySintegra[0]->{"reg60A"}==1){
							$mod = 33;
						}elseif ($companySintegra[0]->{"reg60D"}==1){
							$mod = 33;
						}elseif ($companySintegra[0]->{"reg60I"}==1){
							$mod = 33;
							$modDoc = "2D";
						}elseif ($companySintegra[0]->{"reg60R"}==1){
							$mod = 33;
						}
						if ($mod == 0){
							$mod = $nota->{'ser_codigo'}; 
							if ($mod == 1){
								$mod = 01;			
							}elseif ($mod == '1A'){
								$mod = 01;			
							}elseif ($mod == 'A1'){
								$mod = 01;			
							}elseif ($mod == 'UN'){
								$mod = 01;	
							}else{
								$mod = 02;	
							}
						}
					}
					
					// $mod = ($nota->{'not_tipo'}==9) ? 55 : 65;
					$wregistro50->Modelo=$mod;
					$wregistro50->Serie=$nota->{'ser_codigo'};
					$wregistro50->Numero=$nota->{'not_numero'};
					$wregistro50->CFOP=$nota->{'cfo_codigo'};					
					$empCNPJ=$company->{"emp_cpfcnpj"};
					$cliCNPJ=$nota->{'cad_cnpjcpf'};
					if ($empCNPJ == $cliCNPJ){
						$wregistro50->EmissorDocumento='T';
					}else{
						$wregistro50->EmissorDocumento='P';
					}
					
					$valorContabil = 0;
					$valorBaseDeCalculo = 0;
					$valorIcms = 0;
					$valorIsentas = 0;
					$valorOutras = 0;
					$aliq=($nota->{'not_aliq'}>0) ? $nota->{'not_aliq'} : 0;
					
					foreach($item_nota as $itn){
						$tribjson = json_decode(base64_decode($itn->{'itn_tribjson'}));
						$cfop = ( isset($tribjson->{"rowdata"}[0]->{"ref_cfop"}) && $tribjson->{"rowdata"}[0]->{"ref_cfop"}!="" ) ? $tribjson->{"rowdata"}[0]->{"ref_cfop"} : $itn->{'cfo_codigo'};
						
						if($nota->{'cfo_codigo'}==$cfop){
							$valorContabil+=($itn->{'itn_qtde'} * ($itn->{'itn_valor'} + $itn->{'itn_ipi'} + $itn->{'itn_icmssubst'}) );
							$valorBaseDeCalculo+=$itn->{'itn_baseicms'};
							$valorIcms+=$itn->{'itn_icms'};
							$situacao=$itn->{'tri_situacao'};
							if($situacao=='30' or $situacao=='40' or $situacao=='41'){
								$valorIsentas = $valorIsentas + ($itn->{'itn_qtde'} * $itn->{'itn_valor'});
							}elseif($situacao=='50' or $situacao=='51' or $situacao=='90'){
								$valorOutras = $valorOutras + ($itn->{'itn_qtde'} * $itn->{'itn_valor'});
							}
						}						
					}			
					
					$wregistro50->ValorContabil = $valorContabil;
					$wregistro50->BaseDeCalculo = $valorBaseDeCalculo; 
					$wregistro50->Icms = $valorIcms; 
					$wregistro50->Isentas = $valorIsentas;
					$wregistro50->Outras = $valorOutras;
					
					$wregistro50->Aliquota=$aliq;
					if ($status == 100){
						$t = 'N'; // Autorizado o uso da NF-e
					}elseif ($status == 101){
						$t = 'S'; // Cancelamento de NF-e homologado
					}elseif ($status == 102){
						$t = '4'; // Inutilização de número homologado
					}elseif ($status == 110){
						$t = '2'; // Uso Denagado
					}else{
						$t = 'N';
					}
					$wregistro50->Situacao = $t;
					if($valorContabil>0) $_sint->Registros50->Add($wregistro50);
				}
				//======================================================================FIM DO REGISTRO 50==========================================================================//

				//=====================================================================INICIO DO REGISTRO 51========================================================================//
				if ($companySintegra[0]->{'reg51'}==1 && $nota->{"not_tipo"}==9){
					$wregistro51=new TRegistro51();
					$UF = ($nota->{'not_entrsaida'}==2 && $nota->{'not_tipo'}==9) ? $nota->{'cad_uf'} : $company->{"emp_uf"};
					$wregistro51->CPFCNPJ = ($nota->{'not_entrsaida'}==2 && $nota->{'not_tipo'}==9) ? $nota->{'cad_cnpjcpf'} : $company->{'emp_cpfcnpj'};
					if($UF=="EX") $wregistro51->CPFCNPJ = 0;
					if($nota->{'cad_pessoa'}==1){
						$wregistro51->Inscricao = "ISENTO        ";
					}else{
						if($nota->{'not_entrsaida'}==2 && $nota->{'not_tipo'}==9){
							if( isset($nota->{'cad_inscrg'}) && $nota->{'cad_inscrg'}!="" && is_numeric($nota->{'cad_inscrg'}) ){
								$wregistro51->Inscricao = $nota->{'cad_inscrg'};
							}else{
								$wregistro51->Inscricao = "ISENTO        ";
							}
						}else{
							$wregistro51->Inscricao = $company->{'emp_inscrg'};
						}
					}
					$wregistro51->DataDocumento = $nota->{'not_dtfaturam'};
					$wregistro51->Estado = $UF;
					$wregistro51->Serie = $nota->{'ser_codigo'};
					$wregistro51->Numero  =$nota->{'not_numero'};
					$wregistro51->CFOP = $nota->{'cfo_codigo'};
					$wregistro51->ValorContabil = $nota->{'not_totalnota'};
					$wregistro51->ValorIpi = $nota->{'not_totipi'};
					$valorOutrasIPI = 0;
					$valorIsentasIPI = 0;
					if ($company->{"emp_codregtrib"} == 3){
						foreach($item_nota as $itn){
							$situacao=$itn->{'tri_sit_ipi'};
							if ($situacao=='02' or $situacao=='03' or $situacao=='52' or $situacao=='53'){
								$valorIsentasIPI = $valorIsentasIPI + ($itn->{'itn_qtde'} * $itn->{'itn_valor'});
							}elseif($situacao=='00' or $situacao=='01' or $situacao=='04' or $situacao=='05' or $situacao=='49' or
									$situacao=='50' or $situacao=='51' or $situacao=='54' or $situacao=='55' or $situacao=='90'){
								$valorOutrasIPI = $valorOutrasIPI + ($itn->{'itn_qtde'} * $itn->{'itn_valor'});
							}else{
								$valorIsentasIPI = 0;
								$valorOutrasIPI = 0;
							}
						}
					}else{	
						$valorIsentasIPI = $nota->{'not_totalnota'};
					}
					
					$wregistro51->ValorOutras = $valorOutrasIPI;
					$wregistro51->ValorIsentas = $valorIsentasIPI;		
					if ($status == 100){
						$t = 'N'; 
					}elseif ($status == 101){
						$t = 'S'; 
					}elseif ($status == 102){
						$t = '4'; 
					}elseif ($status == 110){
						$t = '2'; 
					}
					$wregistro51->Situacao = $t;
					$_sint->Registros51->Add($wregistro51);					
				}
				//======================================================================FIM DO REGISTRO 51==========================================================================//

				//=====================================================================INICIO DO REGISTRO 53========================================================================//	
				if ($companySintegra[0]->{'reg53'}==1 && $nota->{"not_tipo"}==9 && $nota->{'not_toticmssubst'}>0){
					$wregistro53 = new TRegistro53();
					$wregistro53->CPFCNPJ = ($nota->{'not_entrsaida'}==2 && $nota->{'not_tipo'}==9) ? $nota->{'cad_cnpjcpf'} : $company->{'emp_cpfcnpj'};
					if($nota->{'cad_pessoa'}==1){
						$wregistro53->Inscricao = "ISENTO        ";
					}else{
						if($nota->{'not_entrsaida'}==2 && $nota->{'not_tipo'}==9){
							if( isset($nota->{'cad_inscrg'}) && $nota->{'cad_inscrg'}!="" && is_numeric($nota->{'cad_inscrg'}) ){
								$wregistro53->Inscricao = $nota->{'cad_inscrg'};
							}else{
								$wregistro53->Inscricao = "ISENTO        ";
							}
						}else{
							$wregistro53->Inscricao = $company->{'emp_inscrg'};
						}
					}
					$wregistro53->DataDocumento = $nota->{'not_dtfaturam'};	
					$wregistro53->Estado = $company->{"emp_uf"};
					$mod=$company->{'emp_amb_nfe'};
					if ($mod != 0){
						$mod = 55;
					}else{
						if ($companySintegra[0]->{"reg60M"}==1){
							$mod = 33;
							$modDoc = "2D";
						}elseif ($companySintegra[0]->{"reg60A"}==1){
							$mod = 33;
						}elseif ($companySintegra[0]->{"reg60D"}==1){
							$mod = 33;
						}elseif ($companySintegra[0]->{"reg60I"}==1){
							$mod = 33;
							$modDoc = "2D";
						}elseif ($companySintegra[0]->{"reg60R"}==1){
							$mod = 33;
						}
						if ($mod == 0){
							$mod = $nota->{'ser_codigo'}; 
							if ($mod == 1){
								$mod = 01;			
							}elseif ($mod == '1A'){
								$mod = 01;			
							}elseif ($mod == 'A1'){
								$mod = 01;			
							}elseif ($mod == 'UN'){
								$mod = 01;	
							}else{
								$mod = 02;	
							}
						}
					}
					// $mod = ($nota->{'not_tipo'}==9) ? 55 : 65;
					$wregistro53->Modelo = $mod;	
					$wregistro53->Serie = $nota->{'ser_codigo'};
					$wregistro53->Numero = $nota->{'not_numero'};
					$wregistro53->CFOP = $nota->{'cfo_codigo'};	
					$empCNPJ=$company->{"emp_cpfcnpj"};
					$cliCNPJ=$nota->{'cad_cnpjcpf'};
					if ($empCNPJ == $cliCNPJ){
						$wregistro53->Emitente = 'T';	
					}else{
						$wregistro53->Emitente = 'P';
					}
					$wregistro53->BaseST = $nota->{'not_totbaseicmsst'};
					$wregistro53->IcmsRetido = $nota->{'not_toticmssubst'};
					$frete = $nota->{'not_frete'};
					$seguro = $nota->{'not_seguro'};
					$despesa = $nota->{'not_despesa'};
					$soma = $frete + $seguro + $despesa;
					$wregistro53->Despesas = $soma;		
					if ($status == 100){
						$t = 'N'; 
					}elseif ($status == 101){
						$t = 'S'; 
					}elseif ($status == 102){
						$t = '4'; 
					}elseif ($status == 110){
						$t = '2'; 
					}
					$wregistro53->Situacao = $t;	
					$wregistro53->CodigoAntecipacao = 4; // <-- Antecipação tributária com MVA (Margem de Valor Agregado), efetuada pelo destinatário encerrando a fase de tributação "4" 	
					$_sint->Registros53->Add($wregistro53);	
				}
				//======================================================================FIM DO REGISTRO 53==========================================================================//

				//=====================================================================INICIO DO REGISTRO 54========================================================================//
				if ($companySintegra[0]->{'reg54'}==1){
					$array54 = array();
					$wregistro54=new TRegistro54();
					if ($company->{"emp_codregtrib"} == 3){
						$aliq="";
						$cfop="";
						foreach($item_nota as $itn){
							$UF = ($nota->{'not_entrsaida'}==2 && $nota->{'not_tipo'}==9) ? $nota->{'cad_uf'} : $company->{"emp_uf"};
							$wregistro54->CPFCNPJ = ($nota->{'not_entrsaida'}==2 && $nota->{'not_tipo'}==9) ? $nota->{'cad_cnpjcpf'} : $company->{'emp_cpfcnpj'};
							if($UF=="EX") $wregistro54->CPFCNPJ = 0;
							$mod=$company->{'emp_amb_nfe'};
							if ($mod != 0){
								$mod = 55;
							}else{
								if ($companySintegra[0]->{"reg60M"}==1){
									$mod = 33;
									$modDoc = "2D";
								}elseif ($companySintegra[0]->{"reg60A"}==1){
									$mod = 33;
								}elseif ($companySintegra[0]->{"reg60D"}==1){
									$mod = 33;
								}elseif ($companySintegra[0]->{"reg60I"}==1){
									$mod = 33;
									$modDoc = "2D";
								}elseif ($companySintegra[0]->{"reg60R"}==1){
									$mod = 33;
								}
								if ($mod == 0){
									$mod = $itn->{'ser_codigo'}; 
									if ($mod == 1){
										$mod = 01;			
									}elseif ($mod == '1A'){
										$mod = 01;			
									}elseif ($mod == 'A1'){
										$mod = 01;			
									}elseif ($mod == 'UN'){
										$mod = 01;	
									}else{
										$mod = 02;	
									}
								}
							}							
							// $mod = ($nota->{'not_tipo'}==9) ? 55 : 65;
							$tribjson = json_decode(base64_decode($itn->{'itn_tribjson'}));
							$cfop = ( isset($tribjson->{"rowdata"}[0]->{"ref_cfop"}) && $tribjson->{"rowdata"}[0]->{"ref_cfop"}!="" ) ? $tribjson->{"rowdata"}[0]->{"ref_cfop"} : $itn->{'cfo_codigo'};
							$wregistro54->Modelo=$mod;
							$wregistro54->Serie=$itn->{'ser_codigo'};
							$wregistro54->Numero=$itn->{'not_numero'};
							$wregistro54->CFOP=$cfop;		
							$origem=$itn->{'tri_origem'};
							$situacao=$itn->{'tri_situacao'};
							$normal=$origem.$situacao;					
							$wregistro54->CST=$normal;
							$wregistro54->NumeroItem=$nitem;			
							$wregistro54->Codigo=$itn->{'ref_codigo'};
							$wregistro54->Quantidade=$itn->{'itn_qtde'};
							$wregistro54->Valor=($itn->{'itn_qtde'} * $itn->{'itn_valor'}); 
							$wregistro54->ValorDescontoDespesa=0;  // <-- Alterar este valor para "0" pois não temos desconto no item!!!	
							$wregistro54->BaseDeCalculo=$itn->{'itn_baseicms'}; 
							$wregistro54->BaseST=$itn->{'itn_baseicmsst'}; 
							$wregistro54->ValorIpi=$itn->{'itn_ipi'}; 			
							$wregistro54->Aliquota=$itn->{'itn_aliqicms'}; 			
							if ($wregistro54->Aliquota != $aliq or $wregistro54->CFOP != $nota->{'cfo_codigo'}){
								$wregistro50=new TRegistro50();
								$wregistro50->CPFCNPJ = ($nota->{'not_entrsaida'}==2 && $nota->{'not_tipo'}==9) ? $nota->{'cad_cnpjcpf'} : $company->{'emp_cpfcnpj'};
								$wregistro50->Inscricao=$itn->{'cad_inscrg'};
								$wregistro50->DataDocumento=$nota->{'not_dtfaturam'};	
								$wregistro50->UF=$company->{"emp_uf"};
								$mod=$company->{'emp_amb_nfe'};
								if ($mod != 0){
									$mod = 55;
								}else{
									if ($companySintegra[0]->{"reg60M"}==1){
										$mod = 33;
										$modDoc = "2D";
									}elseif ($companySintegra[0]->{"reg60A"}==1){
										$mod = 33;
									}elseif ($companySintegra[0]->{"reg60D"}==1){
										$mod = 33;
									}elseif ($companySintegra[0]->{"reg60I"}==1){
										$mod = 33;
										$modDoc = "2D";
									}elseif ($companySintegra[0]->{"reg60R"}==1){
										$mod = 33;
									}
									if ($mod == 0){
										$mod = $nota->{'ser_codigo'}; 
										if ($mod == 1){
											$mod = 01;			
										}elseif ($mod == '1A'){
											$mod = 01;			
										}elseif ($mod == 'A1'){
											$mod = 01;			
										}elseif ($mod == 'UN'){
											$mod = 01;	
										}else{
											$mod = 02;	
										}
									}
								}
								// $mod = ($nota->{'not_tipo'}==9) ? 55 : 65;	
								$wregistro50->Modelo=$mod;					
								$wregistro50->Serie=$nota->{'ser_codigo'};
								$wregistro50->Numero=$nota->{'not_numero'};
								$wregistro50->CFOP=$nota->{'cfo_codigo'};					
								$empCNPJ=$company->{"emp_cpfcnpj"};
								$cliCNPJ=$nota->{'cad_cnpjcpf'};
								if ($empCNPJ == $cliCNPJ){
									$wregistro50->EmissorDocumento='T';	
								}else{	
									$wregistro50->EmissorDocumento='P';	
								}
								
								$valorContabil = 0;
								$valorBaseDeCalculo = 0;
								$valorIcms = 0;
								$valorIsentas = 0;
								$valorOutras = 0;
								$aliq=($nota->{'not_aliq'}>0) ? $nota->{'not_aliq'} : 0;
								
								foreach($item_nota as $itn2){
									
									$tribjson2 = json_decode(base64_decode($itn2->{'itn_tribjson'}));
									$cfop2 = ( isset($tribjson2->{"rowdata"}[0]->{"ref_cfop"}) && $tribjson2->{"rowdata"}[0]->{"ref_cfop"}!="" ) ? $tribjson2->{"rowdata"}[0]->{"ref_cfop"} : $itn2->{'cfo_codigo'};
									
									if($cfop==$cfop2){
										$valorContabil+=$itn2->{'itn_subtotal'};
										$valorBaseDeCalculo+=$itn2->{'itn_baseicms'};
										$valorIcms+=$itn2->{'itn_icms'};
										$situacao=$itn2->{'tri_situacao'};
										if($situacao=='30' or $situacao=='40' or $situacao=='41'){
											$valorIsentas = $valorIsentas + $itn2->{'itn_subtotal'};
										}elseif($situacao=='50' or $situacao=='51' or $situacao=='90'){
											$valorOutras = $valorOutras + $itn2->{'itn_subtotal'};
										}
									}						
								}			
								
								$wregistro50->ValorContabil=$valorContabil;
								$wregistro50->BaseDeCalculo=$valorBaseDeCalculo; 
								$wregistro50->Icms=$valorIcms; 
								$wregistro50->Isentas=$valorIsentas;
								$wregistro50->Outras=$valorOutras;
					
								$wregistro50->Aliquota=$aliq;
								if ($status == 100){
									$t = 'N'; 
								}elseif ($status == 101){
									$t = 'S'; 
								}elseif ($status == 102){
									$t = '4'; 
								}elseif ($status == 110){
									$t = '2'; 
								}
								$wregistro50->Situacao=$t;
								$_sint->Registros50->Add($wregistro50);
							}else{
								$wregistro50=new TRegistro50();
								$wregistro50->CPFCNPJ = ($nota->{'not_entrsaida'}==2 && $nota->{'not_tipo'}==9) ? $nota->{'cad_cnpjcpf'} : $company->{'emp_cpfcnpj'};
								$wregistro50->Inscricao=$itn->{'cad_incrg'};
								$wregistro50->DataDocumento=$nota->{'not_dtfaturam'};	
								$wregistro50->UF=$company->{"emp_uf"};	
								// $mod = ($nota->{'not_tipo'}==9) ? 55 : 65;
								$mod=$company->{'emp_amb_nfe'};
								if ($mod != 0){
									$mod = 55;
								}else{		
									if ($companySintegra[0]->{"reg60M"}==1){
										$mod = 33;
										$modDoc = "2D";
									}elseif ($companySintegra[0]->{"reg60A"}==1){
										$mod = 33;
									}elseif ($companySintegra[0]->{"reg60D"}==1){
										$mod = 33;
									}elseif ($companySintegra[0]->{"reg60I"}==1){
										$mod = 33;
										$modDoc = "2D";
									}elseif ($companySintegra[0]->{"reg60R"}==1){
										$mod = 33;
									}
									if ($mod == 0){
										$mod = $nota->{'ser_codigo'}; 
										if ($mod == 1){
											$mod = 01;			
										}elseif ($mod == '1A'){
											$mod = 01;			
										}elseif ($mod == 'A1'){
											$mod = 01;			
										}elseif ($mod == 'UN'){
											$mod = 01;	
										}else{
											$mod = 02;	
										}
									}
								}
								$wregistro50->Modelo=$mod;					
								$wregistro50->Serie=$nota->{'ser_codigo'};
								$wregistro50->Numero=$nota->{'not_numero'};
								$wregistro50->CFOP=$nota->{'cfo_codigo'};					
								$empCNPJ=$company->{"emp_cpfcnpj"};
								$cliCNPJ=$nota->{'cad_cnpjcpf'};
								if ($empCNPJ == $cliCNPJ){
									$wregistro50->EmissorDocumento='T';	
								}else{	
									$wregistro50->EmissorDocumento='P';	
								}
								$wregistro50->ValorContabil=$nota->{'not_totalnota'};
								$wregistro50->BaseDeCalculo=$nota->{'not_totbaseicms'}; 
								$wregistro50->Icms=$nota->{'not_toticms'}; 
								$valorIsentas = 0;
								$valorOutras = 0;
								if ($company->{"emp_codregtrib"} == 3){ 
									foreach($item_nota as $itn){
										$situacao=$itn->{'tri_situacao'};
										if($situacao=='30' or $situacao=='40' or $situacao=='41'){
											$valorIsentas = $valorIsentas + ($itn->{'itn_qtde'} * $itn->{'itn_valor'});
										}elseif($situacao=='50' or $situacao=='51' or $situacao=='90'){
											$valorOutras = $valorOutras + ($itn->{'itn_qtde'} * $itn->{'itn_valor'});
										}else{
											$valorIsentas = 0;
											$valorOutras = 0;
										}	
										$aliq = $wregistro54->Aliquota;
									}			
								}else{
									$valorIsentas = $nota->{'not_totalnota'};				
									$aliq = 0;			
								}
								$wregistro50->Isentas=$valorIsentas;
								$wregistro50->Outras=$valorOutras;	
								$wregistro50->Aliquota=$aliq;
								if ($status == 100){
									$t = 'N'; 
								}elseif ($status == 101){
									$t = 'S'; 
								}elseif ($status == 102){
									$t = '4'; 
								}elseif ($status == 110){
									$t = '2'; 
								}
								$wregistro50->Situacao=$t;
								$_sint->Registros50->Add($wregistro50);
							}
							if(!in_array($wregistro54,$array54)){
								$nitem++;				
								array_push($array54,$wregistro54);
								array_push($itens75,$itn->{'ref_codigo'});								
								$_sint->Registros54->Add($wregistro54);
							}	
						}
						
					}else{


						foreach($item_nota as $itn){
							$wregistro54=new TRegistro54();
							$UF = ($nota->{'not_entrsaida'}==2 && $nota->{'not_tipo'}==9) ? $nota->{'cad_uf'} : $company->{"emp_uf"};
							$wregistro54->CPFCNPJ = ($nota->{'not_entrsaida'}==2 && $nota->{'not_tipo'}==9) ? $nota->{'cad_cnpjcpf'} : $company->{'emp_cpfcnpj'};
							if($UF=="EX") $wregistro54->CPFCNPJ = 0;
							$mod=$company->{'emp_amb_nfe'};
							if ($mod != 0){
								$mod = 55;
							}else{		
								if ($companySintegra[0]->{"reg60M"}==1){
									$mod = 33;
									$modDoc = "2D";
								}elseif ($companySintegra[0]->{"reg60A"}==1){
									$mod = 33;
								}elseif ($companySintegra[0]->{"reg60D"}==1){
									$mod = 33;
								}elseif ($companySintegra[0]->{"reg60I"}==1){
									$mod = 33;
									$modDoc = "2D";
								}elseif ($companySintegra[0]->{"reg60R"}==1){
									$mod = 33;
								}
								if ($mod == 0){
									$mod = $itn->{'ser_codigo'}; 
									if ($mod == 1){
										$mod = 01;			
									}elseif ($mod == '1A'){
										$mod = 01;			
									}elseif ($mod == 'A1'){
										$mod = 01;			
									}elseif ($mod == 'UN'){
										$mod = 01;	
									}else{
										$mod = 02;	
									}
								}
							}
							// $mod = ($nota->{'not_tipo'}==9) ? 55 : 65;
							$tribjson = json_decode(base64_decode($itn->{'itn_tribjson'}));
							$cfop = ( isset($tribjson->{"rowdata"}[0]->{"ref_cfop"}) && $tribjson->{"rowdata"}[0]->{"ref_cfop"}!="" ) ? $tribjson->{"rowdata"}[0]->{"ref_cfop"} : $itn->{'cfo_codigo'};
							$wregistro54->Modelo=$mod;					
							$wregistro54->Serie=$itn->{'ser_codigo'};
							$wregistro54->Numero=$itn->{'not_numero'};
							$wregistro54->CFOP=$cfop;					
							$wregistro54->CST = ($tribjson->{"rowdata"}[0]->{"tri_csosn"} && $tribjson->{"rowdata"}[0]->{"tri_csosn"}!="000") ? $tribjson->{"rowdata"}[0]->{"tri_csosn"} : "400";
							$wregistro54->NumeroItem=$nitem;
							$wregistro54->Codigo=$itn->{'ref_codigo'};
							$wregistro54->Quantidade=$itn->{'itn_qtde'};
							$wregistro54->Valor=($itn->{'itn_qtde'} * $itn->{'itn_valor'}); 
							$wregistro54->ValorDescontoDespesa=0;  // <-- Alterar este valor para "0" pois não temos desconto no item!!!	
							$wregistro54->BaseDeCalculo=$itn->{'itn_baseicms'};
							$wregistro54->BaseST=0;
							$wregistro54->ValorIpi=0;
							$wregistro54->Aliquota=($nota->{'not_aliq'}>0) ? $nota->{'not_aliq'} : 0;
							
							if ($cfop != $nota->{'cfo_codigo'}){
								$wregistro50=new TRegistro50();
								$wregistro50->CPFCNPJ = ($nota->{'not_entrsaida'}==2 && $nota->{'not_tipo'}==9) ? $nota->{'cad_cnpjcpf'} : $company->{'emp_cpfcnpj'};
								if($nota->{'cad_pessoa'}==1)
									$wregistro50->Inscricao="ISENTO        ";
								else
									$wregistro50->Inscricao=$nota->{'cad_inscrg'};
								$wregistro50->DataDocumento=$nota->{'not_dtfaturam'};	
								$wregistro50->UF=$company->{"emp_uf"};
								$mod=$company->{'emp_amb_nfe'};
								if ($mod != 0){
									$mod = 55;
								}else{
									if ($companySintegra[0]->{"reg60M"}==1){
										$mod = 33;
										$modDoc = "2D";
									}elseif ($companySintegra[0]->{"reg60A"}==1){
										$mod = 33;
									}elseif ($companySintegra[0]->{"reg60D"}==1){
										$mod = 33;
									}elseif ($companySintegra[0]->{"reg60I"}==1){
										$mod = 33;
										$modDoc = "2D";
									}elseif ($companySintegra[0]->{"reg60R"}==1){
										$mod = 33;
									}
									if ($mod == 0){
										$mod = $nota->{'ser_codigo'}; 
										if ($mod == 1){
											$mod = 01;			
										}elseif ($mod == '1A'){
											$mod = 01;			
										}elseif ($mod == 'A1'){
											$mod = 01;			
										}elseif ($mod == 'UN'){
											$mod = 01;	
										}else{
											$mod = 02;	
										}
									}
								}
								// $mod = ($nota->{'not_tipo'}==9) ? 55 : 65;
								$wregistro50->Modelo=$mod;					
								$wregistro50->Serie=$nota->{'ser_codigo'};
								$wregistro50->Numero=$nota->{'not_numero'};
								$wregistro50->CFOP=$cfop;					
								$empCNPJ=$company->{"emp_cpfcnpj"};
								$cliCNPJ=$nota->{'cad_cnpjcpf'};
								if ($empCNPJ == $cliCNPJ){
									$wregistro50->EmissorDocumento='T';	
								}else{	
									$wregistro50->EmissorDocumento='P';	
								}
								
								$valorContabil = 0;
								$valorBaseDeCalculo = 0;
								$valorIcms = 0;
								$valorIsentas = 0;
								$valorOutras = 0;
								$aliq=($nota->{'not_aliq'}>0) ? $nota->{'not_aliq'} : 0;
								
								foreach($item_nota as $itn2){
									$tribjson2 = json_decode(base64_decode($itn2->{'itn_tribjson'}));
									$cfop2 = ( isset($tribjson2->{"rowdata"}[0]->{"ref_cfop"}) && $tribjson2->{"rowdata"}[0]->{"ref_cfop"}!="" ) ? $tribjson2->{"rowdata"}[0]->{"ref_cfop"} : $itn2->{'cfo_codigo'};
									
									if($cfop==$cfop2){
										$valorContabil+=$itn2->{'itn_subtotal'};
										$valorBaseDeCalculo+=$itn2->{'itn_baseicms'};
										$valorIcms+=$itn2->{'itn_icms'};
										$situacao=$itn2->{'tri_situacao'};
										if($situacao=='30' or $situacao=='40' or $situacao=='41'){
											$valorIsentas = $valorIsentas + $itn2->{'itn_subtotal'};
										}elseif($situacao=='50' or $situacao=='51' or $situacao=='90'){
											$valorOutras = $valorOutras + $itn2->{'itn_subtotal'};
										}
									}						
								}
								
								$wregistro50->ValorContabil=$valorContabil;
								$wregistro50->BaseDeCalculo=$valorBaseDeCalculo; 
								$wregistro50->Icms=$valorIcms; 
								$wregistro50->Isentas=$valorIsentas;
								$wregistro50->Outras=$valorOutras;
								
								$wregistro50->Aliquota=$aliq;
								if ($status == 100){
									$t = 'N'; 
								}elseif ($status == 101){
									$t = 'S'; 
								}elseif ($status == 102){
									$t = '4'; 
								}elseif ($status == 110){
									$t = '2'; 
								}
								$wregistro50->Situacao=$t;
								if(!in_array($wregistro50,$array50)){
									$_sint->Registros50->Add($wregistro50);
									array_push($array50,$wregistro50);
								}
							}
							
							//if(!in_array($wregistro54,$array54)){
								$nitem++;
								array_push($array54,$wregistro54);			
								$_sint->Registros54->Add($wregistro54);
							//}
							if(!in_array($itn->{'ref_codigo'}, $itens75)){
								array_push($itens75,$itn->{'ref_codigo'});
							}
						}
					}
				}
		}
		//=====================================================================INICIO DO REGISTRO 74========================================================================//
		
		if($companySintegra[0]->{'reg74'}==1){
			$filtroStk = '{"cod":"700697","params":[{"name":"emp_codigo","value":"'.$company->emp_codigo.'","type":"string"}]}';

			$dataPacketStk = new DataPacket();
			$dataPacketStk->setHost($TParams->getHost($company->emp_db_comum));
			$dataPacketStk->add($filtroStk);
			$inventario = $dataPacketStk->open(true);
			
			foreach($inventario as $inv){
				if(in_array($inv->{'ref_codigo'}, $itens75)){
					$wregistro74=new TRegistro74();
					$wregistro74->Data = $not_dtfatfim;
					$wregistro74->Codigo=$inv->{'ref_codigo'};
					$wregistro74->Quantidade=$inv->{'saldo'};
					$wregistro74->ValorProduto=$inv->{'saldo'}*$inv->{'ref_preco'};
					$wregistro74->CodigoPosse=1;
					$dados = $wregistro74->CodigoPosse;
					if($dados == 1){
						$wregistro74->CNPJPossuidor=00000000000000;
						$wregistro74->InscricaoPossuidor='';
					}elseif ($dados == 2){
						$wregistro74->CNPJPossuidor=$company->{"emp_cpfcnpj"};
						$wregistro74->InscricaoPossuidor=$company->{"emp_inscrg"};
					}
					$wregistro74->UFPossuidor=$company->emp_uf;
					$_sint->Registros74->Add($wregistro74);
				}
			}
		}
		
		//======================================================================FIM DO REGISTRO 74==========================================================================//		
		
		//$strin = implode("-", $itens75);
		//fwrite($arq, $strin);
		
		if($companySintegra[0]->{'reg75'}==1){
			if(count($itens75)>0){
				$filtroStk = '{"cod":"700696","params":[]}';
				$datapacket_stk = new DataPacket();
				$datapacket_stk->setHost($TParams->getHost($company->emp_db_comum));
				$datapacket_stk->add($filtroStk);
				$estoque = $datapacket_stk->open(true);
				foreach($estoque as $itn){
					$cod = $itn->{'ref_codigo'};
					if(in_array($cod, $itens75)){
						$wregistro75=new TRegistro75();
						$wregistro75->DataInicial=$not_dtfatini;
						$wregistro75->DataFinal=$not_dtfatfim;
						$wregistro75->Codigo=$itn->{'ref_codigo'};	
						$wregistro75->NCM=$itn->{'ref_ncm'};
						$wregistro75->Descricao=$itn->{'ref_descr'};
						$wregistro75->Unidade=$itn->{'uni_codigo'};
						$wregistro75->AliquotaIpi=$itn->{'tri_aliqipi'};
						$wregistro75->AliquotaIcms=$itn->{'tri_aliqicms'}; 		
						$wregistro75->Reducao=$itn->{'tri_redbaseicms'};
						$wregistro75->BaseST=$itn->{'tri_aliq_icms_st'};
						$_sint->Registros75->Add($wregistro75);
					}
				}
			}
		}

		// Registro 60M
		$wregistro60M=new TRegistro60M();
		$wregistro60M->Emissao=$_sint->Registro10->DataInicial;
		$wregistro60M->NumSerie='000000987456';
		$wregistro60M->NumOrdem=1;
		$wregistro60M->ModeloDoc='2D';
		$wregistro60M->CooInicial=1000;
		$wregistro60M->CooFinal=1050;
		$wregistro60M->CRZ=1;
		$wregistro60M->CRO=1;
		$wregistro60M->VendaBruta=2050.35;
		$wregistro60M->ValorGT=10000;
		// $_sint->Registros60M->Add($wregistro60M);
		
		// Registro 60A
		$wregistro60A=new TRegistro60A();
		$wregistro60A->Emissao=$_sint->Registro10->DataInicial;
		$wregistro60A->NumSerie='000000987456';	
		$wregistro60A->StAliquota='1800';
		$wregistro60A->Valor=100;
		// $_sint->Registros60A->Add($wregistro60A);
		
		// Registro 60R
		$wregistro60R=new TRegistro60R();
		$x=str_replace('-','/',$_sint->Registro10->DataFinal);
		$data=date('mY',strtotime($x));				
		$wregistro60R->MesAno=$data;
		$wregistro60R->Codigo=$wregistro54->Codigo;
		$wregistro60R->Qtd=100;
		$wregistro60R->Valor=100;
		$wregistro60R->BaseDeCalculo=0;
		$wregistro60R->Aliquota='1800';

	}catch (Exception $e){
		echo ($e->getMessage());
	}		
	$_sint->Debug=false;
	$_sint->GeraArquivo();
?>