<?php 
/**
* REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAÇÃO DA ENTIDADE
* Registro obrigatório e corresponde ao primeiro registro do arquivo.
* Obs.: Nos casos de EFD apresentadas por estabelecimentos situados em outra UF e que possuam Inscrição
* Estadual nos termos do Convênio ICMS nº 113/04, deve-se observar o seguinte procedimento para preenchimento do registro 0000:
* 	a) Informar o campo UF da unidade federada do tomador de serviços;
* 	b) Informar no campo IE a inscrição estadual na unidade federada do tomador de serviços;
* 	c) Informar no campo COD_MUN o código de município correspondente à capital do estado do tomador de serviços.
* @version 1.0.0
* @package
*/
if(!defined('DS')) define('DS',DIRECTORY_SEPARATOR);
include_once(__DIR__.DS.'..'.DS.'Registro.php');
/**
*
*
*/
class Registro_0000 extends Registro{
	/**
	* versao
	*/
	const VERSION='1.0.0';
	
	/**
	* Texto fixo contendo “0000”.
	* @name REG
	* @size 4
	* @type string
	* @position 01
	* @required true	
	*/
	protected $reg='0000';
	
	/**
	* Código da versão do leiaute conforme a tabela indicada no Ato COTEPE.
	* @name $cod_ver
	* @size 3
	* @type numeric	
	* @position 02
	* @required true
	*/
	protected $cod_ver;
	
	/**
	* Código da finalidade do arquivo:
	*	0 - Remessa do arquivo original;
	*	1 - Remessa do arquivo substituto.
	* @name $cod_fin
	* @size 1
	* @type numeric	
	* @position 03
	* @required true	
	*/
	protected $cod_fin;
	
	/**
	*
	* Data inicial das informações contidas no arquivo.
	* $name $dt_ini
	* @size 8
	* @type numeric
	* @format ddmmaaaa
	* @position 04
	* @required true
	*/
	protected $dt_ini;


	/**
	* Data final das informações contidas no arquivo.
	* $name $dt_fin
	* @size 8
	* @type numeric
	* @format ddmmaaaa	
	* @position 05
	* @required true
	*/
	protected $dt_fin;

	/**
	* Nome empresarial da entidade
	* @name $nome
	* @size 100
	* @type string	
	* @position 06
	* @required true	
	*/
	protected $nome;

	/**
	* Número de inscrição da entidade no CNPJ.
	* @name $cnpj
	* @size 14
	* @type numeric	
	* @position 07
	* @required true
	*/
	protected $cnpj;


	/**
	* Número de inscrição da entidade no CPF.
	* @name $cpf
	* @size 11
	* @type numeric	
	* @position 08
	* @required true
	*/
	protected $cpf;

	/**
	* Sigla da unidade da federação da entidade.
	* @name $uf
	* @size 2
	* @type string	
	* @position 09
	* @required true
	*/
	protected $uf;

	/**
	* Inscrição Estadual da entidade.
	* @name $ie
	* @size 14
	* @type string	
	* @position 10
	* @required true
	*/
	protected $ie;

	/**
	* Código do município do domicílio fiscal da entidade, conforme a tabela IBGE
	* @name $cod_mun
	* @size 7
	* @type numeric	
	* @position 11
	* @required true
	*/
	protected $cod_mun;

	/**
	* Inscrição Municipal da entidade.
	* @name $im
	* @size undefined
	* @type string	
	* @position 12
	* @required true
	*/
	protected $im;

	/**
	* Inscrição da entidade na SUFRAMA
	* @name $suframa
	* @size 9
	* @type string	
	* @position 13
	* @required true
	*/
	protected $suframa;

	/**
	* Perfil de apresentação do arquivo fiscal;
	*	A – Perfil A;
	*	B – Perfil B.;
	*	C – Perfil C.
	* @name $ind_perfil
	* @size 1
	* @type string	
	* @position 14
	* @required true
	*/
	protected $ind_perfil;

	/**
	* Indicador de tipo de atividade:
	*	0 – Industrial ou equiparado a industrial;
	*	1 – Outros.
	* @name $ind_ativ
	* @size 1
	* @type numeric
	* @position 15
	* @required true
	*/
	protected $ind_ativ;
	
	/**
	* metodo responsavel pela construcao do obj do registro 0
	* @param mixed[] $items Array associativo com proriedade como indices e seus respectivos valores
	*/
	public function __construct($items=null){
		if(is_array($items)&&!empty($items)){
			foreach($items as $key=>$value){
				if(property_exists($this,$key)) 
					$this->$key=$value;
				else
					throw new Exception('Propriedade '.$key.' não definida em '.get_class($this));
			}
			unset($items);
		}
	}
}
?>