<?php 
/**
* REGISTRO 0005: DADOS COMPLEMENTARES DA ENTIDADE
* Registro obrigatório utilizado para complementar as informações de identificação do informante do arquivo.
* Nível hierárquico - 2
* Ocorrência – um por arquivo
* @version 1.0.0
* @package
*/
if(!defined('DS')) define('DS',DIRECTORY_SEPARATOR);
include_once(__DIR__.DS.'..'.DS.'Registro.php');
/**
*
*
*/
class Registro_0005 extends Registro{
	/**
	* versao
	*/
	const VERSION='1.0.0';
	
	/**
	* Texto fixo contendo “0005”.
	* @name REG
	* @size 4
	* @type string
	* @position 01
	* @required true	
	*/
	protected $reg='0005';
	
	/**
	* Nome de fantasia associado ao nome empresarial.
	* @name $fantasia
	* @size 60
	* @type string	
	* @position 02
	* @required true
	*/
	protected $fantasia;
	
	/**
	* Código de Endereçamento Postal.
	* @name $cep
	* @size 8
	* @type numeric	
	* @position 03
	* @required true	
	*/
	protected $cep;
	
	/**
	*
	* Logradouro e endereço do imóvel.
	* $name $end
	* @size 60
	* @type string
	* @position 04
	* @required true
	*/
	protected $end;


	/**
	* Número do imóvel.
	* $name $num
	* @size 10
	* @type string
	* @position 05
	* @required true
	*/
	protected $num;

	/**
	* Dados complementares do endereço.
	* @name $compl
	* @size 60
	* @type string	
	* @position 06
	* @required true	
	*/
	protected $compl;

	/**
	* Bairro em que o imóvel está situado.
	* @name $bairro
	* @size 60
	* @type string	
	* @position 07
	* @required true
	*/
	protected $bairro;


	/**
	* Número do telefone (DDD+FONE).
	* @name $fone
	* @size 11
	* @type string	
	* @position 08
	* @required true
	*/
	protected $fone;

	/**
	* Número do fax.
	* @name $fax
	* @size 11
	* @type string	
	* @position 09
	* @required true
	*/
	protected $fax;

	/**
	* Endereço do correio eletrônico.
	* @name $email
	* @size undefined
	* @type string	
	* @position 10
	* @required true
	*/
	protected $email;	
	
	/**
	* metodo responsavel pela construcao do obj do registro 0
	* @param mixed[] $items Array associativo com proriedade como indices e seus respectivos valores
	*/
	public function __construct($items=null){
		// parent::__construct();
		if(is_array($items)&&!empty($items)){
			foreach($items as $key=>$value){
				if(property_exists($this,$key)) 
					$this->$key=$value;
				else
					throw new Exception('Propriedade '.$key.' não defina em '.get_class($this));
			}
			unset($items);
		}
	}
}
?>