<?php 
/**
* REGISTRO 0150: TABELA DE CADASTRO DO PARTICIPANTE
* Registro utilizado para informações cadastrais das pessoas físicas ou jurídicas envolvidas nas transações
* comerciais com o estabelecimento, no período. Participantes sem movimentação no período não devem ser informados neste registro.
* Obs.: Não devem ser informados como participantes os CNPJ e CPF apenas citados nos registros C350 e C460.
* O código a ser utilizado é de livre atribuição pelo contribuinte e possui validade para o arquivo informado. 
* Este código deve ser único para o participante, não havendo necessidade, sempre que possível, de se criar um novo para cada  período.
* Não podem ser informados dois ou mais registros com o mesmo Código de Participante.
* Para o caso de participante pessoa física com mais de um endereço, podem ser fornecidos mais de um registro,
* com o mesmo NOME e CPF. Neste caso, deve ser usado um COD_PART para cada registro, alterando os demais dados.
* As informações deste registro representam os dados atualizados no último dia da EFD.
* @version 1.0.0
* @package
*/
if(!defined('DS')) define('DS',DIRECTORY_SEPARATOR);
include_once(__DIR__.DS.'..'.DS.'Registro.php');
/**
*
*
*/
class Registro_0150 extends Registro{
	/**
	* versao
	*/
	const VERSION='1.0.0';
	
	/**
	* Texto fixo contendo 0150.
	* @name REG
	* @size 4
	* @type string
	* @position 01
	* @required true	
	*/
	protected $reg='0150';
	
	/**
	* Código de identificação do participante no arquivo.
	* @name $cod_part
	* @size 60
	* @type string	
	* @position 02
	* @required true
	*/
	protected $cod_part;
	
	/**
	* Nome pessoal ou empresarial do participante.
	* @name $nome
	* @size 100
	* @type string	
	* @position 03
	* @required true	
	*/
	protected $nome;
	
	/**
	*
	* Código do país do participante, conforme a tabela indicada no item 3.2.1
	* $name $cod_pais
	* @size 5
	* @type numeric
	* @position 04
	* @required true
	*/
	protected $cod_pais;


	/**
	* CNPJ do participante.
	* $name $cnpj
	* @size 14
	* @type numeric
	* @position 05
	* @required true
	*/
	protected $cnpj;

	/**
	* CPF do participante.
	* @name $cpf
	* @size 11
	* @type numeric	
	* @position 06
	* @required true	
	*/
	protected $cpf;

	/**
	* Inscrição Estadual do participante.
	* @name $ie
	* @size 14
	* @type string	
	* @position 07
	* @required true
	*/
	protected $ie;


	/**
	* Código do município, conforme a tabela IBGE
	* @name $cod_mun
	* @size 7
	* @type numeric	
	* @position 08
	* @required true
	*/
	protected $cod_mun;

	/**
	* Número de inscrição do participante na SUFRAMA.
	* @name $suframa
	* @size 9
	* @type string	
	* @position 09
	* @required true
	*/
	protected $suframa;

	/**
	* Logradouro e endereço do imóvel
	* @name $end
	* @size 60
	* @type string	
	* @position 10
	* @required true
	*/
	protected $end;

	/**
	* Número do imóvel
	* @name $num
	* @size 10
	* @type string	
	* @position 11
	* @required true
	*/
	protected $num;

	/**
	* Dados complementares do endereço.
	* @name $compl
	* @size 60
	* @type string	
	* @position 12
	* @required true
	*/
	protected $compl;

	/**
	* Bairro em que o imóvel está situado
	* @name $bairro
	* @size 60
	* @type string	
	* @position 13
	* @required true
	*/
	protected $bairro;
	
	/**
	* metodo responsavel pela construcao do obj do registro 0
	* @param mixed[] $items Array associativo com proriedade como indices e seus respectivos valores
	*/
	public function __construct($items=null){
		if(is_array($items)&&!empty($items)){
			foreach($items as $key=>$value){
				if(property_exists($this,$key)) 
					$this->$key=$value;
				else
					throw new Exception('Propriedade '.$key.' não defina em '.get_class($this));
			}
			unset($items);
		}
	}
}
?>