<?php 
/**
* REGISTRO 0205: ALTERAÇÃO DO ITEM
* Este registro tem por objetivo informar alterações ocorridas na descrição do produto, desde que não o
* descaracterize ou haja modificação que o identifique como sendo novo produto. Caso não tenha ocorrido movimentação no
* período da alteração do item, deverá ser informada no primeiro período em que houver movimentação do item ou no inventário.
* Deverá ser ainda informado quando ocorrer alteração na codificação do produto.
* Não podem ser informados dois ou mais registros com sobreposição de períodos.
* Nível hierárquico - 3
* Ocorrência - 1:N
* @version 1.0.0
* @package
*/
if(!defined('DS')) define('DS',DIRECTORY_SEPARATOR);
include_once(__DIR__.DS.'..'.DS.'Registro.php');
/**
*
*
*/
class Registro_0205 extends Registro{
	/**
	* versao
	*/
	const VERSION='1.0.0';
	
	/**
	* Texto fixo contendo "0205".
	* @name REG
	* @size 4
	* @type string
	* @position 01
	* @required true	
	*/
	protected $reg='0205';
	
	/**
	* Descrição anterior do item
	* @name $descr_ant_item
	* @size undefined
	* @type string	
	* @position 02
	* @required true
	*/
	protected $descr_ant_item;
	

	/**
	*
	* Data inicial de utilização da descrição do item
	* $name $dt_ini
	* @size 8
	* @type numeric
	* @format ddmmaaaa
	* @position 03
	* @required true
	*/
	protected $dt_ini;


	/**
	* Data final de utilização da descrição do item.
	* $name $dt_fim
	* @size 8
	* @type numeric
	* @format ddmmaaaa	
	* @position 04
	* @required true
	*/
	protected $dt_fim;

	/**
	* Código anterior do item com relação à última informação apresentada.
	* @name $cod_ant_item
	* @size 60
	* @type string	
	* @position 05
	* @required true	
	*/
	protected $cod_ant_item;
	
	/**
	* metodo responsavel pela construcao do obj do registro 0
	* @param mixed[] $items Array associativo com proriedade como indices e seus respectivos valores
	*/
	public function __construct($items=null){
		if(is_array($items)&&!empty($items)){
			foreach($items as $key=>$value){
				if(property_exists($this,$key)) 
					$this->$key=$value;
				else
					throw new Exception('Propriedade '.$key.' não defina em '.get_class($this));
			}
			unset($items);
		}
	}
}
?>