<?php 
/**
* REGISTRO 0206: CÓDIGO DE PRODUTO CONFORME TABELA PUBLICADA PELA ANP (COMBUSTÍVEIS)
* Este registro tem por objetivo informar o código correspondente ao produto constante na Tabela da Agência
* Nacional de Petróleo (ANP) para os produtos denominados “Combustíveis”.
* Deve ser apresentado apenas pelos contribuintes produtores, importadores, distribuidores e postos de combustíveis.
* Nível hierárquico - 3
* Ocorrência - 1:1
* @version 1.0.0
* @package
*/
if(!defined('DS')) define('DS',DIRECTORY_SEPARATOR);
include_once(__DIR__.DS.'..'.DS.'Registro.php');
/**
*
*
*/
class Registro_0206 extends Registro{
	/**
	* versao
	*/
	const VERSION='1.0.0';
	
	/**
	* Texto fixo contendo "0206".
	* @name REG
	* @size 4
	* @type string
	* @position 01
	* @required true	
	*/
	protected $reg='0206';
	
	/**
	* Código do combustível, conforme tabela publicada pela ANP
	* @name $cod_comb
	* @size undefined
	* @type string	
	* @position 02
	* @required true
	*/
	protected $cod_comb;
	
	
	/**
	* metodo responsavel pela construcao do obj do registro 0
	* @param mixed[] $items Array associativo com proriedade como indices e seus respectivos valores
	*/
	public function __construct($items=null){
		if(is_array($items)&&!empty($items)){
			foreach($items as $key=>$value){
				if(property_exists($this,$key)) 
					$this->$key=$value;
				else
					throw new Exception('Propriedade '.$key.' não defina em '.get_class($this));
			}
			unset($items);
		}
	}
}
?>