<?php 
/**
* REGISTRO 0300: CADASTRO DE BENS OU COMPONENTES DO ATIVO IMOBILIZADO
* Este registro tem o objetivo de identificar e caracterizar todos os bens ou componentes arrolados no registro G125 do Bloco G e os bens em construção.
* O bem ou componente deverá ter código individualizado atribuído pelo contribuinte em seu controle patrimonial
* do ativo imobilizado e não poderá ser reutilizado, duplicado, atribuído a bens ou componentes diferentes.
* A discriminação do bem ou componente deve indicar precisamente o mesmo, sendo vedadas discriminações
* diferentes para o mesmo bem ou componente no mesmo período ou discriminações genéricas.
* As informações nos campos IDENT_MERC, DESCR_ITEM, COD_PRNC e COD_CTA devem se referir às características atuais do bem ou componente.
* Deverá também ser apresentado registro que identifique e caracterize o bem que está sendo construído no
* estabelecimento do contribuinte, a partir do período de apuração em que adquirir ou consumir o 1º componente.
* Nível hierárquico - 2
* Ocorrência – Vários (por arquivo)
* @version 1.0.0
* @package
*/
if(!defined('DS')) define('DS',DIRECTORY_SEPARATOR);
include_once(__DIR__.DS.'..'.DS.'Registro.php');
/**
*
*
*/
class Registro_0300 extends Registro{
	/**
	* versao
	*/
	const VERSION='1.0.0';
	
	/**
	* Texto fixo contendo “0300”.
	* @name REG
	* @size 4
	* @type string
	* @position 01
	* @required true	
	*/
	protected $reg='0300';
	
	/**
	* Código individualizado do bem ou componente adotado no controle patrimonial do estabelecimento informante
	* @name $cod_ind_bem
	* @size 60
	* @type string	
	* @position 02
	* @required true
	*/
	protected $cod_ind_bem;
	
	/**
	* Identificação do tipo de mercadoria:
	*	1 = bem;
	*	2 = componente.
	* @name $ident_merc
	* @size 1
	* @type numeric	
	* @position 03
	* @required true	
	*/
	protected $ident_merc;
	
	/**
	*
	* Descrição do bem ou componente (modelo, marca e outras características necessárias a sua individualização)
	* $name $descr_item
	* @size undefined
	* @type string
	* @position 04
	* @required true
	*/
	protected $descr_item;


	/**
	* Código de cadastro do bem principal nos casos em que o bem ou componente ( campo 02) esteja vinculado a um bem principal.
	* $name $cod_prnc
	* @size 60
	* @type string
	* @position 05
	* @required true
	*/
	protected $cod_prnc;

	/**
	* Código da conta analítica de contabilização do bem ou componente (campo 06 do Registro 0500)
	* @name $cod_cta
	* @size 60
	* @type string	
	* @position 06
	* @required true	
	*/
	protected $cod_cta;

	/**
	* Número total de parcelas a serem apropriadas, segundo a legislação de cada unidade federada
	* @name $nr_parc
	* @size 3
	* @type numeric	
	* @position 07
	* @required true
	*/
	protected $nr_parc;
	
	/**
	* metodo responsavel pela construcao do obj do registro 0
	* @param mixed[] $items Array associativo com proriedade como indices e seus respectivos valores
	*/
	public function __construct($items=null){
		if(is_array($items)&&!empty($items)){
			foreach($items as $key=>$value){
				if(property_exists($this,$key)) 
					$this->$key=$value;
				else
					throw new Exception('Propriedade '.$key.' não defina em '.get_class($this));
			}
			unset($items);
		}
	}
}
?>