<?php 
/**
* REGISTRO 0400: TABELA DE NATUREZA DA OPERAÇÃO/PRESTAÇÃO
* Este registro tem por objetivo codificar os textos das diferentes naturezas da operação/prestação discriminadas nos
* documentos fiscais. Esta codificação e suas descrições são livremente criadas e mantidas pelo contribuinte.
* Este registro não se refere a CFOP. Algumas empresas utilizam outra classificação além das apresentadas nos
* CFOP. Esta codificação permite informar estes agrupamentos próprios.
* Não podem ser informados dois ou mais registros com o mesmo conteúdo no campo COD_NAT
* Nível hierárquico - 2
* Ocorrência – vários (por arquivo)
* @version 1.0.0
* @package
*/
if(!defined('DS')) define('DS',DIRECTORY_SEPARATOR);
include_once(__DIR__.DS.'..'.DS.'Registro.php');
/**
*
*
*/
class Registro_0400 extends Registro{
	/**
	* versao
	*/
	const VERSION='1.0.0';
	
	/**
	* Texto fixo contendo “0400”.
	* @name REG
	* @size 4
	* @type string
	* @position 01
	* @required true	
	*/
	protected $reg='0400';
	
	/**
	* Código da natureza da operação/prestação.
	* @name $cod_nat
	* @size 10
	* @type string	
	* @position 02
	* @required true
	*/
	protected $cod_nat;
	
	/**
	* Descrição da natureza da operação/prestação
	* @name $descr_nat
	* @size undefined
	* @type string	
	* @position 03
	* @required true	
	*/
	protected $descr_nat;
	
	
	/**
	* metodo responsavel pela construcao do obj do registro 0
	* @param mixed[] $items Array associativo com proriedade como indices e seus respectivos valores
	*/
	public function __construct($items=null){
		if(is_array($items)&&!empty($items)){
			foreach($items as $key=>$value){
				if(property_exists($this,$key)) 
					$this->$key=$value;
				else
					throw new Exception('Propriedade '.$key.' não defina em '.get_class($this));
			}
			unset($items);
		}
	}
}
?>