<?php 
/**
* REGISTRO 0460: TABELA DE OBSERVAÇÕES DO LANÇAMENTO FISCAL
* Este registro é utilizado para informar anotações de escrituração determinadas pela legislação pertinente aos
* lançamentos fiscais, tais como: ajustes efetuados por diferimento parcial de imposto, antecipações, diferencial de alíquota e outros.
* Esta codificação e suas descrições são de atribuição do contribuinte e não podem ser informados dois ou mais registros com o mesmo conteúdo no campo COD_OBS.
* Nível hierárquico - 2
* Ocorrência –vários (por arquivo)
* @version 1.0.0
* @package
*/
if(!defined('DS')) define('DS',DIRECTORY_SEPARATOR);
include_once(__DIR__.DS.'..'.DS.'Registro.php');
/**
*
*
*/
class Registro_0460 extends Registro{
	/**
	* versao
	*/
	const VERSION='1.0.0';
	
	/**
	* Texto fixo contendo 0460.
	* @name REG
	* @size 4
	* @type string
	* @position 01
	* @required true	
	*/
	protected $reg='0460';
	
	/**
	* Código da Observação do lançamento fiscal.
	* @name $cod_obs
	* @size 6
	* @type string	
	* @position 02
	* @required true
	*/
	protected $cod_obs;
	
	/**
	* Descrição da observação vinculada ao lançamento fiscal
	* @name $txt
	* @size undefined
	* @type string	
	* @position 03
	* @required true	
	*/
	protected $txt;
	
	
	/**
	* metodo responsavel pela construcao do obj do registro 0
	* @param mixed[] $items Array associativo com proriedade como indices e seus respectivos valores
	*/
	public function __construct($items=null){
		if(is_array($items)&&!empty($items)){
			foreach($items as $key=>$value){
				if(property_exists($this,$key)) 
					$this->$key=$value;
				else
					throw new Exception('Propriedade '.$key.' não defina em '.get_class($this));
			}
			unset($items);
		}
	}
}
?>