<?php 
/**
* REGISTRO 0500: PLANO DE CONTAS CONTÁBEIS
* Este registro tem o objetivo de identificar as contas contábeis utilizadas pelo contribuinte informante em sua
* Contabilidade Geral, relativas às contas referenciadas no registro 0300. Não podem ser informados dois ou mais registros
* com a mesma combinação de conteúdo nos campos DT_ALT e COD_CTA.
* Nível hierárquico - 2
* Ocorrência - vários (por arquivo)
* @version 1.0.0
* @package
*/
if(!defined('DS')) define('DS',DIRECTORY_SEPARATOR);
include_once(__DIR__.DS.'..'.DS.'Registro.php');
/**
*
*
*/
class Registro_0500 extends Registro{
	/**
	* versao
	*/
	const VERSION='1.0.0';
	
	/**
	* Texto fixo contendo “0500”.
	* @name REG
	* @size 4
	* @type string
	* @position 01
	* @required true	
	*/
	protected $reg='0500';
	
	/**
	* Data da inclusão/alteração.
	* @name $dt_alt
	* @size 8
	* @type numeric	
	* @format ddmmaaaa
	* @position 02
	* @required true
	*/
	protected $dt_alt;
	
	/**
	* Código da natureza da conta/grupo de contas:
	* 	01 - Contas de ativo;
	* 	02 - Contas de passivo;
	* 	03 - Patrimônio líquido;
	* 	04 - Contas de resultado;
	* 	05 - Contas de compensação;
	* 	09 - Outras.
	* @name $cod_nat_cc
	* @size 2
	* @type string	
	* @position 03
	* @required true	
	*/
	protected $cod_nat_cc;
	
	/**
	* Indicador do tipo de conta:
	* 	S - Sintética (grupo de contas);
	* 	A - Analítica (conta).
	* $name $ind_cta
	* @size 1
	* @type string
	* @position 04
	* @required true
	*/
	protected $ind_cta;


	/**
	* Nível da conta analítica/grupo de contas.
	* $name $nivel
	* @size 5
	* @type numeric
	* @position 05
	* @required true
	*/
	protected $nivel;

	/**
	* Código da conta analítica/grupo de contas.
	* @name $cod_cta
	* @size 60
	* @type string	
	* @position 06
	* @required true	
	*/
	protected $cod_cta;

	/**
	* Nome da conta analítica/grupo de contas.
	* @name $nome_cta
	* @size 60
	* @type string	
	* @position 07
	* @required true
	*/
	protected $nome_cta;
	
	/**
	* metodo responsavel pela construcao do obj do registro 0
	* @param mixed[] $items Array associativo com proriedade como indices e seus respectivos valores
	*/
	public function __construct($items=null){
		if(is_array($items)&&!empty($items)){
			foreach($items as $key=>$value){
				if(property_exists($this,$key)) 
					$this->$key=$value;
				else
					throw new Exception('Propriedade '.$key.' não defina em '.get_class($this));
			}
			unset($items);
		}
	}
}
?>