<?php 
/**
* REGISTRO 0600: CENTRO DE CUSTOS
* Este registro tem o objetivo de identificar os centros de custos referenciados no registro 0305.
* Não podem ser informados dois ou mais registros com a mesma combinação de conteúdo nos campos DT_ALT e COD_CCUS.
* Nível hierárquico - 2
* Ocorrência - vários (por arquivo)
* @version 1.0.0
* @package
*/
if(!defined('DS')) define('DS',DIRECTORY_SEPARATOR);
include_once(__DIR__.DS.'..'.DS.'Registro.php');
/**
*
*
*/
class Registro_0600 extends Registro{
	/**
	* versao
	*/
	const VERSION='1.0.0';
	
	/**
	* Texto fixo contendo “0600”.
	* @name REG
	* @size 4
	* @type string
	* @position 01
	* @required true	
	*/
	protected $reg='0600';
	
	/**
	* Data da inclusão/alteração.
	* @name $dt_alt
	* @size 8
	* @type numeric	
	* @format ddmmaaaa
	* @position 02
	* @required true
	*/
	protected $dt_alt;
	
	/**
	* Código do centro de custos.
	* @name $cod_ccus
	* @size 60
	* @type string	
	* @position 06
	* @required true	
	*/
	protected $cod_ccus;

	/**
	* Nome do centro de custos.
	* @name $ccus
	* @size 60
	* @type string	
	* @position 07
	* @required true
	*/
	protected $ccus;
	
	/**
	* metodo responsavel pela construcao do obj do registro 0
	* @param mixed[] $items Array associativo com proriedade como indices e seus respectivos valores
	*/
	public function __construct($items=null){
		if(is_array($items)&&!empty($items)){
			foreach($items as $key=>$value){
				if(property_exists($this,$key)) 
					$this->$key=$value;
				else
					throw new Exception('Propriedade '.$key.' não defina em '.get_class($this));
			}
			unset($items);
		}
	}
}
?>