<?php 
/**
* REGISTRO 1010: OBRIGATORIEDADE DE REGISTROS DO BLOCO 1
* Este registro deverá ser apresentado por todos os contribuintes. Caso a resposta seja “S”, o contribuinte está
* obrigado à apresentação do registro respectivo. Se houver dispensa de apresentação do registro pela unidade federada, a
* resposta para o campo específico do registro deverá ser “N”.
* Nível hierárquico - 2
* Ocorrência – 1:1
* @version 1.0.0
* @package
*/
if(!defined('DS')) define('DS',DIRECTORY_SEPARATOR);
include_once(__DIR__.DS.'..'.DS.'Registro.php');
/**
*
*
*/
class Registro_1010 extends Registro{
	/**
	* versao
	*/
	const VERSION='1.0.0';
	
	/**
	* Texto fixo contendo 1010.
	* @name REG
	* @size 4
	* @type string
	* @position 01
	* @required true	
	*/
	protected $reg='1010';
	
	/**
	* Reg. 1100 - Ocorreu averbação (conclusão) de exportação no período:
	* 	S – Sim
	* 	N - Não
	* @name $ind_exp
	* @size 1
	* @type string	
	* @position 02
	* @required true
	*/
	protected $ind_exp;
	
	/**
	* Reg 1200 – Existem informações acerca de créditos de ICMS a serem controlados, definidos pela Sefaz:
	* 	S – Sim
	* 	N - Não
	* @name $ind_ccrf
	* @size 1
	* @type string
	* @position 03
	* @required true	
	*/
	protected $ind_ccrf;
	
	/**
	* Reg. 1300 – É comercio varejista de combustíveis com movimentação e/ou estoque no período:
	* 	S – Sim
	* 	N - Não 
	* @name $ind_comb
	* @size 1
	* @type string
	* @position 04
	* @required true
	*/
	protected $ind_comb;


	/**
	* Reg. 1390 – Usinas de açúcar e/álcool – O estabelecimento é produtor de açúcar e/ou álcool carburante com movimentação e/ou estoque no período:
	* 	S – Sim
	* 	N - Não
	* @name $ind_usina
	* @size 1
	* @type string
	* @position 05
	* @required true
	*/
	protected $ind_usina;

	/**
	* Reg 1400 – Sendo o registro obrigatório em sua Unidade de Federação, existem informações a serem prestadas neste registro:
	* 	S – Sim;
	* 	N - Não
	* @name $ind_va
	* @size 1
	* @type string	
	* @position 06
	* @required true	
	*/
	protected $ind_va;

	/**
	* Reg 1500 - A empresa é distribuidora de energia e ocorreu fornecimento de energia elétrica para consumidores de outra UF:
	* 	S – Sim;
	* 	N - Não
	* @name $ind_ee
	* @size 1
	* @type string
	* @position 07
	* @required true
	*/
	protected $ind_ee;


	/**
	* Reg 1600 - Realizou vendas com Cartão de Crédito ou de débito:
	*	S – Sim;
	*	N - Não
	* @name $ind_cart
	* @size 1
	* @type string
	* @position 08
	* @required true
	*/
	protected $ind_cart;

	/**
	* Reg. 1700 – Foram emitidos documentos fiscais em papel no período em unidade da federação que exija o controle de utilização de documentos fiscais:
	* 	S – Sim
	* 	N - Não
	* @name $ind_form
	* @size 1
	* @type string	
	* @position 09
	* @required true
	*/
	protected $ind_form;

	/**
	* Reg 1800 – A empresa prestou serviços de transporte aéreo de cargas e de passageiros:
	* 	S – Sim
	* 	N - Não
	* @name $ind_aer
	* @size 1
	* @type string
	* @position 10
	* @required true
	*/
	protected $ind_aer;

	/**
	* metodo responsavel pela construcao do obj do registro 0
	* @param mixed[] $items Array associativo com proriedade como indices e seus respectivos valores
	*/
	public function __construct($items=null){
		if(is_array($items)&&!empty($items)){
			foreach($items as $key=>$value){
				if(property_exists($this,$key)) 
					$this->$key=$value;
				else
					throw new Exception('Propriedade '.$key.' não definida em '.get_class($this));
			}
			unset($items);
		}
	}
}
?>