<?php 
/**
* REGISTRO C100: NOTA FISCAL (CÓDIGO 01), NOTA FISCAL AVULSA (CÓDIGO 1B), NOTA FISCAL DE PRODUTOR (CÓDIGO 04) E NF-e (CÓDIGO 55).
* Este registro deve ser gerado para cada documento fiscal código 01, 1B, 04 e 55, conforme item 4.1.1 do Ato
* COTEPE/ICMS nº 09, de 18 de abril de 2008, registrando a entrada ou saída de produtos ou outras situações que envolvam a emissão dos documentos fiscais mencionados.
* A partir do mês de referência abril de 2012, a informação do campo CHV_NFE passa a ser obrigatória em todas as situações, exceto para NFe com numeração inutilizada (COD_SIT = 05)
* Para cada registro C100, obrigatoriamente deve ser apresentado, pelo menos, um registro C170 e um registro
* C190, observadas as exceções abaixo relacionadas:
* ##################################################################################################
* - Exceção 1: Para documentos com código de situação (campo COD_SIT) cancelado (código “02”), cancelado
* extemporâneo (código “03”), Nota Fiscal Eletrônica (NF-e) denegada (código “04”), preencher somente os campos REG,
* IND_OPER, IND_EMIT, COD_MOD, COD_SIT, SER, NUM_DOC e CHV_NF-e. Para COD-SIT = 05 (numeração
* inutilizada), todos os campos referidos anteriormente devem ser preenchidos, exceto o campo CHV_NF-e. Demais campos
* deverão ser apresentados com conteúdo VAZIO “||”. Não informar registros filhos. A partir de janeiro de 2011, no caso de
* NF-e de emissão própria com código de situação (campo COD_SIT) cancelado (código “02”) e cancelado extemporâneo
* (código “03”) deverão ser informados os campos acima citados incluindo ainda a chave da NF-e.
* ##################################################################################################
* - Exceção 2: Notas Fiscais Eletrônicas - NF-e de emissão própria: regra geral, devem ser apresentados somente os registros
* C100 e C190, e, se existirem ajustes de documento fiscais determinados por legislação estadual (tabela 5.3 do Ato
* COTEPE ICMS 09/08), devem ser apresentados também os registros C195 e C197; somente será admitida a informação
* do registro C170 quando também houver sido informado o registro C176, hipótese de emissão de documento fiscal quando
* houver direito a Ressarcimento de ICMS em Operações com Substituição Tributária. A critério de cada UF, informar os
* registros C110 e C120, a partir de julho de 2012. ;
* ##################################################################################################
* - Exceção 3: Notas Fiscais Complementares e Notas Fiscais Complementares Extemporâneas (campo COD_SIT igual a
* “06” ou “07”): nesta situação, somente os campos REG, IND_EMIT, COD_PART, COD_MOD, COD_SIT, NUM_DOC e
* DT_DOC são de preenchimento obrigatório, devendo ser preenchida a data de efetiva saída, para os contribuintes das UFs
* que utilizam a data de saída para a apuração. Os demais campos são facultativos (se forem preenchidos, inclusive com
* valores iguais a zero, serão validadas e aplicadas as regras de campos existentes). O registro C190 é sempre obrigatório e
* deve ser totalmente preenchido. Os demais campos e registros filhos do registro C100 serão informados, quando houver
* informação a ser prestada. Se for informado o registro C170 o campo NUM_ITEM deve ser preenchido.
* ##################################################################################################
* -Exceção 4: Notas Fiscais emitidas por regime especial ou norma específica (campo COD_SIT igual a “08”). Para
* documentos fiscais emitidos com base em regime especial ou norma específica, deverão ser apresentados os registros C100
* e C190, obrigatoriamente, e os demais registros “filhos”, se estes forem exigidos pela legislação fiscal. Nesta situação, para
* o registro C100, somente os campos REG, IND_EMIT, COD_PART, COD_MOD, COD_SIT, NUM_DOC e DT_DOC
* são de preenchimento obrigatório. A partir do mês de referência abril de 2012 a informação do campo CHV_NFE passa a
* ser obrigatória neste caso para modelo 55. Os demais campos, com exceção do campo NUM_ITEM do registro C170, são
* facultativos (se forem preenchidos, inclusive com valores iguais a Zero, serão validados e aplicadas as regras de campos
* existentes) e deverão ser preenchidos, quando houver informação a ser prestada. Exemplos: a) Nota fiscal emitida em
* substituição ao cupom fiscal – CFOP igual a 5.929 ou 6.929 – (lançamento efetuado em decorrência de emissão de
* documento fiscal relativo à operação ou à prestação também registrada em equipamento Emissor de Cupom Fiscal – ECF,
* exceto para o contribuinte do Estado do Paraná, que deve efetuar a escrituração de acordo com a regra estabelecida na
* tabela de código de ajustes); b) Nos casos em que a legislação estadual permitir a emissão de NF sem informações do
* destinatário, preencher os dados do próprio emitente. Obs.: a partir de janeiro de 2012, para todos os documentos diferentes
* de NF-e e com COD_SIT igual a “08”, deverá ser informada no registro C110 a norma legal que autoriza o preenchimento
* do documento fiscal nessa situação.
* ##################################################################################################
* - Exceção 5: Para os documentos fiscais emitidos de acordo com o estabelecido em regimes especiais ou normas específicas,
* devidamente autorizados pelo fisco (campo COD_SIT igual a “08”), será permitida a informação de data de emissão de
* documento maior que a data de entrada ou saída. Ex. aquisição de cana-de-açúcar, venda de derivados de petróleo, etc. Será emitida Advertência pelo PVA-EFD.
* ##################################################################################################
*  - Exceção 6: Venda de produtos que geram direito a ressarcimento com utilização de NF-e: Nos casos de vendas, para
* outro estado, de produtos tributados por ST na operação anterior o contribuinte deverá indicar no registro C176 os dados
* para futura solicitação de ressarcimento. O registro C170 deverá ser preenchido apenas com os itens da NF que gerem
* direito ao pedido de ressarcimento, devendo também ser preenchido o registro C176 (utilização a partir de 01/06/2009). 
* A UF determinará a obrigatoriedade deste registro.
* ##################################################################################################
* - Exceção 7: Escrituração de documentos emitidos por terceiros: os casos de escrituração de documentos fiscais, inclusive
* NF-e, emitidos por terceiros (como por ex. o consórcio constituído nos termos do disposto nos arts. 278 e 279 da Lei nº
* 6.404, de 15 de dezembro de 1976) e das NF-e “avulsas” emitidas pelas UF (séries 890 a 899) devem ser informados como
* emissão de terceiros, com o código de situação do documento igual a “08 - Documento Fiscal emitido com base em
* Regime Especial ou Norma Específica”. O PVA-EFD exibirá a mensagem de Advertência para esses documentos.
* Obs: Os documentos fiscais emitidos pelas filiais das empresas que possuam inscrição estadual única ou sejam autorizadas
* pelos fiscos estaduais a centralizar suas escriturações fiscais deverão ser informados como sendo de emissão própria e
* código de situação igual a “00 – Documento regular”.Excepcionalmente, até junho de 2012, poderão ser informados como
* sendo de emissão de terceiros e código de situação de documento como sendo “08”.
* ##################################################################################################
* - Exceção 8: NF-e com o campo UF de consumo preenchido: nos casos de NF-e de emissão própria, quando o campo UF
* de consumo for preenchido (onde a UF de consumo é diversa da UF do destinatário), deve ser informado no registro C105.
* Não podem ser informados, para um mesmo documento fiscal, dois ou mais registros com a mesma combinação
* de valores dos campos formadores da chave do registro. A chave deste registro é:
* · para documentos com campo IND_EMIT igual a “1” (um) – emissão por terceiros: campo IND_OPER,
* campo IND_EMIT, campo COD_PART, campo COD_MOD, campo COD_SIT, campo SER e campo
* NUM_DOC;
* · para documentos com campo (IND_EMIT igual “0” (zero) – emissão própria: campo IND_OPER, campo
* IND_EMIT, campo COD_MOD, campo COD_SIT, campo SER e campo NUM_DOC.
* 
* Nível hierárquico - 2
* Ocorrência – vários (por arquivo)
* @version 1.0.0
* @package SpedFiscal
*/
if(!defined('DS')) define('DS',DIRECTORY_SEPARATOR);
include_once(__DIR__.DS.'..'.DS.'Registro.php');
/**
*
*
*/
class Registro_C100 extends Registro{
	/**
	* versao
	*/
	const VERSION='1.0.0';
	
	/**
	* Texto fixo contendo C100.
	* @name REG
	* @size 4
	* @type string
	* @position 01
	* @required true	
	*/
	protected $reg='C100';
	
	/**
	* Indicador do tipo de operação: 
	* consideram-se de emissão própria somente os documentos fiscais emitidos pelo estabelecimento
	* informante (campo CNPJ do registro 0000) da EFD. Documentos emitidos por outros estabelecimentos ainda que da
	* mesma empresa, devem ser considerados como documentos emitidos por terceiros. Nos casos de escrituração de
	* documentos fiscais de terceiros em operações de saídas (ex. consórcios de empresas), deve ser informado no campo 06 (COD_SIT) o código “08”.
	* Se a legislação estadual a que estiver submetido o contribuinte obrigá-lo a escriturar 
	* notas fiscais avulsas em operação de saída, este campo deve ser informado com valor igual a “0” (zero).
	* @name $ind_oper
	* @size 1
	* @type string	
	* @position 02
	* @required true
	* @values Valores válidos: [0- Entrada 1- Saída]
	* @validation se este campo tiver valor igual a 1 (um), o campo IND_OPER deve ser igual a “0” (zero).
	*/
	protected $ind_oper;
	
	/**
	* Indicador do emitente do documento fiscal
	* @name $ind_emit
	* @size 1
	* @type string	
	* @position 03
	* @required true
	* @values Valores Válidos :[0- Emissão própria 1- Terceiros]
	*/
	protected $ind_emit;
		
	/**
	*
	* Código do participante (campo 02 do Registro 0150)
	* - do emitente do documento ou do remetente das mercadorias, no caso de entradas;
	* - do adquirente, no caso de saídas
	* o valor informado deve existir no campo COD_PART do registro 0150.
	* @name $cod_part
	* @size 60
	* @type string	
	* @position 04
	* @required true	
	*/
	protected $cod_part;

	/**
	* Código do modelo do documento fiscal, conforme a Tabela 4.1.1
	* $name $cod_mod
	* @size 2
	* @type string
	* @position 05
	* @required true
	* @values Valores válidos [01, 1B, 04, 55]
	*/
	protected $cod_mod;
	
	/**
	* NCódigo da situação do documento fiscal, conforme a Tabela 4.1.2
	* $name $cod_sit
	* @size 2
	* @type numeric
	* @position 06
	* @required true
	* @values Valores válidos: [00, 01, 02, 03, 04, 05, 06, 07, 08]
	*/
	protected $cod_sit;
	
	/**
	* Série do documento fiscal
	* $name $ser
	* @size 3
	* @type numeric
	* @position 07
	* @required true
	*/
	protected $ser;
	
	/**
	* Número do documento fiscal.
	* $name $num_doc
	* @size 9
	* @type numeric
	* @position 08
	* @required true
	*/
	protected $num_doc;
	
	/**
	* Chave da Nota Fiscal Eletrônica.
	* $name $chv_nfe
	* @size 44
	* @type numeric
	* @position 09
	* @required true
	*/
	protected $chv_nfe;
	
	/**
	* Data da emissão do documento fiscal.
	* $name $dt_doc
	* @size 8
	* @type numeric
	* @position 10
	* @required true
	*/
	protected $dt_doc;
	
	/**
	* Data da entrada ou da saída.
	* $name $dt_e_s
	* @size 8
	* @type numeric
	* @position 11
	* @required true
	*/
	protected $dt_e_s;
	
	/**
	* Valor total do documento fiscal.
	* $name $vl_doc
	* @size undefined
	* @type decimal 2 casas decimais
	* @position 12
	* @required true
	*/
	protected $vl_doc;
	
	/**
	* Indicador do tipo de pagamento.
	* A partir de 01/07/2012 passará a ser:
	* - Indicador do tipo de pagamento:
	* 	0- À vista;
	* 	1- A prazo;
	* 	2 - Outros
	* $name $ind_pgto
	* @size 1
	* @type string
	* @position 13
	* @required true
	* @values Valores válidos [0- À vista 1- A prazo 9- Sem pagamento]
	*/
	protected $ind_pgto;
	
	/**
	* Valor total do desconto.
	* $name $vl_desc
	* @size undefined
	* @type decimal 2 casas decimais
	* @position 14
	* @required true
	*/
	protected $vl_desc;
	
	/**
	* Abatimento não tributado e não comercial Ex.desconto ICMS nas remessas para ZFM.
	* $name $vl_abat_nt
	* @size undefined
	* @type decimal 2 casas decimais
	* @position 15
	* @required true
	*/
	protected $vl_abat_nt;

	
	/**
	* Valor total das mercadorias e serviços.
	* $name $vl_merc
	* @size undefined
	* @type decimal 2 casas decimais
	* @position 16
	* @required true
	*/
	protected $vl_merc;
	
	/**
	* Indicador do tipo do frete.
	* Obs.: A partir de 01/01/2012 passará a ser:
	* - Indicador do tipo do frete:
	* 	0- Por conta do emitente;
	* 	1- Por conta do destinatário/remetente;
	* 	2- Por conta de terceiros;
	* 	9- Sem cobrança de frete.
	* $name $ind_frt
	* @size 1
	* @type string
	* @position 17
	* @required true
	* @values [0- Por conta de terceiros; 1- Por conta do emitente; 2- Por conta do destinatário; 9- Sem cobrança de frete.]
	*/
	protected $ind_frt;
	
	/**
	* Valor do frete indicado no documento fiscal.
	* $name $vl_frt
	* @size undefined
	* @type decimal 2 casas decimais
	* @position 18
	* @required true
	*/
	protected $vl_frt;
	
	/**
	* Valor do seguro indicado no documento fiscal.
	* $name $vl_seg
	* @size undefined
	* @type decimal 2 casas decimais
	* @position 19
	* @required true
	*/
	protected $vl_seg;
	
	/**
	* Valor de outras despesas acessórias.
	* $name $vl_out_da
	* @size undefined
	* @type decimal 2 casas decimais
	* @position 20
	* @required true
	*/
	protected $vl_out_da;
	
	/**
	* Valor da base de cálculo do ICMS.
	* $name $vl_bc_icms
	* @size undefined
	* @type decimal 2 casas decimais
	* @position 21
	* @required true
	*/
	protected $vl_bc_icms;
		
	/**
	* Valor do ICMS.
	* $name $vl_icms
	* @size undefined
	* @type decimal 2 casas decimais
	* @position 22
	* @required true
	*/
	protected $vl_icms;
	
	/**
	* Valor da base de cálculo do ICMS substituição tributária.
	* $name $vl_bc_icms_st
	* @size undefined
	* @type decimal 2 casas decimais
	* @position 23
	* @required true
	*/
	protected $vl_bc_icms_st;	
	
	/**
	* Valor do ICMS retido por substituição tributária.
	* $name $vl_icms_st
	* @size undefined
	* @type decimal 2 casas decimais
	* @position 24
	* @required true
	*/
	protected $vl_icms_st;
	
	/**
	* Valor total do IPI.
	* $name $vl_ipi
	* @size undefined
	* @type decimal 2 casas decimais
	* @position 25
	* @required true
	*/
	protected $vl_ipi;
	
	/**
	* Valor total do PIS.
	* $name $vl_pis
	* @size undefined
	* @type decimal 2 casas decimais
	* @position 26
	* @required true
	*/
	protected $vl_pis;
	
	/**
	* Valor total da COFINS.
	* $name $vl_cofins
	* @size undefined
	* @type decimal 2 casas decimais
	* @position 27
	* @required true
	*/
	protected $vl_cofins;
	
	/**
	* Valor total do PIS retido por substituição tributária.
	* $name $vl_pis_st
	* @size undefined
	* @type decimal 2 casas decimais
	* @position 28
	* @required true
	*/
	protected $vl_pis_st;
	
	/**
	* Valor total da COFINS retido por substituição tributária.
	* $name $vl_cofins_st
	* @size undefined
	* @type decimal 2 casas decimais
	* @position 29
	* @required true
	*/
	protected $vl_cofins_st;
	
	/**
	* metodo responsavel pela construcao do obj do registro 
	* @param mixed[] $items Array associativo com proriedade como indices e seus respectivos valores
	*/
	public function __construct($items=null){
		if(is_array($items)&&!empty($items)){
			foreach($items as $key=>$value){
				if(property_exists($this,$key)) 
					$this->$key=$value;
				else
					throw new Exception('Propriedade '.$key.' não defina em '.get_class($this));
			}
			unset($items);
		}
	}
}
?>