<?php 
/**
* REGISTRO C110:  INFORMAÇÃO COMPLEMENTAR DA NOTA FISCAL (CÓDIGO 01, 1B, 04 e 55).
* Este registro tem por objetivo identificar os dados contidos no campo Informações Complementares da Nota
Fiscal, que sejam de interesse do fisco, conforme dispõe a legislação. Devem ser discriminadas em registros “filhos
próprios” as informações relacionadas com documentos fiscais, processos, cupons fiscais, documentos de arrecadação e
locais de entrega ou coleta que foram explicitamente citadas no campo “Informações Complementares” da Nota Fiscal.
Não podem ser informados para um mesmo documento fiscal, dois ou mais registros com o mesmo conteúdo no
campo COD_INF.

* Nível hierárquico - 3
* Ocorrência - 1:N
* @version 1.0.0
* @package SpedFiscal
*/
if(!defined('DS')) define('DS',DIRECTORY_SEPARATOR);
include_once(__DIR__.DS.'..'.DS.'Registro.php');
/**
*
*
*/
class Registro_C110 extends Registro{
	/**
	* versao
	*/
	const VERSION='1.0.0';
	
	/**
	* Texto fixo contendo C110.
	* @name REG
	* @size 4
	* @type string
	* @position 01
	* @required true	
	*/
	protected $reg='C110';
	
	/**
	* Código da informação complementar do documento fiscal (campo 02 do Registro 0450)
	* @name $cod_inf
	* @size 6
	* @type string
	* @position 02
	* @required true
	*/
	protected $cod_inf;
	
	/**
	* Descrição complementar do código de referência
	* @name $txt_compl
	* @size undefined
	* @type string	
	* @position 03
	* @required false
	*/
	protected $txt_compl;
	
	/**
	* metodo responsavel pela construcao do obj do registro 
	* @param mixed[] $items Array associativo com proriedade como indices e seus respectivos valores
	*/
	public function __construct($items=null){
		if(is_array($items)&&!empty($items)){
			foreach($items as $key=>$value){
				if(property_exists($this,$key)) 
					$this->$key=$value;
				else
					throw new Exception('Propriedade '.$key.' não defina em '.get_class($this));
			}
			unset($items);
		}
	}
}
?>