<?php 
/**
* REGISTRO C400: EQUIPAMENTO ECF (CÓDIGO 02 e 2D).
* Este registro tem por objetivo identificar os equipamentos de ECF e deve ser informado por todos os contribuintes
* que utilizem tais equipamentos na emissão de documentos fiscais.
* Validação do Registro: não podem ser informados dois ou mais registros C400 com a mesma combinação de valores dos campos COD_MOD, ECF_MOD e ECF_FAB.
* Nível hierárquico - 2
* Ocorrência - 1:N
* @version 1.0.0
* @package SpedFiscal
*/
if(!defined('DS')) define('DS',DIRECTORY_SEPARATOR);
include_once(__DIR__.DS.'..'.DS.'Registro.php');
/**
*
*
*/
class Registro_C400 extends Registro{
	/**
	* versao
	*/
	const VERSION='1.0.0';
	
	/**
	* Texto fixo contendo C001.
	* @name REG
	* @size 4
	* @type string
	* @position 01
	* @required true	
	*/
	protected $reg='C400';
	
	/**
	* Código do modelo do documento fiscal,conforme a Tabela 4.1.1
	* @name $cod_mod
	* @size 2
	* @type string	
	* @position 02
	* @required true
	* @values Valores válidos: [02, 2D].
	*/
	protected $cod_mod;
	
	/**
	* Modelo do equipamento
	* @name $ecf_mod
	* @size 20
	* @type string	
	* @position 03
	* @required true
	*/
	protected $ecf_mod;
		
	/**
	*
	* Número de série de fabricação do ECF
	* @name $ecf_fab
	* @size 20
	* @type string	
	* @position 04
	* @required true	
	*/
	protected $ecf_fab;


	/**
	* Número do caixa atribuído ao ECF.
	* $name $ecf_cx
	* @size 3
	* @type numeric
	* @position 05
	* @required true
	*/
	protected $ecf_cx;
	
	/**
	* metodo responsavel pela construcao do obj do registro 
	* @param mixed[] $items Array associativo com proriedade como indices e seus respectivos valores
	*/
	public function __construct($items=null){
		if(is_array($items)&&!empty($items)){
			foreach($items as $key=>$value){
				if(property_exists($this,$key)) 
					$this->$key=$value;
				else
					throw new Exception('Propriedade '.$key.' não defina em '.get_class($this));
			}
			unset($items);
		}
	}
}
?>