<?php 
/**
* REGISTRO C420: REGISTRO DOS TOTALIZADORES PARCIAIS DA REDUÇÃO Z (COD 02 e 2D).
* Este registro tem por objetivo discriminar os valores por código de totalizador da Redução Z.
* Validação do Registro: não podem ser informados dois ou mais registros com a mesma combinação de valores dos campos COD_TOT_PAR e NR_TOT.
* Nível hierárquico - 4
* Ocorrência - 1:N
* @version 1.0.0
* @package SpedFiscal
*/
if(!defined('DS')) define('DS',DIRECTORY_SEPARATOR);
include_once(__DIR__.DS.'..'.DS.'Registro.php');
/**
*
*
*/
class Registro_C420 extends Registro{
	/**
	* versao
	*/
	const VERSION='1.0.0';
	
	/**
	* Texto fixo contendo C420.
	* @name REG
	* @size 4
	* @type string
	* @position 01
	* @required true	
	*/
	protected $reg='C420';
	
	/**
	* Código do totalizador, conforme Tabela 4.4.6
	* @name $cod_tot_par
	* @size 7
	* @type string
	* @position 02
	* @required true
	*/
	protected $cod_tot_par;
	
	/**
	* Valor acumulado no totalizador, relativo à respectiva Redução Z.
	* @name $vlr_acum_tot
	* @size undefined
	* @type decimal 2 casas decimais
	* @position 03
	* @required true	
	*/
	protected $vlr_acum_tot;
	
	/**
	*
	* Número do totalizador quando ocorrer mais de uma situação com a mesma carga tributária efetiva.
	* $name $nr_tot
	* @size 2
	* @type numeric
	* @position 04
	* @required true
	*/
	protected $nr_tot;


	/**
	* Descrição da situação tributária relativa ao totalizador parcial, quando houver mais de um com a mesma carga tributária efetiva.
	* $name $descr_nr_tot
	* @size undefined
	* @type string
	* @position 05
	* @required true
	*/
	protected $descr_nr_tot;
	
	/**
	* metodo responsavel pela construcao do obj do registro 0
	* @param mixed[] $items Array associativo com proriedade como indices e seus respectivos valores
	*/
	public function __construct($items=null){
		if(is_array($items)&&!empty($items)){
			foreach($items as $key=>$value){
				if(property_exists($this,$key)) 
					$this->$key=$value;
				else
					throw new Exception('Propriedade '.$key.' não definida em '.get_class($this));
			}
			unset($items);
		}
	}
}
?>