<?php 
/**
* REGISTRO C460: DOCUMENTO FISCAL EMITIDO POR ECF (CÓDIGO 02 e 2D).
* Este registro deve ser apresentado para a identificação dos documentos fiscais emitidos pelos usuários de equipamentos ECF, que foram totalizados na Redução Z.
* Para cupom fiscal cancelado, informar somente os campos COD_MOD, COD_SIT e NUM_DOC, sem os registros filhos.
* Obs.: Os CNPJ e CPF citados neste registro NÃO devem ser informados no registro 0150.
* Validação do Registro: não podem ser informados dois ou mais registros com a mesma combinação de valores dos campos COD_MOD, NUM_DOC e DT_DOC.
* Nível hierárquico - 4
* Ocorrência - 1:N
* @version 1.0.0
* @package
*/
if(!defined('DS')) define('DS',DIRECTORY_SEPARATOR);
include_once(__DIR__.DS.'..'.DS.'Registro.php');
/**
*
*
*/
class Registro_C460 extends Registro{
	/**
	* versao
	*/
	const VERSION='1.0.0';
	
	/**
	* Texto fixo contendo C460.
	* @name REG
	* @size 4
	* @type string
	* @position 01
	* @required true	
	*/
	protected $reg='C460';
	
	/**
	* Código do modelo do documento fiscal, conforme a Tabela 4.1.1
	* @name $cod_mod
	* @size 2
	* @type string	
	* @position 02
	* @required true
	* @values Valores Válidos: [02, 2D]
	*/
	protected $cod_mod;
	
	/**
	* Código da situação do documento fiscal, conforme a Tabela 4.1.2
	* @name $cod_sit
	* @size 2
	* @type numeric	
	* @position 03
	* @required true
	* @values Valores Válidos: [00, 01, 02]
	*/
	protected $cod_sit;
	
	/**
	*
	* Número do documento fiscal (COO)
	* $name $num_doc
	* @size 6
	* @type numeric
	* @position 04
	* @required true
	*/
	protected $num_doc;

	/**
	* Data da emissão do documento fiscal
	* $name $dt_doc
	* @size 8
	* @type numeric
	* @format ddmmaaaa	
	* @position 05
	* @required true
	*/
	protected $dt_doc;

	/**
	* Valor total do documento fiscal
	* @name $vl_doc
	* @size undefined
	* @type decimal 2 casas decimais
	* @position 06
	* @required true	
	*/
	protected $vl_doc;

	/**
	* Valor do PIS.
	* @name $vl_pis
	* @size undefined
	* @type decimal 2 casas decimais
	* @position 07
	* @required true
	*/
	protected $vl_pis;


	/**
	* Valor da COFINS.
	* @name $vl_cofins
	* @size undefined
	* @type dicmal 2 casas decimais
	* @position 08
	* @required true
	*/
	protected $vl_cofins;

	/**
	* CPF ou CNPJ do adquirente.
	* @name $cpf_cnpj
	* @size 14
	* @type numeric	
	* @position 09
	* @required true
	*/
	protected $cpf_cnpj;

	/**
	* Nome do adquirente.
	* @name $nom_adq
	* @size 60
	* @type string	
	* @position 10
	* @required true
	*/
	protected $nom_adq;

	/**
	* metodo responsavel pela construcao do obj do registro 0
	* @param mixed[] $items Array associativo com proriedade como indices e seus respectivos valores
	*/
	public function __construct($items=null){
		if(is_array($items)&&!empty($items)){
			foreach($items as $key=>$value){
				if(property_exists($this,$key)) 
					$this->$key=$value;
				else
					throw new Exception('Propriedade '.$key.' não definida em '.get_class($this));
			}
			unset($items);
		}
	}
}
?>