<?php 
/**
* REGISTRO C470: ITENS DO DOCUMENTO FISCAL EMITIDO POR ECF (CÓDIGO 02 e 2D).
* Este registro deve ser apresentado para informar os itens dos documentos fiscais emitidos pelos usuários de
* equipamentos ECF, que foram totalizados na Redução Z. O serviço de competência municipal (sujeito ao ISSQN) também
* deverá ser informado nesse registro. Para tanto, deverá ser criado o correspondente item no registro 0200, cujo conteúdo do
* campo TIPO_ITEM será igual “09” (Serviços). Não informar o registro para o item, cuja venda foi totalmente cancelada.
* Nível hierárquico - 5
* Ocorrência - 1:N
* @version 1.0.0
* @package
*/
if(!defined('DS')) define('DS',DIRECTORY_SEPARATOR);
include_once(__DIR__.DS.'..'.DS.'Registro.php');
/**
*
*
*/
class Registro_C470 extends Registro{
	/**
	* versao
	*/
	const VERSION='1.0.0';
	
	/**
	* Texto fixo contendo C470.
	* @name REG
	* @size 4
	* @type string
	* @position 01
	* @required true	
	*/
	protected $reg='C470';
	
	/**
	* Código do item (campo 02 do Registro 0200)
	* @name $cod_item
	* @size 60
	* @type string	
	* @position 02
	* @required true
	*/
	protected $cod_item;
	
	/**
	* Quantidade do item.
	* @name $qtd
	* @size undefined
	* @type decimal 3 casas decimais
	* @position 03
	* @required true
	*/
	protected $qtd;
	
	/**
	*
	* Quantidade cancelada, no caso de cancelamento parcial de item
	* $name $qtd_canc
	* @size undefined
	* @type decimal 3 casas decimais
	* @position 04
	* @required true
	*/
	protected $qtd_canc;

	/**
	* Unidade do item (Campo 02 do registro 0190)
	* $name $unid
	* @size 6
	* @type string
	* @position 05
	* @required true
	*/
	protected $unid;

	/**
	* Valor total do item
	* @name $vl_item
	* @size undefined
	* @type decimal 2 casas decimais
	* @position 06
	* @required true	
	*/
	protected $vl_item;

	/**
	* Código da Situação Tributária, conforme a Tabela indicada no item 4.3.1.
	* @name $cst_icms
	* @size 3
	* @type numeric
	* @position 07
	* @required true
	*/
	protected $cst_icms;


	/**
	* Código Fiscal de Operação e Prestação.
	* @name $cfop
	* @size 4
	* @type numeric
	* @position 08
	* @required true
	*/
	protected $cfop;

	/**
	* Alíquota do ICMS – Carga tributária efetiva em percentual.
	* @name $aliq_icms
	* @size 6
	* @type decimal 2 casa decimais
	* @position 09
	* @required true
	*/
	protected $aliq_icms;

	/**
	* Valor do PIS
	* @name $vl_pis
	* @size undefined
	* @type decimal 2 casas decimais
	* @position 10
	* @required true
	*/
	protected $vl_pis;
	
	/**
	* Valor da COFINS.
	* @name $vl_cofins
	* @size undefined
	* @type decimal 2 casas decimais
	* @position 11
	* @required true
	*/
	protected $vl_cofins;

	/**
	* metodo responsavel pela construcao do obj do registro 0
	* @param mixed[] $items Array associativo com proriedade como indices e seus respectivos valores
	*/
	public function __construct($items=null){
		if(is_array($items)&&!empty($items)){
			foreach($items as $key=>$value){
				if(property_exists($this,$key)) 
					$this->$key=$value;
				else
					throw new Exception('Propriedade '.$key.' não definida em '.get_class($this));
			}
			unset($items);
		}
	}
}
?>