<?php 
/**
* REGISTRO E110: APURAÇÃO DO ICMS – OPERAÇÕES PRÓPRIAS.
* Este registro tem por objetivo informar os valores relativos à apuração do ICMS referentes às operações próprias.
* O registro deve ser apresentado inclusive nos casos de períodos sem movimento. Neste caso, os valores deverão ser apresentados zerados.
* Nível hierárquico – 3 – registro obrigatório
* Ocorrência – um por período
* @version 1.0.0
* @package SpedFiscal
*/
if(!defined('DS')) define('DS',DIRECTORY_SEPARATOR);
include_once(__DIR__.DS.'..'.DS.'Registro.php');
/**
*
*
*/
class Registro_E110 extends Registro{
	/**
	* versao
	*/
	const VERSION='1.0.0';
	
	/**
	* Texto fixo contendo E110.
	* @name REG
	* @size 4
	* @type string
	* @position 01
	* @required true	
	*/
	protected $reg='E110';
	
	/**
	* Valor total dos débitos por "Saídas e prestações com débito do imposto"
	* @name $vl_tot_debitos
	* @size undefined
	* @type decimal 2 casas decimais decimais
	* @position 02
	* @required true
	*/
	protected $vl_tot_debitos;
	
	/**
	* Valor total dos ajustes a débito decorrentes do documento fiscal.
	* @name $vl_aj_debitos
	* @size undefined
	* @type decimal 2 casas decimais decimais
	* @position 03
	* @required true	
	*/
	protected $vl_aj_debitos;
	
	/**
	*
	* Valor total de "Ajustes a débito"
	* $name $vl_tot_aj_debitos
	* @size undefined
	* @type decimal 2 casas decimais
	* @position 04
	* @required true
	*/
	protected $vl_tot_aj_debitos;

	/**
	* Valor total de Ajustes “Estornos de créditos”
	* $name $vl_estornos_cred
	* @size undefined
	* @type decimal 2 casas decimais
	* @position 05
	* @required true
	*/
	protected $vl_estornos_cred;

	/**
	* Valor total dos créditos por "Entradas e aquisições com crédito do imposto"
	* @name $vl_tot_creditos
	* @size undefined
	* @type decimal 2 casas decimais
	* @position 06
	* @required true	
	*/
	protected $vl_tot_creditos;

	/**
	* Valor total dos ajustes a crédito decorrentes do documento fiscal.
	* @name $vl_aj_creditos
	* @size undefined
	* @type decimal 2 casas decimais
	* @position 07
	* @required true
	*/
	protected $vl_aj_creditos;


	/**
	* Valor total de "Ajustes a crédito"
	* @name $vl_tot_aj_creditos
	* @size undefined
	* @type decimal 2 casas decimais
	* @position 08
	* @required true
	*/
	protected $vl_tot_aj_creditos;

	/**
	* Valor total de Ajustes “Estornos de Débitos”
	* @name $vl_estornos_deb
	* @size undefined
	* @type decimal 2 casas decimais
	* @position 09
	* @required true
	*/
	protected $vl_estornos_deb;

	/**
	* Valor total de "Saldo credor do período anterior"
	* @name $vl_sld_credor_ant
	* @size undefined
	* @type decimal 2 casas decimais
	* @position 10
	* @required true
	*/
	protected $vl_sld_credor_ant;

	/**
	* Valor do saldo devedor apurado
	* @name $vl_sld_apurado
	* @size undefined
	* @type decimal 2 casas decimais
	* @position 11
	* @required true
	*/
	protected $vl_sld_apurado;

	/**
	* Valor total de "Deduções"
	* @name $vl_tot_ded
	* @size undefined
	* @type decimal 2 casas decimais
	* @position 12
	* @required true
	*/
	protected $vl_tot_ded;

	/**
	* Valor total de "ICMS a recolher (11-12)
	* @name $vl_icms_recolher
	* @size undefined
	* @type decimal 2 casas decimais
	* @position 13	
	* @required true
	*/
	protected $vl_icms_recolher;

	/**
	* Valor total de "Saldo credor a transportar para o período seguinte”
	* @name $vl_sld_credor_transportar
	* @size undefined
	* @type decimal 2 casas decimais
	* @position 14
	* @required true
	*/
	protected $vl_sld_credor_transportar;

	/**
	* Valores recolhidos ou a recolher, extraapuração.
	* @name $deb_esp
	* @size undefined
	* @type decimal 2 casas decimais
	* @position 15
	* @required true
	*/
	protected $deb_esp;
	
	/**
	* metodo responsavel pela construcao do obj do registro 0
	* @param mixed[] $items Array associativo com proriedade como indices e seus respectivos valores
	*/
	public function __construct($items=null){
		if(is_array($items)&&!empty($items)){
			foreach($items as $key=>$value){
				if(property_exists($this,$key)) 
					$this->$key=$value;
				else
					throw new Exception('Propriedade '.$key.' não definida em '.get_class($this));
			}
			unset($items);
		}
	}
}
?>