<?php 
/**
* REGISTRO E200: PERÍODO DA APURAÇÃO DO ICMS - SUBSTITUIÇÃO TRIBUTÁRIA
* Este registro tem por objetivo informar o(s) período(s) de apuração do ICMS – Substituição Tributária para cada
UF onde o informante seja inscrito como substituto tributário, inclusive para o seu estado, nas operações internas que
envolvam substituição, e também para UF para a qual o declarante tenha comercializado e que não tenha inscrição como
substituto. Os períodos informados devem abranger todo o período previsto no registro 0000, sem haver sobreposição ou
omissão de datas, por UF.
Este registro, também, deverá ser informado pelo substituído, se este for o responsável pelo recolhimento do
imposto devido nas operações subsequentes, quando recebe mercadoria de outra unidade da federação, sujeita ao regime de
substituição tributária, na hipótese de o remetente não estar obrigado à retenção do imposto
* Ocorrência – 1:N
* @version 1.0.0
* @package SpedFiscal
*/
if(!defined('DS')) define('DS',DIRECTORY_SEPARATOR);
include_once(__DIR__.DS.'..'.DS.'Registro.php');
/**
*
*
*/
class Registro_E200 extends Registro{
	/**
	* versao
	*/
	const VERSION='1.0.0';
	
	/**
	* Texto fixo contendo E200.
	* @name REG
	* @size 4
	* @type string
	* @position 01
	* @required true	
	*/
	protected $reg='E200';
	
	/**
	Sigla da unidade da federação a que se refere a apuração do ICMS ST
	*/
	protected $uf;
	
	/**
	* Data inicial a que a apuração se refere
	* @name $dt_ini
	* @size 8
	* @type numeric	
	* @format ddmmaaaa
	* @position 02
	* @required true
	*/
	protected $dt_ini;
	
	/**
	* Data final a que a apuração se refere
	* @name $dt_end
	* @size 8
	* @type numeric	
	* @format ddmmaaaa
	* @position 03
	* @required true	
	*/
	protected $dt_fin;
	
	/**
	* metodo responsavel pela construcao do obj do registro 0
	* @param mixed[] $items Array associativo com proriedade como indices e seus respectivos valores
	*/
	public function __construct($items=null){
		if(is_array($items)&&!empty($items)){
			foreach($items as $key=>$value){
				if(property_exists($this,$key)) 
					$this->$key=$value;
				else
					throw new Exception('Propriedade '.$key.' não definida em '.get_class($this));
			}
			unset($items);
		}
	}
}
?>