<?php 
/**
* REGISTRO E210: APURAÇÃO DO ICMS – SUBSTITUIÇÃO TRIBUTÁRIA
* Este registro tem por objetivo informar valores relativos à apuração do ICMS de substituição tributária, mesmo nos casos de períodos sem movimento. 
* Nível hierárquico – 3 – registro obrigatório
* Ocorrência – um por período
* @version 1.0.0
* @package SpedFiscal
*/
if(!defined('DS')) define('DS',DIRECTORY_SEPARATOR);
include_once(__DIR__.DS.'..'.DS.'Registro.php');
/**
*
*
*/
class Registro_E210 extends Registro{
	/**
	* versao
	*/
	const VERSION='1.0.0';
	
	/**
	* Texto fixo contendo E210.
	* @name REG
	* @size 4
	* @type string
	* @position 01
	* @required true	
	*/
	protected $reg='E210';
	
	/**
	* Indicador de movimento:0 – Sem operações com ST; 1 – Com operações de ST
	* @name $ind_mov_st
	* @size 1
	* @type string
	* @position 02
	* @required true
	*/
	protected $ind_mov_st;
	
	/**
	* Valor do "Saldo credor de período anterior – Substituição Tributária"
	* @name $vl_sld_cred_ant_st
	* @size undefined
	* @type decimal 2 casas decimais decimais
	* @position 03
	* @required true	
	*/
	protected $vl_sld_cred_ant_st;
	
	/**
	*
	* Valor total do ICMS ST de devolução de mercadorias
	* $name $vl_devol_st
	* @size undefined
	* @type decimal 2 casas decimais
	* @position 04
	* @required true
	*/
	protected $vl_devol_st;

	/**
	* Valor total do ICMS ST de ressarcimentos
	* $name $vl_ressarc_st
	* @size undefined
	* @type decimal 2 casas decimais
	* @position 05
	* @required true
	*/
	protected $vl_ressarc_st;

	/**
	* Valor total de Ajustes "Outros créditos ST" e “Estorno de débitos ST”
	* @name $vl_out_cred_st
	* @size undefined
	* @type decimal 2 casas decimais
	* @position 06
	* @required true	
	*/
	protected $vl_out_cred_st;

	/**
	* Valor total dos ajustes a crédito de ICMS ST, provenientes de ajustes do documento fiscal.
	* @name $vl_aj_creditos_st
	* @size undefined
	* @type decimal 2 casas decimais
	* @position 07
	* @required true
	*/
	protected $vl_aj_creditos_st;

	/**
	* Valor Total do ICMS retido por Substituição Tributária
	* @name $vl_retencao_st
	* @size undefined
	* @type decimal 2 casas decimais
	* @position 08
	* @required true
	*/
	protected $vl_retencao_st;

	/**
	* Valor Total dos ajustes "Outros débitos ST" " e “Estorno de créditos ST”
	* @name $vl_out_deb_st
	* @size undefined
	* @type decimal 2 casas decimais
	* @position 09
	* @required true
	*/
	protected $vl_out_deb_st;

	/**
	* Valor total dos ajustes a débito de ICMS ST, provenientes de ajustes do documento fiscal.
	* @name $vl_aj_debitos_st
	* @size undefined
	* @type decimal 2 casas decimais
	* @position 10
	* @required true
	*/
	protected $vl_aj_debitos_st;

	/**
	* Valor total de Saldo devedor antes das deduções
	* @name $vl_sld_dev_ant_st
	* @size undefined
	* @type decimal 2 casas decimais
	* @position 11
	* @required true
	*/
	protected $vl_sld_dev_ant_st;

	/**
	* Valor total dos ajustes "Deduções ST"
	* @name $vl_deducoes_st
	* @size undefined
	* @type decimal 2 casas decimais
	* @position 12
	* @required true
	*/
	protected $vl_deducoes_st;

	/**
	* Valor total de "ICMS a recolher ST (11-12)
	* @name $vl_icms_recol_st
	* @size undefined
	* @type decimal 2 casas decimais
	* @position 13	
	* @required true
	*/
	protected $vl_icms_recol_st;

	/**
	* Valor total de "Saldo credor a transportar para o período seguinte”
	* @name $vl_sld_cred_st_transportar
	* @size undefined
	* @type decimal 2 casas decimais
	* @position 14
	* @required true
	*/
	protected $vl_sld_cred_st_transportar;

	/**
	* Valores recolhidos ou a recolher, extraapuração.
	* @name $deb_esp_st
	* @size undefined
	* @type decimal 2 casas decimais
	* @position 15
	* @required true
	*/
	protected $deb_esp_st;
	
	/**
	* metodo responsavel pela construcao do obj do registro 0
	* @param mixed[] $items Array associativo com proriedade como indices e seus respectivos valores
	*/
	public function __construct($items=null){
		if(is_array($items)&&!empty($items)){
			foreach($items as $key=>$value){
				if(property_exists($this,$key)) 
					$this->$key=$value;
				else
					throw new Exception('Propriedade '.$key.' não definida em '.get_class($this));
			}
			unset($items);
		}
	}
}
?>