<?php 
/**
* REGISTRO K100: PERÍODO DE APURAÇÃO DO ICMS/IPI
* Este registro tem o objetivo de informar o período de apuração do ICMS ou do IPI, prevalecendo os períodos mais curtos.
* Nível hierárquico - 2
* Ocorrência - vários
* @version 1.0.0
* @package
*/
if(!defined('DS')) define('DS',DIRECTORY_SEPARATOR);
include_once(__DIR__.DS.'..'.DS.'Registro.php');
/**
*
*
*/
class Registro_K100 extends Registro{
	/**
	* versao
	*/
	const VERSION='1.0.0';
	
	/**
	* Texto fixo contendo K100.
	* @name REG
	* @size 4
	* @type string
	* @position 01
	* @required true	
	*/
	protected $reg='K100';
	
	/**
	* Data inicial a que a apuração se refere
	* @name $dt_ini
	* @size 8
	* @type numerico	
	* @position 02
	* @required true
	*/
	protected $dt_ini;
	
	/**
	* Data final a que a apuração se refere
	* @name $dt_fin
	* @size 8
	* @type numerico	
	* @position 03
	* @required true
	*/
	protected $dt_fin;
	
	/**
	* metodo responsavel pela construcao do obj do registro 0
	* @param mixed[] $items Array associativo com proriedade como indices e seus respectivos valores
	*/
	public function __construct($items=null){
		if(is_array($items)&&!empty($items)){
			foreach($items as $key=>$value){
				if(property_exists($this,$key)) 
					$this->$key=$value;
				else
					throw new Exception('Propriedade '.$key.' não defina em '.get_class($this));
			}
			unset($items);
		}
	}
}
?>