<?php 
/**
* REGISTRO K200: ESTOQUE ESCRITURADO
* Este registro tem o objetivo de informar o estoque final escriturado do período de apuração informado no Registro K100.
* Nível hierárquico - 3
* Ocorrência - 1:N
* @version 1.0.0
* @package
*/
if(!defined('DS')) define('DS',DIRECTORY_SEPARATOR);
include_once(__DIR__.DS.'..'.DS.'Registro.php');
/**
*
*
*/
class Registro_K200 extends Registro{
	/**
	* versao
	*/
	const VERSION='1.0.0';
	
	/**
	* Texto fixo contendo K200.
	* @name REG
	* @size 4
	* @type caractere
	* @position 01
	* @required true	
	*/
	protected $reg='K200';
	
	/**
	* Data do estoque final
	* @name $dt_est
	* @size 8
	* @type numerico	
	* @position 02
	* @required true
	*/
	protected $dt_est;
	
	/**
	* Código do item (campo 02 do Registro 0200)
	* @name $cod_item
	* @size 60
	* @type caractere	
	* @position 03
	* @required true
	*/
	protected $cod_item;
	
	/**
	* Quantidade em estoque
	* @name $qtd
	* @size -
	* @type numerico	
	* @position 04
	* @required true
	*/
	protected $qtd;
	
	/**
	* Indicador do tipo de estoque:
	0 = Estoque de propriedade do informante e	em seu poder;
	1 = Estoque de propriedade do informante e	em posse de terceiros;
	2 = Estoque de propriedade de terceiros e em posse do informante;
	* @name $ind_est
	* @size 1
	* @type caractere	
	* @position 05
	* @required true
	*/
	protected $ind_est;
	
	/**
	* Código do participante (campo 02 do Registro 0150) - proprietário que não seja o informante do arquivo
	* @name $cod_part
	* @size 60
	* @type caractere	
	* @position 06
	* @required false
	*/
	protected $cod_part;
	
	/**
	* metodo responsavel pela construcao do obj do registro 0
	* @param mixed[] $items Array associativo com proriedade como indices e seus respectivos valores
	*/
	public function __construct($items=null){
		if(is_array($items)&&!empty($items)){
			foreach($items as $key=>$value){
				if(property_exists($this,$key)) 
					$this->$key=$value;
				else
					throw new Exception('Propriedade '.$key.' não defina em '.get_class($this));
			}
			unset($items);
		}
	}
}
?>