<?php 
/**
* REGISTRO K215: DESMONTAGEM DE MERCADORIAS - ITENS DE DESTINO
* Este registro tem o objetivo de escriturar a desmontagem de mercadorias de tipos: 00 - Mercadoria para revenda; 01 - Matéria-Prima; 02 - Embalagem; 03 - Produtos em Processo; 04 - Produto Acabado; 05 - Subproduto e 10 - Outros Insumos - campo TIPO_ITEM do Registro 0200, no que se refere à entrada em estoque do item de destino
* Nível hierárquico - 4
* Ocorrência - 1:N
* @version 1.0.0
* @package
*/
if(!defined('DS')) define('DS',DIRECTORY_SEPARATOR);
include_once(__DIR__.DS.'..'.DS.'Registro.php');
/**
*
*
*/
class Registro_K215 extends Registro{
	/**
	* versao
	*/
	const VERSION='1.0.0';
	
	/**
	* Texto fixo contendo K215.
	* @name REG
	* @size 4
	* @type caractere
	* @position 01
	* @required true	
	*/
	protected $reg='K215';
	
	/**
	* Código do item de destino (campo 02 do Registro 0200)
	* @name $cod_item_des
	* @size 60
	* @type caractere
	* @position 02
	* @required true
	*/
	protected $cod_item_des;
	
	/**
	* Quantidade de destino - entrada em estoque
	* @name $qtd_des
	* @size -
	* @type numerico
	* @position 03
	* @required true
	*/
	protected $qtd_des;
	
	/**
	* metodo responsavel pela construcao do obj do registro 0
	* @param mixed[] $items Array associativo com proriedade como indices e seus respectivos valores
	*/
	public function __construct($items=null){
		if(is_array($items)&&!empty($items)){
			foreach($items as $key=>$value){
				if(property_exists($this,$key)) 
					$this->$key=$value;
				else
					throw new Exception('Propriedade '.$key.' não defina em '.get_class($this));
			}
			unset($items);
		}
	}
}
?>