<?php 
/**
* REGISTRO K220: OUTRAS MOVIMENTAÇÕES INTERNAS ENTRE MERCADORIAS
* Este registro tem o objetivo de informar a movimentação interna entre mercadorias de tipos: 00 – Mercadoria para revenda; - campo TIPO_ITEM do Registro 0200; que não se enquadre nas movimentações internas já informadas nos demais tipos de registros.
* Nível hierárquico - 3
* Ocorrência - 1:N
* @version 1.0.0
* @package
*/
if(!defined('DS')) define('DS',DIRECTORY_SEPARATOR);
include_once(__DIR__.DS.'..'.DS.'Registro.php');
/**
*
*
*/
class Registro_K220 extends Registro{
	/**
	* versao
	*/
	const VERSION='1.0.0';
	
	/**
	* Texto fixo contendo K220.
	* @name REG
	* @size 4
	* @type caractere
	* @position 01
	* @required true	
	*/
	protected $reg='K220';
	
	/**
	* Data da movimentação interna
	* @name $dt_mov
	* @size 8
	* @type numerico
	* @position 02
	* @required true
	*/
	protected $dt_mov;
	
	/**
	* Código do item de origem (campo 02 do Registro 0200)
	* @name $cod_item_ori
	* @size 60
	* @type caractere
	* @position 03
	* @required true
	*/
	protected $cod_item_ori;
	
	/**
	* Código do item de destino (campo 02 do Registro 0200)
	* @name $cod_item_dest
	* @size 60
	* @type caractere
	* @position 04
	* @required true
	*/
	protected $cod_item_dest;
	
	/**
	* Quantidade movimentada
	* @name $qtd
	* @size -
	* @type numerico
	* @position 05
	* @required true
	*/
	protected $qtd;
	
	/**
	* metodo responsavel pela construcao do obj do registro 0
	* @param mixed[] $items Array associativo com proriedade como indices e seus respectivos valores
	*/
	public function __construct($items=null){
		if(is_array($items)&&!empty($items)){
			foreach($items as $key=>$value){
				if(property_exists($this,$key)) 
					$this->$key=$value;
				else
					throw new Exception('Propriedade '.$key.' não defina em '.get_class($this));
			}
			unset($items);
		}
	}
}
?>