<?php 
/**
* REGISTRO K230: ITENS PRODUZIDOS
* Este registro tem o objetivo de informar a produção acabada de produto em processo (tipo 03 – campo TIPO_ITEM do registro 0200) e produto acabado (tipo 04 – campo TIPO_ITEM do registro 0200), inclusive daquele industrializado para terceiro por encomenda.
* Nível hierárquico - 3
* Ocorrência - 1:N
* @version 1.0.0
* @package
*/
if(!defined('DS')) define('DS',DIRECTORY_SEPARATOR);
include_once(__DIR__.DS.'..'.DS.'Registro.php');
/**
*
*
*/
class Registro_K230 extends Registro{
	/**
	* versao
	*/
	const VERSION='1.0.0';
	
	/**
	* Texto fixo contendo K230.
	* @name REG
	* @size 4
	* @type caractere
	* @position 01
	* @required true	
	*/
	protected $reg='K230';
	
	/**
	* Data de início da ordem de produção
	* @name $dt_ini_op
	* @size 8
	* @type numerico
	* @position 02
	* @required false
	*/
	protected $dt_ini_op;
	
	/**
	* Data de conclusão da ordem de produção
	* @name $dt_fin_op
	* @size 8
	* @type numerico
	* @position 03
	* @required false
	*/
	protected $dt_fin_op;
	
	/**
	* Código de identificação da ordem de produção
	* @name $cod_doc_op
	* @size 30
	* @type caractere
	* @position 04
	* @required false
	*/
	protected $cod_doc_op;
	
	/**
	* Código do item produzido (campo 02 do Registro 0200)
	* @name $cod_item
	* @size 60
	* @type caractere
	* @position 05
	* @required true
	*/
	protected $cod_item;
	
	/**
	* Quantidade de produção acabada
	* @name $qtd_enc
	* @size -
	* @type numerico
	* @position 05
	* @required true
	*/
	protected $qtd_enc;
	
	/**
	* metodo responsavel pela construcao do obj do registro 0
	* @param mixed[] $items Array associativo com proriedade como indices e seus respectivos valores
	*/
	public function __construct($items=null){
		if(is_array($items)&&!empty($items)){
			foreach($items as $key=>$value){
				if(property_exists($this,$key)) 
					$this->$key=$value;
				else
					throw new Exception('Propriedade '.$key.' não defina em '.get_class($this));
			}
			unset($items);
		}
	}
}
?>