<?php 
/**
* REGISTRO K260: REPROCESSAMENTO/REPARO DE PRODUTO/INSUMO
* Este registro tem o objetivo de informar o produto que será reprocessado ou que foi reprocessado e o insumo que será reparado ou que foi reparado no período de apuração do Registro K100.
* Nível hierárquico - 3
* Ocorrência - 1:N
* @version 1.0.0
* @package
*/
if(!defined('DS')) define('DS',DIRECTORY_SEPARATOR);
include_once(__DIR__.DS.'..'.DS.'Registro.php');
/**
*
*
*/
class Registro_K260 extends Registro{
	/**
	* versao
	*/
	const VERSION='1.0.0';
	
	/**
	* Texto fixo contendo K260.
	* @name REG
	* @size 4
	* @type caractere
	* @position 01
	* @required true	
	*/
	protected $reg='K260';
	
	/**
	* Código de identificação da ordem de produção, no reprocessamento, ou da ordem de serviço, no reparo
	* @name $cod_op_os
	* @size 30
	* @type caractere
	* @position 02
	* @required false
	*/
	protected $cod_op_os;
	
	/**
	* Código do produto/insumo a ser reprocessado/reparado ou já reprocessado/reparado (campo 02 do Registro 0200)
	* @name $cod_item
	* @size 60
	* @type caractere
	* @position 03
	* @required true
	*/
	protected $cod_item;
	
	/**
	* Data de saída do estoque
	* @name $dt_saida
	* @size 8
	* @type numerico
	* @position 04
	* @required true
	*/
	protected $dt_saida;
	
	/**
	* Quantidade de saída do estoque
	* @name $qtd_saida
	* @size -
	* @type numerico
	* @position 05
	* @required true
	*/
	protected $qtd_saida;
	
	/**
	* Data de retorno ao estoque (entrada)
	* @name $dt_ret
	* @size 8
	* @type numerico
	* @position 06
	* @required false
	*/
	protected $dt_ret;
	
	/**
	* Quantidade de retorno ao estoque (entrada)
	* @name $qtd_ret
	* @size -
	* @type numerico
	* @position 07
	* @required false
	*/
	protected $qtd_ret;
	
	/**
	* metodo responsavel pela construcao do obj do registro 0
	* @param mixed[] $items Array associativo com proriedade como indices e seus respectivos valores
	*/
	public function __construct($items=null){
		if(is_array($items)&&!empty($items)){
			foreach($items as $key=>$value){
				if(property_exists($this,$key)) 
					$this->$key=$value;
				else
					throw new Exception('Propriedade '.$key.' não defina em '.get_class($this));
			}
			unset($items);
		}
	}
}
?>