<?php 
/**
* REGISTRO K275: CORREÇÃO DE APONTAMENTO E RETORNO DE INSUMOS DOS REGISTROS K215, K220, K235, K255 E K265.
* Este registro tem o objetivo de escriturar correção de apontamento de período de apuração anterior, relativo ao Registro-filho, por tipo de Registro e por período de apuração em que o apontamento será corrigido.
* Nível hierárquico - 4
* Ocorrência - 1:N
* @version 1.0.0
* @package
*/
if(!defined('DS')) define('DS',DIRECTORY_SEPARATOR);
include_once(__DIR__.DS.'..'.DS.'Registro.php');
/**
*
*
*/
class Registro_K275 extends Registro{
	/**
	* versao
	*/
	const VERSION='1.0.0';
	
	/**
	* Texto fixo contendo K275.
	* @name REG
	* @size 4
	* @type caractere
	* @position 01
	* @required true	
	*/
	protected $reg='K275';
	
	/**
	* Código da mercadoria (campo 02 do Registro 0200)
	* @name $cod_item
	* @size 60
	* @type caractere
	* @position 02
	* @required true
	*/
	protected $cod_item;
	
	/**
	* Quantidade de correção positiva de apontamento ocorrido em período de apuração anterior
	* @name $qtd_cor_pos
	* @size -
	* @type numerico
	* @position 03
	* @required false
	*/
	protected $qtd_cor_pos;
	
	/**
	* Quantidade de correção negativa de apontamento ocorrido em período de apuração anterior
	* @name $qtd_cor_neg
	* @size -
	* @type numerico
	* @position 04
	* @required false
	*/
	protected $qtd_cor_neg;
	
	/**
	* Código do insumo que foi substituído, caso ocorra a substituição, relativo aos Registros K235/K255.
	* @name $cod_ins_subst
	* @size 60
	* @type caractere
	* @position 05
	* @required false
	*/
	protected $cod_ins_subst;
	
	/**
	* metodo responsavel pela construcao do obj do registro 0
	* @param mixed[] $items Array associativo com proriedade como indices e seus respectivos valores
	*/
	public function __construct($items=null){
		if(is_array($items)&&!empty($items)){
			foreach($items as $key=>$value){
				if(property_exists($this,$key)) 
					$this->$key=$value;
				else
					throw new Exception('Propriedade '.$key.' não defina em '.get_class($this));
			}
			unset($items);
		}
	}
}
?>