<?php 
/**
* REGISTRO K280: CORREÇÃO DE APONTAMENTO - ESTOQUE ESCRITURADO
* Este registro tem o objetivo de escriturar correção de apontamento de estoque escriturado de período de apuração anterior, escriturado no Registro K200.
* Nível hierárquico - 3
* Ocorrência - 1:N
* @version 1.0.0
* @package
*/
if(!defined('DS')) define('DS',DIRECTORY_SEPARATOR);
include_once(__DIR__.DS.'..'.DS.'Registro.php');
/**
*
*
*/
class Registro_K280 extends Registro{
	/**
	* versao
	*/
	const VERSION='1.0.0';
	
	/**
	* Texto fixo contendo K280.
	* @name REG
	* @size 4
	* @type caractere
	* @position 01
	* @required true	
	*/
	protected $reg='K280';
	
	/**
	* Data do estoque final escriturado que está sendo corrigido
	* @name $dt_est
	* @size 8
	* @type numerico
	* @position 02
	* @required true
	*/
	protected $dt_est;
	
	/**
	* Código do item (campo 02 do Registro 0200)
	* @name $cod_item
	* @size 60
	* @type caractere
	* @position 03
	* @required true
	*/
	protected $cod_item;
	
	/**
	* Quantidade de correção positiva de apontamento ocorrido em período de apuração anterior
	* @name $qtd_cor_pos
	* @size -
	* @type numerico
	* @position 04
	* @required false
	*/
	protected $qtd_cor_pos;
	
	/**
	* Quantidade de correção negativa de apontamento ocorrido em período de apuração anterior
	* @name $qtd_cor_neg
	* @size -
	* @type numerico
	* @position 05
	* @required false
	*/
	protected $qtd_cor_neg;
	
	/**
	* Indicador do tipo de estoque: 0 = Estoque de propriedade do informante e em seu poder; 1 = Estoque de propriedade do informante e em posse de terceiros; 2 = Estoque de propriedade de terceiros e em posse do informante
	* @name $ind_est
	* @size 1
	* @type caractere
	* @position 06
	* @required true
	*/
	protected $ind_est;
	
	/**
	* Código do participante (campo 02 do Registro 0150): - proprietário/possuidor que não seja o informante do arquivo
	* @name $cod_part
	* @size 60
	* @type caractere
	* @position 07
	* @required false
	*/
	protected $cod_part;
	
	/**
	* metodo responsavel pela construcao do obj do registro 0
	* @param mixed[] $items Array associativo com proriedade como indices e seus respectivos valores
	*/
	public function __construct($items=null){
		if(is_array($items)&&!empty($items)){
			foreach($items as $key=>$value){
				if(property_exists($this,$key)) 
					$this->$key=$value;
				else
					throw new Exception('Propriedade '.$key.' não defina em '.get_class($this));
			}
			unset($items);
		}
	}
}
?>