<?php

// namespace Exemplo;

require '../vendor/autoload.php';

class MySetup extends Sped\Gnre\Configuration\Setup{

    public function getBaseUrl(){
		return "http://dev.uds.com.br/julio/sped-gnre-master/";
    }

    public function getCertificateCnpj(){
		return "00744544000168";
    }

    public function getCertificateDirectory(){
		return "/var/www/uploads/AGROMGA/certificados/";
    }

    public function getCertificateName(){
		return "Certificado_Digital_Elvis_Prasiler_senha_12345678.pfx";
    }

    public function getCertificatePassword(){
		return "12345678";
    }

    public function getCertificatePemFile(){
		return "/var/www/uploads/AGROMGA/certificados/00744544000168_certKEY.pem";
    }

    public function getEnvironment(){
		return 1;
    }

    public function getPrivateKey(){
		return "/var/www/uploads/AGROMGA/certificados/00744544000168_priKEY.pem";
    }

    public function getProxyIp(){
    }

    public function getProxyPass(){
    }

    public function getProxyPort(){
    }

    public function getProxyUser(){
    }

    public function getDebug(){
        return true;
    }
}

$minhaConfiguracao = new MySetup();

$config = new \Sped\Gnre\Sefaz\ConfigUf;

/**
 * Qual ambiente sera realizada a consulta
 */
$config->setEnvironment(1);
$config->setReceita(100102);
$config->setEstado('SC');

$webService = new Sped\Gnre\Webservice\Connection($minhaConfiguracao, $config->getHeaderSoap(), $config->toXml());

$consulta = $webService->doRequest($config->soapAction());
echo '<pre>';
echo htmlspecialchars($consulta);
