<?php

// namespace Exemplo;

require '../vendor/autoload.php';

class MySetup extends Sped\Gnre\Configuration\Setup{

    public function getBaseUrl(){
		return "http://dev.uds.com.br/julio/sped-gnre-master/";
    }

    public function getCertificateCnpj(){
		return "00744544000168";
    }

    public function getCertificateDirectory(){
		return "/var/www/uploads/AGROMGA/certificados/";
    }

    public function getCertificateName(){
		return "Certificado_Digital_Elvis_Prasiler_senha_12345678.pfx";
    }

    public function getCertificatePassword(){
		return "12345678";
    }

    public function getCertificatePemFile(){
		return "/var/www/uploads/AGROMGA/certificados/00744544000168_certKEY.pem";
    }

    public function getEnvironment(){
		return 1;
    }

    public function getPrivateKey(){
		return "/var/www/uploads/AGROMGA/certificados/00744544000168_priKEY.pem";
    }

    public function getProxyIp(){
    }

    public function getProxyPass(){
    }

    public function getProxyPort(){
    }

    public function getProxyUser(){
    }

    public function getDebug(){
        return false;
    }
}

$minhaConfiguracao = new MySetup();

$guia = new Sped\Gnre\Sefaz\Guia();

$consulta = new Sped\Gnre\Sefaz\Consulta();
$consulta->setRecibo(1802317543);

/**
 * O número que representa em qual ambiente sera realizada a consulta
 * 1 - produção 2 - homologação
 */
$consulta->setEnvironment(1);
//$consulta->utilizarAmbienteDeTeste(true);

//header('Content-Type: text/xml');
//print $consulta->toXml(); // exibe o XML da consulta

$webService = new Sped\Gnre\Webservice\Connection($minhaConfiguracao, $consulta->getHeaderSoap(), $consulta->toXml());
echo $webService->doRequest($consulta->soapAction());
