<?php

// namespace Exemplo;

require '../vendor/autoload.php';

class MySetup extends Sped\Gnre\Configuration\Setup{

    public function getBaseUrl(){
		return "http://dev.uds.com.br/julio/sped-gnre-master/";
    }

    public function getCertificateCnpj(){
		return "00744544000168";
    }

    public function getCertificateDirectory(){
		return "/var/www/uploads/AGROMGA/certificados/";
    }

    public function getCertificateName(){
		return "Certificado_Digital_Elvis_Prasiler_senha_12345678.pfx";
    }

    public function getCertificatePassword(){
		return "12345678";
    }

    public function getCertificatePemFile(){
		return "/var/www/uploads/AGROMGA/certificados/00744544000168_certKEY.pem";
    }

    public function getEnvironment(){
		return 1;
    }

    public function getPrivateKey(){
		return "/var/www/uploads/AGROMGA/certificados/00744544000168_priKEY.pem";
    }

    public function getProxyIp(){
    }

    public function getProxyPass(){
    }

    public function getProxyPort(){
    }

    public function getProxyUser(){
    }

    public function getDebug(){
        return false;
    }
}

$xml = simplexml_load_string (str_replace(":","",file_get_contents('estrutura-lote-completo-gnre.xml')));

$arr = (array) $xml->soap12Body->gnreDadosMsg->TLote_GNRE->guias->TDadosGNRE;

$minhaConfiguracao = new MySetup();

$guia = new Sped\Gnre\Sefaz\Guia();
foreach($arr as $k=>$a){
	if($k=="c03_idContribuinteEmitente" || $k=="c35_idContribuinteDestinatario") $a = $a->CNPJ;
	$guia->__set($k, $a);
}

$lote = new Sped\Gnre\Sefaz\Lote();
// $lote->utilizarAmbienteDeTeste(true);

$lote->addGuia($guia);

// print_r($lote);
// exit();


$webService = new Sped\Gnre\Webservice\Connection($minhaConfiguracao, $lote->getHeaderSoap(), $lote->toXml());
echo "<pre>";
print_r($webService->doRequest($lote->soapAction()));
