<?php

use Sped\Gnre\Parser\SefazRetorno;
use Dompdf\Dompdf;

if( isset($_REQUEST["not_codigo"]) && isset($_REQUEST["p"]) ){
	
	require '../vendor/autoload.php';
	include_once "../../../TParams.class.php";

	$datapacket = new TParams();
	$company = $datapacket->getCompany();
	$filtro = '{"cod":"700002","params":[
		{"name":"not_codigo","value":"'.$_REQUEST["not_codigo"].'","type":"string"},
		{"name":"db","value":"'.$datapacket->getDb().'","type":"other"}
	]}';
	$datapacket->setHost($datapacket->getHost($datapacket->getDbSge()));
	$datapacket->add($filtro);
	$retorno = $datapacket->open(true);
	$datapacket->clear();
	
	//calculo imposto uf dest
	$total=0;
	foreach($retorno as $r){
		if(isset($r->itn_icms) && $r->itn_icms>0){
			if(date("Y")=="2018"){
				$p = 0.8;
			}elseif(date("Y")>="2019"){
				$p = 1;
			}
			$icms = number_format(($r->itn_icms*$p), 2, '.', '');
			$total+=$icms;
		}
	}
	
	if($total>0){
		$total = number_format($total, 2, ".", "");
		//parametrização
		$guia = new Sped\Gnre\Sefaz\Guia();
		$guia->c01_UfFavorecida = $retorno[0]->end_uf;
		$guia->c02_receita = 100102;
		$guia->c25_detalhamentoReceita = '';
		$guia->c26_produto = '';
		$guia->c27_tipoIdentificacaoEmitente = 1;
		$guia->c03_idContribuinteEmitente = $company->emp_cpfcnpj;
		$guia->c28_tipoDocOrigem = 10;
		$guia->c04_docOrigem = $retorno[0]->not_numero;
		$guia->c06_valorPrincipal = $total;
		$guia->c10_valorTotal = $total;
		$guia->c14_dataVencimento = date("Y-m-d");
		// $guia->c15_convenio = 546456;
		$guia->c16_razaoSocialEmitente = $company->emp_razao;
		// $guia->c17_inscricaoEstadualEmitente = $company->emp_inscrg;
		$guia->c18_enderecoEmitente = $company->emp_endereco;
		$guia->c19_municipioEmitente = substr($company->emp_codmun,2);
		$guia->c20_ufEnderecoEmitente = $company->emp_uf;
		$guia->c21_cepEmitente = $company->emp_cep;
		$guia->c22_telefoneEmitente = $company->emp_fone;
		$guia->c34_tipoIdentificacaoDestinatario = ($retorno[0]->cad_pessoa-1);
		$guia->c35_idContribuinteDestinatario = $retorno[0]->cad_cnpjcpf;
		$guia->c36_inscricaoEstadualDestinatario = $retorno[0]->cad_inscrg;
		$guia->c37_razaoSocialDestinatario = $retorno[0]->cad_nomeraz;
		$guia->c38_municipioDestinatario = substr($retorno[0]->cad_codmun,2);
		$guia->c33_dataPagamento = date("Y-m-d");
		/*
		$guia->retornoInformacoesComplementares = '';
		$guia->retornoAtualizacaoMonetaria = 0.00;
		$guia->retornoNumeroDeControle = '';
		$guia->retornoCodigoDeBarras = '';
		$guia->retornoRepresentacaoNumerica = '';
		$guia->retornoJuros = 0.00;
		$guia->retornoMulta = 0.00;
		$guia->mes = date("m");
		$guia->ano = date("Y");
		$guia->parcela = 1;
		$guia->periodo = date("Y");
		*/
		//verificacao codigo do campo extra
		$cod="";
		switch($retorno[0]->end_uf){
			case 'AC':
				$cod=76;
				break;
			case 'AM':
				$cod=12;
				break;
			case 'AP':
				$cod=47;
				break;
			case 'BA':
				$cod=86;
				break;
			case 'MA':
				$cod=94;
				break;
			case 'MS':
				$cod=88;
				break;
			case 'MT':
				$cod=17;
				break;
			case 'PB':
				$cod=30;
				break;
			case 'SC':
				$cod=84;
				break;
		}
		
		if($cod!=""){
			$guia->c39_camposExtras = array(
				array(
					'campoExtra' => array(
						'codigo' =>$cod,
						'tipo' => 'T',
						'valor' => $retorno[0]->not_key_nfe
					)
				)
			);
		}

		$lote = new Sped\Gnre\Sefaz\Lote();
		$lote->addGuia($guia);
		
		//criar arquivo xml
		$dir = $datapacket->uploads.$company->emp_codigo."/gnre/";
		if(!is_dir($dir)){
			mkdir($dir, 0777, true);
		}
		$anomes = date("Ym");
		$dir.= $anomes;
		if(!is_dir($dir)){
			mkdir($dir, 0777, true);
		}
		$arquivo = $dir."/".$retorno[0]->not_key_nfe.".xml";
		$arq = fopen($arquivo, "w+");
		fwrite($arq, $lote->toXml());
		fclose($arq);
		chmod($arquivo, 0777);
		
		// print $lote->toXml();		
		class MySetup extends Sped\Gnre\Configuration\Setup{
			public $baseurl;
			public $cnpj;
			public $certdir;
			public $certificado;
			public $senha;
			public $pem;
			public $priv;
			
			public function getBaseUrl(){
				return $this->baseurl;
			}
			public function getCertificateCnpj(){
				return $this->cnpj;
			}
			public function getCertificateDirectory(){
				return $this->certdir;
			}
			public function getCertificateName(){
				return $this->certificado;
			}
			public function getCertificatePassword(){
				return $this->senha;
			}
			public function getCertificatePemFile(){
				return $this->pem;
			}
			public function getEnvironment(){
				return 1;
			}
			public function getPrivateKey(){
				return $this->priv;
			}
			public function getProxyIp(){
			}
			public function getProxyPass(){
			}
			public function getProxyPort(){
			}
			public function getProxyUser(){
			}
			public function getDebug(){
				return false;
			}
		}

		$xml = file_get_contents($arquivo);

		$minhaConfiguracao = new MySetup();
		
		$minhaConfiguracao->baseurl = $datapacket->HostClient."php/spedPHP/gnre/";
		$minhaConfiguracao->cnpj = $company->emp_cpfcnpj;
		$minhaConfiguracao->certdir = $datapacket->uploads.$company->emp_codigo."/certificados/";
		$minhaConfiguracao->certificado = $company->emp_certificado;
		$minhaConfiguracao->senha = $company->emp_pwd_cert;
		$minhaConfiguracao->pem = $datapacket->uploads.$company->emp_codigo."/certificados/".$company->emp_cpfcnpj."_certKEY.pem";
		$minhaConfiguracao->priv = $datapacket->uploads.$company->emp_codigo."/certificados/".$company->emp_cpfcnpj."_priKEY.pem";


		$webService = new Sped\Gnre\Webservice\Connection($minhaConfiguracao, $lote->getHeaderSoap(), $xml);
		//resultado assincrono
		$resultado = simplexml_load_string (str_replace(":","", $webService->doRequest($lote->soapAction())));
		$codigo = $resultado->soapenvBody->processarResponse->ns1TRetLote_GNRE->ns1situacaoRecepcao->ns1codigo;
		$descricao = $resultado->soapenvBody->processarResponse->ns1TRetLote_GNRE->ns1situacaoRecepcao->ns1descricao;
		$numero = $resultado->soapenvBody->processarResponse->ns1TRetLote_GNRE->ns1recibo->ns1numero;
		// echo $codigo."<br>";
		// echo $descricao."<br>";
		
		//nova requisição recibo
		$guia = new Sped\Gnre\Sefaz\Guia();
		$consulta = new Sped\Gnre\Sefaz\Consulta();
		$consulta->setRecibo($numero);
		$consulta->setEnvironment(1);
		$webService = new Sped\Gnre\Webservice\Connection($minhaConfiguracao, $consulta->getHeaderSoap(), $consulta->toXml());
		$resultado2 = simplexml_load_string (str_replace(":","", $webService->doRequest($consulta->soapAction())));
		$texto = $resultado2->soapenvBody->gnreRespostaMsg->ns1TResultLote_GNRE->ns1resultado;
		// echo $texto;
		// echo substr($texto, (strpos($texto, "20001")+5), (strpos($texto, "\n91"))-(strpos($texto, "20001"))-4);
		// echo "<pre>";
		$parser = new SefazRetorno($texto);
		$lote = $parser->getLote();
		print_r($lote);
		
		/*
		$html = new Sped\Gnre\Render\Html();
		$html->create($lote);
		$pdf = new Sped\Gnre\Render\Pdf();
		$pdf->create($html)->stream('gnre.pdf', array('Attachment' => 0));
		*/
	}

}else{
	exit("Falta parâmetro");
}
