<?php 
/**
* REGISTRO 0001: ABERTURA DO BLOCO 0
* Este registro deve ser gerado para abertura do bloco 0 e indica as informações previstas para este bloco.
* Nível hierárquico - 1
* Ocorrência – um por arquivo
* @version 1.0.0
* @author Gabriel Koshiba Brito <gabrielkoshiba@gmail.com>
* @copyright 2014, VMtech ltda. 
* @package spedPisCofins
* @subpackage bloco_0
*/
if(!defined('DS')) define('DS',DIRECTORY_SEPARATOR);
include_once(__DIR__.DS.'..'.DS.'Registro.php');
/**
*
*
*/
class Registro_0001 extends Registro{
	/**
	* versao
	*/
	const VERSION='1.0.0';
	
	/**
	* Texto fixo contendo “0001”.
	* @name REG
	* @size 4
	* @type string
	* @position 01
	* @required true	
	*/
	protected $reg='0001';
	
	/**
	* Indicador de movimento:
	*	0- Bloco com dados informados;
	*	1- Bloco sem dados informados.
	* @name $ind_mov
	* @size 1
	* @type numeric	
	* @position 02
	* @required true
	*/
	protected $ind_mov;

	
	/**
	* metodo responsavel pela construcao do obj do registro
	* @param mixed[] $items Array associativo com proriedade como indices e seus respectivos valores
	*/
	public function __construct($items=null){
		if(is_array($items)&&!empty($items)){
			foreach($items as $key=>$value){
				$this->_set($key,$value);
			}
			unset($items);
		}
	}
}
?>