<?php 
/**
* REGISTRO 0140: TABELA DE CADASTRO DE ESTABELECIMENTO
* Este registro tem por objetivo relacionar e informar os estabelecimentos da pessoa jurídica que auferiram receitas no
* período da escrituração, que realizaram operações com direito a créditos ou que sofreram retenções na fonte, no período da escrituração.
* Ocorrência - um (por arquivo)
* Observações:
* 	1. Registro de preenchimento obrigatório para o estabelecimento matriz da pessoa jurídica.
* 	2. Em relação aos demais estabelecimentos da pessoa jurídica, este registro deve ser preenchido apenas para os que tenham auferido receitas, sujeitas ou não à incidência de contribuição social, que tenha realizado operações geradoras de créditos ou que tenha sofrido retenções na fonte no período.
* 	3. Caso não tenha o estabelecimento incorrido em quaisquer das operações passíveis de registro nos Blocos A, C, D ou F no período da escrituração, ou referentes a operações extemporâneas passíveis de registro no Bloco 1, não precisa ser informado registro referente ao mesmo.
* 	4. Deve ser escriturado um registro “0140” para cada estabelecimento que se enquadre nas condições de obrigatoriedade acima referida.
* Nível hierárquico - 2
* Ocorrência – Vários (por arquivo)
* @version 1.0.0
* @author Gabriel Koshiba Brito <gabrielkoshiba@gmail.com>
* @copyright 2014, VMtech ltda. 
* @package spedPisCofins
* @subpackage bloco_0
*/
if(!defined('DS')) define('DS',DIRECTORY_SEPARATOR);
include_once(__DIR__.DS.'..'.DS.'Registro.php');
/**
*
*
*/
class Registro_0140 extends Registro{
	/**
	* versao
	*/
	const VERSION='1.0.0';
	
	/**
	* Texto fixo contendo 0140.
	* @name $reg
	* @size 4
	* @type string
	* @position 01
	* @required true	
	*/
	protected $reg='0140';
	
	/**
	* Código de identificação do estabelecimento
	* @name $cod_est
	* @size 60
	* @type string	
	* @position 02
	* @required false
	*/
	protected $cod_est;
	
	/**
	* Nome empresarial do estabelecimento
	* @name $nome
	* @size 100
	* @type string	
	* @position 03
	* @required true
	*/
	protected $nome;
	
	/**
	* Número de inscrição do estabelecimento no CNPJ.
	* @name $cnpj	
	* @size 14
	* @type numeric
	* @position 04
	* @required true
	*/
	protected $cnpj;

	/**
	* Sigla da unidade da federação do estabelecimento.
	* @name $uf
	* @size 2
	* @type string	
	* @position 05
	* @required true
	*/
	protected $uf;

	/**
	* Inscrição Estadual do estabelecimento, se contribuinte de ICMS.
	* @name $ie
	* @size 14
	* @type string
	* @position 06
	* @required false	
	*/
	protected $ie;

	/**
	* Código do município do domicílio fiscal do estabelecimento,conforme a tabela IBGE
	* @name $cod_mun
	* @size 7
	* @type numeric	
	* @position 07
	* @required true
	*/
	protected $cod_mun;

	/**
	* Inscrição Municipal do estabelecimento, se contribuinte do ISS.
	* @name $im
	* @size undefined
	* @type string	
	* @position 08
	* @required false
	*/
	protected $im;

	/**
	* Inscrição do estabelecimento na Suframa
	* @name $suframa
	* @size 9
	* @type string	
	* @position 09
	* @required false
	*/
	protected $suframa;
	
	/**
	* metodo responsavel pela construcao do obj do registro 0
	* @param mixed[] $items Array associativo com proriedade como indices e seus respectivos valores
	*/
	public function __construct($items=null){
		if(is_array($items)&&!empty($items)){
			foreach($items as $key=>$value){
				$this->_set($key,$value);
			}
			unset($items);
		}
	}
}
?>