<?php 
/**
* REGISTRO C010: IDENTIFICAÇÃO DO ESTABELECIMENTO
* Este registro tem o objetivo de identificar o estabelecimento da pessoa jurídica a que se referem as operações e
* documentos fiscais informados neste bloco. Só devem ser escriturados no Registro C010 os estabelecimentos que
* efetivamente tenham realizado aquisição, venda ou devolução de mercadorias, bens e produtos, mediante emissão de
* documento fiscal definido pela legislação do ICMS e do IPI, que devam ser escrituradas no Bloco C.
* O estabelecimento que não realizou operações passíveis de registro nesse bloco, no período da escrituração, não deve ser identificado no Registro C010.
* Para cada estabelecimento cadastrado em “C010”, deve ser informado nos registros de nível inferior (Registros Filho) as
* operações próprias de prestação ou de contratação de serviços, mediante emissão de documento fiscal, no mercado interno ou externo.
* Observações: Registro de preenchimento obrigatório, se IND_MOV igual a “0” no Registro C001
* Nível hierárquico - 2
* Ocorrência – vários por arquivo
* @version 1.0.0 
* @author Gabriel Koshiba Brito <gabrielkoshiba@gmail.com>
* @copyright 2014, VMtech ltda. 
* @package spedPisCofins
* @subpackage bloco_a
*/
if(!defined('DS')) define('DS',DIRECTORY_SEPARATOR);
include_once(__DIR__.DS.'..'.DS.'Registro.php');
/**
*
*
*/
class Registro_C010 extends Registro{
	/**
	* versao
	*/
	const VERSION='1.0.0';
	
	/**
	* Texto fixo contendo C010.
	* @name $reg
	* @size 4
	* @type string
	* @position 01
	* @required true	
	*/
	protected $reg='C010';
	
	/**
	* Número de inscrição do estabelecimento no CNPJ.
	* @name $cnpj
	* @size 14
	* @type numeric	
	* @position 02
	* @required true
	*/
	protected $cnpj;

	/**
	* Indicador da apuração das contribuições e créditos, na escrituração das operações por NF-e e ECF, no período:
	* 	1 – Apuração com base nos registros de consolidação das operações por NF-e (C180 e C190) e por ECF (C490);
	* 	2 – Apuração com base no registro individualizado de NF-e (C100 e C170) e de ECF (C400)
	* @name $ind_escri
	* @size 1
	* @type string	
	* @position 03
	* @required false
	*/
	protected $ind_escri;
	

	/**
	* metodo responsavel pela construcao do obj do registro 0
	* @param mixed[] $items Array associativo com proriedade como indices e seus respectivos valores
	*/
	public function __construct($items=null){
		if(is_array($items)&&!empty($items)){
			foreach($items as $key=>$value){
				$this->_set($key,$value);
			}
			unset($items);
		}
	}
}
?>