<?php 
/**
* REGISTRO C990: ENCERRAMENTO DO BLOCO C
* Este registro destina-se a identificar o encerramento do bloco C e informar a quantidade de linhas (registros) existentes no bloco.
* Observações: Registro obrigatório, se existir o Registro C001
* Nível hierárquico - 1
* Ocorrência – um por arquivo
* @version 1.0.0
* @author Gabriel Koshiba Brito <gabrielkoshiba@gmail.com>
* @copyright 2014, VMtech ltda. 
* @package spedPisCofins
* @subpackage bloco_a
*/
if(!defined('DS')) define('DS',DIRECTORY_SEPARATOR);
include_once(__DIR__.DS.'..'.DS.'Registro.php');
/**
*
*
*/
class Registro_C990 extends Registro{
	/**
	* versao
	*/
	const VERSION='1.0.0';
	
	/**
	* Texto fixo contendo C990.
	* @name REG
	* @size 4
	* @type string
	* @position 01
	* @required true	
	*/
	protected $reg='C990';

	/**
	* Quantidade total de linhas do Bloco C
	* @name $qtd_lin_c
	* @size undefined
	* @type numeric	
	* @position 02
	* @required true
	*/
	protected $qtd_lin_c;

	/**
	* metodo responsavel pela construcao do obj do registro 0
	* @param mixed[] $items Array associativo com proriedade como indices e seus respectivos valores
	*/
	public function __construct($items=null){
		if(is_array($items)&&!empty($items)){
			foreach($items as $key=>$value){
				$this->_set($key,$value)/
			}
			unset($items);
		}
	}
}
?>