<?php
	header('Content-Type: text/html; charset=utf-8');
	include '../php/datapacket.php';
	include '../php/TParams.class.php';
	include_once '../php/funcoes.php';	
	
	$datapacket = new Datapacket();
	$TParams = new TParams();
	
	if( isset($_REQUEST["email"]) && $_REQUEST["email"]!="" ){
		ob_start();
	}
	
	if( isset($_REQUEST["not_codigo"]) ){
		
		$filtro = '{"cod":"700513","params":[
			{"name":"db","value":"'.$TParams->getDb().'","type":"other"},
			{"name":"not_codigo","value":"'.$_REQUEST["not_codigo"].'","type":"string"}
		]}';

		$datapacket->setHost($TParams->getHost($TParams->getDbSge()));
		$datapacket->add($filtro);
		$ret = $datapacket->open();
		
		$company = $TParams->getCompany();
		
		if( isset($ret[0]) ){
			
?>
<!DOCTYPE HTML>
<html lang="pt-BR">
<head>
	<meta charset="UTF-8">
	<title>Carta de Correção (CC-e) da Nota Fiscal Nº <?php echo $ret[0]["not_numero"]?> Série <?php echo $ret[0]["ser_codigo"]?> - Fácil Online</title>
	<link rel="shortcut icon" href="../favicon.ico" type="image/x-icon">
	<style>
		*{
			margin:0;
			padding:0;
			font-family:Arial, Verdana, sans-serif;
			font-size:11px;
		}

		body{
			max-width:900px;
			margin:0 auto;
			width:100%;
		}
		table{
			border-collapse: collapse;
			width:100%;
		}
		table tr td{
			border: 1px solid #000;
			padding:4px;
		}
		span{
			font-size:13px;
			font-weight:bold;
		}
	</style>
</head>
<body>

		<?php
			$i=1;
			foreach($ret as $r){
				$descr = explode("'", base64_decode($r["log_outro"]));
				$descr = utf8_encode($descr[1]);
		?>
		
	<table id="header" cellspacing="0" cellpadding="0">
		<tr style="height:70px;">
			<td style="text-align: center;border-right:none;width:40%">
				IDENTIFICAÇÃO DO EMITENTE
				<?php 
					if(isset($company->{"emp_logo"})&&!empty($company->{"emp_logo"})){
						?>
							<img src="<?php echo "http://".$_SERVER["SERVER_NAME"]."/uploads/".$company->{"emp_codigo"}."/".$company->{"emp_logo"} ;?>" alt="" style="width:55%"><br>
						<?php
					}
				?>
				<span><?php echo $company->{"emp_razao"};?></span><br>
				<?php echo $company->{"emp_endereco"}.", ".$company->{"emp_num"}."<br>".$company->{"emp_bairro"};?><br>
				<?php echo $company->{"emp_cep"}." - ".$company->{"emp_cidade"}."/ ".$company->{"emp_uf"};?><br>
			</td>
			<td style="text-align: center;" colspan="4">
				<span style="font-size:21px;">Representação Gráfica de CC-e</span><br>
				<span style="">(Carta de Correção Eletrônica)</span><br><br>
				<span style="widht:100%;text-align:left;">Protocolo Nº: <?php echo $r["log_protocolo"];?> - Seq. <?php echo $i;?></span><br>
				<span>Registrado na SEFAZ em: <?php echo implode("/",array_reverse(explode("-", substr($r["log_data"],0,10))))?> às <?php echo substr($r["log_data"], 11);?></span>
			</td>
		</tr>
		<tr>
			<td colspan="2" style="border-bottom:none">
				De acordo com as determinações legais vigentes, viemos por meio desta comunicar-lhe, que a Nota Fiscal, abaixo referenciada, contém irregularidades que estão destacadas e suas respectivas correções, solicitamos que sejam aplicadas estas correções ao executar seus lançamentos fiscais.
			</td>
		</tr>
		<tr style="height:90px">
			<td style="border-right:none">
				<span>CNPJ do Destinatário: <?php echo maskCNPJCPF($r["cad_cnpjcpf"])?></span><br>
				<span>Nota Fiscal Nº: <?php echo $r["not_numero"]?> - Série: <?php echo $r["ser_codigo"]?></span>
			</td>
			<td style="border-left:none; text-align: center">
				<img src="<?php echo "http://".$_SERVER["SERVER_NAME"]."/desktop/rel/img-codbarras.php?cod=".$r["not_key_nfe"]; ?>" style="width:80%">
				<?php echo $r["not_key_nfe"];?>
			</td>
		</tr>
		<tr>
			<td colspan="2" style="border-bottom:none">
				A Carta de Correção é disciplinada pelo parágrafo 1º do art. 7º do Convênio S/N, de 15 de dezembro de 1970 e pode ser utilizada para regularização de erro ocorrido na emissão de documento fiscal, desde que o erro não esteja relacionado com: I - As variáveis que determinam o valor do imposto tais como: base de cálculo, alíquota, diferença de preço, quantidade, valor da operação ou da prestação; || - a correção de dados cadasrais que implique mudança do remetente ou do destinatário; III - a data de emissão ou de saída.
			</td>
		</tr>
		<tr>
			<td colspan="2">Correções a serem consideradas</td>
		</tr>
		<tr>
			<td colspan="2" style="height:95px;border-bottom:none" valign="top"><span style="font-size:15px"><?php echo $descr;?></span></td>
		</tr>
		<tr>
			<td colspan="2" style="border-top:none">Este documento é uma representação gráfica da CC-e e foi impresso apenas para sua informação e não possui validade fiscal. A CC-e deve ser recebida e mantida em arquivo eletrônico XML e pode ser consultada através dos portais das SEFAZ.</td>
		</tr>
	</table><br>
	
<?php
				$i++;
			}
			
			//envio por e-mail
				if( isset($_REQUEST["email"]) && $_REQUEST["email"]!="" ){

					if(!isset($logo)) $logo = "";
					if(!isset($data)) $data = "";
					if(!isset($titulo)) $titulo = "";
					if(!isset($relatorioTitle)) $relatorioTitle = "";
					if(!isset($filtros)) $filtros = "";
					if(!isset($colunas)) $colunas = "";
					if(!isset($cabecalhoHeight)) $cabecalhoHeight = "0"; // passar apenas numeros sem px, %..;
					$html = ob_get_clean();
					if(!is_dir($TParams->getHostRoot()."tmp/")){
						mkdir($TParams->getHostRoot()."tmp/", 0777, true);
					}
					$arquivo = str_replace(array(".",","), "", microtime(true));
					$fp = fopen($TParams->getHostRoot()."tmp/".$arquivo.'.html', 'w');
					fwrite($fp, $html);
					fclose($fp);

					exec($TParams->getHostRoot().'class/phantomjs/bin/phantomjs '.$TParams->getHostRoot().'class/phantomjs/rasterizeOs.js '.$TParams->getHostRoot().'tmp/'.$arquivo.'.html '.$TParams->getHostRoot().'tmp/'.$arquivo.'.pdf ["7,5in*5in"] "'.$relatorioTitle.'" "'.base64_encode($titulo).'" "'.$data.'" "'.base64_encode(json_encode($filtros)).'" "'.base64_encode(json_encode($colunas)).'" "'.base64_encode($logo).'" "'.$cabecalhoHeight.'"');
					
					if(file_exists($TParams->getHostRoot()."tmp/".$arquivo.'.pdf')){

						echo $TParams->getHostRoot()."tmp/".$arquivo.'.pdf';

					} else {
						echo "Ocorreu um erro ao gerar o arquivo.";
					}
					
				}
			
		}else{
			exit("Nâo há cartas de correção emitidas para esta Nota Fiscal!");
		}
		
	}elseif( isset($_REQUEST["cte_codigo"]) ){
		
		$filtro = '{"cod":"501126","params":[
			{"name":"cte_codigo","value":"'.$_REQUEST['cte_codigo'].'","type":"string"}
		]}';

		$datapacket->setHost($TParams->getHost($TParams->getDbSge()));
		$datapacket->add($filtro);
		$ret = $datapacket->open();
		
		$company = $TParams->getCompany();
		
		if( isset($ret[0]) ){
			$info = json_decode(base64_decode($ret[0]["cco_info"]));
			if(is_array($info)){
?>
		<!DOCTYPE HTML>
		<html lang="pt-BR">
		<head>
			<meta charset="UTF-8">
			<title>Carta de Correção (CC-e) da CT-e Nº <?php echo $ret[0]["cte_nct"]?> Série <?php echo $ret[0]["cte_serie"]?> - Fácil Online</title>
			<link rel="shortcut icon" href="../favicon.ico" type="image/x-icon">
			<style>
				*{
					margin:0;
					padding:0;
					font-family:Arial, Verdana, sans-serif;
					font-size:11px;
				}
				body{
					max-width:900px;
					margin:0 auto;
					width:100%;
				}
				table{
					border-collapse: collapse;
					width:100%;
				}
				table tr td{
					border: 1px solid #000;
					padding:4px;
				}
				span{
					font-size:16px;
					font-weight:bold;
					color:#b27235;
				}
			</style>
		</head>
		<body>
			<table>
				<tr>
					<td colspan="2" style="height:50px;text-align:center">
						<span>Carta de Correção</span>
					</td>
				</tr>
				<tr>
					<td>Autor do Evento (CNPJ/CPF)</td>
					<td>Chave de Acesso</td>
				</tr>
				<tr>
					<td><?php echo maskCNPJCPF($company->{"emp_cpfcnpj"});?></td>
					<td><?php echo $ret[0]["cte_key"];?></td>
				</tr>
				<tr>
					<td colspan="2">
						Data do Evento
					</td>
				</tr>
				<tr>
					<td colspan="2">
						<?php echo implode("/",array_reverse(explode("-",substr($ret[0]["cco_data"], 0, 10))))." ".substr($ret[0]["cco_data"], 11);?>
					</td>
				</tr>
				<tr>
					<td>Tipo do Evento)</td>
					<td>Sequencial do Evento</td>
				</tr>
				<tr>
					<td>110110</td>
					<td><?php echo $ret[0]["cco_numero"];?></td>
				</tr>
			</table><br>
			<span>Detalhe do Evento</span><br>
			<table>
				<tr>
					<td>
						Grupo Alterado
					</td>
					<td>
						Campo Alterado
					</td>
					<td>
						Nº Item
					</td>
					<td>
						Novo Valor
					</td>
				</tr>
				<?php foreach($info as $inf){ ?>
				<tr>
					<td>
						<?php echo $inf->{"grupoAlterado"};?>
					</td>
					<td>
						<?php echo $inf->{"campoAlterado"};?>
					</td>
					<td>
						<?php echo $inf->{"numeroItem"};?>
					</td>
					<td>
						<?php echo $inf->{"valorAlterado"};?>
					</td>
				</tr>
				<?php } ?>
			</table><br>
			<span>Informações da Carta de correção</span><br>
			<table>
				<tr>
					<td>Mensagem de Autorização</td>
					<td>Protocolo</td>
				</tr>
				<tr>
					<td><?php echo base64_decode($ret[0]["cco_xmotivo"]);?></td>
					<td><?php echo $ret[0]["cco_nprot"];?></td>
				</tr>
			</table><br>
			<span>Condições de uso da Carta de Correção</span><br>
			<table>
				<tr>
					<td>
						Carta de Correção é disciplinada pelo parágrafo 1º do art. 7º do Convênio S/N, de 15 de dezembro de 1970 e pode ser utilizada para regularização de erro ocorrido na emissão de documento fiscal, desde que o erro não esteja relacionado com: I - As variáveis que determinam o valor do imposto tais como: base de cálculo, alíquota, diferença de preço, quantidade, valor da operação ou da prestação; || - a correção de dados cadasrais que implique mudança do remetente ou do destinatário; III - a data de emissão ou de saída.
					</td>
				</tr>
			</table>
		</body>
		</html>
<?php
		
			}else{
				exit("Não há cartas de correção emitidas para esta CT-e.");
			}
		}else{
			exit("Não há cartas de correção emitidas para esta CT-e.");
		}
	}else{
		exit("Nâo há dados para serem impressos");
	}
?>