<?php
// Parâmetros da URL
$codigo = $_GET['codigo'] ?? '123456';
$tipo = strtolower($_GET['tipo'] ?? 'code128');
$dpi = intval($_GET['dpi'] ?? 92);

// Verifica se GD está habilitado
if (!function_exists('imagecreate')) {
    header("Content-Type: text/plain");
    die("Erro: GD não está habilitado no PHP.");
}

if ($tipo !== 'code128') {
    header("Content-Type: text/plain");
    die("Erro: Apenas 'code128' é suportado neste script.");
}

// Tabela básica de Code128 (subset B)
$code128 = [
    ' '=>'212222','!'=>'222122','"'=>'222221','#'=>'121223','$'=>'121322','%'=>'131222','&'=>'122213','\''=>'122312',
    '('=>'132212',')'=>'221213','*'=>'221312','+'=>'231212',','=>'112232','-'=>'122132','.'=>'122231','/'=>'113222',
    '0'=>'123122','1'=>'123221','2'=>'223211','3'=>'221132','4'=>'221231','5'=>'213212','6'=>'223112','7'=>'312131',
    '8'=>'311222','9'=>'321122',':'=>'321221',';'=>'312212','<'=>'322112','='=>'322211','>'=>'212123','?'=>'212321',
    '@'=>'232121','A'=>'111323','B'=>'131123','C'=>'131321','D'=>'112313','E'=>'132113','F'=>'132311','G'=>'211313',
    'H'=>'231113','I'=>'231311','J'=>'112133','K'=>'112331','L'=>'132131','M'=>'113123','N'=>'113321','O'=>'133121',
    'P'=>'313121','Q'=>'211331','R'=>'231131','S'=>'213113','T'=>'213311','U'=>'213131','V'=>'311123','W'=>'311321',
    'X'=>'331121','Y'=>'312113','Z'=>'312311','['=>'332111','\\'=>'314111',']'=>'221411','^'=>'431111','_'=>'111224',
    '`'=>'111422','a'=>'121124','b'=>'121421','c'=>'141122','d'=>'141221','e'=>'112214','f'=>'112412','g'=>'122114',
    'h'=>'122411','i'=>'142112','j'=>'142211','k'=>'241211','l'=>'221114','m'=>'413111','n'=>'241112','o'=>'134111',
    'p'=>'111242','q'=>'121142','r'=>'121241','s'=>'114212','t'=>'124112','u'=>'124211','v'=>'411212','w'=>'421112',
    'x'=>'421211','y'=>'212141','z'=>'214121','{'=>'412121','|'=>'111143','}'=>'111341','~'=>'131141','DEL'=>'114113',
    'START_B'=>'104','STOP'=>'2331112'
];

// Cálculo da sequência binária
function encodeCode128($str, $code128) {
    $startCode = 'START_B';
    $pattern = $code128[$startCode];
    $checksum = 104;
    for ($i = 0; $i < strlen($str); $i++) {
        $char = $str[$i];
        if (!isset($code128[$char])) continue;
        $value = array_search($code128[$char], $code128);
        $checksum += (ord($char) - 32) * ($i + 1);
        $pattern .= $code128[$char];
    }
    $checksum = $checksum % 103;
    $checksumChar = array_keys($code128)[array_values($code128)[$checksum]];
    $pattern .= $code128[$checksumChar] ?? '';
    $pattern .= $code128['STOP'];
    return $pattern;
}

$bin = encodeCode128($codigo, $code128);

// Tamanho de cada "módulo"
$scale = intval($dpi / 30); // Escala proporcional ao DPI
if ($scale < 1) $scale = 1;

// Criar imagem
$width = strlen($bin) * $scale;
$height = 60;
$image = imagecreate($width, $height);
$white = imagecolorallocate($image, 255,255,255);
$black = imagecolorallocate($image, 0,0,0);

// Desenha o código de barras
$x = 0;
for ($i = 0; $i < strlen($bin); $i++) {
    $color = ($i % 2 == 0) ? $black : $white;
    $barWidth = intval($bin[$i]) * $scale;
    imagefilledrectangle($image, $x, 0, $x + $barWidth - 1, $height, $color);
    $x += $barWidth;
}

// Cabeçalho da imagem
header("Content-Type: image/png");
imagepng($image);
imagedestroy($image);
