<?php
	header('Content-Type: text/html; charset=utf-8');
	include '../php/datapacket.php';
	include '../php/TParams.class.php';
	include '../php/funcoes.php';
	
	$datapacket = new Datapacket();
	$datapacket->debug(true);
	$TParams = new TParams();
	$company = $TParams->getCompany();
	$env="";
	
	
	if(isset($_REQUEST['not_codigo']) && !empty($_REQUEST['not_codigo'])){

		$not_codigo = json_decode(base64_decode($_REQUEST['not_codigo']));
		$not_codigo = implode(",", $not_codigo);
		
		$filtro = '{"cod":"500494","params":[
			{"name":"not_codigo","value":"'.$not_codigo.'","type":"other"},
			{"name":"db","value":"'.$TParams->getDb().'","type":"other"}
		]}';
		$datapacket->setHost($TParams->getHost($TParams->getDbSge()));
		$datapacket->add($filtro);
		$destinatarios = $datapacket->open(true);
		$datapacket->clear();

		?>

			<html>
				<head>

					<title> DANFE Simplificado - Etiqueta </title>
					<meta charset="UTF-8">

					<style type="text/css">

						body {
						    -webkit-print-color-adjust: exact;
							margin:0;
							padding:0;
							font-family: Arial, sans-serif;
						}
						
						.quadro{
							font-size:14px;
							border: 1px solid #000;
							width: 55%;
							padding: 10px 0px 10px 5px;
							line-height:20px;
							margin:10px auto;
						}

						.border-div {
							width:380px;
							height:480px;
							float:left;
							padding-left:2px;
							margin-right:1px;
							box-shadow:inset 0px 0px 0px 1px #000;
							-moz-box-shadow:inset 0px 0px 0px 1px #000;
							-webkit-box-shadow:inset 0px 0px 0px 1px #000;
						}
						
						.chave{
							font-size:14px;
							text-align:center;
						}
						
						.chave span{
							font-size:16px;
							font-weight:bold;
						}
						
						.rem{
							margin:10px 5px 50px 5px;
							font-size:14px;
							border-top: 1px solid #000;
							padding:10px 0px;
						}

					</style>

				</head>

				<body>

					<?php

							$indice = 1;
							$marginBottom = '5px';
							foreach($destinatarios as $dest){

								if($indice%6==0) {
									$marginBottom = '12px';
								} else {
									$marginBottom = '5px';
								}

								?>
									<div class="border-div" style="margin-bottom:<?php echo $marginBottom;?>">
											
										<div class="quadro">

											<div style="font-weight:bold">1 - Saída</div>
											<span style="font-weight:bold">Número: </span><?php echo $dest->not_numero?>/ Série <?php echo $dest->ser_codigo?><br>
											<span style="font-weight:bold">Emissão: </span><?php echo implode("/", array_reverse(explode("-",substr($dest->not_data,0,10))))?>

										</div>
										
										<div class="chave">
											<span>Chave de Acesso</span><br>
											<?php echo $dest->not_key_nfe?><br>
											<span>Protocolo de Autorização</span><br>
											<?php echo $dest->not_nprot?> <?php echo implode("/", array_reverse(explode("-",substr($dest->not_data,0,10))))?><?php echo substr($dest->not_dtfaturam,10)?><br>
											<img src="img-codbarras.php?cod=<?php echo $dest->{'not_key_nfe'}; ?>" style="position:relative; width:99%;margin-top:5px;">
										</div>
										
										<div class="rem">
											<b>EMITENTE: <?php echo ($company->{'emp_titulo'} && $company->{'emp_titulo'}==1) ? substr($company->{'emp_razao'},0,30) : substr($company->{'emp_fantasia'},0,30); ?></b><br>
											<b>CNPJ:</b> <?php echo maskCNPJCPF($company->{'emp_cpfcnpj'}); ?><b style="margin-left:8px">IE:</b> <?php echo $company->{'emp_inscrg'}; ?><b style="margin-left:8px">UF:</b> <?php echo $company->{'emp_uf'}; ?><br><br>
											
											<b>DESTINATÁRIO: <?php if(!empty($dest->{'cad_nomeraz'})) echo substr($dest->{'cad_nomeraz'},0,28); ?></b><br>
											<b><?php echo (strlen($dest->{'cad_cnpjcpf'})==14) ? "CNPJ" : "CPF";?>:</b> <?php echo maskCNPJCPF($dest->{'cad_cnpjcpf'}); ?><b style="margin-left:8px"><?php echo (strlen($dest->{'cad_cnpjcpf'})==14) ? "IE" : "RG";?>:</b> <?php echo $dest->{'cad_inscrg'}; ?><b style="margin-left:8px">UF:</b> <?php echo $dest->{'end_uf'}; ?><br><br>
											
											<br><br><b>DANFE SIMPLIFICADO - ETIQUETA</b>

										</div>
										<!--<b style="margin-left:5px;">VALOR TOTAL NF-E:</b> R$ <?php //echo number_format($dest->{'not_totalnota'},2,",","."); ?>-->
										
									</div>		
								
								<?php
								$indice++;
							}

						
				
					?>

				</body>
			
			</html>

		<?php

	} else {

		echo "Selecione um pedido na grid antes de imprimir etiqueta!";

	}



?>